use petgraph::graph::UnGraph;

type Graph = petgraph::Graph<String, f32, petgraph::Undirected>;

fn mk_graph(nodes: &[&str], edges: &[(u32, u32, f32)]) -> Graph {
    let mut graph = UnGraph::<String, f32>::new_undirected();
    for node in nodes {
        graph.add_node(node.to_string());
    }
    graph.extend_with_edges(edges);
    graph
}

pub fn mk_sample1() -> Graph {
    mk_graph(&["A","B","C","D","E","F","G"],
        &[(0,1,3.0),(0,3,5.0),(0,4,3.0),(0,6,3.0),(1,0,3.0),(1,2,3.0),(2,1,3.0),(2,3,1.0),(3,0,5.0),(3,2,1.0),(4,0,3.0),(4,5,5.0),(5,4,5.0),(6,0,3.0)])
}
pub fn mk_sample2() -> Graph {
    mk_graph(&["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","AA","AB","AC","AD","AE","AF","AG","AH","AI","AJ","AK"],
        &[(0,1,3.0),(0,2,3.0),(0,3,5.0),(0,4,3.0),(1,0,3.0),(1,5,3.0),(1,6,2.0),(1,7,3.0),(2,0,3.0),(2,8,2.0),(2,9,5.0),(2,10,4.0),(3,0,5.0),(3,5,1.0),(3,11,2.0),(3,12,1.0),(3,13,1.0),(4,0,3.0),(4,14,2.0),(4,15,2.0),(4,16,3.0),(4,17,3.0),(5,1,3.0),(5,3,1.0),(6,1,2.0),(6,19,1.0),(6,32,2.0),(6,33,1.0),(6,34,5.0),(7,1,3.0),(7,27,1.0),(7,28,3.0),(8,2,2.0),(8,35,4.0),(8,36,4.0),(9,2,5.0),(10,2,4.0),(10,18,3.0),(10,20,1.0),(10,21,3.0),(10,23,2.0),(11,3,2.0),(11,31,1.0),(12,3,1.0),(13,3,1.0),(13,29,3.0),(13,30,2.0),(13,31,1.0),(14,4,2.0),(14,26,1.0),(15,4,2.0),(16,4,3.0),(16,20,6.0),(16,25,4.0),(17,4,3.0),(18,10,3.0),(19,6,1.0),(20,10,1.0),(20,16,6.0),(20,22,3.0),(20,24,2.0),(21,10,3.0),(22,20,3.0),(23,10,2.0),(24,20,2.0),(25,16,4.0),(26,14,1.0),(27,7,1.0),(28,7,3.0),(28,33,1.0),(29,13,3.0),(30,13,2.0),(31,11,1.0),(31,13,1.0),(32,6,2.0),(33,6,1.0),(33,28,1.0),(34,6,5.0),(35,8,4.0),(36,8,4.0)])
}
pub fn mk_large() -> Graph {
    mk_graph(&["0","1","2","3","4","5","6","7","8","9","10","11","12","13","14","15","16","17","18","19","20","21","22","23","24","25","26","27","28","29","30","31","32","33","34","35","36","37","38","39","40","41","42","43","44","45","46","47","48","49","50","51","52","53","54","55","56","57","58","59","60","61","62","63","64","65","66","67","68","69","70","71","72","73","74","75","76","77","78","79","80","81","82","83","84","85","86","87","88","89","90","91","92","93","94","95","96","97","98","99","100","101","102","103","104","105","106","107","108","109","110","111","112","113","114","115","116","117","118","119","120","121","122","123","124","125","126","127","128","129","130","131","132","133","134","135","136","137","138","139","140","141","142","143","144","145","146","147","148","149","150","151","152","153","154","155","156","157","158","159","160","161","162","163","164","165","166","167","168","169","170","171","172","173","174","175","176","177","178","179","180","181","182","183","184","185","186","187","188","189","190","191","192","193","194","195","196","197","198","199","200","201","202","203","204","205","206","207","208","209","210","211","212","213","214","215","216","217","218","219","220","221","222","223","224","225","226","227","228","229","230","231","232","233","234","235","236","237","238","239","240","241","242","243","244","245","246","247","248","249","250","251","252","253","254","255","256","257","258","259","260","261","262","263","264","265","266","267","268","269","270","271","272","273","274","275","276","277","278","279","280","281","282","283","284","285","286","287","288","289","290","291","292","293","294","295","296","297","298","299","300","301","302","303","304","305","306","307","308","309","310","311","312","313","314","315","316","317","318","319","320","321","322","323","324","325","326","327","328","329","330","331","332","333","334","335","336","337","338","339","340","341","342","343","344","345","346","347","348","349","350","351","352","353","354","355","356","357","358","359","360","361","362","363","364","365","366","367","368","369","370","371","372","373","374","375","376","377","378","379","380","381","382","383","384","385","386","387","388","389","390","391","392","393","394","395","396","397","398","399","400","401","402","403","404","405","406","407","408","409","410","411","412","413","414","415","416","417","418","419","420","421","422","423","424","425","426","427","428","429","430","431","432","433","434","435","436","437","438","439","440","441","442","443","444","445","446","447","448","449","450","451","452","453","454","455","456","457","458","459","460","461","462","463","464","465","466","467","468","469","470","471","472","473","474","475","476","477","478","479","480","481","482","483","484","485","486","487","488","489","490","491","492","493","494","495","496","497","498","499","500","501","502","503","504","505","506","507","508","509","510","511","512","513","514","515","516","517","518","519","520","521","522","523","524","525","526","527","528","529","530","531","532","533","534","535","536","537","538","539","540","541","542","543","544","545","546","547","548","549","550","551","552","553","554","555","556","557","558","559","560","561","562","563","564","565","566","567","568","569","570","571","572","573","574","575","576","577","578","579","580","581","582","583","584","585","586","587","588","589","590","591","592","593","594","595","596","597","598","599","600","601","602","603","604","605","606","607","608","609","610","611","612","613","614","615","616","617","618","619","620","621","622","623","624","625","626","627","628","629","630","631","632","633","634","635","636","637","638","639","640","641","642","643","644","645","646","647","648","649","650","651","652","653","654","655","656","657","658","659","660","661","662","663","664","665","666","667","668","669","670","671","672","673","674","675","676","677","678","679","680","681","682","683","684","685","686","687","688","689","690","691","692","693","694","695","696","697","698","699","700","701","702","703","704","705","706","707","708","709","710","711","712","713","714","715","716","717","718","719","720","721","722","723","724","725","726","727","728","729","730","731","732","733","734","735","736","737","738","739","740","741","742","743","744","745","746","747","748","749","750","751","752","753","754","755","756","757","758","759","760","761","762","763","764","765","766","767","768","769","770","771","772","773","774","775","776","777","778","779","780","781","782","783","784","785","786","787","788","789","790","791","792","793","794","795","796","797","798","799","800","801","802","803","804","805","806","807","808","809","810","811","812","813","814","815","816","817","818","819","820","821","822","823","824","825","826","827","828","829","830","831","832","833","834","835","836","837","838","839","840","841","842","843","844","845","846","847","848","849","850","851","852","853","854","855","856","857","858","859","860","861","862","863","864","865","866","867","868","869","870","871","872","873","874","875","876","877","878","879","880","881","882","883","884","885","886","887","888","889","890","891","892","893","894","895","896","897","898","899","900","901","902","903","904","905","906","907","908","909","910","911","912","913","914","915","916","917","918","919","920","921","922","923","924","925","926","927","928","929","930","931","932","933","934","935","936","937","938","939","940","941","942","943","944","945","946","947","948","949","950","951","952","953","954","955","956","957","958","959","960","961","962","963","964","965","966","967","968","969","970","971","972","973","974","975","976","977","978","979","980","981","982","983","984","985","986","987","988","989","990","991","992","993","994","995","996","997","998","999","1000","1001","1002","1003","1004","1005","1006","1007","1008","1009","1010","1011","1012","1013","1014","1015","1016","1017","1018","1019","1020","1021","1022","1023","1024","1025","1026","1027","1028","1029","1030","1031","1032","1033","1034","1035","1036","1037","1038","1039","1040","1041","1042","1043","1044","1045","1046","1047","1048","1049","1050","1051","1052","1053","1054","1055","1056","1057","1058","1059","1060","1061","1062","1063","1064","1065","1066","1067","1068","1069","1070","1071","1072","1073","1074","1075","1076","1077","1078","1079","1080","1081","1082","1083","1084","1085","1086","1087","1088","1089","1090","1091","1092","1093","1094","1095","1096","1097","1098","1099","1100","1101","1102","1103","1104","1105","1106","1107","1108","1109","1110","1111","1112","1113","1114","1115","1116","1117","1118","1119","1120","1121","1122","1123","1124","1125","1126","1127","1128","1129","1130","1131","1132","1133","1134","1135","1136","1137","1138","1139","1140","1141","1142","1143","1144","1145","1146","1147","1148","1149","1150","1151","1152","1153","1154","1155","1156","1157","1158","1159","1160","1161","1162","1163","1164","1165","1166","1167","1168","1169","1170","1171","1172","1173","1174","1175","1176","1177","1178","1179","1180","1181","1182","1183","1184","1185","1186","1187","1188","1189","1190","1191","1192","1193","1194","1195","1196","1197","1198","1199","1200","1201","1202","1203","1204","1205","1206","1207","1208","1209","1210","1211","1212","1213","1214","1215","1216","1217","1218","1219","1220","1221","1222","1223","1224","1225","1226","1227","1228","1229","1230","1231","1232","1233","1234","1235","1236","1237","1238","1239","1240","1241","1242","1243","1244","1245","1246","1247","1248","1249","1250","1251","1252","1253","1254","1255","1256","1257","1258","1259","1260","1261","1262","1263","1264","1265","1266","1267","1268","1269","1270","1271","1272","1273","1274","1275","1276","1277","1278","1279","1280","1281","1282","1283","1284","1285","1286","1287","1288","1289","1290","1291","1292","1293","1294","1295","1296","1297","1298","1299","1300","1301","1302","1303","1304","1305","1306","1307","1308","1309","1310","1311","1312","1313","1314","1315","1316","1317","1318","1319","1320","1321","1322","1323","1324","1325","1326","1327","1328","1329","1330","1331","1332","1333","1334","1335","1336","1337","1338","1339","1340","1341","1342","1343","1344","1345","1346","1347","1348","1349","1350","1351","1352","1353","1354","1355","1356","1357","1358","1359","1360","1361","1362","1363","1364","1365","1366","1367","1368","1369","1370","1371","1372","1373","1374","1375","1376","1377","1378","1379","1380","1381","1382","1383","1384","1385","1386","1387","1388","1389","1390","1391","1392","1393","1394","1395","1396","1397","1398","1399","1400","1401","1402","1403","1404","1405","1406","1407","1408","1409","1410","1411","1412","1413","1414","1415","1416","1417","1418","1419","1420","1421","1422","1423","1424","1425","1426","1427","1428","1429","1430","1431","1432","1433","1434","1435","1436","1437","1438","1439","1440","1441","1442","1443","1444","1445","1446","1447","1448","1449","1450","1451","1452","1453","1454","1455","1456","1457","1458","1459","1460","1461","1462","1463","1464","1465","1466","1467","1468","1469","1470","1471","1472","1473","1474","1475","1476","1477","1478","1479","1480","1481","1482","1483","1484","1485","1486","1487","1488","1489","1490","1491","1492","1493","1494","1495","1496","1497","1498","1499","1500","1501","1502","1503","1504","1505","1506","1507","1508","1509","1510","1511","1512","1513","1514","1515","1516","1517","1518","1519","1520","1521","1522","1523","1524","1525","1526","1527","1528","1529","1530","1531","1532","1533","1534","1535","1536","1537","1538","1539","1540","1541","1542","1543","1544","1545","1546","1547","1548","1549","1550","1551","1552","1553","1554","1555","1556","1557","1558","1559","1560","1561","1562","1563","1564","1565","1566","1567","1568","1569","1570","1571","1572","1573","1574","1575","1576","1577","1578","1579","1580","1581","1582","1583","1584","1585","1586","1587","1588","1589","1590","1591","1592","1593","1594","1595","1596","1597","1598","1599","1600","1601","1602","1603","1604","1605","1606","1607","1608","1609","1610","1611","1612","1613","1614","1615","1616","1617","1618","1619","1620","1621","1622","1623","1624","1625","1626","1627","1628","1629","1630","1631","1632","1633","1634","1635","1636","1637","1638","1639","1640","1641","1642","1643","1644","1645","1646","1647","1648","1649","1650","1651","1652","1653","1654","1655","1656","1657","1658","1659","1660","1661","1662","1663","1664","1665","1666","1667","1668","1669","1670","1671","1672","1673","1674","1675","1676","1677","1678","1679","1680","1681","1682","1683","1684","1685","1686","1687","1688","1689","1690","1691","1692","1693","1694","1695","1696","1697","1698","1699","1700","1701","1702","1703","1704","1705","1706","1707","1708","1709","1710","1711","1712","1713","1714","1715","1716","1717","1718","1719","1720","1721","1722","1723","1724","1725","1726","1727","1728","1729","1730","1731","1732","1733","1734","1735","1736","1737","1738","1739","1740","1741","1742","1743","1744","1745","1746","1747","1748","1749","1750","1751","1752","1753","1754","1755","1756","1757","1758","1759","1760","1761","1762","1763","1764","1765","1766","1767","1768","1769","1770","1771","1772","1773","1774","1775","1776","1777","1778","1779","1780","1781","1782","1783","1784","1785","1786","1787","1788","1789","1790","1791","1792","1793","1794","1795","1796","1797","1798","1799","1800","1801","1802","1803","1804","1805","1806","1807","1808","1809","1810","1811","1812","1813","1814","1815","1816","1817","1818","1819","1820","1821","1822","1823","1824","1825","1826","1827","1828","1829","1830","1831","1832","1833","1834","1835","1836","1837","1838","1839","1840","1841","1842","1843","1844","1845","1846","1847","1848","1849","1850","1851","1852","1853","1854","1855","1856","1857","1858","1859","1860","1861","1862","1863","1864","1865","1866","1867","1868","1869","1870","1871","1872","1873","1874","1875","1876","1877","1878","1879","1880","1881","1882","1883","1884","1885","1886","1887","1888","1889","1890","1891","1892","1893","1894","1895","1896","1897","1898","1899","1900","1901","1902","1903","1904","1905","1906","1907","1908","1909","1910","1911","1912","1913","1914","1915","1916","1917","1918","1919","1920","1921","1922","1923","1924","1925","1926","1927","1928","1929","1930","1931","1932","1933","1934","1935","1936","1937","1938","1939","1940","1941","1942","1943","1944","1945","1946","1947","1948","1949","1950","1951","1952","1953","1954","1955","1956","1957","1958","1959","1960","1961","1962","1963","1964","1965","1966","1967","1968","1969","1970","1971","1972","1973","1974","1975","1976","1977","1978","1979","1980","1981","1982","1983","1984","1985","1986","1987","1988","1989","1990","1991","1992","1993","1994","1995","1996","1997","1998","1999","2000","2001","2002","2003","2004","2005","2006","2007","2008","2009","2010","2011","2012","2013","2014","2015","2016","2017","2018","2019","2020","2021","2022","2023","2024","2025","2026","2027","2028","2029","2030","2031","2032","2033","2034","2035","2036","2037","2038","2039","2040","2041","2042","2043","2044","2045","2046","2047","2048","2049","2050","2051","2052","2053","2054","2055","2056","2057","2058","2059","2060","2061","2062","2063","2064","2065","2066","2067","2068","2069","2070","2071","2072","2073","2074","2075","2076","2077","2078","2079","2080","2081","2082","2083","2084","2085","2086","2087","2088","2089","2090","2091","2092","2093","2094","2095","2096","2097","2098","2099","2100","2101","2102","2103","2104","2105","2106","2107","2108","2109","2110","2111","2112","2113","2114","2115","2116","2117","2118","2119","2120","2121","2122","2123","2124","2125","2126","2127","2128","2129","2130","2131","2132","2133","2134","2135","2136","2137","2138","2139","2140","2141","2142","2143","2144","2145","2146","2147","2148","2149","2150","2151","2152","2153","2154","2155","2156","2157","2158","2159","2160","2161","2162","2163","2164","2165","2166","2167","2168","2169","2170","2171","2172","2173","2174","2175","2176","2177","2178","2179","2180","2181","2182","2183","2184","2185","2186","2187","2188","2189","2190","2191","2192","2193","2194","2195","2196","2197","2198","2199","2200","2201","2202","2203","2204","2205","2206","2207","2208","2209","2210","2211","2212","2213","2214","2215","2216","2217","2218","2219","2220","2221","2222","2223","2224","2225","2226","2227","2228","2229","2230","2231","2232","2233","2234","2235","2236","2237","2238","2239","2240","2241","2242","2243","2244","2245","2246","2247","2248","2249","2250","2251","2252","2253","2254","2255","2256","2257","2258","2259","2260","2261","2262","2263","2264","2265","2266","2267","2268","2269","2270","2271","2272","2273","2274","2275","2276","2277","2278","2279","2280","2281","2282","2283","2284","2285","2286","2287","2288","2289","2290","2291","2292","2293","2294","2295","2296","2297","2298","2299","2300","2301","2302","2303","2304","2305","2306","2307","2308","2309","2310","2311","2312","2313","2314","2315","2316","2317","2318","2319","2320","2321","2322","2323","2324","2325","2326","2327","2328","2329","2330","2331","2332","2333","2334","2335","2336","2337","2338","2339","2340","2341","2342","2343","2344","2345","2346","2347","2348","2349","2350","2351","2352","2353","2354","2355","2356","2357","2358","2359","2360","2361","2362","2363","2364","2365","2366","2367","2368","2369","2370","2371","2372","2373","2374","2375","2376","2377","2378","2379","2380","2381","2382","2383","2384","2385","2386","2387","2388","2389","2390","2391","2392","2393","2394","2395","2396","2397","2398","2399","2400","2401","2402","2403","2404","2405","2406","2407","2408","2409","2410","2411","2412","2413","2414","2415","2416","2417","2418","2419","2420","2421","2422","2423","2424","2425","2426","2427","2428","2429","2430","2431","2432","2433","2434","2435","2436","2437","2438","2439","2440","2441","2442","2443","2444","2445","2446","2447","2448","2449","2450","2451","2452","2453","2454","2455","2456","2457","2458","2459","2460","2461","2462","2463","2464","2465","2466","2467","2468","2469","2470","2471","2472","2473","2474","2475","2476","2477","2478","2479","2480","2481","2482","2483","2484","2485","2486","2487","2488","2489","2490","2491","2492","2493","2494","2495","2496","2497","2498","2499","2500","2501","2502","2503","2504","2505","2506","2507","2508","2509","2510","2511","2512","2513","2514","2515","2516","2517","2518","2519","2520","2521","2522","2523","2524","2525","2526","2527","2528","2529","2530","2531","2532","2533","2534","2535","2536","2537","2538","2539","2540","2541","2542","2543","2544","2545","2546","2547","2548","2549","2550","2551","2552","2553","2554","2555","2556","2557","2558","2559","2560","2561","2562","2563","2564","2565","2566","2567","2568","2569","2570","2571","2572","2573","2574","2575","2576","2577","2578","2579","2580","2581","2582","2583","2584","2585","2586","2587","2588","2589","2590","2591","2592","2593","2594","2595","2596","2597","2598","2599","2600","2601","2602","2603","2604","2605","2606","2607","2608","2609","2610","2611","2612","2613","2614","2615","2616","2617","2618","2619","2620","2621","2622","2623","2624","2625","2626","2627","2628","2629","2630","2631","2632","2633","2634","2635","2636","2637","2638","2639","2640","2641","2642","2643","2644","2645","2646","2647","2648","2649","2650","2651","2652","2653","2654","2655","2656","2657","2658","2659","2660","2661","2662","2663","2664","2665","2666","2667","2668","2669","2670","2671","2672","2673","2674","2675","2676","2677","2678","2679","2680","2681","2682","2683","2684","2685","2686","2687","2688","2689","2690","2691","2692","2693","2694","2695","2696","2697","2698","2699","2700","2701","2702","2703","2704","2705","2706","2707","2708","2709","2710","2711","2712","2713","2714","2715","2716","2717","2718","2719","2720","2721","2722","2723","2724","2725","2726","2727","2728","2729","2730","2731","2732","2733","2734","2735","2736","2737","2738","2739","2740","2741","2742","2743","2744","2745","2746","2747","2748","2749","2750","2751","2752","2753","2754","2755","2756","2757","2758","2759","2760","2761","2762","2763","2764","2765","2766","2767","2768","2769","2770","2771","2772","2773","2774","2775","2776","2777","2778","2779","2780","2781","2782","2783","2784","2785","2786","2787","2788","2789","2790","2791","2792","2793","2794","2795","2796","2797","2798","2799","2800","2801","2802","2803","2804","2805","2806","2807","2808","2809","2810","2811","2812","2813","2814","2815","2816","2817","2818","2819","2820","2821","2822","2823","2824","2825","2826","2827","2828","2829","2830","2831","2832","2833","2834","2835","2836","2837","2838","2839","2840","2841","2842","2843","2844","2845","2846","2847","2848","2849","2850","2851","2852","2853","2854","2855","2856","2857","2858","2859","2860","2861","2862","2863","2864","2865","2866","2867","2868","2869","2870","2871","2872","2873","2874","2875","2876","2877","2878","2879","2880","2881","2882","2883","2884","2885","2886","2887","2888","2889","2890","2891","2892","2893","2894","2895","2896","2897","2898","2899","2900","2901","2902","2903","2904","2905","2906","2907","2908","2909","2910","2911","2912","2913","2914","2915","2916","2917","2918","2919","2920","2921","2922","2923","2924","2925","2926","2927","2928","2929","2930","2931","2932","2933","2934","2935","2936","2937","2938","2939","2940","2941","2942","2943","2944","2945","2946","2947","2948","2949","2950","2951","2952","2953","2954","2955","2956","2957","2958","2959","2960","2961","2962","2963","2964","2965","2966","2967","2968","2969","2970","2971","2972","2973","2974","2975","2976","2977","2978","2979","2980","2981","2982","2983","2984","2985","2986","2987","2988","2989","2990","2991","2992","2993","2994","2995","2996","2997","2998","2999","3000","3001","3002","3003","3004","3005","3006","3007","3008","3009","3010","3011","3012","3013","3014","3015","3016","3017","3018","3019","3020","3021","3022","3023","3024","3025","3026","3027","3028","3029","3030","3031","3032","3033","3034","3035","3036","3037","3038","3039","3040","3041","3042","3043","3044","3045","3046","3047","3048","3049","3050","3051","3052","3053","3054","3055","3056","3057","3058","3059","3060","3061","3062","3063","3064","3065","3066","3067","3068","3069","3070","3071","3072","3073","3074","3075","3076","3077","3078","3079","3080","3081","3082","3083","3084","3085","3086","3087","3088","3089","3090","3091","3092","3093","3094","3095","3096","3097","3098","3099","3100","3101","3102","3103","3104","3105","3106","3107","3108","3109","3110","3111","3112","3113","3114","3115","3116","3117","3118","3119","3120","3121","3122","3123","3124","3125","3126","3127","3128","3129","3130","3131","3132","3133","3134","3135","3136","3137","3138","3139","3140","3141","3142","3143","3144","3145","3146","3147","3148","3149","3150","3151","3152","3153","3154","3155","3156","3157","3158","3159","3160","3161","3162","3163","3164","3165","3166","3167","3168","3169","3170","3171","3172","3173","3174","3175","3176","3177","3178","3179","3180","3181","3182","3183","3184","3185","3186","3187","3188","3189","3190","3191","3192","3193","3194","3195","3196","3197","3198","3199","3200","3201","3202","3203","3204","3205","3206","3207","3208","3209","3210","3211","3212","3213","3214","3215","3216","3217","3218","3219","3220","3221","3222","3223","3224","3225","3226","3227","3228","3229","3230","3231","3232","3233","3234","3235","3236","3237","3238","3239","3240","3241","3242","3243","3244","3245","3246","3247","3248","3249","3250","3251","3252","3253","3254","3255","3256","3257","3258","3259","3260","3261","3262","3263","3264","3265","3266","3267","3268","3269","3270","3271","3272","3273","3274","3275","3276","3277","3278","3279","3280","3281","3282","3283","3284","3285","3286","3287","3288","3289","3290","3291","3292","3293","3294","3295","3296","3297","3298","3299","3300","3301","3302","3303","3304","3305","3306","3307","3308","3309","3310","3311","3312","3313","3314","3315","3316","3317","3318","3319","3320","3321","3322","3323","3324","3325","3326","3327","3328","3329","3330","3331","3332","3333","3334","3335","3336","3337","3338","3339","3340","3341","3342","3343","3344","3345","3346","3347","3348","3349","3350","3351","3352","3353","3354","3355","3356","3357","3358","3359","3360","3361","3362","3363","3364","3365","3366","3367","3368","3369","3370","3371","3372","3373","3374","3375","3376","3377","3378","3379","3380","3381","3382","3383","3384","3385","3386","3387","3388","3389","3390","3391","3392","3393","3394","3395","3396","3397","3398","3399","3400","3401","3402","3403","3404","3405","3406","3407","3408","3409","3410","3411","3412","3413","3414","3415","3416","3417","3418","3419","3420","3421","3422","3423","3424","3425","3426","3427","3428","3429","3430","3431","3432","3433","3434","3435","3436","3437","3438","3439","3440","3441","3442","3443","3444","3445","3446","3447","3448","3449","3450","3451","3452","3453","3454","3455","3456","3457","3458","3459","3460","3461","3462","3463","3464","3465","3466","3467","3468","3469","3470","3471","3472","3473","3474","3475","3476","3477","3478","3479","3480","3481","3482","3483","3484","3485","3486","3487","3488","3489","3490","3491","3492","3493","3494","3495","3496","3497","3498","3499","3500","3501","3502","3503","3504","3505","3506","3507","3508","3509","3510","3511","3512","3513","3514","3515","3516","3517","3518","3519","3520","3521","3522","3523","3524","3525","3526","3527","3528","3529","3530","3531","3532","3533","3534","3535","3536","3537","3538","3539","3540","3541","3542","3543","3544","3545","3546","3547","3548","3549","3550","3551","3552","3553","3554","3555","3556","3557","3558","3559","3560","3561","3562","3563","3564","3565","3566","3567","3568","3569","3570","3571","3572","3573","3574","3575","3576","3577","3578","3579","3580","3581","3582","3583","3584","3585","3586","3587","3588","3589","3590","3591","3592","3593","3594","3595","3596","3597","3598","3599","3600","3601","3602","3603","3604","3605","3606","3607","3608","3609","3610","3611","3612","3613","3614","3615","3616","3617","3618","3619","3620","3621","3622","3623","3624","3625","3626","3627","3628","3629","3630","3631","3632","3633","3634","3635","3636","3637","3638","3639","3640","3641","3642","3643","3644","3645","3646","3647","3648","3649","3650","3651","3652","3653","3654","3655","3656","3657","3658","3659","3660","3661","3662","3663","3664","3665","3666","3667","3668","3669","3670","3671","3672","3673","3674","3675","3676","3677","3678","3679","3680","3681","3682","3683","3684","3685","3686","3687","3688","3689","3690","3691","3692","3693","3694","3695","3696","3697","3698","3699","3700","3701","3702","3703","3704","3705","3706","3707","3708","3709","3710","3711","3712","3713","3714","3715","3716","3717","3718","3719","3720","3721","3722","3723","3724","3725","3726","3727","3728","3729","3730","3731","3732","3733","3734","3735","3736","3737","3738","3739","3740","3741","3742","3743","3744","3745","3746","3747","3748","3749","3750","3751","3752","3753","3754","3755","3756","3757","3758","3759","3760","3761","3762","3763","3764","3765","3766","3767","3768","3769","3770","3771","3772","3773","3774","3775","3776","3777","3778","3779","3780","3781","3782","3783","3784","3785","3786","3787","3788","3789","3790","3791","3792","3793","3794","3795","3796","3797","3798","3799","3800","3801","3802","3803","3804","3805","3806","3807","3808","3809","3810","3811","3812","3813","3814","3815","3816","3817","3818","3819","3820","3821","3822","3823","3824","3825","3826","3827","3828","3829","3830","3831","3832","3833","3834","3835","3836","3837","3838","3839","3840","3841","3842","3843","3844","3845","3846","3847","3848","3849","3850","3851","3852","3853","3854","3855","3856","3857","3858","3859","3860","3861","3862","3863","3864","3865","3866","3867","3868","3869","3870","3871","3872","3873","3874","3875","3876","3877","3878","3879","3880","3881","3882","3883","3884","3885","3886","3887","3888","3889","3890","3891","3892","3893","3894","3895","3896","3897","3898","3899","3900","3901","3902","3903","3904","3905","3906","3907","3908","3909","3910","3911","3912","3913","3914","3915","3916","3917","3918","3919","3920","3921","3922","3923","3924","3925","3926","3927","3928","3929","3930","3931","3932","3933","3934","3935","3936","3937","3938","3939","3940","3941","3942","3943","3944","3945","3946","3947","3948","3949","3950","3951","3952","3953","3954","3955","3956","3957","3958","3959","3960","3961","3962","3963","3964","3965","3966","3967","3968","3969","3970","3971","3972","3973","3974","3975","3976","3977","3978","3979","3980","3981","3982","3983","3984","3985","3986","3987","3988","3989","3990","3991","3992","3993","3994","3995","3996","3997","3998","3999","4000","4001","4002","4003","4004","4005","4006","4007","4008","4009","4010","4011","4012","4013","4014","4015","4016","4017","4018","4019","4020","4021","4022","4023","4024","4025","4026","4027","4028","4029","4030","4031","4032","4033","4034","4035","4036","4037","4038","4039","4040","4041","4042","4043","4044","4045","4046","4047","4048","4049","4050","4051","4052","4053","4054","4055","4056","4057","4058","4059","4060","4061","4062","4063","4064","4065","4066","4067","4068","4069","4070","4071","4072","4073","4074","4075","4076","4077","4078","4079","4080","4081","4082","4083","4084","4085","4086","4087","4088","4089","4090","4091","4092","4093","4094","4095","4096","4097","4098","4099","4100","4101","4102","4103","4104","4105","4106","4107","4108","4109","4110","4111","4112","4113","4114","4115","4116","4117","4118","4119","4120","4121","4122","4123","4124","4125","4126","4127","4128","4129","4130","4131","4132","4133","4134","4135","4136","4137","4138","4139","4140","4141","4142","4143","4144","4145","4146","4147","4148","4149","4150","4151","4152","4153","4154","4155","4156","4157","4158","4159","4160","4161","4162","4163","4164","4165","4166","4167","4168","4169","4170","4171","4172","4173","4174","4175","4176","4177","4178","4179","4180","4181","4182","4183","4184","4185","4186","4187","4188","4189","4190","4191","4192","4193","4194","4195","4196","4197","4198","4199","4200","4201","4202","4203","4204","4205","4206","4207","4208","4209","4210","4211","4212","4213","4214","4215","4216","4217","4218","4219","4220","4221","4222","4223","4224","4225","4226","4227","4228","4229","4230","4231","4232","4233","4234","4235","4236","4237","4238","4239","4240","4241","4242","4243","4244","4245","4246","4247","4248","4249","4250","4251","4252","4253","4254","4255","4256","4257","4258","4259","4260","4261","4262","4263","4264","4265","4266","4267","4268","4269","4270","4271","4272","4273","4274","4275","4276","4277","4278","4279","4280","4281","4282","4283","4284","4285","4286","4287","4288","4289","4290","4291","4292","4293","4294","4295","4296","4297","4298","4299","4300","4301","4302","4303","4304","4305","4306","4307","4308","4309","4310","4311","4312","4313","4314","4315","4316","4317","4318","4319","4320","4321","4322","4323","4324","4325","4326","4327","4328","4329","4330","4331","4332","4333","4334","4335","4336","4337","4338","4339","4340","4341","4342","4343","4344","4345","4346","4347","4348","4349","4350","4351","4352","4353","4354","4355","4356","4357","4358","4359","4360","4361","4362","4363","4364","4365","4366","4367","4368","4369","4370","4371","4372","4373","4374","4375","4376","4377","4378","4379","4380","4381","4382","4383","4384","4385","4386","4387","4388","4389","4390","4391","4392","4393","4394","4395","4396","4397","4398","4399","4400","4401","4402","4403","4404","4405","4406","4407","4408","4409","4410","4411","4412","4413","4414","4415","4416","4417","4418","4419","4420","4421","4422","4423","4424","4425","4426","4427","4428","4429","4430","4431","4432","4433","4434","4435","4436","4437","4438","4439","4440","4441","4442","4443","4444","4445","4446","4447","4448","4449","4450","4451","4452","4453","4454","4455","4456","4457","4458","4459","4460","4461","4462","4463","4464","4465","4466","4467","4468","4469","4470","4471","4472","4473","4474","4475","4476","4477","4478","4479","4480","4481","4482","4483","4484","4485","4486","4487","4488","4489","4490","4491","4492","4493","4494","4495","4496","4497","4498","4499","4500","4501","4502","4503","4504","4505","4506","4507","4508","4509","4510","4511","4512","4513","4514","4515","4516","4517","4518","4519","4520","4521","4522","4523","4524","4525","4526","4527","4528","4529","4530","4531","4532","4533","4534","4535","4536","4537","4538","4539","4540","4541","4542","4543","4544","4545","4546","4547","4548","4549","4550","4551","4552","4553","4554","4555","4556","4557","4558","4559","4560","4561","4562","4563","4564","4565","4566","4567","4568","4569","4570","4571","4572","4573","4574","4575","4576","4577","4578","4579","4580","4581","4582","4583","4584","4585","4586","4587","4588","4589","4590","4591","4592","4593","4594","4595","4596","4597","4598","4599","4600","4601","4602","4603","4604","4605","4606","4607","4608","4609","4610","4611","4612","4613","4614","4615","4616","4617","4618","4619","4620","4621","4622","4623","4624","4625","4626","4627","4628","4629","4630","4631","4632","4633","4634","4635","4636","4637","4638","4639","4640","4641","4642","4643","4644","4645","4646","4647","4648","4649","4650","4651","4652","4653","4654","4655","4656","4657","4658","4659","4660","4661","4662","4663","4664","4665","4666","4667","4668","4669","4670","4671","4672","4673","4674","4675","4676","4677","4678","4679","4680","4681","4682","4683","4684","4685","4686","4687","4688","4689","4690","4691","4692","4693","4694","4695","4696","4697","4698","4699","4700","4701","4702","4703","4704","4705","4706","4707","4708","4709","4710","4711","4712","4713","4714","4715","4716","4717","4718","4719","4720","4721","4722","4723","4724","4725","4726","4727","4728","4729","4730","4731","4732","4733","4734","4735","4736","4737","4738","4739","4740","4741","4742","4743","4744","4745","4746","4747","4748","4749","4750","4751","4752","4753","4754","4755","4756","4757","4758","4759","4760","4761","4762","4763","4764","4765","4766","4767","4768","4769","4770","4771","4772","4773","4774","4775","4776","4777","4778","4779","4780","4781","4782","4783","4784","4785","4786","4787","4788","4789","4790","4791","4792","4793","4794","4795","4796","4797","4798","4799","4800","4801","4802","4803","4804","4805","4806","4807","4808","4809","4810","4811","4812","4813","4814","4815","4816","4817","4818","4819","4820","4821","4822","4823","4824","4825","4826","4827","4828","4829","4830","4831","4832","4833","4834","4835","4836","4837","4838","4839","4840","4841","4842","4843","4844","4845","4846","4847","4848","4849","4850","4851","4852","4853","4854","4855","4856","4857","4858","4859","4860","4861","4862","4863","4864","4865","4866","4867","4868","4869","4870","4871","4872","4873","4874","4875","4876","4877","4878","4879","4880","4881","4882","4883","4884","4885","4886","4887","4888","4889","4890","4891","4892","4893","4894","4895","4896","4897","4898","4899","4900","4901","4902","4903","4904","4905","4906","4907","4908","4909","4910","4911","4912","4913","4914","4915","4916","4917","4918","4919","4920","4921","4922","4923","4924","4925","4926","4927","4928","4929","4930","4931","4932","4933","4934","4935","4936","4937","4938","4939","4940","4941","4942","4943","4944","4945","4946","4947","4948","4949","4950","4951","4952","4953","4954","4955","4956","4957","4958","4959","4960","4961","4962","4963","4964","4965","4966","4967","4968","4969","4970","4971","4972","4973","4974","4975","4976","4977","4978","4979","4980","4981","4982","4983","4984","4985","4986","4987","4988","4989","4990","4991","4992","4993","4994","4995","4996","4997","4998","4999","5000","5001","5002","5003","5004","5005","5006","5007","5008","5009","5010","5011","5012","5013","5014","5015","5016","5017","5018","5019","5020","5021","5022","5023","5024","5025","5026","5027","5028","5029","5030","5031","5032","5033","5034","5035","5036","5037","5038","5039","5040","5041","5042","5043","5044","5045","5046","5047","5048","5049","5050","5051","5052","5053","5054","5055","5056","5057","5058","5059","5060","5061","5062","5063","5064","5065","5066","5067","5068","5069","5070","5071","5072","5073","5074","5075","5076","5077","5078","5079","5080","5081","5082","5083","5084","5085","5086","5087","5088","5089","5090","5091","5092","5093","5094","5095","5096","5097","5098","5099","5100","5101","5102","5103","5104","5105","5106","5107","5108","5109","5110","5111","5112","5113","5114","5115","5116","5117","5118","5119","5120","5121","5122","5123","5124","5125","5126","5127","5128","5129","5130","5131","5132","5133","5134","5135","5136","5137","5138","5139","5140","5141","5142","5143","5144","5145","5146","5147","5148","5149","5150","5151","5152","5153","5154","5155","5156","5157","5158","5159","5160","5161","5162","5163","5164","5165","5166","5167","5168","5169","5170","5171","5172","5173","5174","5175","5176","5177","5178","5179","5180","5181","5182","5183","5184","5185","5186","5187","5188","5189","5190","5191","5192","5193","5194","5195","5196","5197","5198","5199","5200","5201","5202","5203","5204","5205","5206","5207","5208","5209","5210","5211","5212","5213","5214","5215","5216","5217","5218","5219","5220","5221","5222","5223","5224","5225","5226","5227","5228","5229","5230","5231","5232","5233","5234","5235","5236","5237","5238","5239","5240","5241","5242","5243","5244","5245","5246","5247","5248","5249","5250","5251","5252","5253","5254","5255","5256","5257","5258","5259","5260","5261","5262","5263","5264","5265","5266","5267","5268","5269","5270","5271","5272","5273","5274","5275","5276","5277","5278","5279","5280","5281","5282","5283","5284","5285","5286","5287","5288","5289","5290","5291","5292","5293","5294","5295","5296","5297","5298","5299","5300","5301","5302","5303","5304","5305","5306","5307","5308","5309","5310","5311","5312","5313","5314","5315","5316","5317","5318","5319","5320","5321","5322","5323","5324","5325","5326","5327","5328","5329","5330","5331","5332","5333","5334","5335","5336","5337","5338","5339","5340","5341","5342","5343","5344","5345","5346","5347","5348","5349","5350","5351","5352","5353","5354","5355","5356","5357","5358","5359","5360","5361","5362","5363","5364","5365","5366","5367","5368","5369","5370","5371","5372","5373","5374","5375","5376","5377","5378","5379","5380","5381","5382","5383","5384","5385","5386","5387","5388","5389","5390","5391","5392","5393","5394","5395","5396","5397","5398","5399","5400","5401","5402","5403","5404","5405","5406","5407","5408","5409","5410","5411","5412","5413","5414","5415","5416","5417","5418","5419","5420","5421","5422","5423","5424","5425","5426","5427","5428","5429","5430","5431","5432","5433","5434","5435","5436","5437","5438","5439","5440","5441","5442","5443","5444","5445","5446","5447","5448","5449","5450","5451","5452","5453","5454","5455","5456","5457","5458","5459","5460","5461","5462","5463","5464","5465","5466","5467","5468","5469","5470","5471","5472","5473","5474","5475","5476","5477","5478","5479","5480","5481","5482","5483","5484","5485","5486","5487","5488","5489","5490","5491","5492","5493","5494","5495","5496","5497","5498","5499","5500","5501","5502","5503","5504","5505","5506","5507","5508","5509","5510","5511","5512","5513","5514","5515","5516","5517","5518","5519","5520","5521","5522","5523","5524","5525","5526","5527","5528","5529","5530","5531","5532","5533","5534","5535","5536","5537","5538","5539","5540","5541","5542","5543","5544","5545","5546","5547","5548","5549","5550","5551","5552","5553","5554","5555","5556","5557","5558","5559","5560","5561","5562","5563","5564","5565","5566","5567","5568","5569","5570","5571","5572","5573","5574","5575","5576","5577","5578","5579","5580","5581","5582","5583","5584","5585","5586","5587","5588","5589","5590","5591","5592","5593","5594","5595","5596","5597","5598","5599","5600","5601","5602","5603","5604","5605","5606","5607","5608","5609","5610","5611","5612","5613","5614","5615","5616","5617","5618","5619","5620","5621","5622","5623","5624","5625","5626","5627","5628","5629","5630","5631","5632","5633","5634","5635","5636","5637","5638","5639","5640","5641","5642","5643","5644","5645","5646","5647","5648","5649","5650","5651","5652","5653","5654","5655","5656","5657","5658","5659","5660","5661","5662","5663","5664","5665","5666","5667","5668","5669","5670","5671","5672","5673","5674","5675","5676","5677","5678","5679","5680","5681","5682","5683","5684","5685","5686","5687","5688","5689","5690","5691","5692","5693","5694","5695","5696","5697","5698","5699","5700","5701","5702","5703","5704","5705","5706","5707","5708","5709","5710","5711","5712","5713","5714","5715","5716","5717","5718","5719","5720","5721","5722","5723","5724","5725","5726","5727","5728","5729","5730","5731","5732","5733","5734","5735","5736","5737","5738","5739","5740","5741","5742","5743","5744","5745","5746","5747","5748","5749","5750","5751","5752","5753","5754","5755","5756","5757","5758","5759","5760","5761","5762","5763","5764","5765","5766","5767","5768","5769","5770","5771","5772","5773","5774","5775","5776","5777","5778","5779","5780","5781","5782","5783","5784","5785","5786","5787","5788","5789","5790","5791","5792","5793","5794","5795","5796","5797","5798","5799","5800","5801","5802","5803","5804","5805","5806","5807","5808","5809","5810","5811","5812","5813","5814","5815","5816","5817","5818","5819","5820","5821","5822","5823","5824","5825","5826","5827","5828","5829","5830","5831","5832","5833","5834","5835","5836","5837","5838","5839","5840","5841","5842","5843","5844","5845","5846","5847","5848","5849","5850","5851","5852","5853","5854","5855","5856","5857","5858","5859","5860","5861","5862","5863","5864","5865","5866","5867","5868","5869","5870","5871","5872","5873","5874","5875","5876","5877","5878","5879","5880","5881","5882","5883","5884","5885","5886","5887","5888","5889","5890","5891","5892","5893","5894","5895","5896","5897","5898","5899","5900","5901","5902","5903","5904","5905","5906","5907","5908","5909","5910","5911","5912","5913","5914","5915","5916","5917","5918","5919","5920","5921","5922","5923","5924","5925","5926","5927","5928","5929","5930","5931","5932","5933","5934","5935","5936","5937","5938","5939","5940","5941","5942","5943","5944","5945","5946","5947","5948","5949","5950","5951","5952","5953","5954","5955","5956","5957","5958","5959","5960","5961","5962","5963","5964","5965","5966","5967","5968","5969","5970","5971","5972","5973","5974","5975","5976","5977","5978","5979","5980","5981","5982","5983","5984","5985","5986","5987","5988","5989","5990","5991","5992","5993","5994","5995","5996","5997","5998","5999","6000","6001","6002","6003","6004","6005","6006","6007","6008","6009","6010","6011","6012","6013","6014","6015","6016","6017","6018","6019","6020","6021","6022","6023","6024","6025","6026","6027","6028","6029","6030","6031","6032","6033","6034","6035","6036","6037","6038","6039","6040","6041","6042","6043","6044","6045","6046","6047","6048","6049","6050","6051","6052","6053","6054","6055","6056","6057","6058","6059","6060","6061","6062","6063","6064","6065","6066","6067","6068","6069","6070","6071","6072","6073","6074","6075","6076","6077","6078","6079","6080","6081","6082","6083","6084","6085","6086","6087","6088","6089","6090","6091","6092","6093","6094","6095","6096","6097","6098","6099","6100","6101","6102","6103","6104","6105","6106","6107","6108","6109","6110","6111","6112","6113","6114","6115","6116","6117","6118","6119","6120","6121","6122","6123","6124","6125","6126","6127","6128","6129","6130","6131","6132","6133","6134","6135","6136","6137","6138","6139","6140","6141","6142","6143","6144","6145","6146","6147","6148","6149","6150","6151","6152","6153","6154","6155","6156","6157","6158","6159","6160","6161","6162","6163","6164","6165","6166","6167","6168","6169","6170","6171","6172","6173","6174","6175","6176","6177","6178","6179","6180","6181","6182","6183","6184","6185","6186","6187","6188","6189","6190","6191","6192","6193","6194","6195","6196","6197","6198","6199","6200","6201","6202","6203","6204","6205","6206","6207","6208","6209","6210","6211","6212","6213","6214","6215","6216","6217","6218","6219","6220","6221","6222","6223","6224","6225","6226","6227","6228","6229","6230","6231","6232","6233","6234","6235","6236","6237","6238","6239","6240","6241","6242","6243","6244","6245","6246","6247","6248","6249","6250","6251","6252","6253","6254","6255","6256","6257","6258","6259","6260","6261","6262","6263","6264","6265","6266","6267","6268","6269","6270","6271","6272","6273","6274","6275","6276","6277","6278","6279","6280","6281","6282","6283","6284","6285","6286","6287","6288","6289","6290","6291","6292","6293","6294","6295","6296","6297","6298","6299","6300","6301","6302","6303","6304","6305","6306","6307","6308","6309","6310","6311","6312","6313","6314","6315","6316","6317","6318","6319","6320","6321","6322","6323","6324","6325","6326","6327","6328","6329","6330","6331","6332","6333","6334","6335","6336","6337","6338","6339","6340","6341","6342","6343","6344","6345","6346","6347","6348","6349","6350","6351","6352","6353","6354","6355","6356","6357","6358","6359","6360","6361","6362","6363","6364","6365","6366","6367","6368","6369","6370","6371","6372","6373","6374","6375","6376","6377","6378","6379","6380","6381","6382","6383","6384","6385","6386","6387","6388","6389","6390","6391","6392","6393","6394","6395","6396","6397","6398","6399","6400","6401","6402","6403","6404","6405","6406","6407","6408","6409","6410","6411","6412","6413","6414","6415","6416","6417","6418","6419","6420","6421","6422","6423","6424","6425","6426","6427","6428","6429","6430","6431","6432","6433","6434","6435","6436","6437","6438","6439","6440","6441","6442","6443","6444","6445","6446","6447","6448","6449","6450","6451","6452","6453","6454","6455","6456","6457","6458","6459","6460","6461","6462","6463","6464","6465","6466","6467","6468","6469","6470","6471","6472","6473","6474","6475","6476","6477","6478","6479","6480","6481","6482","6483","6484","6485","6486","6487","6488","6489","6490","6491","6492","6493","6494","6495","6496","6497","6498","6499","6500","6501","6502","6503","6504","6505","6506","6507","6508","6509","6510","6511","6512","6513","6514","6515","6516","6517","6518","6519","6520","6521","6522","6523","6524","6525","6526","6527","6528","6529","6530","6531","6532","6533","6534","6535","6536","6537","6538","6539","6540","6541","6542","6543","6544","6545","6546","6547","6548","6549","6550","6551","6552","6553","6554","6555","6556","6557","6558","6559","6560","6561","6562","6563","6564","6565","6566","6567","6568","6569","6570","6571","6572","6573","6574","6575","6576","6577","6578","6579","6580","6581","6582","6583","6584","6585","6586","6587","6588","6589","6590","6591","6592","6593","6594","6595","6596","6597","6598","6599","6600","6601","6602","6603","6604","6605","6606","6607","6608","6609","6610","6611","6612","6613","6614","6615","6616","6617","6618","6619","6620","6621","6622","6623","6624","6625","6626","6627","6628","6629","6630","6631","6632","6633","6634","6635","6636","6637","6638","6639","6640","6641","6642","6643","6644","6645","6646","6647","6648","6649","6650","6651","6652","6653","6654","6655","6656","6657","6658","6659","6660","6661","6662","6663","6664","6665","6666","6667","6668","6669","6670","6671","6672","6673","6674","6675","6676","6677","6678","6679","6680","6681","6682","6683","6684","6685","6686","6687","6688","6689","6690","6691","6692","6693","6694","6695","6696","6697","6698","6699","6700","6701","6702","6703","6704","6705","6706","6707","6708","6709","6710","6711","6712","6713","6714","6715","6716","6717","6718","6719","6720","6721","6722","6723","6724","6725","6726","6727","6728","6729","6730","6731","6732","6733","6734","6735","6736","6737","6738","6739","6740","6741","6742","6743","6744","6745","6746","6747","6748","6749","6750","6751","6752","6753","6754","6755","6756","6757","6758","6759","6760","6761","6762","6763","6764","6765","6766","6767","6768","6769","6770","6771","6772","6773","6774","6775","6776","6777","6778","6779","6780","6781","6782","6783","6784","6785","6786","6787","6788","6789","6790","6791","6792","6793","6794","6795","6796","6797","6798","6799","6800","6801","6802","6803","6804","6805","6806","6807","6808","6809","6810","6811","6812","6813","6814","6815","6816","6817","6818","6819","6820","6821","6822","6823","6824","6825","6826","6827","6828","6829","6830","6831","6832","6833","6834","6835","6836","6837","6838","6839","6840","6841","6842","6843","6844","6845","6846","6847","6848","6849","6850","6851","6852","6853","6854","6855","6856","6857","6858","6859","6860","6861","6862","6863","6864","6865","6866","6867","6868","6869","6870","6871","6872","6873","6874","6875","6876","6877","6878","6879","6880","6881","6882","6883","6884","6885","6886","6887","6888","6889","6890","6891","6892","6893","6894","6895","6896","6897","6898","6899","6900","6901","6902","6903","6904","6905","6906","6907","6908","6909","6910","6911","6912","6913","6914","6915","6916","6917","6918","6919","6920","6921","6922","6923","6924","6925","6926","6927","6928","6929","6930","6931","6932","6933","6934","6935","6936","6937","6938","6939","6940","6941","6942","6943","6944","6945","6946","6947","6948","6949","6950","6951","6952","6953","6954","6955","6956","6957","6958","6959","6960","6961","6962","6963","6964","6965","6966","6967","6968","6969","6970","6971","6972","6973","6974","6975","6976","6977","6978","6979","6980","6981","6982","6983","6984","6985","6986","6987","6988","6989","6990","6991","6992","6993","6994","6995","6996","6997","6998","6999","7000","7001","7002","7003","7004","7005","7006","7007","7008","7009","7010","7011","7012","7013","7014","7015","7016","7017","7018","7019","7020","7021","7022","7023","7024","7025","7026","7027","7028","7029","7030","7031","7032","7033","7034","7035","7036","7037","7038","7039","7040","7041","7042","7043","7044","7045","7046","7047","7048","7049","7050","7051","7052","7053","7054","7055","7056","7057","7058","7059","7060","7061","7062","7063","7064","7065","7066","7067","7068","7069","7070","7071","7072","7073","7074","7075","7076","7077","7078","7079","7080","7081","7082","7083","7084","7085","7086","7087","7088","7089","7090","7091","7092","7093","7094","7095","7096","7097","7098","7099","7100","7101","7102","7103","7104","7105","7106","7107","7108","7109","7110","7111","7112","7113","7114","7115","7116","7117","7118","7119","7120","7121","7122","7123","7124","7125","7126","7127","7128","7129","7130","7131","7132","7133","7134","7135","7136","7137","7138","7139","7140","7141","7142","7143","7144","7145","7146","7147","7148","7149","7150","7151","7152","7153","7154","7155","7156","7157","7158","7159","7160","7161","7162","7163","7164","7165","7166","7167","7168","7169","7170","7171","7172","7173","7174","7175","7176","7177","7178","7179","7180","7181","7182","7183","7184","7185","7186","7187","7188","7189","7190","7191","7192","7193","7194","7195","7196","7197","7198","7199","7200","7201","7202","7203","7204","7205","7206","7207","7208","7209","7210","7211","7212","7213","7214","7215","7216","7217","7218","7219","7220","7221","7222","7223","7224","7225","7226","7227","7228","7229","7230","7231","7232","7233","7234","7235","7236","7237","7238","7239","7240","7241","7242","7243","7244","7245","7246","7247","7248","7249","7250","7251","7252","7253","7254","7255","7256","7257","7258","7259","7260","7261","7262","7263","7264","7265","7266","7267","7268","7269","7270","7271","7272","7273","7274","7275","7276","7277","7278","7279","7280","7281","7282","7283","7284","7285","7286","7287","7288","7289","7290","7291","7292","7293","7294","7295","7296","7297","7298","7299","7300","7301","7302","7303","7304","7305","7306","7307","7308","7309","7310","7311","7312","7313","7314","7315","7316","7317","7318","7319","7320","7321","7322","7323","7324","7325","7326","7327","7328","7329","7330","7331","7332","7333","7334","7335","7336","7337","7338","7339","7340","7341","7342","7343","7344","7345","7346","7347","7348","7349","7350","7351","7352","7353","7354","7355","7356","7357","7358","7359","7360","7361","7362","7363","7364","7365","7366","7367","7368","7369","7370","7371","7372","7373","7374","7375","7376","7377","7378","7379","7380","7381","7382","7383","7384","7385","7386","7387","7388","7389","7390","7391","7392","7393","7394","7395","7396","7397","7398","7399","7400","7401","7402","7403","7404","7405","7406","7407","7408","7409","7410","7411","7412","7413","7414","7415","7416","7417","7418","7419","7420","7421","7422","7423","7424","7425","7426","7427","7428","7429","7430","7431","7432","7433","7434","7435","7436","7437","7438","7439","7440","7441","7442","7443","7444","7445","7446","7447","7448","7449","7450","7451","7452","7453","7454","7455","7456","7457","7458","7459","7460","7461","7462","7463","7464","7465","7466","7467","7468","7469","7470","7471","7472","7473","7474","7475","7476","7477","7478","7479","7480","7481","7482","7483","7484","7485","7486","7487","7488","7489","7490","7491","7492","7493","7494","7495","7496","7497","7498","7499","7500","7501","7502","7503","7504","7505","7506","7507","7508","7509","7510","7511","7512","7513","7514","7515","7516","7517","7518","7519","7520","7521","7522","7523","7524","7525","7526","7527","7528","7529","7530","7531","7532","7533","7534","7535","7536","7537","7538","7539","7540","7541","7542","7543","7544","7545","7546","7547","7548","7549","7550","7551","7552","7553","7554","7555","7556","7557","7558","7559","7560","7561","7562","7563","7564","7565","7566","7567","7568","7569","7570","7571","7572","7573","7574","7575","7576","7577","7578","7579","7580","7581","7582","7583","7584","7585","7586","7587","7588","7589","7590","7591","7592","7593","7594","7595","7596","7597","7598","7599","7600","7601","7602","7603","7604","7605","7606","7607","7608","7609","7610","7611","7612","7613","7614","7615","7616","7617","7618","7619","7620","7621","7622","7623","7624","7625","7626","7627","7628","7629","7630","7631","7632","7633","7634","7635","7636","7637","7638","7639","7640","7641","7642","7643","7644","7645","7646","7647","7648","7649","7650","7651","7652","7653","7654","7655","7656","7657","7658","7659","7660","7661","7662","7663","7664","7665","7666","7667","7668","7669","7670","7671","7672","7673","7674","7675","7676","7677","7678","7679","7680","7681","7682","7683","7684","7685","7686","7687","7688","7689","7690","7691","7692","7693","7694","7695","7696","7697","7698","7699","7700","7701","7702","7703","7704","7705","7706","7707","7708","7709","7710","7711","7712","7713","7714","7715","7716","7717","7718","7719","7720","7721","7722","7723","7724","7725","7726","7727","7728","7729","7730","7731","7732","7733","7734","7735","7736","7737","7738","7739","7740","7741","7742","7743","7744","7745","7746","7747","7748","7749","7750","7751","7752","7753","7754","7755","7756","7757","7758","7759","7760","7761","7762","7763","7764","7765","7766","7767","7768","7769","7770","7771","7772","7773","7774","7775","7776","7777","7778","7779","7780","7781","7782","7783","7784","7785","7786","7787","7788","7789","7790","7791","7792","7793","7794","7795","7796","7797","7798","7799","7800","7801","7802","7803","7804","7805","7806","7807","7808","7809","7810","7811","7812","7813","7814","7815","7816","7817","7818","7819","7820","7821","7822","7823","7824","7825","7826","7827","7828","7829","7830","7831","7832","7833","7834","7835","7836","7837","7838","7839","7840","7841","7842","7843","7844","7845","7846","7847","7848","7849","7850","7851","7852","7853","7854","7855","7856","7857","7858","7859","7860","7861","7862","7863","7864","7865","7866","7867","7868","7869","7870","7871","7872","7873","7874","7875","7876","7877","7878","7879","7880","7881","7882","7883","7884","7885","7886","7887","7888","7889","7890","7891","7892","7893","7894","7895","7896","7897","7898","7899","7900","7901","7902","7903","7904","7905","7906","7907","7908","7909","7910","7911","7912","7913","7914","7915","7916","7917","7918","7919","7920","7921","7922","7923","7924","7925","7926","7927","7928","7929","7930","7931","7932","7933","7934","7935","7936","7937","7938","7939","7940","7941","7942","7943","7944","7945","7946","7947","7948","7949","7950","7951","7952","7953","7954","7955","7956","7957","7958","7959","7960","7961","7962","7963","7964","7965","7966","7967","7968","7969","7970","7971","7972","7973","7974","7975","7976","7977","7978","7979","7980","7981","7982","7983","7984","7985","7986","7987","7988","7989","7990","7991","7992","7993","7994","7995","7996","7997","7998","7999","8000","8001","8002","8003","8004","8005","8006","8007","8008","8009","8010","8011","8012","8013","8014","8015","8016","8017","8018","8019","8020","8021","8022","8023","8024","8025","8026","8027","8028","8029","8030","8031","8032","8033","8034","8035","8036","8037","8038","8039","8040","8041","8042","8043","8044","8045","8046","8047","8048","8049","8050","8051","8052","8053","8054","8055","8056","8057","8058","8059","8060","8061","8062","8063","8064","8065","8066","8067","8068","8069","8070","8071","8072","8073","8074","8075","8076","8077","8078","8079","8080","8081","8082","8083","8084","8085","8086","8087","8088","8089","8090","8091","8092","8093","8094","8095","8096","8097","8098","8099","8100","8101","8102","8103","8104","8105","8106","8107","8108","8109","8110","8111","8112","8113","8114","8115","8116","8117","8118","8119","8120","8121","8122","8123","8124","8125","8126","8127","8128","8129","8130","8131","8132","8133","8134","8135","8136","8137","8138","8139","8140","8141","8142","8143","8144","8145","8146","8147","8148","8149","8150","8151","8152","8153","8154","8155","8156","8157","8158","8159","8160","8161","8162","8163","8164","8165","8166","8167","8168","8169","8170","8171","8172","8173","8174","8175","8176","8177","8178","8179","8180","8181","8182","8183","8184","8185","8186","8187","8188","8189","8190","8191","8192","8193","8194","8195","8196","8197","8198","8199","8200","8201","8202","8203","8204","8205","8206","8207","8208","8209","8210","8211","8212","8213","8214","8215","8216","8217","8218","8219","8220","8221","8222","8223","8224","8225","8226","8227","8228","8229","8230","8231","8232","8233","8234","8235","8236","8237","8238","8239","8240","8241","8242","8243","8244","8245","8246","8247","8248","8249","8250","8251","8252","8253","8254","8255","8256","8257","8258","8259","8260","8261","8262","8263","8264","8265","8266","8267","8268","8269","8270","8271","8272","8273","8274","8275","8276","8277","8278","8279","8280","8281","8282","8283","8284","8285","8286","8287","8288","8289","8290","8291","8292","8293","8294","8295","8296","8297","8298","8299","8300","8301","8302","8303","8304","8305","8306","8307","8308","8309","8310","8311","8312","8313","8314","8315","8316","8317","8318","8319","8320","8321","8322","8323","8324","8325","8326","8327","8328","8329","8330","8331","8332","8333","8334","8335","8336","8337","8338","8339","8340","8341","8342","8343","8344","8345","8346","8347","8348","8349","8350","8351","8352","8353","8354","8355","8356","8357","8358","8359","8360","8361","8362","8363","8364","8365","8366","8367","8368","8369","8370","8371","8372","8373","8374","8375","8376","8377","8378","8379","8380","8381","8382","8383","8384","8385","8386","8387","8388","8389","8390","8391","8392","8393","8394","8395","8396","8397","8398","8399","8400","8401","8402","8403","8404","8405","8406","8407","8408","8409","8410","8411","8412","8413","8414","8415","8416","8417","8418","8419","8420","8421","8422","8423","8424","8425","8426","8427","8428","8429","8430","8431","8432","8433","8434","8435","8436","8437","8438","8439","8440","8441","8442","8443","8444","8445","8446","8447","8448","8449","8450","8451","8452","8453","8454","8455","8456","8457","8458","8459","8460","8461","8462","8463","8464","8465","8466","8467","8468","8469","8470","8471","8472","8473","8474","8475","8476","8477","8478","8479","8480","8481","8482","8483","8484","8485","8486","8487","8488","8489","8490","8491","8492","8493","8494","8495","8496","8497","8498","8499","8500","8501","8502","8503","8504","8505","8506","8507","8508","8509","8510","8511","8512","8513","8514","8515","8516","8517","8518","8519","8520","8521","8522","8523","8524","8525","8526","8527","8528","8529","8530","8531","8532","8533","8534","8535","8536","8537","8538","8539","8540","8541","8542","8543","8544","8545","8546","8547","8548","8549","8550","8551","8552","8553","8554","8555","8556","8557","8558","8559","8560","8561","8562","8563","8564","8565","8566","8567","8568","8569","8570","8571","8572","8573","8574","8575","8576","8577","8578","8579","8580","8581","8582","8583","8584","8585","8586","8587","8588","8589","8590","8591","8592","8593","8594","8595","8596","8597","8598","8599","8600","8601","8602","8603","8604","8605","8606","8607","8608","8609","8610","8611","8612","8613","8614","8615","8616","8617","8618","8619","8620","8621","8622","8623","8624","8625","8626","8627","8628","8629","8630","8631","8632","8633","8634","8635","8636","8637","8638","8639","8640","8641","8642","8643","8644","8645","8646","8647","8648","8649","8650","8651","8652","8653","8654","8655","8656","8657","8658","8659","8660","8661","8662","8663","8664","8665","8666","8667","8668","8669","8670","8671","8672","8673","8674","8675","8676","8677","8678","8679","8680","8681","8682","8683","8684","8685","8686","8687","8688","8689","8690","8691","8692","8693","8694","8695","8696","8697","8698","8699","8700","8701","8702","8703","8704","8705","8706","8707","8708","8709","8710","8711","8712","8713","8714","8715","8716","8717","8718","8719","8720","8721","8722","8723","8724","8725","8726","8727","8728","8729","8730","8731","8732","8733","8734","8735","8736","8737","8738","8739","8740","8741","8742","8743","8744","8745","8746","8747","8748","8749","8750","8751","8752","8753","8754","8755","8756","8757","8758","8759","8760","8761","8762","8763","8764","8765","8766","8767","8768","8769","8770","8771","8772","8773","8774","8775","8776","8777","8778","8779","8780","8781","8782","8783","8784","8785","8786","8787","8788","8789","8790","8791","8792","8793","8794","8795","8796","8797","8798","8799","8800","8801","8802","8803","8804","8805","8806","8807","8808","8809","8810","8811","8812","8813","8814","8815","8816","8817","8818","8819","8820","8821","8822","8823","8824","8825","8826","8827","8828","8829","8830","8831","8832","8833","8834","8835","8836","8837","8838","8839","8840","8841","8842","8843","8844","8845","8846","8847","8848","8849","8850","8851","8852","8853","8854","8855","8856","8857","8858","8859","8860","8861","8862","8863","8864","8865","8866","8867","8868","8869","8870","8871","8872","8873","8874","8875","8876","8877","8878","8879","8880","8881","8882","8883","8884","8885","8886","8887","8888","8889","8890","8891","8892","8893","8894","8895","8896","8897","8898","8899","8900","8901","8902","8903","8904","8905","8906","8907","8908","8909","8910","8911","8912","8913","8914","8915","8916","8917","8918","8919","8920","8921","8922","8923","8924","8925","8926","8927","8928","8929","8930","8931","8932","8933","8934","8935","8936","8937","8938","8939","8940","8941","8942","8943","8944","8945","8946","8947","8948","8949","8950","8951","8952","8953","8954","8955","8956","8957","8958","8959","8960","8961","8962","8963","8964","8965","8966","8967","8968","8969","8970","8971","8972","8973","8974","8975","8976","8977","8978","8979","8980","8981","8982","8983","8984","8985","8986","8987","8988","8989","8990","8991","8992","8993","8994","8995","8996","8997","8998","8999","9000","9001","9002","9003","9004","9005","9006","9007","9008","9009","9010","9011","9012","9013","9014","9015","9016","9017","9018","9019","9020","9021","9022","9023","9024","9025","9026","9027","9028","9029","9030","9031","9032","9033","9034","9035","9036","9037","9038","9039","9040","9041","9042","9043","9044","9045","9046","9047","9048","9049","9050","9051","9052","9053","9054","9055","9056","9057","9058","9059","9060","9061","9062","9063","9064","9065","9066","9067","9068","9069","9070","9071","9072","9073","9074","9075","9076","9077","9078","9079","9080","9081","9082","9083","9084","9085","9086","9087","9088","9089","9090","9091","9092","9093","9094","9095","9096","9097","9098","9099","9100","9101","9102","9103","9104","9105","9106","9107","9108","9109","9110","9111","9112","9113","9114","9115","9116","9117","9118","9119","9120","9121","9122","9123","9124","9125","9126","9127","9128","9129","9130","9131","9132","9133","9134","9135","9136","9137","9138","9139","9140","9141","9142","9143","9144","9145","9146","9147","9148","9149","9150","9151","9152","9153","9154","9155","9156","9157","9158","9159","9160","9161","9162","9163","9164","9165","9166","9167","9168","9169","9170","9171","9172","9173","9174","9175","9176","9177","9178","9179","9180","9181","9182","9183","9184","9185","9186","9187","9188","9189","9190","9191","9192","9193","9194","9195","9196","9197","9198","9199","9200","9201","9202","9203","9204","9205","9206","9207","9208","9209","9210","9211","9212","9213","9214","9215","9216","9217","9218","9219","9220","9221","9222","9223","9224","9225","9226","9227","9228","9229","9230","9231","9232","9233","9234","9235","9236","9237","9238","9239","9240","9241","9242","9243","9244","9245","9246","9247","9248","9249","9250","9251","9252","9253","9254","9255","9256","9257","9258","9259","9260","9261","9262","9263","9264","9265","9266","9267","9268","9269","9270","9271","9272","9273","9274","9275","9276","9277","9278","9279","9280","9281","9282","9283","9284","9285","9286","9287","9288","9289","9290","9291","9292","9293","9294","9295","9296","9297","9298","9299","9300","9301","9302","9303","9304","9305","9306","9307","9308","9309","9310","9311","9312","9313","9314","9315","9316","9317","9318","9319","9320","9321","9322","9323","9324","9325","9326","9327","9328","9329","9330","9331","9332","9333","9334","9335","9336","9337","9338","9339","9340","9341","9342","9343","9344","9345","9346","9347","9348","9349","9350","9351","9352","9353","9354","9355","9356","9357","9358","9359","9360","9361","9362","9363","9364","9365","9366","9367","9368","9369","9370","9371","9372","9373","9374","9375","9376","9377","9378","9379","9380","9381","9382","9383","9384","9385","9386","9387","9388","9389","9390","9391","9392","9393","9394","9395","9396","9397","9398","9399","9400","9401","9402","9403","9404","9405","9406","9407","9408","9409","9410","9411","9412","9413","9414","9415","9416","9417","9418","9419","9420","9421","9422","9423","9424","9425","9426","9427","9428","9429","9430","9431","9432","9433","9434","9435","9436","9437","9438","9439","9440","9441","9442","9443","9444","9445","9446","9447","9448","9449","9450","9451","9452","9453","9454","9455","9456","9457","9458","9459","9460","9461","9462","9463","9464","9465","9466","9467","9468","9469","9470","9471","9472","9473","9474","9475","9476","9477","9478","9479","9480","9481","9482","9483","9484","9485","9486","9487","9488","9489","9490","9491","9492","9493","9494","9495","9496","9497","9498","9499","9500","9501","9502","9503","9504","9505","9506","9507","9508","9509","9510","9511","9512","9513","9514","9515","9516","9517","9518","9519","9520","9521","9522","9523","9524","9525","9526","9527","9528","9529","9530","9531","9532","9533","9534","9535","9536","9537","9538","9539","9540","9541","9542","9543","9544","9545","9546","9547","9548","9549","9550","9551","9552","9553","9554","9555","9556","9557","9558","9559","9560","9561","9562","9563","9564","9565","9566","9567","9568","9569","9570","9571","9572","9573","9574","9575","9576","9577","9578","9579","9580","9581","9582","9583","9584","9585","9586","9587","9588","9589","9590","9591","9592","9593","9594","9595","9596","9597","9598","9599","9600","9601","9602","9603","9604","9605","9606","9607","9608","9609","9610","9611","9612","9613","9614","9615","9616","9617","9618","9619","9620","9621","9622","9623","9624","9625","9626","9627","9628","9629","9630","9631","9632","9633","9634","9635","9636","9637","9638","9639","9640","9641","9642","9643","9644","9645","9646","9647","9648","9649","9650","9651","9652","9653","9654","9655","9656","9657","9658","9659","9660","9661","9662","9663","9664","9665","9666","9667","9668","9669","9670","9671","9672","9673","9674","9675","9676","9677","9678","9679","9680","9681","9682","9683","9684","9685","9686","9687","9688","9689","9690","9691","9692","9693","9694","9695","9696","9697","9698","9699","9700","9701","9702","9703","9704","9705","9706","9707","9708","9709","9710","9711","9712","9713","9714","9715","9716","9717","9718","9719","9720","9721","9722","9723","9724","9725","9726","9727","9728","9729","9730","9731","9732","9733","9734","9735","9736","9737","9738","9739","9740","9741","9742","9743","9744","9745","9746","9747","9748","9749","9750","9751","9752","9753","9754","9755","9756","9757","9758","9759","9760","9761","9762","9763","9764","9765","9766","9767","9768","9769","9770","9771","9772","9773","9774","9775","9776","9777","9778","9779","9780","9781","9782","9783","9784","9785","9786","9787","9788","9789","9790","9791","9792","9793","9794","9795","9796","9797","9798","9799","9800","9801","9802","9803","9804","9805","9806","9807","9808","9809","9810","9811","9812","9813","9814","9815","9816","9817","9818","9819","9820","9821","9822","9823","9824","9825","9826","9827","9828","9829","9830","9831","9832","9833","9834","9835","9836","9837","9838","9839","9840","9841","9842","9843","9844","9845","9846","9847","9848","9849","9850","9851","9852","9853","9854","9855","9856","9857","9858","9859","9860","9861","9862","9863","9864","9865","9866","9867","9868","9869","9870","9871","9872","9873","9874","9875","9876","9877","9878","9879","9880","9881","9882","9883","9884","9885","9886","9887","9888","9889","9890","9891","9892","9893","9894","9895","9896","9897","9898","9899","9900","9901","9902","9903","9904","9905","9906","9907","9908","9909","9910","9911","9912","9913","9914","9915","9916","9917","9918","9919","9920","9921","9922","9923","9924","9925","9926","9927","9928","9929","9930","9931","9932","9933","9934","9935","9936","9937","9938","9939","9940","9941","9942","9943","9944","9945","9946","9947","9948","9949","9950","9951","9952","9953","9954","9955","9956","9957","9958","9959","9960","9961","9962","9963","9964","9965","9966","9967","9968","9969","9970","9971","9972","9973","9974","9975","9976","9977","9978","9979","9980","9981","9982","9983","9984","9985","9986","9987","9988","9989","9990","9991","9992","9993","9994","9995","9996","9997","9998","9999","10000","10001","10002","10003","10004","10005","10006","10007","10008","10009","10010","10011","10012","10013","10014","10015","10016","10017","10018","10019","10020","10021","10022","10023","10024","10025","10026","10027","10028","10029","10030","10031","10032","10033","10034","10035","10036","10037","10038","10039","10040","10041","10042","10043","10044","10045","10046","10047","10048","10049","10050","10051","10052","10053","10054","10055","10056","10057","10058","10059","10060","10061","10062","10063","10064","10065","10066","10067","10068","10069","10070","10071","10072","10073","10074","10075","10076","10077","10078","10079","10080","10081","10082","10083","10084","10085","10086","10087","10088","10089","10090","10091","10092","10093","10094","10095","10096","10097","10098","10099","10100","10101","10102","10103","10104","10105","10106","10107","10108","10109","10110","10111","10112","10113","10114","10115","10116","10117","10118","10119","10120","10121","10122","10123","10124","10125","10126","10127","10128","10129","10130","10131","10132","10133","10134","10135","10136","10137","10138","10139","10140","10141","10142","10143","10144","10145","10146","10147","10148","10149","10150","10151","10152","10153","10154","10155","10156","10157","10158","10159","10160","10161","10162","10163","10164","10165","10166","10167","10168","10169","10170","10171","10172","10173","10174","10175","10176","10177","10178","10179","10180","10181","10182","10183","10184","10185","10186","10187","10188","10189","10190","10191","10192","10193","10194","10195","10196","10197","10198","10199","10200","10201","10202","10203","10204","10205","10206","10207","10208","10209","10210","10211","10212","10213","10214","10215","10216","10217","10218","10219","10220","10221","10222","10223","10224","10225","10226","10227","10228","10229","10230","10231","10232","10233","10234","10235","10236","10237","10238","10239","10240","10241","10242","10243","10244","10245","10246","10247","10248","10249","10250","10251","10252","10253","10254","10255","10256","10257","10258","10259","10260","10261","10262","10263","10264","10265","10266","10267","10268","10269","10270","10271","10272","10273","10274","10275","10276","10277","10278","10279","10280","10281","10282","10283","10284","10285","10286","10287","10288","10289","10290","10291","10292","10293","10294","10295","10296","10297","10298","10299","10300","10301","10302","10303","10304","10305","10306","10307","10308","10309","10310","10311","10312","10313","10314","10315","10316","10317","10318","10319","10320","10321","10322","10323","10324","10325","10326","10327","10328","10329","10330","10331","10332","10333","10334","10335","10336","10337","10338","10339","10340","10341","10342","10343","10344","10345","10346","10347","10348","10349","10350","10351","10352","10353","10354","10355","10356","10357","10358","10359","10360","10361","10362","10363","10364","10365","10366","10367","10368","10369","10370","10371","10372","10373","10374","10375","10376","10377","10378","10379","10380","10381","10382","10383","10384","10385","10386","10387","10388","10389","10390","10391","10392","10393","10394","10395","10396","10397","10398","10399","10400","10401","10402","10403","10404","10405","10406","10407","10408","10409","10410","10411","10412","10413","10414","10415","10416","10417","10418","10419","10420","10421","10422","10423","10424","10425","10426","10427","10428","10429","10430","10431","10432","10433","10434","10435","10436","10437","10438","10439","10440","10441","10442","10443","10444","10445","10446","10447","10448","10449","10450","10451","10452","10453","10454","10455","10456","10457","10458","10459","10460","10461","10462","10463","10464","10465","10466","10467","10468","10469","10470","10471","10472","10473","10474","10475","10476","10477","10478","10479","10480","10481","10482","10483","10484","10485","10486","10487","10488","10489","10490","10491","10492","10493","10494","10495","10496","10497","10498","10499","10500","10501","10502","10503","10504","10505","10506","10507","10508","10509","10510","10511","10512","10513","10514","10515","10516","10517","10518","10519","10520","10521","10522","10523","10524","10525","10526","10527","10528","10529","10530","10531","10532","10533","10534","10535","10536","10537","10538","10539","10540","10541","10542","10543","10544","10545","10546","10547","10548","10549","10550","10551","10552","10553","10554","10555","10556","10557","10558","10559","10560","10561","10562","10563","10564","10565","10566","10567","10568","10569","10570","10571","10572","10573","10574","10575","10576","10577","10578","10579","10580","10581","10582","10583","10584","10585","10586","10587","10588","10589","10590","10591","10592","10593","10594","10595","10596","10597","10598","10599","10600","10601","10602","10603","10604","10605","10606","10607","10608","10609","10610","10611","10612","10613","10614","10615","10616","10617","10618","10619","10620","10621","10622","10623","10624","10625","10626","10627","10628","10629","10630","10631","10632","10633","10634","10635","10636","10637","10638","10639","10640","10641","10642","10643","10644","10645","10646","10647","10648","10649","10650","10651","10652","10653","10654","10655","10656","10657","10658","10659","10660","10661","10662","10663","10664","10665","10666","10667","10668","10669","10670","10671","10672","10673","10674","10675","10676","10677","10678","10679","10680","10681","10682","10683","10684","10685","10686","10687","10688","10689","10690","10691","10692","10693","10694","10695","10696","10697","10698","10699","10700","10701","10702","10703","10704","10705","10706","10707","10708","10709","10710","10711","10712","10713","10714","10715","10716","10717","10718","10719","10720","10721","10722","10723","10724","10725","10726","10727","10728","10729","10730","10731","10732","10733","10734","10735","10736","10737","10738","10739","10740","10741","10742","10743","10744","10745","10746","10747","10748","10749","10750","10751","10752","10753","10754","10755","10756","10757","10758","10759","10760","10761","10762","10763","10764","10765","10766","10767","10768","10769","10770","10771","10772","10773","10774","10775","10776","10777","10778","10779","10780","10781","10782","10783","10784","10785","10786","10787","10788","10789","10790","10791","10792","10793","10794","10795","10796","10797","10798","10799","10800","10801","10802","10803","10804","10805","10806","10807","10808","10809","10810","10811","10812","10813","10814","10815","10816","10817","10818","10819","10820","10821","10822","10823","10824","10825","10826","10827","10828","10829","10830","10831","10832","10833","10834","10835","10836","10837","10838","10839","10840","10841","10842","10843","10844","10845","10846","10847","10848","10849","10850","10851","10852","10853","10854","10855","10856","10857","10858","10859","10860","10861","10862","10863","10864","10865","10866","10867","10868","10869","10870","10871","10872","10873","10874","10875","10876","10877","10878","10879","10880","10881","10882","10883","10884","10885","10886","10887","10888","10889","10890","10891","10892","10893","10894","10895","10896","10897","10898","10899","10900","10901","10902","10903","10904","10905","10906","10907","10908","10909","10910","10911","10912","10913","10914","10915","10916","10917","10918","10919","10920","10921","10922","10923","10924","10925","10926","10927","10928","10929","10930","10931","10932","10933","10934","10935","10936","10937","10938","10939","10940","10941","10942","10943","10944","10945","10946","10947","10948","10949","10950","10951","10952","10953","10954","10955","10956","10957","10958","10959","10960","10961","10962","10963","10964","10965","10966","10967","10968","10969","10970","10971","10972","10973","10974","10975","10976","10977","10978","10979","10980","10981","10982","10983","10984","10985","10986","10987","10988","10989","10990","10991","10992","10993","10994","10995","10996","10997","10998","10999","11000","11001","11002","11003","11004","11005","11006","11007","11008","11009","11010","11011","11012","11013","11014","11015","11016","11017","11018","11019","11020","11021","11022","11023","11024","11025","11026","11027","11028","11029","11030","11031","11032","11033","11034","11035","11036","11037","11038","11039","11040","11041","11042","11043","11044","11045","11046","11047","11048","11049","11050","11051","11052","11053","11054","11055","11056","11057","11058","11059","11060","11061","11062","11063","11064","11065","11066","11067","11068","11069","11070","11071","11072","11073","11074","11075","11076","11077","11078","11079","11080","11081","11082","11083","11084","11085","11086","11087","11088","11089","11090","11091","11092","11093","11094","11095","11096","11097","11098","11099","11100","11101","11102","11103","11104","11105","11106","11107","11108","11109","11110","11111","11112","11113","11114","11115","11116","11117","11118","11119","11120","11121","11122","11123","11124","11125","11126","11127","11128","11129","11130","11131","11132","11133","11134","11135","11136","11137","11138","11139","11140","11141","11142","11143","11144","11145","11146","11147","11148","11149","11150","11151","11152","11153","11154","11155","11156","11157","11158","11159","11160","11161","11162","11163","11164","11165","11166","11167","11168","11169","11170","11171","11172","11173","11174","11175","11176","11177","11178","11179","11180","11181","11182","11183","11184","11185","11186","11187","11188","11189","11190","11191","11192","11193","11194","11195","11196","11197","11198","11199","11200","11201","11202","11203","11204","11205","11206","11207","11208","11209","11210","11211","11212","11213","11214","11215","11216","11217","11218","11219","11220","11221","11222","11223","11224","11225","11226","11227","11228","11229","11230","11231","11232","11233","11234","11235","11236","11237","11238","11239","11240","11241","11242","11243","11244","11245","11246","11247","11248","11249","11250","11251","11252","11253","11254","11255","11256","11257","11258","11259","11260","11261","11262","11263","11264","11265","11266","11267","11268","11269","11270","11271","11272","11273","11274","11275","11276","11277","11278","11279","11280","11281","11282","11283","11284","11285","11286","11287","11288","11289","11290","11291","11292","11293","11294","11295","11296","11297","11298","11299","11300","11301","11302","11303","11304","11305","11306","11307","11308","11309","11310","11311","11312","11313","11314","11315","11316","11317","11318","11319","11320","11321","11322","11323","11324","11325","11326","11327","11328","11329","11330","11331","11332","11333","11334","11335","11336","11337","11338","11339","11340","11341","11342","11343","11344","11345","11346","11347","11348","11349","11350","11351","11352","11353","11354","11355","11356","11357","11358","11359","11360","11361","11362","11363","11364","11365","11366","11367","11368","11369","11370","11371","11372","11373","11374","11375","11376","11377","11378","11379","11380","11381","11382","11383","11384","11385","11386","11387","11388","11389","11390","11391","11392","11393","11394","11395","11396","11397","11398","11399","11400","11401","11402","11403","11404","11405","11406","11407","11408","11409","11410","11411","11412","11413","11414","11415","11416","11417","11418","11419","11420","11421","11422","11423","11424","11425","11426","11427","11428","11429","11430","11431","11432","11433","11434","11435","11436","11437","11438","11439","11440","11441","11442","11443","11444","11445","11446","11447","11448","11449","11450","11451","11452","11453","11454","11455","11456","11457","11458","11459","11460","11461","11462","11463","11464","11465","11466","11467","11468","11469","11470","11471","11472","11473","11474","11475","11476","11477","11478","11479","11480","11481","11482","11483","11484","11485","11486","11487","11488","11489","11490","11491","11492","11493","11494","11495","11496","11497","11498","11499","11500","11501","11502","11503","11504","11505","11506","11507","11508","11509","11510","11511","11512","11513","11514","11515","11516","11517","11518","11519","11520","11521","11522","11523","11524","11525","11526","11527","11528","11529","11530","11531","11532","11533","11534","11535","11536","11537","11538","11539","11540","11541","11542","11543","11544","11545","11546","11547","11548","11549","11550","11551","11552","11553","11554","11555","11556","11557","11558","11559","11560","11561","11562","11563","11564","11565","11566","11567","11568","11569","11570","11571","11572","11573","11574","11575","11576","11577","11578","11579","11580","11581","11582","11583","11584","11585","11586","11587","11588","11589","11590","11591","11592","11593","11594","11595","11596","11597","11598","11599","11600","11601","11602","11603","11604","11605","11606","11607","11608","11609","11610","11611","11612","11613","11614","11615","11616","11617","11618","11619","11620","11621","11622","11623","11624","11625","11626","11627","11628","11629","11630","11631","11632","11633","11634","11635","11636","11637","11638","11639","11640","11641","11642","11643","11644","11645","11646","11647","11648","11649","11650","11651","11652","11653","11654","11655","11656","11657","11658","11659","11660","11661","11662","11663","11664","11665","11666","11667","11668","11669","11670","11671","11672","11673","11674","11675","11676","11677","11678","11679","11680","11681","11682","11683","11684","11685","11686","11687","11688","11689","11690","11691","11692","11693","11694","11695","11696","11697","11698","11699","11700","11701","11702","11703","11704","11705","11706","11707","11708","11709","11710","11711","11712","11713","11714","11715","11716","11717","11718","11719","11720","11721","11722","11723","11724","11725","11726","11727","11728","11729","11730","11731","11732","11733","11734","11735","11736","11737","11738","11739","11740","11741","11742","11743","11744","11745","11746","11747","11748","11749","11750","11751","11752","11753","11754","11755","11756","11757","11758","11759","11760","11761","11762","11763","11764","11765","11766","11767","11768","11769","11770","11771","11772","11773","11774","11775","11776","11777","11778","11779","11780","11781","11782","11783","11784","11785","11786","11787","11788","11789","11790","11791","11792","11793","11794","11795","11796","11797","11798","11799","11800","11801","11802","11803","11804","11805","11806","11807","11808","11809","11810","11811","11812","11813","11814","11815","11816","11817","11818","11819","11820","11821","11822","11823","11824","11825","11826","11827","11828","11829","11830","11831","11832","11833","11834","11835","11836","11837","11838","11839","11840","11841","11842","11843","11844","11845","11846","11847","11848","11849","11850","11851","11852","11853","11854","11855","11856","11857","11858","11859","11860","11861","11862","11863","11864","11865","11866","11867","11868","11869","11870","11871","11872","11873","11874","11875","11876","11877","11878","11879","11880","11881","11882","11883","11884","11885","11886","11887","11888","11889","11890","11891","11892","11893","11894","11895","11896","11897","11898","11899","11900","11901","11902","11903","11904","11905","11906","11907","11908","11909","11910","11911","11912","11913","11914","11915","11916","11917","11918","11919","11920","11921","11922","11923","11924","11925","11926","11927","11928","11929","11930","11931","11932","11933","11934","11935","11936","11937","11938","11939","11940","11941","11942","11943","11944","11945","11946","11947","11948","11949","11950","11951","11952","11953","11954","11955","11956","11957","11958","11959","11960","11961","11962","11963","11964","11965","11966","11967","11968","11969","11970","11971","11972","11973","11974","11975","11976","11977","11978","11979","11980","11981","11982","11983","11984","11985","11986","11987","11988","11989","11990","11991","11992","11993","11994","11995","11996","11997","11998","11999","12000","12001","12002","12003","12004","12005","12006","12007","12008","12009","12010","12011","12012","12013","12014","12015","12016","12017","12018","12019","12020","12021","12022","12023","12024","12025","12026","12027","12028","12029","12030","12031","12032","12033","12034","12035","12036","12037","12038","12039","12040","12041","12042","12043","12044","12045","12046","12047","12048","12049","12050","12051","12052","12053","12054","12055","12056","12057","12058","12059","12060","12061","12062","12063","12064","12065","12066","12067","12068","12069","12070","12071","12072","12073","12074","12075","12076","12077","12078","12079","12080","12081","12082","12083","12084","12085","12086","12087","12088","12089","12090","12091","12092","12093","12094","12095","12096","12097","12098","12099","12100","12101","12102","12103","12104","12105","12106","12107","12108","12109","12110","12111","12112","12113","12114","12115","12116","12117","12118","12119","12120","12121","12122","12123","12124","12125","12126","12127","12128","12129","12130","12131","12132","12133","12134","12135","12136","12137","12138","12139","12140","12141","12142","12143","12144","12145","12146","12147","12148","12149","12150","12151","12152","12153","12154","12155","12156","12157","12158","12159","12160","12161","12162","12163","12164","12165","12166","12167","12168","12169","12170","12171","12172","12173","12174","12175","12176","12177","12178","12179","12180","12181","12182","12183","12184","12185","12186","12187","12188","12189","12190","12191","12192","12193","12194","12195","12196","12197","12198","12199","12200","12201","12202","12203","12204","12205","12206","12207","12208","12209","12210","12211","12212","12213","12214","12215","12216","12217","12218","12219","12220","12221","12222","12223","12224","12225","12226","12227","12228","12229","12230","12231","12232","12233","12234","12235","12236","12237","12238","12239","12240","12241","12242","12243","12244","12245","12246","12247","12248","12249","12250","12251","12252","12253","12254","12255","12256","12257","12258","12259","12260","12261","12262","12263","12264","12265","12266","12267","12268","12269","12270","12271","12272","12273","12274","12275","12276","12277","12278","12279","12280","12281","12282","12283","12284","12285","12286","12287","12288","12289","12290","12291","12292","12293","12294","12295","12296","12297","12298","12299","12300","12301","12302","12303","12304","12305","12306","12307","12308","12309","12310","12311","12312","12313","12314","12315","12316","12317","12318","12319","12320","12321","12322","12323","12324","12325","12326","12327","12328","12329","12330","12331","12332","12333","12334","12335","12336","12337","12338","12339","12340","12341","12342","12343","12344","12345","12346","12347","12348","12349","12350","12351","12352","12353","12354","12355","12356","12357","12358","12359","12360","12361","12362","12363","12364","12365","12366","12367","12368","12369","12370","12371","12372","12373","12374","12375","12376","12377","12378","12379","12380","12381","12382","12383","12384","12385","12386","12387","12388","12389","12390","12391","12392","12393","12394","12395","12396","12397","12398","12399","12400","12401","12402","12403","12404","12405","12406","12407","12408","12409","12410","12411","12412","12413","12414","12415","12416","12417","12418","12419","12420","12421","12422","12423","12424","12425","12426","12427","12428","12429","12430","12431","12432","12433","12434","12435","12436","12437","12438","12439","12440","12441","12442","12443","12444","12445","12446","12447","12448","12449","12450","12451","12452","12453","12454","12455","12456","12457","12458","12459","12460","12461","12462","12463","12464","12465","12466","12467","12468","12469","12470","12471","12472","12473","12474","12475","12476","12477","12478","12479","12480","12481","12482","12483","12484","12485","12486","12487","12488","12489","12490","12491","12492","12493","12494","12495","12496","12497","12498","12499","12500","12501","12502","12503","12504","12505","12506","12507","12508","12509","12510","12511","12512","12513","12514","12515","12516","12517","12518","12519","12520","12521","12522","12523","12524","12525","12526","12527","12528","12529","12530","12531","12532","12533","12534","12535","12536","12537","12538","12539","12540","12541","12542","12543","12544","12545","12546","12547","12548","12549","12550","12551","12552","12553","12554","12555","12556","12557","12558","12559","12560","12561","12562","12563","12564","12565","12566","12567","12568","12569","12570","12571","12572","12573","12574","12575","12576","12577","12578","12579","12580","12581","12582","12583","12584","12585","12586","12587","12588","12589","12590","12591","12592","12593","12594","12595","12596","12597","12598","12599","12600","12601","12602","12603","12604","12605","12606","12607","12608","12609","12610","12611","12612","12613","12614","12615","12616","12617","12618","12619","12620","12621","12622","12623","12624","12625","12626","12627","12628","12629","12630","12631","12632","12633","12634","12635","12636","12637","12638","12639","12640","12641","12642","12643","12644","12645","12646","12647","12648","12649","12650","12651","12652","12653","12654","12655","12656","12657","12658","12659","12660","12661","12662","12663","12664","12665","12666","12667","12668","12669","12670","12671","12672","12673","12674","12675","12676","12677","12678","12679","12680","12681","12682","12683","12684","12685","12686","12687","12688","12689","12690","12691","12692","12693","12694","12695","12696","12697","12698","12699","12700","12701","12702","12703","12704","12705","12706","12707","12708","12709","12710","12711","12712","12713","12714","12715","12716","12717","12718","12719","12720","12721","12722","12723","12724","12725","12726","12727","12728","12729","12730","12731","12732","12733","12734","12735","12736","12737","12738","12739","12740","12741","12742","12743","12744","12745","12746","12747","12748","12749","12750","12751","12752","12753","12754","12755","12756","12757","12758","12759","12760","12761","12762","12763","12764","12765","12766","12767","12768","12769","12770","12771","12772","12773","12774","12775","12776","12777","12778","12779","12780","12781","12782","12783","12784","12785","12786","12787","12788","12789","12790","12791","12792","12793","12794","12795","12796","12797","12798","12799","12800","12801","12802","12803","12804","12805","12806","12807","12808","12809","12810","12811","12812","12813","12814","12815","12816","12817","12818","12819","12820","12821","12822","12823","12824","12825","12826","12827","12828","12829","12830","12831","12832","12833","12834","12835","12836","12837","12838","12839","12840","12841","12842","12843","12844","12845","12846","12847","12848","12849","12850","12851","12852","12853","12854","12855","12856","12857","12858","12859","12860","12861","12862","12863","12864","12865","12866","12867","12868","12869","12870","12871","12872","12873","12874","12875","12876","12877","12878","12879","12880","12881","12882","12883","12884","12885","12886","12887","12888","12889","12890","12891","12892","12893","12894","12895","12896","12897","12898","12899","12900","12901","12902","12903","12904","12905","12906","12907","12908","12909","12910","12911","12912","12913","12914","12915","12916","12917","12918","12919","12920","12921","12922","12923","12924","12925","12926","12927","12928","12929","12930","12931","12932","12933","12934","12935","12936","12937","12938","12939","12940","12941","12942","12943","12944","12945","12946","12947","12948","12949","12950","12951","12952","12953","12954","12955","12956","12957","12958","12959","12960","12961","12962","12963","12964","12965","12966","12967","12968","12969","12970","12971","12972","12973","12974","12975","12976","12977","12978","12979","12980","12981","12982","12983","12984","12985","12986","12987","12988","12989","12990","12991","12992","12993","12994","12995","12996","12997","12998","12999","13000","13001","13002","13003","13004","13005","13006","13007","13008","13009","13010","13011","13012","13013","13014","13015","13016","13017","13018","13019","13020","13021","13022","13023","13024","13025","13026","13027","13028","13029","13030","13031","13032","13033","13034","13035","13036","13037","13038","13039","13040","13041","13042","13043","13044","13045","13046","13047","13048","13049","13050","13051","13052","13053","13054","13055","13056","13057","13058","13059","13060","13061","13062","13063","13064","13065","13066","13067","13068","13069","13070","13071","13072","13073","13074","13075","13076","13077","13078","13079","13080","13081","13082","13083","13084","13085","13086","13087","13088","13089","13090","13091","13092","13093","13094","13095","13096","13097","13098","13099","13100","13101","13102","13103","13104","13105","13106","13107","13108","13109","13110","13111","13112","13113","13114","13115","13116","13117","13118","13119","13120","13121","13122","13123","13124","13125","13126","13127","13128","13129","13130","13131","13132","13133","13134","13135","13136","13137","13138","13139","13140","13141","13142","13143","13144","13145","13146","13147","13148","13149","13150","13151","13152","13153","13154","13155","13156","13157","13158","13159","13160","13161","13162","13163","13164","13165","13166","13167","13168","13169","13170","13171","13172","13173","13174","13175","13176","13177","13178","13179","13180","13181","13182","13183","13184","13185","13186","13187","13188","13189","13190","13191","13192","13193","13194","13195","13196","13197","13198","13199","13200","13201","13202","13203","13204","13205","13206","13207","13208","13209","13210","13211","13212","13213","13214","13215","13216","13217","13218","13219","13220","13221","13222","13223","13224","13225","13226","13227","13228","13229","13230","13231","13232","13233","13234","13235","13236","13237","13238","13239","13240","13241","13242","13243","13244","13245","13246","13247","13248","13249","13250","13251","13252","13253","13254","13255","13256","13257","13258","13259","13260","13261","13262","13263","13264","13265","13266","13267","13268","13269","13270","13271","13272","13273","13274","13275","13276","13277","13278","13279","13280","13281","13282","13283","13284","13285","13286","13287","13288","13289","13290","13291","13292","13293","13294","13295","13296","13297","13298","13299","13300","13301","13302","13303","13304","13305","13306","13307","13308","13309","13310","13311","13312","13313","13314","13315","13316","13317","13318","13319","13320","13321","13322","13323","13324","13325","13326","13327","13328","13329","13330","13331","13332","13333","13334","13335","13336","13337","13338","13339","13340","13341","13342","13343","13344","13345","13346","13347","13348","13349","13350","13351","13352","13353","13354","13355","13356","13357","13358","13359","13360","13361","13362","13363","13364","13365","13366","13367","13368","13369","13370","13371","13372","13373","13374","13375","13376","13377","13378","13379","13380","13381","13382","13383","13384","13385","13386","13387","13388","13389","13390","13391","13392","13393","13394","13395","13396","13397","13398","13399","13400","13401","13402","13403","13404","13405","13406","13407","13408","13409","13410","13411","13412","13413","13414","13415","13416","13417","13418","13419","13420","13421","13422","13423","13424","13425","13426","13427","13428","13429","13430","13431","13432","13433","13434","13435","13436","13437","13438","13439","13440","13441","13442","13443","13444","13445","13446","13447","13448","13449","13450","13451","13452","13453","13454","13455","13456","13457","13458","13459","13460","13461","13462","13463","13464","13465","13466","13467","13468","13469","13470","13471","13472","13473","13474","13475","13476","13477","13478","13479","13480","13481","13482","13483","13484","13485","13486","13487","13488","13489","13490","13491","13492","13493","13494","13495","13496","13497","13498","13499","13500","13501","13502","13503","13504","13505","13506","13507","13508","13509","13510","13511","13512","13513","13514","13515","13516","13517","13518","13519","13520","13521","13522","13523","13524","13525","13526","13527","13528","13529","13530","13531","13532","13533","13534","13535","13536","13537","13538","13539","13540","13541","13542","13543","13544","13545","13546","13547","13548","13549","13550","13551","13552","13553","13554","13555","13556","13557","13558","13559","13560","13561","13562","13563","13564","13565","13566","13567","13568","13569","13570","13571","13572","13573","13574","13575","13576","13577","13578","13579","13580","13581","13582","13583","13584","13585","13586","13587","13588","13589","13590","13591","13592","13593","13594","13595","13596","13597","13598","13599","13600","13601","13602","13603","13604","13605","13606","13607","13608","13609","13610","13611","13612","13613","13614","13615","13616","13617","13618","13619","13620","13621","13622","13623","13624","13625","13626","13627","13628","13629","13630","13631","13632","13633","13634","13635","13636","13637","13638","13639","13640","13641","13642","13643","13644","13645","13646","13647","13648","13649","13650","13651","13652","13653","13654","13655","13656","13657","13658","13659","13660","13661","13662","13663","13664","13665","13666","13667","13668","13669","13670","13671","13672","13673","13674","13675","13676","13677","13678","13679","13680","13681","13682","13683","13684","13685","13686","13687","13688","13689","13690","13691","13692","13693","13694","13695","13696","13697","13698","13699","13700","13701","13702","13703","13704","13705","13706","13707","13708","13709","13710","13711","13712","13713","13714","13715","13716","13717","13718","13719","13720","13721","13722","13723","13724","13725","13726","13727","13728","13729","13730","13731","13732","13733","13734","13735","13736","13737","13738","13739","13740","13741","13742","13743","13744","13745","13746","13747","13748","13749","13750","13751","13752","13753","13754","13755","13756","13757","13758","13759","13760","13761","13762","13763","13764","13765","13766","13767","13768","13769","13770","13771","13772","13773","13774","13775","13776","13777","13778","13779","13780","13781","13782","13783","13784","13785","13786","13787","13788","13789","13790","13791","13792","13793","13794","13795","13796","13797","13798","13799","13800","13801","13802","13803","13804","13805","13806","13807","13808","13809","13810","13811","13812","13813","13814","13815","13816","13817","13818","13819","13820","13821","13822","13823","13824","13825","13826","13827","13828","13829","13830","13831","13832","13833","13834","13835","13836","13837","13838","13839","13840","13841","13842","13843","13844","13845","13846","13847","13848","13849","13850","13851","13852","13853","13854","13855","13856","13857","13858","13859","13860","13861","13862","13863","13864","13865","13866","13867","13868","13869","13870","13871","13872","13873","13874","13875","13876","13877","13878","13879","13880","13881","13882","13883","13884","13885","13886","13887","13888","13889","13890","13891","13892","13893","13894","13895","13896","13897","13898","13899","13900","13901","13902","13903","13904","13905","13906","13907","13908","13909","13910","13911","13912","13913","13914","13915","13916","13917","13918","13919","13920","13921","13922","13923","13924","13925","13926","13927","13928","13929","13930","13931","13932","13933","13934","13935","13936","13937","13938","13939","13940","13941","13942","13943","13944","13945","13946","13947","13948","13949","13950","13951","13952","13953","13954","13955","13956","13957","13958","13959","13960","13961","13962","13963","13964","13965","13966","13967","13968","13969","13970","13971","13972","13973","13974","13975","13976","13977","13978","13979","13980","13981","13982","13983","13984","13985","13986","13987","13988","13989","13990","13991","13992","13993","13994","13995","13996","13997","13998","13999","14000","14001","14002","14003","14004","14005","14006","14007","14008","14009","14010","14011","14012","14013","14014","14015","14016","14017","14018","14019","14020","14021","14022","14023","14024","14025","14026","14027","14028","14029","14030","14031","14032","14033","14034","14035","14036","14037","14038","14039","14040","14041","14042","14043","14044","14045","14046","14047","14048","14049","14050","14051","14052","14053","14054","14055","14056","14057","14058","14059","14060","14061","14062","14063","14064","14065","14066","14067","14068","14069","14070","14071","14072","14073","14074","14075","14076","14077","14078","14079","14080","14081","14082","14083","14084","14085","14086","14087","14088","14089","14090","14091","14092","14093","14094","14095","14096","14097","14098","14099","14100","14101","14102","14103","14104","14105","14106","14107","14108","14109","14110","14111","14112","14113","14114","14115","14116","14117","14118","14119","14120","14121","14122","14123","14124","14125","14126","14127","14128","14129","14130","14131","14132","14133","14134","14135","14136","14137","14138","14139","14140","14141","14142","14143","14144","14145","14146","14147","14148","14149","14150","14151","14152","14153","14154","14155","14156","14157","14158","14159","14160","14161","14162","14163","14164","14165","14166","14167","14168","14169","14170","14171","14172","14173","14174","14175","14176","14177","14178","14179","14180","14181","14182","14183","14184","14185","14186","14187","14188","14189","14190","14191","14192","14193","14194","14195","14196","14197","14198","14199","14200","14201","14202","14203","14204","14205","14206","14207","14208","14209","14210","14211","14212","14213","14214","14215","14216","14217","14218","14219","14220","14221","14222","14223","14224","14225","14226","14227","14228","14229","14230","14231","14232","14233","14234","14235","14236","14237","14238","14239","14240","14241","14242","14243","14244","14245","14246","14247","14248","14249","14250","14251","14252","14253","14254","14255","14256","14257","14258","14259","14260","14261","14262","14263","14264","14265","14266","14267","14268","14269","14270","14271","14272","14273","14274","14275","14276","14277","14278","14279","14280","14281","14282","14283","14284","14285","14286","14287","14288","14289","14290","14291","14292","14293","14294","14295","14296","14297","14298","14299","14300","14301","14302","14303","14304","14305","14306","14307","14308","14309","14310","14311","14312","14313","14314","14315","14316","14317","14318","14319","14320","14321","14322","14323","14324","14325","14326","14327","14328","14329","14330","14331","14332","14333","14334","14335","14336","14337","14338","14339","14340","14341","14342","14343","14344","14345","14346","14347","14348","14349","14350","14351","14352","14353","14354","14355","14356","14357","14358","14359","14360","14361","14362","14363","14364","14365","14366","14367","14368","14369","14370","14371","14372","14373","14374","14375","14376","14377","14378","14379","14380","14381","14382","14383","14384","14385","14386","14387","14388","14389","14390","14391","14392","14393","14394","14395","14396","14397","14398","14399","14400","14401","14402","14403","14404","14405","14406","14407","14408","14409","14410","14411","14412","14413","14414","14415","14416","14417","14418","14419","14420","14421","14422","14423","14424","14425","14426","14427","14428","14429","14430","14431","14432","14433","14434","14435","14436","14437","14438","14439","14440","14441","14442","14443","14444","14445","14446","14447","14448","14449","14450","14451","14452","14453","14454","14455","14456","14457","14458","14459","14460","14461","14462","14463","14464","14465","14466","14467","14468","14469","14470","14471","14472","14473","14474","14475","14476","14477","14478","14479","14480","14481","14482","14483","14484","14485","14486","14487","14488","14489","14490","14491","14492","14493","14494","14495","14496","14497","14498","14499","14500","14501","14502","14503","14504","14505","14506","14507","14508","14509","14510","14511","14512","14513","14514","14515","14516","14517","14518","14519","14520","14521","14522","14523","14524","14525","14526","14527","14528","14529","14530","14531","14532","14533","14534","14535","14536","14537","14538","14539","14540","14541","14542","14543","14544","14545","14546","14547","14548","14549","14550","14551","14552","14553","14554","14555","14556","14557","14558","14559","14560","14561","14562","14563","14564","14565","14566","14567","14568","14569","14570","14571","14572","14573","14574","14575","14576","14577","14578","14579","14580","14581","14582","14583","14584","14585","14586","14587","14588","14589","14590","14591","14592","14593","14594","14595","14596","14597","14598","14599","14600","14601","14602","14603","14604","14605","14606","14607","14608","14609","14610","14611","14612","14613","14614","14615","14616","14617","14618","14619","14620","14621","14622","14623","14624","14625","14626","14627","14628","14629","14630","14631","14632","14633","14634","14635","14636","14637","14638","14639","14640","14641","14642","14643","14644","14645","14646","14647","14648","14649","14650","14651","14652","14653","14654","14655","14656","14657","14658","14659","14660","14661","14662","14663","14664","14665","14666","14667","14668","14669","14670","14671","14672","14673","14674","14675","14676","14677","14678","14679","14680","14681","14682","14683","14684","14685","14686","14687","14688","14689","14690","14691","14692","14693","14694","14695","14696","14697","14698","14699","14700","14701","14702","14703","14704","14705","14706","14707","14708","14709","14710","14711","14712","14713","14714","14715","14716","14717","14718","14719","14720","14721","14722","14723","14724","14725","14726","14727","14728","14729","14730","14731","14732","14733","14734","14735","14736","14737","14738","14739","14740","14741","14742","14743","14744","14745","14746","14747","14748","14749","14750","14751","14752","14753","14754","14755","14756","14757","14758","14759","14760","14761","14762","14763","14764","14765","14766","14767","14768","14769","14770","14771","14772","14773","14774","14775","14776","14777","14778","14779","14780","14781","14782","14783","14784","14785","14786","14787","14788","14789","14790","14791","14792","14793","14794","14795","14796","14797","14798","14799","14800","14801","14802","14803","14804","14805","14806","14807","14808","14809","14810","14811","14812","14813","14814","14815","14816","14817","14818","14819","14820","14821","14822","14823","14824","14825","14826","14827","14828","14829","14830","14831","14832","14833","14834","14835","14836","14837","14838","14839","14840","14841","14842","14843","14844","14845","14846","14847","14848","14849","14850","14851","14852","14853","14854","14855","14856","14857","14858","14859","14860","14861","14862","14863","14864","14865","14866","14867","14868","14869","14870","14871","14872","14873","14874","14875","14876","14877","14878","14879","14880","14881","14882","14883","14884","14885","14886","14887","14888","14889","14890","14891","14892","14893","14894","14895","14896","14897","14898","14899","14900","14901","14902","14903","14904","14905","14906","14907","14908","14909","14910","14911","14912","14913","14914","14915","14916","14917","14918","14919","14920","14921","14922","14923","14924","14925","14926","14927","14928","14929","14930","14931","14932","14933","14934","14935","14936","14937","14938","14939","14940","14941","14942","14943","14944","14945","14946","14947","14948","14949","14950","14951","14952","14953","14954","14955","14956","14957","14958","14959","14960","14961","14962","14963","14964","14965","14966","14967","14968","14969","14970","14971","14972","14973","14974","14975","14976","14977","14978","14979","14980","14981","14982","14983","14984","14985","14986","14987","14988","14989","14990","14991","14992","14993","14994","14995","14996","14997","14998","14999","15000","15001","15002","15003","15004","15005","15006","15007","15008","15009","15010","15011","15012","15013","15014","15015","15016","15017","15018","15019","15020","15021","15022","15023","15024","15025","15026","15027","15028","15029","15030","15031","15032","15033","15034","15035","15036","15037","15038","15039","15040","15041","15042","15043","15044","15045","15046","15047","15048","15049","15050","15051","15052","15053","15054","15055","15056","15057","15058","15059","15060","15061","15062","15063","15064","15065","15066","15067","15068","15069","15070","15071","15072","15073","15074","15075","15076","15077","15078","15079","15080","15081","15082","15083","15084","15085","15086","15087","15088","15089","15090","15091","15092","15093","15094","15095","15096","15097","15098","15099","15100","15101","15102","15103","15104","15105","15106","15107","15108","15109","15110","15111","15112","15113","15114","15115","15116","15117","15118","15119","15120","15121","15122","15123","15124","15125","15126","15127","15128","15129","15130","15131","15132","15133","15134","15135","15136","15137","15138","15139","15140","15141","15142","15143","15144","15145","15146","15147","15148","15149","15150","15151","15152","15153","15154","15155","15156","15157","15158","15159","15160","15161","15162","15163","15164","15165","15166","15167","15168","15169","15170","15171","15172","15173","15174","15175","15176","15177","15178","15179","15180","15181","15182","15183","15184","15185","15186","15187","15188","15189","15190","15191","15192","15193","15194","15195","15196","15197","15198","15199","15200","15201","15202","15203","15204","15205","15206","15207","15208","15209","15210","15211","15212","15213","15214","15215","15216","15217","15218","15219","15220","15221","15222","15223","15224","15225","15226","15227","15228","15229","15230","15231","15232","15233","15234","15235","15236","15237","15238","15239","15240","15241","15242","15243","15244","15245","15246","15247","15248","15249","15250","15251","15252","15253","15254","15255","15256","15257","15258","15259","15260","15261","15262","15263","15264","15265","15266","15267","15268","15269","15270","15271","15272","15273","15274","15275","15276","15277","15278","15279","15280","15281","15282","15283","15284","15285","15286","15287","15288","15289","15290","15291","15292","15293","15294","15295","15296","15297","15298","15299","15300","15301","15302","15303","15304","15305","15306","15307","15308","15309","15310","15311","15312","15313","15314","15315","15316","15317","15318","15319","15320","15321","15322","15323","15324","15325","15326","15327","15328","15329","15330","15331","15332","15333","15334","15335","15336","15337","15338","15339","15340","15341","15342","15343","15344","15345","15346","15347","15348","15349","15350","15351","15352","15353","15354","15355","15356","15357","15358","15359","15360","15361","15362","15363","15364","15365","15366","15367","15368","15369","15370","15371","15372","15373","15374","15375","15376","15377","15378","15379","15380","15381","15382","15383","15384","15385","15386","15387","15388","15389","15390","15391","15392","15393","15394","15395","15396","15397","15398","15399","15400","15401","15402","15403","15404","15405","15406","15407","15408","15409","15410","15411","15412","15413","15414","15415","15416","15417","15418","15419","15420","15421","15422","15423","15424","15425","15426","15427","15428","15429","15430","15431","15432","15433","15434","15435","15436","15437","15438","15439","15440","15441","15442","15443","15444","15445","15446","15447","15448","15449","15450","15451","15452","15453","15454","15455","15456","15457","15458","15459","15460","15461","15462","15463","15464","15465","15466","15467","15468","15469","15470","15471","15472","15473","15474","15475","15476","15477","15478","15479","15480","15481","15482","15483","15484","15485","15486","15487","15488","15489","15490","15491","15492","15493","15494","15495","15496","15497","15498","15499","15500","15501","15502","15503","15504","15505","15506","15507","15508","15509","15510","15511","15512","15513","15514","15515","15516","15517","15518","15519","15520","15521","15522","15523","15524","15525","15526","15527","15528","15529","15530","15531","15532","15533","15534","15535","15536","15537","15538","15539","15540","15541","15542","15543","15544","15545","15546","15547","15548","15549","15550","15551","15552","15553","15554","15555","15556","15557","15558","15559","15560","15561","15562","15563","15564","15565","15566","15567","15568","15569","15570","15571","15572","15573","15574","15575","15576","15577","15578","15579","15580","15581","15582","15583","15584","15585","15586","15587","15588","15589","15590","15591","15592","15593","15594","15595","15596","15597","15598","15599","15600","15601","15602","15603","15604","15605","15606","15607","15608","15609","15610","15611","15612","15613","15614","15615","15616","15617","15618","15619","15620","15621","15622","15623","15624","15625","15626","15627","15628","15629","15630","15631","15632","15633","15634","15635","15636","15637","15638","15639","15640","15641","15642","15643","15644","15645","15646","15647","15648","15649","15650","15651","15652","15653","15654","15655","15656","15657","15658","15659","15660","15661","15662","15663","15664","15665","15666","15667","15668","15669","15670","15671","15672","15673","15674","15675","15676","15677","15678","15679","15680","15681","15682","15683","15684","15685","15686","15687","15688","15689","15690","15691","15692","15693","15694","15695","15696","15697","15698","15699","15700","15701","15702","15703","15704","15705","15706","15707","15708","15709","15710","15711","15712","15713","15714","15715","15716","15717","15718","15719","15720","15721","15722","15723","15724","15725","15726","15727","15728","15729","15730","15731","15732","15733","15734","15735","15736","15737","15738","15739","15740","15741","15742","15743","15744","15745","15746","15747","15748","15749","15750","15751","15752","15753","15754","15755","15756","15757","15758","15759","15760","15761","15762","15763","15764","15765","15766","15767","15768","15769","15770","15771","15772","15773","15774","15775","15776","15777","15778","15779","15780","15781","15782","15783","15784","15785","15786","15787","15788","15789","15790","15791","15792","15793","15794","15795","15796","15797","15798","15799","15800","15801","15802","15803","15804","15805","15806","15807","15808","15809","15810","15811","15812","15813","15814","15815","15816","15817","15818","15819","15820","15821","15822","15823","15824","15825","15826","15827","15828","15829","15830","15831","15832","15833","15834","15835","15836","15837","15838","15839","15840","15841","15842","15843","15844","15845","15846","15847","15848","15849","15850","15851","15852","15853","15854","15855","15856","15857","15858","15859","15860","15861","15862","15863","15864","15865","15866","15867","15868","15869","15870","15871","15872","15873","15874","15875","15876","15877","15878","15879","15880","15881","15882","15883","15884","15885","15886","15887","15888","15889","15890","15891","15892","15893","15894","15895","15896","15897","15898","15899","15900","15901","15902","15903","15904","15905","15906","15907","15908","15909","15910","15911","15912","15913","15914","15915","15916","15917","15918","15919","15920","15921","15922","15923","15924","15925","15926","15927","15928","15929","15930","15931","15932","15933","15934","15935","15936","15937","15938","15939","15940","15941","15942","15943","15944","15945","15946","15947","15948","15949","15950","15951","15952","15953","15954","15955","15956","15957","15958","15959","15960","15961","15962","15963","15964","15965","15966","15967","15968","15969","15970","15971","15972","15973","15974","15975","15976","15977","15978","15979","15980","15981","15982","15983","15984","15985","15986","15987","15988","15989","15990","15991","15992","15993","15994","15995","15996","15997","15998","15999","16000","16001","16002","16003","16004","16005","16006","16007","16008","16009","16010","16011","16012","16013","16014","16015","16016","16017","16018","16019","16020","16021","16022","16023","16024","16025","16026","16027","16028","16029","16030","16031","16032","16033","16034","16035","16036","16037","16038","16039","16040","16041","16042","16043","16044","16045","16046","16047","16048","16049","16050","16051","16052","16053","16054","16055","16056","16057","16058","16059","16060","16061","16062","16063","16064","16065","16066","16067","16068","16069","16070","16071","16072","16073","16074","16075","16076","16077","16078","16079","16080","16081","16082","16083","16084","16085","16086","16087","16088","16089","16090","16091","16092","16093","16094","16095","16096","16097","16098","16099","16100","16101","16102","16103","16104","16105","16106","16107","16108","16109","16110","16111","16112","16113","16114","16115","16116","16117","16118","16119","16120","16121","16122","16123","16124","16125","16126","16127","16128","16129","16130","16131","16132","16133","16134","16135","16136","16137","16138","16139","16140","16141","16142","16143","16144","16145","16146","16147","16148","16149","16150","16151","16152","16153","16154","16155","16156","16157","16158","16159","16160","16161","16162","16163","16164","16165","16166","16167","16168","16169","16170","16171","16172","16173","16174","16175","16176","16177","16178","16179","16180","16181","16182","16183","16184","16185","16186","16187","16188","16189","16190","16191","16192","16193","16194","16195","16196","16197","16198","16199","16200","16201","16202","16203","16204","16205","16206","16207","16208","16209","16210","16211","16212","16213","16214","16215","16216","16217","16218","16219","16220","16221","16222","16223","16224","16225","16226","16227","16228","16229","16230","16231","16232","16233","16234","16235","16236","16237","16238","16239","16240","16241","16242","16243","16244","16245","16246","16247","16248","16249","16250","16251","16252","16253","16254","16255","16256","16257","16258","16259","16260","16261","16262","16263","16264","16265","16266","16267","16268","16269","16270","16271","16272","16273","16274","16275","16276","16277","16278","16279","16280","16281","16282","16283","16284","16285","16286","16287","16288","16289","16290","16291","16292","16293","16294","16295","16296","16297","16298","16299","16300","16301","16302","16303","16304","16305","16306","16307","16308","16309","16310","16311","16312","16313","16314","16315","16316","16317","16318","16319","16320","16321","16322","16323","16324","16325","16326","16327","16328","16329","16330","16331","16332","16333","16334","16335","16336","16337","16338","16339","16340","16341","16342","16343","16344","16345","16346","16347","16348","16349","16350","16351","16352","16353","16354","16355","16356","16357","16358","16359","16360","16361","16362","16363","16364","16365","16366","16367","16368","16369","16370","16371","16372","16373","16374","16375","16376","16377","16378","16379","16380","16381","16382","16383","16384","16385","16386","16387","16388","16389","16390","16391","16392","16393","16394","16395","16396","16397","16398","16399","16400","16401","16402","16403","16404","16405","16406","16407","16408","16409","16410","16411","16412","16413","16414","16415","16416","16417","16418","16419","16420","16421","16422","16423","16424","16425","16426","16427","16428","16429","16430","16431","16432","16433","16434","16435","16436","16437","16438","16439","16440","16441","16442","16443","16444","16445","16446","16447","16448","16449","16450","16451","16452","16453","16454","16455","16456","16457","16458","16459","16460","16461","16462","16463","16464","16465","16466","16467","16468","16469","16470","16471","16472","16473","16474","16475","16476","16477","16478","16479","16480","16481","16482","16483","16484","16485","16486","16487","16488","16489","16490","16491","16492","16493","16494","16495","16496","16497","16498","16499","16500","16501","16502","16503","16504","16505","16506","16507","16508","16509","16510","16511","16512","16513","16514","16515","16516","16517","16518","16519","16520","16521","16522","16523","16524","16525","16526","16527","16528","16529","16530","16531","16532","16533","16534","16535","16536","16537","16538","16539","16540","16541","16542","16543","16544","16545","16546","16547","16548","16549","16550","16551","16552","16553","16554","16555","16556","16557","16558","16559","16560","16561","16562","16563","16564","16565","16566","16567","16568","16569","16570","16571","16572","16573","16574","16575","16576","16577","16578","16579","16580","16581","16582","16583","16584","16585","16586","16587","16588","16589","16590","16591","16592","16593","16594","16595","16596","16597","16598","16599","16600","16601","16602","16603","16604","16605","16606","16607","16608","16609","16610","16611","16612","16613","16614","16615","16616","16617","16618","16619","16620","16621","16622","16623","16624","16625","16626","16627","16628","16629","16630","16631","16632","16633","16634","16635","16636","16637","16638","16639","16640","16641","16642","16643","16644","16645","16646","16647","16648","16649","16650","16651","16652","16653","16654","16655","16656","16657","16658","16659","16660","16661","16662","16663","16664","16665","16666","16667","16668","16669","16670","16671","16672","16673","16674","16675","16676","16677","16678","16679","16680","16681","16682","16683","16684","16685","16686","16687","16688","16689","16690","16691","16692","16693","16694","16695","16696","16697","16698","16699","16700","16701","16702","16703","16704","16705","16706","16707","16708","16709","16710","16711","16712","16713","16714","16715","16716","16717","16718","16719","16720","16721","16722","16723","16724","16725","16726","16727","16728","16729","16730","16731","16732","16733","16734","16735","16736","16737","16738","16739","16740","16741","16742","16743","16744","16745","16746","16747","16748","16749","16750","16751","16752","16753","16754","16755","16756","16757","16758","16759","16760","16761","16762","16763","16764","16765","16766","16767","16768","16769","16770","16771","16772","16773","16774","16775","16776","16777","16778","16779","16780","16781","16782","16783","16784","16785","16786","16787","16788","16789","16790","16791","16792","16793","16794","16795","16796","16797","16798","16799","16800","16801","16802","16803","16804","16805","16806","16807","16808","16809","16810","16811","16812","16813","16814","16815","16816","16817","16818","16819","16820","16821","16822","16823","16824","16825","16826","16827","16828","16829","16830","16831","16832","16833","16834","16835","16836","16837","16838","16839","16840","16841","16842","16843","16844","16845","16846","16847","16848","16849","16850","16851","16852","16853","16854","16855","16856","16857","16858","16859","16860","16861","16862","16863","16864","16865","16866","16867","16868","16869","16870","16871","16872","16873","16874","16875","16876","16877","16878","16879","16880","16881","16882","16883","16884","16885","16886","16887","16888","16889","16890","16891","16892","16893","16894","16895","16896","16897","16898","16899","16900","16901","16902","16903","16904","16905","16906","16907","16908","16909","16910","16911","16912","16913","16914","16915","16916","16917","16918","16919","16920","16921","16922","16923","16924","16925","16926","16927","16928","16929","16930","16931","16932","16933","16934","16935","16936","16937","16938","16939","16940","16941","16942","16943","16944","16945","16946","16947","16948","16949","16950","16951","16952","16953","16954","16955","16956","16957","16958","16959","16960","16961","16962","16963","16964","16965","16966","16967","16968","16969","16970","16971","16972","16973","16974","16975","16976","16977","16978","16979","16980","16981","16982","16983","16984","16985","16986","16987","16988","16989","16990","16991","16992","16993","16994","16995","16996","16997","16998","16999","17000","17001","17002","17003","17004","17005","17006","17007","17008","17009","17010","17011","17012","17013","17014","17015","17016","17017","17018","17019","17020","17021","17022","17023","17024","17025","17026","17027","17028","17029","17030","17031","17032","17033","17034","17035","17036","17037","17038","17039","17040","17041","17042","17043","17044","17045","17046","17047","17048","17049","17050","17051","17052","17053","17054","17055","17056","17057","17058","17059","17060","17061","17062","17063","17064","17065","17066","17067","17068","17069","17070","17071","17072","17073","17074","17075","17076","17077","17078","17079","17080","17081","17082","17083","17084","17085","17086","17087","17088","17089","17090","17091","17092","17093","17094","17095","17096","17097","17098","17099","17100","17101","17102","17103","17104","17105","17106","17107","17108","17109","17110","17111","17112","17113","17114","17115","17116","17117","17118","17119","17120","17121","17122","17123","17124","17125","17126","17127","17128","17129","17130","17131","17132","17133","17134","17135","17136","17137","17138","17139","17140","17141","17142","17143","17144","17145","17146","17147","17148","17149","17150","17151","17152","17153","17154","17155","17156","17157","17158","17159","17160","17161","17162","17163","17164","17165","17166","17167","17168","17169","17170","17171","17172","17173","17174","17175","17176","17177","17178","17179","17180","17181","17182","17183","17184","17185","17186","17187","17188","17189","17190","17191","17192","17193","17194","17195","17196","17197","17198","17199","17200","17201","17202","17203","17204","17205","17206","17207","17208","17209","17210","17211","17212","17213","17214","17215","17216","17217","17218","17219","17220","17221","17222","17223","17224","17225","17226","17227","17228","17229","17230","17231","17232","17233","17234","17235","17236","17237","17238","17239","17240","17241","17242","17243","17244","17245","17246","17247","17248","17249","17250","17251","17252","17253","17254","17255","17256","17257","17258","17259","17260","17261","17262","17263","17264","17265","17266","17267","17268","17269","17270","17271","17272","17273","17274","17275","17276","17277","17278","17279","17280","17281","17282","17283","17284","17285","17286","17287","17288","17289","17290","17291","17292","17293","17294","17295","17296","17297","17298","17299","17300","17301","17302","17303","17304","17305","17306","17307","17308","17309","17310","17311","17312","17313","17314","17315","17316","17317","17318","17319","17320","17321","17322","17323","17324","17325","17326","17327","17328","17329","17330","17331","17332","17333","17334","17335","17336","17337","17338","17339","17340","17341","17342","17343","17344","17345","17346","17347","17348","17349","17350","17351","17352","17353","17354","17355","17356","17357","17358","17359","17360","17361","17362","17363","17364","17365","17366","17367","17368","17369","17370","17371","17372","17373","17374","17375","17376","17377","17378","17379","17380","17381","17382","17383","17384","17385","17386","17387","17388","17389","17390","17391","17392","17393","17394","17395","17396","17397","17398","17399","17400","17401","17402","17403","17404","17405","17406","17407","17408","17409","17410","17411","17412","17413","17414","17415","17416","17417","17418","17419","17420","17421","17422","17423","17424","17425","17426","17427","17428","17429","17430","17431","17432","17433","17434","17435","17436","17437","17438","17439","17440","17441","17442","17443","17444","17445","17446","17447","17448","17449","17450","17451","17452","17453","17454","17455","17456","17457","17458","17459","17460","17461","17462","17463","17464","17465","17466","17467","17468","17469","17470","17471","17472","17473","17474","17475","17476","17477","17478","17479","17480","17481","17482","17483","17484","17485","17486","17487","17488","17489","17490","17491","17492","17493","17494","17495","17496","17497","17498","17499","17500","17501","17502","17503","17504","17505","17506","17507","17508","17509","17510","17511","17512","17513","17514","17515","17516","17517","17518","17519","17520","17521","17522","17523","17524","17525","17526","17527","17528","17529","17530","17531","17532","17533","17534","17535","17536","17537","17538","17539","17540","17541","17542","17543","17544","17545","17546","17547","17548","17549","17550","17551","17552","17553","17554","17555","17556","17557","17558","17559","17560","17561","17562","17563","17564","17565","17566","17567","17568","17569","17570","17571","17572","17573","17574","17575","17576","17577","17578","17579","17580","17581","17582","17583","17584","17585","17586","17587","17588","17589","17590","17591","17592","17593","17594","17595","17596","17597","17598","17599","17600","17601","17602","17603","17604","17605","17606","17607","17608","17609","17610","17611","17612","17613","17614","17615","17616","17617","17618","17619","17620","17621","17622","17623","17624","17625","17626","17627","17628","17629","17630","17631","17632","17633","17634","17635","17636","17637","17638","17639","17640","17641","17642","17643","17644","17645","17646","17647","17648","17649","17650","17651","17652","17653","17654","17655","17656","17657","17658","17659","17660","17661","17662","17663","17664","17665","17666","17667","17668","17669","17670","17671","17672","17673","17674","17675","17676","17677","17678","17679","17680","17681","17682","17683","17684","17685","17686","17687","17688","17689","17690","17691","17692","17693","17694","17695","17696","17697","17698","17699","17700","17701","17702","17703","17704","17705","17706","17707","17708","17709","17710","17711","17712","17713","17714","17715","17716","17717","17718","17719","17720","17721","17722","17723","17724","17725","17726","17727","17728","17729","17730","17731","17732","17733","17734","17735","17736","17737","17738","17739","17740","17741","17742","17743","17744","17745","17746","17747","17748","17749","17750","17751","17752","17753","17754","17755","17756","17757","17758","17759","17760","17761","17762","17763","17764","17765","17766","17767","17768","17769","17770","17771","17772","17773","17774","17775","17776","17777","17778","17779","17780","17781","17782","17783","17784","17785","17786","17787","17788","17789","17790","17791","17792","17793","17794","17795","17796","17797","17798","17799","17800","17801","17802","17803","17804","17805","17806","17807","17808","17809","17810","17811","17812","17813","17814","17815","17816","17817","17818","17819","17820","17821","17822","17823","17824","17825","17826","17827","17828","17829","17830","17831","17832","17833","17834","17835","17836","17837","17838","17839","17840","17841","17842","17843","17844","17845","17846","17847","17848","17849","17850","17851","17852","17853","17854","17855","17856","17857","17858","17859","17860","17861","17862","17863","17864","17865","17866","17867","17868","17869","17870","17871","17872","17873","17874","17875","17876","17877","17878","17879","17880","17881","17882","17883","17884","17885","17886","17887","17888","17889","17890","17891","17892","17893","17894","17895","17896","17897","17898","17899","17900","17901","17902","17903","17904","17905","17906","17907","17908","17909","17910","17911","17912","17913","17914","17915","17916","17917","17918","17919","17920","17921","17922","17923","17924","17925","17926","17927","17928","17929","17930","17931","17932","17933","17934","17935","17936","17937","17938","17939","17940","17941","17942","17943","17944","17945","17946","17947","17948","17949","17950","17951","17952","17953","17954","17955","17956","17957","17958","17959","17960","17961","17962","17963","17964","17965","17966","17967","17968","17969","17970","17971","17972","17973","17974","17975","17976","17977","17978","17979","17980","17981","17982","17983","17984","17985","17986","17987","17988","17989","17990","17991","17992","17993","17994","17995","17996","17997","17998","17999","18000","18001","18002","18003","18004","18005","18006","18007","18008","18009","18010","18011","18012","18013","18014","18015","18016","18017","18018","18019","18020","18021","18022","18023","18024","18025","18026","18027","18028","18029","18030","18031","18032","18033","18034","18035","18036","18037","18038","18039","18040","18041","18042","18043","18044","18045","18046","18047","18048","18049","18050","18051","18052","18053","18054","18055","18056","18057","18058","18059","18060","18061","18062","18063","18064","18065","18066","18067","18068","18069","18070","18071","18072","18073","18074","18075","18076","18077","18078","18079","18080","18081","18082","18083","18084","18085","18086","18087","18088","18089","18090","18091","18092","18093","18094","18095","18096","18097","18098","18099","18100","18101","18102","18103","18104","18105","18106","18107","18108","18109","18110","18111","18112","18113","18114","18115","18116","18117","18118","18119","18120","18121","18122","18123","18124","18125","18126","18127","18128","18129","18130","18131","18132","18133","18134","18135","18136","18137","18138","18139","18140","18141","18142","18143","18144","18145","18146","18147","18148","18149","18150","18151","18152","18153","18154","18155","18156","18157","18158","18159","18160","18161","18162","18163","18164","18165","18166","18167","18168","18169","18170","18171","18172","18173","18174","18175","18176","18177","18178","18179","18180","18181","18182","18183","18184","18185","18186","18187","18188","18189","18190","18191","18192","18193","18194","18195","18196","18197","18198","18199","18200","18201","18202","18203","18204","18205","18206","18207","18208","18209","18210","18211","18212","18213","18214","18215","18216","18217","18218","18219","18220","18221","18222","18223","18224","18225","18226","18227","18228","18229","18230","18231","18232","18233","18234","18235","18236","18237","18238","18239","18240","18241","18242","18243","18244","18245","18246","18247","18248","18249","18250","18251","18252","18253","18254","18255","18256","18257","18258","18259","18260","18261","18262","18263","18264","18265","18266","18267","18268","18269","18270","18271","18272","18273","18274","18275","18276","18277","18278","18279","18280","18281","18282","18283","18284","18285","18286","18287","18288","18289","18290","18291","18292","18293","18294","18295","18296","18297","18298","18299","18300","18301","18302","18303","18304","18305","18306","18307","18308","18309","18310","18311","18312","18313","18314","18315","18316","18317","18318","18319","18320","18321","18322","18323","18324","18325","18326","18327","18328","18329","18330","18331","18332","18333","18334","18335","18336","18337","18338","18339","18340","18341","18342","18343","18344","18345","18346","18347","18348","18349","18350","18351","18352","18353","18354","18355","18356","18357","18358","18359","18360","18361","18362","18363","18364","18365","18366","18367","18368","18369","18370","18371","18372","18373","18374","18375","18376","18377","18378","18379","18380","18381","18382","18383","18384","18385","18386","18387","18388","18389","18390","18391","18392","18393","18394","18395","18396","18397","18398","18399","18400","18401","18402","18403","18404","18405","18406","18407","18408","18409","18410","18411","18412","18413","18414","18415","18416","18417","18418","18419","18420","18421","18422","18423","18424","18425","18426","18427","18428","18429","18430","18431","18432","18433","18434","18435","18436","18437","18438","18439","18440","18441","18442","18443","18444","18445","18446","18447","18448","18449","18450","18451","18452","18453","18454","18455","18456","18457","18458","18459","18460","18461","18462","18463","18464","18465","18466","18467","18468","18469","18470","18471","18472","18473","18474","18475","18476","18477","18478","18479","18480","18481","18482","18483","18484","18485","18486","18487","18488","18489","18490","18491","18492","18493","18494","18495","18496","18497","18498","18499","18500","18501","18502","18503","18504","18505","18506","18507","18508","18509","18510","18511","18512","18513","18514","18515","18516","18517","18518","18519","18520","18521","18522","18523","18524","18525","18526","18527","18528","18529","18530","18531","18532","18533","18534","18535","18536","18537","18538","18539","18540","18541","18542","18543","18544","18545","18546","18547","18548","18549","18550","18551","18552","18553","18554","18555","18556","18557","18558","18559","18560","18561","18562","18563","18564","18565","18566","18567","18568","18569","18570","18571","18572","18573","18574","18575","18576","18577","18578","18579","18580","18581","18582","18583","18584","18585","18586","18587","18588","18589","18590","18591","18592","18593","18594","18595","18596","18597","18598","18599","18600","18601","18602","18603","18604","18605","18606","18607","18608","18609","18610","18611","18612","18613","18614","18615","18616","18617","18618","18619","18620","18621","18622","18623","18624","18625","18626","18627","18628","18629","18630","18631","18632","18633","18634","18635","18636","18637","18638","18639","18640","18641","18642","18643","18644","18645","18646","18647","18648","18649","18650","18651","18652","18653","18654","18655","18656","18657","18658","18659","18660","18661","18662","18663","18664","18665","18666","18667","18668","18669","18670","18671","18672","18673","18674","18675","18676","18677","18678","18679","18680","18681","18682","18683","18684","18685","18686","18687","18688","18689","18690","18691","18692","18693","18694","18695","18696","18697","18698","18699","18700","18701","18702","18703","18704","18705","18706","18707","18708","18709","18710","18711","18712","18713","18714","18715","18716","18717","18718","18719","18720","18721","18722","18723","18724","18725","18726","18727","18728","18729","18730","18731","18732","18733","18734","18735","18736","18737","18738","18739","18740","18741","18742","18743","18744","18745","18746","18747","18748","18749","18750","18751","18752","18753","18754","18755","18756","18757","18758","18759","18760","18761","18762","18763","18764","18765","18766","18767","18768","18769","18770","18771","18772","18773","18774","18775","18776","18777","18778","18779","18780","18781","18782","18783","18784","18785","18786","18787","18788","18789","18790","18791","18792","18793","18794","18795","18796","18797","18798","18799","18800","18801","18802","18803","18804","18805","18806","18807","18808","18809","18810","18811","18812","18813","18814","18815","18816","18817","18818","18819","18820","18821","18822","18823","18824","18825","18826","18827","18828","18829","18830","18831","18832","18833","18834","18835","18836","18837","18838","18839","18840","18841","18842","18843","18844","18845","18846","18847","18848","18849","18850","18851","18852","18853","18854","18855","18856","18857","18858","18859","18860","18861","18862","18863","18864","18865","18866","18867","18868","18869","18870","18871","18872","18873","18874","18875","18876","18877","18878","18879","18880","18881","18882","18883","18884","18885","18886","18887","18888","18889","18890","18891","18892","18893","18894","18895","18896","18897","18898","18899","18900","18901","18902","18903","18904","18905","18906","18907","18908","18909","18910","18911","18912","18913","18914","18915","18916","18917","18918","18919","18920","18921","18922","18923","18924","18925","18926","18927","18928","18929","18930","18931","18932","18933","18934","18935","18936","18937","18938","18939","18940","18941","18942","18943","18944","18945","18946","18947","18948","18949","18950","18951","18952","18953","18954","18955","18956","18957","18958","18959","18960","18961","18962","18963","18964","18965","18966","18967","18968","18969","18970","18971","18972","18973","18974","18975","18976","18977","18978","18979","18980","18981","18982","18983","18984","18985","18986","18987","18988","18989","18990","18991","18992","18993","18994","18995","18996","18997","18998","18999","19000","19001","19002","19003","19004","19005","19006","19007","19008","19009","19010","19011","19012","19013","19014","19015","19016","19017","19018","19019","19020","19021","19022","19023","19024","19025","19026","19027","19028","19029","19030","19031","19032","19033","19034","19035","19036","19037","19038","19039","19040","19041","19042","19043","19044","19045","19046","19047","19048","19049","19050","19051","19052","19053","19054","19055","19056","19057","19058","19059","19060","19061","19062","19063","19064","19065","19066","19067","19068","19069","19070","19071","19072","19073","19074","19075","19076","19077","19078","19079","19080","19081","19082","19083","19084","19085","19086","19087","19088","19089","19090","19091","19092","19093","19094","19095","19096","19097","19098","19099","19100","19101","19102","19103","19104","19105","19106","19107","19108","19109","19110","19111","19112","19113","19114","19115","19116","19117","19118","19119","19120","19121","19122","19123","19124","19125","19126","19127","19128","19129","19130","19131","19132","19133","19134","19135","19136","19137","19138","19139","19140","19141","19142","19143","19144","19145","19146","19147","19148","19149","19150","19151","19152","19153","19154","19155","19156","19157","19158","19159","19160","19161","19162","19163","19164","19165","19166","19167","19168","19169","19170","19171","19172","19173","19174","19175","19176","19177","19178","19179","19180","19181","19182","19183","19184","19185","19186","19187","19188","19189","19190","19191","19192","19193","19194","19195","19196","19197","19198","19199","19200","19201","19202","19203","19204","19205","19206","19207","19208","19209","19210","19211","19212","19213","19214","19215","19216","19217","19218","19219","19220","19221","19222","19223","19224","19225","19226","19227","19228","19229","19230","19231","19232","19233","19234","19235","19236","19237","19238","19239","19240","19241","19242","19243","19244","19245","19246","19247","19248","19249","19250","19251","19252","19253","19254","19255","19256","19257","19258","19259","19260","19261","19262","19263","19264","19265","19266","19267","19268","19269","19270","19271","19272","19273","19274","19275","19276","19277","19278","19279","19280","19281","19282","19283","19284","19285","19286","19287","19288","19289","19290","19291","19292","19293","19294","19295","19296","19297","19298","19299","19300","19301","19302","19303","19304","19305","19306","19307","19308","19309","19310","19311","19312","19313","19314","19315","19316","19317","19318","19319","19320","19321","19322","19323","19324","19325","19326","19327","19328","19329","19330","19331","19332","19333","19334","19335","19336","19337","19338","19339","19340","19341","19342","19343","19344","19345","19346","19347","19348","19349","19350","19351","19352","19353","19354","19355","19356","19357","19358","19359","19360","19361","19362","19363","19364","19365","19366","19367","19368","19369","19370","19371","19372","19373","19374","19375","19376","19377","19378","19379","19380","19381","19382","19383","19384","19385","19386","19387","19388","19389","19390","19391","19392","19393","19394","19395","19396","19397","19398","19399","19400","19401","19402","19403","19404","19405","19406","19407","19408","19409","19410","19411","19412","19413","19414","19415","19416","19417","19418","19419","19420","19421","19422","19423","19424","19425","19426","19427","19428","19429","19430","19431","19432","19433","19434","19435","19436","19437","19438","19439","19440","19441","19442","19443","19444","19445","19446","19447","19448","19449","19450","19451","19452","19453","19454","19455","19456","19457","19458","19459","19460","19461","19462","19463","19464","19465","19466","19467","19468","19469","19470","19471","19472","19473","19474","19475","19476","19477","19478","19479","19480","19481","19482","19483","19484","19485","19486","19487","19488","19489","19490","19491","19492","19493","19494","19495","19496","19497","19498","19499","19500","19501","19502","19503","19504","19505","19506","19507","19508","19509","19510","19511","19512","19513","19514","19515","19516","19517","19518","19519","19520","19521","19522","19523","19524","19525","19526","19527","19528","19529","19530","19531","19532","19533","19534","19535","19536","19537","19538","19539","19540","19541","19542","19543","19544","19545","19546","19547","19548","19549","19550","19551","19552","19553","19554","19555","19556","19557","19558","19559","19560","19561","19562","19563","19564","19565","19566","19567","19568","19569","19570","19571","19572","19573","19574","19575","19576","19577","19578","19579","19580","19581","19582","19583","19584","19585","19586","19587","19588","19589","19590","19591","19592","19593","19594","19595","19596","19597","19598","19599","19600","19601","19602","19603","19604","19605","19606","19607","19608","19609","19610","19611","19612","19613","19614","19615","19616","19617","19618","19619","19620","19621","19622","19623","19624","19625","19626","19627","19628","19629","19630","19631","19632","19633","19634","19635","19636","19637","19638","19639","19640","19641","19642","19643","19644","19645","19646","19647","19648","19649","19650","19651","19652","19653","19654","19655","19656","19657","19658","19659","19660","19661","19662","19663","19664","19665","19666","19667","19668","19669","19670","19671","19672","19673","19674","19675","19676","19677","19678","19679","19680","19681","19682","19683","19684","19685","19686","19687","19688","19689","19690","19691","19692","19693","19694","19695","19696","19697","19698","19699","19700","19701","19702","19703","19704","19705","19706","19707","19708","19709","19710","19711","19712","19713","19714","19715","19716","19717","19718","19719","19720","19721","19722","19723","19724","19725","19726","19727","19728","19729","19730","19731","19732","19733","19734","19735","19736","19737","19738","19739","19740","19741","19742","19743","19744","19745","19746","19747","19748","19749","19750","19751","19752","19753","19754","19755","19756","19757","19758","19759","19760","19761","19762","19763","19764","19765","19766","19767","19768","19769","19770","19771","19772","19773","19774","19775","19776","19777","19778","19779","19780","19781","19782","19783","19784","19785","19786","19787","19788","19789","19790","19791","19792","19793","19794","19795","19796","19797","19798","19799","19800","19801","19802","19803","19804","19805","19806","19807","19808","19809","19810","19811","19812","19813","19814","19815","19816","19817","19818","19819","19820","19821","19822","19823","19824","19825","19826","19827","19828","19829","19830","19831","19832","19833","19834","19835","19836","19837","19838","19839","19840","19841","19842","19843","19844","19845","19846","19847","19848","19849","19850","19851","19852","19853","19854","19855","19856","19857","19858","19859","19860","19861","19862","19863","19864","19865","19866","19867","19868","19869","19870","19871","19872","19873","19874","19875","19876","19877","19878","19879","19880","19881","19882","19883","19884","19885","19886","19887","19888","19889","19890","19891","19892","19893","19894","19895","19896","19897","19898","19899","19900","19901","19902","19903","19904","19905","19906","19907","19908","19909","19910","19911","19912","19913","19914","19915","19916","19917","19918","19919","19920","19921","19922","19923","19924","19925","19926","19927","19928","19929","19930","19931","19932","19933","19934","19935","19936","19937","19938","19939","19940","19941","19942","19943","19944","19945","19946","19947","19948","19949","19950","19951","19952","19953","19954","19955","19956","19957","19958","19959","19960","19961","19962","19963","19964","19965","19966","19967","19968","19969","19970","19971","19972","19973","19974","19975","19976","19977","19978","19979","19980","19981","19982","19983","19984","19985","19986","19987","19988","19989","19990","19991","19992","19993","19994","19995","19996","19997","19998","19999","20000","20001","20002","20003","20004","20005","20006","20007","20008","20009","20010","20011","20012","20013","20014","20015","20016","20017","20018","20019","20020","20021","20022","20023","20024","20025","20026","20027","20028","20029","20030","20031","20032","20033","20034","20035","20036","20037","20038","20039","20040","20041","20042","20043","20044","20045","20046","20047","20048","20049","20050","20051","20052","20053","20054","20055","20056","20057","20058","20059","20060","20061","20062","20063","20064","20065","20066","20067","20068","20069","20070","20071","20072","20073","20074","20075","20076","20077","20078","20079","20080","20081","20082","20083","20084","20085","20086","20087","20088","20089","20090","20091","20092","20093","20094","20095","20096","20097","20098","20099","20100","20101","20102","20103","20104","20105","20106","20107","20108","20109","20110","20111","20112","20113","20114","20115","20116","20117","20118","20119","20120","20121","20122","20123","20124","20125","20126","20127","20128","20129","20130","20131","20132","20133","20134","20135","20136","20137","20138","20139","20140","20141","20142","20143","20144","20145","20146","20147","20148","20149","20150","20151","20152","20153","20154","20155","20156","20157","20158","20159","20160","20161","20162","20163","20164","20165","20166","20167","20168","20169","20170","20171","20172","20173","20174","20175","20176","20177","20178","20179","20180","20181","20182","20183","20184","20185","20186","20187","20188","20189","20190","20191","20192","20193","20194","20195","20196","20197","20198","20199","20200","20201","20202","20203","20204","20205","20206","20207","20208","20209","20210","20211","20212","20213","20214","20215","20216","20217","20218","20219","20220","20221","20222","20223","20224","20225","20226","20227","20228","20229","20230","20231","20232","20233","20234","20235","20236","20237","20238","20239","20240","20241","20242","20243","20244","20245","20246","20247","20248","20249","20250","20251","20252","20253","20254","20255","20256","20257","20258","20259","20260","20261","20262","20263","20264","20265","20266","20267","20268","20269","20270","20271","20272","20273","20274","20275","20276","20277","20278","20279","20280","20281","20282","20283","20284","20285","20286","20287","20288","20289","20290","20291","20292","20293","20294","20295","20296","20297","20298","20299","20300","20301","20302","20303","20304","20305","20306","20307","20308","20309","20310","20311","20312","20313","20314","20315","20316","20317","20318","20319","20320","20321","20322","20323","20324","20325","20326","20327","20328","20329","20330","20331","20332","20333","20334","20335","20336","20337","20338","20339","20340","20341","20342","20343","20344","20345","20346","20347","20348","20349","20350","20351","20352","20353","20354","20355","20356","20357","20358","20359","20360","20361","20362","20363","20364","20365","20366","20367","20368","20369","20370","20371","20372","20373","20374","20375","20376","20377","20378","20379","20380","20381","20382","20383","20384","20385","20386","20387","20388","20389","20390","20391","20392","20393","20394","20395","20396","20397","20398","20399","20400","20401","20402","20403","20404","20405","20406","20407","20408","20409","20410","20411","20412","20413","20414","20415","20416","20417","20418","20419","20420","20421","20422","20423","20424","20425","20426","20427","20428","20429","20430","20431","20432","20433","20434","20435","20436","20437","20438","20439","20440","20441","20442","20443","20444","20445","20446","20447","20448","20449","20450","20451","20452","20453","20454","20455","20456","20457","20458","20459","20460","20461","20462","20463","20464","20465","20466","20467","20468","20469","20470","20471","20472","20473","20474","20475","20476","20477","20478","20479","20480","20481","20482","20483","20484","20485","20486","20487","20488","20489","20490","20491","20492","20493","20494","20495","20496","20497","20498","20499","20500","20501","20502","20503","20504","20505","20506","20507","20508","20509","20510","20511","20512","20513","20514","20515","20516","20517","20518","20519","20520","20521","20522","20523","20524","20525","20526","20527","20528","20529","20530","20531","20532","20533","20534","20535","20536","20537","20538","20539","20540","20541","20542","20543","20544","20545","20546","20547","20548","20549","20550","20551","20552","20553","20554","20555","20556","20557","20558","20559","20560","20561","20562","20563","20564","20565","20566","20567","20568","20569","20570","20571","20572","20573","20574","20575","20576","20577","20578","20579","20580","20581","20582","20583","20584","20585","20586","20587","20588","20589","20590","20591","20592","20593","20594","20595","20596","20597","20598","20599","20600","20601","20602","20603","20604","20605","20606","20607","20608","20609","20610","20611","20612","20613","20614","20615","20616","20617","20618","20619","20620","20621","20622","20623","20624","20625","20626","20627","20628","20629","20630","20631","20632","20633","20634","20635","20636","20637","20638","20639","20640","20641","20642","20643","20644","20645","20646","20647","20648","20649","20650","20651","20652","20653","20654","20655","20656","20657","20658","20659","20660","20661","20662","20663","20664","20665","20666","20667","20668","20669","20670","20671","20672","20673","20674","20675","20676","20677","20678","20679","20680","20681","20682","20683","20684","20685","20686","20687","20688","20689","20690","20691","20692","20693","20694","20695","20696","20697","20698","20699","20700","20701","20702","20703","20704","20705","20706","20707","20708","20709","20710","20711","20712","20713","20714","20715","20716","20717","20718","20719","20720","20721","20722","20723","20724","20725","20726","20727","20728","20729","20730","20731","20732","20733","20734","20735","20736","20737","20738","20739","20740","20741","20742","20743","20744","20745","20746","20747","20748","20749","20750","20751","20752","20753","20754","20755","20756","20757","20758","20759","20760","20761","20762","20763","20764","20765","20766","20767","20768","20769","20770","20771","20772","20773","20774","20775","20776","20777","20778","20779","20780","20781","20782","20783","20784","20785","20786","20787","20788","20789","20790","20791","20792","20793","20794","20795","20796","20797","20798","20799","20800","20801","20802","20803","20804","20805","20806","20807","20808","20809","20810","20811","20812","20813","20814","20815","20816","20817","20818","20819","20820","20821","20822","20823","20824","20825","20826","20827","20828","20829","20830","20831","20832","20833","20834","20835","20836","20837","20838","20839","20840","20841","20842","20843","20844","20845","20846","20847","20848","20849","20850","20851","20852","20853","20854","20855","20856","20857","20858","20859","20860","20861","20862","20863","20864","20865","20866","20867","20868","20869","20870","20871","20872","20873","20874","20875","20876","20877","20878","20879","20880","20881","20882","20883","20884","20885","20886","20887","20888","20889","20890","20891","20892","20893","20894","20895","20896","20897","20898","20899","20900","20901","20902","20903","20904","20905","20906","20907","20908","20909","20910","20911","20912","20913","20914","20915","20916","20917","20918","20919","20920","20921","20922","20923","20924","20925","20926","20927","20928","20929","20930","20931","20932","20933","20934","20935","20936","20937","20938","20939","20940","20941","20942","20943","20944","20945","20946","20947","20948","20949","20950","20951","20952","20953","20954","20955","20956","20957","20958","20959","20960","20961","20962","20963","20964","20965","20966","20967","20968","20969","20970","20971","20972","20973","20974","20975","20976","20977","20978","20979","20980","20981","20982","20983","20984","20985","20986","20987","20988","20989","20990","20991","20992","20993","20994","20995","20996","20997","20998","20999","21000","21001","21002","21003","21004","21005","21006","21007","21008","21009","21010","21011","21012","21013","21014","21015","21016","21017","21018","21019","21020","21021","21022","21023","21024","21025","21026","21027","21028","21029","21030","21031","21032","21033","21034","21035","21036","21037","21038","21039","21040","21041","21042","21043","21044","21045","21046","21047","21048","21049","21050","21051","21052","21053","21054","21055","21056","21057","21058","21059","21060","21061","21062","21063","21064","21065","21066","21067","21068","21069","21070","21071","21072","21073","21074","21075","21076","21077","21078","21079","21080","21081","21082","21083","21084","21085","21086","21087","21088","21089","21090","21091","21092","21093","21094","21095","21096","21097","21098","21099","21100","21101","21102","21103","21104","21105","21106","21107","21108","21109","21110","21111","21112","21113","21114","21115","21116","21117","21118","21119","21120","21121","21122","21123","21124","21125","21126","21127","21128","21129","21130","21131","21132","21133","21134","21135","21136","21137","21138","21139","21140","21141","21142","21143","21144","21145","21146","21147","21148","21149","21150","21151","21152","21153","21154","21155","21156","21157","21158","21159","21160","21161","21162","21163","21164","21165","21166","21167","21168","21169","21170","21171","21172","21173","21174","21175","21176","21177","21178","21179","21180","21181","21182","21183","21184","21185","21186","21187","21188","21189","21190","21191","21192","21193","21194","21195","21196","21197","21198","21199","21200","21201","21202","21203","21204","21205","21206","21207","21208","21209","21210","21211","21212","21213","21214","21215","21216","21217","21218","21219","21220","21221","21222","21223","21224","21225","21226","21227","21228","21229","21230","21231","21232","21233","21234","21235","21236","21237","21238","21239","21240","21241","21242","21243","21244","21245","21246","21247","21248","21249","21250","21251","21252","21253","21254","21255","21256","21257","21258","21259","21260","21261","21262","21263","21264","21265","21266","21267","21268","21269","21270","21271","21272","21273","21274","21275","21276","21277","21278","21279","21280","21281","21282","21283","21284","21285","21286","21287","21288","21289","21290","21291","21292","21293","21294","21295","21296","21297","21298","21299","21300","21301","21302","21303","21304","21305","21306","21307","21308","21309","21310","21311","21312","21313","21314","21315","21316","21317","21318","21319","21320","21321","21322","21323","21324","21325","21326","21327","21328","21329","21330","21331","21332","21333","21334","21335","21336","21337","21338","21339","21340","21341","21342","21343","21344","21345","21346","21347","21348","21349","21350","21351","21352","21353","21354","21355","21356","21357","21358","21359","21360","21361","21362","21363","21364","21365","21366","21367","21368","21369","21370","21371","21372","21373","21374","21375","21376","21377","21378","21379","21380","21381","21382","21383","21384","21385","21386","21387","21388","21389","21390","21391","21392","21393","21394","21395","21396","21397","21398","21399","21400","21401","21402","21403","21404","21405","21406","21407","21408","21409","21410","21411","21412","21413","21414","21415","21416","21417","21418","21419","21420","21421","21422","21423","21424","21425","21426","21427","21428","21429","21430","21431","21432","21433","21434","21435","21436","21437","21438","21439","21440","21441","21442","21443","21444","21445","21446","21447","21448","21449","21450","21451","21452","21453","21454","21455","21456","21457","21458","21459","21460","21461","21462","21463","21464","21465","21466","21467","21468","21469","21470","21471","21472","21473","21474","21475","21476","21477","21478","21479","21480","21481","21482","21483","21484","21485","21486","21487","21488","21489","21490","21491","21492","21493","21494","21495","21496","21497","21498","21499","21500","21501","21502","21503","21504","21505","21506","21507","21508","21509","21510","21511","21512","21513","21514","21515","21516","21517","21518","21519","21520","21521","21522","21523","21524","21525","21526","21527","21528","21529","21530","21531","21532","21533","21534","21535","21536","21537","21538","21539","21540","21541","21542","21543","21544","21545","21546","21547","21548","21549","21550","21551","21552","21553","21554","21555","21556","21557","21558","21559","21560","21561","21562","21563","21564","21565","21566","21567","21568","21569","21570","21571","21572","21573","21574","21575","21576","21577","21578","21579","21580","21581","21582","21583","21584","21585","21586","21587","21588","21589","21590","21591","21592","21593","21594","21595","21596","21597","21598","21599","21600","21601","21602","21603","21604","21605","21606","21607","21608","21609","21610","21611","21612","21613","21614","21615","21616","21617","21618","21619","21620","21621","21622","21623","21624","21625","21626","21627","21628","21629","21630","21631","21632","21633","21634","21635","21636","21637","21638","21639","21640","21641","21642","21643","21644","21645","21646","21647","21648","21649","21650","21651","21652","21653","21654","21655","21656","21657","21658","21659","21660","21661","21662","21663","21664","21665","21666","21667","21668","21669","21670","21671","21672","21673","21674","21675","21676","21677","21678","21679","21680","21681","21682","21683","21684","21685","21686","21687","21688","21689","21690","21691","21692","21693","21694","21695","21696","21697","21698","21699","21700","21701","21702","21703","21704","21705","21706","21707","21708","21709","21710","21711","21712","21713","21714","21715","21716","21717","21718","21719","21720","21721","21722","21723","21724","21725","21726","21727","21728","21729","21730","21731","21732","21733","21734","21735","21736","21737","21738","21739","21740","21741","21742","21743","21744","21745","21746","21747","21748","21749","21750","21751","21752","21753","21754","21755","21756","21757","21758","21759","21760","21761","21762","21763","21764","21765","21766","21767","21768","21769","21770","21771","21772","21773","21774","21775","21776","21777","21778","21779","21780","21781","21782","21783","21784","21785","21786","21787","21788","21789","21790","21791","21792","21793","21794","21795","21796","21797","21798","21799","21800","21801","21802","21803","21804","21805","21806","21807","21808","21809","21810","21811","21812","21813","21814","21815","21816","21817","21818","21819","21820","21821","21822","21823","21824","21825","21826","21827","21828","21829","21830","21831","21832","21833","21834","21835","21836","21837","21838","21839","21840","21841","21842","21843","21844","21845","21846","21847","21848","21849","21850","21851","21852","21853","21854","21855","21856","21857","21858","21859","21860","21861","21862","21863","21864","21865","21866","21867","21868","21869","21870","21871","21872","21873","21874","21875","21876","21877","21878","21879","21880","21881","21882","21883","21884","21885","21886","21887","21888","21889","21890","21891","21892","21893","21894","21895","21896","21897","21898","21899","21900","21901","21902","21903","21904","21905","21906","21907","21908","21909","21910","21911","21912","21913","21914","21915","21916","21917","21918","21919","21920","21921","21922","21923","21924","21925","21926","21927","21928","21929","21930","21931","21932","21933","21934","21935","21936","21937","21938","21939","21940","21941","21942","21943","21944","21945","21946","21947","21948","21949","21950","21951","21952","21953","21954","21955","21956","21957","21958","21959","21960","21961","21962","21963","21964","21965","21966","21967","21968","21969","21970","21971","21972","21973","21974","21975","21976","21977","21978","21979","21980","21981","21982","21983","21984","21985","21986","21987","21988","21989","21990","21991","21992","21993","21994","21995","21996","21997","21998","21999","22000","22001","22002","22003","22004","22005","22006","22007","22008","22009","22010","22011","22012","22013","22014","22015","22016","22017","22018","22019","22020","22021","22022","22023","22024","22025","22026","22027","22028","22029","22030","22031","22032","22033","22034","22035","22036","22037","22038","22039","22040","22041","22042","22043","22044","22045","22046","22047","22048","22049","22050","22051","22052","22053","22054","22055","22056","22057","22058","22059","22060","22061","22062","22063","22064","22065","22066","22067","22068","22069","22070","22071","22072","22073","22074","22075","22076","22077","22078","22079","22080","22081","22082","22083","22084","22085","22086","22087","22088","22089","22090","22091","22092","22093","22094","22095","22096","22097","22098","22099","22100","22101","22102","22103","22104","22105","22106","22107","22108","22109","22110","22111","22112","22113","22114","22115","22116","22117","22118","22119","22120","22121","22122","22123","22124","22125","22126","22127","22128","22129","22130","22131","22132","22133","22134","22135","22136","22137","22138","22139","22140","22141","22142","22143","22144","22145","22146","22147","22148","22149","22150","22151","22152","22153","22154","22155","22156","22157","22158","22159","22160","22161","22162","22163","22164","22165","22166","22167","22168","22169","22170","22171","22172","22173","22174","22175","22176","22177","22178","22179","22180","22181","22182","22183","22184","22185","22186","22187","22188","22189","22190","22191","22192","22193","22194","22195","22196","22197","22198","22199","22200","22201","22202","22203","22204","22205","22206","22207","22208","22209","22210","22211","22212","22213","22214","22215","22216","22217","22218","22219","22220","22221","22222","22223","22224","22225","22226","22227","22228","22229","22230","22231","22232","22233","22234","22235","22236","22237","22238","22239","22240","22241","22242","22243","22244","22245","22246","22247","22248","22249","22250","22251","22252","22253","22254","22255","22256","22257","22258","22259","22260","22261","22262","22263","22264","22265","22266","22267","22268","22269","22270","22271","22272","22273","22274","22275","22276","22277","22278","22279","22280","22281","22282","22283","22284","22285","22286","22287","22288","22289","22290","22291","22292","22293","22294","22295","22296","22297","22298","22299","22300","22301","22302","22303","22304","22305","22306","22307","22308","22309","22310","22311","22312","22313","22314","22315","22316","22317","22318","22319","22320","22321","22322","22323","22324","22325","22326","22327","22328","22329","22330","22331","22332","22333","22334","22335","22336","22337","22338","22339","22340","22341","22342","22343","22344","22345","22346","22347","22348","22349","22350","22351","22352","22353","22354","22355","22356","22357","22358","22359","22360","22361","22362","22363","22364","22365","22366","22367","22368","22369","22370","22371","22372","22373","22374","22375","22376","22377","22378","22379","22380","22381","22382","22383","22384","22385","22386","22387","22388","22389","22390","22391","22392","22393","22394","22395","22396","22397","22398","22399","22400","22401","22402","22403","22404","22405","22406","22407","22408","22409","22410","22411","22412","22413","22414","22415","22416","22417","22418","22419","22420","22421","22422","22423","22424","22425","22426","22427","22428","22429","22430","22431","22432","22433","22434","22435","22436","22437","22438","22439","22440","22441","22442","22443","22444","22445","22446","22447","22448","22449","22450","22451","22452","22453","22454","22455","22456","22457","22458","22459","22460","22461","22462","22463","22464","22465","22466","22467","22468","22469","22470","22471","22472","22473","22474","22475","22476","22477","22478","22479","22480","22481","22482","22483","22484","22485","22486","22487","22488","22489","22490","22491","22492","22493","22494","22495","22496","22497","22498","22499","22500","22501","22502","22503","22504","22505","22506","22507","22508","22509","22510","22511","22512","22513","22514","22515","22516","22517","22518","22519","22520","22521","22522","22523","22524","22525","22526","22527","22528","22529","22530","22531","22532","22533","22534","22535","22536","22537","22538","22539","22540","22541","22542","22543","22544","22545","22546","22547","22548","22549","22550","22551","22552","22553","22554","22555","22556","22557","22558","22559","22560","22561","22562","22563","22564","22565","22566","22567","22568","22569","22570","22571","22572","22573","22574","22575","22576","22577","22578","22579","22580","22581","22582","22583","22584","22585","22586","22587","22588","22589","22590","22591","22592","22593","22594","22595","22596","22597","22598","22599","22600","22601","22602","22603","22604","22605","22606","22607","22608","22609","22610","22611","22612","22613","22614","22615","22616","22617","22618","22619","22620","22621","22622","22623","22624","22625","22626","22627","22628","22629","22630","22631","22632","22633","22634","22635","22636","22637","22638","22639","22640","22641","22642","22643","22644","22645","22646","22647","22648","22649","22650","22651","22652","22653","22654","22655","22656","22657","22658","22659","22660","22661","22662","22663","22664","22665","22666","22667","22668","22669","22670","22671","22672","22673","22674","22675","22676","22677","22678","22679","22680","22681","22682","22683","22684","22685","22686","22687","22688","22689","22690","22691","22692","22693","22694","22695","22696","22697","22698","22699","22700","22701","22702","22703","22704","22705","22706","22707","22708","22709","22710","22711","22712","22713","22714","22715","22716","22717","22718","22719","22720","22721","22722","22723","22724","22725","22726","22727","22728","22729","22730","22731","22732","22733","22734","22735","22736","22737","22738","22739","22740","22741","22742","22743","22744","22745","22746","22747","22748","22749","22750","22751","22752","22753","22754","22755","22756","22757","22758","22759","22760","22761","22762","22763","22764","22765","22766","22767","22768","22769","22770","22771","22772","22773","22774","22775","22776","22777","22778","22779","22780","22781","22782","22783","22784","22785","22786","22787","22788","22789","22790","22791","22792","22793","22794","22795","22796","22797","22798","22799","22800","22801","22802","22803","22804","22805","22806","22807","22808","22809","22810","22811","22812","22813","22814","22815","22816","22817","22818","22819","22820","22821","22822","22823","22824","22825","22826","22827","22828","22829","22830","22831","22832","22833","22834","22835","22836","22837","22838","22839","22840","22841","22842","22843","22844","22845","22846","22847","22848","22849","22850","22851","22852","22853","22854","22855","22856","22857","22858","22859","22860","22861","22862","22863","22864","22865","22866","22867","22868","22869","22870","22871","22872","22873","22874","22875","22876","22877","22878","22879","22880","22881","22882","22883","22884","22885","22886","22887","22888","22889","22890","22891","22892","22893","22894","22895","22896","22897","22898","22899","22900","22901","22902","22903","22904","22905","22906","22907","22908","22909","22910","22911","22912","22913","22914","22915","22916","22917","22918","22919","22920","22921","22922","22923","22924","22925","22926","22927","22928","22929","22930","22931","22932","22933","22934","22935","22936","22937","22938","22939","22940","22941","22942","22943","22944","22945","22946","22947","22948","22949","22950","22951","22952","22953","22954","22955","22956","22957","22958","22959","22960","22961","22962","22963","22964","22965","22966","22967","22968","22969","22970","22971","22972","22973","22974","22975","22976","22977","22978","22979","22980","22981","22982","22983","22984","22985","22986","22987","22988","22989","22990","22991","22992","22993","22994","22995","22996","22997","22998","22999","23000","23001","23002","23003","23004","23005","23006","23007","23008","23009","23010","23011","23012","23013","23014","23015","23016","23017","23018","23019","23020","23021","23022","23023","23024","23025","23026","23027","23028","23029","23030","23031","23032","23033","23034","23035","23036","23037","23038","23039","23040","23041","23042","23043","23044","23045","23046","23047","23048","23049","23050","23051","23052","23053","23054","23055","23056","23057","23058","23059","23060","23061","23062","23063","23064","23065","23066","23067","23068","23069","23070","23071","23072","23073","23074","23075","23076","23077","23078","23079","23080","23081","23082","23083","23084","23085","23086","23087","23088","23089","23090","23091","23092","23093","23094","23095","23096","23097","23098","23099","23100","23101","23102","23103","23104","23105","23106","23107","23108","23109","23110","23111","23112","23113","23114","23115","23116","23117","23118","23119","23120","23121","23122","23123","23124","23125","23126","23127","23128","23129","23130","23131","23132","23133","23134","23135","23136","23137","23138","23139","23140","23141","23142","23143","23144","23145","23146","23147","23148","23149","23150","23151","23152","23153","23154","23155","23156","23157","23158","23159","23160","23161","23162","23163","23164","23165","23166","23167","23168","23169","23170","23171","23172","23173","23174","23175","23176","23177","23178","23179","23180","23181","23182","23183","23184","23185","23186","23187","23188","23189","23190","23191","23192","23193","23194","23195","23196","23197","23198","23199","23200","23201","23202","23203","23204","23205","23206","23207","23208","23209","23210","23211","23212","23213","23214","23215","23216","23217","23218","23219","23220","23221","23222","23223","23224","23225","23226","23227","23228","23229","23230","23231","23232","23233","23234","23235","23236","23237","23238","23239","23240","23241","23242","23243","23244","23245","23246","23247","23248","23249","23250","23251","23252","23253","23254","23255","23256","23257","23258","23259","23260","23261","23262","23263","23264","23265","23266","23267","23268","23269","23270","23271","23272","23273","23274","23275","23276","23277","23278","23279","23280","23281","23282","23283","23284","23285","23286","23287","23288","23289","23290","23291","23292","23293","23294","23295","23296","23297","23298","23299","23300","23301","23302","23303","23304","23305","23306","23307","23308","23309","23310","23311","23312","23313","23314","23315","23316","23317","23318","23319","23320","23321","23322","23323","23324","23325","23326","23327","23328","23329","23330","23331","23332","23333","23334","23335","23336","23337","23338","23339","23340","23341","23342","23343","23344","23345","23346","23347","23348","23349","23350","23351","23352","23353","23354","23355","23356","23357","23358","23359","23360","23361","23362","23363","23364","23365","23366","23367","23368","23369","23370","23371","23372","23373","23374","23375","23376","23377","23378","23379","23380","23381","23382","23383","23384","23385","23386","23387","23388","23389","23390","23391","23392","23393","23394","23395","23396","23397","23398","23399","23400","23401","23402","23403","23404","23405","23406","23407","23408","23409","23410","23411","23412","23413","23414","23415","23416","23417","23418","23419","23420","23421","23422","23423","23424","23425","23426","23427","23428","23429","23430","23431","23432","23433","23434","23435","23436","23437","23438","23439","23440","23441","23442","23443","23444","23445","23446","23447","23448","23449","23450","23451","23452","23453","23454","23455","23456","23457","23458","23459","23460","23461","23462","23463","23464","23465","23466","23467","23468","23469","23470","23471","23472","23473","23474","23475","23476","23477","23478","23479","23480","23481","23482","23483","23484","23485","23486","23487","23488","23489","23490","23491","23492","23493","23494","23495","23496","23497","23498","23499","23500","23501","23502","23503","23504","23505","23506","23507","23508","23509","23510","23511","23512","23513","23514","23515","23516","23517","23518","23519","23520","23521","23522","23523","23524","23525","23526","23527","23528","23529","23530","23531","23532","23533","23534","23535","23536","23537","23538","23539","23540","23541","23542","23543","23544","23545","23546","23547","23548","23549","23550","23551","23552","23553","23554","23555","23556","23557","23558","23559","23560","23561","23562","23563","23564","23565","23566","23567","23568","23569","23570","23571","23572","23573","23574","23575","23576","23577","23578","23579","23580","23581","23582","23583","23584","23585","23586","23587","23588","23589","23590","23591","23592","23593","23594","23595","23596","23597","23598","23599","23600","23601","23602","23603","23604","23605","23606","23607","23608","23609","23610","23611","23612","23613","23614","23615","23616","23617","23618","23619","23620","23621","23622","23623","23624","23625","23626","23627","23628","23629","23630","23631","23632","23633","23634","23635","23636","23637","23638","23639","23640","23641","23642","23643","23644","23645","23646","23647","23648","23649","23650","23651","23652","23653","23654","23655","23656","23657","23658","23659","23660","23661","23662","23663","23664","23665","23666","23667","23668","23669","23670","23671","23672","23673","23674","23675","23676","23677","23678","23679","23680","23681","23682","23683","23684","23685","23686","23687","23688","23689","23690","23691","23692","23693","23694","23695","23696","23697","23698","23699","23700","23701","23702","23703","23704","23705","23706","23707","23708","23709","23710","23711","23712","23713","23714","23715","23716","23717","23718","23719","23720","23721","23722","23723","23724","23725","23726","23727","23728","23729","23730","23731","23732","23733","23734","23735","23736","23737","23738","23739","23740","23741","23742","23743","23744","23745","23746","23747","23748","23749","23750","23751","23752","23753","23754","23755","23756","23757","23758","23759","23760","23761","23762","23763","23764","23765","23766","23767","23768","23769","23770","23771","23772","23773","23774","23775","23776","23777","23778","23779","23780","23781","23782","23783","23784","23785","23786","23787","23788","23789","23790","23791","23792","23793","23794","23795","23796","23797","23798","23799","23800","23801","23802","23803","23804","23805","23806","23807","23808","23809","23810","23811","23812","23813","23814","23815","23816","23817","23818","23819","23820","23821","23822","23823","23824","23825","23826","23827","23828","23829","23830","23831","23832","23833","23834","23835","23836","23837","23838","23839","23840","23841","23842","23843","23844","23845","23846","23847","23848","23849","23850","23851","23852","23853","23854","23855","23856","23857","23858","23859","23860","23861","23862","23863","23864","23865","23866","23867","23868","23869","23870","23871","23872","23873","23874","23875","23876","23877","23878","23879","23880","23881","23882","23883","23884","23885","23886","23887","23888","23889","23890","23891","23892","23893","23894","23895","23896","23897","23898","23899","23900","23901","23902","23903","23904","23905","23906","23907","23908","23909","23910","23911","23912","23913","23914","23915","23916","23917","23918","23919","23920","23921","23922","23923","23924","23925","23926","23927","23928","23929","23930","23931","23932","23933","23934","23935","23936","23937","23938","23939","23940","23941","23942","23943","23944","23945","23946","23947","23948","23949","23950","23951","23952","23953","23954","23955","23956","23957","23958","23959","23960","23961","23962","23963","23964","23965","23966","23967","23968","23969","23970","23971","23972","23973","23974","23975","23976","23977","23978","23979","23980","23981","23982","23983","23984","23985","23986","23987","23988","23989","23990","23991","23992","23993","23994","23995","23996","23997","23998","23999","24000","24001","24002","24003","24004","24005","24006","24007","24008","24009","24010","24011","24012","24013","24014","24015","24016","24017","24018","24019","24020","24021","24022","24023","24024","24025","24026","24027","24028","24029","24030","24031","24032","24033","24034","24035","24036","24037","24038","24039","24040","24041","24042","24043","24044","24045","24046","24047","24048","24049","24050","24051","24052","24053","24054","24055","24056","24057","24058","24059","24060","24061","24062","24063","24064","24065","24066","24067","24068","24069","24070","24071","24072","24073","24074","24075","24076","24077","24078","24079","24080","24081","24082","24083","24084","24085","24086","24087","24088","24089","24090","24091","24092","24093","24094","24095","24096","24097","24098","24099","24100","24101","24102","24103","24104","24105","24106","24107","24108","24109","24110","24111","24112","24113","24114","24115","24116","24117","24118","24119","24120","24121","24122","24123","24124","24125","24126","24127","24128","24129","24130","24131","24132","24133","24134","24135","24136","24137","24138","24139","24140","24141","24142","24143","24144","24145","24146","24147","24148","24149","24150","24151","24152","24153","24154","24155","24156","24157","24158","24159","24160","24161","24162","24163","24164","24165","24166","24167","24168","24169","24170","24171","24172","24173","24174","24175","24176","24177","24178","24179","24180","24181","24182","24183","24184","24185","24186","24187","24188","24189","24190","24191","24192","24193","24194","24195","24196","24197","24198","24199","24200","24201","24202","24203","24204","24205","24206","24207","24208","24209","24210","24211","24212","24213","24214","24215","24216","24217","24218","24219","24220","24221","24222","24223","24224","24225","24226","24227","24228","24229","24230","24231","24232","24233","24234","24235","24236","24237","24238","24239","24240","24241","24242","24243","24244","24245","24246","24247","24248","24249","24250","24251","24252","24253","24254","24255","24256","24257","24258","24259","24260","24261","24262","24263","24264","24265","24266","24267","24268","24269","24270","24271","24272","24273","24274","24275","24276","24277","24278","24279","24280","24281","24282","24283","24284","24285","24286","24287","24288","24289","24290","24291","24292","24293","24294","24295","24296","24297","24298","24299","24300","24301","24302","24303","24304","24305","24306","24307","24308","24309","24310","24311","24312","24313","24314","24315","24316","24317","24318","24319","24320","24321","24322","24323","24324","24325","24326","24327","24328","24329","24330","24331","24332","24333","24334","24335","24336","24337","24338","24339","24340","24341","24342","24343","24344","24345","24346","24347","24348","24349","24350","24351","24352","24353","24354","24355","24356","24357","24358","24359","24360","24361","24362","24363","24364","24365","24366","24367","24368","24369","24370","24371","24372","24373","24374","24375","24376","24377","24378","24379","24380","24381","24382","24383","24384","24385","24386","24387","24388","24389","24390","24391","24392","24393","24394","24395","24396","24397","24398","24399","24400","24401","24402","24403","24404","24405","24406","24407","24408","24409","24410","24411","24412","24413","24414","24415","24416","24417","24418","24419","24420","24421","24422","24423","24424","24425","24426","24427","24428","24429","24430","24431","24432","24433","24434","24435","24436","24437","24438","24439","24440","24441","24442","24443","24444","24445","24446","24447","24448","24449","24450","24451","24452","24453","24454","24455","24456","24457","24458","24459","24460","24461","24462","24463","24464","24465","24466","24467","24468","24469","24470","24471","24472","24473","24474","24475","24476","24477","24478","24479","24480","24481","24482","24483","24484","24485","24486","24487","24488","24489","24490","24491","24492","24493","24494","24495","24496","24497","24498","24499","24500","24501","24502","24503","24504","24505","24506","24507","24508","24509","24510","24511","24512","24513","24514","24515","24516","24517","24518","24519","24520","24521","24522","24523","24524","24525","24526","24527","24528","24529","24530","24531","24532","24533","24534","24535","24536","24537","24538","24539","24540","24541","24542","24543","24544","24545","24546","24547","24548","24549","24550","24551","24552","24553","24554","24555","24556","24557","24558","24559","24560","24561","24562","24563","24564","24565","24566","24567","24568","24569","24570","24571","24572","24573","24574","24575","24576","24577","24578","24579","24580","24581","24582","24583","24584","24585","24586","24587","24588","24589","24590","24591","24592","24593","24594","24595","24596","24597","24598","24599","24600","24601","24602","24603","24604","24605","24606","24607","24608","24609","24610","24611","24612","24613","24614","24615","24616","24617","24618","24619","24620","24621","24622","24623","24624","24625","24626","24627","24628","24629","24630","24631","24632","24633","24634","24635","24636","24637","24638","24639","24640","24641","24642","24643","24644","24645","24646","24647","24648","24649","24650","24651","24652","24653","24654","24655","24656","24657","24658","24659","24660","24661","24662","24663","24664","24665","24666","24667","24668","24669","24670","24671","24672","24673","24674","24675","24676","24677","24678","24679","24680","24681","24682","24683","24684","24685","24686","24687","24688","24689","24690","24691","24692","24693","24694","24695","24696","24697","24698","24699","24700","24701","24702","24703","24704","24705","24706","24707","24708","24709","24710","24711","24712","24713","24714","24715","24716","24717","24718","24719","24720","24721","24722","24723","24724","24725","24726","24727","24728","24729","24730","24731","24732","24733","24734","24735","24736","24737","24738","24739","24740","24741","24742","24743","24744","24745","24746","24747","24748","24749","24750","24751","24752","24753","24754","24755","24756","24757","24758","24759","24760","24761","24762","24763","24764","24765","24766","24767","24768","24769","24770","24771","24772","24773","24774","24775","24776","24777","24778","24779","24780","24781","24782","24783","24784","24785","24786","24787","24788","24789","24790","24791","24792","24793","24794","24795","24796","24797","24798","24799","24800","24801","24802","24803","24804","24805","24806","24807","24808","24809","24810","24811","24812","24813","24814","24815","24816","24817","24818","24819","24820","24821","24822","24823","24824","24825","24826","24827","24828","24829","24830","24831","24832","24833","24834","24835","24836","24837","24838","24839","24840","24841","24842","24843","24844","24845","24846","24847","24848","24849","24850","24851","24852","24853","24854","24855","24856","24857","24858","24859","24860","24861","24862","24863","24864","24865","24866","24867","24868","24869","24870","24871","24872","24873","24874","24875","24876","24877","24878","24879","24880","24881","24882","24883","24884","24885","24886","24887","24888","24889","24890","24891","24892","24893","24894","24895","24896","24897","24898","24899","24900","24901","24902","24903","24904","24905","24906","24907","24908","24909","24910","24911","24912","24913","24914","24915","24916","24917","24918","24919","24920","24921","24922","24923","24924","24925","24926","24927","24928","24929","24930","24931","24932","24933","24934","24935","24936","24937","24938","24939","24940","24941","24942","24943","24944","24945","24946","24947","24948","24949","24950","24951","24952","24953","24954","24955","24956","24957","24958","24959","24960","24961","24962","24963","24964","24965","24966","24967","24968","24969","24970","24971","24972","24973","24974","24975","24976","24977","24978","24979","24980","24981","24982","24983","24984","24985","24986","24987","24988","24989","24990","24991","24992","24993","24994","24995","24996","24997","24998","24999","25000","25001","25002","25003","25004","25005","25006","25007","25008","25009","25010","25011","25012","25013","25014","25015","25016","25017","25018","25019","25020","25021","25022","25023","25024","25025","25026","25027","25028","25029","25030","25031","25032","25033","25034","25035","25036","25037","25038","25039","25040","25041","25042","25043","25044","25045","25046","25047","25048","25049","25050","25051","25052","25053","25054","25055","25056","25057","25058","25059","25060","25061","25062","25063","25064","25065","25066","25067","25068","25069","25070","25071","25072","25073","25074","25075","25076","25077","25078","25079","25080","25081","25082","25083","25084","25085","25086","25087","25088","25089","25090","25091","25092","25093","25094","25095","25096","25097","25098","25099","25100","25101","25102","25103","25104","25105","25106","25107","25108","25109","25110","25111","25112","25113","25114","25115","25116","25117","25118","25119","25120","25121","25122","25123","25124","25125","25126","25127","25128","25129","25130","25131","25132","25133","25134","25135","25136","25137","25138","25139","25140","25141","25142","25143","25144","25145","25146","25147","25148","25149","25150","25151","25152","25153","25154","25155","25156","25157","25158","25159","25160","25161","25162","25163","25164","25165","25166","25167","25168","25169","25170","25171","25172","25173","25174","25175","25176","25177","25178","25179","25180","25181","25182","25183","25184","25185","25186","25187","25188","25189","25190","25191","25192","25193","25194","25195","25196","25197","25198","25199","25200","25201","25202","25203","25204","25205","25206","25207","25208","25209","25210","25211","25212","25213","25214","25215","25216","25217","25218","25219","25220","25221","25222","25223","25224","25225","25226","25227","25228","25229","25230","25231","25232","25233","25234","25235","25236","25237","25238","25239","25240","25241","25242","25243","25244","25245","25246","25247","25248","25249","25250","25251","25252","25253","25254","25255","25256","25257","25258","25259","25260","25261","25262","25263","25264","25265","25266","25267","25268","25269","25270","25271","25272","25273","25274","25275","25276","25277","25278","25279","25280","25281","25282","25283","25284","25285","25286","25287","25288","25289","25290","25291","25292","25293","25294","25295","25296","25297","25298","25299","25300","25301","25302","25303","25304","25305","25306","25307","25308","25309","25310","25311","25312","25313","25314","25315","25316","25317","25318","25319","25320","25321","25322","25323","25324","25325","25326","25327","25328","25329","25330","25331","25332","25333","25334","25335","25336","25337","25338","25339","25340","25341","25342","25343","25344","25345","25346","25347","25348","25349","25350","25351","25352","25353","25354","25355","25356","25357","25358","25359","25360","25361","25362","25363","25364","25365","25366","25367","25368","25369","25370","25371","25372","25373","25374","25375","25376","25377","25378","25379","25380","25381","25382","25383","25384","25385","25386","25387","25388","25389","25390","25391","25392","25393","25394","25395","25396","25397","25398","25399","25400","25401","25402","25403","25404","25405","25406","25407","25408","25409","25410","25411","25412","25413","25414","25415","25416","25417","25418","25419","25420","25421","25422","25423","25424","25425","25426","25427","25428","25429","25430","25431","25432","25433","25434","25435","25436","25437","25438","25439","25440","25441","25442","25443","25444","25445","25446","25447","25448","25449","25450","25451","25452","25453","25454","25455","25456","25457","25458","25459","25460","25461","25462","25463","25464","25465","25466","25467","25468","25469","25470","25471","25472","25473","25474","25475","25476","25477","25478","25479","25480","25481","25482","25483","25484","25485","25486","25487","25488","25489","25490","25491","25492","25493","25494","25495","25496","25497","25498","25499","25500","25501","25502","25503","25504","25505","25506","25507","25508","25509","25510","25511","25512","25513","25514","25515","25516","25517","25518","25519","25520","25521","25522","25523","25524","25525","25526","25527","25528","25529","25530","25531","25532","25533","25534","25535","25536","25537","25538","25539","25540","25541","25542","25543","25544","25545","25546","25547","25548","25549","25550","25551","25552","25553","25554","25555","25556","25557","25558","25559","25560","25561","25562","25563","25564","25565","25566","25567","25568","25569","25570","25571","25572","25573","25574","25575","25576","25577","25578","25579","25580","25581","25582","25583","25584","25585","25586","25587","25588","25589","25590","25591","25592","25593","25594","25595","25596","25597","25598","25599","25600","25601","25602","25603","25604","25605","25606","25607","25608","25609","25610","25611","25612","25613","25614","25615","25616","25617","25618","25619","25620","25621","25622","25623","25624","25625","25626","25627","25628","25629","25630","25631","25632","25633","25634","25635","25636","25637","25638","25639","25640","25641","25642","25643","25644","25645","25646","25647","25648","25649","25650","25651","25652","25653","25654","25655","25656","25657","25658","25659","25660","25661","25662","25663","25664","25665","25666","25667","25668","25669","25670","25671","25672","25673","25674","25675","25676","25677","25678","25679","25680","25681","25682","25683","25684","25685","25686","25687","25688","25689","25690","25691","25692","25693","25694","25695","25696","25697","25698","25699","25700","25701","25702","25703","25704","25705","25706","25707","25708","25709","25710","25711","25712","25713","25714","25715","25716","25717","25718","25719","25720","25721","25722","25723","25724","25725","25726","25727","25728","25729","25730","25731","25732","25733","25734","25735","25736","25737","25738","25739","25740","25741","25742","25743","25744","25745","25746","25747","25748","25749","25750","25751","25752","25753","25754","25755","25756","25757","25758","25759","25760","25761","25762","25763","25764","25765","25766","25767","25768","25769","25770","25771","25772","25773","25774","25775","25776","25777","25778","25779","25780","25781","25782","25783","25784","25785","25786","25787","25788","25789","25790","25791","25792","25793","25794","25795","25796","25797","25798","25799","25800","25801","25802","25803","25804","25805","25806","25807","25808","25809","25810","25811","25812","25813","25814","25815","25816","25817","25818","25819","25820","25821","25822","25823","25824","25825","25826","25827","25828","25829","25830","25831","25832","25833","25834","25835","25836","25837","25838","25839","25840","25841","25842","25843","25844","25845","25846","25847","25848","25849","25850","25851","25852","25853","25854","25855","25856","25857","25858","25859","25860","25861","25862","25863","25864","25865","25866","25867","25868","25869","25870","25871","25872","25873","25874","25875","25876","25877","25878","25879","25880","25881","25882","25883","25884","25885","25886","25887","25888","25889","25890","25891","25892","25893","25894","25895","25896","25897","25898","25899","25900","25901","25902","25903","25904","25905","25906","25907","25908","25909","25910","25911","25912","25913","25914","25915","25916","25917","25918","25919","25920","25921","25922","25923","25924","25925","25926","25927","25928","25929","25930","25931","25932","25933","25934","25935","25936","25937","25938","25939","25940","25941","25942","25943","25944","25945","25946","25947","25948","25949","25950","25951","25952","25953","25954","25955","25956","25957","25958","25959","25960","25961","25962","25963","25964","25965","25966","25967","25968","25969","25970","25971","25972","25973","25974","25975","25976","25977","25978","25979","25980","25981","25982","25983","25984","25985","25986","25987","25988","25989","25990","25991","25992","25993","25994","25995","25996","25997","25998","25999","26000","26001","26002","26003","26004","26005","26006","26007","26008","26009","26010","26011","26012","26013","26014","26015","26016","26017","26018","26019","26020","26021","26022","26023","26024","26025","26026","26027","26028","26029","26030","26031","26032","26033","26034","26035","26036","26037","26038","26039","26040","26041","26042","26043","26044","26045","26046","26047","26048","26049","26050","26051","26052","26053","26054","26055","26056","26057","26058","26059","26060","26061","26062","26063","26064","26065","26066","26067","26068","26069","26070","26071","26072","26073","26074","26075","26076","26077","26078","26079","26080","26081","26082","26083","26084","26085","26086","26087","26088","26089","26090","26091","26092","26093","26094","26095","26096","26097","26098","26099","26100","26101","26102","26103","26104","26105","26106","26107","26108","26109","26110","26111","26112","26113","26114","26115","26116","26117","26118","26119","26120","26121","26122","26123","26124","26125","26126","26127","26128","26129","26130","26131","26132","26133","26134","26135","26136","26137","26138","26139","26140","26141","26142","26143","26144","26145","26146","26147","26148","26149","26150","26151","26152","26153","26154","26155","26156","26157","26158","26159","26160","26161","26162","26163","26164","26165","26166","26167","26168","26169","26170","26171","26172","26173","26174","26175","26176","26177","26178","26179","26180","26181","26182","26183","26184","26185","26186","26187","26188","26189","26190","26191","26192","26193","26194","26195","26196","26197","26198","26199","26200","26201","26202","26203","26204","26205","26206","26207","26208","26209","26210","26211","26212","26213","26214","26215","26216","26217","26218","26219","26220","26221","26222","26223","26224","26225","26226","26227","26228","26229","26230","26231","26232","26233","26234","26235","26236","26237","26238","26239","26240","26241","26242","26243","26244","26245","26246","26247","26248","26249","26250","26251","26252","26253","26254","26255","26256","26257","26258","26259","26260","26261","26262","26263","26264","26265","26266","26267","26268","26269","26270","26271","26272","26273","26274","26275","26276","26277","26278","26279","26280","26281","26282","26283","26284","26285","26286","26287","26288","26289","26290","26291","26292","26293","26294","26295","26296","26297","26298","26299","26300","26301","26302","26303","26304","26305","26306","26307","26308","26309","26310","26311","26312","26313","26314","26315","26316","26317","26318","26319","26320","26321","26322","26323","26324","26325","26326","26327","26328","26329","26330","26331","26332","26333","26334","26335","26336","26337","26338","26339","26340","26341","26342","26343","26344","26345","26346","26347","26348","26349","26350","26351","26352","26353","26354","26355","26356","26357","26358","26359","26360","26361","26362","26363","26364","26365","26366","26367","26368","26369","26370","26371","26372","26373","26374","26375","26376","26377","26378","26379","26380","26381","26382","26383","26384","26385","26386","26387","26388","26389","26390","26391","26392","26393","26394","26395","26396","26397","26398","26399","26400","26401","26402","26403","26404","26405","26406","26407","26408","26409","26410","26411","26412","26413","26414","26415","26416","26417","26418","26419","26420","26421","26422","26423","26424","26425","26426","26427","26428","26429","26430","26431","26432","26433","26434","26435","26436","26437","26438","26439","26440","26441","26442","26443","26444","26445","26446","26447","26448","26449","26450","26451","26452","26453","26454","26455","26456","26457","26458","26459","26460","26461","26462","26463","26464","26465","26466","26467","26468","26469","26470","26471","26472","26473","26474","26475","26476","26477","26478","26479","26480","26481","26482","26483","26484","26485","26486","26487","26488","26489","26490","26491","26492","26493","26494","26495","26496","26497","26498","26499","26500","26501","26502","26503","26504","26505","26506","26507","26508","26509","26510","26511","26512","26513","26514","26515","26516","26517","26518","26519","26520","26521","26522","26523","26524","26525","26526","26527","26528","26529","26530","26531","26532","26533","26534","26535","26536","26537","26538","26539","26540","26541","26542","26543","26544","26545","26546","26547","26548","26549","26550","26551","26552","26553","26554","26555","26556","26557","26558","26559","26560","26561","26562","26563","26564","26565","26566","26567","26568","26569","26570","26571","26572","26573","26574","26575","26576","26577","26578","26579","26580","26581","26582","26583","26584","26585","26586","26587","26588","26589","26590","26591","26592","26593","26594","26595","26596","26597","26598","26599","26600","26601","26602","26603","26604","26605","26606","26607","26608","26609","26610","26611","26612","26613","26614","26615","26616","26617","26618","26619","26620","26621","26622","26623","26624","26625","26626","26627","26628","26629","26630","26631","26632","26633","26634","26635","26636","26637","26638","26639","26640","26641","26642","26643","26644","26645","26646","26647","26648","26649","26650","26651","26652","26653","26654","26655","26656","26657","26658","26659","26660","26661","26662","26663","26664","26665","26666","26667","26668","26669","26670","26671","26672","26673","26674","26675","26676","26677","26678","26679","26680","26681","26682","26683","26684","26685","26686","26687","26688","26689","26690","26691","26692","26693","26694","26695","26696","26697","26698","26699","26700","26701","26702","26703","26704","26705","26706","26707","26708","26709","26710","26711","26712","26713","26714","26715","26716","26717","26718","26719","26720","26721","26722","26723","26724","26725","26726","26727","26728","26729","26730","26731","26732","26733","26734","26735","26736","26737","26738","26739","26740","26741","26742","26743","26744","26745","26746","26747","26748","26749","26750","26751","26752","26753","26754","26755","26756","26757","26758","26759","26760","26761","26762","26763","26764","26765","26766","26767","26768","26769","26770","26771","26772","26773","26774","26775","26776","26777","26778","26779","26780","26781","26782","26783","26784","26785","26786","26787","26788","26789","26790","26791","26792","26793","26794","26795","26796","26797","26798","26799","26800","26801","26802","26803","26804","26805","26806","26807","26808","26809","26810","26811","26812","26813","26814","26815","26816","26817","26818","26819","26820","26821","26822","26823","26824","26825","26826","26827","26828","26829","26830","26831","26832","26833","26834","26835","26836","26837","26838","26839","26840","26841","26842","26843","26844","26845","26846","26847","26848","26849","26850","26851","26852","26853","26854","26855","26856","26857","26858","26859","26860","26861","26862","26863","26864","26865","26866","26867","26868","26869","26870","26871","26872","26873","26874","26875","26876","26877","26878","26879","26880","26881","26882","26883","26884","26885","26886","26887","26888","26889","26890","26891","26892","26893","26894","26895","26896","26897","26898","26899","26900","26901","26902","26903","26904","26905","26906","26907","26908","26909","26910","26911","26912","26913","26914","26915","26916","26917","26918","26919","26920","26921","26922","26923","26924","26925","26926","26927","26928","26929","26930","26931","26932","26933","26934","26935","26936","26937","26938","26939","26940","26941","26942","26943","26944","26945","26946","26947","26948","26949","26950","26951","26952","26953","26954","26955","26956","26957","26958","26959","26960","26961","26962","26963","26964","26965","26966","26967","26968","26969","26970","26971","26972","26973","26974","26975","26976","26977","26978","26979","26980","26981","26982","26983","26984","26985","26986","26987","26988","26989","26990","26991","26992","26993","26994","26995","26996","26997","26998","26999","27000","27001","27002","27003","27004","27005","27006","27007","27008","27009","27010","27011","27012","27013","27014","27015","27016","27017","27018","27019","27020","27021","27022","27023","27024","27025","27026","27027","27028","27029","27030","27031","27032","27033","27034","27035","27036","27037","27038","27039","27040","27041","27042","27043","27044","27045","27046","27047","27048","27049","27050","27051","27052","27053","27054","27055","27056","27057","27058","27059","27060","27061","27062","27063","27064","27065","27066","27067","27068","27069","27070","27071","27072","27073","27074","27075","27076","27077","27078","27079","27080","27081","27082","27083","27084","27085","27086","27087","27088","27089","27090","27091","27092","27093","27094","27095","27096","27097","27098","27099","27100","27101","27102","27103","27104","27105","27106","27107","27108","27109","27110","27111","27112","27113","27114","27115","27116","27117","27118","27119","27120","27121","27122","27123","27124","27125","27126","27127","27128","27129","27130","27131","27132","27133","27134","27135","27136","27137","27138","27139","27140","27141","27142","27143","27144","27145","27146","27147","27148","27149","27150","27151","27152","27153","27154","27155","27156","27157","27158","27159","27160","27161","27162","27163","27164","27165","27166","27167","27168","27169","27170","27171","27172","27173","27174","27175","27176","27177","27178","27179","27180","27181","27182","27183","27184","27185","27186","27187","27188","27189","27190","27191","27192","27193","27194","27195","27196","27197","27198","27199","27200","27201","27202","27203","27204","27205","27206","27207","27208","27209","27210","27211","27212","27213","27214","27215","27216","27217","27218","27219","27220","27221","27222","27223","27224","27225","27226","27227","27228","27229","27230","27231","27232","27233","27234","27235","27236","27237","27238","27239","27240","27241","27242","27243","27244","27245","27246","27247","27248","27249","27250","27251","27252","27253","27254","27255","27256","27257","27258","27259","27260","27261","27262","27263","27264","27265","27266","27267","27268","27269","27270","27271","27272","27273","27274","27275","27276","27277","27278","27279","27280","27281","27282","27283","27284","27285","27286","27287","27288","27289","27290","27291","27292","27293","27294","27295","27296","27297","27298","27299","27300","27301","27302","27303","27304","27305","27306","27307","27308","27309","27310","27311","27312","27313","27314","27315","27316","27317","27318","27319","27320","27321","27322","27323","27324","27325","27326","27327","27328","27329","27330","27331","27332","27333","27334","27335","27336","27337","27338","27339","27340","27341","27342","27343","27344","27345","27346","27347","27348","27349","27350","27351","27352","27353","27354","27355","27356","27357","27358","27359","27360","27361","27362","27363","27364","27365","27366","27367","27368","27369","27370","27371","27372","27373","27374","27375","27376","27377","27378","27379","27380","27381","27382","27383","27384","27385","27386","27387","27388","27389","27390","27391","27392","27393","27394","27395","27396","27397","27398","27399","27400","27401","27402","27403","27404","27405","27406","27407","27408","27409","27410","27411","27412","27413","27414","27415","27416","27417","27418","27419","27420","27421","27422","27423","27424","27425","27426","27427","27428","27429","27430","27431","27432","27433","27434","27435","27436","27437","27438","27439","27440","27441","27442","27443","27444","27445","27446","27447","27448","27449","27450","27451","27452","27453","27454","27455","27456","27457","27458","27459","27460","27461","27462","27463","27464","27465","27466","27467","27468","27469","27470","27471","27472","27473","27474","27475","27476","27477","27478","27479","27480","27481","27482","27483","27484","27485","27486","27487","27488","27489","27490","27491","27492","27493","27494","27495","27496","27497","27498","27499","27500","27501","27502","27503","27504","27505","27506","27507","27508","27509","27510","27511","27512","27513","27514","27515","27516","27517","27518","27519","27520","27521","27522","27523","27524","27525","27526","27527","27528","27529","27530","27531","27532","27533","27534","27535","27536","27537","27538","27539","27540","27541","27542","27543","27544","27545","27546","27547","27548","27549","27550","27551","27552","27553","27554","27555","27556","27557","27558","27559","27560","27561","27562","27563","27564","27565","27566","27567","27568","27569","27570","27571","27572","27573","27574","27575","27576","27577","27578","27579","27580","27581","27582","27583","27584","27585","27586","27587","27588","27589","27590","27591","27592","27593","27594","27595","27596","27597","27598","27599","27600","27601","27602","27603","27604","27605","27606","27607","27608","27609","27610","27611","27612","27613","27614","27615","27616","27617","27618","27619","27620","27621","27622","27623","27624","27625","27626","27627","27628","27629","27630","27631","27632","27633","27634","27635","27636","27637","27638","27639","27640","27641","27642","27643","27644","27645","27646","27647","27648","27649","27650","27651","27652","27653","27654","27655","27656","27657","27658","27659","27660","27661","27662","27663","27664","27665","27666","27667","27668","27669","27670","27671","27672","27673","27674","27675","27676","27677","27678","27679","27680","27681","27682","27683","27684","27685","27686","27687","27688","27689","27690","27691","27692","27693","27694","27695","27696","27697","27698","27699","27700","27701","27702","27703","27704","27705","27706","27707","27708","27709","27710","27711","27712","27713","27714","27715","27716","27717","27718","27719","27720","27721","27722","27723","27724","27725","27726","27727","27728","27729","27730","27731","27732","27733","27734","27735","27736","27737","27738","27739","27740","27741","27742","27743","27744","27745","27746","27747","27748","27749","27750","27751","27752","27753","27754","27755","27756","27757","27758","27759","27760","27761","27762","27763","27764","27765","27766","27767","27768","27769","27770","27771","27772","27773","27774","27775","27776","27777","27778","27779","27780","27781","27782","27783","27784","27785","27786","27787","27788","27789","27790","27791","27792","27793","27794","27795","27796","27797","27798","27799","27800","27801","27802","27803","27804","27805","27806","27807","27808","27809","27810","27811","27812","27813","27814","27815","27816","27817","27818","27819","27820","27821","27822","27823","27824","27825","27826","27827","27828","27829","27830","27831","27832","27833","27834","27835","27836","27837","27838","27839","27840","27841","27842","27843","27844","27845","27846","27847","27848","27849","27850","27851","27852","27853","27854","27855","27856","27857","27858","27859","27860","27861","27862","27863","27864","27865","27866","27867","27868","27869","27870","27871","27872","27873","27874","27875","27876","27877","27878","27879","27880","27881","27882","27883","27884","27885","27886","27887","27888","27889","27890","27891","27892","27893","27894","27895","27896","27897","27898","27899","27900","27901","27902","27903","27904","27905","27906","27907","27908","27909","27910","27911","27912","27913","27914","27915","27916","27917","27918","27919","27920","27921","27922","27923","27924","27925","27926","27927","27928","27929","27930","27931","27932","27933","27934","27935","27936","27937","27938","27939","27940","27941","27942","27943","27944","27945","27946","27947","27948","27949","27950","27951","27952","27953","27954","27955","27956","27957","27958","27959","27960","27961","27962","27963","27964","27965","27966","27967","27968","27969","27970","27971","27972","27973","27974","27975","27976","27977","27978","27979","27980","27981","27982","27983","27984","27985","27986","27987","27988","27989","27990","27991","27992","27993","27994","27995","27996","27997","27998","27999","28000","28001","28002","28003","28004","28005","28006","28007","28008","28009","28010","28011","28012","28013","28014","28015","28016","28017","28018","28019","28020","28021","28022","28023","28024","28025","28026","28027","28028","28029","28030","28031","28032","28033","28034","28035","28036","28037","28038","28039","28040","28041","28042","28043","28044","28045","28046","28047","28048","28049","28050","28051","28052","28053","28054","28055","28056","28057","28058","28059","28060","28061","28062","28063","28064","28065","28066","28067","28068","28069","28070","28071","28072","28073","28074","28075","28076","28077","28078","28079","28080","28081","28082","28083","28084","28085","28086","28087","28088","28089","28090","28091","28092","28093","28094","28095","28096","28097","28098","28099","28100","28101","28102","28103","28104","28105","28106","28107","28108","28109","28110","28111","28112","28113","28114","28115","28116","28117","28118","28119","28120","28121","28122","28123","28124","28125","28126","28127","28128","28129","28130","28131","28132","28133","28134","28135","28136","28137","28138","28139","28140","28141","28142","28143","28144","28145","28146","28147","28148","28149","28150","28151","28152","28153","28154","28155","28156","28157","28158","28159","28160","28161","28162","28163","28164","28165","28166","28167","28168","28169","28170","28171","28172","28173","28174","28175","28176","28177","28178","28179","28180","28181","28182","28183","28184","28185","28186","28187","28188","28189","28190","28191","28192","28193","28194","28195","28196","28197","28198","28199","28200","28201","28202","28203","28204","28205","28206","28207","28208","28209","28210","28211","28212","28213","28214","28215","28216","28217","28218","28219","28220","28221","28222","28223","28224","28225","28226","28227","28228","28229","28230","28231","28232","28233","28234","28235","28236","28237","28238","28239","28240","28241","28242","28243","28244","28245","28246","28247","28248","28249","28250","28251","28252","28253","28254","28255","28256","28257","28258","28259","28260","28261","28262","28263","28264","28265","28266","28267","28268","28269","28270","28271","28272","28273","28274","28275","28276","28277","28278","28279","28280","28281","28282","28283","28284","28285","28286","28287","28288","28289","28290","28291","28292","28293","28294","28295","28296","28297","28298","28299","28300","28301","28302","28303","28304","28305","28306","28307","28308","28309","28310","28311","28312","28313","28314","28315","28316","28317","28318","28319","28320","28321","28322","28323","28324","28325","28326","28327","28328","28329","28330","28331","28332","28333","28334","28335","28336","28337","28338","28339","28340","28341","28342","28343","28344","28345","28346","28347","28348","28349","28350","28351","28352","28353","28354","28355","28356","28357","28358","28359","28360","28361","28362","28363","28364","28365","28366","28367","28368","28369","28370","28371","28372","28373","28374","28375","28376","28377","28378","28379","28380","28381","28382","28383","28384","28385","28386","28387","28388","28389","28390","28391","28392","28393","28394","28395","28396","28397","28398","28399","28400","28401","28402","28403","28404","28405","28406","28407","28408","28409","28410","28411","28412","28413","28414","28415","28416","28417","28418","28419","28420","28421","28422","28423","28424","28425","28426","28427","28428","28429","28430","28431","28432","28433","28434","28435","28436","28437","28438","28439","28440","28441","28442","28443","28444","28445","28446","28447","28448","28449","28450","28451","28452","28453","28454","28455","28456","28457","28458","28459","28460","28461","28462","28463","28464","28465","28466","28467","28468","28469","28470","28471","28472","28473","28474","28475","28476","28477","28478","28479","28480","28481","28482","28483","28484","28485","28486","28487","28488","28489","28490","28491","28492","28493","28494","28495","28496","28497","28498","28499","28500","28501","28502","28503","28504","28505","28506","28507","28508","28509","28510","28511","28512","28513","28514","28515","28516","28517","28518","28519","28520","28521","28522","28523","28524","28525","28526","28527","28528","28529","28530","28531","28532","28533","28534","28535","28536","28537","28538","28539","28540","28541","28542","28543","28544","28545","28546","28547","28548","28549","28550","28551","28552","28553","28554","28555","28556","28557","28558","28559","28560","28561","28562","28563","28564","28565","28566","28567","28568","28569","28570","28571","28572","28573","28574","28575","28576","28577","28578","28579","28580","28581","28582","28583","28584","28585","28586","28587","28588","28589","28590","28591","28592","28593","28594","28595","28596","28597","28598","28599","28600","28601","28602","28603","28604","28605","28606","28607","28608","28609","28610","28611","28612","28613","28614","28615","28616","28617","28618","28619","28620","28621","28622","28623","28624","28625","28626","28627","28628","28629","28630","28631","28632","28633","28634","28635","28636","28637","28638","28639","28640","28641","28642","28643","28644","28645","28646","28647","28648","28649","28650","28651","28652","28653","28654","28655","28656","28657","28658","28659","28660","28661","28662","28663","28664","28665","28666","28667","28668","28669","28670","28671","28672","28673","28674","28675","28676","28677","28678","28679","28680","28681","28682","28683","28684","28685","28686","28687","28688","28689","28690","28691","28692","28693","28694","28695","28696","28697","28698","28699","28700","28701","28702","28703","28704","28705","28706","28707","28708","28709","28710","28711","28712","28713","28714","28715","28716","28717","28718","28719","28720","28721","28722","28723","28724","28725","28726","28727","28728","28729","28730","28731","28732","28733","28734","28735","28736","28737","28738","28739","28740","28741","28742","28743","28744","28745","28746","28747","28748","28749","28750","28751","28752","28753","28754","28755","28756","28757","28758","28759","28760","28761","28762","28763","28764","28765","28766","28767","28768","28769","28770","28771","28772","28773","28774","28775","28776","28777","28778","28779","28780","28781","28782","28783","28784","28785","28786","28787","28788","28789","28790","28791","28792","28793","28794","28795","28796","28797","28798","28799","28800","28801","28802","28803","28804","28805","28806","28807","28808","28809","28810","28811","28812","28813","28814","28815","28816","28817","28818","28819","28820","28821","28822","28823","28824","28825","28826","28827","28828","28829","28830","28831","28832","28833","28834","28835","28836","28837","28838","28839","28840","28841","28842","28843","28844","28845","28846","28847","28848","28849","28850","28851","28852","28853","28854","28855","28856","28857","28858","28859","28860","28861","28862","28863","28864","28865","28866","28867","28868","28869","28870","28871","28872","28873","28874","28875","28876","28877","28878","28879","28880","28881","28882","28883","28884","28885","28886","28887","28888","28889","28890","28891","28892","28893","28894","28895","28896","28897","28898","28899","28900","28901","28902","28903","28904","28905","28906","28907","28908","28909","28910","28911","28912","28913","28914","28915","28916","28917","28918","28919","28920","28921","28922","28923","28924","28925","28926","28927","28928","28929","28930","28931","28932","28933","28934","28935","28936","28937","28938","28939","28940","28941","28942","28943","28944","28945","28946","28947","28948","28949","28950","28951","28952","28953","28954","28955","28956","28957","28958","28959","28960","28961","28962","28963","28964","28965","28966","28967","28968","28969","28970","28971","28972","28973","28974","28975","28976","28977","28978","28979","28980","28981","28982","28983","28984","28985","28986","28987","28988","28989","28990","28991","28992","28993","28994","28995","28996","28997","28998","28999","29000","29001","29002","29003","29004","29005","29006","29007","29008","29009","29010","29011","29012","29013","29014","29015","29016","29017","29018","29019","29020","29021","29022","29023","29024","29025","29026","29027","29028","29029","29030","29031","29032","29033","29034","29035","29036","29037","29038","29039","29040","29041","29042","29043","29044","29045","29046","29047","29048","29049","29050","29051","29052","29053","29054","29055","29056","29057","29058","29059","29060","29061","29062","29063","29064","29065","29066","29067","29068","29069","29070","29071","29072","29073","29074","29075","29076","29077","29078","29079","29080","29081","29082","29083","29084","29085","29086","29087","29088","29089","29090","29091","29092","29093","29094","29095","29096","29097","29098","29099","29100","29101","29102","29103","29104","29105","29106","29107","29108","29109","29110","29111","29112","29113","29114","29115","29116","29117","29118","29119","29120","29121","29122","29123","29124","29125","29126","29127","29128","29129","29130","29131","29132","29133","29134","29135","29136","29137","29138","29139","29140","29141","29142","29143","29144","29145","29146","29147","29148","29149","29150","29151","29152","29153","29154","29155","29156","29157","29158","29159","29160","29161","29162","29163","29164","29165","29166","29167","29168","29169","29170","29171","29172","29173","29174","29175","29176","29177","29178","29179","29180","29181","29182","29183","29184","29185","29186","29187","29188","29189","29190","29191","29192","29193","29194","29195","29196","29197","29198","29199","29200","29201","29202","29203","29204","29205","29206","29207","29208","29209","29210","29211","29212","29213","29214","29215","29216","29217","29218","29219","29220","29221","29222","29223","29224","29225","29226","29227","29228","29229","29230","29231","29232","29233","29234","29235","29236","29237","29238","29239","29240","29241","29242","29243","29244","29245","29246","29247","29248","29249","29250","29251","29252","29253","29254","29255","29256","29257","29258","29259","29260","29261","29262","29263","29264","29265","29266","29267","29268","29269","29270","29271","29272","29273","29274","29275","29276","29277","29278","29279","29280","29281","29282","29283","29284","29285","29286","29287","29288","29289","29290","29291","29292","29293","29294","29295","29296","29297","29298","29299","29300","29301","29302","29303","29304","29305","29306","29307","29308","29309","29310","29311","29312","29313","29314","29315","29316","29317","29318","29319","29320","29321","29322","29323","29324","29325","29326","29327","29328","29329","29330","29331","29332","29333","29334","29335","29336","29337","29338","29339","29340","29341","29342","29343","29344","29345","29346","29347","29348","29349","29350","29351","29352","29353","29354","29355","29356","29357","29358","29359","29360","29361","29362","29363","29364","29365","29366","29367","29368","29369","29370","29371","29372","29373","29374","29375","29376","29377","29378","29379","29380","29381","29382","29383","29384","29385","29386","29387","29388","29389","29390","29391","29392","29393","29394","29395","29396","29397","29398","29399","29400","29401","29402","29403","29404","29405","29406","29407","29408","29409","29410","29411","29412","29413","29414","29415","29416","29417","29418","29419","29420","29421","29422","29423","29424","29425","29426","29427","29428","29429","29430","29431","29432","29433","29434","29435","29436","29437","29438","29439","29440","29441","29442","29443","29444","29445","29446","29447","29448","29449","29450","29451","29452","29453","29454","29455","29456","29457","29458","29459","29460","29461","29462","29463","29464","29465","29466","29467","29468","29469","29470","29471","29472","29473","29474","29475","29476","29477","29478","29479","29480","29481","29482","29483","29484","29485","29486","29487","29488","29489","29490","29491","29492","29493","29494","29495","29496","29497","29498","29499","29500","29501","29502","29503","29504","29505","29506","29507","29508","29509","29510","29511","29512","29513","29514","29515","29516","29517","29518","29519","29520","29521","29522","29523","29524","29525","29526","29527","29528","29529","29530","29531","29532","29533","29534","29535","29536","29537","29538","29539","29540","29541","29542","29543","29544","29545","29546","29547","29548","29549","29550","29551","29552","29553","29554","29555","29556","29557","29558","29559","29560","29561","29562","29563","29564","29565","29566","29567","29568","29569","29570","29571","29572","29573","29574","29575","29576","29577","29578","29579","29580","29581","29582","29583","29584","29585","29586","29587","29588","29589","29590","29591","29592","29593","29594","29595","29596","29597","29598","29599","29600","29601","29602","29603","29604","29605","29606","29607","29608","29609","29610","29611","29612","29613","29614","29615","29616","29617","29618","29619","29620","29621","29622","29623","29624","29625","29626","29627","29628","29629","29630","29631","29632","29633","29634","29635","29636","29637","29638","29639","29640","29641","29642","29643","29644","29645","29646","29647","29648","29649","29650","29651","29652","29653","29654","29655","29656","29657","29658","29659","29660","29661","29662","29663","29664","29665","29666","29667","29668","29669","29670","29671","29672","29673","29674","29675","29676","29677","29678","29679","29680","29681","29682","29683","29684","29685","29686","29687","29688","29689","29690","29691","29692","29693","29694","29695","29696","29697","29698","29699","29700","29701","29702","29703","29704","29705","29706","29707","29708","29709","29710","29711","29712","29713","29714","29715","29716","29717","29718","29719","29720","29721","29722","29723","29724","29725","29726","29727","29728","29729","29730","29731","29732","29733","29734","29735","29736","29737","29738","29739","29740","29741","29742","29743","29744","29745","29746","29747","29748","29749","29750","29751","29752","29753","29754","29755","29756","29757","29758","29759","29760","29761","29762","29763","29764","29765","29766","29767","29768","29769","29770","29771","29772","29773","29774","29775","29776","29777","29778","29779","29780","29781","29782","29783","29784","29785","29786","29787","29788","29789","29790","29791","29792","29793","29794","29795","29796","29797","29798","29799","29800","29801","29802","29803","29804","29805","29806","29807","29808","29809","29810","29811","29812","29813","29814","29815","29816","29817","29818","29819","29820","29821","29822","29823","29824","29825","29826","29827","29828","29829","29830","29831","29832","29833","29834","29835","29836","29837","29838","29839","29840","29841","29842","29843","29844","29845","29846","29847","29848","29849","29850","29851","29852","29853","29854","29855","29856","29857","29858","29859","29860","29861","29862","29863","29864","29865","29866","29867","29868","29869","29870","29871","29872","29873","29874","29875","29876","29877","29878","29879","29880","29881","29882","29883","29884","29885","29886","29887","29888","29889","29890","29891","29892","29893","29894","29895","29896","29897","29898","29899","29900","29901","29902","29903","29904","29905","29906","29907","29908","29909","29910","29911","29912","29913","29914","29915","29916","29917","29918","29919","29920","29921","29922","29923","29924","29925","29926","29927","29928","29929","29930","29931","29932","29933","29934","29935","29936","29937","29938","29939","29940","29941","29942","29943","29944","29945","29946","29947","29948","29949","29950","29951","29952","29953","29954","29955","29956","29957","29958","29959","29960","29961","29962","29963","29964","29965","29966","29967","29968","29969","29970","29971","29972","29973","29974","29975","29976","29977","29978","29979","29980","29981","29982","29983","29984","29985","29986","29987","29988","29989","29990","29991","29992","29993","29994","29995","29996","29997","29998","29999","30000","30001","30002","30003","30004","30005","30006","30007","30008","30009","30010","30011","30012","30013","30014","30015","30016","30017","30018","30019","30020","30021","30022","30023","30024","30025","30026","30027","30028","30029","30030","30031","30032","30033","30034","30035","30036","30037","30038","30039","30040","30041","30042","30043","30044","30045","30046","30047","30048","30049","30050","30051","30052","30053","30054","30055","30056","30057","30058","30059","30060","30061","30062","30063","30064","30065","30066","30067","30068","30069","30070","30071","30072","30073","30074","30075","30076","30077","30078","30079","30080","30081","30082","30083","30084","30085","30086","30087","30088","30089","30090","30091","30092","30093","30094","30095","30096","30097","30098","30099","30100","30101","30102","30103","30104","30105","30106","30107","30108","30109","30110","30111","30112","30113","30114","30115","30116","30117","30118","30119","30120","30121","30122","30123","30124","30125","30126","30127","30128","30129","30130","30131","30132","30133","30134","30135","30136","30137","30138","30139","30140","30141","30142","30143","30144","30145","30146","30147","30148","30149","30150","30151","30152","30153","30154","30155","30156","30157","30158","30159","30160","30161","30162","30163","30164","30165","30166","30167","30168","30169","30170","30171","30172","30173","30174","30175","30176","30177","30178","30179","30180","30181","30182","30183","30184","30185","30186","30187","30188","30189","30190","30191","30192","30193","30194","30195","30196","30197","30198","30199","30200","30201","30202","30203","30204","30205","30206","30207","30208","30209","30210","30211","30212","30213","30214","30215","30216","30217","30218","30219","30220","30221","30222","30223","30224","30225","30226","30227","30228","30229","30230","30231","30232","30233","30234","30235","30236","30237","30238","30239","30240","30241","30242","30243","30244","30245","30246","30247","30248","30249","30250","30251","30252","30253","30254","30255","30256","30257","30258","30259","30260","30261","30262","30263","30264","30265","30266","30267","30268","30269","30270","30271","30272","30273","30274","30275","30276","30277","30278","30279","30280","30281","30282","30283","30284","30285","30286","30287","30288","30289","30290","30291","30292","30293","30294","30295","30296","30297","30298","30299","30300","30301","30302","30303","30304","30305","30306","30307","30308","30309","30310","30311","30312","30313","30314","30315","30316","30317","30318","30319","30320","30321","30322","30323","30324","30325","30326","30327","30328","30329","30330","30331","30332","30333","30334","30335","30336","30337","30338","30339","30340","30341","30342","30343","30344","30345","30346","30347","30348","30349","30350","30351","30352","30353","30354","30355","30356","30357","30358","30359","30360","30361","30362","30363","30364","30365","30366","30367","30368","30369","30370","30371","30372","30373","30374","30375","30376","30377","30378","30379","30380","30381","30382","30383","30384","30385","30386","30387","30388","30389","30390","30391","30392","30393","30394","30395","30396","30397","30398","30399","30400","30401","30402","30403","30404","30405","30406","30407","30408","30409","30410","30411","30412","30413","30414","30415","30416","30417","30418","30419","30420","30421","30422","30423","30424","30425","30426","30427","30428","30429","30430","30431","30432","30433","30434","30435","30436","30437","30438","30439","30440","30441","30442","30443","30444","30445","30446","30447","30448","30449","30450","30451","30452","30453","30454","30455","30456","30457","30458","30459","30460","30461","30462","30463","30464","30465","30466","30467","30468","30469","30470","30471","30472","30473","30474","30475","30476","30477","30478","30479","30480","30481","30482","30483","30484","30485","30486","30487","30488","30489","30490","30491","30492","30493","30494","30495","30496","30497","30498","30499","30500","30501","30502","30503","30504","30505","30506","30507","30508","30509","30510","30511","30512","30513","30514","30515","30516","30517","30518","30519","30520","30521","30522","30523","30524","30525","30526","30527","30528","30529","30530","30531","30532","30533","30534","30535","30536","30537","30538","30539","30540","30541","30542","30543","30544","30545","30546","30547","30548","30549","30550","30551","30552","30553","30554","30555","30556","30557","30558","30559","30560","30561","30562","30563","30564","30565","30566","30567","30568","30569","30570","30571","30572","30573","30574","30575","30576","30577","30578","30579","30580","30581","30582","30583","30584","30585","30586","30587","30588","30589","30590","30591","30592","30593","30594","30595","30596","30597","30598","30599","30600","30601","30602","30603","30604","30605","30606","30607","30608","30609","30610","30611","30612","30613","30614","30615","30616","30617","30618","30619","30620","30621","30622","30623","30624","30625","30626","30627","30628","30629","30630","30631","30632","30633","30634","30635","30636","30637","30638","30639","30640","30641","30642","30643","30644","30645","30646","30647","30648","30649","30650","30651","30652","30653","30654","30655","30656","30657","30658","30659","30660","30661","30662","30663","30664","30665","30666","30667","30668","30669","30670","30671","30672","30673","30674","30675","30676","30677","30678","30679","30680","30681","30682","30683","30684","30685","30686","30687","30688","30689","30690","30691","30692","30693","30694","30695","30696","30697","30698","30699","30700","30701","30702","30703","30704","30705","30706","30707","30708","30709","30710","30711","30712","30713","30714","30715","30716","30717","30718","30719","30720","30721","30722","30723","30724","30725","30726","30727","30728","30729","30730","30731","30732","30733","30734","30735","30736","30737","30738","30739","30740","30741","30742","30743","30744","30745","30746","30747","30748","30749","30750","30751","30752","30753","30754","30755","30756","30757","30758","30759","30760","30761","30762","30763","30764","30765","30766","30767","30768","30769","30770","30771","30772","30773","30774","30775","30776","30777","30778","30779","30780","30781","30782","30783","30784","30785","30786","30787","30788","30789","30790","30791","30792","30793","30794","30795","30796","30797","30798","30799","30800","30801","30802","30803","30804","30805","30806","30807","30808","30809","30810","30811","30812","30813","30814","30815","30816","30817","30818","30819","30820","30821","30822","30823","30824","30825","30826","30827","30828","30829","30830","30831","30832","30833","30834","30835","30836","30837","30838","30839","30840","30841","30842","30843","30844","30845","30846","30847","30848","30849","30850","30851","30852","30853","30854","30855","30856","30857","30858","30859","30860","30861","30862","30863","30864","30865","30866","30867","30868","30869","30870","30871","30872","30873","30874","30875","30876","30877","30878","30879","30880","30881","30882","30883","30884","30885","30886","30887","30888","30889","30890","30891","30892","30893","30894","30895","30896","30897","30898","30899","30900","30901","30902","30903","30904","30905","30906","30907","30908","30909","30910","30911","30912","30913","30914","30915","30916","30917","30918","30919","30920","30921","30922","30923","30924","30925","30926","30927","30928","30929","30930","30931","30932","30933","30934","30935","30936","30937","30938","30939","30940","30941","30942","30943","30944","30945","30946","30947","30948","30949","30950","30951","30952","30953","30954","30955","30956","30957","30958","30959","30960","30961","30962","30963","30964","30965","30966","30967","30968","30969","30970","30971","30972","30973","30974","30975","30976","30977","30978","30979","30980","30981","30982","30983","30984","30985","30986","30987","30988","30989","30990","30991","30992","30993","30994","30995","30996","30997","30998","30999","31000","31001","31002","31003","31004","31005","31006","31007","31008","31009","31010","31011","31012","31013","31014","31015","31016","31017","31018","31019","31020","31021","31022","31023","31024","31025","31026","31027","31028","31029","31030","31031","31032","31033","31034","31035","31036","31037","31038","31039","31040","31041","31042","31043","31044","31045","31046","31047","31048","31049","31050","31051","31052","31053","31054","31055","31056","31057","31058","31059","31060","31061","31062","31063","31064","31065","31066","31067","31068","31069","31070","31071","31072","31073","31074","31075","31076","31077","31078","31079","31080","31081","31082","31083","31084","31085","31086","31087","31088","31089","31090","31091","31092","31093","31094","31095","31096","31097","31098","31099","31100","31101","31102","31103","31104","31105","31106","31107","31108","31109","31110","31111","31112","31113","31114","31115","31116","31117","31118","31119","31120","31121","31122","31123","31124","31125","31126","31127","31128","31129","31130","31131","31132","31133","31134","31135","31136","31137","31138","31139","31140","31141","31142","31143","31144","31145","31146","31147","31148","31149","31150","31151","31152","31153","31154","31155","31156","31157","31158","31159","31160","31161","31162","31163","31164","31165","31166","31167","31168","31169","31170","31171","31172","31173","31174","31175","31176","31177","31178","31179","31180","31181","31182","31183","31184","31185","31186","31187","31188","31189","31190","31191","31192","31193","31194","31195","31196","31197","31198","31199","31200","31201","31202","31203","31204","31205","31206","31207","31208","31209","31210","31211","31212","31213","31214","31215","31216","31217","31218","31219","31220","31221","31222","31223","31224","31225","31226","31227","31228","31229","31230","31231","31232","31233","31234","31235","31236","31237","31238","31239","31240","31241","31242","31243","31244","31245","31246","31247","31248","31249","31250","31251","31252","31253","31254","31255","31256","31257","31258","31259","31260","31261","31262","31263","31264","31265","31266","31267","31268","31269","31270","31271","31272","31273","31274","31275","31276","31277","31278","31279","31280","31281","31282","31283","31284","31285","31286","31287","31288","31289","31290","31291","31292","31293","31294","31295","31296","31297","31298","31299","31300","31301","31302","31303","31304","31305","31306","31307","31308","31309","31310","31311","31312","31313","31314","31315","31316","31317","31318","31319","31320","31321","31322","31323","31324","31325","31326","31327","31328","31329","31330","31331","31332","31333","31334","31335","31336","31337","31338","31339","31340","31341","31342","31343","31344","31345","31346","31347","31348","31349","31350","31351","31352","31353","31354","31355","31356","31357","31358","31359","31360","31361","31362","31363","31364","31365","31366","31367","31368","31369","31370","31371","31372","31373","31374","31375","31376","31377","31378","31379","31380","31381","31382","31383","31384","31385","31386","31387","31388","31389","31390","31391","31392","31393","31394","31395","31396","31397","31398","31399","31400","31401","31402","31403","31404","31405","31406","31407","31408","31409","31410","31411","31412","31413","31414","31415","31416","31417","31418","31419","31420","31421","31422","31423","31424","31425","31426","31427","31428","31429","31430","31431","31432","31433","31434","31435","31436","31437","31438","31439","31440","31441","31442","31443","31444","31445","31446","31447","31448","31449","31450","31451","31452","31453","31454","31455","31456","31457","31458","31459","31460","31461","31462","31463","31464","31465","31466","31467","31468","31469","31470","31471","31472","31473","31474","31475","31476","31477","31478","31479","31480","31481","31482","31483","31484","31485","31486","31487","31488","31489","31490","31491","31492","31493","31494","31495","31496","31497","31498","31499","31500","31501","31502","31503","31504","31505","31506","31507","31508","31509","31510","31511","31512","31513","31514","31515","31516","31517","31518","31519","31520","31521","31522","31523","31524","31525","31526","31527","31528","31529","31530","31531","31532","31533","31534","31535","31536","31537","31538","31539","31540","31541","31542","31543","31544","31545","31546","31547","31548","31549","31550","31551","31552","31553","31554","31555","31556","31557","31558","31559","31560","31561","31562","31563","31564","31565","31566","31567","31568","31569","31570","31571","31572","31573","31574","31575","31576","31577","31578","31579","31580","31581","31582","31583","31584","31585","31586","31587","31588","31589","31590","31591","31592","31593","31594","31595","31596","31597","31598","31599","31600","31601","31602","31603","31604","31605","31606","31607","31608","31609","31610","31611","31612","31613","31614","31615","31616","31617","31618","31619","31620","31621","31622","31623","31624","31625","31626","31627","31628","31629","31630","31631","31632","31633","31634","31635","31636","31637","31638","31639","31640","31641","31642","31643","31644","31645","31646","31647","31648","31649","31650","31651","31652","31653","31654","31655","31656","31657","31658","31659","31660","31661","31662","31663","31664","31665","31666","31667","31668","31669","31670","31671","31672","31673","31674","31675","31676","31677","31678","31679","31680","31681","31682","31683","31684","31685","31686","31687","31688","31689","31690","31691","31692","31693","31694","31695","31696","31697","31698","31699","31700","31701","31702","31703","31704","31705","31706","31707","31708","31709","31710","31711","31712","31713","31714","31715","31716","31717","31718","31719","31720","31721","31722","31723","31724","31725","31726","31727","31728","31729","31730","31731","31732","31733","31734","31735","31736","31737","31738","31739","31740","31741","31742","31743","31744","31745","31746","31747","31748","31749","31750","31751","31752","31753","31754","31755","31756","31757","31758","31759","31760","31761","31762","31763","31764","31765","31766","31767","31768","31769","31770","31771","31772","31773","31774","31775","31776","31777","31778","31779","31780","31781","31782","31783","31784","31785","31786","31787","31788","31789","31790","31791","31792","31793","31794","31795","31796","31797","31798","31799","31800","31801","31802","31803","31804","31805","31806","31807","31808","31809","31810","31811","31812","31813","31814","31815","31816","31817","31818","31819","31820","31821","31822","31823","31824","31825","31826","31827","31828","31829","31830","31831","31832","31833","31834","31835","31836","31837","31838","31839","31840","31841","31842","31843","31844","31845","31846","31847","31848","31849","31850","31851","31852","31853","31854","31855","31856","31857","31858","31859","31860","31861","31862","31863","31864","31865","31866","31867","31868","31869","31870","31871","31872","31873","31874","31875","31876","31877","31878","31879","31880","31881","31882","31883","31884","31885","31886","31887","31888","31889","31890","31891","31892","31893","31894","31895","31896","31897","31898","31899","31900","31901","31902","31903","31904","31905","31906","31907","31908","31909","31910","31911","31912","31913","31914","31915","31916","31917","31918","31919","31920","31921","31922","31923","31924","31925","31926","31927","31928","31929","31930","31931","31932","31933","31934","31935","31936","31937","31938","31939","31940","31941","31942","31943","31944","31945","31946","31947","31948","31949","31950","31951","31952","31953","31954","31955","31956","31957","31958","31959","31960","31961","31962","31963","31964","31965","31966","31967","31968","31969","31970","31971","31972","31973","31974","31975","31976","31977","31978","31979","31980","31981","31982","31983","31984","31985","31986","31987","31988","31989","31990","31991","31992","31993","31994","31995","31996","31997","31998","31999","32000","32001","32002","32003","32004","32005","32006","32007","32008","32009","32010","32011","32012","32013","32014","32015","32016","32017","32018","32019","32020","32021","32022","32023","32024","32025","32026","32027","32028","32029","32030","32031","32032","32033","32034","32035","32036","32037","32038","32039","32040","32041","32042","32043","32044","32045","32046","32047","32048","32049","32050","32051","32052","32053","32054","32055","32056","32057","32058","32059","32060","32061","32062","32063","32064","32065","32066","32067","32068","32069","32070","32071","32072","32073","32074","32075","32076","32077","32078","32079","32080","32081","32082","32083","32084","32085","32086","32087","32088","32089","32090","32091","32092","32093","32094","32095","32096","32097","32098","32099","32100","32101","32102","32103","32104","32105","32106","32107","32108","32109","32110","32111","32112","32113","32114","32115","32116","32117","32118","32119","32120","32121","32122","32123","32124","32125","32126","32127","32128","32129","32130","32131","32132","32133","32134","32135","32136","32137","32138","32139","32140","32141","32142","32143","32144","32145","32146","32147","32148","32149","32150","32151","32152","32153","32154","32155","32156","32157","32158","32159","32160","32161","32162","32163","32164","32165","32166","32167","32168","32169","32170","32171","32172","32173","32174","32175","32176","32177","32178","32179","32180","32181","32182","32183","32184","32185","32186","32187","32188","32189","32190","32191","32192","32193","32194","32195","32196","32197","32198","32199","32200","32201","32202","32203","32204","32205","32206","32207","32208","32209","32210","32211","32212","32213","32214","32215","32216","32217","32218","32219","32220","32221","32222","32223","32224","32225","32226","32227","32228","32229","32230","32231","32232","32233","32234","32235","32236","32237","32238","32239","32240","32241","32242","32243","32244","32245","32246","32247","32248","32249","32250","32251","32252","32253","32254","32255","32256","32257","32258","32259","32260","32261","32262","32263","32264","32265","32266","32267","32268","32269","32270","32271","32272","32273","32274","32275","32276","32277","32278","32279","32280","32281","32282","32283","32284","32285","32286","32287","32288","32289","32290","32291","32292","32293","32294","32295","32296","32297","32298","32299","32300","32301","32302","32303","32304","32305","32306","32307","32308","32309","32310","32311","32312","32313","32314","32315","32316","32317","32318","32319","32320","32321","32322","32323","32324","32325","32326","32327","32328","32329","32330","32331","32332","32333","32334","32335","32336","32337","32338","32339","32340","32341","32342","32343","32344","32345","32346","32347","32348","32349","32350","32351","32352","32353","32354","32355","32356","32357","32358","32359","32360","32361","32362","32363","32364","32365","32366","32367","32368","32369","32370","32371","32372","32373","32374","32375","32376","32377","32378","32379","32380","32381","32382","32383","32384","32385","32386","32387","32388","32389","32390","32391","32392","32393","32394","32395","32396","32397","32398","32399","32400","32401","32402","32403","32404","32405","32406","32407","32408","32409","32410","32411","32412","32413","32414","32415","32416","32417","32418","32419","32420","32421","32422","32423","32424","32425","32426","32427","32428","32429","32430","32431","32432","32433","32434","32435","32436","32437","32438","32439","32440","32441","32442","32443","32444","32445","32446","32447","32448","32449","32450","32451","32452","32453","32454","32455","32456","32457","32458","32459","32460","32461","32462","32463","32464","32465","32466","32467","32468","32469","32470","32471","32472","32473","32474","32475","32476","32477","32478","32479","32480","32481","32482","32483","32484","32485","32486","32487","32488","32489","32490","32491","32492","32493","32494","32495","32496","32497","32498","32499","32500","32501","32502","32503","32504","32505","32506","32507","32508","32509","32510","32511","32512","32513","32514","32515","32516","32517","32518","32519","32520","32521","32522","32523","32524","32525","32526","32527","32528","32529","32530","32531","32532","32533","32534","32535","32536","32537","32538","32539","32540","32541","32542","32543","32544","32545","32546","32547","32548","32549","32550","32551","32552","32553","32554","32555","32556","32557","32558","32559","32560","32561","32562","32563","32564","32565","32566","32567","32568","32569","32570","32571","32572","32573","32574","32575","32576","32577","32578","32579","32580","32581","32582","32583","32584","32585","32586","32587","32588","32589","32590","32591","32592","32593","32594","32595","32596","32597","32598","32599","32600","32601","32602","32603","32604","32605","32606","32607","32608","32609","32610","32611","32612","32613","32614","32615","32616","32617","32618","32619","32620","32621","32622","32623","32624","32625","32626","32627","32628","32629","32630","32631","32632","32633","32634","32635","32636","32637","32638","32639","32640","32641","32642","32643","32644","32645","32646","32647","32648","32649","32650","32651","32652","32653","32654","32655","32656","32657","32658","32659","32660","32661","32662","32663","32664","32665","32666","32667","32668","32669","32670","32671","32672","32673","32674","32675","32676","32677","32678","32679","32680","32681","32682","32683","32684","32685","32686","32687","32688","32689","32690","32691","32692","32693","32694","32695","32696","32697","32698","32699","32700","32701","32702","32703","32704","32705","32706","32707","32708","32709","32710","32711","32712","32713","32714","32715","32716","32717","32718","32719","32720","32721","32722","32723","32724","32725","32726","32727","32728","32729","32730","32731","32732","32733","32734","32735","32736","32737","32738","32739","32740","32741","32742","32743","32744","32745","32746","32747","32748","32749","32750","32751","32752","32753","32754","32755","32756","32757","32758","32759","32760","32761","32762","32763","32764","32765","32766","32767"],
        &[(0,6390,0.7609216),(0,13316,0.19062568),(0,23868,0.74622),(1,9123,0.5734641),(1,19289,0.6899352),(2,5854,4.9256656e-2),(2,10448,6.205048e-2),(3,1438,0.57810473),(3,2929,0.6945942),(3,12784,0.32535315),(3,27729,0.11286687),(3,27734,0.7239962),(3,29554,0.59609115),(4,6342,5.8271687e-2),(4,6741,0.20749107),(4,15817,0.81786275),(4,21822,0.7949503),(4,21883,0.1452508),(5,11973,0.7589601),(5,12864,0.32795757),(5,18827,0.5281872),(5,32558,0.7387783),(6,3431,0.5359314),(6,3886,0.34457436),(6,5407,0.64773536),(6,15263,0.8257852),(6,30265,0.8423905),(6,31313,0.6736258),(7,4255,0.2020997),(7,6380,0.6097893),(7,23665,0.759557),(7,29096,0.5166979),(8,3798,0.78527427),(8,5556,0.7277464),(8,25011,0.7144439),(9,294,0.35887507),(9,634,0.13282387),(9,11967,0.43980658),(9,15609,0.8670651),(9,16634,0.5847239),(9,24421,0.35395834),(10,6873,0.10237214),(10,21303,0.6470532),(10,31548,0.16257466),(11,3690,0.2710325),(11,4565,0.6559056),(12,6931,0.17886198),(12,9298,0.43601552),(12,22286,0.73367006),(13,15063,0.54331195),(13,16442,8.313657e-3),(13,18649,0.5715283),(13,27682,0.19278906),(14,14398,0.26247767),(14,15169,0.41788426),(14,16384,0.120671354),(14,16937,0.916751),(14,29637,5.133673e-2),(15,1874,0.6458528),(15,2425,0.18857741),(15,3427,0.99778897),(15,6634,0.580866),(15,10507,0.37263057),(15,11769,0.26568455),(15,13938,0.34045866),(15,18905,4.715644e-2),(15,31456,2.1454046e-2),(15,32163,0.7940478),(16,1920,0.13791883),(16,6224,0.2039289),(16,20120,0.5919053),(16,29768,0.9362388),(17,3909,0.9271301),(17,12473,0.20989773),(17,18345,0.18322942),(17,21833,0.31238556),(17,21981,0.38719246),(17,22249,0.8376355),(17,32035,9.239191e-2),(18,14134,0.78258526),(18,22610,9.560842e-2),(18,29174,0.30788383),(18,29484,0.43817574),(19,6938,0.4477259),(19,10661,6.488618e-2),(19,15003,2.070275e-3),(19,23089,0.35640594),(20,9294,0.6115513),(20,18460,0.9689578),(20,24797,0.22026958),(21,14319,0.81078416),(21,23149,0.62873447),(21,28713,0.62507045),(22,9354,0.8923041),(22,10878,0.2449375),(22,18143,3.0017132e-2),(22,24755,0.19000374),(23,23605,0.15957768),(23,28475,0.33151525),(23,29095,0.5126246),(23,29502,0.3449311),(24,18285,0.21636932),(24,18734,2.7034806e-2),(24,21092,0.8647348),(24,29666,0.4714619),(25,17190,3.8991448e-2),(25,18230,0.41202435),(25,20628,0.5648377),(25,27739,0.17353815),(25,31201,0.2731487),(25,32761,0.87997967),(26,2944,0.65117925),(26,14149,0.73968107),(26,31341,0.83917844),(27,14255,0.5886593),(27,29855,0.20975739),(27,31371,0.9999585),(28,607,0.61443233),(28,20240,0.6709645),(28,23904,0.49952793),(28,30363,0.37817898),(29,20536,0.612653),(29,29852,0.39500618),(29,29896,0.4120374),(29,30763,0.15592246),(30,1635,0.64159435),(30,3755,0.20585756),(30,12057,0.732901),(30,13502,0.36448017),(30,18953,0.5045681),(30,26336,0.49244615),(30,26563,0.20546849),(32,30060,0.670196),(33,7,0.5063717),(34,26414,0.60785824),(34,28873,8.653827e-2),(34,29998,0.60499465),(35,1999,0.69442487),(35,5538,0.8497192),(35,8870,0.42512152),(35,13687,0.9103051),(35,20725,9.324389e-3),(35,28722,0.6584964),(36,915,0.4083287),(36,15459,0.5507316),(36,16242,0.72413474),(36,20593,4.7714673e-2),(36,30355,0.44508305),(37,6728,6.136681e-2),(37,11780,0.33492917),(38,4558,0.67988205),(38,5682,0.80558765),(38,7573,0.6695293),(38,15362,0.89214206),(38,17772,0.6054225),(39,18703,0.6611274),(39,22364,0.80434585),(39,23595,0.8795272),(40,6113,0.8163318),(40,14579,0.49245048),(40,29356,0.86254436),(41,9483,0.27125475),(41,13579,0.14166366),(41,16311,2.6924672e-2),(41,26860,0.9674493),(41,26907,0.74780977),(42,9944,0.5935021),(42,22142,0.10185437),(42,25266,0.71952325),(42,25752,9.673657e-3),(42,32354,0.6487034),(43,21617,0.6036983),(43,22512,0.97506344),(43,31059,0.40583447),(44,4033,0.9874648),(44,18280,0.91174626),(44,30142,0.9742541),(44,30847,0.70706123),(45,11133,0.91404396),(47,2138,0.97201204),(47,14148,0.93788797),(48,3101,0.47556776),(48,4045,0.7839264),(48,12269,0.36673355),(48,23456,0.23809104),(49,28472,0.21132487),(50,13102,0.99033904),(50,16171,0.17462808),(50,16183,8.036211e-2),(50,20048,0.78064173),(50,26486,0.59060895),(50,26825,0.4723584),(50,28664,0.7674024),(50,30573,0.758556),(51,5644,0.36218914),(51,24410,0.16491492),(51,27841,0.78005433),(52,6986,0.88813096),(52,12003,0.9476774),(52,17837,0.63526493),(52,18457,0.51508874),(52,19955,0.36762995),(53,912,0.6523664),(53,4589,0.2992328),(53,9211,0.5808361),(53,20540,0.81818247),(53,24622,0.8328467),(53,28861,0.5089963),(53,29287,0.49928916),(54,2374,0.86938334),(54,8788,2.1762567e-2),(54,11394,0.80159354),(54,12582,0.23845969),(55,5066,0.24736166),(55,30056,0.25317854),(55,31290,0.2472671),(56,524,0.44831184),(56,16069,0.32776546),(57,5838,0.9362135),(57,31464,0.4705285),(58,6674,0.72923034),(58,6697,0.58851236),(58,20460,4.1959167e-2),(58,26354,0.68550944),(59,3152,0.79038787),(59,3706,5.4950245e-2),(59,4011,0.48942807),(59,9522,0.5504782),(59,11389,0.36495823),(59,16991,0.11993575),(59,18602,0.19415423),(60,6197,0.8093826),(60,14362,0.7837907),(60,15904,0.59007543),(60,23465,0.31836292),(60,23481,0.4039488),(61,7651,5.790311e-2),(61,7744,0.6115815),(61,10051,0.723179),(61,15119,0.44098577),(61,15504,0.328824),(61,31916,3.599861e-2),(62,15927,0.9540371),(63,24161,0.3491055),(63,30985,0.55195093),(64,7931,0.7040593),(64,13856,0.32528132),(64,27325,0.5158985),(65,9301,0.6098796),(65,13738,3.7813008e-2),(65,17330,0.7028529),(65,28980,0.63802713),(66,10904,0.28682104),(66,14436,0.41364846),(66,18417,0.5070158),(66,18687,0.85672647),(66,22814,0.31856844),(66,25003,0.95646876),(67,3036,0.6463858),(67,32083,1.2059618e-2),(68,10604,0.92096305),(68,27982,0.3517862),(69,5438,0.3411827),(69,16893,0.9223814),(69,21129,0.6387484),(69,21601,0.17110407),(69,21617,0.70263326),(69,28966,6.4277805e-2),(70,1489,0.24172051),(70,5119,0.62225187),(70,7086,0.5399607),(70,14640,0.48322588),(70,20219,0.9820804),(70,25035,0.8703591),(70,25434,0.22309814),(70,27970,0.6171762),(70,29501,0.3421217),(71,14434,0.10567998),(72,905,0.35313934),(72,18107,0.14580964),(73,13813,0.875435),(73,14360,0.56481093),(73,18981,6.989906e-3),(73,20168,0.1542681),(73,21873,0.6325529),(73,21986,0.42917126),(74,5509,0.41324553),(74,32351,0.58334637),(74,32727,0.68671393),(75,7657,0.9034958),(75,12259,0.5989804),(75,23310,0.56776917),(76,4777,0.68492603),(76,5587,0.41434124),(76,6059,0.22313258),(76,11476,0.31022507),(76,29163,0.733208),(76,30001,0.64472735),(77,3488,0.1718577),(77,7122,0.32781738),(77,9902,0.8260437),(77,15469,0.52379006),(78,5919,0.17738882),(78,22368,1.6626053e-2),(79,4080,0.5597837),(79,27232,0.87153435),(79,28779,7.165872e-2),(80,3412,0.37856898),(80,10031,0.57003856),(80,18947,0.11168799),(81,2245,0.25728357),(81,7708,0.88471764),(81,12089,0.61345154),(81,29151,0.14453429),(82,1126,0.97689193),(82,1243,0.62324286),(82,2068,0.28400838),(82,7985,0.55439556),(82,20331,0.20247507),(82,24226,0.7280174),(83,25570,4.6522856e-2),(83,26760,0.6085864),(84,1830,2.8799476e-2),(84,3203,0.6455808),(84,10718,0.8749767),(84,21351,5.4083936e-2),(84,24245,0.45384377),(84,26176,0.63011587),(84,26604,0.493722),(85,1464,7.63273e-2),(85,22633,0.14264208),(85,23673,0.6399094),(86,726,0.6720736),(86,7145,0.69443756),(86,8921,0.97340834),(86,15001,0.79734814),(86,20453,0.995066),(86,32132,0.86951697),(87,9715,0.76618147),(87,17200,0.98578525),(89,18968,0.58499354),(89,19580,0.7135684),(89,25627,0.9357941),(90,15933,7.156614e-2),(90,19019,0.54968303),(91,1901,0.44222325),(91,9674,0.98245454),(91,22500,0.26326174),(92,9370,0.92501146),(92,25326,0.85241264),(93,871,0.4801058),(93,14154,0.8118006),(93,22117,0.56480724),(93,28948,0.43058443),(94,3345,0.60893226),(94,19755,0.7944258),(94,24132,9.162853e-3),(95,3362,0.69353735),(95,5386,0.34403712),(95,7630,0.22960863),(95,13076,0.55375725),(96,865,0.9942693),(96,4105,0.31921235),(96,5692,0.92468923),(96,19183,0.58227414),(96,23140,0.6020771),(96,26836,0.82726824),(96,28891,0.9745966),(98,3394,0.38350925),(98,4943,0.60615295),(98,5086,0.83759826),(99,8234,0.44415057),(99,16365,0.42165768),(99,27855,5.1971994e-2),(100,1403,0.35278162),(100,18911,0.12891187),(100,29660,0.22231227),(101,5909,0.3368114),(101,20212,0.19390008),(102,13313,5.827397e-2),(102,24399,0.19725902),(102,29189,0.32347664),(103,3110,0.3079099),(103,4861,0.24644469),(103,5890,2.8958682e-2),(103,7954,0.6743587),(103,17052,0.22636914),(103,25455,0.6165032),(104,3592,9.1476776e-2),(104,7465,0.95419496),(104,8970,0.5056566),(104,16132,0.4576952),(104,17132,0.92230386),(104,31540,0.75726587),(105,1634,0.68904465),(105,12183,0.32340053),(105,17478,0.7473609),(105,20363,0.4992826),(105,30317,0.9190271),(106,5454,0.5219322),(106,17109,5.466974e-2),(106,18949,0.82111883),(106,21250,0.15242717),(106,24225,0.42615864),(107,2067,0.4825645),(107,4999,0.40657914),(107,6721,0.14894427),(107,10262,0.13999632),(107,12804,0.7048028),(107,15635,0.23498373),(107,23311,0.20976527),(107,32314,7.936194e-2),(108,11089,0.1322136),(108,20250,0.76268697),(109,11656,0.61914086),(109,24133,0.69381046),(110,13052,0.71497345),(111,3533,8.366657e-2),(111,13931,0.628543),(111,25607,0.84708863),(112,6075,4.2730927e-2),(112,10842,0.41762993),(113,6996,0.76087296),(113,19707,0.32483903),(113,20199,0.221042),(113,27994,0.99451005),(114,1338,0.5631224),(114,11794,2.6390553e-3),(114,14688,0.66226226),(114,17955,0.5033671),(114,31711,0.82651126),(115,12152,0.8151169),(115,30980,0.56555295),(116,5320,0.7211106),(116,20327,0.5859969),(116,22640,0.6838365),(116,23829,2.9716643e-2),(116,29363,0.27879936),(117,663,0.8971467),(117,6462,0.384504),(117,6532,0.1299832),(117,8516,0.54243594),(117,12850,0.9070971),(117,19619,0.6256783),(118,16289,0.16391341),(118,16390,0.93933225),(118,24300,1.643273e-2),(119,2227,0.16389407),(119,4576,0.47843912),(119,10155,8.017234e-2),(119,14518,0.26931036),(119,20675,0.66618043),(119,26096,0.8331496),(120,5092,0.46590954),(120,11451,0.33733106),(120,13815,0.4336445),(120,14300,0.930079),(120,28985,0.5971997),(120,31745,0.84377444),(121,3688,0.46440083),(121,9502,0.62698275),(121,21282,0.22384271),(121,21335,0.91708755),(121,21452,0.38506562),(122,3321,0.28562775),(122,24173,0.13682128),(123,17663,0.19110222),(123,18011,0.7167341),(123,19068,0.16026036),(123,23166,0.43531227),(123,31465,0.45123506),(124,968,3.0086514e-2),(124,2519,7.2189674e-2),(124,2629,0.52762413),(124,12681,6.511537e-2),(124,22859,0.34944698),(124,27464,0.79781216),(125,12898,0.8880999),(125,16435,0.23189881),(125,18357,0.24217412),(125,24328,0.23124976),(125,28082,0.33930016),(125,30167,0.10756083),(126,5981,0.4365484),(126,11090,0.87151664),(126,11420,0.6119009),(126,20032,0.796466),(126,20862,0.12401231),(126,24597,0.9766374),(126,30717,0.9111281),(127,1489,0.124959655),(127,3048,0.5551622),(127,17263,0.43265828),(127,22728,0.5492591),(127,23421,0.20112526),(127,26574,0.24995728),(128,1451,0.719483),(128,14256,7.503601e-2),(128,26145,0.4749949),(128,31868,0.16483516),(130,4407,0.56124187),(130,6275,0.9722496),(130,12876,0.16435443),(130,17073,0.9203822),(131,10783,0.5137416),(131,23050,3.938569e-2),(131,24206,0.5162369),(131,31216,0.15785147),(132,3545,0.8781179),(132,4269,1.3301283e-2),(133,17020,0.4144159),(133,19894,0.96214163),(133,20243,0.1727239),(133,24484,0.4151401),(134,4130,0.395982),(134,10054,0.2619887),(134,29585,5.5757537e-2),(135,9548,0.9622488),(135,25966,0.93282896),(135,30871,0.56780124),(136,52,0.2104729),(136,19294,0.28044853),(136,24028,0.48928368),(137,32001,0.69736826),(138,15589,0.9607005),(138,32596,0.23401645),(139,3842,0.66571003),(139,24800,0.7525095),(139,30032,0.14931789),(139,32672,0.7078497),(140,3119,0.397172),(140,29033,0.4412008),(141,288,0.93087566),(141,6171,4.0319655e-2),(141,6852,0.49292406),(141,7926,0.7587098),(141,25372,0.97156316),(142,2415,0.79393554),(142,2506,0.8217756),(142,3834,0.7922938),(142,16579,0.5273923),(143,1569,0.46857998),(143,7608,0.9217598),(143,13994,0.57844967),(144,3343,0.10160706),(144,11941,0.31815413),(144,19851,0.64860463),(144,23809,7.169303e-2),(144,24920,0.6268874),(145,789,0.4823454),(145,1008,0.92222077),(145,10754,0.4419451),(145,23761,0.8984692),(145,25467,0.3562329),(145,26483,0.43798122),(145,27982,0.11094553),(146,23434,1.9101162e-2),(146,30695,0.8562076),(146,32155,5.7670027e-2),(147,3138,0.24397515),(147,3178,0.39457965),(147,6545,0.6503596),(147,10186,0.81194025),(147,20509,0.7153315),(147,28131,0.17509672),(147,31216,0.16967006),(148,6883,0.3627108),(148,10386,0.8422914),(148,11156,0.57979006),(148,14788,0.33883566),(148,22963,0.72925067),(148,27523,0.75658417),(149,1953,0.24459924),(149,4332,0.6455972),(149,9704,0.59642315),(149,12631,0.80417436),(149,19610,0.9948207),(149,27528,0.2040361),(149,29436,0.82304806),(149,29911,0.19834073),(150,395,2.0061513e-4),(150,1114,5.946709e-2),(150,2036,0.14700294),(150,7935,0.3515503),(150,19232,0.51878583),(150,22529,0.5148544),(151,11192,0.6986685),(151,11394,0.3449564),(151,31292,0.31185773),(152,6008,0.6806488),(152,12885,0.28140712),(152,15901,0.36596617),(152,27546,0.53384936),(153,3944,0.20245017),(153,28865,0.4024889),(153,30735,0.19915102),(154,9228,0.6026872),(154,11434,0.49722353),(154,12544,0.21132272),(154,18278,0.84829277),(154,18527,4.5820702e-2),(154,25347,0.44753885),(154,25566,0.89063346),(154,26059,0.50558823),(155,11612,1.0507436e-3),(155,19408,1.5967878e-2),(155,26062,4.122041e-2),(156,12635,0.73492813),(156,16297,0.6512614),(156,16592,0.61393446),(156,21976,0.74404055),(156,24130,0.14375104),(157,15351,0.37268847),(158,8408,0.78847617),(158,11709,0.17914465),(159,58,8.538536e-2),(159,229,0.7466942),(159,9210,0.841984),(159,11591,2.8715238e-2),(159,26453,0.5991419),(160,9137,0.55055696),(160,16713,0.88500816),(160,32207,0.23411943),(161,10821,0.15589687),(161,19660,0.26576763),(161,22708,0.2237831),(161,25861,0.35082623),(161,27836,0.32240593),(161,29878,0.3103774),(161,31328,0.16119905),(162,11876,0.13872747),(162,14720,0.8801276),(163,2688,0.89381343),(163,13093,0.4291605),(163,21635,0.54406965),(163,24444,0.83648306),(164,1083,0.31466526),(164,2236,0.46865183),(164,2641,0.60127574),(164,6953,0.7180438),(164,16218,0.38575834),(164,16479,0.8944349),(164,27395,0.29879662),(164,29302,0.5405326),(166,12097,1.5872642e-2),(166,16183,0.6758764),(166,22165,0.17460632),(166,29467,0.20461054),(166,30094,0.6620925),(167,15315,0.11722999),(167,16548,0.21183674),(167,16829,8.1454664e-2),(167,22662,2.332772e-2),(168,4817,0.7994367),(168,9347,0.5187212),(168,10686,2.345985e-2),(168,28695,0.6506215),(168,31306,6.725947e-2),(169,2107,0.40903625),(169,12124,0.5610851),(169,21552,0.3321706),(169,29341,0.2515581),(169,31257,0.30723214),(169,31818,0.13093032),(171,16833,0.8748319),(171,18883,0.60582525),(171,19045,0.7322815),(171,24170,0.48039585),(171,24591,0.73569435),(172,1261,0.80419004),(172,10697,0.23808797),(172,16105,2.460946e-3),(172,32029,0.10029081),(173,9344,0.51292604),(173,12352,0.7925611),(173,27738,0.27743277),(174,17804,0.6619422),(174,19059,0.16954455),(174,19279,0.6290576),(175,3923,0.16005796),(175,11449,0.90746933),(175,14661,1.3758053e-2),(175,20459,0.3509805),(175,22543,8.178856e-2),(175,23845,0.34241948),(175,29579,0.58076566),(176,14580,0.623893),(177,11253,0.8846459),(178,2316,0.14028409),(178,3823,0.12334684),(178,15747,0.23694357),(178,17560,0.21990548),(178,18673,0.43217576),(179,1650,0.99272484),(179,4206,0.87638456),(179,7469,0.2422678),(179,9777,0.87369347),(179,10532,0.15830702),(179,22229,0.76970345),(179,26905,0.7777723),(180,2270,0.7522258),(180,4417,0.7270002),(180,14900,0.6529333),(180,15338,0.8521643),(180,20020,0.32467955),(180,21680,7.083771e-2),(181,27645,0.46241093),(182,23545,6.7553654e-2),(183,3648,0.8704927),(183,6075,0.82511896),(183,7810,0.4683634),(183,16391,0.53848684),(183,17987,0.8574085),(183,23926,0.32847038),(183,27521,0.2690818),(183,29448,8.6605236e-2),(184,1306,0.17223126),(184,14486,0.4789282),(184,14663,0.53964496),(184,16221,0.17837581),(184,26701,0.68342996),(185,6033,0.9610346),(185,8041,0.44071066),(185,8365,0.49780387),(185,13710,0.34805015),(185,15306,0.6653911),(185,20896,0.70212066),(185,21777,6.40651e-2),(186,2918,0.45388502),(186,6623,0.42566654),(186,22898,0.59138733),(186,32624,0.4775276),(187,18078,0.3932004),(187,25672,0.1880849),(188,779,5.2025117e-2),(188,3156,0.9552663),(188,5739,0.84491974),(188,6024,0.82360935),(188,8148,0.5284616),(188,14715,0.49998242),(188,20065,0.79141057),(188,21941,0.42834246),(189,5012,8.051985e-2),(189,11561,0.76685107),(189,13844,0.41832632),(190,3624,0.24778767),(190,9295,5.8775917e-2),(190,25578,0.86401993),(191,7050,0.90803754),(191,7672,0.513581),(191,29013,0.58710545),(192,4783,0.28531942),(192,6607,0.43612552),(192,8724,0.65018356),(192,17785,0.2988908),(192,18651,0.92310077),(192,22976,0.93949115),(192,29752,6.6150814e-2),(192,29832,0.9154965),(192,31469,0.26891762),(193,4774,0.40685862),(193,10591,0.7904896),(193,31059,0.59191084),(194,31224,1.5634453e-2),(195,14293,8.9310996e-2),(195,16753,0.6278303),(195,26557,2.2787705e-2),(195,32662,0.18948482),(196,1345,0.5286506),(196,4524,0.7321107),(196,10835,0.6218741),(196,15661,6.4443e-2),(196,16713,0.7377652),(196,21624,0.929228),(196,23700,0.8126225),(197,5881,0.67424214),(197,18353,0.2514002),(197,24226,0.57373047),(197,24432,0.39084342),(198,12375,0.19571544),(199,1171,0.11535988),(199,8132,0.8037999),(199,10348,0.9883615),(199,26955,0.31419286),(200,15869,0.6066234),(200,22734,0.37582216),(200,28317,0.95635986),(200,30107,0.13069038),(200,32743,0.51460624),(201,4288,0.87590724),(201,15302,0.46516696),(201,22766,0.28382128),(201,31884,0.12028638),(202,4156,0.8718922),(202,11728,0.2660175),(202,15233,0.2403865),(203,415,0.6320991),(203,4780,0.66767585),(203,13139,0.38138282),(203,15563,0.5885662),(204,26754,0.7696238),(204,31151,0.90069455),(205,5806,0.21321176),(205,10747,0.74941826),(205,27955,6.0781233e-2),(205,32347,0.59425545),(206,4995,0.33314887),(206,16472,0.7155412),(206,16780,0.18691048),(206,27325,3.4146406e-2),(207,3977,0.4443225),(207,9086,0.84191054),(207,15751,1.1478355e-3),(208,13225,0.79925334),(208,13824,0.37049955),(208,14518,0.30885828),(208,32764,0.12883104),(209,9231,0.30079776),(209,10884,0.83292764),(209,11992,0.48011488),(209,17277,0.67034066),(210,14486,0.66399604),(210,18915,0.25448468),(211,2820,0.6426675),(211,4884,0.3608773),(211,5059,0.82574826),(211,19872,0.90205514),(212,16242,0.19226599),(212,19066,0.9155706),(212,24101,0.12075212),(212,29556,8.271134e-2),(213,15345,0.21327499),(213,29503,0.802693),(214,4055,0.30010465),(214,5564,0.5718523),(214,9455,0.3756557),(214,10186,0.7456967),(214,11690,6.398246e-2),(214,18219,0.34578833),(214,19446,0.21688345),(214,26058,0.97682416),(215,357,0.22543097),(215,5631,0.27193817),(215,16991,0.60518944),(217,8412,0.12954739),(217,23802,0.5753899),(217,27239,0.59611887),(218,8814,0.8772473),(218,14117,0.7091063),(218,18294,0.2967329),(218,22740,0.9947574),(219,592,0.16435799),(219,1907,0.936829),(219,20909,0.300051),(220,1340,0.5938027),(220,9923,0.9231663),(221,10327,0.32961357),(221,30962,0.43034983),(222,381,0.6599295),(222,6371,0.47433493),(222,19027,0.7400456),(222,20030,3.3260856e-2),(223,6050,0.47246373),(223,13497,0.56950396),(223,25135,0.28921878),(223,27097,0.45213702),(223,29047,0.2882987),(224,2083,0.25435737),(224,4834,0.7316157),(224,8721,0.42795748),(224,16638,0.4289786),(224,23492,0.2564821),(225,8243,0.26273865),(225,11690,0.8639392),(225,12093,0.86925495),(225,15049,8.432924e-3),(225,15684,0.5895093),(225,28711,0.75823295),(225,29166,0.6857075),(226,15895,0.71353126),(226,24343,0.39625877),(227,7021,0.5672807),(227,9752,0.28328213),(227,17871,0.6942188),(228,5909,0.8027611),(228,8772,9.435935e-2),(228,10014,0.4254393),(228,15776,0.9423002),(228,28066,0.12696454),(228,29168,0.36338732),(229,7173,0.9358849),(229,16485,0.45653623),(229,20246,0.56830645),(230,900,0.9542061),(230,16848,0.3009188),(230,17861,0.53841573),(230,28087,0.2743095),(230,29243,0.3162499),(231,6588,0.9417036),(231,12408,0.48488036),(232,2766,0.116343096),(232,13299,0.7095545),(233,3822,0.35988128),(233,4255,0.33071238),(233,16236,0.38113868),(233,30662,0.3754842),(234,14698,0.8783494),(234,18978,0.807646),(234,32381,0.6500148),(235,8479,2.5513824e-3),(235,11594,0.20076618),(236,791,0.64941394),(236,2065,0.14286183),(236,15174,0.9268005),(236,19293,0.95507187),(236,20323,0.3934641),(236,26910,0.14897515),(237,13472,0.3497138),(237,14133,0.32036662),(237,16356,0.5859936),(238,10380,0.43485457),(238,10493,0.32490483),(238,17901,9.587081e-2),(238,21150,0.50201535),(238,26354,0.38349617),(239,6778,0.1484163),(239,9540,0.43396044),(239,10949,0.6963754),(239,17295,0.12345472),(239,18172,0.2256568),(239,28212,0.5863132),(239,29912,0.9782526),(239,32604,0.24801631),(240,6291,0.13155076),(240,31534,0.94369715),(241,5928,0.54295486),(241,7830,0.9345231),(241,21525,0.82370394),(241,24231,2.466661e-2),(241,26929,0.886468),(242,3845,0.3699837),(242,4063,0.93849194),(242,5974,0.35347247),(242,7915,5.103241e-3),(242,32434,0.26877603),(243,7173,0.48429462),(243,31184,0.7069707),(244,12682,0.9984601),(244,23244,3.6758587e-2),(245,9997,0.3965971),(245,11410,8.332242e-2),(245,19470,0.52021277),(245,25812,0.2537632),(245,31993,0.3997174),(246,3326,0.39722303),(246,9184,0.35908508),(246,11455,0.4896569),(246,17096,0.6455209),(246,22178,0.41096854),(247,9100,4.8754264e-2),(247,17293,0.5084977),(247,21440,2.7915215e-2),(248,2046,0.8165032),(248,9507,0.5615961),(248,13978,0.3971957),(248,19713,0.40043622),(248,26780,0.9451698),(248,28607,0.8281879),(248,29149,0.11083195),(248,29867,0.8040164),(248,32400,0.87538135),(249,5023,0.1868849),(249,10982,0.9443503),(249,17696,0.57522845),(249,31321,0.39354128),(250,1205,0.8773659),(250,8868,0.26523504),(250,11424,0.5820956),(250,11528,0.81017977),(250,14872,0.45448655),(250,15350,0.94670266),(250,18957,0.3323137),(250,26186,0.16507225),(250,27987,0.6538269),(250,31232,0.4744823),(251,7701,0.4024257),(251,12011,0.46041295),(251,14991,0.9291061),(251,21711,0.3360066),(252,1202,0.29950738),(252,29546,0.48998314),(253,14474,0.82339215),(254,10471,0.1649189),(254,27173,0.5284737),(256,16919,0.34838516),(257,22224,0.75868464),(257,24388,0.488887),(258,2251,0.3891179),(258,13429,0.6689923),(258,16189,0.657582),(258,19832,7.167122e-2),(258,27804,0.16963904),(258,28866,0.58567023),(259,1163,9.516812e-2),(259,1370,0.7149646),(259,2930,0.9793553),(259,12110,0.91762483),(259,12832,1.6447989e-3),(259,20998,0.810129),(259,26124,0.38166472),(260,6938,0.103105545),(260,20297,0.68591666),(260,21578,0.6278377),(261,8096,0.5577927),(261,13256,0.4250226),(261,20054,0.42677313),(261,21320,4.0473755e-2),(262,1604,2.9400509e-2),(262,10752,0.9707226),(262,12163,0.6719669),(262,12349,0.14694285),(262,20675,0.80300766),(263,9396,9.750582e-2),(263,11564,0.94973594),(263,21544,0.88584733),(263,23623,0.66953355),(264,13684,0.6400529),(264,26244,0.97872853),(264,29840,0.9880995),(265,770,0.28021404),(265,20817,0.81035686),(265,31492,0.2140342),(266,1116,0.35083368),(266,9082,0.3528632),(266,18130,0.73110133),(266,19178,0.37405005),(266,31684,0.83325356),(267,9283,0.90674895),(267,12894,4.275151e-2),(267,14230,0.8212958),(267,21280,0.41921848),(267,25156,0.7590593),(268,9556,0.27086526),(268,24052,0.44831282),(268,29447,0.53410274),(268,30361,4.7999874e-2),(269,636,0.93325937),(269,5175,9.771544e-3),(269,30491,0.45284814),(270,12899,0.12855324),(270,13786,0.82331556),(271,21870,0.9277834),(271,27713,0.82356507),(271,28336,0.797614),(271,30701,0.7297372),(272,513,4.8434943e-2),(272,10397,0.6700473),(272,11923,0.2761597),(272,18877,0.6382402),(272,29695,0.6829815),(273,5516,0.53022623),(273,9500,0.756228),(273,11837,0.2952115),(273,19431,0.6962512),(273,29245,0.9329088),(274,8942,0.7474031),(274,16895,0.6685153),(274,20461,0.7006336),(274,23686,0.50232655),(274,30571,0.6883576),(275,16967,0.7271699),(275,20499,0.64691573),(275,23769,4.0556986e-2),(276,15612,0.6504706),(276,32510,0.9182635),(277,4320,0.96916056),(277,12519,0.51228845),(277,17649,0.78316635),(277,20818,0.46922228),(277,30261,0.48531318),(278,4813,0.32369956),(278,4925,0.76701474),(278,6806,0.2747752),(278,26756,0.44874343),(278,29062,0.41112828),(279,4568,0.7414068),(279,5926,0.3168357),(279,23364,0.80891365),(279,23987,0.52157456),(279,28045,0.46288177),(280,7963,0.4069968),(280,9988,0.31519198),(280,13560,0.9303689),(280,19140,0.3520971),(281,6678,0.7978781),(281,31373,0.41888517),(282,729,8.4444754e-2),(282,22280,0.47594962),(283,3012,0.9579771),(283,13423,0.37775928),(283,23004,0.4982661),(283,31096,2.278555e-3),(285,2945,2.7424062e-2),(285,8921,0.9634334),(285,20275,4.6719607e-2),(285,30325,0.21446548),(286,21378,4.166557e-2),(287,6598,0.7679744),(287,23152,0.62184817),(287,23194,0.7627184),(288,4128,0.8993432),(288,7298,0.15312913),(288,17032,0.7514665),(288,17428,0.3014341),(288,27513,3.3943627e-2),(288,30277,0.83339113),(288,32752,0.35260826),(289,157,0.52752334),(289,9242,0.896785),(289,10132,0.29226825),(289,16313,2.8158508e-2),(289,17959,0.98302037),(289,18421,0.6965268),(289,25152,0.19991583),(290,6682,0.90814763),(290,17415,0.40938342),(290,19743,0.45552358),(290,21388,0.13937357),(290,25437,0.6747035),(291,16060,0.44723687),(291,22462,0.2798393),(291,24123,0.8390802),(291,31071,0.18301517),(292,8191,0.62495863),(292,10029,3.2722754e-3),(292,14827,0.14829063),(292,26340,0.90986043),(292,30350,4.1292604e-2),(292,30635,0.9247892),(293,11986,3.392415e-2),(293,12743,0.1497011),(293,16825,0.63236064),(293,20780,0.5718438),(294,12028,0.6002596),(294,15092,0.19983953),(294,18640,2.3984825e-2),(294,20832,0.59535587),(294,24496,0.5668096),(294,27478,0.96118486),(294,27552,0.35212064),(294,32112,0.98406875),(295,7391,0.86386585),(296,11720,0.44753745),(296,13555,0.84677595),(297,1160,0.18771467),(297,9792,0.6391524),(297,20722,0.7489866),(297,29126,0.6486388),(297,29305,0.54643404),(297,32651,0.6713616),(298,2074,0.27784953),(298,15842,0.12956557),(298,19780,0.45455873),(298,29239,0.76975),(299,9805,0.83267295),(299,25231,0.26033747),(300,9511,0.23214617),(300,22418,0.39514446),(300,22639,0.39142314),(300,29131,0.4443741),(300,29531,5.8057204e-2),(300,30269,7.3949985e-2),(300,32025,0.58230174),(301,1168,0.63592845),(301,7988,8.450208e-2),(301,8550,0.39310437),(301,14476,0.6737756),(301,14695,0.78953385),(301,18862,0.7228555),(301,20851,0.9809238),(301,24481,0.7203147),(301,24983,0.5167524),(302,2391,0.20566712),(302,3278,0.26362446),(302,8014,0.13675763),(302,9004,0.7025422),(302,23226,0.5653884),(302,25540,0.3904943),(302,31300,0.75708044),(303,10646,0.112333834),(303,11046,0.21133591),(303,17102,0.333758),(303,17709,0.84402907),(303,18129,0.7312563),(304,10878,0.9885345),(304,11660,0.85451734),(304,12269,0.61556035),(304,17290,0.52030295),(304,18573,0.19137318),(305,4914,0.19023564),(305,14533,0.59969354),(305,21882,0.6389764),(305,26190,0.782506),(306,1076,0.59694195),(306,2355,0.20954578),(306,16348,0.9688537),(306,19082,0.80146754),(307,9213,0.7860098),(307,11859,0.12280611),(307,18585,0.99721336),(308,2291,0.117292464),(308,4604,0.7425049),(308,11219,0.83520776),(308,29436,7.393284e-2),(309,2844,0.7970548),(309,5584,0.54051375),(309,11533,0.75235474),(309,17670,0.70821995),(310,19099,0.9315619),(311,2041,2.1797923e-2),(311,10531,0.37818033),(311,28316,0.9785986),(312,3528,0.909033),(312,7732,0.15500562),(312,8774,0.14229728),(313,5725,0.10093423),(313,8993,0.6790525),(313,16516,0.8602835),(313,16765,0.76897305),(313,22022,0.9671937),(313,29495,0.84185946),(314,2121,7.8188345e-2),(314,6800,0.8643301),(314,15509,0.43811238),(315,2377,0.35259727),(315,12284,0.28461123),(315,29642,0.84649825),(315,32694,0.16206695),(316,12494,0.1761155),(316,32293,0.15403214),(317,20800,0.98874),(317,32454,0.55225205),(318,8438,0.7018973),(318,19086,0.7851957),(319,27627,0.856931),(320,2978,0.5215497),(320,10781,0.96067196),(321,6264,0.70305437),(321,13837,0.25948438),(321,17265,0.31575543),(321,19612,0.8267346),(321,22271,0.1658146),(321,22958,0.9630932),(321,25072,0.96845174),(321,29813,0.6541173),(322,15250,0.46209309),(322,20899,0.5914757),(322,23617,0.3593931),(322,29969,0.5723748),(323,9209,0.19937174),(323,11045,0.1614788),(323,14419,0.117655285),(323,24205,0.79720896),(323,25612,0.6175678),(323,30639,0.41642687),(324,3029,0.98987603),(324,6731,0.53310066),(324,19405,0.9954555),(324,22511,0.7128231),(325,9878,0.16638692),(325,10218,0.68988305),(325,23779,0.60022664),(326,3184,8.335103e-2),(326,6551,0.66340196),(326,7754,0.292756),(326,14225,0.81733227),(326,15050,0.5124797),(326,30370,0.909387),(327,2942,0.111830875),(327,8224,0.8142881),(327,19354,4.2700812e-2),(328,16467,0.5364282),(329,5310,0.47796196),(329,12157,0.37192905),(329,12522,0.42359036),(329,28137,0.73807234),(330,3509,0.77015465),(330,3541,0.6057183),(330,10867,0.95307004),(330,17793,0.21891282),(330,28492,0.300221),(330,29202,0.8497748),(331,2514,0.19735087),(331,17488,0.82528),(331,29328,0.92986566),(332,8465,0.42427945),(332,8538,0.42567047),(332,14663,0.8111172),(333,1498,0.7996826),(333,10264,0.5031956),(333,21884,0.92307484),(333,21959,0.82716155),(334,621,0.377963),(334,5887,0.5088199),(334,7974,0.48845583),(334,11146,4.9040753e-2),(334,13836,4.519608e-2),(334,13887,0.6168838),(334,24070,0.40315226),(334,26945,0.32724077),(334,28100,0.35435197),(335,2876,0.7109221),(335,9407,0.9632104),(335,17568,0.84268826),(335,18843,0.27074036),(335,19361,0.49358103),(335,24177,0.76208335),(335,28814,0.8617658),(336,23554,0.18170334),(336,26222,0.17770593),(336,26749,0.9326988),(337,7851,1.0716559e-2),(337,26456,0.18967421),(337,26815,0.58899444),(338,19075,2.9539585e-2),(338,26586,0.31290013),(338,30601,6.2283255e-2),(339,5083,0.672556),(339,21605,0.80533683),(339,21871,0.4592203),(340,11097,2.9472217e-2),(340,15717,0.8538903),(340,17198,0.38115722),(340,18004,0.37933174),(340,23200,0.52644825),(340,31490,0.93096906),(342,1373,0.84761125),(342,5276,0.16171111),(342,13734,0.32051286),(342,26091,0.6417934),(342,30735,0.1853698),(342,31148,0.88047594),(342,32692,0.80639076),(343,2233,0.84766656),(343,16231,0.15166914),(343,24499,0.18862902),(343,25846,0.66653407),(343,28808,0.30538434),(344,7052,0.47479916),(344,7971,0.2967211),(344,24356,0.28718847),(344,25836,0.8065798),(345,105,0.6916792),(345,1813,0.13468367),(345,8045,3.9951578e-2),(345,23447,0.7835156),(345,25121,0.29112273),(345,28318,0.69229275),(346,18600,0.7908989),(346,29477,0.31387764),(346,32358,0.83777106),(347,8677,0.6481754),(347,21457,0.85522497),(348,5134,0.20060672),(348,13121,0.80629086),(348,28645,0.78404367),(349,15137,0.30200747),(349,22822,0.45501712),(349,24897,0.6313904),(349,31016,0.1166949),(349,32276,0.95717555),(349,32749,0.68329024),(350,16876,0.124558486),(350,18222,0.9732932),(350,19117,5.7945505e-2),(350,24077,0.37776354),(350,25066,0.8884835),(351,6679,0.1425617),(351,16463,0.40878573),(352,10526,0.4498409),(352,21969,0.18585265),(353,1158,0.8262538),(353,2889,0.69324183),(353,3780,0.36047816),(353,5505,0.42585808),(353,6711,0.627654),(353,8954,0.6872861),(354,25066,5.0065555e-2),(355,477,0.91588354),(355,14757,0.43962267),(355,26615,0.9155174),(356,2952,7.64349e-2),(356,10708,0.34212905),(356,11820,0.97672313),(356,13419,0.50896627),(356,24859,0.40873936),(357,6517,0.69705707),(357,22272,0.931918),(357,27555,0.6591035),(358,7884,0.90059084),(358,9105,0.3402617),(358,22005,0.28401765),(358,23258,0.75741994),(358,24548,0.4051519),(358,28243,0.10409666),(358,31214,0.3031512),(359,7458,0.30022234),(359,23823,0.39910078),(359,32558,0.5235354),(360,565,8.827676e-2),(360,13593,0.43588752),(360,13863,0.72014034),(360,22964,0.32582453),(360,24951,0.7476873),(361,14244,0.23232406),(362,1640,0.48251304),(362,4668,0.6750673),(362,13929,0.11716297),(362,22890,0.39840993),(362,23562,0.6232627),(363,21028,0.95151687),(363,24374,0.56324273),(364,11227,0.5210951),(364,23305,0.70938015),(364,24798,0.18454558),(364,27854,0.20492692),(364,29331,0.93092436),(365,1697,0.4689117),(365,4094,0.667443),(365,6136,0.25818533),(365,6545,0.6590782),(365,8310,0.7177774),(365,12326,0.5080481),(365,13814,0.93079084),(365,14183,0.8908854),(365,15682,0.3498167),(365,20610,0.8006748),(365,21139,0.18279013),(365,23843,0.20544052),(366,378,0.5127421),(366,5728,0.83903724),(366,6821,0.49210995),(366,7038,0.32930166),(366,27130,0.87667704),(366,28078,0.9794839),(366,29109,0.10220646),(367,18116,0.36645877),(367,24844,0.3668532),(367,31524,0.7786489),(368,4651,0.122449115),(368,10255,0.67021525),(368,11552,0.16414651),(368,14012,1.0599181e-2),(368,17640,4.905023e-2),(368,30985,0.7186211),(369,1173,0.36977217),(369,16851,0.8423106),(369,22906,0.521079),(370,14735,0.475076),(370,15464,0.8074643),(370,19490,0.7840713),(371,5480,0.69349444),(371,11484,0.84987855),(371,15759,0.51767117),(371,17402,0.8302714),(371,20422,0.89820856),(371,23181,0.15157282),(372,3612,6.254137e-2),(372,4774,0.91389),(372,13045,0.67295086),(372,27039,0.30357444),(372,27923,0.90897775),(372,31188,0.70097667),(372,31196,0.93210036),(373,6414,0.16957232),(373,14484,0.38177356),(373,17241,0.8619447),(373,22079,0.9846528),(373,23276,0.85905933),(374,8365,0.52910084),(374,18369,0.95868033),(375,1231,0.5684544),(375,3922,0.5355671),(375,12651,0.1188763),(375,16280,0.2644389),(375,30353,0.25879738),(376,6638,0.48876974),(376,14123,0.8256233),(376,18465,0.6233952),(376,18741,0.1496216),(376,27435,0.14222054),(376,27579,0.84761757),(377,5829,5.3803597e-2),(377,13106,0.8924589),(377,19823,0.4968203),(377,20869,0.9374312),(377,23978,0.59678006),(377,29419,0.7943921),(378,2618,6.711697e-2),(378,3551,0.44268292),(378,8797,0.3819348),(378,12618,0.56787074),(378,27507,0.37585342),(378,28288,7.1005665e-2),(379,518,0.9208631),(379,22089,4.530545e-2),(379,29576,0.3356816),(380,1608,0.6075677),(380,7258,0.52727425),(380,13051,0.7925951),(380,14347,0.34607783),(380,25633,0.99211013),(381,3799,0.48024997),(381,7401,0.39166528),(381,10052,0.62999386),(381,13251,0.1294136),(381,28570,0.90605307),(382,8349,5.310075e-2),(382,14290,0.4901124),(382,16752,0.31307527),(382,18345,0.34233302),(382,21255,0.47639525),(382,26434,0.84291744),(382,27361,0.50015026),(383,1913,0.6763196),(383,2333,0.40660417),(383,5586,0.26473704),(383,10145,0.88127744),(383,13745,0.9092452),(383,22504,0.23139638),(383,26181,0.4682529),(384,3411,0.7202126),(384,10308,0.9093836),(384,28156,0.22459076),(385,5839,0.10200327),(385,9257,1.85832e-2),(385,15935,2.5702247e-2),(385,17231,0.5793992),(385,18005,0.4658795),(385,22544,0.87870413),(386,3362,0.8369057),(386,31044,0.93919986),(387,9944,0.5816513),(387,16742,0.23409876),(388,15682,0.94941384),(388,16615,0.3119534),(388,20629,0.46378043),(388,23027,0.47688022),(388,27067,0.20308472),(389,22900,0.93851876),(389,27007,0.24838558),(390,1063,0.27822202),(390,6224,3.686798e-2),(390,13979,0.31023452),(390,18263,0.7892414),(390,22238,0.39125612),(390,24892,0.20886534),(391,6918,0.47069418),(391,14877,0.1293095),(391,17687,0.5214538),(391,24539,0.5215247),(391,26564,0.50478387),(392,143,0.33046135),(392,790,0.28717047),(392,1454,0.6580196),(392,1878,0.18186586),(392,4933,0.7488646),(392,13374,0.2810469),(392,18020,0.7830195),(392,24838,0.3240423),(392,28287,0.5955831),(392,32238,0.969736),(393,0,0.86225855),(393,1471,0.20050362),(393,1524,0.8581138),(393,20373,0.97932357),(393,20395,0.2984912),(393,22116,0.6789446),(393,30843,0.45593002),(393,32077,0.6397691),(394,124,0.54393536),(394,6373,0.3511915),(394,6694,0.5430342),(394,17325,2.649076e-2),(394,19209,0.8156096),(394,20186,0.3948741),(394,24863,0.9577223),(394,31266,0.71275145),(395,14725,0.28577584),(395,14976,0.46448526),(395,17030,0.8962772),(395,25240,0.28275043),(396,11223,0.269877),(396,19806,0.60669917),(396,31480,0.594913),(397,1154,0.5236226),(397,1861,0.49405438),(397,7092,0.42611215),(397,14320,0.39658067),(397,15182,0.37083656),(397,32436,7.0537575e-2),(398,5322,0.9248233),(398,8065,0.60012037),(398,14251,0.6856729),(399,2420,3.785519e-2),(399,20639,0.9728606),(400,11669,0.8156737),(400,21865,0.8189032),(400,31964,0.6296153),(401,12377,0.27961034),(401,16902,0.41419756),(401,21383,0.5289856),(401,32110,0.37192553),(402,1198,0.45087722),(402,7375,0.9197233),(402,16829,0.5565014),(402,20588,0.44610047),(402,20714,0.18582489),(402,29761,0.3465883),(403,77,0.8096466),(403,18494,0.6319023),(403,28075,0.6518652),(404,16064,0.5829377),(404,31139,0.75426924),(405,16507,4.2186677e-3),(405,20819,0.25465623),(405,25033,0.8035947),(405,26297,0.6634934),(406,6018,0.12002361),(406,9924,0.56561935),(407,11201,0.2777196),(407,12359,0.32077467),(407,21573,0.819963),(408,13666,0.87485117),(408,15301,0.27282777),(409,15371,0.4129877),(409,19870,0.6235699),(410,4052,0.17500798),(410,7860,0.81109065),(410,16957,0.5352906),(410,22665,0.39609617),(411,2489,0.7594591),(411,23285,0.65179336),(411,32013,0.7179696),(412,858,0.5743417),(412,15897,0.3528581),(412,21038,0.6022515),(412,30669,0.99950475),(412,31716,0.122318916),(413,26853,0.17229417),(413,31718,0.46778765),(414,8343,0.1510239),(414,26277,3.9470423e-2),(414,28782,0.7174696),(415,8713,0.46987355),(415,25314,0.23018777),(416,5427,0.66782635),(416,7133,0.4025748),(416,14597,0.6343143),(416,19630,0.17973402),(417,4666,0.83509636),(417,10793,9.291405e-2),(417,11314,0.54238755),(417,15498,0.4564101),(417,27263,0.606764),(417,30284,0.8135313),(418,1410,0.30888638),(418,8139,4.3689355e-2),(418,12388,0.18076622),(419,2848,0.6814122),(419,8116,0.4019834),(419,10333,0.27232808),(419,10693,0.7122957),(419,29163,0.837774),(420,571,0.48410416),(420,1035,0.736707),(420,22925,3.9920792e-2),(421,15838,0.87561613),(422,13749,0.67269546),(422,25797,0.20351897),(422,27549,0.968414),(422,28198,0.7259493),(423,3469,0.4147602),(423,19273,0.5595684),(424,3307,0.59994507),(424,10734,0.17604303),(424,25009,0.5858166),(424,26138,0.2622632),(425,8964,0.8942141),(425,20414,0.99979866),(427,12456,0.49222183),(427,14344,0.13097787),(427,15121,0.18543543),(427,29265,0.6429557),(427,32593,0.7665523),(428,4296,0.16056296),(428,18466,0.21402703),(428,22228,1.1730313e-2),(428,28278,0.7371529),(429,3767,0.450273),(429,23616,0.7880235),(429,23763,0.8536651),(429,29998,8.1561886e-2),(430,7482,0.11245014),(430,10421,0.5012113),(430,23680,0.95626634),(431,10735,0.8156669),(431,20605,1.7021995e-2),(431,23906,7.802185e-2),(431,29556,0.8344123),(432,1902,2.517326e-4),(432,9940,0.9051226),(432,19708,0.14786805),(432,20669,0.86168075),(432,22893,0.72627306),(433,9009,0.5210254),(433,13410,0.8378554),(433,14298,0.35770252),(433,27249,0.79749274),(433,28933,5.0947618e-2),(434,145,3.6879305e-2),(434,14729,0.22872119),(434,23463,0.5980899),(434,23940,0.8751568),(434,25332,0.1585319),(435,13563,5.8124224e-3),(435,25408,0.76260036),(436,1611,0.5604683),(436,6301,0.8116193),(436,7575,0.54811245),(436,19458,0.7006487),(437,860,0.27729043),(437,15950,0.4018425),(437,17728,0.9016032),(437,18316,0.106462225),(437,18476,7.947055e-2),(437,26023,0.78289855),(437,27096,0.16735092),(437,30195,0.35553026),(437,31924,0.6939347),(438,19635,0.17038076),(439,15174,0.33427715),(440,3222,0.69724405),(440,18128,0.22499529),(441,23293,7.306729e-2),(442,4255,0.94990665),(442,9150,0.5443244),(442,9587,0.19224171),(442,12362,0.7751817),(442,14668,0.857879),(442,18387,0.5578532),(443,2987,0.44203937),(443,13926,0.39283627),(443,20150,0.10703182),(443,25459,0.42470726),(443,29232,0.7603081),(443,29992,0.5989081),(444,2005,0.45183635),(444,3573,0.58168167),(444,9702,0.1393781),(444,10015,0.16650304),(444,10185,0.34829986),(444,15711,0.45865452),(444,21108,0.7980182),(445,28492,0.22728206),(446,24994,0.10664687),(447,14129,0.15318212),(447,15521,0.94204354),(448,16367,0.16134854),(448,28270,0.48926616),(449,6880,0.74384195),(449,7303,0.46833345),(449,14111,0.20365123),(449,32187,0.8732595),(450,4375,4.320377e-2),(450,10285,0.58368516),(450,14374,0.6763354),(450,22239,0.20639028),(450,30722,0.71051043),(451,19852,0.8377849),(451,24486,0.22265343),(451,29869,0.84080416),(452,807,0.9511165),(452,6303,0.17101175),(452,10888,0.29391405),(452,12866,0.31797293),(452,18241,0.428686),(453,27086,0.4445761),(454,5049,0.90787977),(454,8049,0.8586637),(454,12769,0.39308852),(454,14084,6.543985e-2),(454,16375,0.18718547),(454,21046,0.29350647),(454,21948,0.5191727),(455,1646,0.8882336),(455,2661,0.16318622),(455,6120,0.84800345),(455,8153,0.95351535),(455,10122,0.84785706),(455,10979,0.29440233),(455,14152,0.77695525),(455,17445,0.65727377),(455,19267,4.2945035e-2),(455,31939,0.40935668),(456,2640,0.24636163),(456,5123,0.69934416),(456,10224,0.34943062),(457,21676,0.61501926),(457,32613,0.124109164),(458,8823,0.28805044),(458,13462,0.68715084),(458,19966,0.35375485),(458,27445,0.30595982),(458,30432,0.8523858),(458,32470,0.39641273),(459,10,0.47946775),(459,13667,0.9389195),(460,5092,0.13601556),(460,7322,0.89065135),(460,10728,0.7763149),(460,12161,2.612659e-3),(460,13076,0.89620674),(460,18126,0.39644825),(460,28376,0.36494076),(460,30760,2.4614796e-2),(461,5878,0.5086797),(461,12122,0.41078427),(461,22295,0.16960469),(461,30512,0.3881),(462,3137,0.6548659),(462,4295,0.90392643),(462,5105,0.6554057),(462,21881,0.1252776),(462,22897,0.6549293),(462,30091,0.83553207),(463,6642,0.257398),(463,9532,0.70694757),(463,12062,0.26442057),(464,4396,0.94307697),(464,28358,0.8084482),(464,29263,0.17812754),(465,1379,8.000565e-2),(465,5186,0.1185241),(465,23705,0.4096188),(466,7841,0.5051732),(466,20959,0.10959584),(467,16243,0.502142),(467,20468,0.7619261),(468,12329,0.39208964),(468,17630,0.25190964),(468,18752,0.7681206),(468,24228,0.18652125),(469,4997,0.8777397),(469,5053,1.8082509e-2),(469,7705,0.4651381),(469,11375,0.4122176),(469,25923,1.4381001e-2),(470,5218,0.80096763),(470,9656,6.2090964e-3),(470,14214,0.5467347),(470,19835,1.1254017e-2),(470,26408,0.16401039),(471,490,0.8874584),(471,4068,0.5892914),(471,9292,0.3273055),(471,11379,0.38371304),(471,14252,0.7156926),(471,19740,0.78820527),(472,2922,0.11749446),(472,7289,0.7379066),(472,7371,0.36002985),(472,31630,0.74372596),(473,404,0.19333392),(473,13253,0.1480931),(473,16832,0.17906556),(473,19231,0.997258),(474,4183,7.415728e-2),(474,7786,0.79640585),(474,19673,0.9758081),(474,21264,0.9954869),(475,4195,0.5116481),(475,4399,0.37819207),(475,5647,9.577779e-2),(475,11264,6.659065e-2),(475,11891,0.24590203),(475,23636,0.85710937),(476,3707,0.17864284),(476,18668,0.29327583),(476,27313,0.6074846),(476,30930,0.23921612),(476,32436,1.8913677e-2),(477,126,0.7834402),(477,4982,0.21113208),(477,9270,0.7458648),(477,9859,0.98397714),(477,25404,1.4699098e-2),(478,2004,0.7975845),(478,4017,0.64433664),(478,16692,0.8787292),(478,26814,0.8825608),(479,17677,0.2725393),(479,19992,0.5073116),(480,16998,9.579506e-2),(480,17779,0.51266897),(480,25862,0.14748031),(480,30007,0.57366014),(481,10451,0.8154076),(481,11094,0.39184633),(481,15108,0.35412025),(481,22608,0.74774456),(482,1068,0.53782433),(482,24867,0.9799149),(482,30867,0.4315912),(483,29695,0.830185),(484,6969,0.2534496),(484,20803,0.5113723),(484,23270,0.27861956),(484,24510,0.32384768),(485,10511,0.6360655),(485,20748,0.9969061),(485,21105,7.3109075e-2),(485,23197,0.46192),(485,31753,0.60033494),(486,20549,0.96191573),(487,8977,6.705707e-2),(487,25229,0.51704305),(487,27602,7.089179e-2),(487,29082,0.8207876),(487,32628,0.19314402),(488,12762,0.73636144),(489,10691,0.36366123),(489,25634,0.56961644),(490,6298,0.49383742),(490,14874,0.2288449),(490,18498,0.6694546),(490,19249,0.37723795),(490,22600,0.53803927),(491,326,3.2938894e-2),(491,2138,0.7612882),(491,11428,0.20309821),(491,12817,0.99203616),(491,13184,0.9619203),(491,17070,0.9059445),(491,28470,0.6758267),(492,15857,0.8382139),(493,377,0.8316688),(493,1536,3.097044e-2),(493,11474,0.18014365),(493,17500,0.3010338),(493,28980,0.71370846),(493,29900,0.9337151),(493,30665,0.3846086),(493,32063,0.4467198),(494,7129,0.8039293),(494,9346,0.64059377),(494,25837,0.34528732),(494,27010,0.7810819),(494,30669,0.4262062),(494,31258,0.27102298),(495,5856,3.5864864e-2),(495,16508,0.1259639),(495,20123,0.322122),(495,26152,0.99822277),(495,29447,0.96844655),(496,4801,0.83873814),(496,9308,0.18195145),(496,13502,0.5353379),(496,16689,0.6317571),(496,17061,2.7673878e-2),(496,19121,0.4543633),(496,20328,0.24622115),(496,22909,0.98836446),(496,22923,8.384966e-2),(496,22929,0.5760763),(496,29225,0.5483383),(497,7767,0.8923988),(497,11908,0.67333937),(497,19872,8.84994e-2),(497,24973,0.81980765),(497,26818,0.9824607),(497,28671,0.48889002),(498,4802,0.87551403),(498,10978,0.7548582),(499,3361,0.39557418),(499,16618,0.34742284),(499,20895,0.2092742),(499,22103,2.4707444e-2),(499,24861,0.9786175),(500,5870,0.2030999),(500,8570,0.6282025),(500,11853,0.82516205),(500,12100,0.61577296),(500,14914,0.22370835),(500,19373,5.384194e-2),(500,24351,0.8588629),(501,2899,0.12754466),(501,12428,0.43783736),(501,12912,0.9169868),(501,32223,0.91138667),(501,32530,0.2674584),(502,1066,0.22613914),(502,2427,0.14127026),(502,26422,7.4968085e-2),(502,30921,0.7218051),(503,2485,0.5734507),(503,8554,0.5792229),(503,25746,0.2883762),(503,25807,0.11780683),(503,28540,0.5682382),(503,31204,0.38013756),(504,21385,0.44159454),(505,7090,0.43884328),(505,19632,0.81385106),(505,24638,0.27383044),(505,26103,0.8291724),(506,11226,6.067667e-2),(506,28160,0.2889834),(507,6543,8.19168e-2),(507,12504,0.41803405),(507,16731,0.57071096),(507,22667,0.4046379),(507,27949,0.50600684),(507,29358,0.17396162),(508,4403,0.28305098),(508,9942,4.1654523e-2),(508,15459,0.41399673),(508,20963,0.8919268),(508,30475,0.28756562),(508,31468,0.55405813),(509,5281,0.7982849),(509,16459,0.38106987),(509,18880,0.9085347),(509,22893,0.11625951),(509,23738,0.9336666),(509,24372,0.5246469),(509,25328,1.1322463e-2),(509,27449,0.16262397),(509,30006,0.6153345),(510,103,0.28915057),(510,12826,0.7356422),(510,30365,0.20750563),(511,1496,0.58693075),(511,7014,0.82486755),(511,22339,0.1676868),(511,28299,0.95735216),(511,31211,0.85032564),(511,31748,0.3485103),(512,8161,0.28878596),(512,11025,0.39868504),(512,11958,0.13193335),(512,13224,0.40819013),(512,16270,0.57961565),(512,18876,0.83542585),(512,19362,0.8939866),(512,23253,0.58247524),(513,12018,0.37999985),(513,18056,0.22881733),(513,30071,0.16900307),(514,67,0.75407785),(514,3055,5.4352465e-3),(514,3794,1.4922439e-2),(514,7748,0.115131564),(514,7857,0.94198763),(514,20918,0.62131774),(515,514,0.11309085),(515,929,0.44856432),(515,24296,0.60637933),(516,12153,0.3042874),(516,22149,0.7869292),(516,23153,0.93083936),(516,23317,0.66563195),(517,2136,0.42373353),(517,3467,0.7581037),(517,7479,0.41081306),(517,8938,0.93417037),(517,10929,0.8300162),(517,19820,9.419149e-4),(517,27397,0.9903654),(517,29624,0.2673531),(518,2590,0.79820967),(518,22535,0.25936744),(518,31515,0.74140584),(519,18585,0.3479388),(519,21563,0.5712399),(519,26991,0.1879722),(519,27122,4.352563e-2),(520,9792,0.21926256),(520,11164,8.346498e-2),(520,14886,0.77378863),(520,15843,0.6890492),(521,16642,0.76895726),(521,22430,0.30453238),(521,23003,0.6653604),(521,27160,0.7138727),(522,10151,0.88477796),(522,11363,0.15796357),(522,13947,0.35542226),(522,28915,0.60301816),(523,942,0.50454324),(523,15928,0.620006),(523,29859,0.277713),(524,2783,0.22805956),(524,24743,0.347565),(524,31794,0.17095762),(525,22237,0.67252326),(525,31271,9.83841e-2),(525,31389,0.121959366),(526,13981,0.9550068),(526,21063,0.25830185),(526,26506,0.9639095),(526,28283,0.15531246),(527,1624,0.84783995),(527,10611,0.7668923),(527,17006,0.6897902),(527,26046,0.23513922),(527,26194,0.18105686),(527,26773,0.69075835),(528,5864,0.5245619),(528,9424,0.6381291),(528,14454,0.50151485),(528,16064,0.51089036),(528,19570,0.12675066),(528,25722,0.3930872),(529,1371,0.35750258),(529,3472,9.681476e-2),(529,16736,0.8826099),(530,15618,0.80755496),(530,32046,0.7580412),(531,7408,0.79951584),(531,8198,0.8645116),(531,16316,0.47938287),(531,24644,0.81993026),(532,2350,0.39082503),(532,6356,0.8095415),(532,7166,0.81724936),(532,16056,0.72927684),(532,19123,0.64444727),(532,25084,0.17958261),(532,32029,0.36416498),(533,1966,0.11388568),(533,3864,0.41389066),(533,6178,0.52092385),(533,18793,0.58874726),(533,23697,0.207503),(534,7081,0.27347383),(534,19091,0.6287984),(534,32696,0.5134737),(535,17666,0.5339238),(535,20694,0.5118758),(535,30852,0.8646281),(536,1249,0.40477678),(536,7259,0.30985087),(536,8177,0.70195323),(536,17403,0.18364915),(536,28113,0.41065893),(536,31844,0.29732326),(537,117,0.8477826),(537,543,0.9226941),(537,12726,0.89803946),(537,13774,8.7831184e-2),(537,15299,0.9909219),(537,26436,0.43483758),(538,484,0.7633708),(538,19400,0.37116373),(538,19526,0.3222282),(539,688,0.12490094),(539,28805,0.48653197),(539,30194,0.15541102),(539,31255,0.9982277),(540,3461,0.62449384),(540,12260,0.7921911),(540,13610,0.528948),(540,17470,0.52151185),(540,28546,0.85901076),(541,4580,3.6118004e-2),(541,16298,7.363584e-2),(541,17068,0.4284307),(541,19618,0.4075719),(541,21800,0.96354693),(542,3217,0.21018513),(542,14277,0.90242064),(542,17231,0.8522832),(542,23515,1.5500278e-2),(543,2061,0.6607039),(543,20213,0.3738329),(543,24129,0.56418025),(543,25791,0.8644726),(544,3093,0.7975221),(544,5233,0.34995165),(544,9132,0.9321739),(544,18974,0.50809103),(545,1184,0.5457043),(545,7014,0.5287731),(545,12295,3.218029e-2),(545,16597,0.74407405),(545,24619,0.94906485),(545,27192,0.16366763),(545,30002,0.99962276),(545,31398,0.72118574),(545,32709,0.7747354),(546,10003,0.28359511),(546,13391,0.61704457),(546,22293,0.7913361),(547,16281,0.18771507),(548,15194,0.64065623),(548,22324,0.2050983),(549,274,0.43445656),(549,1050,0.49547687),(549,5228,0.4705184),(549,9769,0.39849716),(549,12443,0.761351),(549,12553,5.942999e-2),(549,13060,9.974506e-3),(550,6934,0.8909659),(550,8099,0.1622837),(550,25623,0.85614175),(550,29745,0.31405708),(551,6083,0.26088437),(551,8056,0.53639525),(551,8069,6.1257094e-2),(551,31987,0.9986333),(552,6452,0.7017983),(552,12283,3.6067687e-2),(552,21722,0.53743476),(553,2791,0.18544424),(553,7940,4.5344267e-2),(553,16070,0.65650815),(553,19813,0.7641746),(554,1913,0.3935073),(554,3200,0.6059759),(554,9176,0.68792766),(554,25560,0.39292303),(554,27761,0.1107447),(555,1689,0.4685303),(555,19829,0.18497731),(555,23790,0.36008534),(555,27882,0.522534),(555,31344,0.96913165),(555,31562,9.060838e-2),(556,3923,0.18729357),(556,5962,5.465445e-2),(556,10045,1.2397197e-2),(556,17776,0.46866146),(556,18326,0.37107146),(556,23385,0.5587512),(557,5374,0.2801142),(557,17660,0.55989707),(557,18341,0.15678118),(557,18993,0.6344302),(557,20899,0.42396268),(557,31876,0.28225288),(558,4357,0.4163432),(558,20659,0.22130182),(558,23235,0.102225564),(559,6159,0.4177679),(559,7428,0.34539092),(559,11896,0.52071166),(559,27220,0.7082648),(560,7584,0.8993996),(560,7958,0.48231906),(560,9128,0.4776598),(560,26421,0.57913005),(561,29948,0.7883131),(561,30217,9.594273e-3),(562,703,0.865695),(562,3084,0.50709933),(562,4813,0.20946191),(562,9120,0.9663741),(562,13542,0.22955798),(562,28666,4.427455e-2),(563,1540,0.82076746),(563,9169,0.76021904),(563,20481,0.3790607),(563,24189,0.4040619),(563,30419,0.7569898),(564,1407,0.4038333),(564,14573,0.26268652),(564,16580,0.8043381),(564,23543,0.46552205),(564,24167,0.14890867),(564,24572,0.91404),(565,795,8.177757e-2),(565,3777,0.15610166),(565,27553,0.16844648),(566,18990,0.43353736),(566,23809,0.621891),(566,32296,0.5666091),(567,8313,3.936432e-2),(567,15137,0.68473864),(567,21625,0.36397508),(567,23317,0.93165904),(568,362,0.82219607),(568,2964,8.6589105e-2),(568,11724,0.851795),(568,12869,0.24759027),(568,24482,0.210674),(569,457,0.75038385),(569,3706,0.28222063),(569,5738,0.8183714),(569,32253,6.5963015e-2),(570,22341,0.45640472),(570,25047,0.2531108),(571,17840,0.24819653),(571,19760,0.572759),(572,3066,0.88577324),(573,13993,0.39128074),(573,18465,0.4557425),(573,24600,9.766091e-2),(573,24625,0.15099598),(574,4500,0.7960183),(574,4629,0.971481),(574,7115,0.19751595),(574,13013,0.8598797),(574,16123,0.89963204),(574,17969,0.40019506),(574,18941,4.6671897e-2),(574,29350,3.9523266e-2),(575,985,0.2060085),(575,3612,0.55842465),(575,14262,0.62289476),(575,17882,0.17346576),(575,18150,0.4220025),(575,21612,0.47388592),(575,23860,0.7925684),(575,25334,0.64621997),(575,31816,0.90018773),(576,251,8.2691245e-2),(576,4537,0.7553792),(576,16949,0.3915885),(576,17269,0.13097134),(576,21551,0.9640209),(576,30255,0.101943575),(577,11234,0.8370268),(577,18046,0.43215436),(577,22041,0.101712674),(577,27885,0.5588243),(578,13135,0.9614402),(578,13738,0.37151077),(578,29698,0.115350656),(579,5847,0.68446946),(579,7248,7.5212926e-2),(579,8855,2.7050635e-2),(579,13768,0.60535574),(579,19097,0.26320595),(579,20954,0.9619491),(580,749,0.842139),(580,5067,0.760531),(580,5763,1.8361682e-2),(580,28196,0.81232077),(581,20302,0.67805725),(581,31853,0.3437527),(582,628,0.65955436),(582,10310,0.120407715),(582,11031,0.4608429),(582,14524,0.48160222),(582,25258,0.6318712),(583,9385,0.9141273),(583,15827,0.4392253),(584,6597,0.9893843),(584,13956,0.46202186),(584,15541,0.43826315),(584,18869,0.35256836),(585,9227,0.9661139),(585,22490,0.37746367),(585,24049,0.24546306),(586,2422,0.38393173),(586,13975,0.6334993),(586,15408,0.97822493),(586,25169,9.509944e-2),(586,29341,0.31575608),(587,585,0.89141655),(587,14016,0.56942326),(587,20424,0.50584),(587,24730,4.205204e-2),(587,30934,0.35280827),(587,31518,0.44597048),(588,3769,0.4892264),(588,15129,0.86291075),(588,18132,6.499033e-2),(588,20509,0.5724741),(588,21320,0.42800933),(588,24211,0.8528566),(589,63,0.56549704),(589,1214,0.60947573),(589,3008,4.8089113e-2),(589,23062,1.6689124e-2),(590,4408,0.1737083),(590,5474,0.36246234),(590,9615,0.84119403),(590,23763,0.4806952),(590,27778,0.22780353),(591,14167,0.16736291),(592,944,0.23119862),(592,5306,0.37998953),(592,7511,0.5532813),(592,13489,0.53329474),(593,11341,0.50149006),(593,11844,0.934097),(593,20648,0.7607544),(593,21540,0.56782365),(593,25541,0.33815882),(593,25765,6.751185e-2),(594,16754,3.641596e-2),(594,19423,0.838292),(594,23242,0.40825808),(594,26403,0.55512977),(595,143,0.6532736),(595,2328,0.6481249),(595,8329,0.49204984),(595,15508,4.512432e-3),(595,18568,0.988298),(596,1519,0.26237127),(596,3455,0.7202634),(596,6722,0.24951212),(596,13488,0.4370458),(596,22465,0.28683528),(596,27549,0.7414209),(596,28985,0.83670413),(596,30752,0.7105664),(597,4044,0.86048687),(597,12726,0.9648171),(597,14879,0.24053),(598,4475,0.5681505),(598,18674,0.41669607),(598,20495,9.005679e-2),(598,21182,0.4731391),(599,1679,0.39702812),(599,8812,0.4292573),(599,11153,5.409507e-3),(599,16353,0.5862911),(599,21536,0.17498817),(599,32024,3.3173434e-2),(600,186,0.34187925),(600,8665,0.19103536),(600,28464,0.4882549),(600,31378,0.62570095),(601,926,0.7013331),(601,19377,0.9067024),(601,20804,0.30548957),(601,24155,0.11167942),(602,2029,0.65019876),(603,4909,9.797062e-2),(603,6298,0.72434),(603,17021,0.24782199),(603,18380,0.96004486),(603,27875,0.27094987),(603,28735,0.18357375),(603,29426,0.9617974),(604,15,0.47837257),(604,2083,0.50768733),(604,14992,0.5276279),(604,15972,0.93597335),(604,16587,0.9824812),(604,21341,0.9225582),(605,593,0.31484652),(605,2537,8.7089404e-2),(605,13331,0.49983424),(606,3349,0.20920843),(606,30459,0.9953672),(607,16956,0.42658618),(608,4115,0.8474323),(608,6754,0.43027833),(608,9697,0.35331383),(608,10325,0.30204552),(608,11902,0.9455466),(608,15031,9.7368136e-2),(608,19814,0.8653919),(608,27408,0.38712832),(608,28527,0.15868203),(609,14276,6.373202e-2),(609,15487,0.81099504),(609,22129,0.7592187),(610,620,0.8215055),(610,2414,0.39065552),(611,4029,0.700432),(611,12625,0.30186114),(611,21938,0.18876502),(612,17503,0.52065957),(612,22191,0.8545003),(612,32311,0.37328842),(613,150,0.81087995),(613,7881,0.13182928),(613,9120,0.11020162),(613,16300,0.7154495),(613,27995,0.19477311),(613,28852,0.980108),(615,7099,5.7602144e-4),(615,20473,0.5493937),(615,21595,0.31174052),(616,1130,0.2401687),(616,18662,3.7009858e-3),(617,1514,0.14448233),(617,9060,0.62385553),(617,19906,0.33159542),(618,2166,0.20838442),(618,3327,0.36839554),(618,10248,0.9376946),(618,12980,0.49959943),(618,17830,0.65459955),(618,20941,0.3760406),(618,31619,0.19942941),(619,6101,0.9117933),(619,15058,0.4992373),(620,8608,0.5764934),(620,13918,0.6861324),(620,24769,0.67706645),(620,29567,0.53193223),(621,1885,0.7131115),(621,11789,0.38877872),(621,24251,0.5942247),(621,26723,0.7240358),(622,152,0.63412225),(622,22171,0.67328095),(623,3023,0.4001574),(623,11448,0.79145163),(623,12583,0.62147564),(623,32389,0.16729467),(624,9919,0.6382196),(624,26357,0.41299665),(624,27222,0.5962748),(624,32596,6.6956766e-2),(625,360,0.7629283),(625,24348,0.34227404),(626,2563,0.21127652),(626,8504,0.66619325),(626,12810,0.6862857),(626,15174,0.3532168),(626,28640,0.56205827),(626,29968,0.86132085),(626,31192,0.39836472),(627,22148,0.79859155),(627,27567,0.23917952),(628,4403,0.89543664),(628,12670,0.63250625),(628,14469,0.9477816),(628,16566,0.9967827),(628,25561,0.9242706),(629,15028,0.67420435),(629,21115,2.5532392e-3),(630,5515,0.6487891),(630,15418,0.23894013),(630,21021,0.88999325),(630,21464,0.15439102),(630,23248,5.328292e-2),(631,4619,0.73172),(631,20008,8.103308e-2),(631,27086,0.43906513),(632,17097,0.72853583),(632,22362,0.564374),(632,32394,0.7775639),(633,1706,7.475605e-2),(633,2836,0.15722921),(633,11515,0.10261556),(634,2560,0.26650295),(634,12578,0.506004),(634,15300,0.17387901),(634,17631,0.722991),(634,23526,0.543829),(634,30446,0.5663829),(636,5772,0.4355705),(636,10174,0.46309066),(636,12195,0.6059778),(636,25838,0.581092),(636,26662,0.5239879),(636,29846,0.7248482),(636,30963,2.8494092e-2),(637,2584,0.62441516),(637,16228,6.336283e-2),(637,20311,6.966834e-2),(638,9726,0.85170966),(638,9739,0.74284995),(638,9821,0.62862885),(638,12352,8.164472e-2),(638,29331,0.476957),(639,12750,0.9831171),(639,19857,0.8508203),(639,29062,0.1525335),(640,4906,0.40421626),(640,18021,5.962173e-2),(640,25716,0.9273083),(640,30142,0.23116879),(641,6292,3.3174533e-2),(641,21061,0.13128288),(641,23837,0.13255073),(642,23943,0.20809916),(642,26442,0.73146313),(642,32356,0.51906747),(643,7411,3.263026e-2),(643,13276,0.7298812),(644,10044,0.5345358),(644,12084,2.0491108e-2),(644,15294,0.6829682),(644,17653,0.8107795),(644,20150,0.30213884),(644,24284,0.21171667),(645,759,0.16390595),(645,1313,0.39451435),(645,1438,0.96059847),(645,9364,0.886651),(645,11577,0.48859692),(645,13882,0.21312812),(645,17593,0.3816279),(645,18564,0.69010913),(645,24870,0.14661701),(645,25611,0.8565833),(645,27370,0.82012165),(645,31272,0.8616726),(646,5802,0.39483172),(646,9960,0.503292),(646,11792,0.16084254),(646,12671,8.526041e-2),(646,22979,0.31826437),(647,2511,0.519703),(647,3021,0.85836613),(647,9001,0.167992),(647,10747,5.902182e-2),(647,17199,0.6980449),(647,32305,4.684809e-2),(648,12836,0.90727645),(648,19918,0.2331401),(648,21340,0.6082514),(648,29481,2.665817e-2),(648,30255,0.66698116),(649,1433,0.19359721),(649,17357,0.82667136),(649,19668,0.9350963),(649,19967,0.904062),(649,20959,0.7792471),(649,23394,0.5377804),(649,24098,0.36543345),(650,7531,0.8476275),(650,16468,0.7712612),(650,18470,0.6274946),(650,23197,0.5773491),(650,32681,0.7084429),(651,9598,0.842231),(651,10175,0.2726415),(652,22819,0.86785823),(653,2565,0.34256607),(653,7367,0.24976304),(653,12119,0.49689984),(653,12684,0.73431283),(653,14845,0.88628435),(653,15597,0.91354346),(653,28501,0.32140538),(654,12039,6.540129e-4),(654,15353,0.4025762),(655,15354,0.79560494),(655,21243,0.87672704),(655,31372,0.8175889),(656,3365,0.4213633),(656,7227,0.56277037),(656,30405,0.11077361),(657,8168,0.7664364),(657,12052,0.1377365),(657,14192,0.40982345),(658,10856,0.60928214),(658,11939,0.92656195),(658,22610,0.36695167),(658,27755,0.9935681),(659,19158,0.7452967),(659,23936,0.16055621),(660,723,0.6771194),(660,1417,0.6417099),(660,6144,0.42331204),(660,10916,0.9119224),(660,17718,0.72553486),(660,30787,0.42918244),(661,7689,2.8426202e-2),(661,8189,0.97800803),(661,17169,0.466846),(661,19480,0.5218146),(661,20796,0.41548467),(661,22011,0.93829054),(661,27130,0.5735949),(662,8822,0.26524535),(662,9718,5.5471048e-2),(662,11121,0.6677227),(662,12149,0.903231),(663,4010,4.0980868e-2),(663,4263,7.0588514e-2),(663,13632,0.19848989),(664,6547,0.14912502),(664,13490,0.46424118),(664,15667,0.66226053),(664,29853,0.58989125),(665,480,0.5704412),(665,5060,0.6751232),(665,7619,0.838635),(665,21199,0.80476654),(666,2455,1.7947016e-2),(666,2593,0.5414694),(666,5432,0.25768805),(666,18653,0.8232383),(666,21436,0.6872852),(666,32424,0.6461608),(667,211,0.19724843),(667,4706,0.23814163),(667,6906,0.30837148),(667,10593,0.36467698),(667,12380,0.5947967),(667,22769,0.7080932),(667,29233,4.4107176e-2),(668,2555,0.40015128),(668,9099,0.9317156),(668,11416,0.24776417),(668,16891,0.70851666),(668,27128,0.29009584),(669,2475,0.4109748),(669,4888,0.50218886),(669,10051,0.1570837),(669,27138,0.27770296),(669,30589,0.96379846),(670,5030,0.6571547),(670,7654,6.693569e-2),(670,9016,0.38357505),(670,18809,1.0941981e-2),(670,32228,0.711441),(671,14361,0.5316409),(671,24239,0.76763195),(671,30748,0.10837077),(671,30787,0.78357077),(671,31941,0.31261843),(672,250,0.7092578),(672,2073,0.634975),(672,4947,0.42394742),(672,8293,0.818991),(673,10394,0.4494925),(673,19558,2.7245456e-2),(673,21082,0.12212275),(673,29875,0.7082827),(673,30733,6.9226936e-2),(674,1431,0.59695053),(674,18504,0.55302835),(674,21849,0.1904727),(675,1656,0.27247915),(675,8506,0.34438032),(675,15773,1.4466485e-2),(675,28622,5.5672742e-2),(675,29185,0.10520273),(675,29820,0.95730865),(676,490,0.6656431),(676,2540,0.9529437),(676,4584,0.35850585),(677,11504,0.89856),(677,20304,0.29452354),(677,22070,0.11270625),(678,5400,8.083463e-2),(678,6490,0.19136994),(678,8514,0.15620561),(678,12507,0.42372468),(678,12836,7.055697e-2),(678,19807,0.35033226),(679,3369,0.26237863),(679,10729,0.37250012),(680,5123,0.66376853),(680,14145,0.14482935),(680,24533,0.4067479),(680,32214,0.91006166),(680,32694,5.648745e-2),(681,193,0.8838496),(681,14645,0.12337657),(681,17875,0.9347184),(681,19441,0.85284114),(682,1104,0.69545054),(682,6704,0.5927572),(682,26318,0.52518326),(682,27793,0.43406266),(682,31256,0.3482597),(683,278,0.72859824),(683,14558,0.7717946),(683,28044,0.20497325),(683,30788,0.6944899),(683,31997,0.64362913),(684,1486,0.15397842),(684,6655,0.9375578),(684,7704,6.437571e-2),(684,12820,0.51405257),(684,14317,0.44270924),(684,23120,0.13082653),(684,30195,0.97383964),(685,30524,0.2556155),(686,1267,0.67806244),(687,2734,0.21023303),(687,16011,0.95862037),(687,23549,0.15882438),(688,132,0.44464636),(688,2446,0.252864),(688,5557,0.6941305),(688,8839,0.6179385),(688,18232,0.47347385),(688,30838,0.2540779),(690,3338,0.30999377),(690,17276,5.8414456e-2),(690,20275,0.92813),(690,30929,0.26595038),(691,1521,0.99007845),(692,14522,0.972097),(692,17371,0.5051693),(693,10235,0.22480544),(694,9282,0.67597014),(694,13128,0.5654765),(694,15858,2.4926126e-2),(695,4860,0.6802134),(695,18228,0.23122005),(695,21765,0.1739049),(696,7231,0.7222034),(696,13370,0.5180813),(696,21860,0.6617097),(696,22185,0.73815),(696,26078,3.943104e-3),(697,9473,0.81167245),(697,21089,3.387403e-2),(698,3727,0.63234824),(698,15612,0.7590191),(698,16156,0.5486704),(699,2193,0.43090564),(699,4663,6.991743e-2),(699,15159,0.6476104),(699,20935,0.99257743),(700,3506,4.642663e-2),(700,6369,0.6386274),(700,30761,9.729599e-3),(701,3536,0.97862846),(701,8349,0.6958073),(701,22705,0.9386727),(701,26767,0.79158866),(702,9089,0.682667),(702,30142,0.65815264),(703,4948,0.630758),(703,6278,0.67804444),(703,7694,0.75857604),(703,19790,0.5903065),(703,25328,4.685396e-2),(704,1036,0.22906178),(704,4172,0.262789),(704,9136,0.1774735),(705,14426,0.7096382),(705,18383,0.48013872),(705,25098,0.3396053),(705,27942,0.33950225),(706,5166,0.45784554),(707,24526,0.74656796),(707,26826,0.99879885),(708,2352,0.60272115),(708,17399,0.98462635),(708,25500,0.9730675),(709,6151,0.8318443),(710,397,0.8642828),(710,17307,0.8454603),(710,22393,0.20955649),(710,26528,8.753591e-3),(710,28836,0.5854385),(711,28411,0.4846296),(712,7734,0.63456815),(712,10285,0.76203537),(712,10739,0.41445285),(712,11130,4.326112e-2),(713,10343,0.5421713),(713,12637,0.35714263),(713,16657,0.67585236),(713,24112,0.6150245),(714,14624,0.52785033),(714,30552,0.6700062),(715,1539,0.22780012),(715,17440,0.670059),(716,20065,0.65650874),(716,21554,0.38451186),(716,22478,0.646237),(716,24644,0.1676017),(716,25465,0.46917364),(716,26049,0.8739271),(716,31619,0.9667973),(717,1679,0.40105554),(717,9534,0.6921294),(717,10771,0.47155344),(717,11966,9.946433e-2),(717,18959,0.748507),(717,19275,4.9300697e-2),(717,26375,0.44172972),(718,13984,0.21882711),(718,17177,0.63833576),(718,28074,0.29559058),(720,380,0.12207668),(720,6111,0.9491995),(721,9422,0.5332302),(722,1683,0.4961547),(722,2589,0.4245263),(722,4022,0.26864952),(722,7743,0.5685581),(722,27032,0.25561184),(722,27528,0.7964863),(722,27890,0.70869696),(723,10970,7.666675e-2),(723,11199,0.57171303),(723,13148,0.7541575),(723,20419,0.8312797),(723,22864,0.6091039),(724,12194,0.9419488),(724,15702,0.6060427),(724,20818,0.7218474),(724,32407,0.5034004),(725,24459,0.6059195),(726,7669,0.711853),(726,8176,0.30429995),(726,11178,0.7314793),(726,25698,0.9694207),(726,25701,0.43604264),(726,31100,0.35789213),(727,19232,0.6857655),(727,25380,3.9113585e-2),(727,28759,0.17940821),(728,17864,0.7761365),(728,18630,0.8256125),(728,26660,0.2904626),(729,8808,0.9221087),(729,25575,0.28933835),(729,26315,0.5387083),(729,28526,0.71467423),(730,6016,0.21345343),(730,15552,0.7393247),(730,16567,0.5346267),(730,17955,5.5530187e-2),(731,187,2.6251478e-2),(731,4002,0.8635526),(731,21719,1.510388e-2),(731,26725,0.36464953),(731,32745,6.431312e-2),(732,3719,0.38815746),(732,31102,0.13022797),(733,9107,0.61545336),(733,15581,0.703167),(733,16447,0.20298545),(733,19374,0.6860897),(733,20334,0.77111953),(733,26088,1.0925175e-2),(733,31965,2.1709908e-2),(734,811,3.0337617e-2),(734,6861,0.9577159),(734,15994,0.5450396),(734,19607,0.8545023),(734,20113,0.9084293),(734,23094,0.29562053),(735,4542,0.9760886),(735,10310,1.1011509e-2),(735,20152,0.7454438),(736,1583,1.2690263e-3),(736,5041,0.24116431),(736,18994,0.14119048),(736,27881,0.11669037),(736,29351,0.73411715),(737,8129,0.3524667),(737,13368,0.625686),(737,15022,0.4036977),(737,23324,0.4069789),(737,23506,1.9506713e-2),(738,4500,8.574603e-2),(738,16814,0.36775506),(738,17166,7.84665e-2),(738,22100,0.42934608),(738,27428,0.13091254),(738,29449,0.9797324),(739,414,0.39277792),(739,1576,0.68494904),(739,14785,0.8758929),(739,21344,0.1915033),(739,30015,0.39471966),(740,558,0.29114395),(740,11261,0.38053292),(740,18859,5.9865203e-2),(741,1970,0.42385733),(741,10356,0.7164222),(741,10436,0.6167515),(741,18932,0.75559276),(742,23527,2.2352247e-2),(743,1925,0.45130646),(743,17117,0.1894116),(743,29344,0.38309488),(744,31822,0.6643593),(745,22609,7.4841835e-2),(746,11067,0.67851716),(746,26109,0.36666462),(747,21451,0.32784998),(748,9534,1.8657932e-2),(748,13248,6.897403e-2),(748,14705,0.9514343),(749,3411,0.35612684),(749,17346,0.59395266),(749,26853,0.66022074),(750,3078,0.6131058),(750,25026,0.7248152),(751,1862,0.67619354),(751,4454,0.8926974),(751,5892,0.9087292),(751,10870,0.55226684),(751,20607,0.13402216),(751,25085,0.79224837),(752,10629,0.50018555),(752,21753,0.9846286),(752,26647,0.81506217),(752,32344,0.9878858),(753,511,0.30443668),(753,4350,0.5465836),(753,6777,0.5692414),(753,20303,0.53369564),(753,21262,0.39316952),(753,27317,0.92910814),(753,27543,0.30199733),(754,12189,0.8368816),(754,18482,0.31240237),(754,18575,0.41712207),(754,27302,0.5111783),(755,23791,0.5108983),(755,27938,0.44981065),(756,14177,5.149661e-2),(756,14594,0.5390577),(756,15212,0.9441558),(756,19113,0.5160584),(756,23342,0.4937458),(756,32083,0.673434),(757,8596,0.7648048),(757,9766,0.32560354),(757,24846,0.3750101),(758,10695,0.14531642),(758,18326,0.9517376),(758,28239,0.3778447),(758,32571,0.62367547),(759,21222,0.22871599),(759,27424,0.17465179),(759,31400,0.7584995),(760,7910,0.44582814),(760,11414,0.7828403),(760,17342,0.886991),(760,28109,0.5175229),(761,22071,0.42565063),(762,3253,0.43719545),(762,12934,0.15332142),(762,24386,0.40282285),(763,7624,0.6594354),(763,14933,0.87666726),(763,16563,0.22081234),(764,12420,0.96741885),(764,13681,0.84503275),(764,22213,0.28316477),(764,25924,1.6380148e-2),(765,15275,0.2119153),(766,27074,0.4597503),(767,16356,1.8816974e-2),(767,17741,0.66059697),(767,22244,0.45518094),(767,30613,0.69599444),(768,10289,0.57237875),(768,17126,0.42630255),(768,24550,0.9978337),(768,28190,0.53045344),(769,7261,0.61616385),(769,27247,0.34266916),(770,4329,0.9263281),(770,15067,0.9848279),(770,15418,0.28914136),(771,1091,0.3169711),(771,10112,0.70233583),(772,163,0.89353454),(772,2591,0.3342402),(772,2902,0.23415002),(772,4015,0.3938676),(772,5110,0.53002113),(772,5236,0.43307424),(772,7067,0.38288105),(772,11045,0.6921868),(772,11230,0.975057),(772,19471,0.65834117),(772,31431,0.48602653),(773,7528,0.11175361),(773,12031,0.4569778),(773,18089,0.6376037),(773,19168,0.9713303),(773,19284,3.369067e-3),(773,26222,0.24352475),(773,26753,0.19265427),(773,28139,0.2826142),(774,14811,0.14502433),(775,5123,0.85613346),(775,6041,0.5696872),(775,29078,0.6719755),(776,5525,0.61113894),(776,6637,6.3596845e-2),(776,6864,0.9507107),(777,5838,6.312759e-2),(777,8962,0.14194024),(777,14070,0.58721584),(777,16642,0.4154477),(777,17002,0.16188212),(777,19985,0.2833487),(777,26480,0.57823503),(778,216,0.7304392),(778,1290,0.67059916),(778,11836,0.43294019),(778,13089,0.41249335),(778,17112,2.5741775e-2),(778,24059,0.7750812),(778,29424,0.8457745),(779,8385,0.289078),(779,13072,0.52517253),(779,16192,0.35033336),(779,21227,0.9483472),(779,26351,0.65691173),(779,30605,0.59715515),(780,896,0.3410517),(780,1035,0.47301385),(780,21304,0.15956868),(780,26494,0.6779779),(781,3455,0.36770356),(781,18529,0.73576385),(781,30423,0.50263953),(782,6809,0.1049661),(782,18791,0.99925333),(782,20522,0.40141317),(782,24455,0.24468887),(782,27905,0.6984586),(782,29278,5.0828658e-2),(782,29343,0.71174204),(783,30280,0.15344721),(784,6666,0.8097973),(784,9369,0.3978052),(784,11702,4.436232e-2),(784,21250,9.41467e-2),(784,21594,0.5777493),(784,22261,0.2739103),(784,23676,0.29129156),(785,246,0.99790174),(785,2010,0.87098515),(785,4305,0.1411903),(785,8260,0.84957814),(785,24572,0.9814419),(786,58,0.17324322),(786,2905,0.18461658),(786,5936,0.6573561),(786,8433,0.18140364),(786,24132,0.31717107),(787,4420,0.1498601),(787,10352,3.9440304e-2),(787,20118,0.79663587),(787,20439,0.3571552),(787,23173,0.8744358),(787,31384,0.37113315),(788,3125,9.368953e-3),(788,6086,0.5523628),(788,12998,0.13332175),(789,6604,0.5089784),(789,7817,0.8364808),(789,14416,0.4139083),(789,25392,0.8467975),(790,27078,0.31956816),(790,30800,0.15195173),(790,31470,0.9868902),(791,10654,0.14271194),(791,11933,0.322663),(791,23767,0.378367),(791,23944,0.8875146),(791,25110,0.25092494),(792,2374,0.5500341),(792,2813,0.2647576),(793,13926,0.6851708),(793,15305,0.6020157),(793,18658,0.1063067),(793,20986,6.721156e-2),(793,26254,0.598296),(793,32078,0.2607487),(794,1712,0.42816657),(794,2231,0.4761167),(794,14759,0.36791927),(794,20348,0.5334332),(794,26536,0.80245394),(794,27640,0.67510855),(794,31224,0.36426315),(795,21986,0.7688589),(795,22546,0.8441003),(796,912,0.7755563),(796,10094,0.38268155),(796,19120,0.95828944),(796,27714,6.70593e-2),(796,28203,0.7068857),(797,1477,0.5236038),(797,32716,0.20110315),(798,150,0.6094115),(798,855,0.15139453),(798,5552,0.36730832),(798,5888,0.6336639),(798,9933,0.8180859),(799,6563,9.8063156e-2),(799,13458,0.76813024),(799,14232,0.37821233),(799,17003,0.7935999),(799,17363,0.14479877),(799,18762,0.6643866),(799,21151,0.10490124),(799,24191,0.9885689),(799,26786,0.6058713),(799,31696,0.34087202),(800,7981,0.44151577),(800,23626,0.7182285),(800,29485,0.21691284),(801,5640,0.6786943),(801,13621,0.1848151),(801,28386,0.41309994),(802,468,0.29505086),(802,8945,0.17997631),(802,11988,0.897543),(802,23775,0.39247143),(802,29418,0.97696066),(802,31606,0.85893977),(802,32548,0.11853565),(803,1250,0.88585514),(803,19065,0.59013414),(804,17671,0.2562236),(804,20317,0.9202985),(804,22299,0.9531533),(804,31417,0.6729485),(805,32100,0.7027106),(806,5093,0.53665733),(806,10416,1.9390201e-2),(806,11513,0.7389556),(806,18485,0.98578167),(806,24792,5.9135772e-2),(806,24943,0.28106722),(806,26367,0.27855086),(807,24681,0.46336076),(808,5398,5.4725427e-2),(808,8029,0.16581538),(808,15996,2.496058e-2),(808,18978,0.25153962),(808,19719,0.5552711),(809,1045,0.8297988),(809,2209,0.864671),(809,2738,0.7055601),(809,4725,0.8494138),(809,4981,0.9827797),(809,13439,8.7583475e-2),(809,25515,0.15267934),(809,25783,0.68464595),(809,28782,0.85248744),(810,3334,0.8047993),(810,4456,0.8530012),(810,7270,7.937639e-2),(810,14814,9.7214326e-2),(810,19017,0.30635026),(811,6651,0.95657057),(811,10698,0.3487647),(811,12722,0.7983395),(811,13446,0.6768022),(811,17932,0.3931633),(812,5474,0.17629552),(812,18093,0.15742058),(812,20424,0.8941727),(812,27401,0.88166976),(813,489,0.8202968),(813,3772,0.9839047),(813,8925,0.6826377),(813,9925,2.3437398e-2),(813,10355,0.46107855),(813,15576,2.0720527e-2),(813,16525,0.34235755),(813,17407,0.6591478),(813,25102,0.5691539),(814,5837,0.27724364),(814,6532,0.8103865),(814,7897,0.70714027),(814,9353,0.491807),(814,18172,0.13415591),(816,3009,0.2661816),(816,3284,0.9597409),(816,17331,0.3683875),(816,32579,0.7227405),(817,6246,0.78819215),(818,1525,0.5243651),(818,7991,0.78184223),(818,11856,3.0879287e-2),(818,22930,0.48292318),(818,27369,0.4434582),(819,3326,0.8880403),(819,32649,0.6543043),(820,12868,3.770714e-2),(820,15621,0.64410615),(821,10382,0.7499378),(821,27974,0.58565235),(821,30911,0.26269606),(821,31361,0.36270654),(822,671,0.26379675),(822,2264,0.4514657),(822,3777,0.1367204),(822,4994,0.76212305),(822,17278,0.94340557),(822,25158,0.20383318),(822,28526,0.3334194),(823,4110,0.626369),(823,28330,0.8378421),(824,6725,0.124489225),(824,8932,7.582769e-2),(824,11031,0.20639423),(824,18313,0.8041993),(824,22643,0.1202895),(824,26156,0.8600845),(825,8419,0.5146442),(825,16255,0.7127214),(825,17464,0.8950558),(825,18372,0.46734953),(825,19686,8.214704e-2),(825,30095,0.8256055),(826,2870,0.6595211),(826,16606,0.78295296),(826,22695,0.86935735),(827,7255,0.25196397),(827,18171,0.7411858),(827,31947,0.5613703),(828,3011,0.7686926),(828,4541,0.9613409),(828,5027,0.85938984),(828,7542,0.9177659),(828,21174,0.25393242),(829,315,0.14910057),(829,361,0.18189207),(829,724,0.64181507),(829,1508,0.69925666),(829,1899,3.8359273e-2),(829,8898,4.2666767e-2),(829,11688,0.71488386),(829,22992,0.4485848),(829,29029,0.31404373),(830,9907,0.16852634),(830,16483,0.43977094),(830,20110,0.6876809),(831,4472,3.6352273e-2),(831,8531,0.17532556),(831,25949,0.45594108),(831,27877,0.43612042),(831,28590,0.27818406),(831,32331,0.7036522),(832,3170,3.471869e-2),(832,5149,0.75790155),(832,9702,0.5732527),(832,24299,0.33559918),(832,28816,0.41986713),(832,30496,0.6830837),(833,615,0.3187718),(833,1641,0.63678074),(833,6496,0.35163447),(833,13233,0.71047974),(833,19474,0.5341685),(833,19947,0.4066366),(833,24863,8.771561e-2),(834,7680,0.8198248),(834,15715,0.45996362),(835,1534,0.9504561),(835,25872,0.25598773),(836,545,0.20959915),(836,2124,0.8255445),(836,22011,9.754615e-2),(836,22309,0.62453294),(836,30886,0.5278821),(837,24464,0.6716416),(837,30254,0.87000424),(838,4988,0.41217396),(838,11920,0.39860263),(838,14059,0.2581205),(838,15026,0.92359674),(838,16859,0.60551184),(838,21812,0.12442859),(839,3511,0.13325915),(839,24407,0.7252364),(839,26223,0.56977385),(839,27945,0.59829247),(839,31921,8.773331e-2),(840,6720,0.68308437),(840,13639,0.12253082),(840,23828,0.44540513),(840,24208,0.67370486),(840,30721,0.5993827),(840,31789,0.48773846),(842,20347,0.92754483),(842,21875,0.2519225),(842,24619,0.15938908),(843,2903,0.6135919),(843,4557,0.30659798),(843,15845,0.81276983),(843,28779,0.330291),(843,31554,0.61004627),(844,30523,8.9630954e-2),(845,12240,0.81246233),(845,26262,0.7933816),(845,28512,0.4399967),(846,4307,0.43603683),(846,7494,0.25746703),(846,12267,0.38435486),(846,12583,0.78959423),(846,12762,0.22037815),(846,13479,0.1135274),(846,23127,9.811136e-2),(846,25656,0.3142459),(847,3324,0.9554224),(847,6468,0.40527803),(847,16883,0.1676129),(847,20398,0.58865225),(847,27804,0.78313106),(848,12178,0.9843383),(848,24841,0.45380527),(849,2773,0.5320765),(849,10324,0.43016693),(849,10458,0.5009047),(849,16154,9.385599e-2),(849,17473,0.298163),(849,26089,0.92000544),(849,30594,0.21913882),(850,22852,0.78557956),(851,1218,0.11577545),(851,3690,0.18583281),(851,16390,0.7905183),(851,19164,0.17806235),(851,21150,0.7699612),(851,27282,7.7519976e-2),(852,2586,0.4158143),(853,466,0.31251863),(853,7984,0.32426122),(853,11405,0.35217568),(853,20391,0.56348467),(853,22004,0.25895742),(854,1967,0.85884404),(854,23131,0.6397521),(854,31662,0.45544463),(855,7079,0.6783259),(855,8156,0.14370157),(855,17456,0.9738956),(856,9251,0.8801535),(856,25267,0.54026127),(856,25441,0.6795209),(856,26912,9.1897786e-2),(857,227,0.6377979),(857,6869,0.7628249),(857,23269,0.40408728),(858,4816,0.7821808),(858,4912,0.6201935),(858,10879,0.7477026),(858,19812,0.5299977),(858,24345,0.1257638),(858,28093,0.7392642),(859,10068,0.98685914),(859,12656,0.29278743),(859,12680,0.29232326),(859,13737,0.992522),(859,23194,6.1962537e-2),(859,24652,0.49619377),(859,29382,0.69118905),(860,1137,3.0346695e-2),(860,14639,0.4700768),(860,15885,0.43290994),(860,17994,0.21131155),(860,19362,0.6457044),(860,20640,0.9214528),(860,27025,0.29017672),(860,30416,0.7893054),(861,16907,0.39419752),(861,23368,0.117096156),(861,30130,0.86765635),(862,832,0.53292483),(862,933,0.8728427),(862,11294,0.8934874),(862,16451,0.82970506),(862,18416,2.6943114e-2),(862,20264,0.18903926),(862,31250,0.44431508),(863,3504,0.7383711),(863,6028,0.15735058),(863,10466,0.66971624),(863,24699,0.30386016),(864,12986,0.15611999),(864,28880,0.1566492),(865,7889,0.94170594),(865,13215,2.6910678e-2),(865,15086,0.6423655),(865,30611,0.56859297),(866,13741,0.13483447),(866,23980,0.58311856),(866,25333,0.83821386),(867,2675,0.5833032),(867,4920,0.96476024),(867,12987,0.6229721),(867,16882,0.37340906),(867,22115,0.81905025),(867,24310,0.3312075),(867,26315,0.6668557),(868,982,0.7815131),(868,18226,0.40434873),(868,19074,0.3622709),(869,1826,0.5294832),(869,7811,0.9533307),(870,10238,0.7507338),(870,16512,0.6276477),(870,16621,0.37488136),(870,20395,0.79729927),(870,31446,0.75403404),(871,6370,0.5750358),(871,12632,0.877153),(871,25023,0.9556969),(871,29410,0.14786775),(871,31421,1.6563032e-2),(871,32093,0.39672956),(872,15555,0.99378645),(872,32162,0.106882885),(873,649,0.65504116),(873,4507,0.34497085),(873,9798,0.84447414),(873,12221,6.972469e-2),(873,14685,0.51986825),(874,10845,0.92046624),(874,19091,0.3387248),(874,22189,8.116358e-2),(875,6016,1.720585e-2),(875,6699,7.8256756e-2),(875,9503,0.7642693),(875,10230,0.83055246),(875,10521,0.84042156),(875,11548,0.5570375),(875,15001,6.359066e-2),(875,17585,0.15373251),(875,19973,0.68193936),(875,22097,0.16588466),(875,32349,0.71953166),(876,183,0.855278),(876,5582,0.70512193),(876,11412,0.94727343),(877,3572,0.83940876),(877,14894,0.1351883),(877,20518,9.713795e-3),(877,22663,0.1450835),(877,25096,9.939848e-2),(878,7619,0.26812166),(878,9225,0.87246734),(878,25149,0.3882776),(879,7105,0.33632144),(879,10824,0.21858323),(879,16721,0.5331908),(880,4981,0.16251148),(880,20503,0.55009085),(881,3214,0.89137197),(881,7469,0.80853146),(881,9053,0.5149355),(881,12509,0.36510336),(881,13560,0.9101602),(882,20308,0.51616216),(882,24341,0.5375185),(882,32089,0.40653712),(883,9095,0.3984651),(883,14326,0.9026602),(883,19239,0.5879656),(883,20634,0.5396189),(883,24475,0.11069264),(883,27645,0.39161363),(884,9411,0.57002616),(884,10510,0.7616901),(884,13156,0.3560054),(884,13720,0.57701135),(884,23873,0.7445269),(884,26727,0.51268274),(885,14497,0.9172957),(885,17708,0.43161678),(885,25015,0.12881804),(885,29208,0.76698536),(886,16070,0.890367),(886,18763,5.743631e-2),(887,6531,0.9514152),(887,13766,0.4150755),(887,30169,0.3052218),(887,30398,0.5260433),(888,2241,0.6388676),(888,19864,3.416349e-2),(888,21832,0.62642455),(889,14556,0.26871666),(889,22325,0.7781515),(889,31690,0.9474978),(890,19862,0.5945212),(890,32650,0.36905214),(891,12866,0.33268395),(892,1244,0.2431124),(892,5819,0.32321563),(892,8803,0.48360625),(892,12222,0.6157351),(892,27180,0.83162135),(893,4582,0.2949274),(893,5277,0.7006141),(893,9309,0.19013004),(893,20762,0.85990435),(893,23175,0.6182789),(893,32228,0.23105985),(894,4417,0.23941258),(894,9547,0.84993905),(894,27474,0.9593111),(894,30151,0.17172186),(895,1153,0.1930243),(895,25638,0.24042787),(895,25748,0.43426517),(896,12434,1.3537314e-2),(896,14802,6.212051e-2),(896,31495,0.8445218),(897,16848,0.3646665),(897,17552,0.8665958),(897,27906,0.6070609),(898,3326,0.17484659),(898,6132,0.88793033),(898,17603,1.8244511e-3),(898,26501,4.770731e-2),(899,25752,0.84068996),(899,30883,0.3662359),(900,4991,6.1990153e-2),(900,8940,0.38084757),(900,14832,0.3905128),(900,26534,0.89497644),(900,29711,0.1141051),(901,5869,0.4724927),(901,8107,0.65373194),(902,718,0.24738087),(902,21684,0.503314),(902,22818,0.3361396),(903,9177,1.4068619e-3),(903,10916,0.77314985),(903,18200,0.24515839),(903,18552,0.61208594),(903,21617,0.7446908),(903,22651,0.9927699),(904,189,2.1762839e-4),(904,16238,2.5820078e-2),(904,19732,9.99204e-2),(905,7089,2.139701e-2),(905,26794,0.83816975),(906,905,0.498502),(906,6082,0.7037415),(906,7231,0.44355306),(906,9085,0.11497404),(906,17530,0.48371887),(906,23952,0.50550234),(906,30637,0.9066058),(907,6608,0.19810116),(907,14165,0.32887),(907,15295,0.17612597),(907,23499,0.66252726),(907,31021,0.8376028),(908,699,0.5076313),(908,5907,0.107339665),(908,8660,9.530235e-4),(908,13013,0.24008171),(908,17263,5.9288662e-2),(908,25089,0.9562161),(909,17331,0.6685594),(909,22442,0.24323952),(909,24568,0.6222837),(909,25160,0.33316958),(910,794,0.34518892),(910,6458,0.2214219),(910,12437,0.22641675),(910,12814,0.41784185),(910,17261,0.43134087),(910,20481,0.17520082),(910,27229,0.40578568),(911,8582,0.14581716),(911,11707,0.38163993),(911,11826,0.48700908),(911,22017,0.97440475),(911,22170,0.97169846),(911,24973,0.35401425),(911,29431,0.5896486),(911,30955,0.5185881),(911,30979,0.78110814),(912,13066,2.5565005e-3),(912,13989,0.4619758),(913,66,0.9388502),(913,5852,0.28972262),(914,7787,0.60584515),(914,17260,0.57489794),(915,1556,0.5485831),(915,4098,0.4619078),(915,16134,0.6201227),(916,939,0.48578975),(916,15495,8.13927e-2),(916,18091,0.4968684),(916,18115,0.89331675),(916,30389,0.6985095),(917,7323,0.9948453),(917,15048,7.006606e-2),(917,16418,0.7669188),(917,16799,0.42840198),(917,25824,7.245351e-2),(917,32142,0.10914949),(918,23380,0.70407873),(918,27827,0.3297737),(919,1306,0.43163687),(919,2259,0.46446142),(919,4667,0.80754596),(919,24488,0.71102905),(919,25854,0.16283697),(919,31815,0.37172607),(919,32069,0.9048406),(920,2992,0.5052686),(920,16010,0.31867003),(920,16638,0.34807384),(920,20131,0.79717565),(920,23406,0.7262463),(921,1537,0.9310048),(921,2900,0.5359253),(922,9493,0.29421365),(923,2282,0.17887779),(923,16385,0.3164052),(923,18042,0.80842036),(923,30061,0.15204225),(924,1585,0.5029139),(924,7434,0.63399965),(924,10231,0.44917795),(924,11921,0.9594572),(925,3404,0.82740927),(925,8902,0.11544697),(926,26483,0.31065187),(926,30198,5.2480914e-2),(927,3935,0.9350775),(927,9825,0.83568656),(927,14393,0.6253194),(927,16755,0.4104375),(927,28756,0.14761768),(928,3628,0.15397575),(928,10251,0.22944899),(928,13069,0.5401345),(928,13745,0.8977049),(928,30680,0.5966401),(929,9324,0.209119),(929,15134,3.0723765e-2),(929,27309,0.29367614),(930,1401,1.2303893e-2),(930,10999,0.7624831),(930,15727,0.27397537),(930,16808,0.6657052),(931,11431,0.8526049),(931,13797,0.2016126),(931,17635,0.65337354),(931,20678,0.7074773),(932,7812,9.5868014e-2),(932,10000,0.94939023),(932,11397,8.609691e-2),(932,14817,0.48569855),(932,26860,0.60509515),(933,4491,0.35027194),(933,10626,0.55910724),(933,14969,0.8634718),(933,16928,8.047217e-2),(933,20807,0.19164898),(933,22105,0.7901824),(933,23065,0.677993),(933,30381,0.782595),(934,2615,0.76079476),(934,6304,0.7813007),(934,14171,0.9637264),(934,27862,0.14052536),(935,5444,0.7891872),(935,17147,0.6726135),(935,21700,0.51912636),(935,23751,0.11387082),(935,27572,0.15363994),(935,30481,0.7735919),(935,32148,0.536774),(936,5962,0.52660257),(936,13560,0.17085579),(937,9237,0.8159648),(937,22299,0.24813427),(937,23565,0.7889242),(937,30665,0.7452624),(937,31933,0.34359297),(938,18143,0.80990124),(938,26864,0.29466456),(938,31478,0.85899),(939,2676,0.6324269),(939,3974,0.8008496),(939,10503,0.627085),(939,13526,0.55693835),(939,15511,0.33556625),(940,4647,0.20527047),(941,2526,0.6352571),(941,8674,0.7716014),(941,13287,0.2708612),(941,19994,7.018405e-2),(941,23198,0.1984006),(941,27454,1.2663562e-2),(941,27565,0.7026516),(942,5101,0.63196033),(942,7463,0.78286326),(942,13806,0.16129218),(942,16741,0.5572248),(942,31217,0.36714387),(943,12250,0.37660903),(943,12624,0.1940152),(943,19270,9.916498e-2),(943,23010,0.18000136),(944,27571,0.18354028),(944,30902,0.17963164),(945,7362,0.89254385),(945,8293,0.9941932),(945,9901,0.6248439),(945,22338,0.17055775),(945,25381,0.6271139),(946,5269,0.66970587),(946,11142,0.881304),(946,22984,0.66625667),(946,30034,0.25118208),(947,5964,8.119181e-2),(947,5975,0.3428274),(947,21358,0.8363909),(947,30097,0.97562903),(947,31519,0.3159882),(947,31821,0.10547826),(948,748,0.52729666),(948,8938,0.40956894),(948,20172,0.319221),(948,22931,0.14210756),(949,8351,0.81221837),(950,16069,0.8459567),(950,16905,0.3363133),(950,17582,0.75849336),(950,28831,0.7032993),(951,956,0.6870568),(951,25302,0.16712871),(951,29529,2.7903933e-2),(951,30237,0.7258651),(952,1309,0.71618056),(952,5103,0.6589022),(952,5305,0.10403802),(952,9343,0.33050427),(952,11288,0.9281576),(952,21313,0.5121499),(952,28171,0.291493),(953,2089,0.45465702),(953,8804,0.4027797),(953,15418,0.41789386),(953,26456,0.11030985),(954,10385,0.44167274),(954,10702,0.16042855),(954,15427,0.22401428),(955,22869,0.29530537),(955,31523,0.17318358),(956,1814,0.49170205),(956,15226,0.7519071),(956,24675,0.89003956),(957,6021,0.6488263),(957,8012,0.22997978),(957,17610,0.48857018),(957,26183,0.61931896),(958,12629,0.63625646),(958,13870,0.3569731),(958,17269,0.9808167),(958,18890,0.4882156),(958,24321,0.8641075),(958,24792,0.8652556),(958,26402,0.9536203),(959,887,0.4345851),(959,1082,3.718635e-2),(959,3921,0.67655295),(959,21201,0.80198985),(959,23348,6.603787e-2),(959,30143,0.64934635),(960,892,0.71247077),(960,5648,0.33255872),(960,26622,0.33073354),(960,27521,7.10625e-2),(960,28977,0.49920604),(960,29610,0.9708203),(961,7264,0.84244066),(961,8173,0.30877307),(961,8987,0.40419897),(961,17206,0.66539854),(961,19924,0.30613446),(961,20372,5.0628148e-2),(962,2345,0.93382764),(962,8479,0.6765446),(962,10466,0.7472246),(962,13381,0.13079792),(963,10919,0.37538227),(963,17904,0.9366964),(964,3149,0.43528664),(965,4213,0.85826504),(965,13877,0.45661533),(965,14030,0.61260647),(966,7952,2.9971741e-2),(966,9073,0.18919356),(966,12533,0.34595),(967,12629,0.46330887),(967,13302,0.90916944),(967,15850,0.64973164),(967,28284,0.55100554),(968,7415,0.7706972),(968,31780,0.51966804),(969,10761,0.31123072),(970,10357,0.60758555),(970,10393,0.96107215),(970,25936,0.34499905),(971,3061,0.8757253),(972,1937,0.562879),(972,14506,0.7236977),(972,26156,0.329895),(972,31072,0.26149592),(973,3040,0.9641524),(973,7251,0.31089863),(973,19020,0.47379974),(973,30195,0.214228),(974,5860,0.110630296),(974,14973,7.9374164e-2),(974,26666,0.15660098),(974,32657,0.34138486),(975,4763,0.108916126),(975,22507,0.59484667),(975,27104,0.91788834),(975,30876,0.5243267),(976,1893,0.85092336),(976,9608,0.20066968),(976,22169,0.31850275),(976,22858,0.9420439),(977,10736,0.9793954),(977,21790,0.8155895),(977,27932,0.51500994),(978,3119,0.9448129),(978,3520,0.4112725),(978,7429,0.62260437),(978,14074,0.23483104),(978,16630,0.9743527),(979,15536,0.2927689),(979,30824,0.46671364),(980,15015,0.8310803),(980,15847,0.5186544),(980,23681,0.12334812),(980,25484,0.4685365),(981,7166,0.2616731),(981,8052,7.67905e-2),(981,12741,0.45373133),(981,13003,0.5118239),(981,13415,1.9452771e-2),(981,23450,0.24718593),(981,27275,0.3048285),(981,31272,0.80473685),(982,5034,0.5766556),(982,7429,0.7855169),(982,11422,0.6151874),(982,30821,0.20359658),(982,32549,0.4807919),(983,3346,0.18176824),(983,6661,0.8580334),(983,13680,0.60254097),(983,17684,0.61900973),(983,20902,0.14901318),(983,30582,0.22809947),(983,31898,0.4913446),(984,909,0.35790548),(984,5603,0.16233402),(984,14808,0.22323044),(985,2816,0.39438415),(985,13543,7.201865e-2),(985,18695,0.887738),(985,25835,0.7069262),(985,28375,0.4483002),(986,3743,0.53318876),(986,5250,0.5286298),(986,11952,0.8158024),(986,16316,0.9020431),(986,18364,0.738214),(986,23211,0.8618069),(987,1289,0.7907156),(987,16402,0.25594676),(987,24592,0.6874075),(987,29670,0.87532413),(987,31332,0.36502656),(988,10098,0.83921796),(988,23620,0.6277356),(988,30557,9.1749765e-2),(989,1488,0.2423491),(989,9408,0.6628138),(989,13809,0.87803173),(989,28298,0.591188),(990,4494,7.793183e-2),(990,15092,0.634166),(990,26484,0.6844246),(990,29672,0.7855147),(990,32146,0.649001),(991,1393,0.2936072),(991,6212,0.9488988),(991,7238,0.9365203),(991,17264,0.5571771),(992,11587,0.8017818),(992,24946,0.3888314),(993,3997,0.20544536),(993,6334,0.8001889),(993,12029,0.62896323),(993,13022,0.53604335),(993,24787,0.1340597),(994,957,0.52639735),(995,7421,0.23900038),(995,13972,0.99994427),(995,30277,0.8137426),(996,7066,0.7929197),(996,12093,0.7188012),(996,18561,0.4033072),(996,24618,0.43519577),(996,25087,0.49823415),(996,29899,0.12213167),(997,3544,0.11808189),(998,7502,0.5537071),(998,9533,0.44280806),(998,24803,0.5991582),(999,11363,0.13980983),(999,17935,0.36675766),(999,25103,0.7648529),(1000,169,0.20704722),(1000,14856,0.56044906),(1000,30031,0.9460251),(1001,19133,0.9809987),(1002,25230,0.7660408),(1003,17242,0.5776368),(1003,18098,0.18642014),(1003,29174,0.31119454),(1004,39,0.32724306),(1004,1191,0.9841462),(1004,9216,6.8490446e-2),(1004,16808,0.3702687),(1005,13503,7.111311e-2),(1005,19855,0.70829463),(1005,29806,0.6424411),(1006,24494,0.47076255),(1006,30174,0.20679638),(1006,32348,0.3020954),(1007,1398,0.47828642),(1007,14315,0.17336127),(1007,19705,0.47780755),(1008,208,0.52705723),(1008,6028,0.5920001),(1008,9930,0.72111803),(1008,15574,0.27522197),(1008,15635,0.116907425),(1008,27727,0.2712372),(1010,3100,0.48683798),(1010,18519,0.2655764),(1010,29306,0.20832124),(1011,20546,0.13343619),(1011,22459,0.79556763),(1011,25046,0.883116),(1011,25244,0.5075713),(1012,1697,0.5203194),(1012,9766,0.42618522),(1012,15030,0.3925764),(1012,27412,0.1880554),(1012,28315,0.75263196),(1013,5292,0.56698525),(1013,7581,0.17931458),(1013,10676,0.8921964),(1013,29120,0.8920893),(1014,6592,0.23681489),(1014,14339,0.6606486),(1015,10814,0.5897634),(1015,12367,0.16068095),(1015,16344,0.9394363),(1016,19,0.97130585),(1016,2482,0.45739722),(1016,2563,0.8997038),(1016,15883,0.72418284),(1016,23472,0.634072),(1017,12609,0.5091218),(1017,15955,0.28020105),(1017,27330,0.60440576),(1017,32396,0.20921881),(1018,1180,0.39529252),(1018,2151,0.27186474),(1018,7718,0.4679352),(1018,8812,0.28671837),(1018,9365,0.24643792),(1018,13756,0.7835711),(1018,22572,0.14148709),(1018,32125,0.18145263),(1019,3029,0.822933),(1019,3767,8.986519e-3),(1019,10567,0.69587487),(1019,19084,0.5487782),(1019,30621,0.16382),(1020,14885,0.26793534),(1020,15991,0.9723419),(1020,18223,0.30341765),(1021,9540,5.9253756e-2),(1021,14991,0.11957451),(1021,22757,0.7178819),(1021,25842,0.30600697),(1022,11410,2.6356932e-2),(1022,12274,0.8252292),(1022,13749,0.16254951),(1022,14136,0.83709884),(1022,22672,0.15790917),(1023,6490,0.3096046),(1023,11329,0.61998135),(1023,15325,0.76130146),(1023,25518,0.6099868),(1023,32721,0.5874132),(1024,6196,0.56363904),(1024,16551,0.8062927),(1024,25062,0.5702583),(1024,26459,0.83561087),(1024,29510,0.8303919),(1024,31076,0.37024993),(1025,2501,0.44225594),(1025,4452,0.69011974),(1025,15414,0.37817544),(1025,27454,0.9482105),(1025,29651,0.30271283),(1026,46,5.5514444e-2),(1026,5117,0.33412656),(1026,20796,0.16627757),(1026,24192,0.84301543),(1027,2337,0.7312207),(1027,4076,0.41887173),(1027,5269,0.95937794),(1027,9718,0.9162928),(1027,11893,0.951512),(1027,17135,9.878451e-2),(1027,17726,0.7437308),(1027,20795,0.67803234),(1027,22249,0.8510459),(1027,27192,0.2520644),(1028,2101,0.9789899),(1028,18080,0.65873766),(1028,28253,0.24784788),(1029,17577,0.98110217),(1029,27393,0.349616),(1029,29584,0.57062227),(1030,1968,0.68221915),(1030,3054,0.33605018),(1030,3486,0.87791175),(1030,4463,0.39642197),(1030,18624,0.38917035),(1030,23484,0.3053538),(1031,1584,0.3699881),(1031,10895,0.6794538),(1031,18715,0.6924723),(1031,19682,6.643214e-2),(1031,24673,0.7247216),(1032,13551,0.68630177),(1032,17833,0.37506923),(1032,19097,0.84506524),(1032,19241,0.7194433),(1032,31193,1.2240224e-2),(1033,5042,0.86884284),(1033,9076,0.1177973),(1033,19499,0.15855457),(1033,23125,0.24041736),(1033,27794,0.9784149),(1034,6454,0.47915122),(1034,20733,0.1769974),(1034,22480,0.26628947),(1034,29702,0.6515094),(1035,499,0.6166104),(1035,3208,0.76145077),(1035,22431,0.5081949),(1035,24852,0.67691827),(1035,30703,0.8396477),(1036,19293,0.7833189),(1036,31368,0.17561534),(1037,6937,0.88307625),(1037,25367,0.57845545),(1037,28217,0.44789475),(1037,29228,0.7388163),(1038,3986,1.9934643e-3),(1038,7619,0.52037567),(1038,28936,0.11076325),(1038,30031,0.11168943),(1039,17083,0.7914664),(1040,8559,6.779404e-2),(1040,11289,0.5290956),(1040,18990,0.2388782),(1040,20058,0.7685922),(1040,25862,0.3600461),(1041,583,0.7684681),(1041,14809,0.113515496),(1041,15517,0.15962318),(1041,20902,0.7841876),(1041,24811,0.9187247),(1041,25715,0.68743086),(1041,28342,0.5048203),(1042,1623,0.5018506),(1042,5786,0.8983576),(1042,8523,0.79806286),(1042,20502,0.30603197),(1042,21208,5.2306153e-2),(1042,30929,0.31603518),(1042,31706,0.76175475),(1042,32729,0.94417024),(1043,8896,0.5330473),(1043,21941,3.6502674e-2),(1043,25535,0.30384612),(1044,17015,0.6730858),(1044,19483,0.7347195),(1044,25035,0.39910161),(1045,2233,0.4050669),(1045,11169,0.10454027),(1045,22546,6.9673285e-2),(1046,9894,0.60731226),(1046,10478,0.63553715),(1046,13224,6.9365986e-2),(1046,16732,0.81901217),(1046,16940,0.21134813),(1046,18804,0.22812635),(1047,9020,0.72380334),(1047,9771,0.4729573),(1047,20564,0.21976592),(1047,22300,0.5725868),(1047,27871,0.9520571),(1048,13379,0.9781228),(1048,26218,0.21885043),(1048,28797,0.19946572),(1049,8668,0.724611),(1049,18128,0.26831004),(1049,20505,0.56045413),(1049,24183,0.6984729),(1049,30466,0.7790133),(1049,30541,0.24010003),(1050,12447,0.2482592),(1050,16381,0.84489363),(1051,1633,0.979802),(1051,11641,0.6758586),(1051,14636,0.8844925),(1051,15316,0.57679296),(1051,20913,0.33483008),(1051,26730,0.91138536),(1051,27236,0.18672127),(1051,30560,0.89956045),(1052,202,0.72894156),(1052,5269,0.21496913),(1052,8075,0.99144375),(1052,30504,0.40589076),(1053,2562,0.45346692),(1053,10410,0.62947166),(1053,12932,0.73603827),(1053,15354,0.44843253),(1053,20942,0.2544441),(1053,26253,0.6480495),(1054,5081,0.50457424),(1054,10834,0.55265445),(1054,12833,0.6057746),(1054,22736,0.67305005),(1054,26037,0.60728693),(1055,5375,0.43880454),(1055,6119,0.1587049),(1056,20821,0.22030869),(1056,27171,0.8425657),(1056,28501,0.7152025),(1057,9686,6.9066666e-2),(1057,18158,0.11182113),(1058,1077,0.51976454),(1058,5832,0.24618608),(1058,21768,0.58864194),(1059,12021,0.69486004),(1059,12388,0.45783108),(1059,30634,0.24901272),(1059,31102,0.8506221),(1060,6125,0.9316416),(1060,26678,0.8300387),(1061,8658,0.24947986),(1061,11291,0.52072746),(1061,12465,0.23817115),(1061,14328,0.9455119),(1061,18505,0.9847676),(1062,10772,0.60403204),(1062,13635,0.41264272),(1062,19462,0.15856075),(1062,21087,1.967322e-3),(1062,26214,0.53150135),(1062,27184,0.592683),(1062,32690,1.5472919e-2),(1063,2067,0.26454377),(1063,4252,0.3135836),(1063,5397,0.522607),(1063,6204,0.9069213),(1063,7351,0.427721),(1063,18328,0.6627977),(1063,19496,0.4570943),(1064,6474,0.9206666),(1064,7051,0.3312419),(1064,17038,0.5938664),(1064,29471,0.2378929),(1065,8204,0.7043087),(1065,20087,8.743589e-2),(1065,21175,0.92222345),(1066,6198,0.23175602),(1066,15759,0.5578177),(1066,18200,0.88170004),(1066,24701,0.24858727),(1066,26481,0.5627521),(1067,805,0.99881035),(1067,2712,0.41731673),(1067,10357,0.10420875),(1067,11436,7.4661925e-2),(1067,28486,0.555953),(1068,9501,0.2086407),(1068,14493,0.9321271),(1068,24315,0.71443063),(1068,28293,0.80647033),(1069,632,8.176993e-2),(1070,12893,0.14109674),(1070,21782,0.30431405),(1070,28389,0.9795764),(1071,12678,0.95578974),(1071,13253,0.22939359),(1071,20864,0.16637698),(1071,21197,0.8899874),(1071,27192,0.28491607),(1071,29675,1.2261936e-3),(1071,29700,0.5766547),(1072,3793,0.35321662),(1072,6924,0.34391174),(1072,24650,0.14850278),(1073,12895,1.1436259e-3),(1073,17497,0.6363944),(1073,17689,0.33834904),(1073,20382,0.21853556),(1073,24198,7.538933e-3),(1073,31196,0.44000477),(1074,369,0.91876376),(1074,10023,0.33798003),(1074,12730,0.96057904),(1074,15261,7.045502e-2),(1075,545,0.6558641),(1075,5303,0.7380012),(1075,14748,0.27246553),(1076,2955,0.8670846),(1076,3590,0.29761273),(1076,9534,0.53971905),(1076,14023,0.76039886),(1076,26164,0.98797065),(1076,32335,0.7496478),(1077,515,0.6985919),(1077,1762,0.693139),(1077,1779,0.17023447),(1077,28039,3.075243e-2),(1078,10029,0.22827806),(1078,25690,0.506982),(1078,25898,0.47666162),(1079,29783,0.38464898),(1080,138,0.41695127),(1080,30099,0.49341843),(1080,32437,1.9911679e-2),(1081,8658,0.18566325),(1081,16796,0.51270837),(1081,17338,0.8108693),(1081,17469,0.18537982),(1081,31063,0.7171961),(1082,11464,0.97191554),(1082,12624,0.21789789),(1082,23533,0.95616376),(1082,27847,0.79920155),(1082,28270,0.77883327),(1083,1605,0.61031294),(1083,11181,0.7240652),(1083,32767,0.85151744),(1084,5471,0.9456534),(1084,5695,0.81673765),(1084,17333,1.4511619e-2),(1084,17811,0.33870694),(1084,29377,0.49740854),(1085,7867,0.9798993),(1085,17886,0.60389245),(1086,3022,0.73526484),(1086,13615,0.2321653),(1086,17258,0.2375205),(1086,17529,9.960554e-2),(1086,22296,0.9418841),(1086,26595,0.4382188),(1086,29029,0.70227987),(1087,13593,0.73498935),(1087,17544,0.71124345),(1087,18153,0.31443837),(1088,966,0.22267233),(1088,1412,0.7888923),(1088,5263,0.7116138),(1088,15235,0.2939819),(1088,31426,0.7174596),(1089,1571,0.6544134),(1089,20561,0.302002),(1089,21777,0.50425744),(1089,23069,0.6268159),(1090,2971,2.9349046e-2),(1090,14316,0.39274856),(1090,16958,2.901677e-2),(1090,29520,0.8613977),(1091,3557,7.347212e-2),(1091,16336,0.25630668),(1091,29209,0.4012469),(1092,20318,0.78183067),(1092,23490,0.31146288),(1092,24645,0.51206195),(1092,27792,0.51432616),(1093,13661,5.5849742e-2),(1093,14395,0.53089404),(1093,17091,0.8857853),(1093,17622,0.12806879),(1093,22856,0.46758828),(1093,31077,0.20127079),(1093,31129,0.48891392),(1094,4475,0.4182789),(1094,7737,0.8515005),(1094,15275,4.546353e-2),(1095,18388,0.43982098),(1095,20020,0.46093765),(1095,30142,0.61909294),(1095,30644,0.17831624),(1096,649,0.9871775),(1096,15408,0.21185824),(1097,3767,0.3580845),(1097,13732,0.7247694),(1097,22568,0.5396911),(1097,31808,0.20051228),(1098,3085,0.5180557),(1099,7115,0.9781515),(1099,19407,0.572622),(1099,23768,0.2616216),(1100,9290,0.23605545),(1100,9368,0.33298248),(1100,13321,0.55733633),(1100,30049,0.7338729),(1101,11574,0.719237),(1102,9913,0.40059176),(1102,19193,0.77198),(1102,20667,0.66743636),(1102,21685,0.4345922),(1102,23164,0.2501779),(1102,27087,0.972622),(1103,13986,0.49024042),(1103,14549,9.885397e-2),(1104,49,0.8780671),(1104,6440,0.99580944),(1104,10135,0.30499807),(1104,11664,0.4239809),(1104,14747,0.8434963),(1104,27348,0.3855494),(1104,29175,0.46928248),(1104,32009,0.32399005),(1105,1165,0.7152772),(1105,11440,0.50102574),(1106,7569,8.103071e-3),(1106,10095,0.38118893),(1106,16087,0.87473327),(1106,23408,0.13465318),(1106,32367,0.23806114),(1107,6863,4.1401472e-2),(1107,14397,0.34919485),(1108,142,0.6362387),(1108,1645,0.15581922),(1108,7583,0.27724132),(1108,9479,0.38102922),(1108,14014,0.32957923),(1108,20497,0.8260855),(1108,23939,0.93531096),(1108,29494,0.25178418),(1109,5353,0.5899319),(1109,10587,0.13337912),(1109,13439,5.6108885e-2),(1110,19263,0.34667584),(1110,32109,0.46759486),(1111,594,0.16461302),(1111,2919,0.48370966),(1111,9918,0.21530454),(1111,13620,0.28852037),(1111,19734,0.15847374),(1112,3994,0.18901),(1112,6793,0.4014878),(1112,8598,0.6175087),(1112,19645,0.578668),(1113,2280,0.6136903),(1113,3982,0.8967681),(1113,10504,0.23533483),(1113,12550,0.15109254),(1113,27123,0.95934725),(1113,28476,0.8031563),(1113,30638,0.9371334),(1114,782,0.20112827),(1114,1372,0.7747073),(1114,11067,0.48515338),(1114,15771,0.648796),(1114,23211,0.22101134),(1114,25516,0.45516652),(1114,32191,0.7814967),(1115,14188,0.67832017),(1116,427,0.13273573),(1116,13270,0.20737028),(1116,28972,0.65986514),(1117,1181,0.1646337),(1117,6310,0.1736826),(1117,10475,0.3405549),(1117,20044,0.9923728),(1118,5011,0.46969548),(1118,15357,1.6017783e-2),(1118,19328,0.101380095),(1119,287,0.9353333),(1119,3601,0.45171386),(1119,7804,1.4861904e-2),(1119,18904,0.5544931),(1119,22988,0.7236288),(1119,23435,0.40657973),(1119,28823,0.9829042),(1119,30409,0.15154807),(1120,11188,0.8577915),(1120,15461,0.46384382),(1120,19708,0.9393935),(1120,27823,0.14079757),(1121,1749,3.0271284e-2),(1121,9535,0.4476023),(1121,10269,0.60137546),(1121,17029,0.11809234),(1121,19426,0.77510905),(1121,25157,0.6743812),(1121,25627,0.4465442),(1121,32035,0.92966074),(1122,4053,0.49573055),(1122,5169,0.57414484),(1122,7201,0.38478506),(1122,8244,0.32308388),(1122,12716,9.977135e-2),(1122,12878,0.65815765),(1122,25180,0.2521952),(1123,9040,0.6329208),(1123,29546,0.47001627),(1124,16733,0.6201892),(1124,22389,0.6193139),(1124,26622,0.80686194),(1124,27979,0.9958852),(1124,29212,0.59248674),(1125,3683,0.25426322),(1125,4740,0.63357294),(1125,11569,0.90842855),(1126,4792,0.601021),(1126,5968,0.73660994),(1126,9189,0.2871198),(1126,23809,0.21051568),(1126,29642,0.5279131),(1126,30103,0.6209694),(1127,1826,0.7000982),(1127,11430,0.40725783),(1127,14353,0.44981053),(1128,1792,0.13221306),(1128,3264,0.61888075),(1128,3939,0.9238762),(1128,7399,4.331593e-3),(1128,15098,4.0425556e-3),(1128,21865,0.3453712),(1128,27122,0.7898642),(1129,6458,0.72089916),(1129,8263,5.2387647e-2),(1129,27725,4.5295436e-2),(1130,6662,0.20824197),(1130,11535,0.9294914),(1130,11970,7.831524e-5),(1130,15150,0.29783696),(1130,19683,0.44586942),(1130,31242,0.98166174),(1130,31686,0.5132731),(1131,2623,0.67166936),(1131,7262,1.1904371e-2),(1131,14240,0.35451195),(1131,15969,0.3971968),(1131,23017,0.803149),(1131,28522,5.377862e-2),(1132,13355,0.40027636),(1132,19316,0.15417095),(1132,23309,0.9473007),(1132,31341,0.7408307),(1133,4474,0.22823094),(1133,5236,0.46825123),(1133,15190,0.1943373),(1133,17119,0.42365316),(1133,17631,0.29212636),(1133,22649,0.8026511),(1133,32374,0.5460929),(1134,1304,0.8420006),(1134,9555,0.10541718),(1134,10962,0.6395356),(1134,11348,0.24478185),(1134,13161,0.41272208),(1134,17510,0.20478237),(1134,20661,0.5530654),(1134,21538,0.75306267),(1134,22203,0.6594414),(1135,4308,0.2758084),(1135,7498,0.5397206),(1135,10590,0.9243168),(1135,13200,0.17134775),(1135,20212,0.6669605),(1135,21057,6.554768e-2),(1135,22025,0.35972372),(1135,32122,0.66316193),(1136,6457,0.77371097),(1136,13718,0.4385246),(1136,23864,0.18539874),(1136,25232,0.42760032),(1137,1099,3.3639498e-2),(1137,9828,0.8388905),(1137,11939,0.2752358),(1137,12653,0.62159973),(1137,14635,0.32196698),(1137,21030,0.80751264),(1137,24564,0.8023817),(1137,31262,0.16986808),(1138,7138,0.29863507),(1138,32269,0.2793094),(1139,1903,0.96993697),(1139,2919,0.8501389),(1139,5524,0.23962572),(1139,8400,0.39964053),(1139,8781,0.78850734),(1139,9290,0.28640702),(1139,11562,0.93199897),(1139,28255,0.16384639),(1139,32759,3.841787e-2),(1140,425,0.66265726),(1140,7675,0.44294822),(1140,11357,0.6418548),(1141,2398,0.56157756),(1141,7355,0.6466799),(1141,13110,0.98712105),(1142,10220,0.3636777),(1142,20763,0.12188766),(1142,28183,0.14875507),(1143,3894,0.15458632),(1143,25149,0.89253515),(1143,29874,0.23360376),(1144,6463,0.3112475),(1144,17408,0.54243046),(1145,15364,0.39774862),(1145,23418,0.12742),(1146,5906,0.7167905),(1146,11109,0.93244237),(1146,11673,0.41248134),(1146,13147,0.838452),(1146,13776,0.3569319),(1147,3272,0.85127413),(1147,13839,0.22262459),(1147,22120,0.67838496),(1148,3974,0.87080014),(1148,16636,0.7964247),(1148,20003,0.22541516),(1148,23899,0.36357397),(1148,26317,0.90186197),(1148,32314,0.11388031),(1149,4706,0.27322245),(1149,24047,0.84830636),(1149,27627,0.2499839),(1150,8437,6.286855e-2),(1150,9509,0.8810525),(1150,16855,0.6809572),(1150,25406,0.38365203),(1151,19396,0.5209487),(1151,29853,0.572224),(1152,519,0.3800498),(1152,16680,0.4333718),(1153,2646,0.8881509),(1153,4082,0.5927562),(1153,6338,0.44427615),(1153,13043,0.34416938),(1153,24932,0.20528683),(1153,25333,0.2349589),(1153,31100,0.7719291),(1154,24587,0.40698743),(1155,3838,0.14176565),(1155,19669,0.9329511),(1155,22756,0.9570559),(1155,28731,0.6239638),(1155,29307,0.34358382),(1156,1878,0.55385655),(1156,10236,5.261165e-2),(1156,19593,0.16945879),(1156,20972,0.2438717),(1156,22395,0.99978036),(1156,24142,0.88820827),(1156,24172,0.5297467),(1157,12775,0.85725695),(1157,20887,0.6267342),(1157,28707,0.3786947),(1158,6778,1.5258449e-2),(1158,27462,0.5705558),(1159,13255,0.8496399),(1159,22278,0.45351544),(1159,25090,0.61221695),(1159,26402,0.9434218),(1159,29158,0.17559342),(1159,30953,0.11003103),(1160,10603,0.37042695),(1160,16190,0.20970976),(1160,20517,0.3232709),(1160,24154,0.9161175),(1160,29657,0.30845976),(1161,10419,0.9494403),(1161,14066,0.82218623),(1161,14861,0.7348283),(1162,5176,0.29406625),(1162,8946,6.3509725e-2),(1162,10091,0.74109155),(1163,5720,0.770894),(1163,16305,0.3790669),(1163,19699,9.2273235e-2),(1164,22319,0.34191853),(1164,26555,4.5972407e-2),(1164,31408,0.7244459),(1165,19557,0.24803136),(1165,20160,0.5666854),(1165,24255,0.7539001),(1166,6777,0.2873819),(1166,19451,0.5884282),(1166,19859,0.9517168),(1167,68,0.17620665),(1167,3135,0.7457916),(1167,10771,0.18049991),(1167,23191,0.12875442),(1167,25225,6.197529e-2),(1167,26026,0.8885946),(1167,27781,0.5653491),(1167,30530,0.24421364),(1167,31039,0.52104473),(1168,11912,0.78022164),(1168,12119,0.45998627),(1169,12295,0.96556675),(1169,23086,0.24869868),(1169,25768,0.87803525),(1169,28469,0.4733165),(1170,9068,0.33713675),(1170,22363,0.22542535),(1171,5428,0.5508733),(1172,6966,0.72077817),(1172,8327,8.887626e-2),(1172,8639,0.7593393),(1172,15996,0.46442005),(1172,18643,0.21443307),(1172,23788,0.36910012),(1172,29770,0.3995078),(1173,5896,0.53102446),(1173,8619,0.319525),(1173,8662,0.6625138),(1173,14539,0.5050307),(1173,16349,0.89778495),(1173,18507,0.26821837),(1173,25449,0.33294475),(1174,3970,0.11762854),(1174,7519,0.92102456),(1174,7967,0.38877255),(1174,9190,0.9060921),(1175,23729,0.1359025),(1176,11604,0.8878632),(1176,14666,0.13235642),(1176,21015,0.5778334),(1176,22981,0.20117326),(1176,30048,0.31859866),(1177,15115,0.8641798),(1177,17663,6.267902e-2),(1177,30659,0.17645097),(1178,4018,0.20857245),(1178,6743,0.96140206),(1178,9353,0.50030476),(1178,9617,0.6540274),(1178,25546,0.6916966),(1179,300,0.7687267),(1179,21227,0.12231568),(1179,22856,0.95988095),(1179,25193,0.28959084),(1179,27445,0.52807164),(1179,28047,0.26182574),(1180,1139,0.25570005),(1180,2676,0.94781226),(1180,29355,0.38376713),(1180,30923,0.7641059),(1180,32491,7.082678e-2),(1181,5966,0.7906706),(1181,25434,0.6908499),(1181,29201,0.9996818),(1182,16567,0.7782811),(1182,29655,0.7876846),(1183,5590,0.5260033),(1183,5834,0.836052),(1183,7367,0.8290134),(1183,11122,0.89035064),(1183,16945,0.32561177),(1184,9092,0.7751463),(1184,17838,0.32357895),(1184,25979,2.9828185e-2),(1184,28621,0.254641),(1184,30603,0.7280755),(1184,31726,0.3653622),(1185,1315,0.9841829),(1185,11606,0.8814812),(1185,14132,0.73558253),(1185,18959,0.50810397),(1186,6806,0.90531796),(1186,14470,6.075116e-2),(1186,14485,0.74247265),(1186,23344,0.42624357),(1187,24673,4.6177767e-3),(1188,15676,0.7641623),(1188,17774,0.40341076),(1189,30148,0.3015258),(1189,32544,0.114376575),(1191,25354,0.12029864),(1192,16200,0.33823895),(1192,18719,0.84836817),(1193,1446,0.40352497),(1193,4275,0.13456632),(1193,4549,0.47090507),(1193,5492,0.71457154),(1193,13279,0.4499374),(1193,13388,7.169288e-2),(1194,4506,0.94620234),(1194,8132,0.27418226),(1194,24453,6.194028e-3),(1195,10636,0.680265),(1195,29226,0.28758097),(1196,12393,0.6171058),(1196,13628,0.5310886),(1196,14146,0.4067469),(1196,14197,0.72906),(1196,25927,0.16064063),(1197,14390,2.7404811e-2),(1197,17574,1.7057344e-2),(1197,19898,0.8123704),(1197,30037,0.7529312),(1198,8605,0.64070916),(1198,8759,0.9139071),(1199,12337,0.38360396),(1200,7023,0.19468164),(1200,15693,0.45891032),(1200,21585,0.38610142),(1200,26347,0.54473054),(1200,29576,0.9087671),(1201,704,0.14087875),(1201,776,0.96856),(1201,9683,0.98100543),(1201,15182,0.5267096),(1202,15284,0.26770383),(1202,20571,2.6962453e-2),(1203,5471,0.481018),(1203,17880,3.2013062e-2),(1203,18805,0.70428),(1204,4129,0.1620132),(1204,9641,0.22610523),(1204,10659,2.5071153e-2),(1204,10844,0.7885342),(1204,15290,0.36752936),(1204,27044,0.33081424),(1204,29853,0.3241074),(1204,29883,0.44704568),(1205,23057,0.7458075),(1206,12472,0.42248377),(1206,24048,8.910883e-2),(1206,30214,0.7703146),(1206,31612,0.46023896),(1207,4007,0.7989372),(1207,4961,0.7473781),(1207,19731,0.6834596),(1207,28036,5.3962395e-2),(1207,30233,0.9588136),(1208,2223,0.24609642),(1208,5666,0.81949943),(1208,5750,5.63432e-2),(1208,17987,0.27340162),(1208,22578,0.68855476),(1208,31853,0.45220703),(1209,1503,0.9183486),(1209,7356,7.428799e-2),(1209,7754,0.79338145),(1209,9328,0.8979994),(1209,11776,0.75116384),(1209,12790,0.82923454),(1209,16622,0.2658487),(1209,18775,0.37671304),(1209,18924,0.85992396),(1209,20303,0.112243816),(1210,6381,0.73095393),(1210,6896,0.91052103),(1210,13252,0.7847756),(1210,16771,0.6416763),(1211,2404,0.2332281),(1211,28598,0.94793946),(1211,30192,0.6082294),(1212,5561,0.7961686),(1212,9753,2.3707317e-2),(1213,1183,0.55670345),(1213,15149,0.49865255),(1213,22526,0.4044203),(1214,17535,0.5912585),(1214,18408,0.24684496),(1214,32617,0.87782866),(1215,28277,0.8671567),(1216,2526,0.1853487),(1216,15632,0.8364644),(1216,18561,0.11132481),(1216,20525,0.70888937),(1216,23793,0.21168874),(1216,25822,0.38999057),(1216,29176,0.38222983),(1217,5962,0.62105644),(1217,8796,0.1656427),(1217,14798,0.33157888),(1217,19716,0.2280126),(1217,22807,0.29474545),(1218,1380,0.43675822),(1218,3207,0.16288029),(1218,8810,0.9110818),(1218,17721,5.5714633e-2),(1218,23840,0.53703475),(1218,29736,0.5021153),(1219,1911,5.757871e-3),(1219,2400,0.64429104),(1219,3267,0.45293),(1219,17054,0.28067347),(1220,10674,0.1607635),(1220,10702,0.9603885),(1220,11958,0.69121027),(1220,14274,0.92969346),(1221,2525,0.13838418),(1221,11671,8.768692e-2),(1221,15754,0.12788172),(1221,21593,0.73635876),(1221,30936,0.6545427),(1222,2373,0.30068606),(1222,3529,0.91545033),(1222,10341,0.31463185),(1222,21284,9.717871e-2),(1223,1357,2.8312989e-3),(1223,5905,0.27997705),(1223,20363,8.8388935e-2),(1223,25088,0.1408003),(1223,28717,0.35491952),(1224,14713,0.8289246),(1225,21369,0.7149759),(1225,23971,0.58625096),(1225,32645,0.66985106),(1226,2570,0.443575),(1226,22057,0.68330026),(1226,25179,0.8999495),(1226,29920,0.4883025),(1227,1422,0.6296019),(1227,22623,0.85195625),(1227,26657,0.4928732),(1228,7868,4.039155e-2),(1228,32595,0.8470033),(1229,4175,0.33941302),(1229,15022,0.14777756),(1229,22372,0.36265936),(1229,25545,0.22892432),(1229,26967,0.73546004),(1229,31786,7.964607e-2),(1231,6642,0.34745106),(1231,10965,6.2485263e-2),(1231,19265,0.58740777),(1231,21683,3.7367847e-2),(1231,26364,0.5473693),(1232,4457,8.788411e-2),(1232,6676,0.31453997),(1232,12883,0.70069826),(1232,15534,0.6569429),(1232,29156,0.50314504),(1233,1756,0.5228091),(1233,5125,0.37954465),(1233,10775,0.27814084),(1233,22506,0.83255565),(1233,27192,0.7287857),(1234,11412,0.898372),(1234,31584,0.12441937),(1235,2062,0.1534142),(1235,13278,0.17035943),(1235,14018,0.7080268),(1235,16294,0.8342193),(1237,11995,0.403565),(1237,18737,0.19917387),(1237,26189,0.98931646),(1237,31013,0.63601),(1237,31344,0.9187754),(1238,4260,0.51396686),(1239,5725,0.92265916),(1239,6409,0.780777),(1239,10652,0.7709211),(1239,30131,0.35740617),(1240,6429,0.3556436),(1240,18042,0.14596988),(1240,19755,0.32197657),(1240,25957,0.11817448),(1241,2342,0.4630922),(1241,4640,7.2930634e-2),(1241,5722,0.82593703),(1241,14492,0.43578097),(1241,17256,0.6469859),(1241,20795,9.84475e-2),(1241,22220,0.2441054),(1241,26682,0.74686617),(1241,29842,0.15969685),(1241,30671,0.41492602),(1242,7529,0.12532201),(1242,9673,6.5331765e-2),(1242,11755,0.19114734),(1242,16014,0.65550107),(1242,20146,0.2854493),(1242,21692,0.9845726),(1242,26819,0.41097552),(1242,31694,0.22338866),(1243,7495,0.389795),(1243,13491,0.7626204),(1243,15720,0.70780694),(1243,23726,0.6391913),(1243,30264,0.17984208),(1244,3000,0.23642246),(1244,10915,0.9285651),(1244,26651,0.3428425),(1245,8377,0.123274274),(1246,10263,0.5865372),(1246,11475,0.4272689),(1246,11485,0.5428633),(1246,17139,0.6049576),(1246,27315,0.61202925),(1246,27885,8.975456e-2),(1247,10283,0.13594458),(1247,25987,0.74239755),(1247,30473,0.5216411),(1248,2732,0.3342172),(1248,5471,6.2366482e-2),(1248,24190,0.5244797),(1248,29938,0.19226304),(1249,10778,0.8178035),(1249,18099,0.48370805),(1249,19827,5.8427207e-2),(1249,20042,0.65685135),(1249,29217,0.7112754),(1249,30704,0.6070181),(1249,31205,0.6669399),(1250,27534,0.45365387),(1251,3057,0.25581914),(1251,15892,0.3886123),(1251,16046,0.177216),(1251,19416,0.8457901),(1251,27603,0.3961622),(1251,28050,0.13167386),(1252,12160,0.3437383),(1252,12689,0.40157518),(1252,21016,0.98244464),(1252,26847,0.86427695),(1252,30009,0.20592579),(1252,32464,0.5206623),(1253,51,0.79353493),(1253,9154,0.7124068),(1253,20704,0.121469304),(1253,24709,0.71916854),(1254,3999,0.43297613),(1254,6793,0.50105107),(1254,8844,0.46266332),(1254,13615,0.97714233),(1254,15914,0.9736838),(1254,17140,3.4198659e-3),(1255,4758,0.86555743),(1255,13819,9.345842e-2),(1255,18619,0.8435811),(1255,27124,5.1853154e-2),(1255,27461,9.409636e-2),(1255,29226,0.54735863),(1256,10666,0.6436008),(1256,13760,0.12647577),(1256,13845,0.4331423),(1256,20018,0.36682442),(1256,21346,0.3217092),(1256,22053,0.34098274),(1256,30751,0.12903054),(1257,2596,3.0524371e-2),(1257,4630,0.6864989),(1257,14061,0.37541124),(1257,23067,1.39566185e-2),(1257,23091,0.11377601),(1257,24323,0.35696945),(1257,27692,0.26951882),(1258,9664,0.2639514),(1258,14608,0.7463438),(1258,19907,0.86278635),(1259,18777,0.57023674),(1259,20898,0.17780228),(1260,11911,0.88287103),(1260,18037,2.3489213e-2),(1260,25911,0.66787267),(1260,28547,0.6774153),(1261,16506,0.9131366),(1262,12347,0.7437552),(1262,32571,0.52284473),(1263,5760,0.914316),(1263,7592,0.42768306),(1263,25320,0.8159475),(1264,3761,0.47737014),(1264,8636,0.114042416),(1264,15313,0.74160624),(1264,15724,0.60983133),(1264,26501,9.318041e-2),(1264,29760,0.49126792),(1265,1338,0.71640855),(1265,25024,0.8373683),(1265,32317,0.8847299),(1266,8942,0.31220594),(1266,10087,0.17113438),(1266,20460,0.50005406),(1266,20613,0.6625589),(1266,21611,0.5277049),(1266,23799,0.48902944),(1267,3252,2.8358582e-2),(1267,8755,0.38269907),(1267,12708,0.62072754),(1267,13778,0.4748152),(1267,29233,0.684248),(1268,599,0.17749244),(1268,18473,0.37154946),(1268,18607,0.4321526),(1269,11407,0.5825676),(1269,13073,0.44411603),(1269,15608,0.99616116),(1269,17219,0.9088588),(1269,21697,0.63782436),(1270,16381,0.47594604),(1271,3276,0.45188156),(1271,5398,0.9011343),(1271,23975,8.778265e-2),(1271,27383,0.47596863),(1272,1731,0.38944876),(1273,11101,0.24251378),(1273,19584,0.96902287),(1273,23217,0.566059),(1274,10283,0.9857458),(1275,10241,0.15528247),(1275,10511,0.61962116),(1275,12832,0.42348164),(1275,22621,0.80067974),(1275,22882,0.6797029),(1275,30847,0.4858959),(1276,1086,0.15329534),(1276,4350,0.5152055),(1276,20161,0.7911261),(1276,20512,0.8416225),(1277,22032,0.7082993),(1277,27229,0.8905667),(1277,27556,0.71702105),(1278,1984,0.58988774),(1278,6853,0.6471479),(1278,30533,0.46916687),(1279,2794,0.50697476),(1279,2836,0.42326573),(1279,6039,0.59802574),(1279,6292,0.28762266),(1279,9489,0.5450656),(1280,9179,0.52759516),(1280,10890,0.96278864),(1280,27214,0.43242687),(1281,400,0.71586776),(1281,4889,0.24803106),(1281,5646,0.59608847),(1281,15868,0.78256065),(1282,274,0.41562048),(1282,1635,0.5298246),(1282,14564,0.6570023),(1282,27359,0.8700935),(1283,582,0.1791965),(1283,1034,0.77580214),(1283,16660,0.8721493),(1283,28505,0.108147174),(1284,3739,0.45029598),(1285,5837,0.5895152),(1285,20070,0.65837365),(1286,25795,0.24363153),(1287,19822,0.9797312),(1287,23575,0.5420741),(1287,27960,0.98563),(1288,2443,1.3305786e-2),(1288,27215,0.44146672),(1288,27678,0.4654077),(1289,14015,0.7057682),(1289,18291,0.90740544),(1289,27700,0.8419435),(1289,29735,0.20141627),(1290,6023,0.5230243),(1290,24675,0.81320435),(1290,31704,0.29830256),(1291,6140,0.18234237),(1291,8642,0.7853376),(1291,16022,0.6061248),(1291,24582,0.90831625),(1292,7761,6.169701e-2),(1292,9099,0.78232193),(1292,14162,0.42434317),(1292,28396,0.25456935),(1292,28589,1.7201114e-2),(1292,29440,0.74986064),(1293,1525,0.7419762),(1293,2376,0.2637361),(1293,15207,0.3914182),(1293,23985,0.5046235),(1293,25882,0.515937),(1293,29194,0.63065803),(1294,2865,0.75058144),(1294,3199,3.507472e-2),(1294,21056,0.89430654),(1294,21748,0.2695984),(1294,24755,0.64819396),(1294,28867,0.9163253),(1294,29962,0.56814754),(1294,30927,0.8695423),(1294,32752,0.19081958),(1295,13417,0.98276293),(1295,20349,0.6593679),(1295,24180,0.4551613),(1295,28355,0.61797714),(1295,28420,0.16024294),(1296,15895,0.7792926),(1296,21268,0.5021291),(1296,26270,0.74730587),(1296,28718,0.31870037),(1297,3033,0.6321578),(1297,18762,0.20738275),(1297,21114,0.8581587),(1297,21274,0.78566647),(1297,21343,0.7157014),(1297,31302,0.94614553),(1298,12771,0.3521168),(1298,13393,0.71436816),(1298,20446,0.24921924),(1298,23107,0.8283787),(1299,25782,0.9081198),(1300,3698,0.7815057),(1300,7022,0.81276953),(1300,21113,0.5503103),(1300,22888,6.7255415e-2),(1300,32583,0.75999147),(1301,510,0.4952665),(1301,16740,0.81407434),(1301,22478,0.34416136),(1301,32279,0.66575885),(1302,3950,0.47388208),(1302,27939,7.128429e-2),(1303,11032,0.9323773),(1303,22929,0.39461756),(1304,6292,0.43738672),(1304,9865,0.6152599),(1304,13113,0.18265812),(1304,18550,0.5108073),(1304,22418,0.9770324),(1304,26492,1.8018516e-2),(1304,27944,0.24349794),(1304,28218,0.7876068),(1305,3629,0.45115364),(1305,21902,0.79038775),(1306,11505,0.29677948),(1306,27221,0.71418107),(1307,4607,0.83613545),(1307,6510,0.42688134),(1307,12552,0.70323557),(1307,13588,0.32828334),(1307,28089,0.96981364),(1307,28303,0.45086634),(1307,31384,0.4917521),(1308,5664,4.5408446e-2),(1308,7068,0.8168371),(1308,14676,0.31849962),(1308,16507,4.044898e-2),(1308,22972,0.3770516),(1308,31589,0.8814634),(1309,533,0.20904881),(1309,7316,0.22704984),(1309,11251,0.7285431),(1309,15080,0.40230396),(1310,7369,0.9280523),(1310,11032,0.120297104),(1310,12654,0.4139785),(1310,18327,0.3710519),(1310,21480,0.27793068),(1310,21675,0.9514366),(1310,24732,0.6815078),(1310,24924,6.602432e-2),(1311,358,0.6062873),(1311,30260,0.10033471),(1312,23324,0.7419508),(1312,23758,0.91228414),(1313,1585,0.75865436),(1313,7960,0.646533),(1313,8161,0.56252193),(1313,8694,2.3650813e-3),(1313,11329,1.3911047e-2),(1313,15555,0.7461354),(1313,21262,0.8474578),(1314,612,0.22863565),(1314,9440,0.64547443),(1314,16579,0.385593),(1314,26075,0.97176903),(1315,1616,0.335382),(1315,7201,1.9614369e-2),(1315,20342,0.26499513),(1316,3342,0.87353814),(1316,12693,0.44318753),(1316,14335,0.24617594),(1316,21670,0.38896784),(1316,29024,0.10971153),(1316,30602,0.21861887),(1317,14290,0.50013137),(1317,20334,0.6285887),(1317,20934,0.9424625),(1317,22549,3.727428e-2),(1317,25287,0.7118475),(1317,28089,0.8876856),(1318,7996,0.10625162),(1318,10852,0.9162863),(1318,15774,0.8995513),(1319,1186,0.66184646),(1319,9825,5.9683543e-2),(1319,14906,0.3196406),(1320,10495,4.699927e-2),(1320,28224,0.31131402),(1321,8527,0.9136198),(1321,10360,0.59053695),(1321,22578,0.84184766),(1321,31297,0.8954401),(1322,521,9.2333555e-2),(1322,7280,0.63223004),(1322,7823,0.89023733),(1322,7979,0.64784616),(1322,13717,2.9328136e-2),(1322,25929,0.44820344),(1323,12202,0.77227044),(1323,13774,0.1364349),(1324,5026,1.0382322e-3),(1324,5421,5.6679826e-2),(1324,26907,0.7431983),(1324,31907,0.38100207),(1325,7680,0.42434397),(1325,20157,1.6902186e-2),(1325,22965,0.40876555),(1326,4456,7.8098685e-2),(1326,12326,0.29163998),(1326,17920,0.44215366),(1327,13523,5.257683e-2),(1327,14834,0.52615595),(1327,29072,0.39058208),(1328,776,0.3062077),(1328,4356,3.1374436e-2),(1328,11270,0.62314373),(1328,18466,0.3284796),(1328,30315,0.2506148),(1329,14252,5.5254865e-2),(1329,17561,0.5009298),(1329,17743,0.84388864),(1329,22185,4.2421337e-2),(1329,28471,0.39596367),(1329,32438,0.6539628),(1330,10810,0.108530894),(1330,13192,0.403013),(1331,242,0.73392946),(1331,5746,7.185098e-2),(1331,7038,0.55611145),(1331,8682,0.96834904),(1331,9549,0.18281315),(1331,12977,0.72958565),(1331,32602,0.9164628),(1332,2079,0.26429585),(1332,8481,0.20617236),(1332,17408,0.4709039),(1332,28737,0.23493463),(1332,29684,0.5969209),(1333,88,5.633151e-3),(1333,5879,0.8521401),(1333,23978,0.45260304),(1335,10565,0.89942086),(1335,11766,0.42078266),(1335,12094,0.36213923),(1335,19236,7.4877046e-2),(1336,143,0.49719092),(1336,5024,0.4071474),(1336,17215,0.32058805),(1336,19595,0.8732445),(1337,218,0.35368225),(1337,16984,1.591637e-2),(1337,18891,0.46660888),(1337,19206,0.4787018),(1337,22201,0.7173756),(1338,10304,0.8802487),(1338,11555,0.8303454),(1338,16533,0.60874027),(1338,24005,0.7938347),(1338,29111,0.52558136),(1339,12604,0.3465025),(1339,15258,0.34292436),(1339,17546,0.74165773),(1339,31692,0.8879582),(1340,7602,0.23604693),(1340,20936,6.775185e-2),(1340,21913,0.3972075),(1341,10354,0.65865487),(1341,14292,0.35789347),(1341,19985,0.8311088),(1341,21359,1.5303442e-2),(1341,22968,0.68669784),(1342,8096,0.5264566),(1342,9195,0.7016933),(1342,11355,0.9617742),(1342,25918,0.87124974),(1343,4197,0.23353422),(1343,5732,0.59530574),(1343,30189,0.30073473),(1343,32455,0.42612574),(1344,7380,0.5407111),(1344,10044,0.9471242),(1344,12258,0.49536613),(1344,24682,0.82105523),(1344,31032,0.40339768),(1345,23297,0.75796366),(1345,24053,0.77990025),(1345,27299,0.5097648),(1345,27328,0.5151977),(1346,4599,0.76193583),(1346,6024,0.37989044),(1346,6080,0.33918205),(1346,7903,0.5554364),(1346,9143,0.82872725),(1346,28202,0.74235195),(1346,32364,0.6838987),(1347,5510,0.22345784),(1347,10066,0.52336836),(1347,25695,0.69024044),(1348,10795,0.53852665),(1348,19029,0.10468221),(1348,27763,0.48733318),(1348,31789,0.2775932),(1349,1689,0.4816433),(1349,6074,0.4946149),(1349,28573,0.536652),(1350,173,0.711803),(1350,14328,0.18873443),(1350,20484,0.8069436),(1350,25949,0.7910407),(1350,28082,3.809237e-2),(1350,30287,0.10584421),(1351,6430,0.25276995),(1351,19354,0.1534491),(1351,31144,0.24723978),(1352,8995,8.204787e-2),(1352,20392,0.265903),(1353,2162,0.7871586),(1353,4401,0.1281614),(1353,7073,0.31954515),(1353,13578,0.25640863),(1353,14183,0.55209655),(1354,977,0.20552167),(1354,19235,0.7241405),(1354,23557,0.9421297),(1354,26134,0.28501055),(1354,26882,0.24985923),(1355,1980,0.43587127),(1355,5906,0.22111408),(1355,21996,0.48095453),(1355,27985,0.10125605),(1355,29342,0.60400397),(1356,4171,0.6911178),(1356,11382,6.5201023e-3),(1356,11565,0.3260216),(1356,14264,0.35317183),(1356,22079,0.44262874),(1356,23700,0.88380045),(1356,26270,0.6502467),(1356,30971,0.28758937),(1356,31388,0.4749358),(1357,6088,0.43445376),(1357,8542,0.45321554),(1358,4331,0.20477797),(1358,22360,0.12947695),(1359,1191,0.43621477),(1359,10348,0.5473319),(1359,10562,0.74042445),(1359,26336,0.36108547),(1360,293,2.7084226e-2),(1360,8853,0.41201168),(1360,9809,6.884155e-2),(1360,20629,2.2209795e-2),(1361,1583,0.33297896),(1361,17311,0.8994194),(1361,23012,0.80538213),(1361,25580,0.18882181),(1361,27849,0.33597696),(1361,29175,0.6470716),(1361,29515,0.8537706),(1362,531,0.13080728),(1362,10132,0.77026004),(1362,22102,0.72470796),(1362,26417,0.77112615),(1363,4195,0.9767107),(1363,10114,0.7764848),(1363,11695,0.764791),(1363,15154,4.5241773e-2),(1363,21024,0.700164),(1363,23187,0.7003905),(1363,25079,0.27083603),(1364,12328,0.6987091),(1365,12466,0.49725205),(1365,24708,1.3478406e-3),(1365,25201,0.21351635),(1365,26455,0.60172445),(1365,30824,0.9021409),(1366,2224,0.2827188),(1366,6414,0.38159263),(1366,27610,0.55656475),(1367,13639,0.61358154),(1367,19226,0.40823472),(1367,32029,0.6729847),(1368,4379,0.6761024),(1368,15030,0.35031477),(1368,28004,0.5724321),(1368,28872,0.23500724),(1369,13525,0.7890471),(1370,685,0.45481157),(1370,1128,0.16784856),(1370,7634,0.5726963),(1370,12383,0.21179336),(1370,23137,0.7960155),(1370,23363,0.4093279),(1370,26084,0.26774552),(1371,10733,0.13690673),(1371,12432,0.34408706),(1372,5318,0.69448775),(1372,6741,0.46052924),(1372,16791,0.17888765),(1373,12381,0.1262125),(1373,16941,0.949737),(1374,8785,0.47792158),(1374,19522,0.3850185),(1374,24275,0.30459794),(1374,27813,0.78680265),(1374,32437,0.88515246),(1375,15307,7.4244514e-3),(1375,23178,0.8543596),(1375,26780,0.72654766),(1375,29956,0.7625338),(1376,977,0.3604141),(1376,5518,0.43502653),(1376,11329,0.21931711),(1376,12038,0.7806978),(1376,14759,0.96822643),(1376,17794,0.5623038),(1376,21775,0.2387647),(1376,22183,0.6400409),(1376,22448,0.6470305),(1376,26851,0.86335886),(1376,26932,0.4782676),(1376,29600,0.5506915),(1376,29827,0.6170225),(1377,510,1.2388212e-2),(1377,6848,0.23875323),(1377,7477,0.7019356),(1377,17113,0.1182064),(1377,19315,0.39974174),(1377,27287,1.6981965e-2),(1377,30034,0.14167708),(1378,2373,0.46520588),(1378,3654,0.19138426),(1378,4514,0.14611743),(1378,16492,0.89800304),(1378,17485,0.69315535),(1378,28415,0.10216449),(1379,2884,0.3912506),(1379,25168,0.44697186),(1379,25805,0.89635056),(1380,4874,0.96795714),(1380,21761,0.6799156),(1380,22710,0.2755346),(1380,23576,0.59124845),(1380,25398,0.5343199),(1381,24334,5.4536894e-2),(1382,2311,0.15109886),(1382,6140,0.70006514),(1382,13326,2.937932e-2),(1382,29304,0.1279948),(1383,14445,0.14205596),(1383,15780,0.7098568),(1383,27248,0.99195486),(1385,7237,0.6052472),(1385,10283,0.5448421),(1385,19963,0.7308981),(1385,23119,0.6081226),(1385,27695,0.8410989),(1386,201,0.42229813),(1386,10348,0.64931166),(1386,25496,0.6167171),(1386,26780,0.45700774),(1387,23039,0.97694075),(1387,30008,0.717995),(1387,30930,0.8479001),(1388,1142,0.3087812),(1388,11817,0.13566291),(1388,18158,0.71857893),(1388,22388,0.15804635),(1388,26860,0.20269753),(1388,27071,5.185008e-2),(1389,3927,0.58643574),(1389,5500,0.44163042),(1389,7955,0.980735),(1389,9593,0.8176744),(1389,25092,0.78099805),(1390,18291,0.7089627),(1390,20773,0.13411888),(1391,14816,0.497232),(1391,24877,0.936355),(1392,14710,0.81874746),(1392,15678,0.63175416),(1392,27713,0.5720772),(1393,8958,0.94924784),(1393,22654,0.37183315),(1393,30585,0.6554353),(1394,3734,0.6032752),(1394,9069,0.7237449),(1394,21715,0.990302),(1394,27487,0.8092595),(1394,32007,0.23634149),(1394,32247,0.8275893),(1395,9545,0.4269273),(1395,17707,0.74279636),(1395,25435,9.184742e-2),(1395,30207,0.40816355),(1395,32125,0.7738043),(1397,3790,0.56831425),(1397,32051,0.27582487),(1399,21,1.019457e-2),(1399,7228,0.21691102),(1399,7946,0.68960404),(1399,10716,0.8172444),(1399,18421,1.0015347e-2),(1400,7014,0.70834893),(1400,7564,0.93548506),(1400,14705,0.9885517),(1401,4730,3.581449e-2),(1401,14181,0.53067666),(1401,14524,0.86144215),(1401,26950,0.22172152),(1401,29799,2.2753619e-2),(1402,9288,0.9387757),(1402,12777,4.387104e-2),(1402,17783,0.4369714),(1402,28152,0.92078125),(1403,91,0.38731793),(1403,26120,3.0901425e-2),(1404,6856,0.83122194),(1404,12748,0.41086468),(1404,13966,0.24913256),(1404,20500,0.9773464),(1404,23059,0.58000654),(1404,25568,0.76411694),(1404,26702,0.32418895),(1405,245,0.5778095),(1405,11767,0.8683358),(1405,21430,0.7326489),(1406,2462,0.3308351),(1406,25464,0.5562361),(1407,1174,0.9282488),(1407,22367,4.153243e-2),(1407,25487,0.75842106),(1408,274,0.88688207),(1408,17965,0.90742546),(1408,19731,0.8071243),(1408,31369,0.99137706),(1408,31787,0.75674266),(1409,17156,0.44890827),(1409,32301,0.74233675),(1410,24917,9.988737e-3),(1410,31788,0.541404),(1411,16783,0.4798561),(1411,16906,0.5484574),(1411,32522,0.7136239),(1412,1628,0.7754317),(1412,5847,0.97101897),(1412,7664,0.11549168),(1412,18633,0.9566293),(1412,26029,0.7292775),(1412,26471,0.62230855),(1413,882,1.3043021e-2),(1413,2454,0.32987216),(1413,4566,0.99472934),(1413,14562,0.4918644),(1413,25499,1.8365147e-2),(1413,26222,0.9608491),(1413,26910,0.31411412),(1414,5225,0.43400544),(1414,10458,0.8432407),(1414,27578,0.20856442),(1414,30645,5.559057e-2),(1415,8537,0.9025903),(1415,9903,0.43775275),(1415,15961,0.8361485),(1415,16949,0.56195617),(1415,30494,0.75811386),(1416,1492,0.58531934),(1416,18347,0.13043863),(1417,3560,0.6871263),(1417,13729,0.1118833),(1418,5394,0.81323296),(1418,9497,0.35242385),(1418,10004,0.26540148),(1418,17483,6.2919045e-3),(1418,17709,0.6306829),(1418,19790,0.8744194),(1418,24121,0.27399236),(1418,27188,0.7279921),(1419,23868,0.37470305),(1419,27334,0.13093182),(1420,5890,0.80606276),(1420,7152,5.919547e-3),(1420,27580,0.4181328),(1420,29515,0.14433333),(1420,30081,0.45540586),(1421,5457,0.3896786),(1421,25739,0.7823979),(1421,30773,0.31424466),(1422,7100,0.2190105),(1422,9140,0.7482655),(1422,17409,0.6763453),(1423,8481,0.19663483),(1423,11720,7.875902e-2),(1423,18332,0.4060125),(1424,13918,0.34217358),(1424,29568,8.916651e-2),(1425,5867,0.89417315),(1425,7471,0.65686494),(1425,15827,0.42142856),(1425,29843,0.78201663),(1426,1945,0.6130491),(1426,5425,0.66156775),(1426,9982,0.5652606),(1426,10708,2.1642257e-2),(1426,13365,0.75084215),(1426,15500,0.42279547),(1426,20538,0.4803478),(1426,22869,0.42709506),(1426,23345,0.19371241),(1427,31781,0.507326),(1427,32426,0.87516916),(1428,1773,0.700815),(1428,2485,4.857439e-2),(1428,2914,8.447919e-2),(1428,19340,0.5285651),(1428,19838,6.503411e-2),(1428,25438,0.10808039),(1428,26649,0.10617247),(1428,26807,0.43865177),(1429,870,7.104753e-3),(1429,1471,1.7660001e-2),(1429,9031,0.36833417),(1429,27616,0.5558574),(1429,29454,0.51496494),(1430,10656,0.31775492),(1430,13905,2.419044e-2),(1430,21182,0.33491784),(1430,24354,0.48125532),(1431,2596,0.4144962),(1431,3112,0.43315715),(1431,7207,8.048466e-2),(1432,902,0.59343916),(1432,15044,4.8674205e-3),(1432,28578,0.20467795),(1433,12234,0.7310679),(1433,14672,0.90175027),(1433,14710,0.40356654),(1433,17852,0.13472034),(1433,26665,0.23833886),(1433,27608,0.8121099),(1433,28683,0.7003377),(1434,9983,0.8890193),(1434,13267,2.927806e-2),(1434,25048,0.8055911),(1434,25214,0.17374817),(1435,2263,0.5133338),(1435,13055,0.67880803),(1435,15360,0.63783175),(1435,20223,0.4683796),(1436,1138,1.8629383e-3),(1436,5311,0.5787904),(1436,16120,0.97400385),(1436,18665,0.28754017),(1436,28828,0.34595907),(1437,196,0.519585),(1437,1027,2.405155e-2),(1437,15792,0.4278402),(1437,18081,0.34089655),(1437,22920,0.7989399),(1437,32043,0.9372552),(1438,2123,0.26653197),(1438,31732,0.82218146),(1439,9745,0.2549069),(1439,12991,0.97772765),(1439,15715,0.75377494),(1439,18281,0.9899012),(1439,19854,8.642274e-2),(1440,2662,0.32352132),(1441,8916,0.46389553),(1441,16923,0.35157847),(1441,22839,0.77842426),(1441,32465,6.585569e-2),(1442,4927,0.4818791),(1442,5220,1.24970935e-2),(1442,5844,0.57709193),(1442,7836,0.55513215),(1442,8550,0.4937143),(1442,25055,0.28702423),(1442,31463,0.6639639),(1443,630,0.45191833),(1443,4655,0.21021615),(1443,25972,0.960629),(1444,1353,0.4247973),(1444,7148,1.5802193e-2),(1444,8219,9.5007025e-2),(1444,9278,0.47891736),(1444,16798,0.48375726),(1444,21694,0.7516835),(1446,3800,0.12680963),(1446,19700,0.40531752),(1446,22870,0.24420598),(1446,25158,0.13910612),(1447,2898,0.7221649),(1447,5115,0.31138435),(1447,17591,0.16550614),(1448,2145,0.8411828),(1448,9173,0.91515946),(1448,10456,0.91264653),(1449,6967,0.2886894),(1449,8809,0.6719686),(1449,13151,0.41962638),(1450,8496,0.9820456),(1450,17821,2.6396029e-2),(1450,24831,0.8205992),(1451,25523,6.4427905e-2),(1452,3957,0.653992),(1452,5981,0.6321991),(1452,27182,0.8671228),(1453,11662,0.11959997),(1454,10290,0.7961086),(1454,18094,0.7022019),(1454,18321,0.3082527),(1454,26823,0.52574843),(1455,4176,0.45429656),(1455,5150,0.47066662),(1456,780,0.4344696),(1456,5562,0.68051475),(1456,6235,0.56174004),(1456,9678,0.5959797),(1456,10276,0.8263278),(1456,17099,0.6911617),(1456,22353,0.48083943),(1456,23269,0.275777),(1456,26266,0.12018368),(1457,4320,0.61052763),(1457,4878,0.3325231),(1457,9765,5.3693235e-2),(1457,11448,0.6963462),(1458,2522,0.43298963),(1458,10743,3.4757382e-3),(1458,13630,0.93111074),(1458,22586,0.21812004),(1459,14639,0.3560858),(1460,11942,0.6144487),(1460,16135,0.847772),(1460,19417,0.16238518),(1460,23336,0.5278792),(1461,2427,4.0594764e-2),(1461,7110,0.108062886),(1461,10056,0.37944606),(1461,11256,0.31296048),(1462,4293,0.5472876),(1462,4629,0.9049887),(1462,4682,0.33600768),(1462,14428,0.26735005),(1463,8879,0.8108962),(1463,17133,0.9868846),(1463,18246,0.46530682),(1463,20238,0.41988605),(1464,5143,0.488136),(1464,20577,0.12429723),(1465,5939,0.45604503),(1465,12789,0.6597792),(1465,18318,0.86943793),(1465,19446,0.978766),(1465,29693,0.1883082),(1466,10544,7.8756884e-2),(1466,22424,0.71729624),(1467,2957,0.61389524),(1467,23473,0.9101093),(1467,32696,0.6311332),(1468,10530,0.16953675),(1468,25398,0.89173555),(1468,30615,0.1502562),(1469,21987,0.23127373),(1469,26721,0.21999377),(1469,28506,0.44799155),(1469,28963,0.15953095),(1470,5911,0.51262355),(1470,25729,0.56118566),(1470,28772,0.93951076),(1470,30504,0.92884976),(1472,477,0.75191694),(1472,25612,0.8573908),(1472,30432,0.7973817),(1473,5756,0.17921765),(1473,18983,5.5692773e-2),(1474,16540,4.632955e-2),(1475,10162,0.7077656),(1476,7023,0.13751848),(1476,18277,0.400945),(1477,12772,0.5656037),(1477,12980,0.93869555),(1477,20514,0.68780696),(1477,22454,0.50575364),(1478,7969,0.11510116),(1478,12782,0.1223093),(1478,24554,2.1505872e-2),(1478,32225,0.51060385),(1479,2437,0.21251398),(1479,3673,0.13601857),(1479,12116,0.74267507),(1479,17100,0.56527734),(1479,18565,0.3712365),(1479,30452,0.5868643),(1480,5976,0.25261968),(1480,20810,0.47272435),(1480,24334,0.20045151),(1481,8926,0.6612664),(1481,10916,0.4740446),(1481,18298,0.5994687),(1481,23175,0.3715173),(1482,16096,0.9125745),(1482,19401,0.50785094),(1482,23492,0.59098256),(1482,26025,0.103360854),(1483,664,0.6183258),(1483,6680,0.34040812),(1483,7921,0.80576897),(1483,16161,0.37157223),(1483,18780,0.7390459),(1483,21051,0.49860847),(1484,10443,0.59636927),(1484,21347,0.32068148),(1484,24038,0.3253144),(1484,24518,0.9009915),(1484,25813,0.41218692),(1485,732,0.9095),(1485,2406,0.3900102),(1485,9458,0.9813241),(1485,16344,0.73341537),(1485,16941,0.80400217),(1485,24364,0.26616123),(1485,24666,1.449338e-3),(1485,30154,0.8442484),(1486,2324,0.24782278),(1486,7924,0.61067736),(1487,5851,0.9579433),(1487,22454,0.2792474),(1487,22850,0.90799624),(1487,27533,0.83070916),(1487,29159,0.13611837),(1488,8625,0.26241785),(1488,16508,0.3065916),(1488,21168,0.33424187),(1489,4469,0.89555913),(1489,7084,0.4612966),(1489,13858,0.26547205),(1489,16053,0.98114985),(1490,18705,0.25009346),(1490,20705,0.85287577),(1490,24275,0.429394),(1490,26503,0.7658217),(1491,4429,0.46713167),(1491,9870,0.2981751),(1491,19814,0.4988668),(1491,20812,5.823409e-2),(1491,31046,0.64494276),(1492,9973,8.0918565e-2),(1492,24536,0.9253993),(1492,25006,0.63612187),(1493,1707,0.16998836),(1493,1913,0.8979465),(1493,2682,0.94732654),(1493,7915,6.2328327e-2),(1493,12698,0.10632836),(1493,15132,0.5506388),(1493,23664,0.97336066),(1493,28014,0.43503183),(1493,30054,0.5653352),(1494,8813,0.8814749),(1494,15589,0.8234542),(1494,27044,0.97262627),(1494,31058,0.7779536),(1494,31713,0.5367313),(1495,5006,4.815268e-2),(1495,6324,0.5451224),(1495,9801,0.98122483),(1495,12636,0.12258158),(1495,17939,0.69727075),(1495,19824,0.31146702),(1496,3389,0.5011266),(1496,14932,0.5159803),(1496,24516,0.6187642),(1497,12532,0.5419233),(1497,13286,0.7232465),(1497,15182,0.17138721),(1497,22194,0.44132507),(1497,31115,0.8888837),(1498,3201,0.6829765),(1499,1415,0.26537964),(1499,2443,0.683206),(1499,7229,0.4379435),(1499,7407,0.2038828),(1499,18885,0.5546836),(1499,23621,0.50095344),(1499,23987,0.12610132),(1499,27668,0.36144692),(1500,1964,0.63241553),(1500,14850,4.197131e-2),(1500,16048,0.68719834),(1500,20017,5.4416927e-3),(1500,26075,0.69990903),(1500,28845,0.6387378),(1501,16261,0.41963813),(1501,18306,0.32336655),(1501,26368,0.83564776),(1502,10446,0.46001434),(1502,31383,0.13326275),(1503,18259,0.68106663),(1503,19307,0.9655845),(1503,21021,0.24907912),(1503,25639,0.606098),(1503,26551,0.38873413),(1504,5425,0.43452096),(1504,14968,0.77929527),(1504,16421,0.29528996),(1504,20630,0.6530316),(1504,23141,0.5269499),(1504,32083,0.7156474),(1505,7461,0.5959877),(1505,7693,0.361914),(1505,8311,0.915371),(1505,9563,0.3344288),(1505,10843,0.36611643),(1506,11898,0.6107348),(1506,12602,0.62828314),(1506,14752,0.5593588),(1506,21875,0.85773593),(1507,9951,0.7968747),(1507,11334,0.53216356),(1507,12832,0.78459466),(1507,14632,0.33638117),(1507,18180,0.13719615),(1507,21441,0.37296766),(1508,31442,0.27180254),(1508,31921,0.93966895),(1509,8754,0.42111367),(1509,19899,0.35125718),(1509,23992,0.6161304),(1510,10116,0.4446575),(1510,21435,0.9767351),(1510,23973,0.1716839),(1510,24197,0.87601113),(1510,24678,0.45975867),(1511,3320,0.8207922),(1511,10109,0.5034568),(1511,13240,0.85777426),(1511,17027,0.35756928),(1512,4821,0.24194369),(1512,26112,0.21438353),(1513,3387,0.9222531),(1513,13760,0.8518793),(1513,21720,0.5694471),(1513,28838,0.23002262),(1513,29868,0.22104977),(1514,5884,0.6449979),(1514,6476,0.1707662),(1514,11720,0.46359122),(1514,25059,0.57836896),(1515,12486,0.42600638),(1515,13521,0.8432909),(1515,15513,0.30519316),(1515,22038,0.5891984),(1516,18086,8.088749e-2),(1516,19429,9.311862e-2),(1517,8117,0.58287036),(1517,23936,0.9810765),(1517,24609,0.35720438),(1517,25552,2.834085e-2),(1518,2031,0.15621087),(1518,18964,0.9169338),(1518,22753,0.12905912),(1518,27886,0.85251826),(1518,31991,0.57593304),(1519,7010,0.8079344),(1519,26104,0.17198266),(1520,6661,0.4673336),(1520,11882,0.9230947),(1520,30814,2.9926218e-2),(1521,15521,0.1272514),(1522,14280,4.3541595e-2),(1522,20981,0.41733015),(1522,26208,0.67245114),(1522,29674,0.26520434),(1523,14322,0.67069066),(1523,22584,1.6929675e-2),(1523,27701,0.5223423),(1524,20495,0.72514606),(1524,24704,8.080626e-2),(1524,27730,0.16196592),(1525,4912,0.9872411),(1525,13292,0.57891977),(1525,25918,0.4597992),(1525,29928,0.71286666),(1526,26882,0.7660708),(1527,7729,0.8701256),(1527,23033,0.12692104),(1527,23559,0.45152688),(1527,26810,0.6531692),(1528,16223,0.6221694),(1528,18544,0.25899604),(1528,26959,0.27424303),(1528,30420,0.89175117),(1529,2927,0.7612999),(1529,8547,8.1321955e-2),(1529,10501,0.6865797),(1529,24513,0.16268821),(1529,29213,0.6028147),(1529,30147,0.2545554),(1529,32411,0.12739263),(1530,3217,0.9344034),(1530,8515,0.460392),(1530,13779,0.33325276),(1530,14055,0.14176013),(1530,23518,0.3914595),(1531,1895,0.42852184),(1531,32410,0.7334508),(1532,2241,0.7744191),(1532,12683,0.9115951),(1532,30285,0.5932493),(1532,30688,0.7404645),(1533,766,0.29603288),(1533,3898,0.20531751),(1533,5733,0.11156619),(1533,8337,0.7699783),(1533,16104,0.668809),(1533,22533,0.37775588),(1534,21596,0.50942254),(1534,30710,0.34672567),(1535,6561,0.28338107),(1535,24989,0.9637768),(1535,26520,0.5014076),(1535,31104,0.20852935),(1536,799,0.61856383),(1536,3993,0.9145688),(1536,7116,6.882391e-2),(1537,948,0.1913044),(1537,2351,0.96170324),(1537,12222,0.8505425),(1537,15708,0.44225726),(1537,17975,0.8210347),(1537,20911,0.996776),(1538,14502,0.9020304),(1538,24341,0.2862538),(1538,26599,0.9588668),(1538,27719,0.55556124),(1538,28781,0.2146842),(1538,30112,0.7113971),(1539,6820,0.6917326),(1540,1962,0.8218268),(1540,2508,0.96915805),(1540,5854,9.3417086e-2),(1540,28503,0.7917505),(1540,32572,0.55337936),(1541,2837,3.0507206e-3),(1541,7130,0.32322243),(1541,15761,0.47239566),(1541,19036,0.74520105),(1542,22316,0.95246834),(1543,26694,0.5350349),(1543,30098,0.9202611),(1544,1144,0.43347925),(1544,2407,0.92099607),(1544,3389,0.24027537),(1544,16487,0.5823931),(1544,27187,0.90364933),(1544,31784,0.25884852),(1545,13767,0.84970325),(1545,14924,0.8798441),(1545,30516,0.7436357),(1546,3943,0.7341882),(1546,11945,0.95729405),(1546,17041,9.008626e-2),(1546,19755,0.38757694),(1546,29230,7.074685e-2),(1546,29376,0.37082294),(1546,30092,0.77544117),(1546,31898,0.2289102),(1546,32014,0.31349698),(1547,26344,0.73391145),(1547,29626,0.19352075),(1547,31106,0.71614486),(1548,1909,0.60470784),(1548,3143,0.6119408),(1549,8565,0.22547519),(1550,1107,0.7091847),(1550,9785,0.80640066),(1550,26013,0.30521026),(1551,19415,0.12031596),(1551,31515,0.23937145),(1552,3798,0.22854504),(1552,13637,0.12294646),(1552,17581,0.9136644),(1552,24218,0.9221157),(1552,32726,0.64819425),(1553,21638,0.64247876),(1554,5958,5.7515636e-2),(1554,10792,0.7085215),(1554,23122,0.9412699),(1554,25843,0.7262623),(1555,1725,0.49090254),(1555,12546,0.7897425),(1555,17192,0.3417195),(1555,19721,0.21435744),(1556,15492,0.82799536),(1556,18602,9.922022e-2),(1556,26119,0.55385906),(1556,30144,0.77008736),(1556,31533,0.5556602),(1556,32096,0.66219485),(1558,8821,0.82767725),(1558,14350,0.504268),(1558,23032,0.7490829),(1558,25235,9.875941e-2),(1559,4840,0.616781),(1559,9329,4.3883096e-2),(1560,6898,0.27556664),(1560,8651,0.28105974),(1560,17401,0.42021438),(1560,26398,0.45154673),(1561,11859,6.2090438e-2),(1561,24907,0.22794588),(1561,29566,0.7842485),(1562,11010,0.3345031),(1562,14265,0.17798269),(1562,31116,0.21400686),(1563,3581,0.6485145),(1563,9938,5.4668233e-2),(1563,17830,0.89516383),(1563,19955,0.2923193),(1564,2887,0.82944816),(1564,17072,0.28758836),(1565,18248,0.8334651),(1565,26876,9.853717e-2),(1566,1468,0.104763046),(1566,15358,0.6747641),(1567,14143,0.3617423),(1567,22215,0.3095463),(1567,23845,0.4192452),(1567,30181,0.7461656),(1567,32168,0.891703),(1568,1024,0.80154055),(1568,1279,0.5319982),(1568,3988,0.6714018),(1568,4943,0.21174888),(1568,8371,0.9950599),(1569,34,0.94967914),(1569,4478,0.5872647),(1570,2455,0.19458374),(1570,10804,0.7590217),(1570,27848,0.1954857),(1570,30041,0.48463425),(1570,31276,0.12901224),(1570,31298,0.34010828),(1571,6612,0.6299694),(1571,6791,0.1639298),(1571,8139,0.6257733),(1571,26113,0.422554),(1571,29379,0.4020961),(1571,30484,0.93061435),(1573,1674,6.8998635e-2),(1573,8232,0.6702265),(1573,15933,4.5617722e-2),(1573,22941,0.62576145),(1573,32752,0.28722996),(1574,10710,0.65650123),(1574,19674,0.9629578),(1575,706,0.5292672),(1575,4703,3.261191e-2),(1575,5477,0.46020043),(1575,11836,0.4767376),(1575,13876,0.45979303),(1575,15200,0.35304144),(1576,15813,0.8354596),(1576,20297,0.12869008),(1576,20817,0.7491275),(1576,30301,0.9630102),(1576,30331,0.4808632),(1577,3630,0.79110366),(1577,12180,0.11525024),(1578,1234,0.84867847),(1578,4854,0.23662904),(1578,25911,0.5789155),(1579,4524,0.34145814),(1579,15418,0.5185743),(1579,26563,0.7656838),(1580,893,0.17186639),(1580,2094,7.6751344e-2),(1580,3973,0.23946524),(1580,4569,0.7246737),(1580,23045,0.56092817),(1580,24998,3.2248646e-2),(1581,10147,0.16596316),(1581,14676,0.5620468),(1581,16837,0.44281194),(1581,26853,7.50976e-2),(1581,27426,3.833135e-2),(1582,9640,0.27477434),(1582,11779,0.24056667),(1583,19116,0.5956435),(1584,1539,0.6193289),(1584,6007,0.63891685),(1584,9394,0.43347162),(1584,17842,0.3921045),(1584,18311,7.474135e-2),(1584,18401,0.97475505),(1584,25035,8.818312e-2),(1584,25993,0.7177123),(1585,18623,0.94529),(1586,25512,0.8977198),(1587,633,0.7339732),(1587,12092,0.77433926),(1587,12519,0.8935329),(1588,6458,0.7483763),(1588,14388,0.3420614),(1588,21052,0.91739917),(1588,23680,0.7218174),(1589,17212,0.5490211),(1589,31854,0.43395612),(1590,4151,0.951594),(1590,12051,0.7789366),(1590,22468,3.7938945e-2),(1591,4119,6.449313e-2),(1591,6918,0.58954257),(1591,10822,0.17298825),(1591,11445,0.88786536),(1591,31017,0.63270426),(1592,19353,0.4448623),(1592,24723,7.650477e-2),(1593,1463,0.56990767),(1593,3732,0.97677934),(1593,13591,0.29607865),(1593,22329,0.26291075),(1593,29895,0.39778772),(1594,3566,0.5218812),(1594,4008,0.7062185),(1594,15533,0.4220497),(1594,19555,0.29103854),(1594,26833,0.41457522),(1595,4632,0.23848142),(1595,8900,0.8048755),(1595,30395,0.8572939),(1596,19644,0.6203667),(1596,26396,0.5018303),(1596,32471,9.3168365e-3),(1597,1007,0.74050105),(1597,2148,0.24747086),(1597,19586,0.49145532),(1597,19861,0.22578937),(1597,25791,0.36486703),(1598,11144,9.9506944e-2),(1598,25167,0.7681169),(1599,9044,0.6634463),(1599,27089,0.11993309),(1600,4732,6.597868e-2),(1600,16779,7.367817e-2),(1600,18001,0.20188163),(1601,6947,1.9973265e-2),(1601,19262,0.634163),(1602,6101,0.32107398),(1602,7803,0.37629646),(1602,8063,0.34042555),(1602,19557,0.8746587),(1602,27086,0.9094697),(1602,28358,0.29322794),(1602,32059,0.278263),(1603,10434,0.19238158),(1603,13127,0.6314236),(1603,18132,0.10617948),(1603,31816,1.5667055e-3),(1604,15642,0.6025589),(1605,3496,0.8826112),(1605,9555,0.5748703),(1605,26389,0.23383687),(1605,32580,0.5805193),(1608,427,0.5357914),(1608,3391,0.8352822),(1608,11383,1.6829394e-2),(1608,18297,0.7470925),(1608,18625,2.598097e-2),(1608,20684,0.69538504),(1609,8788,0.44468912),(1609,18192,1.5728626e-2),(1609,25475,0.8197188),(1609,31719,0.15683137),(1609,32694,0.28328058),(1610,10113,6.781631e-2),(1610,11036,0.27541777),(1610,21846,0.48204777),(1610,25321,0.9526648),(1611,1441,0.43682742),(1611,2271,0.27544168),(1611,14720,0.19220696),(1611,18768,5.7333346e-2),(1611,30911,0.5594675),(1611,31241,0.1653606),(1612,1555,0.61145926),(1612,23400,0.13376375),(1612,25627,2.2939024e-2),(1613,960,0.9796671),(1613,8896,0.9164726),(1613,13697,0.11924382),(1613,18613,0.30097455),(1614,1698,0.2284603),(1614,20134,0.67557335),(1614,27254,9.331234e-2),(1615,2405,0.71800435),(1615,9596,0.4761757),(1615,11087,0.37774274),(1615,11220,0.64801586),(1615,17515,0.41409004),(1615,24365,0.42996016),(1616,5988,0.52575403),(1617,3974,0.14101848),(1617,32024,0.821174),(1618,13743,0.4575002),(1618,22595,0.9677),(1618,25948,0.5577477),(1618,26469,0.32630867),(1618,29835,0.15926889),(1619,7139,0.407528),(1619,8786,0.19065082),(1619,24045,0.46004948),(1619,25985,0.100157246),(1619,28707,7.0734225e-2),(1620,9026,0.8064767),(1620,11416,0.2755301),(1620,17463,0.857483),(1620,19202,0.417382),(1620,20041,0.53198975),(1620,22786,0.6001713),(1620,30156,0.5347602),(1621,5560,0.606656),(1621,7509,0.41676098),(1621,7747,0.41367435),(1622,11773,0.5280326),(1622,12524,0.5813712),(1622,14517,0.89656866),(1622,24795,7.4168816e-2),(1622,31748,0.16769959),(1623,12421,4.8899096e-2),(1624,1403,7.4098766e-2),(1624,3628,0.5165422),(1624,13628,0.6522202),(1624,18507,0.80731356),(1624,21945,0.57356447),(1625,332,2.098356e-2),(1625,14360,0.45319337),(1625,21597,0.7725533),(1625,22731,7.855517e-2),(1625,26393,0.4130604),(1625,26397,0.47564292),(1625,26623,0.153335),(1625,30082,0.53496516),(1626,318,0.9640247),(1626,526,0.3645366),(1626,1348,0.93724173),(1626,10687,0.96600235),(1626,11335,0.89607847),(1626,17149,0.29698348),(1627,4166,0.25124633),(1627,30496,0.2654979),(1627,32697,0.51069045),(1628,11103,0.82459456),(1628,18389,0.6460452),(1628,23559,0.62967813),(1629,24262,0.9832971),(1629,27935,0.41270956),(1629,31389,2.8485278e-2),(1630,6489,0.35909685),(1630,13945,0.97102743),(1630,15583,0.5676816),(1631,20227,0.666565),(1631,28397,0.4037256),(1631,32087,0.36175057),(1632,15598,3.918656e-2),(1632,15859,0.75147915),(1633,7857,0.3751243),(1633,10491,0.26056504),(1633,29508,0.2910361),(1634,3756,0.9043227),(1634,13738,0.8195694),(1634,18857,0.5412431),(1634,26125,0.207231),(1634,29916,0.49635318),(1634,30568,0.40451175),(1635,6676,0.24219865),(1635,31714,0.2295631),(1636,10433,0.5807777),(1636,24505,0.678547),(1636,28301,0.3865436),(1636,31805,0.8207456),(1637,3872,0.43124905),(1637,5115,0.8418457),(1637,20066,0.5064956),(1637,26560,0.55932313),(1637,28107,0.9040549),(1638,6757,1.3190553e-2),(1638,12175,0.11671977),(1638,17116,0.43107638),(1638,21189,0.37427855),(1639,4532,0.42423),(1639,6503,0.90117246),(1639,6676,0.7349927),(1640,18055,8.858037e-2),(1640,22020,0.37859443),(1640,28184,0.70935225),(1641,766,0.965188),(1641,1135,0.71065956),(1641,10982,0.7226463),(1641,12023,0.18890639),(1641,13132,0.67633307),(1641,17624,0.30066726),(1641,27732,0.5488204),(1642,20799,0.4369356),(1642,23940,0.49898),(1643,6873,0.39588803),(1643,10859,9.7681284e-2),(1643,11728,0.7292853),(1643,13390,0.36128595),(1643,21892,0.20005864),(1643,31533,0.8529349),(1644,261,0.81627786),(1644,9204,3.1566598e-2),(1644,23822,0.14559102),(1644,28128,0.52147084),(1645,12174,0.99293613),(1645,28383,0.69328487),(1645,29257,0.6207096),(1646,1607,0.13655934),(1646,2513,0.4674892),(1646,3893,0.174998),(1646,6251,0.67236024),(1646,29830,0.113466784),(1646,32345,0.9591927),(1647,5136,0.3512325),(1647,28698,0.884406),(1647,28922,0.10936101),(1648,11240,3.582952e-2),(1648,18676,0.2216805),(1648,25433,0.82626516),(1649,16371,0.84107643),(1649,16525,1.1336087e-2),(1649,19644,8.069772e-3),(1649,20346,0.47162452),(1650,2146,0.118205294),(1650,2768,0.5364123),(1651,3436,0.30054522),(1651,3653,0.99234086),(1651,10366,0.9217771),(1651,11380,0.3604455),(1651,28516,0.17902954),(1652,2079,0.93909276),(1652,3953,0.37730816),(1652,6082,0.97719854),(1652,12748,0.6780347),(1652,17753,0.70016307),(1652,27230,0.69843763),(1652,28390,0.4197377),(1652,32644,6.4551875e-2),(1653,2427,5.2235406e-2),(1653,8922,0.88342553),(1653,11335,0.47653177),(1653,28506,0.8393376),(1654,2022,0.27212527),(1654,4334,0.57655096),(1654,14522,6.0098567e-3),(1655,9776,0.73104125),(1655,22794,0.37355366),(1655,24750,0.6857287),(1655,28244,0.45146012),(1655,30552,0.46566215),(1656,936,0.3715205),(1656,10823,2.3564074e-2),(1656,19904,0.1429165),(1656,23755,0.4305043),(1657,16811,0.764683),(1658,10265,0.20369901),(1658,12966,0.8652459),(1658,13694,0.4670748),(1658,16753,0.7782431),(1658,30013,0.39067036),(1658,30099,1.3359541e-2),(1659,5195,0.47224796),(1659,6076,0.44817314),(1659,8587,0.14955334),(1659,9639,0.50172275),(1659,11490,0.23190957),(1659,13501,0.55403876),(1660,14951,0.6951398),(1661,3290,0.5291726),(1661,12205,0.312866),(1661,12235,0.5901577),(1661,26178,0.84296423),(1662,1807,0.24807887),(1662,7274,0.13566689),(1662,15754,0.21290737),(1662,19101,0.8890174),(1662,23477,0.5806319),(1662,25035,0.88148534),(1662,26202,0.16182443),(1662,26781,0.5419152),(1663,4892,0.87633276),(1663,25182,0.4710956),(1663,25307,0.603909),(1664,5747,0.20187384),(1664,10719,0.4930505),(1664,11625,0.4890069),(1664,22944,0.7861447),(1666,1801,8.818528e-2),(1666,2135,0.58735615),(1666,15494,2.0296488e-2),(1666,21137,0.33181807),(1666,31680,0.60069585),(1667,18688,0.9166898),(1667,28052,0.37415066),(1668,1720,0.1372539),(1668,7902,0.21508195),(1668,10837,0.7024167),(1668,12113,0.87020755),(1668,19516,0.1862655),(1669,7872,0.51632684),(1669,26578,0.8607726),(1670,9190,0.7877827),(1670,12176,0.18398029),(1670,18567,0.92859423),(1670,25423,0.98530287),(1670,29161,0.7754176),(1670,29186,0.3541311),(1670,29654,0.46904972),(1670,31113,0.24694058),(1671,11163,0.74985313),(1671,14787,0.6977066),(1671,22262,0.22247514),(1671,25389,0.54870725),(1671,31837,0.37304133),(1671,32227,0.794395),(1672,334,0.74820846),(1672,12819,0.17366773),(1672,17778,4.3211166e-2),(1672,25020,0.9307981),(1672,26778,0.7556053),(1673,1411,0.12199208),(1673,8926,0.29565477),(1673,11601,0.70760715),(1673,24000,0.68134516),(1674,3177,3.1426817e-2),(1674,13739,6.766995e-2),(1674,21633,0.88891906),(1674,26973,0.3650015),(1674,27840,0.62970227),(1674,28674,0.25771818),(1674,30817,1.9936718e-2),(1674,31902,0.26306188),(1675,1875,0.5062748),(1675,7186,0.7691363),(1675,30966,0.6727179),(1675,31302,0.35229042),(1676,7184,9.162222e-2),(1676,14938,4.9056742e-2),(1676,21127,0.7255732),(1676,22564,0.8381204),(1676,28791,0.8158077),(1677,8104,0.68712205),(1677,8139,2.2023603e-2),(1677,30080,0.25404558),(1678,2179,0.17775154),(1678,17599,3.8490582e-2),(1678,18371,0.95081806),(1678,22777,0.29288825),(1678,25041,0.23392954),(1678,30059,0.7153594),(1679,26175,0.3443804),(1680,12235,0.26775143),(1680,24739,0.18255216),(1680,28330,0.48338538),(1681,383,0.6128207),(1681,30749,4.8134755e-2),(1681,30841,5.8200236e-2),(1682,12480,0.8639571),(1682,13975,0.40422332),(1682,15946,0.1509197),(1682,23717,0.100258894),(1683,18827,0.82435566),(1683,24956,0.12583043),(1683,26589,0.57525456),(1684,19795,0.88018245),(1684,23012,0.2655189),(1684,25845,0.96225566),(1685,293,0.10906823),(1685,3032,0.6823215),(1685,20891,0.6082574),(1686,3292,0.9274343),(1686,3486,0.58213985),(1686,12324,0.7294101),(1686,17808,8.028677e-2),(1686,18554,0.35350513),(1686,18668,0.74017006),(1686,22389,0.17096694),(1687,2977,0.6595654),(1687,3400,0.9106267),(1687,13986,0.72119653),(1687,14341,0.6347278),(1688,1974,0.30825213),(1688,7343,6.719081e-2),(1688,9591,0.13541965),(1689,5759,0.99372965),(1689,6533,0.7989485),(1689,12904,0.11151079),(1689,21171,0.3975341),(1689,23229,0.23382325),(1690,3243,0.20193802),(1690,16788,0.9975745),(1690,17645,0.39823127),(1690,22543,0.3918745),(1691,818,0.12585206),(1691,1597,0.77192307),(1691,11844,0.8943716),(1691,21210,0.6846226),(1691,25152,0.12509422),(1691,30061,0.40514624),(1692,4889,0.6868016),(1692,31305,0.56998456),(1692,31464,0.7706261),(1693,11941,0.30716252),(1693,15974,0.97411186),(1693,29221,0.8373458),(1694,2084,0.24975123),(1694,5690,0.83468676),(1694,6749,0.8754157),(1694,15508,0.7410344),(1694,21489,0.47176078),(1694,32701,0.23246583),(1695,3864,0.65067),(1695,21850,0.20411117),(1696,13133,0.2656619),(1696,20534,0.46019846),(1696,21130,0.47723854),(1696,30570,2.3039434e-2),(1696,32738,0.39114615),(1697,7702,0.405059),(1697,24428,0.84059066),(1698,165,0.634752),(1698,2861,0.57608867),(1698,9290,0.48663548),(1698,12246,0.55508465),(1698,18462,0.102073714),(1699,19416,0.54129595),(1699,21924,0.2927149),(1699,24518,0.53880054),(1700,14442,0.85533184),(1700,31112,0.3169885),(1701,21558,0.44256768),(1701,23431,0.99942994),(1701,24411,0.20896034),(1702,17734,0.7475324),(1703,472,0.4330554),(1703,5601,1.1755476e-2),(1703,14554,0.28436553),(1703,25815,0.70241517),(1704,1075,0.8155626),(1704,27556,0.25800538),(1705,3737,0.7605853),(1705,3983,0.5407993),(1705,17782,0.1377321),(1705,24363,0.41187337),(1705,24656,0.8453024),(1706,5191,0.5508053),(1706,13564,0.25847462),(1706,14407,0.14353311),(1706,20447,0.9860916),(1706,20665,0.6939234),(1707,7771,0.36655676),(1707,11090,0.68955195),(1707,12408,0.2926313),(1707,17257,0.47014955),(1707,20636,0.98483694),(1707,29319,0.696475),(1708,2109,0.48154888),(1708,8135,4.535897e-2),(1708,17748,0.52917594),(1708,18035,0.762874),(1708,29430,0.16919446),(1709,379,0.83910674),(1709,2209,0.5699878),(1709,7969,0.2212945),(1709,10513,0.26434565),(1709,27290,0.70055926),(1709,28707,0.3614154),(1709,29700,3.3056248e-2),(1709,30551,0.5249437),(1710,11423,0.23892066),(1710,26777,0.32555884),(1711,15181,0.61744493),(1711,15369,0.13575831),(1711,15404,0.65048105),(1711,25222,0.1895455),(1711,26076,0.9102951),(1711,26709,0.31612074),(1711,29442,4.605038e-2),(1712,966,0.75278974),(1712,9540,0.5757831),(1712,11673,0.3816393),(1712,15441,0.9212996),(1712,22008,0.92486006),(1713,17452,0.9297054),(1713,18625,0.37816516),(1713,32128,0.17348999),(1714,9559,0.5112834),(1714,19975,0.5053352),(1714,28896,0.5443021),(1714,30812,6.177843e-2),(1714,31962,0.76171696),(1715,10516,0.2186913),(1715,11962,0.38210803),(1715,27030,7.050743e-2),(1715,27588,0.50068295),(1716,21832,0.34667748),(1716,23634,0.5495229),(1716,26852,0.49909458),(1716,27134,0.3975397),(1716,28494,0.32782978),(1717,11441,0.97120285),(1717,20550,0.5621137),(1717,28577,0.3136002),(1718,7727,0.75895923),(1718,8412,0.3697057),(1718,18714,0.5341325),(1718,26782,0.81002885),(1718,27209,0.7954019),(1719,1821,0.6030373),(1719,7624,0.54325914),(1719,9363,0.2771777),(1719,17913,0.710157),(1719,21307,0.144908),(1719,22765,0.1712082),(1719,22780,0.24691822),(1720,11027,0.81804264),(1720,23154,0.7036335),(1721,1329,0.10068745),(1721,6683,0.2671821),(1721,28329,0.5014562),(1722,2537,0.84241885),(1722,5547,0.13110858),(1722,8689,0.53124756),(1722,15464,9.6805476e-2),(1722,16660,0.7514718),(1722,20137,0.6912684),(1722,28115,0.8909442),(1723,4741,5.3100105e-2),(1723,12122,0.11498842),(1723,20585,0.9760741),(1723,23261,0.62436616),(1724,8357,0.34940052),(1724,23916,0.52007496),(1725,1524,6.29459e-2),(1725,3167,0.5675822),(1725,3274,0.55878186),(1725,21724,0.93301356),(1726,348,0.20994815),(1726,4631,3.7868433e-2),(1726,7526,7.545045e-2),(1726,12881,0.5510816),(1726,14294,4.2177964e-2),(1726,28365,0.28389966),(1726,29087,0.8743047),(1727,3782,0.9633478),(1727,17850,0.64893526),(1727,26094,0.7265152),(1728,3109,0.83336973),(1728,12604,0.9221805),(1728,14057,0.6680542),(1728,31638,0.97727674),(1729,1590,0.7028476),(1729,13643,0.85061544),(1729,15081,0.18636537),(1729,19248,8.400467e-3),(1729,29740,0.8355387),(1730,7849,0.32954475),(1730,14374,0.44329345),(1730,14878,0.4463879),(1730,21345,2.0443853e-2),(1730,22130,0.98091364),(1730,30286,0.67263114),(1731,5136,0.47496533),(1731,17206,0.15969527),(1731,25652,3.6132798e-2),(1732,3009,0.9243366),(1732,9887,0.62293816),(1733,4801,0.23725452),(1733,7302,0.12775189),(1733,11325,0.93280077),(1733,17858,0.6367772),(1734,8653,0.4041277),(1734,10422,0.42445165),(1734,12356,0.43507728),(1735,3321,3.9547686e-2),(1735,15900,4.6100684e-2),(1735,16012,0.28921726),(1735,26116,0.94412255),(1736,16397,6.49616e-3),(1736,16914,0.44096532),(1737,2202,0.45498902),(1737,8312,0.2391167),(1737,15202,0.4702872),(1737,22519,0.18001957),(1738,13207,0.6580832),(1738,22151,0.5235533),(1738,32494,0.3536884),(1739,6693,0.85313594),(1739,13563,5.9124768e-2),(1739,14530,0.9747324),(1739,32243,0.7073916),(1740,8706,0.11396816),(1740,16079,0.66205245),(1740,19858,0.2607378),(1740,21105,0.80666363),(1740,24352,0.41401604),(1740,30499,0.20195463),(1741,6998,0.48775607),(1741,14247,0.78288954),(1741,28869,0.5760843),(1741,31113,0.62040263),(1742,782,0.7686374),(1742,20162,0.14113504),(1742,31432,0.1324287),(1742,32671,0.5008555),(1743,8897,1.2451716e-3),(1743,8931,0.14361587),(1743,12889,0.8889762),(1743,17175,0.30085757),(1743,19701,0.9975626),(1743,21334,0.7338258),(1743,31046,6.374651e-2),(1743,31236,0.7246389),(1743,31803,0.63627857),(1744,424,0.8266439),(1744,2864,0.86998147),(1744,4794,0.7306488),(1744,10438,0.4134212),(1744,19430,0.8430198),(1744,23615,0.4364638),(1744,27566,0.5877486),(1744,28325,0.24546798),(1745,13244,0.9097914),(1745,15836,0.32000542),(1745,22049,0.63300395),(1746,3898,1.684009e-2),(1746,10179,0.10735708),(1747,28287,9.3705654e-2),(1747,29769,0.8710016),(1747,31742,3.804948e-2),(1748,12998,1.249023e-2),(1748,16872,5.581769e-2),(1748,21475,0.23477945),(1749,10185,0.7340622),(1749,20186,0.6582039),(1749,28588,0.4856849),(1749,31212,0.14075856),(1750,10998,0.72861654),(1750,18068,0.9334206),(1750,21698,0.5346634),(1750,27481,6.475988e-2),(1750,31133,0.5929622),(1751,2783,0.16798031),(1751,10401,0.7246183),(1752,13340,0.46460673),(1752,15426,0.7229934),(1752,26154,0.65006894),(1753,1955,0.6259822),(1754,3186,5.2903745e-2),(1754,13935,0.5722119),(1754,32177,0.111712284),(1755,4813,0.52567637),(1755,12520,0.3594128),(1755,14389,9.790419e-3),(1755,25370,0.83142895),(1756,8923,0.5730452),(1756,9710,0.6405056),(1756,17551,0.21352619),(1756,18755,0.26543757),(1756,26955,0.628777),(1757,6906,0.3069311),(1757,7599,0.78507894),(1757,9655,0.6612599),(1757,18488,0.5288247),(1758,481,0.21943824),(1758,6100,0.2443853),(1758,31704,0.53159595),(1759,8203,0.14164735),(1759,11760,3.655262e-3),(1759,14499,0.26981047),(1760,5397,0.9556732),(1760,8338,0.6291673),(1760,21527,0.47524804),(1760,31664,0.22033182),(1761,5164,0.91757435),(1761,9327,0.90402144),(1762,8246,0.898131),(1762,24158,0.5866811),(1762,28590,0.739425),(1763,22185,0.8070942),(1763,22258,0.15032957),(1763,23724,0.6120463),(1764,31449,0.39175013),(1764,32437,0.7164375),(1765,3811,0.7884921),(1765,5854,0.812046),(1765,16010,0.22379284),(1765,29035,0.2619905),(1766,4817,0.10000629),(1766,11740,0.983001),(1766,13873,0.12795374),(1766,23763,1.8549452e-3),(1766,25435,0.9873222),(1766,27502,0.44929516),(1767,66,0.2918425),(1767,2405,0.16991797),(1768,4614,0.2434844),(1768,15058,0.80990285),(1769,5270,0.12199521),(1769,10291,0.8836852),(1769,10831,0.70588875),(1769,16552,0.5685753),(1769,30286,0.22671239),(1770,3874,0.5986177),(1770,16411,0.862939),(1770,20489,0.21918121),(1771,11238,0.3599346),(1771,11710,0.58641577),(1771,12572,7.2947316e-2),(1771,14225,0.93616843),(1771,17168,0.92281544),(1771,23842,0.7019534),(1771,28082,0.83424693),(1771,29341,0.36599162),(1772,2527,0.223311),(1772,5731,7.371713e-2),(1773,4514,0.88931155),(1773,13213,0.81426144),(1773,13439,0.9218619),(1773,13973,0.39727175),(1774,1724,0.90176797),(1774,2009,0.37206548),(1774,13126,0.89018327),(1774,17329,0.30611745),(1774,28202,0.7099296),(1774,30288,0.77036375),(1775,9112,0.9925274),(1775,13734,0.28521377),(1775,20256,0.79061675),(1775,25730,0.13741538),(1775,28099,0.60848814),(1776,5543,0.66377974),(1776,26218,0.8590892),(1777,9846,0.32399055),(1777,13288,0.9549899),(1777,14771,0.48348147),(1777,25537,0.1080816),(1777,26752,0.5978489),(1777,31796,0.77122694),(1778,6276,0.99179196),(1778,9695,0.62646496),(1778,14124,0.53020984),(1778,18231,0.57222223),(1778,20485,0.26014417),(1778,20535,0.7711406),(1778,24189,0.263322),(1779,18136,0.51261157),(1779,19191,0.14177951),(1779,20176,0.29417694),(1779,29552,0.279103),(1779,30594,0.91877615),(1780,5842,0.8053092),(1780,6845,0.78913623),(1781,4259,0.9583914),(1781,11325,0.91420984),(1781,18697,0.7993771),(1781,22899,0.37911025),(1781,23581,0.8256274),(1783,5695,0.78191984),(1783,9986,0.18555),(1783,11756,0.112677045),(1783,13469,6.0027007e-2),(1783,29468,3.1738836e-2),(1784,15341,5.8165103e-2),(1784,26632,3.534235e-2),(1784,26690,0.5926105),(1784,28254,0.8381309),(1784,30541,0.19040579),(1785,2877,0.54712874),(1785,9966,3.5023283e-2),(1785,12398,7.064855e-2),(1785,14257,0.4350789),(1785,24052,0.90333647),(1785,25060,0.90485466),(1786,1452,0.45900616),(1786,10942,0.48012343),(1786,16491,0.75253063),(1786,16689,0.3081163),(1786,30568,0.3480206),(1786,31216,3.2124363e-2),(1787,3731,0.41922653),(1787,6706,0.62334317),(1787,15798,0.8991616),(1787,17016,0.12574862),(1787,29075,0.2890011),(1788,1114,0.5432017),(1788,13112,0.4245901),(1788,16149,0.7275895),(1788,17565,0.89537865),(1788,20839,0.37033352),(1788,30298,0.9237367),(1789,11455,0.3769326),(1789,15288,0.8035894),(1789,22386,0.22543909),(1790,13,0.549582),(1790,1966,0.59169185),(1791,2360,0.67637205),(1791,10614,9.296386e-2),(1791,12421,0.48219922),(1791,17178,0.4081284),(1791,19837,4.682625e-2),(1791,29302,0.38160095),(1792,20597,0.5002068),(1792,29660,0.84381723),(1793,13416,0.9041012),(1793,15239,0.27939236),(1794,70,0.17264386),(1794,3363,0.3196281),(1794,14388,0.4597175),(1794,14592,0.4236169),(1794,15163,8.164325e-2),(1794,19334,0.46925044),(1794,28633,0.84503204),(1795,1162,1.5649023e-2),(1795,10179,0.3351257),(1795,26459,0.7338863),(1795,31710,0.34457794),(1795,32566,0.8052959),(1796,1095,0.95186156),(1796,5189,0.788716),(1796,8783,0.789697),(1796,9876,0.8940359),(1796,18747,0.31748328),(1796,32680,0.3147722),(1797,2270,0.6340461),(1797,2669,0.72237355),(1797,11330,0.84121037),(1797,12154,1.9499628e-2),(1797,15805,0.22746745),(1797,27796,6.336842e-2),(1798,10767,0.4628338),(1798,11308,7.349924e-2),(1798,24855,0.98741156),(1799,11231,0.9672537),(1799,19917,0.9854208),(1800,8517,0.45696297),(1800,12338,0.14476308),(1800,13474,4.7164005e-3),(1800,15284,0.67480063),(1800,18692,0.33586225),(1801,16831,0.9421584),(1802,3222,0.2739541),(1802,31617,3.408427e-2),(1802,32170,0.90711266),(1803,10454,0.24393828),(1803,24497,0.66962993),(1803,28795,0.90335345),(1803,29156,0.9361993),(1804,10407,0.46411553),(1804,13746,0.17735219),(1804,15922,0.3059805),(1804,21178,0.3268973),(1804,32643,0.5505276),(1805,19974,0.93611103),(1805,22326,0.5343973),(1805,24647,0.57453555),(1806,21948,0.51154),(1806,25763,0.5165034),(1807,503,0.5328518),(1807,3879,0.46666703),(1807,4858,2.3829728e-2),(1807,20282,0.8897271),(1807,23372,0.21428932),(1808,26794,0.7228542),(1808,29648,0.10740417),(1809,5377,0.45427126),(1809,13798,0.13828848),(1809,19096,0.75279856),(1809,19637,0.39744997),(1809,26696,0.18355587),(1809,27665,0.4531548),(1809,28856,0.28748918),(1810,1384,0.8840581),(1810,6405,0.7420046),(1810,11396,0.44469094),(1810,11432,0.79626113),(1810,15076,0.7236245),(1811,1119,0.55117357),(1811,21330,0.6683242),(1811,23077,0.83832353),(1811,25956,0.8652393),(1812,1029,0.37077883),(1812,3078,0.45204082),(1812,6464,0.69390255),(1812,11276,0.6048258),(1812,21034,0.3685535),(1813,11655,0.25577316),(1813,25314,0.59016895),(1813,25628,0.25643057),(1815,5024,0.8741777),(1815,11908,3.136838e-2),(1815,17472,6.437167e-2),(1815,17964,0.5733459),(1815,20027,9.218243e-2),(1815,20563,0.6233166),(1815,31818,0.567535),(1815,32415,0.51187366),(1816,899,0.17524365),(1816,15611,0.30122417),(1816,17343,0.5353569),(1817,3752,0.36940846),(1817,14657,0.46019086),(1817,20379,0.76839465),(1817,23203,0.111265376),(1817,24317,0.73315984),(1817,25961,0.56091505),(1817,28972,0.5727469),(1817,30689,0.7225942),(1818,20070,0.47355595),(1818,21257,0.8106633),(1818,26519,0.8608149),(1818,26546,0.8272341),(1819,5452,0.2881591),(1819,7552,0.19454989),(1819,12055,0.5934559),(1819,16374,2.97684e-2),(1819,22560,0.6803319),(1819,25443,0.7467654),(1820,14773,0.5391753),(1820,31118,0.40738344),(1821,5115,0.66323024),(1822,3715,0.41151062),(1822,4119,0.101260744),(1822,8028,0.9006797),(1822,8821,1.092755e-2),(1822,10253,0.67962307),(1822,11721,0.85052574),(1822,22607,0.3749169),(1823,4089,9.436275e-2),(1823,5041,0.34000897),(1823,19701,0.6882031),(1823,28049,0.6923016),(1824,15692,0.93584305),(1824,16009,8.4527075e-2),(1824,28841,0.2193194),(1824,29879,0.42667413),(1824,29903,0.72822624),(1824,32602,9.218552e-2),(1825,199,0.8060865),(1825,6321,7.071671e-2),(1825,7359,0.8121039),(1825,29186,0.8576522),(1825,31924,7.941748e-3),(1826,4187,0.9538314),(1826,12092,0.85123354),(1827,13695,0.74437165),(1827,14186,0.9863346),(1827,14788,0.93501306),(1827,22532,0.3706881),(1828,14269,0.5080258),(1829,10812,7.2122156e-4),(1829,24166,0.89947516),(1830,16594,0.24840322),(1830,18496,0.2800347),(1831,57,0.1764963),(1831,3735,0.56049675),(1831,24307,5.586874e-2),(1831,31691,0.19742031),(1832,27261,0.6134908),(1832,32442,0.25674015),(1833,376,0.8684359),(1833,430,0.9104767),(1833,15019,0.59396917),(1834,10216,0.14581232),(1835,17065,0.66985935),(1835,21514,0.91869986),(1836,10247,0.21907905),(1836,14867,0.78560585),(1836,24069,0.18967427),(1836,27089,0.8375565),(1836,28233,0.8096232),(1837,472,0.73873115),(1837,6046,0.4901595),(1837,9398,0.5897628),(1837,26422,0.73081475),(1837,28631,0.23486578),(1838,9190,0.9124952),(1838,14525,0.28459018),(1838,15938,0.6927439),(1838,16432,0.7558071),(1838,18542,0.622137),(1838,23050,8.619036e-2),(1839,3398,1.2609437e-2),(1839,17697,0.8984752),(1839,25546,0.9753617),(1839,27147,0.4046678),(1839,28263,0.78912807),(1840,5888,0.843371),(1840,22743,0.6438123),(1840,23319,0.43871778),(1840,28392,0.7200916),(1841,8184,0.24172829),(1841,13636,0.4459177),(1841,27042,0.28103203),(1842,7576,0.14511496),(1842,11786,0.95824087),(1843,9018,0.73436564),(1843,15128,9.425488e-2),(1843,19396,0.97926897),(1843,20821,0.4950272),(1844,6596,0.40296218),(1844,8852,0.2742919),(1844,17132,0.7478964),(1844,17719,0.6136397),(1844,22093,0.3577834),(1845,4131,0.39185005),(1845,4913,0.989686),(1845,10124,0.6496917),(1845,23505,3.4007937e-2),(1845,27983,0.7913908),(1845,29430,0.6879988),(1845,29869,0.7224568),(1846,3870,0.7053524),(1846,8153,0.4779066),(1846,9278,0.76996017),(1846,11330,0.6452236),(1846,19851,6.941873e-2),(1846,20631,0.30519485),(1846,26466,0.26735342),(1847,14187,0.91312826),(1847,17383,9.487519e-2),(1847,17458,8.1191495e-2),(1847,18619,0.4412151),(1847,24640,0.51074046),(1847,26585,0.58432645),(1847,30568,9.117094e-2),(1847,32326,7.523866e-2),(1848,6184,0.3174489),(1848,7808,0.39312294),(1848,13754,0.73757714),(1848,23276,0.7677815),(1849,24671,0.30474198),(1849,27287,0.8732674),(1849,30844,0.36787632),(1850,15033,0.76655203),(1850,19528,0.8414439),(1850,26612,0.3918392),(1850,31440,0.99066675),(1851,7761,1.5837388e-2),(1851,16941,0.5031416),(1851,23892,0.2506488),(1851,27086,0.981792),(1851,31024,0.29379016),(1852,23869,0.9160285),(1852,29582,0.2836827),(1853,1029,0.2637737),(1853,4894,0.16960338),(1853,12593,7.480682e-2),(1854,4457,0.16567881),(1854,8766,0.41777068),(1854,18282,0.59875786),(1854,30671,0.9002314),(1854,32142,0.39206865),(1855,10596,0.9689689),(1855,13212,0.5450918),(1855,21835,0.64742357),(1855,23381,0.867309),(1856,6195,0.17134942),(1856,18990,0.49846527),(1857,9223,1.690723e-2),(1857,25692,0.8385405),(1858,2517,0.8790562),(1858,3782,0.21769688),(1858,5155,0.5043945),(1858,8067,0.7013993),(1858,11661,1.7708633e-2),(1858,22259,0.17042737),(1859,2708,0.49080974),(1859,11650,0.6140799),(1859,16790,3.317663e-2),(1859,18272,0.46841386),(1859,19276,0.4609232),(1860,3273,0.37086302),(1860,4018,0.19087419),(1860,8044,0.24290885),(1860,16458,0.19644837),(1860,18996,5.746684e-2),(1860,25750,0.9593897),(1860,27345,0.72676265),(1861,16867,0.80010545),(1861,29894,0.3608744),(1862,3006,0.21946996),(1862,24197,0.5007659),(1862,32585,0.5238306),(1863,7352,0.13901325),(1863,12874,0.40209717),(1863,15881,3.8295437e-2),(1863,27913,0.66313416),(1863,29974,0.3257445),(1864,9382,0.6339548),(1864,21644,0.3736784),(1864,22704,0.57809204),(1864,25881,6.528244e-2),(1864,27687,0.14936937),(1865,22755,0.7067184),(1866,3502,0.9484946),(1866,4033,0.295726),(1866,4726,6.4111896e-2),(1866,20461,0.7219672),(1866,26993,0.85856813),(1867,3432,0.64692193),(1867,11327,2.8041901e-2),(1867,11379,0.36859185),(1867,16345,0.4190376),(1867,22152,0.21275276),(1868,8178,0.6688057),(1868,13325,0.26053628),(1868,18315,9.713209e-2),(1868,18458,0.7358591),(1869,4596,0.38442367),(1869,15077,0.32489094),(1870,5490,0.6678752),(1871,10939,5.3776756e-2),(1871,21540,0.32188696),(1871,26323,0.30010378),(1871,31289,2.4216179e-2),(1872,2563,0.43642357),(1872,3376,0.5055354),(1872,5956,8.206938e-2),(1872,30713,0.18953179),(1872,31616,0.63877326),(1873,5741,0.15398186),(1873,11576,0.5922141),(1874,8876,0.5068546),(1874,13842,0.5479942),(1874,17292,0.48388737),(1874,17293,0.9116407),(1874,19811,0.9649678),(1875,2669,0.6722757),(1875,8840,0.26202342),(1875,17852,0.6666231),(1876,5210,0.3436739),(1876,5726,0.7779895),(1876,5794,0.101633236),(1876,6303,2.330855e-2),(1876,8896,0.28411376),(1876,9690,0.5587694),(1876,18913,0.77913374),(1876,27454,0.6532719),(1877,10954,0.9777069),(1877,14797,0.32603472),(1877,15999,0.46608782),(1877,22793,0.64039266),(1877,31385,0.1457063),(1878,7763,0.15116772),(1878,32431,0.43044564),(1879,5243,0.8076318),(1879,7694,0.1435735),(1879,9068,0.91759396),(1879,10237,0.5253329),(1879,11103,0.6275161),(1879,11502,0.29678535),(1879,12606,0.33869785),(1879,16287,0.70329934),(1879,25097,0.16234905),(1880,5760,0.21344256),(1880,26821,6.515302e-2),(1880,27861,0.50932354),(1880,31238,0.7548088),(1881,3033,0.81467044),(1881,13359,0.8841559),(1881,14899,0.92297214),(1881,15065,0.5843877),(1882,2510,0.17488901),(1882,16675,0.18094368),(1882,18096,0.29491514),(1882,30174,0.8296894),(1883,5124,0.2665504),(1883,10007,9.6868865e-2),(1883,13834,0.6624269),(1884,9928,0.42864278),(1884,14071,0.82909983),(1884,21462,0.6602542),(1884,26067,0.6490481),(1885,5425,0.8103183),(1885,13710,0.4267041),(1885,23337,0.63063085),(1885,25933,0.55900246),(1886,6731,4.4539127e-2),(1886,13643,5.347959e-2),(1886,17242,3.9153367e-2),(1887,3594,0.14074978),(1887,9185,0.31407213),(1887,10862,7.685823e-2),(1887,26489,3.1271573e-2),(1888,7250,0.47063595),(1888,10568,9.1987655e-2),(1888,28267,0.3723042),(1889,9480,0.6296893),(1889,11373,0.3612372),(1889,18106,0.20313938),(1890,7640,3.916673e-2),(1890,20877,0.23187453),(1890,21876,0.44330233),(1891,11221,0.6173257),(1891,12371,9.5335424e-2),(1891,13840,0.75477916),(1891,16977,0.14592579),(1891,19982,0.38779694),(1891,30882,0.5092674),(1892,6724,0.95660067),(1892,17462,0.83236665),(1892,19527,0.48129645),(1892,21124,0.3107248),(1892,23190,0.16416231),(1893,22570,0.8852935),(1893,30743,0.2109609),(1894,25488,0.70255345),(1895,8308,0.23935564),(1895,8746,0.8440259),(1895,19812,0.809965),(1895,20937,0.71523875),(1895,22023,0.5591423),(1895,22522,0.51590925),(1895,23073,0.24156715),(1895,26700,0.67571765),(1895,31741,0.976409),(1896,26585,0.965305),(1897,2980,0.7380961),(1897,11336,0.6417073),(1898,8617,0.31253612),(1898,14540,0.40202263),(1898,25026,0.8456064),(1898,25758,0.84448075),(1898,30378,0.29986182),(1899,10224,5.3686205e-2),(1899,22272,0.41293123),(1899,24782,0.37180728),(1900,26,0.832154),(1900,1865,1.6031759e-2),(1900,2367,0.45690826),(1900,4202,0.7920613),(1900,7363,0.54346025),(1900,22277,0.515129),(1900,25723,0.73273426),(1900,29971,0.96220845),(1900,32503,7.3425874e-2),(1902,13573,0.48311096),(1902,22777,0.18102331),(1902,26457,0.2936525),(1903,12066,0.99517125),(1903,15133,0.804321),(1903,24171,0.38774538),(1903,24999,0.6530188),(1904,25281,0.45509133),(1904,32660,0.27919376),(1905,4316,0.34892073),(1905,7463,0.6047829),(1905,12149,0.30534753),(1905,18102,0.41429088),(1905,22701,0.66742957),(1905,30121,0.4858812),(1905,30997,0.6798066),(1906,12408,0.30893338),(1906,25056,0.22381194),(1906,25497,0.6287711),(1906,25555,0.73001313),(1906,28561,0.46460402),(1907,1392,0.70544016),(1907,14349,0.86698455),(1908,4998,0.38396454),(1908,8331,8.665545e-2),(1908,26089,0.1233904),(1908,29963,0.27679008),(1908,32347,0.13992038),(1909,6168,0.24006714),(1909,25337,0.83411324),(1909,25700,0.37163314),(1910,4629,0.7400713),(1910,24411,0.17003794),(1911,644,0.22656795),(1911,7725,0.5605942),(1911,8838,0.681176),(1911,18430,2.5916569e-2),(1912,12618,0.26891658),(1912,18623,0.93630207),(1912,25527,0.87076056),(1912,26765,0.4712682),(1913,13725,0.8943887),(1913,19645,2.6180893e-2),(1914,4239,0.27258602),(1914,13772,0.71051586),(1914,16967,0.68378574),(1914,24796,0.9713167),(1914,26066,0.42093036),(1914,26868,0.69466126),(1914,32402,0.55658555),(1915,13592,0.9795862),(1915,20335,0.39688197),(1915,27392,0.9363276),(1916,1311,0.7136432),(1916,9382,0.18183103),(1916,11174,0.26851013),(1916,23808,0.8983577),(1916,24891,0.63856566),(1916,25795,0.6943875),(1917,13851,0.5509848),(1917,25924,0.48134708),(1918,3960,6.9536336e-2),(1918,26548,0.45355338),(1918,30244,0.14443876),(1918,30357,0.80275565),(1919,4065,1.6812734e-2),(1919,6749,0.8214437),(1919,9690,0.7849421),(1919,12690,0.14023645),(1919,15630,0.6190123),(1919,30809,0.62335205),(1920,11117,0.71352893),(1920,12732,6.417456e-2),(1920,14902,0.29610112),(1920,21919,0.6826279),(1920,22691,4.1352347e-2),(1920,28610,0.71603316),(1921,22784,0.83122224),(1921,25213,0.44039455),(1921,26294,0.18459602),(1921,29666,3.460295e-2),(1921,31666,0.3023191),(1922,4045,0.21326941),(1923,4820,0.14260638),(1923,10573,0.8325758),(1923,21029,1.6951006e-2),(1923,25458,0.6905621),(1924,12899,0.44665134),(1925,118,0.8477495),(1925,10716,0.29441398),(1925,17223,0.94180167),(1925,19284,0.7436023),(1925,28324,0.9667221),(1925,29620,0.22032934),(1926,12555,0.5237724),(1926,17816,0.7979163),(1926,21213,0.93940145),(1926,22479,0.119957566),(1926,25016,0.88410205),(1927,207,0.6888164),(1927,8794,0.30633053),(1927,11047,0.37100795),(1927,18615,0.6213573),(1927,22372,0.80217505),(1928,4540,0.20207927),(1928,6740,0.8673061),(1928,18696,0.1400767),(1928,27713,2.448175e-2),(1929,1289,0.16891888),(1929,3632,8.992054e-2),(1929,18518,6.810784e-2),(1929,23245,0.109568104),(1929,30958,0.5397637),(1930,11276,0.57381),(1930,26517,0.18090051),(1931,11654,0.23486029),(1931,14487,2.1269416e-2),(1931,19290,0.73177606),(1932,3075,0.7615351),(1932,10239,0.4278311),(1932,15381,0.7060784),(1932,15938,0.3028304),(1932,24052,0.8554413),(1932,27416,4.533874e-3),(1932,32136,0.5007773),(1933,9533,7.570982e-2),(1934,8892,0.84114975),(1934,30866,0.34111825),(1935,325,0.8935111),(1935,23758,0.8841914),(1935,24300,7.159481e-2),(1936,488,0.4443239),(1936,5447,0.5193461),(1936,7058,0.44947425),(1936,12715,0.7182012),(1936,19110,0.85352165),(1936,30978,0.7072059),(1936,32435,5.9800383e-2),(1937,7245,0.23283501),(1937,29980,0.9599331),(1937,32191,0.43318525),(1938,17779,0.8288594),(1938,18764,0.79644424),(1938,19836,0.85653687),(1938,23379,0.59386957),(1939,180,0.71841353),(1939,2236,0.79978037),(1939,24568,0.81585485),(1939,32456,0.894445),(1940,1330,0.11268968),(1940,10319,0.66935986),(1940,16617,0.8926806),(1941,3948,0.4446136),(1941,25314,0.804383),(1941,31138,7.830478e-2),(1942,1345,0.27126825),(1942,11271,0.15536334),(1942,12584,0.38463333),(1942,15180,4.5407593e-2),(1942,17990,0.9438857),(1942,18631,0.4219477),(1943,20837,0.6661477),(1943,23200,0.7161032),(1943,26510,0.49084887),(1944,566,0.28395203),(1944,2101,0.8532325),(1944,2118,9.8806225e-2),(1944,14555,0.13413247),(1944,16282,0.83352876),(1944,23889,0.5330583),(1944,24189,0.9606471),(1944,27336,0.13734725),(1944,31237,0.74998593),(1945,2773,0.14749674),(1945,6837,0.8407055),(1945,12318,0.9119872),(1945,15962,0.38725448),(1945,26722,0.5117443),(1945,26875,0.65911454),(1946,358,0.5340577),(1946,1315,0.51257926),(1946,11958,0.7104901),(1946,12310,0.6682523),(1946,15686,0.43291628),(1946,24107,0.6426682),(1947,8190,0.7237045),(1947,15632,0.56289583),(1947,21828,0.36724806),(1947,24588,0.7067424),(1947,26127,4.7822925e-3),(1947,28382,5.197486e-2),(1948,6657,0.7630966),(1948,11994,0.3258158),(1948,16220,0.37544173),(1948,22191,0.4738984),(1948,25038,0.58947283),(1949,4773,0.5318994),(1949,6675,0.21237572),(1949,16034,0.93799776),(1949,18880,0.117547736),(1949,21130,0.99988455),(1949,22668,0.9259359),(1949,28943,0.42691195),(1949,29041,0.38586333),(1949,29721,0.13039018),(1949,30607,0.9395224),(1950,10411,0.5679701),(1950,13101,0.18181849),(1950,27139,0.41891804),(1951,2263,0.47087166),(1951,3998,0.8731708),(1951,17243,0.99635345),(1951,28051,0.9386811),(1952,1923,0.3267532),(1952,2309,0.42082605),(1952,2989,0.66034406),(1952,4207,0.9344856),(1952,9220,0.5623411),(1952,25089,0.7474167),(1952,30841,0.21343169),(1953,1592,0.8694729),(1953,1888,0.49638078),(1953,6243,9.51166e-2),(1953,27953,0.7540471),(1953,31172,0.60531133),(1953,32654,0.2809606),(1954,23277,0.76613957),(1954,24296,0.84239566),(1955,217,0.2239172),(1955,2204,0.74070317),(1955,4993,0.21837011),(1955,17049,0.9068464),(1955,17211,0.39110458),(1955,17836,0.7198315),(1955,25777,0.3924327),(1955,27664,0.45824608),(1956,2326,5.5452153e-2),(1956,16454,0.16854724),(1956,16965,0.2631875),(1956,17624,0.59238964),(1957,10725,0.1999985),(1957,14517,1.0258865e-2),(1957,23673,0.5601802),(1958,7501,0.83235765),(1958,16902,0.5113945),(1958,20667,0.82201064),(1958,28008,0.7142392),(1958,32035,0.6673056),(1959,20319,0.5532331),(1959,25156,0.7913041),(1960,4284,0.27228436),(1960,6598,0.86480796),(1960,17399,0.5469818),(1960,22693,3.709817e-2),(1960,27857,0.18507569),(1961,1372,0.40643495),(1961,12131,4.8830185e-2),(1961,21086,0.24590257),(1961,30027,0.24789177),(1962,8563,0.5065209),(1963,5761,0.5835684),(1963,10232,0.638211),(1963,17255,0.30237195),(1963,18917,0.8251507),(1963,25642,0.1703919),(1964,5505,0.1396687),(1964,13031,0.22622375),(1964,18947,0.42426777),(1964,19720,0.9928299),(1965,4861,3.2465268e-2),(1965,5563,0.62481594),(1966,26761,0.3957754),(1967,3574,0.7117369),(1967,10011,0.42750716),(1967,27859,0.6049308),(1968,2923,0.4832067),(1968,8526,9.4786935e-2),(1968,30213,0.80274767),(1969,1980,0.5522815),(1969,8393,0.41721088),(1969,17875,0.8723479),(1969,26192,0.52141434),(1969,32629,0.81520253),(1970,5358,0.9474698),(1970,9802,0.11976167),(1970,15497,0.37168545),(1970,22118,0.59577256),(1970,22901,0.85806996),(1970,25613,9.356417e-2),(1971,16417,0.39170313),(1971,17073,0.11576187),(1971,20397,1.4607343e-2),(1971,24701,0.1504009),(1971,30921,0.9785248),(1972,14811,0.52729577),(1972,17377,0.949662),(1972,26340,0.474411),(1973,9494,0.51539487),(1973,11583,0.6207083),(1974,9824,0.49555865),(1974,31236,0.21681353),(1975,2017,0.15098514),(1975,16182,0.2154874),(1975,22991,0.27983955),(1975,29654,0.9435338),(1975,32304,0.38352835),(1976,18670,0.31284052),(1976,23588,0.48180106),(1977,2394,0.4961774),(1977,14468,7.868e-2),(1977,15298,0.26998124),(1977,15922,0.5049638),(1977,22825,0.36536187),(1977,28886,0.7083163),(1977,31398,0.2097188),(1977,31776,0.13628109),(1977,31869,0.9921089),(1978,7389,0.20850234),(1978,20256,0.250923),(1978,30793,0.61472785),(1978,31007,0.72273636),(1979,13238,4.6264775e-2),(1979,18422,0.26375845),(1980,24657,0.2639411),(1980,28116,1.7573755e-2),(1981,1058,1.9246032e-2),(1981,5315,0.380647),(1981,10166,0.9070552),(1981,17250,0.31855989),(1981,28723,8.324986e-2),(1981,28945,0.97221506),(1982,309,0.22460234),(1982,15184,0.13433279),(1982,25981,0.83268416),(1983,1938,0.86608785),(1983,2954,7.657328e-2),(1983,3113,1.3255228e-3),(1983,16800,0.6561783),(1983,21242,0.75963694),(1983,24302,0.4121541),(1983,28786,0.13528144),(1984,1136,0.17205304),(1984,1334,5.8048964e-2),(1984,6013,0.25015867),(1984,11159,0.9672991),(1984,19750,1.1886238e-2),(1984,23523,0.14114912),(1984,26931,0.5079267),(1984,30150,0.2612367),(1985,2128,0.93303066),(1985,14961,0.92609966),(1985,15435,0.54081506),(1986,9349,0.37844506),(1986,22342,0.6288233),(1987,1077,0.436355),(1987,20177,2.0609219e-2),(1987,29202,0.8353715),(1987,30796,0.72352105),(1988,240,1.8479144e-2),(1988,1656,0.78520584),(1988,7130,0.3139568),(1988,17020,0.5529745),(1988,28305,0.9604512),(1989,4208,0.9964873),(1989,19934,0.11896173),(1989,20547,0.41056886),(1989,29285,5.085353e-2),(1990,4434,0.76536554),(1990,5887,0.97246706),(1990,6350,0.72553414),(1990,18408,0.91045976),(1990,31555,0.6846385),(1991,19058,1.3230297e-2),(1991,22188,0.13399382),(1992,15318,0.56991994),(1993,25388,0.99508035),(1994,6872,0.4341809),(1994,11827,0.21216658),(1994,14431,0.43273917),(1994,17097,0.16869298),(1994,18067,0.74572134),(1994,19941,0.735614),(1994,23115,9.405861e-2),(1994,27844,0.15054168),(1995,852,0.6397414),(1995,18424,0.6069786),(1995,18992,0.628748),(1996,27505,1.7407505e-2),(1997,4631,0.6807061),(1997,7565,0.4987719),(1997,23003,7.9930685e-2),(1997,25969,0.65506023),(1998,1245,0.5121728),(1999,5275,0.39876953),(1999,12656,0.22012605),(1999,30926,0.8826042),(2000,5044,0.5850625),(2000,15883,0.7832365),(2000,16565,0.30738065),(2000,19393,8.8015184e-2),(2000,27663,0.44292405),(2001,2249,0.29494166),(2001,3822,0.16040477),(2001,19448,0.66383636),(2001,25561,0.7701067),(2001,30836,0.48733678),(2002,300,0.11879216),(2003,7487,0.52597505),(2003,10124,0.56958693),(2003,25430,0.4542357),(2004,5298,0.57365835),(2004,13243,0.113195315),(2004,17018,0.33948457),(2004,21752,0.95537),(2004,26418,0.6074789),(2005,6456,0.296083),(2005,8256,0.23655407),(2005,10332,0.718316),(2006,15114,0.9480186),(2007,8697,0.30033305),(2007,13370,0.8044591),(2007,14666,0.4403691),(2007,15552,0.25598392),(2007,21449,0.83422166),(2007,31483,0.25680643),(2008,2310,0.6666976),(2008,9330,0.9638763),(2008,11728,0.54877245),(2008,14005,0.543922),(2008,20832,0.77503633),(2009,27516,5.0215077e-2),(2010,11159,0.25997373),(2010,11609,0.76538223),(2010,15192,0.32792443),(2010,24899,0.30917153),(2010,25455,0.3465545),(2011,3532,0.19522476),(2011,6471,0.70014393),(2011,12770,0.54171085),(2012,737,0.3827826),(2012,11323,0.35344794),(2012,12897,0.5255434),(2012,15358,0.13382235),(2012,19253,0.52060556),(2013,3207,0.26424167),(2013,4044,0.9576117),(2013,7399,0.4758561),(2013,17091,0.1560254),(2013,29119,0.61380947),(2013,32245,0.42175937),(2014,2697,2.1890118e-3),(2014,15168,0.9780766),(2014,15657,0.9030503),(2014,27405,0.49594158),(2015,13389,0.46344215),(2015,23643,0.35628188),(2015,24145,0.3211999),(2015,31131,0.7179324),(2016,25126,0.82700974),(2017,853,0.5574672),(2017,6477,1.8582895e-2),(2017,14807,0.18544896),(2017,23796,0.38275903),(2018,27891,6.2848255e-2),(2019,3905,0.8298179),(2019,5810,0.71644694),(2019,21710,0.82881135),(2020,14531,0.98255485),(2020,15522,0.27129346),(2020,24248,0.21296185),(2020,31482,0.43701884),(2021,462,0.36964437),(2021,4835,0.46489713),(2021,4896,9.923649e-3),(2021,15639,0.9867086),(2021,23040,0.5184528),(2021,23059,0.42107227),(2021,26663,0.69617784),(2021,32324,0.5097702),(2021,32689,0.9211287),(2022,5185,0.56683517),(2022,31147,0.82010347),(2023,18870,0.72689116),(2023,19123,3.9889183e-2),(2023,19453,0.5579452),(2023,22167,0.20036636),(2023,22519,0.47458312),(2023,22675,0.19525106),(2023,32133,0.91497415),(2024,20249,0.14918378),(2024,21552,0.64405525),(2026,16157,2.8858334e-2),(2026,17872,0.19612685),(2026,21830,0.38417634),(2026,28578,0.38765243),(2026,30230,0.28266025),(2027,20923,0.20771593),(2027,29883,0.11587493),(2027,32139,0.6686654),(2028,13583,0.7261832),(2028,22073,0.7874559),(2029,3338,0.15924269),(2029,10607,0.73098475),(2029,14068,5.064334e-2),(2029,28891,0.9420739),(2029,29028,3.5386123e-2),(2031,8136,0.40135103),(2031,19657,0.1658639),(2031,32235,0.9832638),(2032,27363,0.12238208),(2032,27853,0.51735944),(2032,31600,0.9885736),(2033,12147,0.50085735),(2034,16649,0.855978),(2035,2761,0.8522139),(2035,6155,0.83943886),(2035,15555,0.8702236),(2035,23408,0.83110553),(2036,8279,0.6774504),(2036,13868,0.505542),(2036,25487,0.26954958),(2036,26189,0.71020854),(2037,2776,0.5876845),(2037,6041,0.7690013),(2037,25119,0.42869636),(2038,3472,7.139376e-2),(2038,6390,0.45123124),(2038,9678,0.21957637),(2038,17041,0.84521604),(2038,29333,0.22968444),(2039,19343,0.4184245),(2039,22854,0.5508149),(2039,32423,8.489993e-2),(2040,2184,0.9168562),(2040,6084,0.85990137),(2040,9537,0.7667617),(2040,14797,0.74044675),(2040,31848,0.8167821),(2041,12038,0.34933984),(2041,14964,0.446206),(2041,23849,0.27001375),(2041,29957,0.3366607),(2041,32190,8.812848e-2),(2042,4545,0.5462945),(2042,10072,0.52422774),(2042,21130,0.8160994),(2042,23859,0.31631523),(2042,30338,0.46506184),(2043,1285,0.30225778),(2043,2024,0.63524485),(2043,5390,0.6163702),(2043,9138,0.9331869),(2043,29204,0.6916182),(2043,32544,0.65828604),(2044,9139,0.7438498),(2044,20694,0.5632508),(2044,22792,0.22326872),(2044,28094,0.6024019),(2044,28263,0.5305289),(2045,7170,0.5718978),(2045,12347,0.121392116),(2045,21039,0.9911171),(2045,23444,0.57257825),(2045,30674,0.98439443),(2046,116,0.470584),(2046,2468,0.8442143),(2046,10802,0.49797833),(2047,20945,0.13068493),(2047,30727,0.80627674),(2048,16997,0.7476717),(2048,20530,0.82430595),(2048,21780,0.6731062),(2048,22305,0.7715749),(2048,27228,0.33773303),(2048,30525,0.597832),(2048,32306,0.8712519),(2048,32624,0.31246194),(2049,872,0.15376773),(2049,16569,0.5676179),(2049,20485,0.8287485),(2049,29760,0.99206895),(2050,26138,0.40015703),(2050,29028,0.23645185),(2051,12790,0.1713749),(2051,16111,0.6584192),(2052,10496,0.24302179),(2052,29149,7.427114e-3),(2053,1936,0.61529654),(2053,19124,0.53902805),(2053,26592,0.21658394),(2053,27081,0.67048794),(2054,6118,0.3943064),(2054,8237,0.2997521),(2054,9859,0.6910744),(2054,14301,0.20127958),(2054,29088,0.8245392),(2055,5547,0.490066),(2055,11502,0.46567354),(2055,14497,0.5601338),(2055,17559,0.6224036),(2055,22902,2.346096e-2),(2055,31336,0.5382126),(2056,20541,0.7609067),(2056,22885,0.9891261),(2056,23853,8.2092606e-2),(2057,16195,0.4419934),(2057,29026,0.34727004),(2057,29545,0.5121991),(2057,32176,0.85198003),(2058,5399,0.88380045),(2058,20307,0.3752198),(2059,7051,0.37966326),(2059,25355,3.9896267e-3),(2060,1530,0.5562112),(2060,7404,0.917359),(2060,14084,0.46257272),(2060,14444,0.27401832),(2060,30923,0.43826473),(2061,11089,0.32891354),(2061,27079,0.84264165),(2062,10522,0.5309947),(2062,20029,9.601341e-2),(2062,24289,0.86446726),(2062,24490,0.6169071),(2063,842,0.1946996),(2063,12016,5.2488368e-2),(2063,14253,0.26763663),(2063,14959,0.34835005),(2063,30218,0.92958736),(2064,3149,0.5932756),(2064,25254,0.23182696),(2065,6520,0.10189603),(2065,10004,0.8755263),(2065,25280,0.6750206),(2065,26029,0.4790928),(2066,7464,0.5645416),(2066,16543,0.24927811),(2066,18157,0.4514613),(2067,15529,0.37975988),(2067,21926,0.22780038),(2067,22474,0.22387925),(2067,27993,0.31743628),(2067,29855,0.68687147),(2068,22733,6.1641075e-2),(2068,28659,0.91483575),(2069,14993,0.30985743),(2069,16962,0.5411303),(2070,6270,0.13562435),(2070,11950,0.26301825),(2070,15206,0.6638308),(2070,16870,0.8867364),(2071,7783,0.2028004),(2072,10067,3.4015585e-2),(2072,13273,0.15550646),(2072,15755,0.9920795),(2072,16627,0.5731733),(2073,4312,0.31472063),(2073,14958,0.6774903),(2073,20843,0.68193847),(2073,27962,0.430374),(2074,5856,0.5405511),(2074,9040,0.52416015),(2074,24542,0.58142984),(2075,2725,0.36704507),(2075,11144,0.18753083),(2075,16537,3.796158e-2),(2075,25486,0.35545173),(2075,26161,0.23473588),(2076,6497,0.9623947),(2076,7457,0.9420531),(2076,10032,0.8837937),(2076,20861,0.40035096),(2077,10206,0.1929843),(2077,11414,0.341973),(2077,14944,0.99057454),(2077,18349,0.88188696),(2077,26211,0.22506532),(2078,9805,0.64169896),(2078,12060,0.3020306),(2078,23878,0.9114338),(2079,2163,0.49089625),(2079,14459,0.5473764),(2079,18033,0.98335177),(2080,18847,0.5262391),(2081,24555,0.5671191),(2081,30912,0.90387374),(2082,3034,0.7634462),(2082,23750,0.39402935),(2082,28857,0.49473736),(2082,29338,1.3126922e-2),(2083,20581,0.84227854),(2083,30682,0.19357345),(2084,1669,0.11113633),(2084,2851,0.31043005),(2084,15211,0.39417315),(2084,25775,0.9712441),(2085,4242,0.54378575),(2085,16423,0.7562973),(2085,22014,0.8984105),(2085,29528,0.5451955),(2085,31068,0.73769504),(2086,15367,0.34000075),(2086,20737,0.63927996),(2086,32216,0.84265524),(2087,20280,0.8060704),(2088,1148,0.33852518),(2088,2769,0.58851296),(2088,4788,0.5968491),(2088,23719,0.775498),(2088,26883,0.5713828),(2088,28355,0.54793406),(2088,30510,1.7041476e-2),(2089,7094,0.8518948),(2089,11860,0.3017851),(2089,13067,5.372377e-2),(2089,14901,0.32522625),(2089,17212,0.9527862),(2089,27399,0.9062602),(2090,3931,0.56223327),(2090,7547,0.9591333),(2090,11733,0.14242627),(2090,13340,8.934293e-2),(2090,19518,0.31980607),(2091,19749,9.460685e-3),(2091,28696,0.6121941),(2092,660,0.3282729),(2092,7419,0.8112899),(2092,13546,0.52841437),(2092,13774,0.5808098),(2092,19403,0.79779446),(2092,22323,0.8967827),(2092,29061,0.7356727),(2093,9243,3.2819957e-2),(2093,13814,0.9171178),(2094,10351,0.2133366),(2094,10357,0.8212244),(2095,1941,1.1522756e-2),(2095,4381,0.9633355),(2095,5200,0.88233584),(2095,9640,0.7267356),(2095,23758,0.26367196),(2095,28626,0.58435476),(2096,1306,0.7546942),(2096,16841,5.102555e-2),(2097,2254,0.9728579),(2097,9645,0.8114691),(2097,13304,0.14781326),(2098,3091,0.66816956),(2098,11911,0.8815071),(2098,13843,0.6985444),(2098,23961,0.29057366),(2099,12075,0.8321457),(2099,18401,0.63877356),(2100,9204,0.8212578),(2100,20836,3.3608705e-2),(2100,20899,0.6241159),(2100,30000,0.834831),(2101,8474,0.3039478),(2101,8591,0.2563946),(2101,9186,0.47144184),(2101,10713,0.9282228),(2101,11755,0.87493306),(2101,16723,0.50865597),(2101,19346,5.3246338e-2),(2101,20494,0.6696513),(2101,23325,0.3253184),(2101,26587,0.28666252),(2102,5162,9.768952e-2),(2102,7970,0.5521483),(2102,13192,0.49299705),(2102,20991,0.6619931),(2102,31271,0.32794032),(2103,6191,5.1645905e-2),(2103,6485,0.685267),(2103,7462,0.6897184),(2103,13322,0.47945514),(2103,18602,0.6604923),(2103,18837,0.31594896),(2103,19395,0.17613995),(2103,23549,4.8738517e-2),(2104,9697,0.19468157),(2104,10809,0.9031526),(2104,13177,0.9105123),(2104,19253,0.4695296),(2104,19953,0.70164865),(2104,30627,0.33887574),(2104,32452,0.46755952),(2105,12678,0.2888652),(2105,28956,0.6508567),(2105,29998,0.92712915),(2106,7023,0.7152195),(2106,9667,4.4990323e-2),(2106,19975,0.76404214),(2107,22017,0.9495926),(2107,28674,0.8832019),(2108,2867,0.22295895),(2108,19205,0.43670562),(2108,24151,3.8749797e-3),(2108,26027,0.7372527),(2109,5698,0.5711578),(2109,7978,7.6137274e-3),(2109,8934,0.3542829),(2109,9841,0.79226583),(2109,14933,0.799922),(2109,24274,0.22869463),(2110,17531,0.8716984),(2110,19465,7.6129325e-2),(2110,22337,0.65798837),(2110,31503,0.6978794),(2111,26416,0.773733),(2112,4141,0.88973355),(2112,9818,0.78475857),(2112,19719,0.3465458),(2113,14291,0.59037864),(2113,17598,0.60699075),(2113,24036,0.74527186),(2113,24234,0.52761686),(2114,9999,0.61786586),(2114,27527,0.4019286),(2115,9326,0.23784457),(2115,18366,0.7718312),(2115,27640,0.8792955),(2116,10326,0.72849256),(2117,2831,0.45555758),(2117,8979,9.530017e-2),(2117,10046,6.472643e-3),(2117,13257,0.54895294),(2117,18827,0.5925973),(2117,22724,0.3861263),(2118,4348,0.16501606),(2118,21768,0.2627124),(2118,22577,0.7714802),(2118,23858,0.38083842),(2119,349,4.8322342e-2),(2119,1668,0.10553675),(2119,1722,0.792018),(2119,4890,0.5279807),(2119,7046,0.85678715),(2119,8515,0.6472537),(2119,8728,0.7773043),(2119,9810,0.84110993),(2119,11325,0.49530149),(2119,13012,0.5660488),(2119,19830,0.37771842),(2119,28202,3.8013826e-3),(2120,28993,0.1556991),(2121,8754,0.18237853),(2122,977,0.72888106),(2122,2134,0.95548445),(2122,4621,0.4376452),(2122,5290,0.6307546),(2122,5632,0.9076736),(2122,22139,0.56871456),(2123,2432,7.0976935e-2),(2123,4192,0.28139338),(2123,29687,0.41829395),(2124,9115,0.5195028),(2124,16359,0.4779824),(2125,1709,0.967377),(2125,6824,0.19066967),(2125,8940,0.3785677),(2125,26588,0.73733634),(2125,29612,0.32972485),(2125,31050,0.455053),(2126,312,0.9754713),(2126,787,0.62211645),(2126,1015,7.913639e-2),(2126,28178,0.44310644),(2127,20398,0.5027819),(2127,22509,0.7691243),(2127,29267,0.43152988),(2127,30125,0.6427932),(2127,32480,0.92461264),(2127,32725,0.5940288),(2128,3397,0.79151917),(2128,3821,9.554523e-2),(2128,13820,8.05766e-2),(2128,26628,0.107469246),(2129,1880,2.0310411e-2),(2129,6078,0.5296783),(2129,15981,0.11644347),(2129,21871,0.7443195),(2129,28571,0.6189717),(2129,31985,0.96479815),(2130,16404,0.61039615),(2130,17854,0.65950376),(2130,20278,9.969089e-3),(2131,1069,0.48999602),(2131,11009,0.21957462),(2131,25217,0.9559978),(2132,5917,0.7188564),(2132,23837,5.356202e-2),(2132,25014,0.9392412),(2132,25105,0.70853555),(2132,26585,0.93812793),(2133,2132,0.6225812),(2133,2907,0.13629323),(2133,3869,0.9804212),(2133,18595,0.99605334),(2133,18956,2.8641602e-2),(2133,24198,0.42671373),(2133,24763,0.7545954),(2133,24904,0.630888),(2134,2393,0.64682114),(2134,12905,0.32106045),(2134,14396,0.15384099),(2134,20292,0.34606346),(2135,6301,0.7500094),(2135,6408,9.4851375e-2),(2135,9144,0.19312036),(2135,10897,0.5506689),(2135,13195,0.50221086),(2136,507,0.65712714),(2136,10759,0.17105494),(2136,16487,0.54987144),(2136,18037,0.73234767),(2136,23140,0.36020717),(2136,25343,0.10336107),(2136,29713,0.80959415),(2137,5926,0.6622465),(2137,13908,0.8758157),(2137,16704,0.48484328),(2137,22051,0.59169966),(2138,7659,0.90317106),(2138,11845,0.9030103),(2139,12185,1.7291012e-3),(2139,16522,0.3948423),(2139,24208,0.68235284),(2139,27759,0.45763397),(2139,28771,0.4264842),(2139,30485,0.8422835),(2140,17408,0.8426025),(2140,17975,0.30617264),(2140,24868,1.8030131e-2),(2140,25469,2.68865e-3),(2141,5187,0.9519962),(2141,7647,1.11089265e-2),(2141,16232,0.5639105),(2141,31519,0.79097193),(2142,20841,0.1776137),(2142,27486,0.7542867),(2142,29106,0.52036166),(2143,3882,0.9500811),(2143,21573,0.9590603),(2143,25105,0.26703846),(2144,7063,0.16230412),(2144,17336,0.60930854),(2144,22036,0.7309731),(2144,22769,0.5930522),(2144,25951,0.98412704),(2145,9289,0.79377496),(2145,19310,0.2271244),(2145,22505,0.30131054),(2145,23717,0.6084292),(2145,24644,0.20250626),(2145,28696,0.27351207),(2146,3787,0.5740471),(2147,679,0.64425886),(2147,4854,0.89123046),(2147,9230,0.35737756),(2148,9211,0.8758964),(2148,18125,0.82293504),(2149,13783,0.5357491),(2149,15958,0.12010472),(2149,17392,0.7826235),(2150,6810,0.3901122),(2150,7002,6.281954e-2),(2150,10936,0.82344764),(2150,27629,0.18779431),(2151,10792,0.7590124),(2151,18630,0.10516538),(2151,19326,0.48332462),(2151,23493,0.55124736),(2151,26939,0.36462763),(2152,8139,0.9542043),(2152,14403,0.2771591),(2152,14669,0.68835855),(2152,20598,0.10127219),(2152,22332,0.99772596),(2152,24009,0.86778057),(2152,30672,6.737399e-2),(2153,4137,0.72129714),(2153,4240,0.9678506),(2153,9107,2.1582514e-3),(2153,12259,0.34490758),(2153,23087,0.34825513),(2153,31549,0.4162977),(2154,6273,0.45752656),(2154,16409,0.95536053),(2154,25100,7.1702756e-2),(2154,30973,0.32705864),(2155,18495,0.86259234),(2155,26002,0.68839014),(2155,30517,0.7466919),(2156,1101,0.69307214),(2156,23823,0.55383563),(2156,25357,0.24817805),(2156,29654,0.53608),(2157,7109,0.50457746),(2157,21859,0.8504993),(2159,403,0.19671115),(2159,10824,0.39659652),(2159,19601,0.2851836),(2159,19970,0.49156132),(2159,28005,0.46270937),(2159,28240,0.8293629),(2159,28760,0.29341316),(2159,29127,0.8332026),(2160,7975,0.2981178),(2160,22479,4.555245e-2),(2160,30930,0.21698268),(2161,11025,4.6402346e-2),(2161,13227,0.47255287),(2161,15096,0.9457798),(2161,17255,0.9986046),(2161,25692,0.6536381),(2161,25929,0.75599945),(2161,26737,0.13395296),(2161,29382,0.8910838),(2162,21873,1.4696716e-2),(2162,29692,0.2072215),(2163,129,0.5345724),(2163,5152,0.990532),(2163,6990,0.14910443),(2163,32447,5.7991073e-2),(2164,3878,0.88395625),(2164,5408,0.9984766),(2164,29602,0.98655623),(2165,1697,0.4133604),(2165,4600,0.9352969),(2165,11216,0.7833261),(2165,12317,0.9895465),(2165,13143,0.4850834),(2165,19258,6.9550365e-2),(2165,21667,0.75975204),(2165,26001,0.95754683),(2166,4708,0.40786877),(2166,5262,0.26632068),(2166,7921,0.119093314),(2166,9144,0.9904848),(2166,11980,0.9714697),(2166,18583,0.9635081),(2166,18881,0.7602641),(2166,28517,0.65114224),(2166,31249,0.21025173),(2167,3493,0.64691484),(2167,4186,0.7241734),(2167,5107,0.90392965),(2167,29648,8.292109e-3),(2168,4039,0.9217748),(2168,7805,0.883195),(2168,8581,0.55737364),(2168,11003,0.88496727),(2168,15168,0.9596837),(2168,16677,0.9983576),(2168,17515,0.9042896),(2168,23544,0.5255545),(2169,5575,0.7496795),(2169,32150,0.7186177),(2170,24359,0.88518983),(2170,31047,0.86402404),(2171,2833,0.89612556),(2171,10189,0.38149545),(2171,12460,2.2321573e-2),(2171,13124,0.70256114),(2171,21082,0.5935902),(2171,26179,0.48322544),(2172,3325,0.7639942),(2172,10930,0.2023279),(2173,25516,0.62478757),(2173,31055,0.7654533),(2174,7431,9.979899e-2),(2174,29224,0.58533895),(2174,32591,0.8843258),(2175,1870,0.40333423),(2175,5933,0.49109864),(2175,8152,0.28991017),(2175,13139,0.9981109),(2175,13788,0.3783423),(2175,19003,0.21826556),(2175,24640,9.626826e-2),(2176,7037,0.37578762),(2176,15494,0.9008988),(2176,16187,0.11089837),(2176,17900,0.7165293),(2176,22517,0.5658553),(2176,25260,0.33756462),(2177,26727,0.38628995),(2177,29112,0.16681695),(2177,31001,0.56107646),(2178,20,0.9889427),(2178,3425,0.8537331),(2178,5194,0.47373876),(2178,7199,0.2949485),(2178,9353,0.13419242),(2178,14039,0.12266235),(2178,24834,0.74963784),(2179,1197,0.7138518),(2179,1822,0.46995887),(2179,19568,0.4352434),(2180,13586,0.83643395),(2180,17593,0.13723792),(2180,21637,0.23996766),(2180,24114,0.25322604),(2181,18719,0.47562596),(2182,11901,0.15822549),(2182,17473,0.4972174),(2182,30703,0.48464337),(2183,3503,0.4881762),(2183,5227,0.54557776),(2184,1254,0.28903082),(2184,1558,0.5028742),(2184,25837,0.64691603),(2184,30200,0.5777269),(2185,10240,4.7629975e-2),(2185,13224,0.20697404),(2185,15909,0.25023302),(2185,25899,0.24437022),(2186,4054,0.45533815),(2186,16385,0.36510894),(2186,23574,0.46644485),(2187,4445,0.6747345),(2187,12417,0.46255872),(2187,12532,0.3971935),(2187,18151,0.7241359),(2187,19091,0.12548754),(2188,818,0.41553286),(2188,21088,0.56808025),(2188,28372,0.96349514),(2188,29823,0.10258334),(2189,10371,0.55304694),(2189,13329,0.47671694),(2189,19748,0.48351443),(2190,2619,3.193051e-2),(2190,11539,0.41570354),(2190,14758,0.9492579),(2190,18763,0.69569975),(2191,20046,0.33589685),(2191,21367,0.69977474),(2191,22264,0.35678098),(2191,22978,0.88997084),(2191,23839,0.8718737),(2192,1530,0.2669674),(2192,5178,0.84274703),(2192,5862,0.92477393),(2192,6531,0.4373201),(2192,13018,0.5823645),(2192,15290,0.48374352),(2192,16345,0.4583167),(2192,16769,0.4495053),(2192,23464,0.47653788),(2193,15829,0.27138916),(2193,15858,4.296319e-2),(2193,19448,0.79654396),(2193,30044,0.6133381),(2194,4207,0.35475063),(2194,14893,0.18536593),(2194,15000,0.4790425),(2194,15195,0.46688),(2194,22566,0.49096793),(2195,11021,0.22510533),(2195,15670,8.35984e-2),(2196,17467,0.6649703),(2196,30447,0.64984775),(2197,11835,9.497344e-2),(2198,2079,0.2715022),(2198,8937,1.2430017e-2),(2198,9737,0.81934386),(2198,11370,0.58957916),(2198,26665,0.5784474),(2198,27691,0.8374754),(2198,31438,0.32041162),(2199,2993,0.35198838),(2199,6224,0.8890712),(2199,11895,0.4006907),(2199,25797,0.36254334),(2199,28369,0.84726185),(2199,29430,0.5941236),(2199,31410,0.43039393),(2200,14805,0.30318436),(2200,19450,0.4991406),(2200,19585,0.12704434),(2200,20928,0.5663436),(2200,24223,0.40347475),(2201,3588,0.3189797),(2201,4268,0.90272915),(2202,2445,4.355467e-2),(2202,11428,0.5676316),(2202,13950,0.32873496),(2202,19300,0.2578003),(2202,22016,0.29166758),(2202,22353,4.729387e-4),(2202,26529,0.19832465),(2202,27210,0.71387875),(2203,9833,0.86984575),(2203,23693,0.4850777),(2204,7410,0.83917964),(2204,18495,0.85287696),(2205,3782,0.77664053),(2205,21446,0.6503776),(2205,29998,0.4369393),(2206,1195,0.23610485),(2206,15602,0.32842213),(2206,17173,0.5957515),(2206,18986,0.5351971),(2206,20396,1.4035474e-2),(2206,24755,0.5929905),(2207,8267,0.6773188),(2207,10347,0.98219246),(2207,11366,0.9170413),(2207,11530,0.929378),(2207,18477,9.841186e-2),(2207,20575,0.102419965),(2207,26139,0.201987),(2207,29266,0.3053152),(2208,11651,1.3968607e-2),(2208,13857,0.59782255),(2208,28251,0.5081266),(2209,27851,0.6691582),(2209,31518,0.50047034),(2210,47,0.70363647),(2210,992,0.81853926),(2210,7298,0.11430214),(2210,13616,0.80344075),(2210,27056,0.6737338),(2210,28481,0.76632094),(2210,30314,0.45296606),(2211,7617,0.75029874),(2211,17044,0.7132882),(2211,19909,0.58829254),(2211,28614,0.6052261),(2212,3379,0.22306603),(2212,6003,0.31560317),(2212,10472,0.77447283),(2212,10948,0.82640105),(2212,12197,0.24530937),(2212,13746,0.32716846),(2212,23246,0.12600644),(2213,18092,5.9414677e-2),(2214,936,0.7282957),(2214,19820,0.117981486),(2214,31387,7.761916e-2),(2215,24624,0.8632243),(2215,26707,8.411564e-2),(2215,28510,0.20113504),(2216,24207,7.592813e-2),(2216,31065,7.1650684e-2),(2217,1316,0.887055),(2217,3436,5.363861e-2),(2217,5284,0.528493),(2217,30534,0.11951508),(2218,15646,0.31801796),(2218,30120,0.5282968),(2219,2706,0.49972346),(2219,4047,0.3301228),(2219,18968,0.52716845),(2219,24790,0.62563515),(2219,25984,9.0025e-2),(2220,7100,0.394184),(2220,16790,0.72831094),(2220,19810,0.39400783),(2220,20484,0.893978),(2220,20508,0.7168332),(2221,592,0.4376199),(2221,9167,0.82130665),(2221,14758,0.1899251),(2221,16370,0.9544703),(2221,20867,0.22832091),(2222,2749,0.79432213),(2222,5653,0.1061367),(2222,14688,0.54782397),(2222,20091,0.69561476),(2222,20892,0.7118763),(2222,31375,0.6945418),(2223,10772,0.24131517),(2223,19374,0.9573067),(2223,20243,0.54404366),(2223,21750,0.7990851),(2223,29565,0.99260855),(2223,29834,0.92296857),(2223,30046,0.122715235),(2223,32112,0.67623717),(2224,4192,0.22084962),(2224,5157,0.2919686),(2224,13330,0.27354234),(2224,17042,0.7211142),(2224,24409,0.88679355),(2225,2350,3.2607075e-2),(2225,5412,0.119524375),(2225,26158,0.7599441),(2226,6522,0.78352827),(2226,7656,0.24131383),(2226,29024,0.6965123),(2227,3737,0.20892936),(2227,3756,0.6201685),(2227,12028,0.95142037),(2227,23020,0.2190529),(2227,26909,0.8533502),(2228,5128,0.42946088),(2228,24387,4.2572096e-2),(2229,6410,0.8915282),(2229,12744,0.9093279),(2229,21051,0.21832584),(2229,29390,0.80083096),(2230,3702,0.4689558),(2230,4527,7.083446e-2),(2230,5820,0.22201417),(2230,12023,0.14259186),(2230,23821,0.48439968),(2230,26179,0.45843628),(2231,4159,6.0731187e-2),(2231,4470,0.21634048),(2231,6602,1.1864882e-2),(2231,11560,0.7319388),(2231,19365,0.6555037),(2231,25959,0.23302048),(2231,29785,0.79831135),(2232,12818,0.32475966),(2232,20278,0.60041875),(2232,26078,0.959346),(2232,31963,0.9754411),(2233,998,0.7219205),(2234,708,4.9769897e-2),(2234,13318,0.107227236),(2234,17106,0.21573128),(2234,19167,1.0218339e-2),(2234,27899,0.39473456),(2234,28039,0.6672025),(2234,32149,0.5916936),(2235,9573,0.36094388),(2235,16099,0.83256936),(2235,17954,0.2673926),(2235,19509,0.15337402),(2236,776,0.12901022),(2236,3892,0.5489617),(2236,11424,0.5934153),(2236,27663,0.18228532),(2236,31353,0.40176564),(2237,4598,0.20117354),(2237,6040,0.5850286),(2237,6235,0.97876537),(2237,9770,0.84373456),(2237,12557,0.7154952),(2237,20443,0.775191),(2237,22593,3.303163e-2),(2237,26580,0.8795456),(2237,28715,0.4822253),(2237,30863,0.60097027),(2239,4102,0.6449757),(2239,11967,0.56790835),(2239,17123,0.9063961),(2239,24448,0.19399844),(2240,12497,0.94274443),(2240,14426,0.9012383),(2240,22038,0.7061539),(2240,27013,0.8689123),(2240,30684,0.40742534),(2241,4882,0.55620694),(2241,15801,0.19522366),(2241,16282,0.79668194),(2241,18193,0.6807),(2241,22376,0.21807556),(2242,24110,0.62472075),(2242,24558,0.61266637),(2243,307,0.38336885),(2243,5290,0.15641333),(2243,6075,0.308469),(2243,8574,0.17574438),(2243,11333,0.77290505),(2243,19279,0.24708824),(2244,4088,0.8239598),(2244,7838,0.6654086),(2244,21424,0.57911414),(2245,18059,8.095224e-2),(2245,32741,0.62155885),(2246,8129,0.8377577),(2246,20277,0.6955542),(2246,20600,0.94782233),(2246,21075,0.41535673),(2249,18146,0.4499947),(2249,20676,0.14734302),(2250,6680,6.350922e-2),(2250,8656,0.8798142),(2250,14108,8.608109e-3),(2250,20646,9.4727e-2),(2251,4950,0.7937508),(2251,8223,0.1691526),(2251,9922,0.15751676),(2251,25653,0.42383718),(2251,30523,0.18630965),(2252,3512,0.23950796),(2253,7347,0.9792941),(2254,10863,0.3759647),(2254,12420,3.3890992e-2),(2254,13848,0.50654864),(2254,15116,0.31499845),(2254,23303,0.94850796),(2254,31159,6.1460394e-2),(2255,590,3.5781983e-2),(2255,15385,0.341963),(2256,9057,0.37421122),(2256,14358,0.61532634),(2257,2052,0.7288784),(2257,5260,0.64328474),(2257,5813,0.811637),(2257,9796,0.47332636),(2257,14286,0.69299746),(2258,9523,0.3290607),(2258,10226,0.7234894),(2258,24979,4.9861427e-2),(2259,5114,0.990102),(2259,14946,0.9545432),(2259,16675,0.98273796),(2259,17331,0.17738117),(2260,9002,0.6361831),(2260,13824,0.6507505),(2260,17669,0.38455594),(2261,4063,0.8137535),(2261,9088,0.6260969),(2261,18655,0.7917685),(2261,30939,0.9861157),(2262,1600,0.5951953),(2262,12129,0.74497896),(2263,3520,7.26835e-2),(2263,8166,0.47973382),(2263,11539,0.8619656),(2263,12539,0.67436403),(2263,13821,0.26707116),(2263,23707,0.15956098),(2263,25331,0.24676804),(2263,29740,0.47136658),(2265,674,0.87882),(2265,3515,0.4224999),(2265,5466,0.33357581),(2265,24667,0.9411472),(2265,31124,0.31178075),(2265,32375,0.3972783),(2266,23549,0.60562456),(2267,6777,0.4993233),(2267,14996,0.51559067),(2267,15111,0.96367884),(2268,11953,0.26405054),(2268,15264,0.86906713),(2268,23394,0.555584),(2268,25911,0.81025267),(2269,9932,0.71059036),(2269,10215,6.296739e-2),(2269,12186,0.6257725),(2269,13209,0.30289423),(2269,22800,6.489564e-3),(2269,26539,0.96150804),(2269,30199,0.4860338),(2270,6512,0.37503663),(2270,12931,0.92563885),(2270,15882,0.94102705),(2270,26008,0.35656834),(2270,28573,0.33189335),(2270,30453,0.39023256),(2271,1296,0.91708),(2271,1308,0.117139906),(2271,6488,0.3072404),(2271,8911,0.934656),(2271,12554,0.67942524),(2271,16016,0.912004),(2271,22214,0.61178696),(2272,2258,0.763283),(2272,2771,0.7985532),(2272,4147,0.6235632),(2272,13052,0.6671706),(2272,13226,8.369659e-2),(2272,26054,0.9981263),(2273,1001,0.24220009),(2273,5794,0.5462136),(2273,5854,0.99108964),(2273,10541,0.21819648),(2273,26808,0.499376),(2273,27029,0.53971523),(2273,31814,0.53676796),(2274,3094,0.9636833),(2274,7168,0.9458127),(2274,8608,0.7048378),(2274,17601,0.19665599),(2274,20125,0.12042296),(2274,30884,0.48905677),(2275,854,0.12435559),(2275,1286,0.94119745),(2275,18037,0.43029663),(2275,23494,0.6532792),(2275,31429,0.5214903),(2275,32403,5.4833446e-2),(2276,2328,0.48858166),(2276,5698,0.9882382),(2276,6813,0.34012365),(2276,31696,0.23043106),(2276,32018,0.7513898),(2277,420,0.3299942),(2277,10805,0.7702671),(2277,11683,0.970472),(2277,17213,0.17099833),(2277,19205,0.9041184),(2277,26448,0.77477664),(2277,28977,0.9505675),(2277,30482,0.28864285),(2278,10265,0.943321),(2278,15119,0.48288664),(2278,22268,0.20395665),(2279,1227,0.8782308),(2279,4143,0.19552173),(2279,19849,0.53444123),(2279,22919,0.6058128),(2279,24180,0.8691453),(2279,31657,0.36899668),(2280,12096,0.12716135),(2280,13420,7.343037e-2),(2280,21618,0.35652456),(2280,22076,0.66631466),(2280,23909,0.28124592),(2280,30158,0.5322558),(2281,5609,1.8426031e-3),(2281,15743,0.35104468),(2281,17149,0.23460698),(2281,20971,0.6753728),(2282,6141,0.12304123),(2282,10496,0.17314474),(2282,16093,0.8924902),(2283,6606,0.31763604),(2283,8302,0.98037994),(2283,9037,0.36155558),(2283,20899,0.7076524),(2283,30860,0.5398878),(2284,6164,0.39360502),(2284,22391,0.37385),(2284,27677,0.73791367),(2284,32706,0.6240301),(2285,5159,0.704651),(2285,12541,0.43547967),(2285,13142,0.46646214),(2285,26827,0.8125457),(2285,31713,0.9072794),(2285,32018,0.5284565),(2286,5662,0.7790014),(2286,17735,1.9381022e-2),(2286,24071,0.8816921),(2287,28383,0.49746633),(2287,30304,0.43168887),(2287,32702,0.31077495),(2288,3436,0.2773993),(2288,21920,0.14101747),(2289,2446,0.21639709),(2289,16585,0.61724627),(2289,27453,0.27932444),(2290,2301,0.18245211),(2290,2763,0.93236154),(2290,3936,0.57797974),(2290,7155,0.32551593),(2290,16563,0.8309102),(2290,28365,0.4290154),(2291,31620,0.28701788),(2291,31883,0.78700995),(2292,7672,0.7686361),(2292,8565,0.663921),(2292,22454,0.9149354),(2293,32408,0.6390405),(2294,4576,0.49615392),(2294,10049,0.86732715),(2294,12812,0.3848688),(2294,29250,0.28246856),(2295,268,0.30238092),(2295,13877,0.2431282),(2296,2942,0.57610554),(2296,7262,6.0524143e-2),(2296,18340,0.6356065),(2297,23631,0.6783318),(2298,630,0.62963045),(2298,1694,0.23639041),(2298,10250,0.40059498),(2298,18359,0.10765214),(2298,21713,0.73972285),(2299,7712,0.7578618),(2299,10082,0.6849345),(2299,10434,0.12836209),(2299,13952,0.5366837),(2300,16314,0.43373808),(2300,19120,0.4620526),(2300,20323,0.6914664),(2301,18339,0.8668848),(2301,21334,0.5963996),(2301,27061,0.594518),(2301,32242,0.67106664),(2302,2419,0.32611337),(2302,29859,0.10241476),(2303,5100,0.90493906),(2303,20802,0.48083872),(2303,24563,0.9843394),(2304,4924,0.9412521),(2304,14935,0.7521905),(2305,4977,0.99191266),(2305,9907,0.6691113),(2305,19069,0.8739836),(2305,20937,0.4872082),(2305,25127,0.26011184),(2305,29800,0.50148004),(2306,693,0.6502467),(2306,1373,8.160296e-2),(2306,6249,7.4996926e-2),(2306,24173,0.12588243),(2307,21964,0.7388924),(2307,23712,1.3239652e-2),(2307,25960,0.8898533),(2308,1503,0.75540674),(2308,3351,0.25437966),(2308,21902,9.1394834e-2),(2308,27384,0.45336217),(2309,8441,0.7336549),(2309,17409,0.1881123),(2309,30692,0.3813325),(2310,12373,0.21163066),(2310,17441,0.3562927),(2310,20751,0.66167647),(2310,24032,0.88190085),(2311,2412,0.22695592),(2311,8525,0.47438973),(2311,22648,0.5975774),(2311,23745,0.37427777),(2312,883,0.25504678),(2312,14795,0.34561375),(2312,24456,0.1541191),(2313,15586,0.45345336),(2313,16071,0.7477332),(2313,23643,0.9343441),(2313,24334,8.957429e-3),(2313,26019,0.26610103),(2314,2703,0.16738488),(2314,12609,0.49758238),(2314,21846,0.10880191),(2314,27027,0.63699895),(2316,1452,0.41018996),(2316,13782,0.33317792),(2316,21108,0.79229456),(2317,16982,0.85246444),(2318,9032,7.717999e-2),(2318,27046,0.5633414),(2319,20371,0.15027179),(2320,2081,0.6470516),(2320,5135,0.3450219),(2320,8465,0.26764518),(2320,11482,0.78852105),(2321,535,0.38128927),(2321,4475,0.7769346),(2321,8689,0.53325534),(2321,11044,0.16858198),(2321,13256,0.107019156),(2321,19472,0.89205664),(2322,12593,0.5585709),(2322,20949,0.62934554),(2322,23509,0.11968577),(2322,24583,0.8781901),(2322,27598,0.34152928),(2322,29154,0.102041215),(2322,30924,0.45123318),(2323,7678,9.8203585e-2),(2323,9588,0.95498186),(2323,21871,0.8055693),(2323,22877,9.876926e-2),(2324,2139,0.7308067),(2324,11917,7.371397e-2),(2324,12909,6.0474e-2),(2324,17047,0.9160439),(2324,23512,2.4151556e-2),(2324,26153,0.4508781),(2325,680,0.3016732),(2325,10183,5.6757465e-2),(2325,20790,0.63786626),(2325,30265,0.42953792),(2326,4806,0.90976214),(2327,1222,3.5175286e-2),(2327,12093,0.70530766),(2327,21645,0.20106652),(2327,24697,0.1478102),(2328,2127,0.7968313),(2328,22161,0.8135029),(2328,28594,0.4230122),(2328,29481,0.1779781),(2329,1759,0.10513241),(2329,3589,0.2850865),(2330,1037,0.8422744),(2330,4241,0.8315544),(2330,6191,0.68721366),(2330,12066,0.53460675),(2330,24448,0.33574712),(2330,28544,0.13294539),(2330,29309,0.14109692),(2330,32730,0.8211182),(2331,4928,0.89813405),(2331,5378,0.5765039),(2331,6936,0.14631492),(2331,7895,0.4889914),(2331,29747,0.10729351),(2331,31773,0.2973254),(2332,4436,0.4149128),(2332,8334,0.28566408),(2332,20146,0.6376994),(2332,20473,9.317915e-2),(2332,22610,0.608723),(2332,23332,0.29512182),(2332,23650,0.81600165),(2332,26452,0.24419077),(2332,26476,0.806262),(2333,1130,0.21922314),(2333,6364,0.83510035),(2333,8512,0.16113545),(2333,11383,0.6904504),(2334,2826,0.24303423),(2334,7975,0.6727833),(2334,29610,0.79768574),(2335,9270,0.8378912),(2335,12540,0.4447765),(2335,15817,0.1346968),(2335,16444,0.60350084),(2335,31060,0.29701984),(2336,8156,0.44149208),(2336,20722,0.6510456),(2336,21983,0.41597956),(2336,24980,0.124047786),(2336,30703,0.9886349),(2337,16548,0.46936762),(2337,17915,0.8801573),(2337,21671,0.98826814),(2337,24122,0.107443444),(2338,9413,0.21818979),(2338,18642,0.83754355),(2338,18968,0.7062898),(2338,27136,0.24909471),(2339,50,0.2560733),(2339,1352,1.2626782e-2),(2339,5051,0.85782504),(2339,14840,0.24572714),(2339,20158,4.2249367e-2),(2339,32286,2.743121e-2),(2340,6719,0.4975607),(2340,11887,0.14518714),(2340,14150,9.611659e-3),(2340,31546,0.6896865),(2341,10454,0.8653246),(2341,11241,0.7937134),(2341,14201,0.5163429),(2341,15586,0.52973324),(2341,16202,0.3651708),(2341,24383,0.4008999),(2342,18848,0.8947585),(2342,28231,0.33105606),(2343,729,0.6382499),(2343,834,0.86156476),(2343,6853,0.57203156),(2343,28914,0.2768253),(2343,29596,0.9969364),(2344,230,1.8269818e-2),(2344,2815,0.74421936),(2344,6374,0.22586231),(2344,14212,0.98224723),(2344,15938,0.5701908),(2345,7071,0.47055614),(2345,20461,0.34562686),(2346,2364,0.34593976),(2346,6549,6.878684e-2),(2346,30128,0.80374545),(2347,14603,0.79684657),(2347,15555,0.32064208),(2347,19228,0.5660529),(2347,20904,0.6342079),(2347,24008,8.534644e-2),(2348,48,0.54651386),(2348,3662,0.33022428),(2348,5132,3.6327795e-3),(2348,5566,0.18833916),(2348,23549,5.570798e-2),(2348,26913,0.5820193),(2348,27370,0.35607547),(2349,378,0.99347913),(2349,7355,0.8781744),(2349,13437,0.30024406),(2349,16121,0.4386714),(2349,21737,7.7721e-2),(2349,29157,0.5544012),(2350,3865,0.32366154),(2350,7667,0.2369479),(2350,11555,0.16370305),(2351,12556,0.92720425),(2351,32150,0.9473699),(2352,1860,0.79489714),(2352,7912,0.24819507),(2352,19365,0.7900582),(2352,24546,0.4603994),(2353,6099,0.31157345),(2353,18669,0.8494666),(2353,29040,0.57020396),(2354,15630,0.21342899),(2354,15684,0.44688615),(2354,23705,2.5224065e-2),(2354,27840,0.90553653),(2354,31621,0.19914667),(2355,24175,0.3599102),(2356,5873,0.16234735),(2356,7998,0.50183475),(2356,10865,8.703427e-2),(2356,17029,0.2883819),(2356,26055,0.19211644),(2356,28565,0.78677076),(2356,31542,0.5345204),(2357,8191,0.15475112),(2357,12119,0.46456826),(2357,19006,0.9886899),(2357,20769,0.41275024),(2357,25676,0.512599),(2357,30159,0.26448423),(2358,6397,0.71538806),(2358,8547,0.6409657),(2358,22468,0.82383746),(2358,26201,0.50344986),(2360,12065,0.9179283),(2360,14525,0.6320853),(2360,17282,0.401331),(2360,23051,0.46861377),(2361,17336,0.8978172),(2361,30530,0.7806917),(2361,32539,0.3493572),(2362,10314,0.83073705),(2362,18286,0.7996418),(2363,12079,0.91723514),(2363,28873,0.96620595),(2364,31596,0.8459023),(2365,2958,0.36657307),(2365,5735,0.365338),(2365,7681,0.26168182),(2365,19617,7.888325e-2),(2365,23581,0.102687664),(2366,305,0.5176963),(2366,9716,0.29455194),(2366,16968,7.513243e-2),(2366,24919,0.5237355),(2366,27082,0.9391093),(2366,28830,0.13613868),(2367,5099,7.5583816e-2),(2367,12405,0.8176329),(2367,20341,0.1961376),(2368,8887,0.6116974),(2368,10949,0.98697096),(2368,12083,0.27507016),(2368,15139,0.735885),(2368,24597,0.62539995),(2369,18612,0.1159739),(2370,15124,1.6210468e-2),(2370,20644,0.85551655),(2370,26429,0.12241085),(2370,32500,0.5343093),(2371,12723,0.4658838),(2371,16004,0.8253195),(2371,25085,0.51281357),(2372,6837,0.7230072),(2372,12530,0.16502973),(2372,13594,0.63724),(2372,22308,0.8514459),(2373,32033,0.5149568),(2374,3240,7.008857e-2),(2374,11532,0.31466913),(2374,22166,0.24699478),(2375,865,2.9091585e-2),(2375,10730,0.69014144),(2375,24561,0.60459495),(2375,28150,0.9761025),(2376,5136,0.60296386),(2376,14729,0.26705605),(2376,21511,0.39812392),(2376,32433,0.33803296),(2377,4923,2.2392854e-2),(2377,11280,0.109729365),(2377,14549,0.1688296),(2377,16160,0.86519486),(2377,16656,0.8288242),(2377,27955,0.44033346),(2378,18644,7.490813e-2),(2378,21437,0.50945276),(2378,23766,0.3873242),(2378,25763,0.20522137),(2379,20694,0.19587412),(2379,22200,0.9329868),(2379,26938,0.3812019),(2379,31293,0.1882909),(2380,7961,0.760686),(2380,24188,0.75310487),(2380,28386,7.347599e-2),(2381,4321,0.86465454),(2381,10574,0.5909591),(2381,26759,0.7859179),(2382,7136,0.35778484),(2382,16404,0.26609114),(2382,17774,0.105785176),(2382,20427,0.49341577),(2382,22069,0.2928711),(2382,28161,0.16604398),(2382,30219,0.12715885),(2382,30989,0.29120398),(2383,7948,0.32080904),(2383,10494,3.806014e-3),(2383,12479,0.44035873),(2383,13871,0.9892386),(2383,28044,6.4296916e-2),(2384,11282,0.9380455),(2384,23076,0.6533798),(2384,23755,0.9059357),(2384,31078,0.8935512),(2384,31155,0.7198862),(2384,32637,0.12245382),(2385,13587,0.32230967),(2385,16510,0.20736893),(2385,18498,7.06534e-2),(2385,30936,0.29575503),(2386,18199,0.6839252),(2386,31103,0.4361052),(2387,1127,0.7760281),(2387,4720,0.9382364),(2387,4996,0.8463203),(2387,6180,0.8410561),(2387,7764,0.15124449),(2387,9137,7.502973e-2),(2387,12268,0.34418893),(2388,4960,0.32340333),(2388,10721,0.9952423),(2388,18051,0.66243386),(2388,24608,0.5205653),(2389,18444,0.68926966),(2389,31900,0.1465183),(2390,1795,0.9891002),(2390,11694,0.108556196),(2390,12382,0.5002205),(2390,12872,0.23111844),(2390,25215,0.5500167),(2390,29052,0.7422722),(2390,30187,0.5108607),(2391,2729,0.40414777),(2391,6659,0.2573954),(2391,10034,0.5608921),(2391,20317,0.48931098),(2392,24994,0.31743518),(2393,1468,0.49410495),(2393,6407,0.57543737),(2394,7808,0.2767605),(2394,9029,0.46737936),(2394,14618,0.49845424),(2394,16323,0.1196748),(2394,27336,0.75204813),(2395,4475,1.5486257e-2),(2395,5376,3.1157197e-2),(2395,10910,0.31784824),(2395,10926,0.6410591),(2395,15057,0.20088536),(2395,15324,0.41389525),(2395,17710,0.71168244),(2395,27438,0.9097529),(2395,30894,0.56557286),(2396,3109,0.25880536),(2396,7307,6.667026e-2),(2396,9203,0.5420944),(2396,16424,0.40296382),(2396,28225,0.43771046),(2397,1383,0.24434407),(2397,3521,1.9346144e-2),(2397,9225,0.6965133),(2397,13386,0.87438005),(2397,20417,0.56963205),(2397,21297,0.19105797),(2398,5115,0.60665494),(2398,8982,0.53087074),(2398,11143,0.4689582),(2399,5769,0.7314085),(2399,9394,0.5087886),(2399,13987,0.61655295),(2399,14167,1.977919e-2),(2399,16722,0.74404764),(2399,25871,0.33158523),(2400,735,0.64465),(2400,3465,0.63218325),(2400,6511,0.9694681),(2400,27920,0.10976679),(2400,29264,0.39656132),(2401,16966,0.49955502),(2401,23403,0.5841743),(2402,692,0.7917364),(2402,14779,8.549461e-2),(2402,19345,0.9702287),(2404,14879,0.9736419),(2404,18493,0.5858976),(2404,24108,0.6493857),(2405,2108,0.35990623),(2405,3212,0.10344523),(2405,3432,0.9864862),(2405,4589,0.2619768),(2405,10197,0.24355604),(2405,12798,0.3606027),(2405,31533,0.6459258),(2405,31815,0.41743308),(2406,3617,0.49943236),(2406,10043,0.48398182),(2406,10307,0.34760267),(2406,13438,0.483824),(2406,17450,0.22884342),(2406,23759,0.45736808),(2406,25858,0.4915851),(2406,32223,0.30475932),(2407,3423,0.6533645),(2407,14025,0.9792296),(2407,28478,0.2945964),(2407,31251,0.50490415),(2408,16186,0.13923936),(2408,27325,0.7353882),(2409,4807,0.93730485),(2409,10876,0.13304302),(2409,11990,0.840199),(2409,14012,7.526981e-2),(2409,22105,0.76647425),(2410,2838,1.8190637e-2),(2410,8854,0.46109834),(2410,14795,0.25288582),(2410,19049,0.81002814),(2410,25445,0.8394183),(2410,31857,0.7083805),(2411,310,0.1320397),(2411,20367,0.773482),(2411,30013,0.70871943),(2412,10554,0.35655314),(2412,21144,0.9399723),(2412,22290,0.96476334),(2413,9014,0.34975734),(2413,17198,0.5122288),(2413,22026,0.16492374),(2414,20405,0.27682117),(2415,10264,0.9381709),(2415,11148,0.14277609),(2415,19808,6.7448094e-2),(2415,19872,9.9708095e-2),(2415,30455,0.6150419),(2416,4988,0.6269376),(2416,13704,0.84992564),(2416,14526,0.14218017),(2416,23464,0.10185294),(2416,27070,8.9799024e-2),(2417,13515,0.3360604),(2417,19725,0.5459046),(2417,31698,0.93701005),(2417,31969,0.77742094),(2417,32136,0.5119367),(2418,4107,0.32794788),(2419,17127,0.36148673),(2420,4816,0.2727616),(2420,9503,0.89504254),(2420,10266,0.62504756),(2421,3001,0.18197817),(2421,10564,0.934771),(2421,14187,0.22714035),(2421,14412,0.23534706),(2421,22008,1.6494583e-2),(2421,25440,0.4819443),(2421,28400,0.28094494),(2422,1229,0.57552314),(2422,7162,0.37019503),(2422,19395,0.4676126),(2422,21547,0.60652983),(2422,23680,0.8028193),(2422,26170,0.8877063),(2423,1538,0.94291747),(2423,13786,0.74020994),(2423,15997,0.7640903),(2423,23153,0.7058033),(2424,7180,0.6943071),(2424,9901,0.17935069),(2424,12565,0.7467708),(2424,25854,0.76687825),(2424,32348,0.45372686),(2425,1972,0.7952948),(2425,15768,0.80835277),(2425,27233,1.7283058e-2),(2426,416,0.34053925),(2426,18585,0.88762313),(2427,29696,0.81305295),(2427,31295,0.66458535),(2428,2996,0.42973652),(2428,14987,0.11136466),(2428,16956,0.73988396),(2428,19134,0.2644261),(2429,13806,0.613884),(2429,20964,7.944711e-2),(2429,29602,0.40559617),(2430,6306,0.26855883),(2430,17147,0.9056417),(2430,17611,0.78592396),(2430,17972,0.5892032),(2431,1348,0.74163824),(2431,7068,0.26844278),(2431,9207,0.21798912),(2431,10084,0.3624424),(2431,12415,0.30178267),(2431,15868,0.17273247),(2431,23019,0.9866902),(2431,25140,0.8714368),(2431,29929,0.65267926),(2432,4886,0.9692239),(2432,5911,0.21382733),(2432,14367,0.43498766),(2432,28699,0.29094696),(2432,30678,7.347543e-2),(2433,25800,0.13896433),(2433,27298,0.79964644),(2434,4174,0.117811956),(2434,5023,0.3929441),(2434,11727,0.72361314),(2434,29356,0.8893592),(2435,6536,0.18046968),(2435,17184,0.62736374),(2435,19428,7.519959e-2),(2435,22144,0.35219568),(2436,11494,0.97870356),(2436,13256,0.6837789),(2436,16240,0.12129436),(2436,23386,0.7911316),(2436,31157,0.6726396),(2437,8688,6.270904e-2),(2437,12200,0.35808602),(2437,13300,0.5260644),(2438,3371,0.51400554),(2438,9884,4.91329e-2),(2439,1198,0.7749728),(2439,19464,0.6145636),(2439,24665,0.30106783),(2440,6222,5.7121426e-2),(2440,11537,0.9717161),(2441,5122,0.17687786),(2441,9111,0.8623641),(2441,17453,1.2569661e-2),(2441,19592,0.2516234),(2442,6186,0.100112975),(2442,21482,0.15102798),(2443,7830,0.32355678),(2443,7949,3.6112744e-2),(2443,16532,0.43475994),(2443,19696,0.5023207),(2443,23598,0.13664766),(2444,9412,0.43566847),(2444,12040,0.3632454),(2445,642,0.78046703),(2445,1420,0.58265305),(2445,11968,0.19303633),(2446,8930,0.8878814),(2446,14204,0.34194228),(2446,25125,0.9974708),(2446,27503,0.6522863),(2446,28239,0.2613815),(2447,7835,0.48234284),(2447,11483,0.1654373),(2447,15538,0.7297062),(2448,4383,0.48290637),(2448,9924,0.2216477),(2449,5359,0.8529258),(2449,16221,0.49372858),(2449,26204,8.483849e-2),(2450,8441,0.48363957),(2450,18879,0.22149129),(2451,13433,0.122922905),(2451,17255,0.7725259),(2451,21403,0.8632276),(2452,3250,0.53954107),(2452,3612,0.58350927),(2452,5221,7.327482e-2),(2452,5797,4.4796363e-2),(2452,7084,0.76965564),(2452,26710,0.29915276),(2453,9478,0.7560237),(2453,30069,0.8655382),(2454,29823,0.14281093),(2455,14867,0.98130596),(2456,1162,0.960849),(2456,9435,0.8493733),(2456,10541,0.7199458),(2456,19072,0.5094885),(2456,22247,0.94021946),(2456,23168,0.686349),(2456,27841,0.5293994),(2457,3991,0.8665773),(2457,4113,0.9143962),(2457,24538,0.98786783),(2458,21674,0.5516302),(2458,22175,0.80155146),(2458,23527,0.2776017),(2458,27142,0.9582367),(2459,675,0.39420533),(2459,17186,0.47199652),(2459,23553,0.49413496),(2460,14394,0.87639266),(2460,16702,0.38065735),(2461,4139,0.2581931),(2461,17412,0.6066647),(2461,30239,6.101469e-2),(2462,5463,2.9199839e-2),(2462,7443,0.84175897),(2462,7483,0.47650817),(2462,17145,0.9766524),(2462,24950,0.7414316),(2462,26644,0.84074426),(2462,28181,0.8186797),(2463,13040,2.5887577e-2),(2463,13313,2.6511502e-2),(2464,4861,0.20462298),(2464,4921,0.69515043),(2464,18087,0.834244),(2465,6884,0.43933403),(2465,16730,0.8090707),(2465,17323,0.79062784),(2465,25818,0.55783236),(2465,26297,0.50194776),(2466,1445,0.78731143),(2466,10870,0.25229836),(2466,23325,0.7820062),(2466,28603,0.73352396),(2466,30319,0.4076652),(2467,868,0.85643446),(2467,914,0.42835465),(2467,1683,7.725657e-2),(2467,8778,0.24462931),(2467,15195,0.48777905),(2467,23964,0.22510798),(2468,2796,0.4217996),(2468,7489,0.85217476),(2468,10370,0.29441166),(2468,20437,0.33111724),(2468,30373,0.53698146),(2469,6423,0.76108795),(2469,11020,0.8882005),(2469,16243,0.8796005),(2469,23854,0.17192908),(2470,27095,0.7377453),(2470,27670,0.95172614),(2470,30885,0.96054626),(2471,3464,0.44544214),(2471,23263,0.9266388),(2471,25772,0.15336524),(2471,30151,0.9986689),(2472,24459,0.63848585),(2472,29087,0.72762066),(2474,3856,0.55321866),(2474,9127,0.74753356),(2474,13147,0.7458612),(2474,13988,0.35440335),(2474,22687,0.891653),(2474,24387,0.6902081),(2474,25299,0.89334995),(2475,73,0.5683892),(2475,21247,0.1513284),(2475,30339,0.6806755),(2476,7484,0.28044134),(2476,9089,1.6428975e-2),(2476,14798,0.92014515),(2476,24325,0.9729882),(2476,26333,0.15190561),(2478,2509,0.1820354),(2478,5226,0.65166074),(2478,13014,4.2424146e-2),(2478,13476,0.74955666),(2478,15873,0.93582356),(2478,17148,0.89169055),(2478,27548,0.12073791),(2478,29898,0.4766788),(2479,275,0.7980109),(2479,4257,0.16694519),(2479,6103,0.8278467),(2479,16080,0.7794745),(2479,23963,0.9538947),(2479,25015,0.7138914),(2479,26609,1.6751422e-2),(2480,3867,0.113544144),(2480,7400,0.54454434),(2480,18955,0.99234706),(2480,19099,1.6898494e-2),(2480,25431,0.7108207),(2481,9312,0.56549394),(2481,15383,0.4330265),(2481,20909,0.20346832),(2481,21161,0.55014706),(2481,22847,8.216262e-2),(2482,26189,0.6554565),(2482,27384,0.29079875),(2483,10770,0.21702625),(2483,22281,0.114750415),(2483,26825,0.9646799),(2484,3434,0.48223528),(2484,3765,0.9791916),(2484,15774,0.92601967),(2484,16264,0.1782641),(2484,21038,0.3451697),(2484,26608,0.45865193),(2484,30856,0.7923795),(2485,5917,0.6034068),(2485,15307,2.2923974e-2),(2485,21945,0.6975229),(2486,1995,5.053774e-3),(2486,4879,0.62371624),(2486,13826,0.8221307),(2486,18720,0.1258489),(2486,18904,0.9106778),(2486,19084,0.34503236),(2486,24073,0.5335012),(2486,26745,0.6984411),(2486,30749,0.56836754),(2487,10328,0.8014323),(2487,14568,0.311331),(2487,19998,0.7313138),(2487,21052,0.18393141),(2487,27919,0.7303933),(2488,13956,0.662819),(2488,15810,0.10867988),(2489,928,0.75062454),(2489,3960,6.1348498e-2),(2490,6037,0.8372323),(2490,6579,5.1094564e-3),(2490,6782,0.52742463),(2490,13728,0.85560817),(2490,24292,0.67122287),(2492,4875,0.41474012),(2492,5807,0.37819758),(2492,6162,0.33385482),(2492,26806,0.4651445),(2493,9629,5.619553e-2),(2493,29064,0.8017969),(2494,6903,1.3468111e-2),(2494,22068,0.5628949),(2494,26606,0.9046172),(2494,31035,0.7652033),(2494,31223,0.230976),(2495,11919,0.94057685),(2495,22601,0.73011),(2495,28948,0.6733658),(2495,29536,0.17064175),(2496,6556,0.11693005),(2496,11113,0.52356553),(2496,13619,0.7501622),(2496,28789,0.926635),(2497,12367,0.13772354),(2497,13224,0.6526309),(2497,15087,5.960749e-3),(2497,19943,0.8498892),(2497,26325,0.36000982),(2498,18103,0.47945327),(2498,19600,0.11642826),(2498,30293,0.45841238),(2499,7447,7.800807e-2),(2499,9554,0.29772094),(2499,11645,0.7131744),(2499,12491,0.30265665),(2499,12539,0.42625853),(2499,21132,0.37055),(2499,31816,0.28430355),(2499,32324,0.5275063),(2500,10255,0.85272294),(2500,21583,0.56153035),(2500,24139,7.287572e-2),(2500,24653,0.3183373),(2500,25102,0.63539636),(2501,9301,0.4612642),(2501,11088,0.3380674),(2501,22021,0.38569084),(2502,3853,6.727549e-2),(2502,6684,0.7733555),(2502,21079,0.27752945),(2502,25725,0.5073107),(2502,30686,0.61015975),(2503,1004,0.40901637),(2503,7748,0.5256563),(2503,12230,0.4587569),(2503,14400,8.267826e-2),(2503,28637,0.4337367),(2504,265,2.333693e-2),(2504,366,0.68103343),(2504,2118,0.65715915),(2504,30017,0.69563),(2505,14089,0.59188604),(2505,31955,0.6606538),(2506,4533,0.5021568),(2507,2665,0.6914828),(2507,8433,0.20796528),(2507,22830,5.784634e-2),(2507,23814,0.712112),(2507,32102,0.24531636),(2508,3355,0.6134684),(2508,5908,0.4376997),(2508,7374,0.48135644),(2508,18805,0.29013258),(2508,25162,4.1166168e-2),(2508,29872,0.1575439),(2509,10616,0.39541242),(2509,20703,3.9334383e-2),(2509,26389,0.20107535),(2509,27043,0.6391728),(2510,9557,0.5171643),(2510,23814,0.97305834),(2510,31730,0.11106876),(2511,68,0.7716087),(2511,1205,0.6028809),(2511,10958,0.8957954),(2511,13210,0.37163812),(2511,25168,0.56152797),(2511,26202,9.170432e-2),(2511,31392,0.30848685),(2512,3704,0.36073822),(2512,7412,0.38932484),(2512,13869,0.375749),(2512,17928,0.57074505),(2512,21291,0.8296875),(2512,26989,0.26239008),(2512,28043,0.9027432),(2512,28782,0.547382),(2513,21382,0.9140075),(2514,2190,0.6704212),(2514,5335,0.9354413),(2514,8720,0.56958026),(2514,13224,0.69500405),(2514,29707,0.3237654),(2514,32068,0.9152661),(2515,22157,0.62513834),(2516,8824,0.7139238),(2516,23151,0.85767984),(2516,24560,0.4260213),(2516,26469,0.83564043),(2517,7028,0.93283194),(2517,10649,0.17830205),(2517,13232,0.3850786),(2517,30122,0.6450979),(2518,9795,7.102736e-2),(2518,15636,0.85299546),(2518,17008,0.31109875),(2519,1209,5.9796594e-2),(2519,11803,0.19337389),(2519,14893,0.5549491),(2519,23508,0.6290382),(2519,24054,0.5296526),(2519,28234,0.8027259),(2519,30873,0.355039),(2520,2586,0.8909843),(2520,3126,0.8650874),(2520,9422,0.5835321),(2520,12906,0.30441815),(2520,18471,0.425037),(2520,19463,0.40378025),(2521,3359,0.24268755),(2521,3992,0.95079935),(2521,4097,1.4271851e-2),(2521,8554,0.16164196),(2521,14541,4.314277e-2),(2521,25569,0.36653316),(2521,26491,0.4243534),(2522,1290,1.2220975e-2),(2522,14539,0.97479945),(2522,18318,0.65093386),(2522,21042,0.8444737),(2522,24551,0.43295833),(2523,1265,0.5357686),(2523,21913,0.7289269),(2523,22058,0.10102829),(2524,26047,0.44078356),(2525,4482,0.17123069),(2525,10417,0.9477868),(2525,23575,0.12947981),(2525,25310,0.93135685),(2526,12019,9.814954e-3),(2526,21762,8.781321e-2),(2527,2934,0.80171573),(2527,3299,0.19524285),(2527,6073,2.9165948e-2),(2527,22539,0.8848454),(2527,24543,0.77350396),(2527,27989,0.6458592),(2527,30103,0.19858898),(2528,883,0.5240653),(2528,4667,0.87691605),(2528,5190,0.1020497),(2528,11241,0.58281),(2528,12765,9.491234e-2),(2528,29254,0.18124782),(2528,29318,0.19556417),(2529,138,0.46732584),(2529,13615,0.7876069),(2529,19554,0.7432817),(2529,25037,0.5920549),(2529,28163,0.65415555),(2529,31321,0.98286915),(2530,13707,0.26076052),(2530,19482,0.31221944),(2530,27587,8.248341e-2),(2531,267,0.1322645),(2531,2135,0.7758957),(2531,25372,4.1466866e-2),(2531,26192,0.53961766),(2531,27760,0.49084225),(2532,2320,0.4580124),(2532,19028,0.2835917),(2532,23633,0.7944479),(2532,28726,0.6364752),(2533,1050,0.45543423),(2533,23221,0.7545416),(2533,27605,0.33277723),(2534,1876,0.984584),(2534,8840,0.9654659),(2534,22555,0.25252858),(2535,1327,0.6094456),(2535,4932,0.1996701),(2535,14446,0.5008781),(2536,2645,3.2843426e-3),(2536,4441,0.9633133),(2536,18659,0.36414903),(2537,11320,0.9471849),(2537,16708,0.61404216),(2537,17166,0.69313806),(2537,23270,0.9543297),(2537,26693,0.15541883),(2537,27268,0.43880862),(2537,27662,6.064352e-2),(2537,28404,0.9972283),(2537,32270,0.17486832),(2538,21201,8.755903e-3),(2539,6582,0.46779424),(2540,6913,0.28003693),(2540,23963,0.6144556),(2540,29224,0.11989948),(2541,7790,0.16625814),(2541,9136,0.9382115),(2541,25741,0.9511342),(2541,29046,0.14578818),(2542,991,0.4638559),(2542,12205,0.45681196),(2542,29687,2.6581466e-2),(2543,1616,0.68858075),(2543,4479,0.55375284),(2543,7775,0.65847844),(2543,16429,0.26399198),(2544,14670,0.1209306),(2544,28001,7.658413e-2),(2545,1809,0.98514336),(2545,5449,0.80161005),(2545,15053,0.77547634),(2545,15656,2.4131825e-2),(2545,18138,0.26264113),(2545,21628,0.28690806),(2545,29028,0.49701095),(2545,30577,8.1250586e-2),(2546,9563,0.7385301),(2546,21101,0.29762033),(2546,31406,0.43884018),(2547,2066,0.19586338),(2547,7495,0.22273596),(2547,26863,0.14233154),(2548,755,0.21717153),(2548,4023,0.9459726),(2548,6726,0.3333956),(2548,10376,0.31407714),(2548,14592,0.4423406),(2549,10421,1.7242074e-2),(2549,16663,0.35875398),(2550,12818,0.17180893),(2550,16298,0.906354),(2550,16580,0.9801569),(2550,19576,0.2837274),(2551,13168,0.20682019),(2552,19430,0.7115275),(2552,27197,0.24766888),(2552,27407,0.14174101),(2552,32594,0.49920508),(2553,2093,0.4046647),(2553,11928,0.9710703),(2553,15735,0.120849006),(2553,18747,4.41712e-3),(2553,26644,0.9348405),(2554,1417,0.93334794),(2554,2200,0.8058764),(2554,14813,0.86201257),(2555,1278,0.8289323),(2555,4958,0.97935843),(2555,11114,0.46458906),(2555,12275,2.2822434e-2),(2555,14725,0.678055),(2555,15435,0.112451956),(2555,18682,0.13274175),(2555,26753,0.93914396),(2557,8320,0.6236127),(2557,15130,0.90295744),(2557,17207,0.29059258),(2557,20673,0.8624153),(2557,30651,0.4489986),(2558,7205,0.6707314),(2558,18745,0.46854743),(2558,21474,4.2861574e-3),(2558,24035,0.88359666),(2558,27929,8.194311e-2),(2559,3290,0.26266384),(2559,4841,0.7101694),(2559,7480,0.61584204),(2559,8414,0.62602186),(2559,10932,0.77838),(2559,18916,0.310004),(2559,20075,0.71970385),(2559,22268,0.9118896),(2559,24995,0.31833753),(2559,30732,0.17506866),(2560,3163,0.9740168),(2560,15059,5.4478023e-2),(2560,21263,0.11672825),(2561,5145,7.105011e-2),(2561,9078,0.5786115),(2561,21322,6.617889e-2),(2561,27827,0.79237944),(2561,27977,2.629448e-3),(2562,9997,0.4060333),(2562,18941,5.335193e-2),(2562,26325,0.776134),(2563,543,0.60837644),(2563,3630,0.24754468),(2563,17289,4.1794613e-2),(2563,30833,4.776434e-2),(2564,6124,0.68883723),(2564,11525,0.6677913),(2564,13680,0.9698451),(2564,15146,0.5337801),(2564,20471,0.898623),(2564,30906,0.3269935),(2564,31245,0.6125737),(2565,11498,0.5283643),(2565,18894,0.67418647),(2565,21440,0.25008228),(2566,4975,0.12003548),(2566,12034,0.5473119),(2566,21799,0.4125727),(2566,32548,0.76178235),(2567,11509,0.40399167),(2567,18778,0.5987801),(2568,8146,0.5126413),(2568,11745,0.80843383),(2568,21588,0.5171203),(2569,518,0.18914579),(2569,10978,0.77178997),(2569,14250,5.6969274e-2),(2570,1890,0.19347209),(2570,2067,0.4585195),(2570,18649,0.50849265),(2571,4616,0.68397313),(2571,5779,1.3864991e-2),(2571,6235,0.25277284),(2572,7152,0.3908159),(2572,12185,0.638086),(2572,26785,0.39420742),(2572,31691,0.29025888),(2573,2572,0.4388932),(2573,18519,0.93916976),(2574,7501,0.6960091),(2574,31526,0.4846391),(2575,12670,0.40522334),(2575,25572,0.53034276),(2575,26019,0.709331),(2575,28483,0.7550113),(2575,29510,0.6334746),(2575,31638,0.30808592),(2575,32039,0.2867152),(2576,20660,0.9109353),(2576,25491,0.41542205),(2576,27078,0.41947278),(2577,3538,0.21904011),(2577,18498,0.16174476),(2578,4701,0.85475),(2578,12051,0.9465134),(2578,12945,0.8701746),(2578,15957,0.20267114),(2578,16861,0.21095341),(2578,29071,1.4939498e-2),(2579,2166,0.22928366),(2579,12559,0.80553085),(2579,21383,0.46567214),(2579,26336,0.5543325),(2579,28505,0.54447293),(2579,30109,0.62673753),(2580,4820,0.91383153),(2580,19204,0.8783212),(2580,28706,0.49792987),(2581,2786,7.281031e-2),(2581,28494,0.14937821),(2582,12297,0.24671194),(2582,16019,0.24471208),(2582,24832,0.8010507),(2582,27174,0.33231196),(2583,30013,0.53930426),(2584,126,0.39264563),(2584,7477,0.8882223),(2584,24890,0.60806996),(2584,28771,0.3352769),(2585,4408,0.69004905),(2585,9842,0.69762456),(2585,16137,0.6721933),(2585,17774,1.8082196e-2),(2585,20779,6.992918e-3),(2585,21218,0.29335916),(2585,32214,0.8356071),(2586,1637,0.39945468),(2586,3323,0.38342938),(2586,13807,0.67655957),(2586,18809,0.3310936),(2587,7178,7.442785e-2),(2587,16837,0.41854355),(2587,17576,0.34631708),(2587,23218,0.3807248),(2587,24362,4.697071e-2),(2587,32279,0.47622925),(2588,3579,0.9942991),(2588,10522,0.4896762),(2588,10571,0.90105456),(2588,26155,0.3297439),(2589,5286,0.19235097),(2589,8428,0.8545055),(2589,9973,0.11999136),(2589,12945,0.5972697),(2589,13371,0.5516296),(2589,22604,0.19147705),(2589,22739,0.3378053),(2589,29681,0.88246363),(2589,31347,0.8670384),(2590,2279,0.11614936),(2590,10387,0.58888364),(2590,11050,0.2438261),(2590,24894,0.4285464),(2590,28773,0.77140236),(2591,3084,0.6186396),(2591,11765,0.9831254),(2591,12325,0.5981646),(2591,22974,0.43896624),(2592,806,0.12770309),(2592,2009,0.72924453),(2592,3923,0.8112082),(2592,4096,9.323563e-2),(2592,18490,0.5936161),(2592,25909,0.922837),(2592,26228,0.8506346),(2593,7410,6.264802e-2),(2593,9188,0.23118863),(2593,14300,0.23117648),(2593,19416,8.560069e-3),(2593,21948,5.1518198e-2),(2594,4288,0.5583467),(2594,5163,0.37903923),(2594,15759,0.556433),(2594,26285,0.14714894),(2595,235,0.5991855),(2595,4210,0.41544455),(2595,6153,0.1649904),(2595,18834,0.27233934),(2595,18950,0.652014),(2595,20059,0.495473),(2595,31238,0.9180372),(2596,19174,0.16247025),(2596,23429,0.97610545),(2597,1098,0.68455595),(2597,4880,9.7514786e-2),(2597,16536,0.1298707),(2597,28493,0.5668537),(2597,32581,0.62115103),(2598,5414,3.0114515e-2),(2598,11698,0.9579909),(2598,18983,0.3711991),(2598,22937,0.8469879),(2599,12521,7.555687e-2),(2599,14434,0.7759053),(2599,28879,0.84386814),(2599,31719,0.80022115),(2600,6066,0.483906),(2600,17658,0.31819624),(2600,20932,0.17763208),(2600,22460,0.9757726),(2601,4833,0.36703318),(2601,18164,0.47440764),(2601,28130,0.84850633),(2601,28336,0.19955313),(2602,14814,0.115972474),(2602,32717,0.6795439),(2603,6554,0.48895055),(2603,15699,0.35294142),(2603,20882,0.26632646),(2604,20232,0.4443654),(2604,24737,0.6152879),(2604,26356,0.6578949),(2604,29297,0.8272383),(2605,5209,0.46845016),(2605,17443,0.81065595),(2605,18478,0.9820268),(2605,28660,0.8165772),(2607,11392,0.47187757),(2607,11755,0.33019355),(2608,24878,0.5822332),(2608,30780,0.69653004),(2609,18438,0.45589644),(2609,19122,0.22582711),(2609,25147,8.037905e-2),(2610,15116,0.19166306),(2610,28329,0.40772167),(2611,379,0.6089788),(2611,11371,0.92882085),(2611,15955,0.45465457),(2611,20140,0.21961388),(2612,8439,0.9781311),(2612,12752,0.5286561),(2612,21282,0.5041837),(2612,23827,0.44575664),(2612,26062,3.730029e-2),(2612,26626,0.7200241),(2612,27974,0.7008533),(2613,3377,0.87257475),(2613,23886,0.2807483),(2613,28809,0.81774753),(2613,31979,0.20990936),(2614,1792,0.48248467),(2614,5814,8.8362984e-2),(2614,9752,0.6113783),(2614,17996,0.2524795),(2614,19679,0.6549587),(2614,22152,2.7807143e-2),(2614,30922,0.7249114),(2615,2183,0.85589963),(2615,10273,0.79376173),(2615,13297,0.791643),(2616,4497,0.5859735),(2616,5929,0.79916126),(2616,6279,0.91897666),(2616,7403,0.50174683),(2616,8978,0.52199954),(2616,17136,0.9421448),(2617,3095,0.59778976),(2617,5338,0.85346234),(2617,16458,0.2613217),(2617,20181,0.1858453),(2617,26715,0.5193191),(2617,29792,0.83213645),(2618,15167,0.82456416),(2618,17860,0.22086313),(2618,19547,0.5661159),(2618,21306,0.34347174),(2618,29090,0.42525232),(2619,11385,0.8096422),(2619,15984,0.4246319),(2619,16609,0.46446),(2619,16668,0.28114143),(2619,19018,0.47229058),(2619,21795,0.8380229),(2619,29496,2.7287848e-2),(2620,10560,0.25909522),(2620,16481,0.2300079),(2620,21099,0.54517233),(2620,29225,0.51328415),(2621,8358,0.56409043),(2621,12863,0.21726257),(2621,17734,0.18817875),(2621,23380,0.60109556),(2621,29070,4.401006e-2),(2622,2925,0.50375617),(2622,5540,0.5754438),(2622,13725,0.8460183),(2622,22629,0.9636716),(2622,23335,0.79776937),(2623,3020,0.9521318),(2623,8274,0.18542577),(2624,5648,0.30282253),(2624,11402,0.9226564),(2624,11599,0.7364204),(2624,23128,0.20320596),(2624,28656,0.6861347),(2625,2554,0.8278234),(2625,9308,0.77299273),(2625,9687,0.22906606),(2625,26004,0.4412776),(2625,27441,0.7414398),(2626,6127,0.99494094),(2626,11413,0.38377398),(2626,18556,0.88101447),(2626,25428,0.19330418),(2627,24898,0.58102244),(2627,27027,0.48442215),(2628,10627,0.88573074),(2628,12393,5.1541895e-2),(2628,21324,0.35018268),(2628,27962,0.395421),(2628,31801,0.38170615),(2629,1374,8.458905e-2),(2629,7243,0.7222018),(2629,18668,0.78355724),(2630,1149,6.9336034e-2),(2630,3136,0.7593507),(2630,8409,0.93472475),(2630,13240,0.5344569),(2630,13889,0.7138301),(2630,14218,0.39484373),(2630,16818,0.88879627),(2630,25832,0.44267845),(2630,30659,0.9325692),(2631,5748,0.89289033),(2631,22328,0.22876154),(2632,4148,0.30160543),(2632,10310,0.55146855),(2632,11038,0.6521661),(2632,21878,0.24532938),(2633,16586,0.70558566),(2633,22500,0.28313386),(2633,25432,0.9279573),(2634,14583,0.7349878),(2634,21054,3.1419553e-2),(2635,11238,0.45588806),(2635,27346,0.3463499),(2636,1451,0.44010147),(2636,4478,0.8769301),(2636,11653,0.61316395),(2636,13984,0.6252109),(2636,22270,0.64909595),(2636,24514,0.30982563),(2636,26216,0.3141114),(2636,26859,0.7244632),(2637,4605,0.2858339),(2637,13817,0.40412334),(2637,19588,3.3742223e-2),(2637,20311,0.6943228),(2637,31552,0.32155338),(2639,3588,0.8681511),(2640,6710,0.30621168),(2640,30665,0.71152365),(2641,10308,8.1392996e-2),(2641,14745,0.97583705),(2641,20135,0.89441466),(2641,20763,0.36492205),(2641,25621,0.75921994),(2642,27859,0.69358164),(2643,8472,1.6609514e-2),(2643,9282,0.41784203),(2643,9688,0.13485727),(2643,15684,0.6752669),(2644,15543,0.8681177),(2644,20167,0.7933843),(2644,27048,0.21619496),(2644,27193,0.18520738),(2644,27654,0.38547853),(2645,3546,0.9665716),(2645,18626,0.21559621),(2645,19292,0.2375751),(2646,1704,0.9898108),(2646,2827,0.13708863),(2647,3457,0.6407981),(2647,6229,0.7338976),(2647,26190,0.55438274),(2647,27132,0.7465239),(2648,4815,3.600642e-2),(2648,14953,0.23124792),(2649,4635,0.8519165),(2649,10455,0.28435713),(2649,20596,0.3372833),(2650,14016,0.79286623),(2650,21506,0.7730221),(2650,26719,0.15496115),(2650,29185,0.95311344),(2651,753,0.8071908),(2651,11115,0.4828012),(2651,22429,0.51353145),(2651,26358,0.95315695),(2651,27370,0.5746426),(2651,28784,0.2124098),(2651,31301,0.617561),(2652,18358,0.2714671),(2653,1800,0.64675796),(2653,15098,0.8717712),(2653,21705,0.49233875),(2653,22790,0.73763245),(2654,5511,0.30069023),(2654,8424,0.54889435),(2654,16847,0.74261206),(2654,25627,0.7277063),(2655,2676,0.98751223),(2655,8429,0.70824575),(2655,9050,0.76790255),(2655,9818,0.9789101),(2655,10649,0.16146864),(2655,25355,0.35244396),(2656,556,0.36355153),(2656,3816,0.8824275),(2656,23945,0.4059974),(2656,27575,0.9639748),(2656,32743,0.41955137),(2657,24953,0.2185834),(2658,15625,0.78123516),(2658,22212,0.50666106),(2659,1144,0.5061316),(2659,1730,0.7324524),(2659,2757,0.8498658),(2659,9827,0.16273738),(2659,12709,0.5745637),(2659,24230,0.17652215),(2659,29091,0.3821308),(2659,32097,0.19496655),(2660,5641,9.8631546e-2),(2660,7087,0.76712495),(2660,7860,0.12581441),(2661,1294,0.5761361),(2661,5281,0.47486448),(2661,6897,0.23625234),(2661,14522,0.8171674),(2661,18604,0.45269045),(2661,23857,0.83521616),(2661,29003,0.9142093),(2662,7003,0.77021146),(2662,11327,0.22661649),(2662,12554,7.029821e-2),(2662,27097,0.3920076),(2662,30854,0.80939084),(2663,14993,0.15057534),(2663,23874,0.71803916),(2663,28341,0.27148667),(2663,31473,0.79833275),(2664,1773,0.7307114),(2664,7036,0.9257177),(2664,16691,4.5047654e-3),(2664,21747,0.88010156),(2665,1972,0.18176313),(2665,3221,0.3744129),(2665,13517,0.22024876),(2665,19442,0.24664903),(2665,28953,0.81277335),(2666,10407,0.55491245),(2666,10671,0.59721655),(2666,14875,0.68561816),(2666,22146,0.5709939),(2666,26212,0.40527987),(2666,28389,0.14199711),(2666,31677,0.6063928),(2667,305,0.46616024),(2667,10115,0.7886828),(2667,26941,0.54303694),(2668,2425,0.44020525),(2668,6089,0.7729335),(2668,7630,0.4890199),(2668,13596,4.745534e-2),(2668,15916,0.7818493),(2668,20619,9.645118e-2),(2669,7434,0.72477067),(2669,9429,0.14344715),(2669,13906,0.37322214),(2670,12973,0.38027403),(2670,24300,0.11192352),(2670,26260,0.509939),(2670,29126,0.14003527),(2671,3063,0.16500117),(2671,7193,0.93644804),(2671,15514,0.9097178),(2671,19951,3.1668466e-2),(2672,341,0.99292535),(2672,457,0.4010297),(2672,4180,0.14070562),(2672,11235,0.57047385),(2672,18128,0.4107294),(2672,18798,0.69351804),(2672,26719,0.43521565),(2672,27137,0.3773488),(2673,2933,0.30897653),(2673,6201,3.828895e-2),(2674,2550,0.5353829),(2674,3211,0.5019326),(2674,17168,0.91161805),(2674,28585,0.451899),(2674,31754,0.33827624),(2675,6209,0.8394708),(2675,15444,0.66183305),(2675,15650,0.33956534),(2675,17149,0.36105704),(2675,31732,0.70805264),(2676,3308,9.433273e-2),(2676,6758,0.6735387),(2676,21895,0.21815091),(2676,32422,0.23216374),(2677,11114,0.36747614),(2677,21144,0.6159388),(2677,27278,0.557428),(2677,28230,0.67057997),(2677,32403,0.3122898),(2679,7032,0.4072328),(2679,8744,0.6989294),(2679,23645,0.124510385),(2679,24422,0.54113334),(2679,30202,0.53290516),(2680,24007,0.81472915),(2680,31087,0.7935377),(2681,269,0.33013675),(2681,7976,0.756435),(2681,32280,0.9076631),(2682,11251,0.378223),(2682,12531,0.8382008),(2682,20429,5.432547e-2),(2682,25237,0.845315),(2682,30113,0.27441922),(2683,17944,0.63176817),(2683,27552,0.8887086),(2683,29660,0.88455045),(2684,27886,0.67212933),(2685,3861,0.8966546),(2685,10678,0.8064937),(2685,16001,0.10351341),(2685,18684,0.37092787),(2685,21327,0.44788963),(2686,8466,2.588332e-2),(2686,9639,0.2903769),(2686,16840,0.18100293),(2687,10672,0.45459083),(2687,26465,0.6580729),(2688,3636,0.34533483),(2688,16999,0.8689377),(2689,13605,0.34266758),(2689,17936,0.2549813),(2689,24118,0.13250025),(2690,2743,0.3037346),(2690,9579,0.9549094),(2690,10159,0.47099936),(2690,31876,0.33738464),(2691,1864,0.84784716),(2691,32318,0.22723283),(2692,3036,0.95968664),(2692,5023,0.60792285),(2692,9871,0.45696464),(2692,11596,0.9536236),(2692,12601,0.1345788),(2692,13451,0.637866),(2692,22188,0.5906546),(2692,22385,0.54984146),(2692,26139,0.8390453),(2692,27778,0.5452795),(2692,28475,0.54980856),(2692,30020,0.26411656),(2693,11532,0.2260729),(2694,26328,0.13601592),(2695,1274,4.6793845e-2),(2695,5159,0.2826977),(2695,16252,4.7472786e-2),(2695,16478,8.969344e-2),(2695,17957,0.78059644),(2695,18438,0.49945188),(2695,21213,0.79576033),(2696,1395,0.5054505),(2696,4926,7.815662e-2),(2696,5788,0.16655442),(2696,6410,0.36773062),(2696,17303,0.37876275),(2696,18453,0.18838745),(2696,20202,0.49359018),(2696,21346,0.41048396),(2696,21669,0.6104492),(2697,2105,0.6916571),(2697,2366,0.19268265),(2697,4105,0.40866384),(2697,10310,0.84134007),(2697,10503,0.93065727),(2697,32096,0.37589923),(2698,8148,0.9314977),(2698,8314,0.7275622),(2698,14982,0.85610855),(2698,17961,0.3744064),(2699,2783,0.6862899),(2699,16637,0.26247296),(2699,20362,0.810672),(2699,21705,0.14600058),(2700,11336,0.44914123),(2700,15596,0.5405309),(2700,25989,0.68198335),(2700,30539,0.51466244),(2700,30931,0.79504585),(2701,1294,0.15767685),(2701,6656,2.9023234e-3),(2701,11889,0.9191385),(2701,12380,9.4991766e-2),(2701,13106,7.948335e-2),(2701,16524,0.7011068),(2701,17823,0.90455765),(2701,31130,0.28788647),(2702,5684,0.16969043),(2702,20413,0.9848804),(2702,22548,0.66055125),(2702,22966,0.9888308),(2702,25391,0.43118772),(2703,111,0.2583212),(2703,8223,0.41715142),(2703,20852,0.9663598),(2703,30271,0.51528233),(2704,4219,0.6679483),(2704,7445,0.82403326),(2704,16009,0.43536085),(2704,18816,0.3495104),(2704,28331,0.9822434),(2705,6231,0.30512017),(2705,8204,0.66618264),(2705,10838,0.40160143),(2705,12618,0.14117591),(2705,25393,0.7988189),(2706,3792,0.9458418),(2706,4427,0.44349864),(2706,6361,0.15808314),(2706,10715,0.67599916),(2706,15887,0.2518921),(2707,3289,0.99521774),(2707,4737,0.37419274),(2707,9177,0.6074016),(2707,15519,7.06693e-2),(2707,21167,0.6125595),(2707,21231,0.24441294),(2708,1634,0.2384506),(2708,3158,0.10120563),(2708,13390,0.5540661),(2708,20510,0.6288347),(2709,8775,0.6219724),(2709,10777,0.84129965),(2709,29246,0.14874718),(2710,684,0.8888807),(2710,14902,2.7802268e-2),(2710,22588,0.49997264),(2711,3785,0.3642232),(2711,6814,0.42665777),(2711,17101,0.39589235),(2711,17823,0.8998591),(2711,21019,0.9117964),(2711,22404,0.49664882),(2711,24590,0.56922156),(2711,26315,0.78201044),(2712,4332,0.54007906),(2712,15287,0.48783484),(2712,27188,0.47748682),(2712,27855,0.90908),(2713,27469,0.47812697),(2713,27599,0.9025211),(2713,27972,0.82073486),(2714,4902,0.35091817),(2714,6828,0.48540807),(2714,13042,0.7806265),(2714,20334,0.20412616),(2714,24035,1.8551599e-3),(2715,1122,0.950596),(2715,1577,0.27195218),(2715,23818,0.36191982),(2715,30583,0.22096995),(2716,8636,0.337565),(2716,32420,6.5125816e-2),(2717,1101,0.15465353),(2717,6645,0.8335571),(2717,13835,0.11673858),(2717,25087,0.8136542),(2717,32229,0.36606976),(2719,8943,0.9843409),(2719,18867,0.25542098),(2719,26817,0.6596689),(2719,29992,0.29448164),(2720,1835,0.15526882),(2720,5133,0.48820093),(2720,13058,0.71263516),(2720,15311,0.96928453),(2720,16379,0.8128942),(2720,24293,0.7243863),(2720,30217,0.87748414),(2721,6693,0.48223057),(2721,14243,0.5080139),(2721,14426,0.1099299),(2721,15011,0.8568778),(2721,15857,0.29409695),(2721,30639,0.13065381),(2721,31816,0.71283937),(2722,77,0.47155255),(2722,11446,0.4442172),(2722,14552,0.20696276),(2722,25678,0.9170669),(2722,30341,0.7555527),(2722,32652,0.68996316),(2723,4358,0.45876524),(2723,28859,0.6816112),(2723,30976,0.88345295),(2724,30408,0.9653447),(2724,32523,0.9617998),(2725,2896,0.27221042),(2725,5600,0.116013095),(2725,14993,0.6976392),(2726,6867,0.37469196),(2726,16599,0.63301176),(2726,23315,0.9747797),(2726,24139,0.2736533),(2726,25802,0.39923224),(2726,30022,0.67265767),(2727,2965,0.78898597),(2727,4542,0.517625),(2727,4608,0.37313437),(2727,4649,0.7308934),(2727,8907,0.36583608),(2727,22145,0.5023107),(2728,4256,0.78379613),(2728,4279,0.2364161),(2728,6153,0.1831526),(2728,10892,0.6892352),(2728,16856,0.9963641),(2728,18598,0.8144092),(2728,20173,0.92633784),(2728,28762,0.36277235),(2729,1595,0.86685324),(2729,6438,0.9825714),(2729,9563,0.99290055),(2729,12087,8.865957e-2),(2729,18369,0.4793848),(2730,1456,0.2664857),(2730,21919,0.45183265),(2730,24286,0.15357138),(2730,30205,0.5930672),(2731,198,0.5995424),(2731,534,0.6691031),(2731,23419,0.7948239),(2731,28080,0.39315936),(2732,8120,0.21739824),(2732,15790,0.54766905),(2732,24607,0.6559204),(2732,31836,0.3295972),(2734,5345,0.60099864),(2734,6578,0.10354307),(2734,12275,0.20921476),(2734,13994,0.5856291),(2734,32433,0.28961417),(2735,4669,0.8587736),(2735,9223,0.29186732),(2735,26667,0.33912304),(2735,32381,0.14533047),(2736,13015,0.43587774),(2736,17031,0.101659276),(2736,24183,0.5492083),(2737,10448,0.15638041),(2737,10611,0.8593813),(2737,10883,0.64817756),(2737,16392,0.60321295),(2737,22556,0.5090235),(2737,31911,0.4666088),(2738,293,0.6514057),(2738,6689,0.31629014),(2738,10064,0.8467351),(2739,722,0.4110031),(2739,8759,0.339411),(2739,26817,0.29433414),(2739,27335,0.69692653),(2740,6633,0.40524164),(2740,17462,0.87494236),(2740,30637,6.996454e-4),(2741,12792,2.829335e-2),(2741,13997,0.95726484),(2741,18704,0.95197994),(2741,19467,0.561488),(2741,20933,0.5183404),(2741,25823,0.76132214),(2742,3718,0.84277654),(2742,13286,0.44006148),(2742,23514,0.16741003),(2742,30891,0.5708028),(2742,31409,0.38703728),(2743,7430,0.95376915),(2743,18184,0.4844873),(2743,20545,0.97130644),(2743,21642,0.44315574),(2743,27306,0.9217779),(2743,28008,8.578103e-2),(2743,31028,0.55117506),(2744,6104,0.99451345),(2745,216,0.24442504),(2745,3632,0.1645276),(2745,20249,0.29969293),(2745,20769,0.678012),(2745,25349,0.46668753),(2745,26794,0.30485028),(2746,2281,0.40430224),(2746,6999,0.7338472),(2746,11208,5.543711e-2),(2746,14225,0.59999245),(2746,17071,0.18317327),(2746,24447,0.38123453),(2747,844,7.4674405e-2),(2747,15534,0.121094815),(2748,10763,0.77329326),(2748,12709,0.25168216),(2748,20897,0.9869174),(2748,21421,0.11104328),(2748,27057,0.88845843),(2748,27108,0.4315193),(2749,120,0.6566736),(2749,20812,0.73393327),(2749,21617,0.3830466),(2750,3443,7.6757945e-2),(2750,6485,0.4327164),(2750,15292,0.55852497),(2750,15575,0.9081387),(2751,5670,0.73526937),(2751,5700,0.9977616),(2751,11962,0.41106412),(2751,21131,0.28246942),(2751,22092,0.51069593),(2751,24520,0.7540771),(2751,25576,0.725337),(2751,26074,0.77709955),(2752,12370,0.4576855),(2752,13908,0.29416606),(2752,25503,0.23406398),(2752,27808,4.899617e-3),(2752,31876,0.69961166),(2753,7878,0.7354723),(2753,20219,0.97130746),(2754,2529,7.178619e-2),(2754,3863,0.7898342),(2754,4802,0.33983845),(2754,5034,0.12701228),(2754,9243,0.36618543),(2754,22176,0.8285935),(2754,26262,0.33111498),(2755,4736,0.6508661),(2755,7608,2.9249238e-3),(2755,8940,0.8904667),(2755,11986,0.4137096),(2755,22224,0.7523777),(2756,415,0.9639851),(2756,484,0.89868605),(2756,23136,0.9966962),(2756,23264,0.15253404),(2756,24292,0.288702),(2757,5339,0.44424683),(2757,21394,0.6214823),(2757,24757,0.98894966),(2757,29751,1.696841e-2),(2758,5772,0.1758659),(2758,23664,0.6639447),(2758,27191,0.10306233),(2758,29451,0.57673985),(2759,14998,0.93373466),(2759,20697,0.9555864),(2759,21973,0.286002),(2759,28354,0.6112804),(2760,1580,4.8487324e-2),(2760,8160,0.23661992),(2760,12160,0.9962594),(2760,12249,0.24641031),(2760,18059,0.6758449),(2760,28753,0.83604616),(2761,6080,0.65237004),(2761,19936,0.8593419),(2761,20451,4.7078338e-2),(2761,28579,0.8434498),(2762,886,0.73077047),(2762,9865,0.99646163),(2762,15424,0.71719193),(2762,24385,0.79342026),(2762,29981,0.61747205),(2763,2050,0.82555765),(2763,25370,0.26282498),(2763,26615,0.45650747),(2764,6683,0.899043),(2764,8056,8.232512e-2),(2764,12577,0.26920745),(2765,925,4.363702e-3),(2765,10677,0.54565835),(2765,19537,6.7429945e-2),(2765,19774,0.60175383),(2765,29410,0.5269306),(2766,4185,0.6716907),(2766,16561,0.36972693),(2766,18234,0.89359486),(2766,30137,0.9368296),(2767,201,0.54902035),(2767,2299,0.9778539),(2767,3954,0.37119618),(2767,14359,0.20711818),(2767,17120,2.6172386e-2),(2767,25577,0.98395187),(2768,2869,0.89665675),(2768,8018,0.66788065),(2768,30557,0.19913997),(2769,2020,0.67331696),(2769,4559,0.6966049),(2769,7819,0.7035517),(2769,12638,0.53596485),(2770,3126,0.6956203),(2770,5084,0.42734668),(2770,5808,0.9433249),(2770,8123,2.0447358e-2),(2770,25866,0.32503426),(2770,32437,0.6211567),(2771,4057,5.113858e-2),(2771,7429,0.5308598),(2771,10552,0.15336993),(2771,22529,0.5316409),(2771,24124,0.4290872),(2771,27265,0.90598184),(2771,30235,0.5618783),(2772,1044,0.8255023),(2772,16645,0.9616399),(2772,26593,0.61940837),(2773,265,0.144209),(2773,13769,8.156542e-3),(2773,15980,0.5357204),(2773,18330,0.6522853),(2773,18632,0.11898238),(2773,19319,0.14890893),(2773,20036,0.8475207),(2774,7318,0.6869772),(2774,8695,0.39904112),(2774,15737,8.830438e-2),(2774,21944,0.9747001),(2774,23624,2.9672863e-2),(2775,8056,2.1784509e-2),(2775,21963,0.6991673),(2775,28934,0.9963539),(2776,437,0.9114546),(2777,24118,0.9047741),(2777,26063,0.13321735),(2777,26541,0.82118833),(2777,29387,0.27572176),(2778,1528,0.7464415),(2778,11547,4.6745505e-2),(2778,15117,0.7404261),(2778,16554,6.071121e-2),(2778,32108,0.730539),(2779,4305,0.5265251),(2779,17203,0.62224907),(2779,30654,0.98564243),(2780,10216,0.902496),(2780,19922,0.35710454),(2780,28624,0.63087034),(2780,30536,0.10728243),(2780,32522,0.8324952),(2781,1572,0.3079809),(2781,4043,0.15039793),(2781,6799,0.14148033),(2782,1330,0.2641541),(2783,4316,0.26344255),(2783,11476,0.9410602),(2783,12245,0.9898149),(2783,15643,0.48764995),(2783,17550,0.44820133),(2783,28953,0.9467048),(2784,2499,0.8360627),(2784,6579,0.108325146),(2784,16133,0.9644842),(2784,23435,0.8831821),(2785,12987,0.6767634),(2785,18833,0.7441624),(2785,20498,0.98975146),(2786,11072,0.7650428),(2786,17399,0.2546624),(2786,19244,4.5645766e-2),(2786,24641,4.8780747e-2),(2787,25,0.5781028),(2787,129,0.607424),(2787,12974,0.22476453),(2788,3692,0.8683886),(2788,13494,0.2965421),(2788,21862,0.59140104),(2788,28102,0.7511795),(2789,3582,0.93467754),(2789,20547,5.386576e-3),(2789,23115,0.76625377),(2789,26557,0.3053462),(2789,28884,0.15147822),(2789,32197,0.62948453),(2790,919,0.6512153),(2790,3057,5.281871e-2),(2790,13033,0.21077164),(2790,17154,0.8997838),(2790,18179,0.88943607),(2790,25091,0.9731948),(2790,26197,8.9073725e-2),(2791,5811,0.16471298),(2791,11746,0.94125676),(2791,11771,0.5871901),(2791,17946,8.195057e-2),(2791,20772,0.8158089),(2791,29880,0.35611454),(2792,894,0.19714963),(2792,5361,0.2760166),(2792,13628,0.73169357),(2792,17192,0.60288423),(2792,22884,0.7251652),(2793,1751,0.13608342),(2793,6742,5.14048e-2),(2793,18916,0.90285164),(2794,3208,0.45435798),(2794,22354,0.47690937),(2795,2026,0.7897569),(2795,6288,0.6884957),(2795,13898,0.2420135),(2795,17858,0.50735176),(2795,19743,0.4197489),(2796,6508,9.5507994e-2),(2796,15397,0.39647388),(2797,13954,0.51547545),(2797,18698,0.6475816),(2797,18972,0.7832416),(2797,19875,0.17245078),(2797,19913,0.6165196),(2797,29161,0.37619564),(2798,4337,0.34013203),(2798,7916,0.2520738),(2798,10719,0.11655936),(2798,17313,9.501502e-2),(2798,22276,0.41135898),(2798,32556,0.51177794),(2799,3696,0.6969966),(2799,3824,0.84313923),(2799,20024,0.15316898),(2800,5952,0.69862694),(2800,19784,0.36868876),(2800,30477,0.58438957),(2801,25467,9.185876e-2),(2801,30318,4.475254e-2),(2802,694,0.14934243),(2802,28945,0.62228143),(2803,4635,8.8464856e-2),(2803,27650,0.24992494),(2803,32321,0.5451301),(2804,661,2.2728166e-4),(2804,28602,0.23549092),(2805,20704,0.8311827),(2805,31276,0.45103034),(2806,8180,0.1556892),(2806,13766,0.100568384),(2806,13852,0.5217443),(2806,26977,8.243819e-2),(2806,31441,0.61249363),(2807,2405,0.5861089),(2807,2685,0.7890953),(2807,3390,0.9785525),(2807,3582,0.33133715),(2807,17525,0.3623401),(2808,15721,0.7466078),(2808,22253,0.85018116),(2809,17960,8.924735e-2),(2809,28538,0.556277),(2809,28804,7.410134e-2),(2810,14769,0.2533848),(2810,32711,0.23203695),(2811,441,0.8291379),(2811,5553,0.523509),(2811,14598,0.7106447),(2811,16326,0.14240777),(2811,19164,0.32489297),(2811,24271,0.9491381),(2812,1249,0.36219892),(2812,2795,0.50958925),(2812,11944,0.38738903),(2812,19336,0.35995343),(2812,22579,0.8032361),(2812,28910,0.686755),(2813,13645,0.829241),(2813,15355,0.56226856),(2813,20315,0.20332499),(2813,22874,0.82311034),(2813,24677,0.36967984),(2813,28057,0.5361536),(2814,2310,0.6334612),(2814,6871,0.9223222),(2814,14490,0.69162005),(2814,25199,0.40237108),(2814,25711,0.74655217),(2815,12343,0.9340874),(2815,15795,7.8689724e-2),(2815,23690,0.6301933),(2816,30241,0.38786864),(2816,30650,0.72511804),(2818,3754,0.47540742),(2818,7392,0.44567043),(2819,6325,0.5092538),(2819,32761,0.11643186),(2820,9259,0.8570051),(2820,9803,0.1393992),(2820,10950,0.41719732),(2820,14522,0.5880602),(2821,12017,0.24226704),(2821,15404,0.7210018),(2822,26402,0.43747902),(2823,4470,0.3214455),(2823,6152,0.20241818),(2823,18800,0.2763016),(2823,22804,0.6142469),(2823,29222,0.63071203),(2823,31354,0.23165943),(2824,2799,0.7155622),(2824,20930,0.44590816),(2824,23824,0.29082397),(2824,24105,0.73936087),(2824,26442,0.90429884),(2824,32137,0.21530306),(2825,13831,0.87885886),(2825,27240,0.7739102),(2826,22785,0.8633539),(2826,29166,0.37439823),(2827,403,0.6723553),(2827,12786,0.77338284),(2827,13813,0.43176082),(2827,17742,0.96339285),(2827,18563,0.18234554),(2827,20393,0.6578201),(2827,24510,0.7328549),(2827,25107,0.97465426),(2827,27960,0.9021261),(2827,28848,0.8008331),(2828,15,0.49682656),(2828,4425,0.85512084),(2828,4877,3.4796923e-2),(2828,11932,8.469002e-2),(2828,14958,0.30641726),(2828,15751,9.211741e-2),(2828,25879,0.13913813),(2828,29228,0.77881294),(2829,2094,0.72064596),(2829,13474,0.72057116),(2829,17877,0.41575658),(2829,25363,0.8001632),(2830,1735,0.25727946),(2830,12125,0.53086144),(2830,18093,0.77309334),(2830,21287,7.022174e-2),(2831,846,0.3230788),(2831,10746,0.91476727),(2831,18818,0.5477661),(2831,26047,0.5445291),(2831,30818,0.8256812),(2833,3171,0.1591561),(2833,12334,0.6835707),(2833,13843,0.4720958),(2833,18789,3.0843003e-3),(2833,20093,0.21882491),(2833,26717,0.9667027),(2833,30029,0.8260832),(2834,7919,0.69199467),(2834,9767,0.109428234),(2834,14147,0.9933105),(2834,22590,0.3547009),(2835,3240,0.91090775),(2835,6573,0.7356294),(2835,9063,0.5965298),(2835,12676,0.4475942),(2835,16720,0.16603403),(2835,25283,0.970234),(2835,29807,0.40520066),(2836,15246,0.99270517),(2836,26790,0.83012164),(2836,29519,0.5757863),(2836,29637,0.36070842),(2837,7666,0.5778633),(2837,9149,0.4611224),(2837,9179,0.8595201),(2837,24443,0.88512236),(2837,26222,0.903854),(2837,31188,0.40188143),(2838,23565,0.8355018),(2839,5589,0.29223862),(2839,10404,0.19942763),(2839,12523,0.204077),(2839,17106,0.5051682),(2839,17756,0.7736565),(2839,23539,0.8517965),(2839,32761,0.80234855),(2840,1507,0.21761101),(2840,3703,0.8196546),(2840,6775,0.430902),(2841,4384,8.512856e-2),(2841,21126,0.28587154),(2841,30413,0.124933),(2842,7884,0.5151371),(2842,8305,0.5646006),(2842,8546,3.572513e-3),(2842,25242,0.5236459),(2842,30761,0.2575003),(2842,30882,0.36817372),(2843,8543,6.745427e-2),(2843,9632,0.23787458),(2843,21000,0.8015862),(2844,10704,5.2033715e-2),(2844,12831,6.648855e-2),(2844,29686,0.4851292),(2845,3837,0.7365547),(2845,7816,0.60306394),(2845,24821,0.7921475),(2845,26043,0.5536434),(2845,30215,8.169213e-2),(2845,32661,0.85224396),(2846,5467,0.5013697),(2846,12495,0.6611997),(2846,13230,0.68577546),(2846,16967,0.5546279),(2846,27894,0.4519996),(2846,29798,0.34507698),(2846,29907,0.96199757),(2847,1988,0.7787703),(2847,3762,0.4332247),(2847,11458,0.22147313),(2847,26843,0.31726867),(2847,26918,0.29849225),(2847,28407,0.31858435),(2848,7641,0.5492921),(2848,11930,0.91825044),(2848,14749,0.75746167),(2848,18155,0.8378144),(2849,14430,0.3486276),(2849,23621,0.6056624),(2850,4835,0.3425424),(2850,21211,0.16444829),(2851,2354,0.8329518),(2851,6450,0.55572087),(2851,7898,0.2308043),(2851,9738,0.92852664),(2851,12187,0.9409444),(2851,16562,0.82901156),(2851,24667,0.7329528),(2851,28137,0.27976677),(2852,694,0.100009784),(2852,5174,0.46921936),(2852,14389,0.13069667),(2852,24151,0.7281636),(2853,4987,0.6433953),(2853,17722,0.48349977),(2853,17892,0.45675847),(2854,5783,0.5199039),(2854,7858,0.9276728),(2854,13605,0.81376964),(2854,17137,0.9113138),(2854,18565,0.7040843),(2855,2873,0.34441423),(2855,22570,0.14964564),(2856,19915,0.46914077),(2856,23777,0.19649503),(2857,16784,0.28882882),(2857,19401,0.5932152),(2857,25388,0.5461156),(2857,28219,0.62237334),(2858,1363,0.81809795),(2858,2504,0.29524356),(2858,10391,0.9652438),(2858,16642,0.24274123),(2858,17276,0.12849562),(2858,19936,0.5670365),(2858,22518,0.6299344),(2859,14751,0.32119748),(2859,15446,0.5130537),(2859,16070,0.5287357),(2859,20880,6.947977e-2),(2859,21101,0.4968224),(2859,24225,0.61583275),(2860,21,0.8559403),(2860,13684,0.13285506),(2861,4365,0.6437462),(2861,13090,0.5386873),(2861,14769,0.17037186),(2861,14831,0.6821697),(2861,30474,2.8691186e-2),(2862,16940,0.60880905),(2862,29754,0.2728228),(2862,30134,0.41797855),(2862,31649,0.94906557),(2862,31698,0.24303277),(2862,32107,0.7256482),(2863,7278,0.55739903),(2864,7613,0.23761053),(2864,20692,0.9041093),(2864,28754,0.81539875),(2865,22193,0.89730513),(2866,4568,0.22957425),(2866,12161,0.18604131),(2866,22145,0.59480405),(2866,24253,0.549495),(2867,1813,0.2895756),(2867,6641,0.6334677),(2867,16550,5.7537716e-2),(2867,21510,6.64326e-2),(2867,30241,0.41883755),(2868,1430,0.51296186),(2868,26189,0.38544053),(2869,11483,0.40106484),(2869,14257,0.9290552),(2869,20524,0.7837163),(2869,30353,0.5244172),(2870,3431,0.13566205),(2870,21819,0.4656933),(2871,2457,0.6382316),(2871,7022,0.48651096),(2871,16141,0.98824066),(2871,25841,8.017402e-2),(2871,30284,0.24468336),(2872,14023,0.38539857),(2872,23407,0.53578144),(2872,26410,0.46670857),(2873,140,0.44444203),(2873,5183,0.58780396),(2873,11118,0.46617365),(2873,17801,0.50484645),(2873,21149,0.4902339),(2873,30869,0.4366735),(2875,929,0.18471068),(2875,1332,0.5756596),(2875,1430,0.7211756),(2875,4061,4.305231e-2),(2875,6388,6.8980497e-3),(2875,17927,0.9316576),(2875,27655,0.22688581),(2876,5766,0.83322465),(2876,19928,0.9702515),(2876,26929,0.805344),(2877,6304,0.32405335),(2877,6475,0.3198641),(2877,25704,7.5286925e-3),(2877,29099,8.980353e-3),(2877,30808,0.3018774),(2878,12981,0.32056916),(2878,21478,0.5759635),(2878,23609,0.5205681),(2879,443,0.80605614),(2879,6958,0.12288947),(2879,22102,0.13804859),(2879,29834,0.61692184),(2880,1776,0.90045446),(2880,21849,0.9474478),(2880,22825,0.55303097),(2880,25203,3.9868332e-2),(2880,29290,0.5280256),(2880,31235,0.30206114),(2880,31679,8.9365e-2),(2880,32031,0.98194486),(2881,5595,9.239921e-2),(2881,17188,0.1398948),(2881,22992,0.90399134),(2881,26753,0.6129436),(2881,31449,0.16950603),(2882,965,0.64526737),(2883,1040,0.6905664),(2883,26840,0.23290089),(2884,12765,0.6125356),(2884,21376,0.14782572),(2884,21729,0.8002107),(2885,19805,8.2861185e-3),(2885,23416,0.70624727),(2886,9828,0.7793274),(2886,25852,0.43342006),(2886,32635,0.749059),(2887,16668,0.22954628),(2888,6167,0.9507397),(2888,10519,0.38877416),(2888,20759,0.9564711),(2889,10862,0.6459042),(2890,16375,0.27692425),(2890,16963,0.34556323),(2890,25979,0.249515),(2890,30340,0.8656066),(2891,112,0.7421983),(2891,2344,0.42387542),(2891,5182,0.11416136),(2891,11982,0.13480492),(2891,17697,0.12954491),(2891,21625,0.1248292),(2891,32516,0.54984945),(2892,23840,2.4262194e-2),(2892,27556,0.87436944),(2893,2458,0.209487),(2893,3218,0.9281703),(2893,3361,0.47643766),(2893,3477,0.27057257),(2894,3764,0.42346025),(2894,13221,0.1360334),(2894,25373,0.16371398),(2895,4270,0.81800026),(2895,9160,0.5661825),(2895,10804,0.3215893),(2895,13322,0.52174175),(2895,23115,0.6540395),(2895,26142,0.25818914),(2896,3669,0.16923226),(2896,25195,0.5092333),(2896,25512,0.24021384),(2896,30754,0.4477725),(2896,30922,0.77359766),(2897,3456,0.39670807),(2898,6301,0.5830578),(2898,16861,0.2392966),(2898,16918,0.85162544),(2898,26286,0.6031581),(2899,3354,0.10327507),(2899,3617,0.7867539),(2899,8306,5.943221e-2),(2899,11483,8.1987776e-2),(2899,11816,0.91835),(2899,20922,0.47704434),(2899,29337,0.8656585),(2900,7155,0.7187587),(2901,14998,0.44948062),(2901,22316,0.28370145),(2901,24028,0.1769372),(2901,29198,0.5063365),(2902,959,0.8051962),(2902,4552,0.9957093),(2902,7325,0.9051296),(2902,13288,0.5038587),(2902,17627,0.7737789),(2902,17975,0.441868),(2902,28268,0.4410191),(2903,9359,0.2566231),(2903,13834,0.7625558),(2903,14876,0.152824),(2903,18796,0.16348286),(2903,21161,0.11430274),(2903,25573,0.42407984),(2904,13137,0.67555505),(2904,13885,0.64960974),(2904,18209,9.904439e-2),(2904,30713,0.10004281),(2905,5183,0.96093804),(2905,10471,0.399878),(2905,11048,0.92692465),(2905,15344,0.8612418),(2905,19001,0.36042285),(2905,32131,0.4573772),(2905,32694,0.6480512),(2906,3285,0.7405057),(2906,5451,6.0560893e-2),(2906,19218,0.50417507),(2906,26694,0.9010192),(2907,2756,0.583957),(2907,17721,0.104326405),(2907,21790,0.87349236),(2907,25347,0.89353544),(2907,26434,0.52982914),(2907,31138,0.66689086),(2908,3921,1.7359672e-2),(2908,22489,0.6485706),(2909,7559,0.3259498),(2909,27344,0.8471911),(2909,30953,0.9309474),(2909,31745,0.24870662),(2911,9206,0.3006187),(2911,26008,0.60909206),(2912,12977,0.79334384),(2912,16579,0.97621924),(2912,19207,0.55805784),(2912,20179,0.8790695),(2912,23910,0.5428712),(2912,27326,0.11773897),(2913,7003,0.5564863),(2913,8081,0.88004535),(2913,14282,0.740034),(2913,16920,0.17294003),(2913,18782,0.40246797),(2913,25433,5.890757e-2),(2914,3369,0.121944055),(2914,9913,0.7896291),(2914,10051,0.11683848),(2914,13654,0.73869455),(2914,20261,0.52020967),(2914,24129,0.81138724),(2914,31152,0.2020879),(2915,8695,0.5885941),(2915,13809,0.28075454),(2915,15505,0.76500565),(2915,22034,0.66130733),(2915,31924,0.89844567),(2916,13278,0.7775109),(2916,23462,0.6245072),(2917,9920,0.122564435),(2918,4919,1.6784534e-2),(2918,7146,0.33954751),(2918,13927,0.6167832),(2918,14576,0.13157299),(2918,25542,0.46301436),(2918,27344,0.1955366),(2919,18251,0.19511856),(2920,9860,1.8721862e-3),(2920,17583,0.49918377),(2920,30759,0.9675166),(2921,5591,0.57249635),(2921,9554,0.26416907),(2921,12491,0.83688265),(2921,15466,0.10050913),(2921,16460,0.16715574),(2921,29916,0.43877232),(2922,1242,0.24959177),(2922,6542,0.8782937),(2922,7102,0.45598033),(2922,11395,0.16687217),(2922,29673,0.5502366),(2922,31966,0.89263946),(2923,28305,8.613117e-4),(2923,28994,1.3465813e-2),(2923,29431,5.5702202e-2),(2924,700,0.6163354),(2924,13706,0.7925704),(2924,26574,0.43925712),(2924,29016,0.1756791),(2925,1620,4.452935e-2),(2925,6460,0.9763786),(2925,11047,0.9352137),(2925,12013,0.107829936),(2926,7289,0.70339423),(2926,12293,0.20625028),(2926,19117,0.26290503),(2926,24577,0.5986301),(2926,27032,0.17162025),(2927,880,0.44062114),(2927,13777,0.65585405),(2927,13803,0.45043665),(2927,26528,0.29669508),(2928,5612,0.4787058),(2928,16247,0.27346373),(2928,22737,0.2763395),(2929,11086,0.46990594),(2930,20394,0.36952347),(2930,23735,0.27002975),(2930,31422,0.12015342),(2931,5699,0.18797487),(2931,7115,0.5322915),(2931,7628,0.32612625),(2931,21276,0.73399043),(2931,26003,0.77790713),(2931,26865,0.90307695),(2931,27434,0.28861058),(2931,29112,0.5237842),(2932,7986,0.3824733),(2932,10162,0.7689562),(2932,12065,0.21193324),(2932,14701,8.922478e-2),(2932,29306,0.1367565),(2933,3377,8.935397e-2),(2933,6231,0.5417214),(2933,7948,0.24896182),(2933,11033,0.54516923),(2933,14313,0.18805169),(2933,21274,0.46352264),(2933,27823,4.7515873e-3),(2933,28182,0.7921407),(2933,29982,0.90657234),(2933,30573,0.1909409),(2933,32415,0.17046323),(2934,366,0.8890005),(2934,8186,0.21555379),(2934,11033,0.9671174),(2934,19301,0.27066302),(2934,19607,0.8203785),(2934,23410,0.78500384),(2934,26351,0.4934396),(2935,24143,0.55762017),(2935,31401,0.28107032),(2935,31552,0.58370763),(2936,5122,0.43372297),(2936,6035,0.86718667),(2936,20416,3.542166e-2),(2936,25650,0.34772098),(2937,8803,0.8731796),(2937,11261,0.63138276),(2937,18572,9.754526e-2),(2937,21431,0.40494302),(2937,27631,0.18944134),(2938,8397,5.1252488e-2),(2938,16724,0.87081885),(2938,20857,0.6396774),(2939,888,0.93116426),(2939,4728,0.2554135),(2939,16129,0.24237776),(2939,17331,6.12135e-3),(2939,26546,0.44394964),(2939,30830,0.3947207),(2940,2067,0.18782319),(2940,3483,0.58937913),(2940,6295,0.8102366),(2940,16857,4.2172e-2),(2940,20117,0.61149603),(2941,4675,0.74209714),(2941,5670,0.70789367),(2941,22552,0.2298304),(2942,1296,0.52599615),(2942,2278,0.68842965),(2942,24383,0.45214015),(2942,24803,0.8073819),(2942,25606,0.95757353),(2942,26692,0.21383056),(2943,2255,0.84549695),(2943,24748,0.45502123),(2944,4622,0.84428114),(2944,27837,0.66119826),(2944,28323,0.5542139),(2944,30892,9.401325e-2),(2944,32314,0.7461831),(2945,9555,0.7445894),(2945,11519,0.32912666),(2946,6327,0.35162434),(2946,15704,0.7701088),(2946,20261,0.2775655),(2947,2507,0.57960886),(2947,14575,0.5354434),(2947,15341,0.94777566),(2947,17501,0.6719376),(2947,20905,0.36485302),(2947,26782,3.9241903e-2),(2948,11245,7.2910614e-2),(2948,15793,0.56031793),(2949,5793,0.94084984),(2949,17470,0.4928134),(2949,24581,0.8001952),(2949,24880,0.41501454),(2950,3884,0.7102962),(2951,15823,0.948735),(2951,19256,1.7966045e-2),(2952,2878,0.9404224),(2952,14629,0.25263664),(2952,20762,1.904191e-2),(2953,8806,0.85054165),(2953,18744,0.8284477),(2954,92,0.21958345),(2954,2487,0.48083296),(2954,5341,0.27266553),(2954,16581,0.81073487),(2954,20884,0.123873495),(2954,24420,0.80836654),(2955,942,0.3388345),(2955,14298,0.32579708),(2955,25700,0.91364807),(2956,5217,0.3858117),(2956,6121,0.27988794),(2956,16919,0.342391),(2956,31558,0.7330116),(2957,8490,0.13166781),(2957,12747,0.7341828),(2957,16654,0.53827274),(2957,20359,0.5920827),(2957,27889,0.61354154),(2957,29667,1.2345331e-2),(2958,1417,0.30225366),(2958,28182,6.768375e-2),(2958,31496,0.48229507),(2958,32094,0.28572237),(2959,8610,3.488734e-2),(2959,18728,0.8078564),(2959,27805,0.91815996),(2960,4059,0.37695816),(2960,6679,0.15897796),(2960,26642,0.47592494),(2961,2388,0.75697917),(2961,4808,0.9321441),(2962,5103,0.5750907),(2962,13502,0.45834923),(2962,26171,0.5565953),(2963,7857,0.45812204),(2963,17819,0.29243788),(2963,21179,0.41217175),(2963,26689,0.13380228),(2964,28759,0.5829711),(2966,12824,0.98749053),(2966,30183,0.75786155),(2967,10276,0.21795967),(2967,10426,0.29240555),(2967,12927,0.40154347),(2967,15772,0.87009066),(2968,2751,0.22847041),(2968,20064,0.36208886),(2968,26286,0.83244824),(2968,28974,0.7783806),(2969,17616,0.59473),(2969,21234,0.7000593),(2969,21857,0.33233625),(2969,22417,0.85992473),(2969,25801,0.28501827),(2969,31755,0.17640066),(2970,14234,0.10125767),(2971,5317,0.8625975),(2971,18008,0.21782641),(2971,30443,0.5446734),(2973,1024,0.2831996),(2973,28226,0.81591964),(2973,30004,0.7611584),(2973,32344,0.6771523),(2974,28311,7.099553e-2),(2975,9435,0.240042),(2975,12506,8.680765e-2),(2975,16942,0.4771703),(2975,27157,0.80290955),(2976,2482,0.3813617),(2976,5765,6.8210356e-2),(2976,25422,2.9200021e-2),(2976,29232,0.7660506),(2976,29596,0.30352437),(2977,3011,0.2777765),(2977,9550,0.41676572),(2977,27012,0.3977917),(2978,5513,0.911072),(2978,13568,0.80321246),(2978,18552,0.8059205),(2978,32726,0.79530144),(2979,770,1.45127075e-2),(2979,13079,0.4322602),(2979,14660,0.7020749),(2979,18595,1.636044e-2),(2979,26027,0.22475466),(2979,27097,0.8055256),(2979,27219,0.6804424),(2979,29300,0.17770503),(2980,3802,0.18603075),(2980,9689,0.9868712),(2980,14149,0.48776612),(2980,21239,2.0645311e-2),(2980,30202,0.90165895),(2981,3192,0.36573383),(2981,3227,0.7230568),(2981,4338,0.42329308),(2981,11018,0.61467344),(2981,17121,0.52168566),(2981,19117,3.7041105e-2),(2981,28441,0.7311262),(2981,32225,0.83455676),(2982,7789,0.20914026),(2982,9302,0.81656456),(2982,10878,5.077939e-2),(2982,11163,3.4253273e-2),(2982,21859,0.89494276),(2984,13098,4.5615777e-2),(2984,28688,0.9033893),(2984,32290,0.9029463),(2985,5775,0.9951548),(2985,5779,0.5989977),(2985,9937,0.8029879),(2985,11204,0.95715386),(2985,26216,0.9912196),(2986,5840,0.8463895),(2986,9054,0.9901477),(2986,21599,0.38029015),(2986,30015,0.5026854),(2987,691,0.3176052),(2987,3138,0.31067523),(2987,21282,0.3798445),(2987,32254,0.25103772),(2988,6474,0.37556005),(2988,9802,0.11186085),(2989,6771,2.1003531e-2),(2989,12849,0.582099),(2990,2696,0.48175114),(2990,3845,0.40825436),(2990,3993,0.98140085),(2990,11145,0.66652626),(2990,12134,0.4400816),(2990,17787,0.6206894),(2990,19600,0.39170888),(2990,19984,0.7198692),(2990,23995,0.30567777),(2991,4795,0.90203154),(2992,7948,4.6995156e-2),(2992,14382,0.981558),(2992,15118,0.42948428),(2992,15274,0.91139543),(2992,15880,0.6427145),(2992,29242,0.84094125),(2992,32020,0.6240911),(2993,2942,0.6925264),(2993,3990,0.2609482),(2993,7942,0.6063627),(2993,19678,1.3846496e-2),(2993,26198,0.23231164),(2993,26272,0.97060317),(2994,2763,0.66697973),(2994,11834,0.9597586),(2994,21196,0.87677425),(2995,30711,0.4794083),(2996,21789,0.8686599),(2996,32707,0.5584766),(2997,5503,0.6212127),(2997,10065,0.24062462),(2998,5091,1.2770323e-3),(2998,7175,0.93791753),(2998,17162,0.72106797),(2998,24829,9.8166056e-2),(2998,30629,0.26379836),(2999,5379,0.15164155),(2999,14117,0.10562105),(2999,16009,0.31180575),(2999,17167,0.82178015),(2999,18184,0.2399966),(2999,18822,2.8832525e-3),(2999,18840,0.65897536),(2999,21142,0.66718155),(2999,25552,0.21826532),(2999,30595,0.9701801),(3000,3946,0.76908356),(3000,5610,0.35999736),(3000,5799,5.4087196e-2),(3000,7742,0.25223956),(3000,11366,0.2669221),(3000,13464,0.77921814),(3000,32564,0.14975324),(3001,1236,0.8164731),(3001,4394,0.6768004),(3001,12704,0.771837),(3001,17830,9.345709e-2),(3002,3045,0.9883459),(3002,4367,0.51684654),(3002,12242,0.7251375),(3002,16772,0.5344382),(3002,16966,0.26703763),(3002,19117,0.6022954),(3002,30727,0.40464514),(3003,1842,0.4330692),(3003,3086,0.8057203),(3003,17874,0.9276438),(3003,28446,6.2128525e-2),(3004,560,0.1531829),(3004,1885,0.48350742),(3004,20482,0.44644105),(3004,21343,0.579512),(3005,3454,0.26695845),(3005,18534,0.90077627),(3005,19738,0.4903615),(3006,13972,0.2425506),(3006,20495,0.19729061),(3006,21554,0.5314716),(3007,7220,0.26084778),(3007,12112,0.110570945),(3007,19423,6.412105e-2),(3007,19965,0.44890738),(3008,3305,0.36547723),(3008,4848,0.111468926),(3008,10932,0.33572367),(3008,11183,0.7012124),(3008,14425,0.13558717),(3008,17869,0.8104354),(3009,17523,0.7169744),(3009,21436,0.35895157),(3009,23808,0.32241914),(3010,3575,0.3777816),(3010,10609,0.23264319),(3010,31239,0.70808965),(3011,3380,0.79535174),(3011,5404,0.23921365),(3011,15942,0.64729863),(3011,20607,0.6977216),(3012,6571,0.1491534),(3012,31496,0.9087985),(3013,2339,0.6002834),(3013,10518,0.49767372),(3013,16662,0.93268615),(3013,29242,0.20699437),(3014,7371,9.63712e-2),(3014,7573,0.10984704),(3014,7860,0.8563432),(3014,16780,5.6835346e-2),(3014,23788,7.302054e-2),(3014,28982,0.67759764),(3014,29839,0.66237575),(3015,8709,0.9970421),(3016,378,0.16138132),(3016,1929,7.2422246e-3),(3016,21713,0.1081576),(3016,24175,0.62680113),(3017,3763,0.41180032),(3017,3990,0.9663989),(3017,4195,2.136713e-2),(3017,4317,0.7741607),(3017,15964,0.13506),(3018,3897,0.18234377),(3018,4647,0.64681244),(3018,11433,0.11439447),(3018,20529,0.6753187),(3018,28347,0.6990828),(3019,9415,0.6802111),(3019,16449,3.0168736e-2),(3019,21427,0.7508982),(3020,14642,0.478801),(3020,18095,0.21306074),(3020,20886,0.4046862),(3021,4349,0.13369161),(3021,8425,0.9575337),(3021,14631,0.8915118),(3021,18876,0.45865488),(3021,23188,0.9050572),(3021,27888,0.9462867),(3022,10389,7.663445e-2),(3022,31128,0.6651217),(3023,2975,0.7985708),(3023,12573,0.8927658),(3023,12952,0.12574041),(3024,1022,0.99407905),(3024,3107,4.5927264e-2),(3024,7481,0.6020401),(3024,9708,0.4247762),(3024,9830,0.21462934),(3024,13590,6.535237e-2),(3024,17075,0.3933075),(3024,20511,0.62701565),(3024,25350,0.25249326),(3025,7739,0.8426451),(3025,10686,0.42357257),(3025,11299,9.0477966e-2),(3026,16960,0.73208153),(3026,26693,0.9696811),(3027,9535,0.96509665),(3027,12109,0.31371856),(3027,12590,0.78398305),(3027,32625,0.7290487),(3028,3,0.20876625),(3028,11656,0.30299702),(3028,30623,0.7865388),(3029,610,0.18319675),(3029,15748,0.5446254),(3029,25196,0.7253098),(3030,4918,0.94241166),(3030,18460,0.6696713),(3030,19211,0.1730673),(3030,30484,0.8120747),(3031,6726,0.5956804),(3031,12252,0.41311073),(3031,13388,0.9416849),(3031,15764,0.99019676),(3031,15909,0.7667391),(3031,16938,6.258556e-2),(3031,18188,0.8377869),(3031,26971,0.50141466),(3032,4872,0.13749246),(3032,14259,0.8230076),(3033,9786,0.58378553),(3033,14085,0.2593342),(3033,20101,0.85014594),(3033,31176,0.7256194),(3034,1250,0.6769068),(3034,2458,0.37664267),(3034,3136,0.7985874),(3034,16219,0.46095574),(3034,25368,0.40225583),(3034,32419,0.87412107),(3035,5138,0.18339181),(3035,8350,0.3663947),(3035,11485,0.6722013),(3035,14626,0.900157),(3035,22619,0.9397635),(3035,24208,0.54513216),(3035,28242,0.77148914),(3036,6005,0.48382297),(3036,18523,0.14586762),(3036,19280,0.8058204),(3036,19706,0.5107951),(3036,26822,0.61357933),(3037,1557,0.5709035),(3037,10851,0.2708472),(3037,19397,0.2911195),(3037,23334,0.35995948),(3038,6585,0.6933224),(3039,210,0.8121174),(3039,1146,8.4609546e-2),(3039,12909,0.16818346),(3039,18102,0.62323624),(3039,26173,0.4565314),(3040,22521,0.74673766),(3041,16815,0.6804158),(3041,18383,0.42585793),(3041,19577,0.70984197),(3041,31022,3.1839892e-2),(3042,2131,0.37143168),(3042,25964,0.19011645),(3043,13853,0.2752824),(3043,19398,0.17736277),(3043,22126,0.53434306),(3043,28300,0.43701446),(3044,14534,0.46466398),(3044,18363,0.5774986),(3044,22888,0.25351772),(3044,24180,0.18573654),(3045,534,0.7896487),(3045,11689,0.2830396),(3045,12618,0.1116739),(3045,12740,0.35251766),(3046,2238,0.5467595),(3046,16656,0.25049913),(3046,26913,0.8295205),(3047,8255,0.19454344),(3047,9757,0.515611),(3047,23811,0.82750326),(3047,30320,0.24876691),(3048,4959,8.816665e-2),(3048,6949,0.22768454),(3048,16431,0.40442652),(3048,25812,0.57131815),(3048,31307,0.2252313),(3049,68,0.29167905),(3049,2241,0.1386862),(3049,15434,3.7371796e-2),(3049,18075,0.42418694),(3049,28286,0.1334471),(3049,31509,0.36806664),(3050,3442,0.7899417),(3050,4013,0.618928),(3050,17142,0.5810001),(3050,21536,0.70384884),(3050,21786,0.827858),(3050,27550,0.29202837),(3050,31951,0.94381595),(3050,31977,0.9768552),(3051,162,0.672338),(3051,5592,0.91840607),(3051,14866,0.6613112),(3051,19221,0.1386831),(3052,10350,8.576701e-2),(3052,12124,0.50663084),(3052,12725,0.11795625),(3052,25679,5.7149593e-2),(3053,5820,0.4311874),(3053,25570,0.7309584),(3053,28849,0.6790887),(3053,29572,0.44685712),(3054,7606,0.65340036),(3054,17963,0.9282278),(3054,19569,0.7439339),(3054,26284,0.57162696),(3055,570,0.31737605),(3055,3273,0.36464396),(3055,6443,0.28838795),(3055,14339,0.106893495),(3056,3891,0.8367282),(3056,12301,0.7051017),(3056,12737,0.88630956),(3056,20181,0.51654613),(3056,23750,0.43700716),(3057,4969,0.5089585),(3057,5047,0.45543355),(3057,8211,0.41680518),(3057,12033,0.24830192),(3057,20842,0.40073475),(3057,31591,0.81602144),(3058,9868,0.15005091),(3058,10846,0.29422122),(3058,18456,3.961979e-2),(3058,21444,0.4752855),(3058,23765,0.23247637),(3058,32497,0.9968211),(3059,177,0.66880727),(3059,2859,0.5207162),(3059,19149,0.14849718),(3060,3997,0.7620807),(3060,5758,0.57563627),(3060,10618,0.17799245),(3060,16520,0.37342092),(3060,27411,0.11614788),(3061,2215,7.109444e-3),(3061,4115,0.85397685),(3061,6210,0.84466535),(3061,11890,0.6483317),(3061,20440,0.97049344),(3061,28009,0.42947268),(3061,28396,0.9139779),(3061,30776,0.25528434),(3061,32607,0.98124987),(3062,6903,0.34447572),(3062,14232,0.51756024),(3062,23369,0.37785903),(3062,24414,0.8414854),(3062,27870,0.2681138),(3063,8350,0.31178463),(3063,21586,0.6369769),(3064,4308,0.50666696),(3064,13523,0.5749999),(3065,960,0.30904675),(3065,9600,0.5272629),(3065,30782,1.835588e-2),(3066,4371,0.8189024),(3066,6420,0.35392943),(3066,19967,0.91668963),(3067,1238,0.24179791),(3067,1871,0.42456144),(3067,14679,0.62141806),(3067,19456,0.76671475),(3068,4158,6.471867e-2),(3068,16323,0.49485534),(3068,28362,0.21661909),(3069,15953,3.3122923e-2),(3069,19919,0.17121542),(3069,21167,0.9767558),(3069,23994,0.39674702),(3069,25581,0.8355095),(3070,1496,0.92370135),(3070,7656,0.2083162),(3070,29361,1.2318979e-2),(3071,17426,0.84687704),(3071,19226,0.19411166),(3071,19281,0.13538174),(3072,1873,0.7857528),(3072,20822,0.8386277),(3072,21044,0.23395394),(3072,22755,0.8432792),(3073,31508,0.5709916),(3073,32314,0.24508357),(3074,6082,4.258505e-2),(3074,8169,0.3633532),(3074,14178,0.7551248),(3074,14431,0.86946857),(3074,21670,0.69175243),(3075,8591,0.827014),(3075,17953,0.38308865),(3075,26539,0.91300875),(3076,7407,7.330912e-2),(3076,8470,5.11634e-2),(3076,17605,0.8842247),(3076,29304,0.86157036),(3077,1556,1.0034287e-2),(3077,17298,0.39835516),(3077,20706,0.31883758),(3077,22649,0.49705815),(3077,23702,0.71224904),(3077,27869,0.43825734),(3078,2593,0.7024085),(3078,2600,0.39309034),(3078,11982,0.576794),(3078,15820,0.27349767),(3078,24096,7.232458e-2),(3078,27190,0.12815167),(3079,1289,0.10566551),(3079,6409,0.18286577),(3079,23671,0.9171884),(3079,24755,0.60171634),(3080,2731,0.23632145),(3080,15535,0.35589),(3080,18962,0.9631615),(3080,20095,0.82312006),(3081,3053,0.10525828),(3081,6901,0.8067438),(3081,15163,0.87526387),(3081,22351,1.2262322e-2),(3081,29133,0.9467737),(3082,9649,0.6853433),(3082,11180,0.68932664),(3083,7472,0.8838905),(3083,27362,0.35035273),(3084,18736,0.4832045),(3084,20254,0.7355302),(3085,3641,0.60113525),(3085,6278,0.22447301),(3085,21356,0.6193927),(3085,32031,0.32608494),(3086,9145,0.9500431),(3087,2452,0.64354074),(3087,8086,0.15051235),(3087,10108,0.8499257),(3087,11114,0.7119477),(3087,19391,0.8763409),(3087,30455,0.83940554),(3087,31580,1.3898574e-2),(3088,5622,0.3680199),(3088,7784,0.7128619),(3088,10177,0.7292394),(3088,28279,0.82538855),(3089,12901,1.7248504e-2),(3089,14781,0.4317676),(3090,23171,0.6351534),(3091,2653,0.15792607),(3091,3236,0.4564595),(3091,7050,0.3120714),(3091,12362,0.5912436),(3091,12498,0.47407174),(3091,12721,1.308643e-2),(3092,6666,0.7705054),(3092,9847,0.7776666),(3092,15378,0.846349),(3092,30617,0.7556019),(3092,30942,0.6111389),(3093,1603,0.48042315),(3093,3606,2.9642534e-2),(3093,12671,0.8427261),(3093,15727,0.48907474),(3093,17601,0.6698786),(3093,22996,0.558012),(3095,1548,0.21381187),(3095,14454,0.8488724),(3095,27527,0.3087405),(3096,3450,0.7821025),(3096,15324,0.9996922),(3096,23977,0.45098582),(3097,8287,0.48665023),(3097,9782,0.20445858),(3097,13498,0.73647517),(3097,20398,0.3538376),(3098,12169,0.5562478),(3098,17609,0.6421115),(3099,6628,0.56353927),(3099,9259,1.3142852e-2),(3099,10146,0.60951066),(3099,15364,0.26040292),(3099,24421,0.74268264),(3100,9897,0.9700756),(3100,14486,0.3836036),(3100,15444,0.24853164),(3100,30681,0.77761036),(3100,30835,0.4750385),(3101,12134,0.8893826),(3101,20488,0.58810645),(3101,21306,0.680258),(3102,8331,0.43054172),(3102,15712,0.9024075),(3102,18001,0.8105245),(3102,21829,0.9012833),(3102,21973,0.56355095),(3102,22282,5.6505804e-3),(3102,23971,0.19980502),(3102,26604,0.32302213),(3103,2167,0.90755445),(3103,15541,0.36262214),(3103,18856,0.9657723),(3103,27425,0.95014507),(3104,6072,0.75150603),(3104,10786,0.39642897),(3104,21112,0.5488514),(3104,30899,0.40913096),(3105,428,0.3851624),(3105,2705,0.21782319),(3105,26276,0.47868332),(3105,29042,0.70773995),(3106,7732,0.29552084),(3106,16016,0.504407),(3106,24581,0.34042606),(3107,1007,0.29483783),(3107,16657,0.7208314),(3107,18177,0.50414246),(3107,23595,0.60026807),(3108,1374,0.20400062),(3108,6293,0.3093584),(3108,14691,0.326048),(3108,18343,0.41598347),(3108,18505,0.1734486),(3108,25155,0.24686493),(3109,1955,0.54898345),(3109,7161,0.79279524),(3109,12710,0.8175374),(3109,30733,0.6002497),(3109,31022,0.64829457),(3110,7852,0.7742637),(3110,26309,0.10901855),(3111,779,2.7570449e-2),(3111,7905,0.6899522),(3111,9115,0.41574627),(3111,9157,0.59259164),(3111,11078,0.85246706),(3111,22289,0.31121135),(3111,22870,0.6535991),(3111,28451,0.73585725),(3111,28817,0.46872917),(3111,31794,0.7987052),(3112,15572,2.5371363e-2),(3112,26603,0.23349868),(3112,31398,0.8024782),(3113,8984,0.64979863),(3113,9410,0.73250866),(3113,17884,0.6909884),(3113,24891,6.650484e-3),(3113,29644,0.45329815),(3114,152,0.6905913),(3114,4856,0.15251075),(3114,24419,0.5513666),(3114,25675,1.0551678e-2),(3114,26127,6.334515e-2),(3114,26262,0.18741097),(3114,28670,0.39612874),(3114,31145,0.34773555),(3115,8685,0.3547761),(3115,11048,0.9892371),(3115,15101,0.618088),(3115,18678,0.575319),(3115,24290,0.6860375),(3116,44,0.3729228),(3116,1210,0.7245797),(3116,10983,8.259184e-2),(3116,16142,0.5667413),(3116,26864,0.12652832),(3117,3747,8.870148e-2),(3117,7206,0.8958928),(3118,6460,0.27398983),(3118,13188,0.20913802),(3118,14210,0.81634265),(3118,18624,0.5688017),(3118,31701,0.8967573),(3119,4472,0.9111903),(3119,14726,0.7303989),(3119,17096,0.37674806),(3119,25135,0.39323264),(3119,30801,4.7844447e-2),(3120,20786,0.13344315),(3121,15808,0.8642304),(3121,24566,0.54712635),(3122,14860,0.48353428),(3122,19715,0.65363944),(3122,19725,0.89011806),(3123,4282,0.52413756),(3123,7274,0.32833695),(3123,8492,0.9566735),(3123,11871,0.8582593),(3123,15598,0.17249227),(3123,17788,0.281951),(3123,22632,0.47282228),(3123,23272,0.22942191),(3123,27566,0.4483952),(3124,2210,0.6489919),(3124,4113,0.76204616),(3124,5427,0.40014115),(3124,8041,0.7520298),(3124,22711,6.966799e-2),(3124,23665,0.100729354),(3124,26901,5.7292655e-2),(3125,24266,0.36268973),(3126,4933,7.64246e-2),(3126,16365,0.5767101),(3126,18403,0.80774444),(3126,27053,0.2954587),(3126,27682,0.4489682),(3127,12976,0.42842406),(3127,14696,0.47561994),(3127,23433,0.6297916),(3128,17087,0.7196953),(3128,18513,0.8497065),(3128,23142,0.43824688),(3128,30115,0.9083994),(3128,30583,0.26831502),(3129,2327,0.8712682),(3129,23319,0.5414678),(3129,24380,0.69613844),(3129,31179,0.83186996),(3129,31258,0.28766668),(3130,16490,0.72406137),(3131,1439,0.2972135),(3131,5313,0.23629645),(3131,15202,0.9235577),(3131,19544,0.6431815),(3131,21907,0.14173241),(3131,27671,0.4993862),(3131,29753,0.7794012),(3132,12442,0.814973),(3133,817,0.4269689),(3133,12211,0.91072357),(3133,13709,0.6882353),(3133,15632,0.71589744),(3133,19055,0.8564356),(3133,19542,0.66071606),(3133,20955,0.9586952),(3134,17531,0.44527322),(3134,22707,0.48692414),(3134,27383,0.40605038),(3135,21105,0.9398516),(3136,1388,0.9005141),(3136,18414,0.15707348),(3136,22321,0.65207),(3136,26531,0.62675315),(3136,28799,0.25446177),(3137,16172,0.11969725),(3137,19406,0.17381932),(3138,14216,0.9905232),(3138,19385,0.81238675),(3139,102,0.5252722),(3139,10452,0.7324894),(3139,13284,0.10708977),(3140,9822,0.5882299),(3140,15922,0.706051),(3140,17147,0.36762702),(3140,19234,0.56776816),(3140,21565,0.59466785),(3140,23481,0.66695493),(3141,23186,2.2358853e-2),(3142,928,0.4457211),(3142,3615,0.6472969),(3142,17604,0.83059096),(3142,17999,0.150882),(3143,5678,0.5915743),(3143,8159,0.82309735),(3143,9581,0.2658712),(3143,21567,7.603232e-2),(3144,12873,0.23464093),(3144,30318,0.953099),(3145,7681,0.36866316),(3145,17388,0.9889324),(3145,32153,0.7692458),(3146,11409,0.8661781),(3146,13369,0.7041138),(3146,28249,0.45075428),(3146,28634,7.107514e-2),(3146,30326,0.7355953),(3146,30540,0.88147956),(3146,30787,0.7511984),(3147,9974,0.5970446),(3147,12287,0.615634),(3147,15445,0.87695944),(3147,27412,0.8478319),(3147,32567,9.445374e-2),(3148,4971,0.5096362),(3148,21209,0.18626754),(3148,25163,0.80135083),(3149,12993,0.95942754),(3149,30967,0.9908134),(3149,31794,0.29913428),(3150,3570,0.5695213),(3151,13339,0.70959854),(3151,19475,0.7991594),(3151,25096,9.640157e-2),(3151,29738,0.5005401),(3151,31791,0.4200275),(3152,2101,0.10933013),(3152,2352,0.69933057),(3152,8550,0.5051919),(3152,19715,4.6030056e-2),(3152,25206,6.3018315e-2),(3153,4374,0.453913),(3153,14540,0.66787577),(3153,18808,0.52032113),(3153,21162,0.8747401),(3154,4496,0.564056),(3154,20089,0.53863674),(3154,20462,0.8684934),(3155,560,0.6961663),(3155,1108,0.13594116),(3155,6226,0.84799343),(3155,11517,0.66177016),(3155,20271,0.4416222),(3156,4059,0.53523),(3156,7048,0.2279195),(3156,30598,0.22842547),(3157,2303,0.9613424),(3157,7612,0.72752523),(3157,10476,0.5745912),(3157,18585,0.38921285),(3157,31182,0.97301656),(3158,24687,0.2480583),(3158,28262,0.8758039),(3158,28341,0.2606605),(3158,32016,0.47908384),(3159,14815,0.39672095),(3159,24807,0.6691888),(3159,28973,0.53010887),(3160,3820,0.6926775),(3160,6230,0.17288923),(3160,12074,0.93811965),(3160,14742,0.61240256),(3161,2206,0.104193784),(3161,5061,9.616684e-2),(3161,15389,0.22187507),(3161,21851,0.26251286),(3161,23943,5.609998e-2),(3161,24187,0.33647),(3161,28326,0.95555425),(3162,7245,0.21057276),(3162,17929,9.507901e-2),(3163,5749,0.26276),(3163,6661,0.6500459),(3163,7485,1.1606782e-2),(3163,11411,0.59913003),(3163,19498,0.39973977),(3163,23795,0.53050786),(3164,1700,0.7144294),(3164,4145,4.4503354e-2),(3164,22642,0.30937538),(3164,27755,0.29122382),(3164,28741,0.20879453),(3165,22679,0.8898489),(3165,28352,2.344985e-2),(3166,811,0.4064968),(3166,7342,5.2567016e-2),(3166,11292,0.84066856),(3166,18659,0.10568512),(3166,19667,0.31003162),(3166,22431,4.8071347e-2),(3167,7823,0.4800609),(3167,17345,6.8686314e-2),(3167,18437,0.12534164),(3167,19037,0.83310544),(3167,31784,0.24654976),(3167,32603,0.5874397),(3168,6457,0.7932019),(3168,6623,0.9467895),(3168,8718,0.18944474),(3168,21342,0.15964596),(3168,23339,0.9675467),(3168,25391,0.7293022),(3169,8256,0.7963882),(3169,9828,2.1852977e-3),(3169,13401,5.0500445e-2),(3169,21944,4.1188322e-2),(3169,31519,0.14167607),(3170,13977,0.4495374),(3170,21176,0.82102543),(3170,29674,9.901937e-2),(3171,9203,0.53830165),(3171,20465,0.91025823),(3173,3803,0.26915842),(3173,4271,6.784514e-2),(3173,4599,0.98582304),(3174,16521,0.19260263),(3174,28787,0.68139267),(3175,4560,0.13793528),(3175,15187,0.27921093),(3175,30936,0.4441157),(3176,6109,0.8613175),(3176,7896,0.79145926),(3176,14859,0.60291016),(3176,23931,0.8704257),(3177,657,0.6496418),(3177,20342,0.8355787),(3178,6019,0.27598205),(3178,14401,0.12805611),(3178,20342,0.5342055),(3178,29772,0.23871477),(3179,3935,0.642777),(3179,5148,0.7453591),(3179,14708,0.5659327),(3179,24234,0.66202664),(3179,27638,0.66195893),(3179,28376,0.5802634),(3179,30390,0.81028223),(3180,11109,0.25822923),(3180,15844,0.50413126),(3180,17462,0.38534),(3180,26957,0.16031097),(3181,5097,0.9826826),(3181,31584,0.11024195),(3182,12694,0.23484959),(3183,7578,0.24835354),(3184,521,0.18386549),(3184,11927,0.31138113),(3185,12425,0.68215364),(3185,23396,5.5262268e-2),(3185,24252,0.6567644),(3186,5729,0.78383654),(3186,8372,0.7893325),(3186,13075,0.5643533),(3186,20668,0.6788159),(3186,27636,0.11375692),(3187,14927,0.8174387),(3187,21854,0.98898757),(3187,25529,0.19118258),(3188,6726,0.8318397),(3188,21181,0.65467453),(3188,29873,0.55685705),(3189,12509,0.22649243),(3189,18083,0.7770364),(3189,28413,0.7388326),(3190,28308,0.59829205),(3190,32500,0.62010574),(3191,4901,0.49884334),(3191,13785,0.4819548),(3191,18473,0.53194916),(3191,21566,0.16316268),(3192,1369,0.5035333),(3192,8305,0.39938465),(3192,21407,0.74196124),(3192,22058,0.5804304),(3192,27174,0.35861456),(3192,31078,0.44616345),(3193,2453,0.59703165),(3193,10131,0.5153282),(3193,11323,0.21451156),(3194,19277,0.69804513),(3195,19465,0.5242864),(3195,31298,0.112638436),(3196,15727,0.3183898),(3196,18300,9.555628e-2),(3197,2610,0.4482863),(3198,7121,0.4926373),(3198,8968,0.5693176),(3198,10191,0.21513961),(3198,14150,9.26974e-2),(3198,26128,0.5802035),(3199,3287,0.85387313),(3199,6723,0.49301684),(3199,10140,0.8460512),(3199,29749,0.1738348),(3199,32009,5.5244446e-2),(3200,26132,0.84512216),(3200,26182,0.39608854),(3201,11447,0.6113567),(3201,12543,2.4811633e-2),(3201,13124,0.3198996),(3201,32145,0.45312384),(3202,21969,0.14134084),(3202,24466,0.96163076),(3202,31706,0.22459632),(3202,32594,0.570279),(3203,8250,0.9832379),(3203,21382,0.39510456),(3203,22777,0.4453666),(3203,26141,0.61780214),(3203,29901,0.61758816),(3203,31631,0.2744584),(3204,9462,0.78911144),(3204,12680,0.31770113),(3204,20092,0.27229512),(3205,8256,0.87455213),(3205,8720,0.37976545),(3205,13860,0.38400447),(3205,27824,0.9983248),(3206,5290,6.048798e-2),(3206,11207,0.51863253),(3206,25876,0.14995806),(3206,27146,0.34661028),(3206,29960,0.89470965),(3207,3004,0.17533022),(3207,3102,0.4989842),(3207,8723,6.656151e-2),(3207,9545,0.18480262),(3207,21975,0.9388159),(3208,1205,0.41646206),(3208,6167,0.57432246),(3208,9125,0.89371204),(3208,15091,0.15503897),(3208,20028,0.94839203),(3209,16289,0.5891456),(3210,20599,0.8770851),(3210,21991,8.9720204e-2),(3211,583,0.74621546),(3211,13126,6.636369e-2),(3211,13443,0.86994964),(3211,13974,0.717646),(3211,27704,0.18254253),(3212,3181,7.575411e-2),(3212,10164,0.23276162),(3212,10441,0.23578708),(3212,12377,0.66962755),(3212,14244,0.4967214),(3212,16480,0.46752492),(3212,25889,0.47891864),(3213,7753,3.4444634e-2),(3213,17918,0.7771486),(3214,3825,0.9859564),(3214,18707,0.95696545),(3215,5072,7.127155e-2),(3215,7838,0.34495947),(3215,18461,0.43397617),(3215,22055,0.5076861),(3216,8574,0.49967676),(3216,25005,0.4535039),(3217,9178,0.5205487),(3217,12043,0.7910589),(3217,22597,0.43168843),(3219,14293,0.20099439),(3219,15564,0.72801983),(3219,19391,0.51590484),(3219,20450,0.77547866),(3220,1660,0.9606389),(3220,18703,0.4851366),(3221,6268,0.3738832),(3221,12416,0.86465734),(3221,16626,0.3641043),(3221,18393,0.4934623),(3221,24666,0.2598376),(3221,28978,0.8497872),(3221,29434,0.5496103),(3222,10555,0.84490216),(3222,11146,0.37141222),(3222,25605,0.30199003),(3223,10822,0.745944),(3223,18376,0.70024323),(3223,29494,0.4073907),(3224,6175,0.8520134),(3224,11102,7.569842e-2),(3224,19673,0.391296),(3224,20444,0.693241),(3224,21293,0.7059108),(3224,24866,0.6101226),(3224,30809,0.72561365),(3224,31166,0.3969491),(3224,32337,0.48863122),(3224,32637,0.5261056),(3225,2182,0.5246183),(3225,7447,0.528084),(3225,22486,0.9331215),(3225,26422,0.27386412),(3226,1680,0.90332645),(3226,5506,0.1645261),(3226,12241,0.8943832),(3227,1409,0.4576557),(3227,13359,0.47282124),(3228,18128,0.1261028),(3228,18674,0.9026702),(3228,22042,9.132073e-3),(3229,1914,0.23651403),(3229,5554,0.32067525),(3229,5610,0.79394376),(3229,9416,0.9402448),(3229,11110,0.59397787),(3229,23615,0.53544855),(3229,25349,0.6521293),(3229,26479,0.70535696),(3229,27399,0.65904737),(3229,31298,0.20488282),(3230,643,0.28513128),(3230,5295,0.42054692),(3230,12858,0.5858122),(3230,32350,0.3028862),(3230,32565,0.33216858),(3231,264,5.859625e-2),(3231,6284,0.23507921),(3231,12603,0.55054003),(3231,31130,4.998497e-2),(3231,32102,0.9716825),(3231,32746,0.18666875),(3232,11611,0.7009977),(3232,13401,0.9646451),(3232,13566,0.6308904),(3232,21650,0.30486387),(3232,27889,0.14955178),(3232,32576,0.3341717),(3233,9723,7.786367e-2),(3233,24107,7.876275e-2),(3233,25943,0.7019174),(3233,27141,0.33000612),(3234,6288,0.22961581),(3234,10475,0.32369098),(3234,13965,0.28146434),(3234,14085,0.41026726),(3234,16002,0.5849188),(3234,27009,0.9536272),(3235,19751,0.47609064),(3235,26755,0.59038705),(3236,170,0.206147),(3236,5050,0.11291893),(3236,10691,0.8502011),(3236,12530,0.46591562),(3236,14026,0.17189732),(3236,21146,0.7873119),(3236,28215,0.11058505),(3236,29784,0.97620034),(3236,31004,0.34618402),(3237,13154,0.2664834),(3237,17012,0.5853315),(3237,22886,0.88118607),(3237,23984,0.23905171),(3237,26845,0.16426063),(3237,28215,0.25336415),(3238,20741,0.58615017),(3238,22377,0.5446834),(3238,29534,0.2886345),(3238,32496,0.11754565),(3239,21915,0.5209555),(3239,27633,0.91073626),(3240,13306,0.69951797),(3240,15740,0.10471606),(3240,16370,0.5077325),(3240,19980,0.7085249),(3240,26882,0.38160756),(3241,13896,0.21997182),(3241,14922,0.6139996),(3241,16015,5.827167e-3),(3241,20427,0.4297044),(3241,21675,0.42798516),(3241,22586,0.6284703),(3242,11334,0.7144608),(3242,23107,0.7607105),(3242,27632,0.59995204),(3243,3012,0.5964791),(3243,9134,0.6072326),(3243,9501,0.87031156),(3243,30383,5.512737e-2),(3244,7400,0.2270776),(3244,9663,0.12694333),(3244,11654,0.42459688),(3244,14513,0.8471798),(3244,18693,0.77519333),(3244,29186,0.9034128),(3244,29897,0.9764246),(3245,5319,0.25780377),(3246,19974,0.60383236),(3246,29177,0.575827),(3247,11046,5.104257e-2),(3247,11484,0.76156116),(3247,19923,0.34756166),(3247,20435,0.121678375),(3247,31377,0.423373),(3248,12975,0.90881974),(3248,30649,0.4722598),(3248,31816,0.8592291),(3248,31901,0.6813989),(3249,1564,0.42806742),(3249,3927,0.52922344),(3249,11945,0.59238654),(3249,18227,0.7894956),(3249,24321,0.79270476),(3249,24706,0.116554916),(3249,27045,0.9076747),(3249,30796,0.43531886),(3250,6216,0.2682102),(3250,9636,0.30971026),(3251,17341,0.39175645),(3251,20222,0.6624091),(3251,30196,0.43708974),(3252,290,0.40585417),(3252,19769,0.963063),(3252,22232,0.9828042),(3252,24454,5.435243e-2),(3252,29251,0.39057854),(3253,5196,0.43073112),(3253,9448,0.84106374),(3253,25362,0.63855124),(3254,3164,0.44461873),(3254,6751,0.51471895),(3254,18632,0.32887897),(3255,17164,0.99549955),(3255,20785,0.60764724),(3255,21475,0.86373365),(3255,23337,4.6454654e-3),(3256,1579,0.9210447),(3256,2034,0.31672382),(3256,12674,0.69649816),(3257,635,0.6800678),(3257,13703,0.13036563),(3257,14316,0.579056),(3257,16229,0.16678663),(3257,26635,0.6274373),(3257,27602,0.48042905),(3257,32411,0.86288255),(3257,32579,0.41407698),(3258,4460,0.13528636),(3258,13527,0.14682245),(3258,16823,6.335284e-2),(3258,19132,0.7693686),(3258,26089,0.92868847),(3258,28889,0.90673876),(3259,11922,0.55921364),(3260,14602,0.95827204),(3260,26245,3.2223355e-2),(3260,28253,0.6547723),(3261,12845,0.93131953),(3261,15390,0.8675654),(3261,16599,0.79228884),(3261,25321,0.9496375),(3262,2683,4.842132e-2),(3262,7822,0.9469279),(3262,14676,0.31086087),(3262,18380,0.69820565),(3263,6485,0.35401702),(3263,10594,0.1259902),(3263,11010,0.26987),(3263,13648,0.57514304),(3263,29661,0.10197837),(3263,30175,0.28519437),(3264,3229,0.5124339),(3264,10793,1.7591717e-2),(3264,10962,0.9693313),(3264,31415,0.1333302),(3265,4963,0.2324938),(3265,25825,0.72263),(3265,28709,0.7335037),(3266,1184,7.771354e-2),(3266,7603,0.5569937),(3266,12311,0.75109005),(3266,15434,0.29084942),(3266,23184,0.40991196),(3266,23895,0.45631662),(3266,28175,0.36293846),(3267,6331,0.50921476),(3267,8981,7.960847e-2),(3267,22551,0.5153137),(3267,26387,0.9974396),(3268,11864,0.66418093),(3268,14830,0.5350669),(3268,32565,0.62011683),(3269,7332,0.6729015),(3269,22654,7.8033194e-2),(3269,28641,0.30691803),(3270,10101,0.89493513),(3270,13595,0.5833947),(3270,14634,0.15950993),(3271,907,0.7229936),(3272,1865,0.11885562),(3272,19005,0.812657),(3272,19353,0.1763803),(3272,19976,0.8124055),(3272,21605,0.42174974),(3272,24572,0.641929),(3272,28889,0.22954337),(3272,31129,0.4079856),(3273,16582,0.7276405),(3274,3785,0.77125216),(3274,8646,0.4688334),(3274,21496,0.9412918),(3275,192,0.37683797),(3275,8150,1.1786301e-2),(3275,18962,0.6417715),(3275,20859,0.23100792),(3276,4593,0.59997416),(3276,8290,0.3792816),(3276,9291,0.47000968),(3276,13721,0.29167408),(3276,13872,0.8063206),(3276,19350,0.27853343),(3276,27972,0.7963306),(3277,72,0.9713788),(3277,8286,0.6029343),(3277,10358,0.9108328),(3277,24447,9.630344e-2),(3277,24646,0.75165147),(3277,29980,0.99453914),(3277,31903,0.5414116),(3278,12193,0.96913844),(3279,1108,0.6826913),(3279,5439,0.697118),(3279,21964,0.9788464),(3279,28638,1.4450454e-2),(3280,4199,0.28729725),(3280,16097,0.5693146),(3280,24445,0.8705819),(3281,5365,5.0894827e-2),(3281,17899,2.3371434e-2),(3281,20093,0.81443894),(3281,21351,0.12897922),(3282,4958,0.588746),(3282,31523,0.791155),(3283,3757,0.25892708),(3283,6969,0.78965497),(3283,23174,0.3455287),(3283,26688,0.33442363),(3284,4382,0.88399804),(3284,14894,0.38043645),(3284,14901,0.7216428),(3284,19812,0.42756847),(3284,19870,7.149978e-2),(3285,7272,0.15086006),(3285,9541,0.73136276),(3285,21391,0.5328383),(3285,21907,0.3466144),(3285,27205,0.4289144),(3285,28519,5.0794166e-2),(3285,29084,0.9065246),(3285,29746,0.77608657),(3286,5783,0.1421122),(3286,18696,0.21641453),(3286,24325,0.106208995),(3286,26735,0.23235083),(3286,29355,0.33755043),(3287,971,0.35811725),(3287,12788,0.296799),(3287,24885,8.317587e-2),(3288,5807,0.7196491),(3288,12865,0.99799734),(3288,13160,0.7250869),(3289,8877,2.126265e-3),(3289,23485,0.9117876),(3289,29931,0.75332),(3290,1190,0.7392921),(3290,10118,0.45446223),(3290,14585,0.28638157),(3290,29904,0.41273072),(3290,32533,0.57067895),(3291,16699,0.5950478),(3291,27480,0.21921879),(3291,32386,1.8355682e-2),(3291,32420,0.984375),(3292,4098,0.41810894),(3292,4898,0.92426676),(3292,4951,0.16350448),(3292,7491,0.50499636),(3292,24519,0.97010916),(3293,17591,0.7697175),(3293,22541,1.0977327e-2),(3293,27475,0.7638124),(3294,2445,0.669802),(3294,11185,0.24067676),(3294,20371,0.41992345),(3294,28946,0.81537205),(3295,4119,0.5569676),(3295,5196,0.28650647),(3295,12232,0.56371444),(3295,21983,0.2245169),(3295,29047,0.7213353),(3295,30858,0.92047125),(3295,32520,0.38672525),(3296,15124,0.866153),(3296,19522,0.52627945),(3296,23094,0.70213836),(3296,26874,0.5167144),(3297,1194,0.52947843),(3297,6912,0.17697535),(3297,30032,0.46872914),(3298,605,8.534341e-2),(3298,20332,4.1594874e-2),(3298,25734,0.6996161),(3298,26813,0.1823992),(3298,31158,0.5648854),(3299,7273,0.926039),(3299,19040,0.4950027),(3299,29188,0.1665322),(3299,30603,0.7927548),(3300,3813,0.8104755),(3300,5409,0.7483124),(3300,6913,0.14761269),(3300,21223,0.1022986),(3301,2722,0.39739838),(3301,2875,0.65904075),(3301,12355,0.94768494),(3301,16502,0.16484754),(3301,24103,0.38102093),(3302,20814,0.12540032),(3302,21565,0.4941984),(3303,11586,0.7561601),(3303,16571,0.17335442),(3303,18961,9.286465e-2),(3303,27657,0.5118389),(3303,28045,0.76811033),(3303,32634,0.70880985),(3304,8420,0.6567724),(3304,18918,0.23440759),(3304,25680,0.8640069),(3305,2785,9.119006e-2),(3305,5670,0.21214731),(3305,11272,0.48963842),(3305,15148,0.46381366),(3306,13814,0.6090936),(3306,21680,0.5922795),(3306,28992,0.9216734),(3306,31744,0.6073144),(3307,10920,1.2779724e-2),(3307,21462,0.8125393),(3307,22269,0.2673405),(3307,29501,0.8392146),(3308,882,0.98182416),(3308,10889,0.72564757),(3308,12519,0.72457516),(3308,13846,0.5000463),(3308,21630,0.9417083),(3308,25374,0.8724842),(3308,32109,0.5117734),(3309,1310,0.67551947),(3309,16398,0.2618396),(3309,17337,0.12430079),(3309,27474,0.7955476),(3309,28904,0.9093839),(3310,1765,0.4222163),(3310,5283,0.8462349),(3311,4360,0.35336006),(3311,6604,0.25112408),(3311,11200,0.3888692),(3311,13351,6.0571957e-2),(3311,14803,0.47225708),(3312,19905,7.887847e-2),(3312,29441,0.9854907),(3313,5439,0.39154142),(3313,12891,0.14058429),(3313,15438,0.3426411),(3314,1223,0.8850538),(3314,9301,0.49976903),(3314,29445,0.89173),(3314,30496,0.7047031),(3315,4385,0.38995355),(3315,8411,0.79571307),(3315,8826,0.404327),(3315,12349,0.25265083),(3315,19746,2.5206212e-2),(3315,23362,0.45523578),(3316,1867,0.4523362),(3316,8193,0.20646656),(3316,25060,0.8332542),(3316,26475,0.9279046),(3317,2700,0.69406587),(3317,3451,0.22987331),(3317,8704,3.271744e-2),(3317,14103,0.91054827),(3317,16845,0.76196945),(3317,29468,0.41698027),(3318,2069,0.6410563),(3318,6775,0.63836056),(3318,7326,0.4196469),(3318,14522,9.893339e-2),(3318,16639,0.39995483),(3318,18209,0.5382518),(3318,27876,0.91961294),(3318,31867,0.73464465),(3319,6069,0.27802798),(3319,6849,0.6978811),(3319,19886,0.9403618),(3320,6534,0.9269916),(3320,9387,0.5016178),(3320,12723,0.88578624),(3320,13849,0.82642186),(3320,31963,0.4622539),(3321,526,0.9815274),(3321,4382,0.5517763),(3321,17315,0.69425595),(3321,30218,0.31989288),(3321,32188,0.3351809),(3322,2123,0.68747866),(3322,5072,0.34200504),(3322,19815,0.277911),(3322,22410,0.9183732),(3322,23044,0.15185961),(3322,31792,0.24380983),(3323,28726,0.20231582),(3323,30493,0.17935029),(3324,10934,0.7192473),(3324,20507,0.44237015),(3324,26702,0.9263679),(3324,31763,0.5379963),(3325,23392,7.673315e-3),(3326,23467,0.4981551),(3327,6350,0.7897323),(3327,11835,0.20499785),(3327,27988,0.21399444),(3328,1463,0.8560299),(3328,1491,5.208554e-2),(3328,8448,0.6631139),(3328,13054,0.63463426),(3328,22920,0.42860827),(3328,23528,2.404503e-2),(3329,8910,0.9309273),(3329,12989,0.2961989),(3329,30765,0.111346215),(3330,8435,0.5423694),(3330,8709,5.826067e-2),(3330,19344,0.625265),(3330,22017,0.7319232),(3330,29780,0.6377103),(3331,2611,0.5492234),(3331,4447,0.821109),(3331,24051,0.61210465),(3332,2437,0.23595871),(3332,8771,2.2136202e-2),(3332,25520,0.5858976),(3333,1705,0.92928123),(3333,3280,0.37159342),(3333,5943,0.3973047),(3333,7402,0.7854512),(3333,23139,0.49560803),(3334,20936,0.9176769),(3334,23588,0.1011719),(3335,2693,0.9629397),(3335,4143,0.44887537),(3335,11703,0.5721393),(3335,15797,0.6682014),(3336,12552,0.90755004),(3337,19456,0.85939145),(3337,22958,0.37353775),(3337,24142,0.5843088),(3337,26469,0.12820873),(3338,4991,0.21518712),(3338,6853,0.18334672),(3338,9248,0.69485116),(3338,14322,0.9866215),(3339,5910,0.53501624),(3339,9237,0.53583956),(3339,11665,0.16128471),(3339,21019,0.14469412),(3339,29579,0.48672953),(3339,30703,0.22416313),(3339,31895,0.72450626),(3339,32270,0.28990397),(3340,16631,0.8952269),(3340,20494,0.45808795),(3341,1095,9.665527e-2),(3341,11626,0.27860385),(3341,12951,0.91926396),(3341,18188,0.92017424),(3342,3775,9.027909e-2),(3342,5274,0.7538567),(3342,31937,0.8203389),(3343,6508,0.33317712),(3343,27653,0.87620956),(3344,18047,0.25155488),(3344,21797,0.7713216),(3344,27160,0.11441656),(3344,29561,0.55323154),(3344,29925,0.5521293),(3344,32153,0.66508627),(3345,328,0.4977828),(3345,2613,0.7889546),(3345,4546,3.0176602e-2),(3345,17072,0.3886964),(3346,27381,0.7450418),(3347,369,0.60651845),(3347,10187,4.163608e-2),(3347,30959,0.50523245),(3348,5536,0.28883287),(3348,8060,0.6595614),(3348,16071,0.70386624),(3348,23185,0.9165368),(3349,8977,0.36515638),(3349,20250,0.9397895),(3349,28586,0.46614897),(3349,30160,0.10478245),(3350,4955,0.3998621),(3350,13131,0.424099),(3350,22459,0.58046365),(3350,29182,0.7992924),(3350,30451,0.33700278),(3351,6238,0.85882133),(3351,11555,0.5448266),(3351,11907,0.44090292),(3351,16053,7.6715425e-2),(3351,16460,0.47252896),(3351,21181,0.69692403),(3351,25164,0.64317214),(3351,29964,0.54283625),(3351,31703,0.11445207),(3352,34,0.7750137),(3352,5412,5.3397067e-2),(3352,9751,0.46925563),(3352,17000,0.28381068),(3352,25457,0.24906589),(3352,26010,0.9029171),(3353,62,0.40831155),(3353,1851,0.15106475),(3353,11130,0.79329723),(3353,29153,0.2862972),(3354,1809,0.7613165),(3354,9872,0.9813958),(3354,9961,7.171044e-2),(3354,12014,2.022698e-2),(3354,16694,0.6463996),(3354,32297,0.29036537),(3355,712,0.13488847),(3355,4925,0.1936586),(3355,9205,0.5075412),(3355,17984,0.5223848),(3355,19658,0.30317658),(3356,2856,0.23272555),(3356,12020,0.2646608),(3356,20978,0.7233128),(3356,24224,0.78878963),(3356,30356,0.57028687),(3357,14151,0.78820586),(3358,8353,0.23469102),(3358,14607,0.72952056),(3358,16167,0.8803244),(3358,23016,0.9347993),(3358,23984,0.7591567),(3358,25516,0.109308295),(3358,29333,0.7316171),(3358,30345,0.7834686),(3359,9898,0.6389055),(3359,12835,0.24019857),(3359,17956,0.8211747),(3359,18299,0.74922556),(3359,23656,0.3100702),(3360,5045,0.8385307),(3360,15152,0.81136477),(3360,22110,0.3261074),(3360,27613,0.796256),(3361,7714,0.13012676),(3361,20463,0.9157621),(3361,31312,0.283032),(3361,31498,0.6141818),(3362,64,0.26840404),(3362,3113,0.7148547),(3362,3673,0.9472798),(3362,4042,0.8194443),(3362,22068,0.2750624),(3362,31898,0.18107903),(3363,5443,0.3681439),(3363,18955,0.41181025),(3363,24911,0.47878325),(3363,27315,0.7996319),(3364,15,0.917294),(3364,3743,0.860208),(3364,13025,0.106668904),(3364,15307,0.78485984),(3364,17795,0.800171),(3364,24088,0.6201347),(3365,8543,0.103949875),(3365,8591,0.6568372),(3365,10201,0.77135944),(3365,24658,0.74858344),(3365,26641,0.6987172),(3366,3293,0.12491659),(3366,5250,0.23809046),(3366,8051,0.25950497),(3366,16119,0.9069375),(3367,2470,0.13384809),(3367,26397,0.7311251),(3368,2755,2.2714356e-2),(3368,8793,5.5495713e-2),(3368,9983,0.5297556),(3368,10177,0.9529868),(3368,16435,0.70324355),(3368,19300,0.65520185),(3368,23657,0.40183908),(3368,26511,0.1512141),(3369,30325,0.27947852),(3370,4346,0.5522257),(3370,4936,0.43619436),(3370,16594,0.3564127),(3370,31806,0.74177474),(3371,3915,0.40225822),(3371,5155,0.43716708),(3371,12976,0.29100507),(3371,19846,0.9549836),(3371,21954,0.873508),(3372,10462,0.8904648),(3373,4422,0.863002),(3373,5560,0.21464701),(3373,13154,0.1776873),(3373,21901,0.30572858),(3374,20171,0.1361564),(3374,21075,0.4945009),(3374,31681,0.7124414),(3374,31862,0.7833468),(3375,7876,0.628476),(3375,23722,0.28889328),(3375,29654,0.44486532),(3376,5403,0.21881261),(3376,6579,0.5663757),(3376,8545,0.22185864),(3376,11198,0.3485915),(3376,11743,0.26228693),(3376,24964,1.7585631e-2),(3377,4145,0.100826316),(3377,15889,0.8930862),(3377,17086,0.97337574),(3377,20103,7.227173e-2),(3378,11266,0.55824566),(3378,17605,6.2214136e-2),(3378,28659,0.6239737),(3378,30217,0.4427625),(3378,31317,0.38348648),(3378,31890,0.33810902),(3378,31912,0.19528677),(3379,11732,0.7776247),(3379,19767,0.40338022),(3379,23423,0.6569546),(3379,26777,0.6557958),(3380,1574,0.84550524),(3380,16513,0.5622962),(3381,6033,0.31161606),(3381,8808,0.34659445),(3381,10084,0.9056672),(3381,10298,0.39151025),(3382,2442,0.13790272),(3382,13317,0.7512553),(3382,14077,0.7012082),(3382,19430,0.81884074),(3383,10770,0.9443348),(3383,16528,0.4919298),(3383,22049,0.87144876),(3383,31319,0.5735753),(3384,22190,0.51979005),(3384,22900,0.6203969),(3384,28917,0.72402865),(3385,16,9.790805e-2),(3385,2342,5.9104417e-2),(3385,7797,0.43744302),(3385,13525,0.92746025),(3385,18764,0.7877968),(3385,24905,0.53755194),(3386,8495,0.9001398),(3386,18187,0.4018365),(3386,19866,0.7129862),(3386,22422,0.8737894),(3386,24180,8.0922134e-2),(3386,27603,0.4115309),(3386,29466,0.9683341),(3386,32271,0.8063601),(3387,16649,0.2619046),(3388,9603,0.3030693),(3388,11780,0.26133803),(3388,12231,0.15544592),(3388,15428,0.20365867),(3388,20859,0.2850842),(3388,21397,0.22035803),(3388,29569,0.54538536),(3389,3383,0.892462),(3389,23103,9.322159e-2),(3389,26485,8.9188926e-2),(3389,31157,0.6387828),(3390,3565,0.9504963),(3390,8862,0.350222),(3390,9079,7.116076e-2),(3390,11610,0.26964423),(3391,9383,0.30211344),(3391,10728,0.81180674),(3391,15760,0.9806095),(3391,19884,0.70842886),(3392,386,0.5020864),(3392,9291,0.4794974),(3392,15712,0.596473),(3392,15728,0.23367538),(3392,15739,0.11934449),(3392,16780,0.6885514),(3392,25910,0.4972523),(3392,32444,4.5063805e-2),(3393,2752,0.85146654),(3393,11334,0.71122223),(3393,15406,0.7217821),(3394,9156,0.85815585),(3394,11455,0.32779932),(3394,18144,0.57705146),(3394,23107,0.1613182),(3395,4976,0.5486983),(3395,26218,0.9151256),(3396,2741,0.2678797),(3396,11008,7.418281e-2),(3396,24245,0.9082371),(3397,715,0.5866892),(3397,21852,0.7101863),(3397,27161,0.38996625),(3397,27505,0.88410354),(3398,28224,0.32551628),(3399,12404,6.6147335e-3),(3400,1141,0.5434646),(3400,9592,0.81093246),(3400,28796,0.36698145),(3401,3791,0.6093659),(3401,23525,0.1889608),(3401,26736,0.70768714),(3402,18924,0.5593555),(3402,22550,0.91467845),(3402,27444,0.91854525),(3403,2703,0.30927047),(3403,3739,0.54002553),(3403,12887,5.1611323e-2),(3403,18128,0.70135826),(3403,26192,0.81472254),(3404,10179,0.6353028),(3404,13125,0.8284985),(3404,13225,0.5457971),(3404,16097,0.3588786),(3404,17835,0.22682787),(3404,23892,0.25572577),(3405,6302,0.86805975),(3405,23115,0.86429286),(3405,26731,0.40600485),(3406,212,0.46976277),(3406,9943,0.24352287),(3406,10219,0.9838631),(3406,14708,9.29806e-2),(3406,17210,0.54086894),(3406,18370,0.15815952),(3406,20674,0.7050973),(3406,30892,0.94442),(3407,7040,7.6491676e-2),(3407,29972,1.34148365e-2),(3407,31687,4.2185213e-2),(3408,3117,0.45003885),(3408,4616,1.3460815e-2),(3408,8117,0.10120832),(3408,29959,0.14101447),(3409,6135,0.6775964),(3409,7826,5.6430325e-3),(3409,16933,0.85727704),(3409,27850,0.76269406),(3409,31713,0.20393884),(3410,9544,0.5125772),(3410,23587,0.3421037),(3411,5405,0.31905046),(3411,5919,0.16221903),(3411,25199,0.8118009),(3412,6880,0.6522379),(3412,17889,0.7638915),(3412,27657,4.0325038e-2),(3412,31510,0.9801442),(3413,3006,0.846976),(3413,7245,0.4584426),(3413,23703,0.7741169),(3414,13946,0.27297807),(3415,15119,0.2397387),(3415,23593,0.2542284),(3415,28298,0.34802693),(3416,10086,0.8752239),(3417,8450,0.24441624),(3417,20368,0.86244047),(3418,5284,0.12503885),(3418,7061,4.4038607e-4),(3418,15611,0.8236152),(3418,15951,0.18217054),(3418,18067,0.84483224),(3419,10267,0.9181666),(3419,10591,0.676178),(3419,19239,0.93716455),(3419,23343,0.73044956),(3420,3042,0.9412943),(3420,3151,5.0088637e-2),(3420,9035,0.88011885),(3420,15911,0.5047078),(3421,11180,0.8496182),(3421,17170,0.4842917),(3421,17405,0.88630587),(3421,17825,3.9925687e-2),(3421,25576,0.24013554),(3422,16948,2.7082685e-2),(3422,21432,0.18961367),(3422,26073,0.44122863),(3422,26690,0.72645193),(3423,5389,0.68076134),(3423,9377,0.44482747),(3423,19085,9.533146e-2),(3423,23728,0.6642895),(3423,26383,0.58626825),(3423,30716,0.75749016),(3423,31879,0.19229065),(3424,2430,0.72005296),(3424,21846,0.5425662),(3424,27190,0.96108043),(3425,3760,0.38191855),(3425,11386,0.66810554),(3425,18811,0.47996885),(3425,32686,1.0532954e-2),(3427,7540,0.99852705),(3428,8494,0.51571923),(3428,10326,0.64664567),(3428,15853,0.17390394),(3428,20629,0.5863274),(3428,21972,0.55962527),(3428,22962,0.3062342),(3428,24944,0.27804792),(3428,28309,0.8393073),(3429,5929,0.16270213),(3429,11381,0.5653334),(3429,13437,9.1140874e-2),(3429,24787,2.6193762e-4),(3430,6940,0.18136817),(3430,7369,0.13433073),(3430,17964,0.15337041),(3431,2226,0.8593489),(3431,15298,0.61989635),(3431,23858,0.9515202),(3432,4810,0.100684695),(3432,5916,1.37074515e-2),(3432,21725,0.45978355),(3433,12767,0.56557417),(3433,24002,0.7367925),(3433,28210,1.25837e-3),(3434,554,0.82846797),(3434,5427,0.46039575),(3434,15147,0.30238864),(3434,16517,0.42738998),(3434,18855,0.2737856),(3434,24146,0.16597241),(3434,24650,0.2495671),(3435,1821,0.7682758),(3435,14226,0.56154114),(3435,19210,0.4246707),(3435,30604,0.26347587),(3436,53,0.27422762),(3436,3284,0.5539069),(3436,7620,0.48684174),(3436,12741,0.736809),(3436,29067,0.818236),(3437,16884,0.38139775),(3437,23417,0.14049868),(3438,24469,0.89698637),(3439,1688,0.59045446),(3439,4141,0.32753325),(3439,4790,0.55408084),(3439,11987,0.8054045),(3439,15719,0.20794018),(3439,22921,0.8126105),(3440,1538,0.11011074),(3440,28707,0.5976012),(3441,3699,0.92135364),(3441,15238,0.61194736),(3441,29781,0.79484004),(3442,9378,0.37045947),(3442,25497,0.7347616),(3442,32742,0.8935992),(3443,20885,0.63803893),(3443,25048,0.11351059),(3443,27068,0.22257459),(3444,7627,0.6087243),(3444,14858,0.60403985),(3444,18235,0.39308923),(3444,18989,6.980959e-2),(3445,9659,0.20478651),(3445,15245,0.36027327),(3445,19528,0.9005679),(3445,21299,0.19208337),(3445,27582,0.165378),(3445,28540,0.8508169),(3446,376,0.88226485),(3446,1273,0.713655),(3446,10834,0.70388865),(3446,22563,0.7121771),(3446,25031,7.7796414e-2),(3446,31712,0.2002888),(3447,3350,0.15700723),(3447,6273,0.3532571),(3447,8470,0.3560795),(3447,17978,0.3899517),(3447,27545,0.5047066),(3448,10126,0.101552986),(3448,13026,0.89257604),(3448,16872,0.5271566),(3448,21429,0.68536645),(3448,31852,0.12960427),(3450,2632,0.599528),(3450,15741,0.45474678),(3450,17818,0.8017225),(3450,18948,0.493033),(3450,29384,0.3871515),(3451,10111,0.8326637),(3451,10223,0.5703035),(3451,14796,0.7142905),(3451,19193,0.83735734),(3451,29960,0.44684917),(3452,22936,0.35182354),(3452,27900,0.7175125),(3454,19091,2.5154978e-2),(3454,24692,0.8550714),(3454,28163,0.16446123),(3454,32226,0.4356223),(3455,1516,0.8847024),(3455,4879,0.23459738),(3455,6561,0.30438298),(3455,15629,0.5221675),(3455,28044,0.84794295),(3456,2137,0.5023765),(3456,18043,0.46098706),(3456,24490,0.14318834),(3457,14960,0.30670086),(3458,2663,0.9010375),(3458,11109,0.99696666),(3458,27727,3.0855684e-2),(3459,4932,0.6781385),(3459,6124,0.27512962),(3459,8612,0.38685033),(3459,24175,0.24120177),(3459,27130,0.80428934),(3459,32089,9.384163e-2),(3459,32731,0.37544945),(3460,9390,0.30659476),(3460,17305,6.6344254e-3),(3460,18389,0.8389543),(3460,20982,0.44832695),(3461,1158,0.65531665),(3461,1353,5.737822e-2),(3461,13640,0.40328535),(3461,22200,0.4428241),(3461,22753,0.28067797),(3462,251,7.668605e-2),(3462,4781,0.9620957),(3462,14545,0.9276931),(3462,17343,0.3499408),(3462,19841,0.44029173),(3462,21861,0.74967164),(3462,22963,0.95749617),(3463,1164,0.39470583),(3463,4473,0.8794192),(3463,5607,0.26882374),(3464,11200,0.67106456),(3464,27963,0.42386842),(3464,29700,0.58231884),(3464,30353,0.8488759),(3465,2145,0.8537121),(3465,8084,0.78749245),(3465,23022,0.47107792),(3465,30664,0.5605482),(3466,4811,0.775907),(3466,5657,0.28652945),(3466,6197,0.67826223),(3466,10789,0.62099296),(3466,11790,0.3044208),(3467,1294,0.79470026),(3467,22170,0.55546945),(3468,10677,0.67479366),(3468,11591,0.91388834),(3468,22156,0.16999257),(3468,23638,0.53807414),(3468,32036,0.5891279),(3469,26391,8.8114806e-2),(3471,11594,0.818213),(3472,1103,6.736283e-2),(3472,5441,0.385116),(3472,17958,0.5086848),(3472,18025,0.4143656),(3472,21363,0.4404208),(3472,25902,2.8687572e-2),(3472,30659,4.6630792e-2),(3473,2877,0.9009825),(3473,9387,0.6092135),(3474,3153,0.52086633),(3474,13353,0.13672908),(3474,16063,0.55001116),(3474,32202,0.5300713),(3474,32435,0.68256223),(3476,6905,0.700376),(3476,11438,0.49842682),(3476,15788,0.7938121),(3476,15824,0.6666051),(3477,3547,0.7998533),(3477,20789,0.6858098),(3477,22181,9.380348e-2),(3477,22332,0.18262948),(3478,2589,0.10594372),(3478,14562,0.31725696),(3478,20739,0.51914006),(3479,13288,0.61774313),(3479,17137,0.14721747),(3479,28955,0.28932986),(3479,29269,8.4005676e-2),(3480,19799,0.89003253),(3481,5746,0.4999223),(3481,27536,0.6723003),(3482,1088,0.8655108),(3482,32740,0.9412639),(3483,4318,7.7404834e-2),(3483,16884,0.9084837),(3483,26451,0.4740604),(3484,3450,0.42301956),(3484,3459,0.9950493),(3484,11583,0.2557831),(3484,12419,0.5035868),(3484,26961,0.48792407),(3484,29773,0.76569575),(3484,32303,3.8693216e-2),(3485,12063,0.3165184),(3485,31652,0.24619687),(3486,3542,0.6897906),(3486,4513,0.5903532),(3486,10752,0.35119864),(3486,19145,0.70376515),(3486,20244,0.23739414),(3486,30188,0.5170129),(3487,11451,0.61290365),(3487,19933,0.10455527),(3487,25707,0.48125613),(3487,26208,0.43558615),(3488,14696,0.7667667),(3488,23309,0.89051265),(3489,21914,0.3104624),(3489,23493,0.7658464),(3489,31679,0.7698669),(3490,2860,0.6860139),(3490,3751,4.380771e-2),(3490,5636,0.5921606),(3490,8889,0.11270833),(3490,11548,0.868975),(3490,22919,0.7165925),(3490,27809,0.23363069),(3490,28773,0.292504),(3491,3528,0.6575319),(3491,22995,0.18840085),(3491,23143,0.5601622),(3491,25183,0.38494605),(3491,32750,0.12669137),(3492,25134,0.8173792),(3492,25530,0.79348385),(3493,19308,0.36166206),(3493,20055,0.18629324),(3493,30223,0.48568195),(3494,2228,0.30066234),(3494,9167,0.10725743),(3494,9720,0.18859099),(3494,16867,0.29254258),(3495,1045,0.44236192),(3495,5392,0.19677393),(3495,16725,9.325288e-2),(3495,20834,0.47606125),(3495,27394,0.24791394),(3495,30634,0.89166874),(3496,2241,0.781938),(3496,3140,1.7253224e-2),(3496,3542,3.197203e-2),(3496,4466,0.36412492),(3496,12408,0.5095665),(3496,30876,5.753445e-2),(3496,31023,1.7796306e-2),(3497,4787,2.2179393e-2),(3497,6426,0.6208094),(3497,20053,0.15720366),(3497,26635,0.4247748),(3498,6740,0.30746037),(3498,10645,0.81539047),(3498,29720,0.8266916),(3498,30121,6.847185e-2),(3499,2846,0.7925452),(3499,8388,0.24952033),(3499,11571,0.9964721),(3499,25073,0.16630848),(3499,31316,5.8582224e-2),(3500,884,0.42892113),(3500,5639,0.47385636),(3500,24919,0.6389117),(3500,26491,0.8475655),(3501,2557,0.790179),(3501,14670,0.19548546),(3501,18995,0.7145416),(3502,3717,8.246119e-2),(3502,4658,0.17276488),(3502,11450,0.8041942),(3503,7471,0.32164454),(3503,9125,0.7171085),(3503,18895,0.5099938),(3503,28389,0.27056277),(3504,290,0.7293092),(3504,3237,0.924367),(3504,6892,0.3852392),(3504,6915,0.47586876),(3504,25943,0.37779063),(3505,12673,6.757477e-2),(3505,30951,0.8236581),(3506,2148,0.27045968),(3506,12279,0.62772506),(3506,21404,0.8086038),(3507,13695,0.21668804),(3507,14583,0.51372856),(3507,14841,0.6462624),(3508,6216,0.21430433),(3508,13520,0.21713288),(3508,25677,0.86178887),(3509,9858,0.39816377),(3509,22720,0.45404044),(3510,1687,0.673798),(3510,2616,0.3234604),(3510,6710,0.24839224),(3510,17391,0.31641787),(3510,17983,0.16371745),(3510,18691,0.5749771),(3510,21772,0.37307748),(3510,23952,0.21299252),(3511,9282,0.56356585),(3511,12222,0.44125763),(3511,26113,0.4919585),(3511,27677,0.23291303),(3512,5300,0.19810893),(3512,22743,0.86420953),(3512,29057,0.14177208),(3512,30301,0.3075422),(3512,30707,0.8139331),(3513,1517,0.8996296),(3513,17497,0.33185884),(3513,22968,0.28494155),(3513,23459,0.5459534),(3513,29274,0.8013134),(3513,32032,2.041564e-2),(3514,15159,0.993426),(3515,21655,0.8443515),(3516,3576,0.15977582),(3516,6975,0.3672571),(3516,8090,0.8730506),(3516,15427,0.17335604),(3516,15559,0.5416637),(3516,24578,6.5370776e-2),(3517,4066,0.8284879),(3517,9354,1.099123e-2),(3517,12933,0.57606405),(3518,521,0.62667125),(3518,6270,0.6718237),(3518,18530,0.19082126),(3519,8996,3.986474e-2),(3519,9042,0.7593834),(3519,29669,0.68403345),(3520,1155,9.379837e-3),(3520,2161,0.8015377),(3520,14748,0.9126757),(3520,23810,0.9846463),(3521,439,0.64801216),(3521,13983,0.18754987),(3521,24715,0.44346508),(3521,27207,0.3993583),(3521,27635,2.4292381e-2),(3521,28410,0.81929576),(3522,1041,0.7167335),(3522,21177,0.44699192),(3522,25395,0.57373047),(3522,30879,0.34596503),(3523,14220,0.544799),(3523,17139,0.5312345),(3524,13744,0.7220448),(3525,2859,0.44742772),(3525,20236,0.16670527),(3525,27048,0.6012266),(3526,563,0.4985768),(3526,4861,0.87886447),(3526,11333,0.3495558),(3526,13562,0.49231797),(3526,15550,0.64853466),(3526,21033,9.536543e-2),(3527,10147,0.9792497),(3527,18310,0.42002752),(3527,28372,0.9972555),(3527,28608,1.0280479e-2),(3527,30763,0.83495957),(3528,9475,0.58725196),(3528,22943,0.14132775),(3528,26474,2.7092358e-3),(3528,28496,0.9759063),(3529,330,0.29710785),(3529,13898,0.5007866),(3529,17046,0.7247402),(3529,25710,6.2323947e-2),(3529,29742,0.5939208),(3530,4252,0.18715674),(3530,32760,0.52088386),(3531,10463,0.6504408),(3531,16808,0.24556686),(3531,18153,0.912053),(3531,24170,0.5830917),(3532,1612,0.9091274),(3532,3552,3.2304406e-2),(3532,10077,0.38968173),(3532,13374,0.9541362),(3532,20551,5.9707765e-2),(3532,21862,0.7367449),(3532,24925,0.50085616),(3532,25357,0.26043308),(3532,31260,0.8659714),(3533,10098,0.9558393),(3533,20341,0.39760533),(3533,21464,0.98239416),(3533,26443,0.28869066),(3534,13167,0.80604947),(3534,31245,0.94456595),(3535,8437,0.17071112),(3535,11268,6.2715456e-2),(3535,18380,0.84519947),(3535,24440,0.46875194),(3536,25,0.38849315),(3536,643,0.9539025),(3536,2516,3.2689292e-2),(3536,4803,0.8161095),(3536,11943,0.4914162),(3536,17912,0.12611003),(3536,23384,0.78709173),(3536,29684,0.9762707),(3537,793,0.63931775),(3537,1428,0.470378),(3537,6774,0.97402936),(3537,10635,0.677709),(3538,9601,0.20799722),(3538,13078,0.8843668),(3538,13833,0.91649574),(3538,18404,0.13610503),(3539,7907,3.777448e-2),(3540,11405,0.22051543),(3540,29434,0.49971566),(3541,9401,0.32294303),(3541,13779,0.36812317),(3541,14979,0.37573266),(3541,25619,0.36469463),(3541,30572,0.87971777),(3542,9562,0.64913243),(3542,16271,0.54446524),(3542,31961,0.2008966),(3542,32767,0.9749905),(3543,6403,0.8381053),(3543,21655,0.21781738),(3544,6891,0.97672284),(3544,19719,0.83087486),(3544,31074,0.61235017),(3545,6538,0.24774037),(3545,9856,0.647434),(3545,11551,0.17462352),(3545,12573,0.39389944),(3545,19336,0.72418606),(3545,27643,0.83054245),(3545,28712,0.93439406),(3546,2551,0.8362243),(3546,13512,0.94989526),(3546,21218,0.14903077),(3547,13255,0.778762),(3547,15006,0.43059132),(3547,16220,0.4191414),(3547,21268,0.7579931),(3547,29733,0.5763391),(3547,31435,0.26483783),(3548,8299,0.92090344),(3548,8332,0.3023536),(3548,14915,1.224856e-3),(3548,16619,0.35340515),(3549,16565,0.8459165),(3550,1002,0.6812593),(3550,1526,0.93797094),(3550,6680,0.7782114),(3550,10032,0.34821138),(3550,11165,0.18185516),(3550,22839,0.565242),(3551,22211,0.78461915),(3552,1706,0.9167934),(3552,14097,0.32480377),(3552,15620,0.899502),(3553,18176,0.1528707),(3553,27311,0.76427287),(3554,3973,0.4344754),(3554,7506,0.5612472),(3554,12509,1.9734275e-2),(3555,5297,0.9733027),(3555,6333,0.9417804),(3555,8244,0.86037225),(3555,22616,0.19667086),(3556,10851,9.75026e-2),(3556,19065,0.6557944),(3556,19238,0.6537487),(3556,30855,0.24812686),(3556,32650,0.61344063),(3557,878,0.2592608),(3557,9546,0.7567118),(3557,18303,0.7440016),(3557,27991,0.37700143),(3557,29365,0.30377433),(3557,30159,0.3343737),(3558,697,0.6026415),(3558,3307,4.780975e-3),(3558,10843,0.8488183),(3558,23502,6.806469e-2),(3558,32112,0.58682674),(3559,17182,0.72462225),(3559,18422,0.5846234),(3559,27129,0.434582),(3559,30850,0.39523357),(3560,5789,0.4395994),(3560,11930,0.7134581),(3560,13733,0.8794676),(3560,16593,0.33612108),(3560,17283,0.98301595),(3560,22791,0.65740913),(3562,9026,0.21995029),(3562,10349,0.7812154),(3562,23639,0.74089396),(3562,24790,0.20829521),(3562,29143,0.30442622),(3562,31843,0.57271904),(3563,2916,3.9265808e-2),(3563,5355,0.40063006),(3563,19752,0.8685426),(3563,30110,0.8139913),(3564,14954,0.3455435),(3564,16657,0.32308835),(3564,21680,0.6441832),(3564,22941,0.9022109),(3564,27440,0.32713464),(3564,27586,0.34796083),(3564,32110,0.12779789),(3565,6879,0.6043683),(3565,12058,0.15549842),(3565,15748,0.67166555),(3565,16493,0.8659526),(3565,24467,0.5847581),(3566,9589,0.8709598),(3566,9604,0.36717638),(3566,16449,0.218581),(3566,21690,0.55248684),(3567,10899,4.2160274e-3),(3567,14642,0.34342757),(3567,23820,0.38302508),(3567,27897,0.99516124),(3567,30969,0.64494115),(3567,31028,0.57001007),(3568,29851,0.349012),(3569,10530,0.7984359),(3569,14245,0.10454223),(3569,19783,0.33787048),(3570,6864,0.24235408),(3570,14378,0.3555503),(3570,18134,0.30872864),(3570,21993,0.76764977),(3570,29277,0.7416805),(3571,4024,0.99954545),(3571,4689,0.7451206),(3571,5485,0.6861952),(3571,7803,0.3835501),(3571,27485,0.3284996),(3571,30097,0.3439411),(3571,31380,0.11673254),(3572,2877,0.5566649),(3572,3000,0.9492731),(3572,5880,0.26867005),(3572,6411,0.7408114),(3573,2719,0.9895991),(3573,12198,0.13244388),(3573,18556,0.5134203),(3574,9543,0.25145656),(3574,13526,0.12097735),(3574,14092,0.89937913),(3574,20003,0.42356902),(3574,23557,0.7521978),(3574,26583,0.7677394),(3575,1524,0.40535688),(3575,2530,0.19787495),(3575,4004,0.26174578),(3575,9285,0.1597152),(3575,20063,8.63085e-2),(3575,25674,0.37325218),(3575,32628,0.3496942),(3575,32752,4.3707833e-2),(3576,852,0.17091224),(3576,4909,0.12364229),(3576,19368,0.17367153),(3576,22605,6.754073e-2),(3577,5841,0.39272326),(3577,11661,0.24397415),(3577,15985,0.4618627),(3577,23262,0.4499133),(3577,26493,0.51050323),(3577,27824,0.33364666),(3578,2275,0.33091947),(3578,16852,7.679947e-2),(3578,26928,0.44930083),(3578,27263,0.2976103),(3579,9518,0.39089087),(3579,11644,0.40711963),(3579,16222,0.7049102),(3579,21130,0.50644994),(3579,23223,0.14147407),(3579,25730,0.529937),(3580,5556,0.55892974),(3580,12323,0.53218937),(3580,13101,0.9516836),(3581,16821,0.1035848),(3581,20929,0.77966976),(3582,2360,0.6272686),(3582,3575,6.39101e-2),(3582,4325,0.9563306),(3582,10382,0.2541317),(3583,16832,0.39595997),(3583,20876,0.21889882),(3583,23178,0.8688995),(3584,971,0.3301596),(3584,3469,0.65947556),(3584,11658,0.80577594),(3584,29047,0.53056824),(3584,31909,0.5511194),(3585,10367,0.7756188),(3585,10667,0.42573658),(3585,12097,0.31854445),(3585,20148,0.8618735),(3585,22893,0.5588363),(3586,5954,0.7272698),(3586,11323,0.6411888),(3587,399,0.43501988),(3587,9892,0.7868102),(3587,26606,0.981355),(3587,28945,0.9340093),(3587,30087,0.21823229),(3587,31376,0.58810973),(3588,1968,0.6050129),(3588,2382,0.5053298),(3588,3794,0.97536945),(3588,18513,0.72857606),(3588,30837,0.6367165),(3589,16203,0.90775007),(3589,21690,0.53779674),(3589,30612,0.34564665),(3590,16205,0.43064693),(3590,17650,0.23356177),(3590,24705,0.9668236),(3590,24996,0.6093435),(3591,14154,0.4498846),(3591,14710,0.863795),(3591,18172,0.24445257),(3591,28424,0.24476299),(3591,29430,0.58757937),(3592,791,0.105125725),(3592,12182,0.36051416),(3592,13088,0.7613308),(3592,13701,0.16980693),(3592,14824,0.36099142),(3592,22355,0.8608942),(3592,22786,0.38091165),(3593,12613,0.8721112),(3593,22083,0.77873486),(3593,27487,0.38290486),(3593,27729,8.33505e-2),(3593,29138,0.6130718),(3594,2780,0.5316094),(3594,2838,0.22964057),(3594,14369,0.49362412),(3594,18742,0.69198483),(3594,27503,0.48931205),(3594,28725,0.7890522),(3594,31534,0.13022345),(3595,4632,0.9482525),(3595,6484,0.90623),(3595,8461,0.30160153),(3595,14776,0.67089844),(3596,20576,0.9811303),(3596,29109,4.7223344e-2),(3597,4615,0.94253254),(3597,7534,0.3329713),(3597,18657,0.559986),(3597,19794,0.6874537),(3597,32071,0.8349289),(3598,838,0.76149696),(3598,13057,0.88015336),(3598,15780,0.5743466),(3598,25448,0.49947378),(3598,25707,0.12708737),(3599,10082,0.5769744),(3599,12296,0.45740876),(3599,15170,0.16999266),(3600,1155,0.17374414),(3600,14867,7.267954e-2),(3600,31437,0.13063982),(3601,371,0.18028654),(3601,493,0.27929935),(3601,1474,0.14550489),(3602,15923,0.472569),(3602,28709,0.20660032),(3603,18067,0.82198083),(3603,25030,0.37869605),(3603,32312,0.23125674),(3604,26330,0.94582695),(3604,32198,0.8020028),(3605,8315,0.6793356),(3605,24212,0.19293316),(3606,3303,0.22610785),(3607,1171,0.25856462),(3607,4746,0.11854012),(3607,28679,0.7275708),(3608,6899,0.94633996),(3608,11567,0.29452795),(3608,28468,0.38455158),(3609,19664,0.44015184),(3609,23534,0.16021156),(3609,29905,0.8154676),(3610,13196,0.96300906),(3610,13592,0.7729325),(3610,15591,0.12264178),(3610,18759,0.67793536),(3611,1391,0.9718526),(3611,3310,0.21850221),(3611,5770,0.26197198),(3611,9389,0.8213565),(3611,12311,0.6036611),(3611,14919,0.8208463),(3611,30884,0.3340039),(3612,4257,0.52534264),(3612,13947,0.29415673),(3612,26108,9.475858e-2),(3612,26109,0.4350389),(3613,9101,0.58774704),(3613,17650,0.818776),(3613,24725,0.21042107),(3614,19945,0.70457757),(3615,1087,0.39731514),(3615,2149,0.46544167),(3615,2644,0.14794303),(3615,3687,0.7066205),(3615,4081,4.624637e-2),(3615,19854,0.26591125),(3615,23102,0.628404),(3616,2139,0.11262573),(3616,2891,0.89638644),(3616,2957,0.1809476),(3616,10296,0.6724671),(3616,26273,0.9583406),(3616,31568,0.8150656),(3617,3215,0.24557965),(3617,13448,0.74284214),(3617,15925,0.4232157),(3617,29607,0.40795708),(3618,2952,3.83221e-3),(3618,8640,0.898606),(3618,18295,0.18456882),(3618,26441,0.39184344),(3618,28634,0.13016273),(3618,32224,0.68251747),(3619,227,0.48975813),(3619,7002,0.8989139),(3619,27789,0.82204574),(3619,28717,0.52349836),(3619,29829,0.61607975),(3620,15803,0.87778103),(3620,19163,0.2545684),(3620,32210,0.43591195),(3621,26719,0.16889368),(3622,3525,0.9931755),(3622,26453,0.63056016),(3623,1314,0.32137966),(3623,4222,0.34743458),(3623,7031,0.6056011),(3623,10708,0.69500035),(3623,18414,0.4824721),(3623,27214,0.23986717),(3623,28594,0.3297802),(3623,32056,0.72084296),(3624,5956,0.7775694),(3624,27293,0.47972175),(3624,31317,0.8991728),(3625,11861,0.8176542),(3625,13262,0.9316848),(3625,30971,6.2460516e-2),(3626,5491,0.7662854),(3626,15713,0.71558553),(3626,31865,0.3690275),(3627,1531,0.22454682),(3627,6469,6.94959e-2),(3627,21809,0.5685602),(3627,28578,0.93822354),(3628,3066,9.82849e-2),(3628,5322,9.738723e-2),(3628,10829,0.20154516),(3628,16295,0.72563183),(3628,17409,0.75954884),(3628,17489,0.6834451),(3628,30000,0.7861724),(3629,6062,3.4561995e-2),(3629,15712,0.6141664),(3630,3393,0.35844877),(3630,22405,0.40202963),(3630,28929,0.10536292),(3631,11395,0.32387304),(3631,17613,0.26382887),(3631,21706,0.23948461),(3632,23632,0.40532562),(3632,26367,0.51594424),(3633,8199,0.4276831),(3633,15049,0.6285278),(3633,29652,0.13478772),(3633,30362,0.1873351),(3634,5796,0.16566603),(3634,24877,0.5211768),(3635,1401,0.46052042),(3635,14024,0.9560894),(3635,16117,0.4241524),(3635,20902,0.17562635),(3636,4860,0.47380617),(3636,16792,0.78478885),(3636,21173,0.9696773),(3636,27885,0.7294032),(3637,5301,0.30419973),(3637,11807,0.6244837),(3638,22546,0.24259242),(3638,22749,0.96803296),(3638,26423,0.6240819),(3639,8985,0.99051666),(3639,13791,0.95596504),(3639,15997,0.27263165),(3639,20771,0.9582865),(3639,23630,0.2544646),(3639,28256,0.2735166),(3639,32001,0.6243677),(3640,5678,0.89919096),(3640,8265,0.4633742),(3640,15374,6.235679e-2),(3640,18556,0.38291854),(3640,23196,0.15693562),(3641,12217,0.77851456),(3641,25943,0.25419343),(3641,28164,0.8927282),(3641,29775,0.81975156),(3642,3130,0.15740386),(3642,11498,4.1581575e-2),(3642,20101,0.5365368),(3642,23288,0.9786946),(3642,24897,0.1398583),(3642,27364,0.3248482),(3642,31700,0.16859393),(3643,4054,0.13764146),(3643,15052,0.62772924),(3643,15500,0.7308808),(3643,30295,0.37934557),(3644,7445,0.1651803),(3644,9987,0.17549601),(3645,17317,0.34173235),(3645,27362,0.21431081),(3645,29979,0.36110517),(3646,4834,0.56014305),(3646,15067,0.64606935),(3646,16240,0.10625842),(3646,27228,0.2899358),(3647,1489,0.9979206),(3647,7734,0.68634725),(3647,17881,0.78917795),(3647,19434,0.6767652),(3648,4466,0.5509203),(3648,5996,0.7100505),(3648,12490,0.8462506),(3648,30640,0.8629708),(3649,8014,6.6423295e-3),(3649,12760,0.18920343),(3649,26376,1.3133564e-2),(3650,26095,0.5662615),(3650,32066,0.6739905),(3651,5733,0.75861084),(3651,9188,0.62928206),(3651,31669,0.28165486),(3652,8528,0.39832914),(3652,9874,7.23376e-2),(3652,23635,0.8660947),(3652,27527,0.93805057),(3653,1458,0.22612612),(3653,11496,0.63101256),(3653,13804,0.9493702),(3653,23440,0.5910502),(3653,25330,0.48822558),(3654,8328,0.568558),(3654,8848,0.91275966),(3654,25799,0.53427863),(3655,8550,0.1285381),(3655,31620,0.7040072),(3656,12969,0.53951716),(3656,25071,0.5572066),(3657,1143,0.94750977),(3657,14852,0.9155035),(3657,16619,0.3242043),(3657,23944,0.34769097),(3657,25955,1.8213028e-2),(3657,30363,0.5803203),(3658,1016,0.5666388),(3658,3564,0.15255661),(3658,8705,0.9099112),(3658,8853,0.6123633),(3658,10600,0.7482321),(3658,23378,0.978375),(3658,28454,0.2578413),(3658,30096,0.39466745),(3659,1737,0.5234942),(3659,4530,1.8869117e-2),(3659,12822,0.76775515),(3659,15883,0.93241215),(3659,19188,0.9720742),(3659,19660,0.29126477),(3659,29948,6.459295e-2),(3660,22390,0.34467614),(3660,25803,0.1580994),(3660,27604,6.8264924e-2),(3661,4409,4.8101317e-2),(3661,16678,0.11197621),(3661,24460,0.934179),(3661,32311,0.5380849),(3662,15382,0.16963717),(3662,17712,1.7970129e-3),(3662,22476,0.27877295),(3663,646,9.519866e-4),(3663,9163,0.23910242),(3663,26893,0.9584242),(3663,28857,0.8530639),(3664,234,0.9044562),(3664,4743,0.5066299),(3664,11603,0.99025285),(3664,27371,0.59880435),(3664,28292,0.21881689),(3665,3236,0.3461805),(3665,5937,0.43303925),(3665,19601,8.62387e-2),(3665,27321,0.82844436),(3665,29021,6.267827e-2),(3666,8704,4.0833824e-3),(3666,10524,0.9075766),(3666,24061,0.5197345),(3666,26586,0.57996255),(3667,830,4.8072252e-2),(3667,925,0.25410008),(3667,2119,0.7336523),(3667,8716,8.316684e-2),(3667,22990,0.5222156),(3667,26054,0.78486854),(3668,7480,0.43166217),(3668,30186,0.5562337),(3668,32017,0.36477265),(3669,9476,0.15192218),(3669,12906,0.5073936),(3669,14441,0.12881468),(3669,21817,0.156817),(3669,24440,0.17396538),(3669,29062,0.66112393),(3670,6518,0.18338816),(3670,14842,7.008603e-2),(3670,19497,0.24703209),(3670,21554,3.0483065e-2),(3670,31232,0.7377745),(3671,17264,0.867492),(3671,24298,0.71096927),(3671,29472,0.8761664),(3672,11485,4.2880997e-2),(3672,11720,0.89844227),(3672,23450,0.48300844),(3672,25110,0.7792269),(3673,1595,0.8605233),(3673,4481,0.8601874),(3673,9711,0.72260565),(3673,15192,0.3321264),(3673,22107,0.12867087),(3673,28327,4.270478e-2),(3674,6087,0.9756076),(3674,18133,0.1984188),(3675,5308,0.24466535),(3675,12430,0.2161281),(3675,19651,0.8469433),(3675,27807,0.5462951),(3676,1961,5.0715223e-2),(3676,6136,0.97826654),(3676,7368,7.99156e-2),(3676,31889,0.5211552),(3677,19579,0.6646329),(3677,25708,0.34821314),(3678,10666,0.9926412),(3678,15285,0.72792023),(3678,26874,0.5777364),(3678,29878,2.190447e-3),(3679,1360,0.68900955),(3679,7156,0.66811806),(3679,9846,2.817595e-2),(3679,12520,0.49369106),(3679,16532,0.39513192),(3679,25178,0.7316857),(3679,30038,0.9644452),(3679,32132,4.382432e-2),(3680,15458,0.7366055),(3680,24604,0.52083284),(3680,25064,0.6058978),(3680,29512,0.44083354),(3681,7335,0.63290656),(3681,23621,0.74184513),(3681,31135,0.9353032),(3682,8965,0.8686783),(3682,10147,0.62213224),(3682,15658,8.417457e-2),(3683,3363,0.84774315),(3683,4554,0.8997232),(3683,4681,0.33207214),(3683,10606,0.66321397),(3683,20023,0.20593712),(3684,6522,0.4136533),(3684,10089,0.363095),(3685,18482,0.2784322),(3685,20627,0.1950488),(3685,21167,0.7195459),(3686,6810,0.8088174),(3686,10548,0.66077375),(3686,11920,0.4139828),(3686,13364,0.18654335),(3686,24319,0.23789018),(3687,4454,9.739879e-2),(3687,27852,0.99664366),(3687,31707,0.14106974),(3688,1424,0.79620624),(3689,6217,0.85537547),(3689,7870,0.60035896),(3689,17298,0.69256973),(3689,19962,0.7535247),(3689,21120,0.37762514),(3689,27573,0.82272494),(3690,10998,0.5735028),(3690,13893,0.31814238),(3690,15940,0.44848204),(3690,18092,0.5223468),(3690,23921,0.45721215),(3691,9949,0.7837831),(3691,12072,0.76895183),(3691,19372,0.9198024),(3691,29099,0.8681256),(3691,31959,0.5179962),(3692,21300,0.5766677),(3692,31807,0.63796586),(3693,387,0.69404453),(3693,11634,0.20492151),(3693,25736,0.17001225),(3693,28019,0.4674476),(3694,475,3.2801505e-2),(3694,18142,0.41730615),(3694,26129,0.7705876),(3694,30830,0.517988),(3695,4052,0.23524328),(3695,18877,0.6832807),(3695,22310,0.18318744),(3696,13964,0.5195585),(3696,22312,0.26896587),(3696,22751,0.35511938),(3696,28066,0.85685724),(3696,28655,0.59633595),(3697,594,6.088819e-2),(3697,2463,0.97455025),(3697,8151,0.29400924),(3697,12060,1.1529806e-2),(3698,651,0.5825117),(3698,6067,1.8771658e-2),(3698,14007,0.26248685),(3699,1285,2.1173438e-2),(3699,4181,0.48473355),(3699,11153,0.32875818),(3699,12197,0.95838886),(3699,21410,0.7351397),(3699,23363,0.22081777),(3699,27567,0.30162767),(3699,29066,0.6178369),(3699,32643,0.6785793),(3700,4190,0.23040695),(3700,20504,0.2996782),(3700,23433,0.78530824),(3700,25906,0.39611375),(3700,30405,0.47029576),(3700,31531,0.8589638),(3701,7802,0.60293245),(3701,14416,0.96300584),(3702,8318,0.29398426),(3702,12659,0.8724767),(3702,12717,0.26759493),(3702,19402,0.47372583),(3702,29303,0.3232507),(3703,8729,0.6198107),(3703,22080,0.35419887),(3703,25036,0.72368735),(3704,5117,0.7948752),(3705,12864,0.37704712),(3705,18186,0.27414143),(3705,23252,0.36344907),(3705,28271,3.5853244e-2),(3706,21137,3.618488e-2),(3706,31410,0.11808228),(3707,2126,0.3496609),(3707,7306,0.94291323),(3707,20436,0.93531513),(3707,32179,0.7573986),(3708,1989,0.74208474),(3708,12346,0.34218174),(3708,15628,5.1821012e-2),(3708,24866,0.5420828),(3708,27128,0.8969689),(3709,9691,0.14486767),(3709,13241,0.5061145),(3709,22743,6.8858616e-2),(3710,3463,0.9420029),(3710,10708,0.6635141),(3710,15282,0.17409009),(3710,17062,0.5596928),(3710,21553,0.8346912),(3710,31468,0.55300146),(3711,706,0.61922175),(3711,6329,0.8859399),(3711,10568,0.68217814),(3711,20872,0.53704715),(3712,9980,0.36162508),(3712,18332,0.35083145),(3712,19198,0.7888281),(3713,1871,0.683472),(3713,22331,0.16273065),(3713,23740,0.21090409),(3713,25028,0.9772278),(3713,25443,0.5268293),(3713,31459,0.37187296),(3714,5778,0.7818333),(3714,8985,0.96898067),(3714,22402,0.19141781),(3714,29351,0.56108713),(3715,4138,0.18706058),(3715,27755,0.24827799),(3715,32204,0.22260424),(3716,4087,0.30250108),(3716,4353,0.7293416),(3716,5245,3.6290653e-2),(3716,12050,0.5943999),(3716,13889,0.8588162),(3716,19759,0.609216),(3716,22664,0.29534206),(3716,22840,0.22820604),(3716,24463,0.92637724),(3717,10475,0.20290253),(3718,1837,0.40411273),(3718,8097,0.721432),(3718,10695,6.41076e-2),(3718,12745,0.6966398),(3718,13170,0.4340765),(3718,15569,0.67454886),(3718,23681,8.149935e-2),(3718,27391,0.7175675),(3719,12874,0.3938564),(3719,16973,8.855612e-4),(3720,2857,0.9855749),(3720,5092,0.14718617),(3720,8523,0.81796014),(3720,26719,2.7580146e-2),(3721,2469,0.49404874),(3721,3843,0.6969919),(3721,10027,0.24954322),(3721,22075,0.6461453),(3721,22362,0.7275269),(3721,23100,0.9549085),(3722,4327,8.646503e-3),(3722,11859,0.95213777),(3722,12502,0.9971707),(3722,21882,0.7135057),(3722,25790,0.74473274),(3723,3297,0.9164145),(3723,19078,0.63593554),(3723,24964,9.251041e-2),(3724,1533,0.52297556),(3724,16210,0.33941147),(3724,19236,0.6398364),(3724,22609,0.23581047),(3725,220,2.3652835e-2),(3725,1357,0.79189444),(3725,7334,1.5622902e-2),(3725,8850,0.60533875),(3725,27251,0.44025442),(3726,14520,0.7272675),(3726,27088,0.5776584),(3726,27190,0.47366765),(3726,32269,0.28592092),(3727,4813,0.85165304),(3727,11349,0.9908639),(3727,31306,0.6848955),(3728,182,0.4489238),(3728,550,0.3859876),(3728,991,0.24448206),(3728,8149,5.3853806e-2),(3728,12617,0.8792111),(3728,14652,0.9940894),(3728,15041,0.886331),(3728,23925,8.301074e-2),(3728,27640,0.1266283),(3728,27798,0.9332727),(3728,28981,0.5815938),(3729,19710,0.9764893),(3729,20817,0.3916801),(3729,21049,0.6890767),(3730,2266,6.6280834e-2),(3730,31939,0.42775854),(3731,602,0.12859109),(3731,6192,0.88522387),(3731,21117,0.19548146),(3731,31076,0.66925955),(3732,24731,0.68287194),(3732,28998,0.26457134),(3733,3381,0.34783816),(3733,20646,0.598613),(3733,30162,0.73892003),(3734,5988,0.99000096),(3734,9000,0.7601853),(3734,19210,0.78001124),(3734,21373,0.5082139),(3734,26087,0.31531286),(3734,28232,0.31134096),(3734,28266,2.7478907e-2),(3734,32678,0.51382715),(3735,9361,0.44192085),(3735,15689,0.2795953),(3736,3545,0.71893835),(3736,10060,0.63837254),(3736,17207,0.40599123),(3736,18572,0.5592436),(3736,19307,0.7041033),(3737,2011,0.10221567),(3737,5508,0.2697084),(3737,6951,0.3940857),(3737,20959,0.5827251),(3738,3484,0.15596908),(3738,6902,7.356541e-2),(3738,12158,0.60716605),(3739,6178,0.15554549),(3739,21695,0.23689872),(3739,24398,1.1032193e-2),(3740,3425,0.5293348),(3740,3737,0.7533824),(3740,4901,3.0060865e-2),(3740,14154,0.75085783),(3740,22342,0.39658582),(3740,24266,3.18804e-2),(3740,28622,0.8598962),(3741,6401,0.404738),(3741,15501,0.64098525),(3741,17238,0.7779565),(3741,27533,0.64320946),(3741,30544,0.76133657),(3741,31382,0.5392849),(3741,31406,0.98495567),(3742,11690,0.24776462),(3742,23368,0.36018178),(3742,28435,0.5108511),(3742,29888,0.7208257),(3743,11184,0.97709054),(3744,4697,0.5374232),(3744,12363,0.32025898),(3744,17190,0.6614185),(3744,17473,0.6075451),(3744,32034,0.4703632),(3745,12411,0.3437333),(3745,24813,0.5919846),(3745,31262,0.7872158),(3746,11962,8.0564745e-2),(3746,12007,0.5868408),(3746,14704,4.2775005e-2),(3746,16901,0.2744229),(3746,29801,0.118739694),(3747,10934,0.36333817),(3747,20432,0.48007324),(3747,22468,0.98923105),(3747,22994,0.56982327),(3748,2341,0.6173049),(3748,30021,0.6206889),(3748,30436,0.73178303),(3748,30624,0.93112683),(3749,5485,0.46874654),(3749,6227,0.26335734),(3749,15467,5.609028e-2),(3749,20287,0.28724384),(3749,21330,0.9213982),(3750,27921,0.28407013),(3750,29381,0.46084705),(3750,31036,0.556027),(3751,5772,0.805661),(3751,9364,0.9890416),(3751,27045,0.72943187),(3751,31900,0.16473344),(3752,1316,4.4379387e-5),(3752,11737,0.9095175),(3752,31843,0.28726935),(3753,1737,0.6646225),(3753,8508,0.5882031),(3753,10947,0.6347761),(3753,14263,1.0879318e-2),(3753,16694,0.877102),(3753,16880,0.82950085),(3753,27665,0.104270175),(3753,29714,0.12931849),(3754,2282,0.8009552),(3754,21431,0.11675438),(3754,26041,0.26499572),(3755,11575,0.80488724),(3755,20763,0.6419686),(3755,25220,6.984078e-2),(3756,11705,0.95993596),(3756,18649,0.28382224),(3756,28524,0.10987745),(3756,29154,0.7992602),(3756,32055,0.27917328),(3757,6000,7.664732e-2),(3757,7508,0.75731456),(3757,9220,0.15372685),(3757,9277,0.1351812),(3757,10562,0.6406735),(3757,20006,0.5992671),(3757,22773,0.60183036),(3757,30994,0.47977397),(3758,1084,0.99449456),(3758,6590,0.1727026),(3758,14387,0.98653287),(3759,5943,0.4884918),(3759,17625,0.93585896),(3760,4413,0.71346235),(3760,9805,8.628323e-2),(3760,10854,0.86530375),(3760,25212,0.24088746),(3761,496,0.9776873),(3761,3868,0.5591247),(3761,29835,0.117336884),(3762,20848,0.2281357),(3762,26747,0.8840019),(3762,28271,5.200108e-2),(3762,29517,4.7547422e-2),(3763,22335,0.291808),(3764,8258,0.51974523),(3764,8656,0.44274905),(3765,12847,0.61536664),(3765,16619,5.93928e-2),(3766,2776,0.23986186),(3766,13719,0.52483875),(3766,28078,0.44055828),(3767,3286,0.35198706),(3767,14092,0.2754645),(3767,19483,0.80173814),(3767,23241,0.47286946),(3767,30109,0.96605647),(3768,1231,2.4919733e-2),(3768,5917,0.48108125),(3768,6253,0.9589344),(3768,21516,0.25621453),(3768,28095,0.47071242),(3769,3977,0.66995126),(3769,6307,0.67910707),(3769,6573,0.3031971),(3769,9273,0.8743357),(3769,9551,0.3199066),(3769,12462,0.5032455),(3769,25805,0.72748107),(3770,5650,0.5443007),(3770,11294,0.74358976),(3770,16104,0.3611023),(3770,18628,0.31298977),(3770,31795,0.25703272),(3771,2877,0.8875831),(3771,5264,0.9194825),(3771,13029,0.44114187),(3771,17326,0.15985101),(3771,20493,0.107221164),(3771,24205,0.16650115),(3771,28003,0.9481495),(3771,28027,0.35897827),(3772,3267,0.26599422),(3772,26191,0.5066581),(3773,8400,0.59985423),(3773,9449,0.42760992),(3773,10835,0.30616668),(3773,17686,0.7410808),(3773,21723,0.33132887),(3773,31373,0.67990375),(3774,343,0.56336564),(3774,16124,0.84451205),(3774,22836,0.4911995),(3774,29945,0.49525166),(3775,1840,0.9097889),(3775,19061,0.65817845),(3776,8786,0.9328995),(3778,14217,0.3613878),(3778,28400,0.59761375),(3779,10565,0.83982146),(3779,12347,0.7096525),(3779,13682,0.5604432),(3779,17978,0.2318499),(3779,19956,0.45250946),(3780,16469,0.64422196),(3780,24015,0.66939074),(3780,24670,0.961883),(3780,25049,0.87374157),(3781,19609,0.18097636),(3782,7056,0.5811718),(3783,27083,0.77253634),(3784,17376,0.5226923),(3784,19001,0.2103044),(3784,24194,0.10654734),(3784,25054,0.816864),(3784,27587,0.6433915),(3784,28840,0.9074681),(3785,4791,0.55539924),(3785,14178,0.61886543),(3785,20701,0.7864514),(3785,21865,0.5769567),(3785,29722,0.5037919),(3786,7270,0.34659457),(3786,15530,0.11234622),(3786,18945,0.9665804),(3786,25614,0.3829301),(3786,25656,0.9578247),(3787,6090,0.19430384),(3787,10317,0.6968582),(3787,24777,0.10234448),(3788,5772,0.22194983),(3788,7980,7.275397e-2),(3788,9573,0.36712575),(3788,11126,0.6337219),(3789,329,0.30919015),(3789,8208,0.4415529),(3789,15513,0.41579854),(3789,22252,0.81252366),(3790,329,0.5406867),(3790,6181,0.7488718),(3790,9749,0.68240047),(3790,15574,0.54530627),(3790,17048,0.8819075),(3790,31614,0.38482365),(3791,1514,0.8655012),(3791,15402,0.9825776),(3791,16718,8.687916e-2),(3791,21625,0.15900652),(3791,25229,0.90370005),(3791,26863,0.5424449),(3792,3943,2.0402271e-2),(3792,4382,0.6029669),(3792,16728,3.860816e-2),(3792,18742,0.4469633),(3792,23073,0.8682486),(3792,30965,0.9794204),(3792,32302,0.45633817),(3793,16098,0.4755122),(3793,26748,0.27146888),(3793,29970,0.7961608),(3794,15337,0.5395954),(3794,17324,8.532254e-2),(3794,28555,0.96422887),(3795,3425,0.26490942),(3795,5133,0.46743008),(3795,6229,0.2651814),(3795,12632,0.31254232),(3795,32011,1.8425785e-2),(3796,81,0.5277965),(3796,3948,0.83821607),(3796,8605,0.16522922),(3796,12408,0.91472256),(3796,32757,0.5167196),(3797,6821,0.83418584),(3798,9095,0.34917653),(3798,23665,0.6642596),(3798,24416,0.3779548),(3798,26285,0.91373414),(3798,30557,0.7298493),(3799,14128,0.56838477),(3800,8313,6.472269e-2),(3800,17922,0.3023947),(3800,24632,0.67086613),(3800,24851,0.5839448),(3801,8626,0.69098866),(3801,14954,0.2599051),(3802,689,0.299215),(3802,6162,0.5382281),(3802,18752,0.6968528),(3803,5762,0.5603249),(3803,11111,0.10248491),(3803,12596,0.22281605),(3803,12824,0.26532418),(3803,14520,0.98659325),(3803,22100,0.58030856),(3803,31469,0.9314387),(3804,29361,2.709408e-2),(3804,32367,0.3250922),(3805,4309,0.902518),(3805,10151,0.312892),(3805,24035,0.14535284),(3805,24141,0.37456465),(3806,6161,0.9552714),(3806,8721,0.22441314),(3806,18967,0.8116071),(3807,14119,0.6200449),(3807,19620,0.10971173),(3807,24113,0.55448467),(3808,19922,0.21292564),(3808,30533,0.71815264),(3808,30604,0.7192196),(3808,31255,0.92675394),(3809,906,0.5622796),(3809,7863,0.41340455),(3809,11055,0.63797307),(3809,25274,0.7949856),(3809,28987,8.093177e-2),(3810,3278,0.15260452),(3810,20440,0.12898988),(3810,22466,0.654761),(3810,24724,0.47378185),(3811,4079,0.66523826),(3811,10520,0.99825585),(3811,11964,0.35346884),(3811,14343,0.47159654),(3811,17806,9.282448e-2),(3811,22720,0.6904871),(3811,27927,0.6957953),(3812,317,0.83057076),(3812,22637,0.40856865),(3812,26932,7.214813e-2),(3812,29373,0.724084),(3812,29495,0.8106441),(3812,31588,0.67028064),(3813,19991,0.6907823),(3813,20847,0.32596642),(3813,32559,0.7017189),(3813,32618,0.610632),(3814,3423,0.14425756),(3814,5162,5.0175726e-2),(3814,29151,0.7188187),(3816,5546,0.1274304),(3816,12874,0.6729847),(3816,15348,0.7665846),(3816,24079,0.3469785),(3816,32030,0.7239262),(3817,2651,0.5449887),(3817,14874,0.70830685),(3817,15301,0.7481552),(3817,18379,0.28000787),(3818,691,0.599536),(3818,2461,2.8840607e-2),(3818,10671,0.29793334),(3818,21086,0.21327396),(3818,32422,0.48975545),(3819,14153,0.6650232),(3819,32438,0.29888028),(3820,4940,0.35494915),(3820,17383,0.4963128),(3821,7092,0.5211927),(3821,9332,0.10802052),(3821,20739,0.37213546),(3822,21,0.19860068),(3822,16978,0.82537323),(3822,18743,0.5163731),(3822,19500,1.3352776e-2),(3822,21413,0.73044145),(3822,24276,0.55276924),(3822,27181,0.937242),(3823,6527,0.31495813),(3823,31277,0.7248556),(3824,4834,0.9400251),(3824,7702,0.8855386),(3824,11939,0.5513114),(3824,15402,0.18929264),(3824,17319,0.5777621),(3824,18787,0.4740253),(3824,26208,0.8338647),(3825,5654,0.28092414),(3825,7924,0.4722785),(3825,10029,0.7410108),(3825,12365,0.53960085),(3825,18260,0.36939472),(3825,22122,0.827075),(3826,3839,0.6241303),(3826,4536,0.14678904),(3826,9212,0.6040063),(3826,16016,0.70313174),(3827,4386,0.50175285),(3827,5023,0.5805662),(3827,9313,0.57103103),(3827,9518,0.16174228),(3827,12842,0.43940672),(3828,2175,0.44508177),(3828,2690,0.71479726),(3828,3482,5.6505546e-2),(3828,17059,0.35838786),(3829,6641,0.2534916),(3829,21538,0.45471674),(3829,27463,0.32261032),(3829,27731,0.14799789),(3830,8459,0.38362756),(3830,10132,0.4308344),(3830,10857,0.9593744),(3830,27653,0.9798425),(3831,6186,0.9527907),(3831,16779,4.042567e-2),(3831,25989,0.6843941),(3832,8256,2.3393204e-2),(3832,13318,0.6003236),(3832,19432,0.48829255),(3832,25380,5.2275774e-3),(3832,26736,0.60393935),(3832,26920,0.2609594),(3833,4731,0.3998248),(3833,20401,0.71075916),(3833,23023,0.7405482),(3834,8649,0.682907),(3834,10477,0.10444741),(3834,28621,0.48177242),(3835,1473,0.63576895),(3835,5995,0.3117932),(3835,13509,0.32501262),(3835,25994,0.14044571),(3835,29222,0.3579014),(3836,9195,6.812011e-3),(3836,11954,0.31138143),(3836,19132,0.77621806),(3836,31813,0.13580787),(3837,10464,0.56106275),(3837,10770,0.10177939),(3837,16272,0.23909162),(3837,17264,0.4227408),(3837,26180,0.50283307),(3838,1813,0.27863273),(3838,7893,0.6079853),(3838,9863,0.11400099),(3838,27760,0.6082819),(3838,31022,0.9215229),(3839,7186,1.7293492e-2),(3839,15293,0.6666898),(3839,32664,0.64745575),(3840,32591,0.6189068),(3841,12349,0.9666195),(3841,30252,0.6197303),(3842,1343,5.3490937e-2),(3842,17417,0.8002838),(3842,24367,0.34548095),(3842,27081,0.80371577),(3842,30069,0.7402338),(3843,11864,0.89559376),(3843,16950,0.21307337),(3843,21907,4.3167748e-2),(3844,6691,0.35812682),(3844,10599,0.45564654),(3844,28994,0.104991525),(3845,95,0.83640337),(3845,4288,2.354913e-2),(3846,4416,0.19065037),(3846,22317,0.25424656),(3846,22511,0.4236264),(3846,27817,0.74542296),(3847,1858,0.37416676),(3847,2692,3.3536687e-2),(3847,15201,0.17207858),(3847,19067,0.69815344),(3847,21024,0.96986073),(3847,23585,0.91861755),(3847,27222,0.23170581),(3847,29600,0.69489574),(3847,31224,0.95687985),(3848,2736,0.59429616),(3848,10635,0.46506953),(3849,15637,0.88077253),(3849,21868,0.5503517),(3849,25900,4.2828884e-2),(3850,9563,3.889389e-2),(3850,10927,2.1120314e-2),(3850,27936,0.38925537),(3850,28983,0.27006933),(3851,1781,0.57232445),(3851,2233,0.4976044),(3851,17355,0.11986932),(3851,22075,0.64795333),(3852,3637,0.45561135),(3852,3772,0.5481291),(3852,5646,0.82613003),(3852,11128,0.16012573),(3852,12147,0.13672961),(3852,20373,0.63572013),(3852,24123,0.881694),(3853,6687,0.7305265),(3853,8314,0.5761168),(3854,11129,0.78083706),(3854,21840,0.71243995),(3855,4348,0.45454282),(3855,7474,0.401448),(3855,12104,0.42083657),(3855,14900,0.71366435),(3855,15680,0.89003104),(3855,15879,0.11171463),(3855,16573,0.324414),(3855,18741,7.973361e-2),(3856,15252,0.54372984),(3856,20208,0.11820193),(3856,20336,0.9026662),(3857,1655,0.90099883),(3857,15711,0.15953453),(3857,27374,0.54748255),(3858,1458,0.12804367),(3858,1874,0.8426232),(3858,2798,0.32608595),(3858,12503,0.52985734),(3859,2426,0.5328613),(3859,6020,2.9124683e-2),(3859,21082,0.12463302),(3860,6889,0.87971705),(3860,15155,0.7227261),(3860,17875,0.84177),(3860,22064,0.5535356),(3860,23575,6.7652473e-3),(3861,5656,0.46918875),(3861,6048,0.48191974),(3861,9724,9.29941e-2),(3861,25109,0.63895386),(3862,14654,0.93206596),(3862,22038,0.19773309),(3862,29440,0.7569311),(3862,31746,6.4567006e-3),(3863,8516,0.8495607),(3863,10925,0.36228102),(3863,18141,0.66169727),(3863,22593,0.7003799),(3864,6352,0.1352248),(3864,20471,0.96567),(3865,885,0.74985933),(3865,4481,0.9104021),(3865,5572,0.9327989),(3865,23278,0.8454119),(3865,25919,6.989161e-2),(3866,1920,0.7736611),(3866,14457,0.75143147),(3866,22944,0.76102215),(3866,32081,6.476359e-2),(3867,8524,0.31035227),(3867,9992,0.75782794),(3867,31491,0.41688576),(3867,32498,0.24122766),(3868,10220,0.13612399),(3868,29176,0.6474974),(3869,896,0.2050505),(3869,1519,0.6726676),(3869,5175,3.90381e-2),(3869,23621,0.5004721),(3869,29237,0.174616),(3870,5369,0.45836183),(3870,28974,0.9670532),(3871,2013,0.6544169),(3871,25814,5.7592895e-2),(3871,28877,1.0273829e-2),(3871,31879,6.182183e-2),(3872,5228,2.0053115e-2),(3872,11332,0.62589616),(3872,19295,0.23486456),(3872,19456,0.63625085),(3873,12363,0.30698532),(3873,29943,0.73602116),(3874,304,0.16508278),(3874,2213,0.5664886),(3874,13470,0.8678717),(3875,2531,0.36416334),(3875,3195,0.9209384),(3875,4308,0.60321486),(3875,15132,0.52362907),(3875,23381,0.83755285),(3875,30342,0.38021004),(3876,7759,0.7989376),(3876,15805,8.67749e-2),(3876,25140,0.65478545),(3876,31943,0.25370416),(3877,1488,0.22670737),(3877,3711,0.72692007),(3877,9654,0.17215073),(3877,16920,4.1775562e-2),(3878,16273,0.19287941),(3878,20520,0.22689483),(3878,21343,0.75113565),(3878,23953,0.22930242),(3879,6411,0.7792007),(3879,14796,0.605708),(3879,15932,0.9132546),(3880,11578,0.37890217),(3880,13446,0.4885579),(3881,8639,0.9312218),(3881,13596,0.6551407),(3882,859,0.74932516),(3882,1307,0.2022719),(3882,10738,0.35905403),(3882,16343,0.75924957),(3882,27795,0.6409073),(3882,30138,0.292254),(3882,31192,0.3539556),(3883,4969,0.3560641),(3883,16803,0.35735264),(3883,20479,0.6634468),(3883,30824,0.33681494),(3884,215,0.55872625),(3884,2690,0.6774832),(3884,24043,0.44465193),(3884,26506,0.8156577),(3885,15253,0.10114743),(3885,31976,0.8918078),(3886,2775,0.7718372),(3886,6181,0.6377434),(3886,7086,0.44116798),(3886,17856,0.92061406),(3886,20319,0.2877479),(3886,20537,0.62561095),(3886,29711,0.80370754),(3887,8851,7.099631e-2),(3887,23709,0.2799619),(3888,4557,0.9416874),(3888,7015,0.20066983),(3888,11460,0.89178705),(3889,4829,0.49190038),(3889,9587,0.4375169),(3889,12134,0.74413604),(3889,16204,0.6910511),(3889,19379,0.2649161),(3889,25938,0.34432003),(3889,31217,0.5906698),(3889,31416,0.6075574),(3890,15178,0.5053943),(3890,21199,0.16199929),(3890,30854,0.902636),(3891,3199,0.3839986),(3891,11030,0.56380516),(3891,11259,0.74882585),(3891,22527,0.319848),(3891,25179,0.42746767),(3891,28703,6.34668e-2),(3892,11337,0.66745126),(3892,16205,0.41940662),(3892,20038,0.1435992),(3892,27246,0.5821989),(3893,19683,0.3025399),(3893,27075,0.67888576),(3894,5558,0.8491629),(3894,6871,0.68112284),(3894,15882,0.7336623),(3894,23018,0.40255424),(3894,29133,0.85831374),(3895,3856,0.71336263),(3895,5896,0.9105358),(3895,11908,0.7321105),(3895,15476,0.121715315),(3895,19790,0.3464875),(3895,20413,0.6181431),(3895,21841,0.30126488),(3896,5249,0.8823224),(3896,5730,0.5087239),(3896,10129,0.48509973),(3896,11193,0.9683576),(3896,11591,0.4920963),(3896,22917,0.950525),(3896,28295,0.865226),(3897,10747,0.8471497),(3897,10913,0.8176129),(3897,15420,0.112764),(3897,17289,0.66948736),(3897,17604,0.44513854),(3897,20262,0.9656809),(3898,14169,0.9122983),(3898,29747,0.8242873),(3898,31604,0.6309277),(3899,12098,0.6089219),(3899,19324,0.72727025),(3900,2431,0.43839142),(3900,3343,4.558198e-2),(3900,8457,0.14235695),(3900,9310,0.5369133),(3900,27723,0.47806224),(3901,7949,0.8859716),(3901,14254,0.45887753),(3901,17706,0.9839543),(3901,23699,1.5539561e-2),(3901,24875,0.39384007),(3901,31843,0.7912021),(3902,6438,0.61818373),(3902,11345,0.24817064),(3902,15807,0.54422307),(3902,28737,0.5393729),(3902,32289,0.520963),(3903,10746,9.003787e-2),(3904,862,0.75348914),(3904,1735,0.37185025),(3904,16059,0.16631988),(3904,16061,0.2980466),(3904,24128,0.91257095),(3904,27952,0.10083675),(3904,32248,0.75703144),(3905,4620,0.44683355),(3905,6013,0.66428727),(3905,11384,0.84009033),(3905,26912,0.36705163),(3906,5301,0.7796292),(3906,9341,0.44690695),(3906,19960,0.3192922),(3906,25998,0.7896218),(3907,271,0.20721912),(3907,9237,0.505592),(3907,19461,0.59422),(3907,21223,0.78659767),(3908,687,0.48418012),(3908,4796,0.47247434),(3908,15015,0.77292144),(3908,19255,0.17947417),(3908,21452,0.51562023),(3908,23413,0.6810671),(3908,26626,0.404096),(3908,30901,0.29258493),(3909,1040,0.92335933),(3909,4025,0.8857531),(3909,9569,0.47216806),(3909,20274,0.99426824),(3909,26524,0.27380165),(3909,27358,0.525233),(3910,14276,0.30376524),(3910,24837,0.3301604),(3911,3548,0.47880626),(3911,5664,0.8050548),(3911,8263,0.2485397),(3911,9431,0.87307316),(3911,12650,0.82029337),(3911,20093,3.193715e-2),(3912,1081,0.63983506),(3912,1964,0.5051324),(3912,7351,0.20869754),(3912,19671,0.5234169),(3912,23978,0.78660655),(3913,5057,0.6954155),(3913,5507,0.7312921),(3913,8921,0.13310121),(3913,12893,0.11737255),(3913,20758,0.65588987),(3913,25373,0.6476989),(3914,4795,0.7686388),(3914,8792,0.92168736),(3914,23946,0.37963358),(3914,26728,3.88004e-2),(3915,252,0.18583575),(3915,4476,0.8507761),(3915,18737,0.23101962),(3916,6826,0.9920665),(3916,13424,1.3810194e-3),(3916,13915,0.6862004),(3916,19834,0.6065988),(3916,24328,0.8022075),(3916,28146,0.6539725),(3916,32397,0.91204196),(3917,7789,0.21583243),(3917,12541,0.59370697),(3917,18626,0.45391887),(3917,25128,0.9138833),(3917,27342,0.36440304),(3918,16251,0.5023327),(3918,16947,0.20716347),(3918,24488,8.4194675e-2),(3919,307,7.944085e-3),(3919,410,0.39026856),(3919,5441,0.39468735),(3919,6015,0.52202266),(3919,14861,0.8598244),(3919,27555,0.7587851),(3919,30163,0.56463593),(3920,2810,0.36842072),(3920,4132,0.3921909),(3920,4335,0.35476616),(3920,15011,8.179486e-2),(3920,15204,0.9559259),(3920,27124,0.37428212),(3921,1251,0.5364229),(3921,23151,0.40708545),(3922,4566,0.67189753),(3922,5965,1.3624112e-2),(3922,29189,0.97394145),(3923,3580,4.877258e-2),(3923,32652,0.5508654),(3924,2250,0.486537),(3924,11186,0.9333411),(3924,12272,0.14096627),(3925,1820,0.30007726),(3925,12778,0.8830739),(3925,16562,0.68799335),(3925,25871,1.34442365e-2),(3925,30226,0.49012506),(3926,14146,5.6092273e-2),(3926,15533,0.44671226),(3926,17601,0.47517797),(3926,20019,0.26799157),(3926,27151,0.6466493),(3927,1828,0.97498137),(3927,2918,0.608295),(3927,3753,0.69109523),(3927,3963,0.27198863),(3927,7873,0.9001085),(3928,30366,0.79540676),(3928,30528,0.85332686),(3929,6473,0.9277043),(3929,6774,0.30290642),(3929,25208,0.2607157),(3929,26581,0.23943752),(3930,6680,0.3628264),(3930,15397,0.21713199),(3931,13795,0.25525814),(3931,18957,3.7213337e-2),(3931,22197,2.523614e-2),(3931,22551,0.566833),(3932,26867,0.10480962),(3932,29086,0.9082697),(3933,19885,0.7810627),(3933,26623,0.9686779),(3933,29850,0.93340737),(3933,30850,0.7412029),(3934,805,0.32540268),(3934,1322,0.98783994),(3934,11830,0.61369324),(3934,15428,0.33687606),(3934,17883,0.50853014),(3934,31713,0.36313376),(3935,29632,0.51324195),(3935,30925,0.8097944),(3936,13877,0.70260614),(3936,17074,0.11717881),(3936,19034,0.37667912),(3936,24630,0.8854756),(3937,565,0.75306964),(3937,3347,0.9267673),(3937,10707,4.778686e-2),(3938,25830,0.35393652),(3938,30431,0.36910263),(3939,316,0.18104021),(3939,19160,0.88046896),(3940,2484,0.7930037),(3940,10542,0.4242305),(3940,26104,0.45337376),(3940,28425,0.5007432),(3941,20627,0.71877396),(3941,22889,0.90955234),(3941,23784,0.8878449),(3941,23907,0.31835243),(3942,1381,0.25592384),(3942,6411,0.49116135),(3943,5108,0.77509695),(3943,15046,0.93142927),(3944,21364,0.47845495),(3944,22234,0.97999966),(3944,23058,0.14265606),(3945,12976,0.2736212),(3945,15177,0.7759567),(3945,26560,0.17146926),(3945,27500,0.3283645),(3945,29808,0.21009816),(3946,1003,0.31149557),(3946,9919,0.9795606),(3947,10121,0.7795158),(3947,15346,0.8035159),(3947,20460,0.8334312),(3947,23076,0.23077618),(3947,28172,0.85730034),(3948,9402,0.3508158),(3948,32652,0.27762595),(3948,32762,0.98277396),(3949,7422,0.3000846),(3949,12771,0.1913761),(3949,20716,0.56710714),(3949,22748,0.6035363),(3949,28456,0.55534977),(3949,30709,0.17718238),(3951,7033,0.5175876),(3951,16295,0.45681316),(3951,18815,0.49731502),(3951,25298,0.6315861),(3951,26139,0.11799363),(3951,28142,0.3936672),(3952,12674,0.8175086),(3952,17980,4.0153556e-2),(3953,12110,0.6104696),(3953,32613,0.2753162),(3954,12856,0.81305534),(3954,26133,0.8998979),(3955,2715,0.4953931),(3955,15853,0.1609649),(3955,17212,0.34597257),(3955,18655,0.7506318),(3955,19522,0.9634829),(3955,24787,0.91271544),(3955,27509,0.86158246),(3956,2020,0.66983366),(3956,7512,1.4782881e-2),(3956,22905,0.1504239),(3956,24901,0.38677013),(3957,10318,0.29001278),(3957,22153,0.4408098),(3957,26228,0.9727405),(3958,9169,0.9201721),(3959,4942,0.7411968),(3959,14080,0.8920947),(3959,14778,0.4073848),(3959,16486,0.88422173),(3959,19007,0.76202464),(3959,29664,0.5502729),(3959,31163,0.1333459),(3960,1637,0.5754825),(3960,5129,0.6015064),(3960,9467,0.36076784),(3960,14544,0.4671384),(3960,21852,0.11846243),(3960,23407,0.94697016),(3961,7626,0.65352005),(3961,10686,0.91612774),(3961,12151,0.17419653),(3961,15358,4.22839e-2),(3961,25392,0.2658374),(3962,15484,6.270476e-2),(3962,28054,0.645157),(3962,29519,0.3573692),(3963,15879,6.257751e-2),(3963,16913,0.68197805),(3963,22121,0.7043904),(3963,26690,0.31503704),(3964,30019,0.55630815),(3965,1203,0.5715406),(3965,7261,0.62326384),(3965,15704,0.6025929),(3965,17944,0.39379418),(3965,31992,0.17088532),(3966,2962,0.772001),(3966,15952,7.879534e-3),(3966,17730,0.6102191),(3966,22515,0.52712715),(3967,5851,0.8369172),(3967,7369,3.627769e-2),(3967,12379,6.528197e-2),(3968,11337,0.984798),(3969,6141,0.89080334),(3969,10698,0.81149304),(3969,16282,0.60317755),(3969,21478,0.14575435),(3969,25668,0.24720836),(3970,5393,0.28674215),(3970,8379,0.77777416),(3970,15979,0.53795433),(3970,17448,0.28851035),(3970,32310,1.2451941e-2),(3971,4019,0.5398489),(3971,4321,0.9711385),(3971,5740,0.2735021),(3971,6013,0.29269612),(3971,7200,0.13180877),(3971,17682,0.29819044),(3971,26672,0.4437885),(3971,27562,0.8427826),(3972,2589,0.19445188),(3972,22106,0.5055451),(3972,32750,0.95040524),(3973,4821,0.52792495),(3973,31888,0.14218614),(3974,2279,0.8960674),(3974,21066,0.5790417),(3974,28518,0.9751757),(3975,8161,0.87375593),(3975,8827,0.4747986),(3976,2270,0.86571413),(3976,9841,0.7362329),(3976,20428,0.8650846),(3977,22002,5.1036984e-2),(3977,28066,0.78855944),(3978,5550,0.2933505),(3978,12404,0.75804746),(3978,22308,0.82205343),(3979,9835,0.94817334),(3979,27433,0.22578575),(3979,30991,0.98758745),(3980,3264,0.13397296),(3980,9381,0.86948603),(3980,30264,0.5254995),(3981,1213,0.8283418),(3981,1940,0.20712003),(3981,16664,6.496242e-2),(3981,17965,0.21030888),(3982,6899,0.14682671),(3982,9470,0.8987025),(3982,14455,0.44619003),(3982,29499,0.6499238),(3983,9147,8.077374e-3),(3983,11693,0.7942117),(3983,14215,0.2474087),(3984,1819,0.601744),(3984,2631,0.124879494),(3984,12862,0.965238),(3984,15862,0.2663252),(3984,16009,5.2274726e-2),(3984,29398,0.2836569),(3985,978,0.46749413),(3985,5923,0.4550392),(3985,11436,0.9381461),(3985,16025,0.57389104),(3985,17216,0.22683616),(3986,16765,0.9703176),(3986,18337,0.5472278),(3987,360,2.0707315e-3),(3987,5488,0.49266216),(3987,6838,0.6454481),(3987,12260,0.45424178),(3987,15010,0.20567183),(3987,15412,0.955231),(3987,25698,0.9941642),(3987,28179,0.9461243),(3988,6086,0.83454305),(3988,7991,0.9475851),(3988,23311,0.3915672),(3988,32354,0.17288002),(3989,6399,0.92109036),(3989,9389,1.3688153e-2),(3989,28505,0.4061516),(3990,10668,0.8600095),(3990,32581,0.72213155),(3991,20499,0.6790552),(3991,27680,0.75399864),(3991,28761,0.19996688),(3992,4161,0.6410745),(3992,21602,0.8229754),(3992,21679,0.6799584),(3992,26039,0.262181),(3993,4315,0.29927623),(3993,9064,2.915643e-2),(3993,26515,0.30107117),(3993,27762,0.9324167),(3993,28302,0.36824632),(3993,30803,0.22000568),(3994,100,0.44784126),(3994,16312,0.65616065),(3994,16846,0.59523565),(3994,20605,0.18982962),(3995,3314,0.6411719),(3995,5207,0.8926209),(3995,15467,9.1236874e-2),(3995,20879,0.17306384),(3995,20883,8.3737716e-2),(3996,8754,0.5590462),(3996,13321,0.48837614),(3996,15193,0.7494005),(3996,24158,0.7508309),(3997,4989,0.536836),(3997,8935,0.29712355),(3997,23444,0.3135327),(3997,27397,2.9091719e-3),(3998,98,0.16393895),(3998,7721,0.5835186),(3998,12936,0.76698875),(3998,20598,0.56305385),(3998,23024,0.9238856),(3998,24461,0.25555003),(3998,25499,0.50429475),(3998,25791,0.79834795),(3999,8100,0.73878676),(4000,23965,0.37903076),(4000,24725,0.5876451),(4000,28858,0.60523343),(4000,31597,5.9097067e-2),(4001,1212,0.41886473),(4001,5413,0.9735248),(4001,29720,0.9164275),(4002,12103,0.10572246),(4002,13607,0.16327351),(4002,15418,0.27112824),(4002,21019,0.37467918),(4002,23279,0.65955883),(4002,27250,0.841908),(4003,3796,0.6894309),(4003,9332,3.3938836e-2),(4003,16809,0.9852072),(4004,2343,0.76346445),(4004,4392,0.31758395),(4004,8788,0.8743629),(4004,20169,9.986403e-2),(4005,16698,0.22016822),(4005,17582,0.41580173),(4005,22552,0.6982471),(4006,176,0.581773),(4006,6975,1.7096293e-4),(4006,8368,0.5422603),(4006,8403,0.34425783),(4007,730,0.4087248),(4007,5672,0.55262566),(4007,6108,0.39358923),(4007,6683,0.40034035),(4007,9115,0.6132976),(4007,16262,0.84226686),(4007,19431,0.47439682),(4008,9018,0.41844183),(4008,14167,6.1492298e-2),(4008,17969,1.2501266e-2),(4008,21029,0.25805894),(4008,21375,0.7794344),(4008,25366,0.5714927),(4009,6096,0.9366692),(4009,8381,0.3797446),(4009,10853,0.572244),(4009,30278,0.82392013),(4010,6580,0.7004645),(4011,6349,3.9062176e-2),(4011,15575,0.77683306),(4012,3324,0.5517331),(4012,4123,0.86841923),(4012,15179,0.60617965),(4012,20178,0.3055796),(4012,20519,0.1896723),(4012,29876,0.18274759),(4013,9044,0.29733387),(4013,17373,0.4268114),(4013,28750,2.3758656e-3),(4013,29535,0.14617752),(4014,5754,0.114885375),(4014,6427,0.17010337),(4014,21052,0.3170489),(4014,23296,0.33127555),(4014,30532,0.18140754),(4015,28441,0.45064062),(4016,4393,0.13130014),(4016,13531,0.31547338),(4016,14092,0.65786713),(4016,15402,0.89709544),(4016,24480,0.57449895),(4016,30661,0.5174776),(4016,30855,0.45273602),(4017,13873,7.038154e-2),(4017,14953,0.22428443),(4017,20911,0.97971934),(4017,28251,0.1453798),(4018,12487,0.3318853),(4018,18370,0.35022607),(4019,332,0.21123654),(4019,1875,0.62097347),(4019,6322,0.97896266),(4020,8013,7.470961e-2),(4020,31384,5.762445e-2),(4021,13203,0.80084497),(4022,9226,0.39685476),(4022,13330,0.5919741),(4023,1750,0.58861893),(4023,3364,0.5799917),(4023,11802,0.99133813),(4023,13518,0.46487272),(4023,14442,4.7245853e-2),(4023,26640,0.37772593),(4024,2170,0.42357472),(4024,10000,0.5814335),(4024,19151,0.49763682),(4024,28621,0.33907384),(4024,29098,0.16089875),(4025,8485,0.99945754),(4025,20694,0.15858187),(4026,1155,0.30105093),(4026,4648,0.23833801),(4026,14876,1.1381107e-2),(4026,26145,0.36058012),(4027,15150,0.2740498),(4027,19010,0.77148205),(4028,681,0.47675908),(4028,21370,0.90013057),(4028,31586,0.36787003),(4029,7036,0.8488519),(4029,7914,0.3683282),(4029,14750,0.5274951),(4030,1461,0.7400264),(4030,12763,0.8048959),(4030,14570,8.0272265e-2),(4030,23784,4.0725954e-2),(4030,25172,0.44934526),(4030,28301,0.3143695),(4030,28370,0.54491025),(4030,28692,0.59341687),(4030,28902,0.40854397),(4030,29739,0.9774461),(4031,17414,0.22211722),(4031,17517,0.58833283),(4031,18995,0.68698585),(4031,20328,0.92280537),(4031,21501,0.8517104),(4031,25993,0.16533962),(4032,14792,6.4409114e-2),(4032,18270,0.26327604),(4032,22281,0.55609155),(4032,28409,0.16548005),(4033,8185,0.29707533),(4033,21149,0.99692225),(4033,25195,0.6477502),(4034,3207,0.42569694),(4034,14432,1.2735086e-2),(4034,20051,0.21123883),(4034,22222,0.58725274),(4034,24274,0.5071337),(4034,29934,0.67707217),(4034,32446,0.95084065),(4035,18141,0.8576488),(4035,19707,0.51143944),(4036,24044,0.65153044),(4036,25448,0.2787041),(4036,25816,0.9863947),(4037,3592,0.42587852),(4037,11007,0.5854449),(4037,29335,9.416888e-2),(4037,31167,6.149698e-2),(4037,32241,0.9977693),(4038,1144,0.3420855),(4038,2503,0.3190197),(4038,9379,0.46294802),(4038,15789,0.9004865),(4039,238,0.10000481),(4039,2285,0.31189737),(4039,4095,0.99544114),(4039,4549,4.9450908e-2),(4039,21623,0.5408847),(4039,25327,0.5374577),(4040,29483,0.82381934),(4041,9522,0.8398901),(4041,13886,0.39718515),(4041,29114,0.5708013),(4042,1100,0.20964846),(4042,12341,0.816431),(4042,17038,0.5178267),(4042,32153,0.9403179),(4043,6166,0.80948776),(4043,15438,0.13446265),(4043,19080,0.296459),(4044,6516,0.3181779),(4044,19982,0.8743341),(4044,27532,0.18914872),(4045,6938,0.15069228),(4045,13262,2.5789043e-2),(4045,14488,0.7182621),(4045,27216,0.7338948),(4045,28398,0.45367968),(4046,355,0.8994759),(4046,8118,0.98450583),(4046,8854,0.9517316),(4047,16300,0.78022444),(4048,2670,0.557056),(4048,8906,0.7892876),(4048,19344,0.62137),(4048,23182,0.9469264),(4049,1091,2.444847e-2),(4049,4589,0.5931661),(4049,10765,0.56315964),(4049,11973,0.9937331),(4049,13029,0.7813681),(4049,13736,0.8932067),(4049,19682,0.7017926),(4050,1338,0.6518242),(4050,16802,0.3699541),(4050,31041,0.1939011),(4051,17242,0.9812557),(4052,8839,0.82127917),(4052,11042,0.73429286),(4052,25000,0.45774436),(4053,20210,0.36214763),(4053,29136,0.889053),(4053,30751,0.33550987),(4054,20696,0.68154055),(4054,24119,0.14106333),(4054,26492,0.38232782),(4055,3298,0.50037265),(4055,15501,0.9516317),(4055,24613,0.75404847),(4056,1097,0.9754462),(4056,27484,0.7257163),(4056,31480,0.9708635),(4056,31495,0.38584465),(4057,471,0.59623784),(4057,4085,6.462581e-2),(4057,10263,0.96889937),(4057,18218,0.948398),(4057,24332,0.5164179),(4058,7584,0.96411794),(4059,5371,0.6519608),(4059,6487,0.6666157),(4059,19843,2.1465197e-2),(4060,1994,0.45333785),(4060,7848,0.89143664),(4060,8599,0.13924031),(4060,17696,0.47892815),(4061,16074,4.8711684e-2),(4061,32661,0.42704967),(4062,8628,0.6011151),(4062,9865,0.20019826),(4062,12104,8.785508e-2),(4062,21512,0.5011731),(4062,25132,0.9718203),(4063,1820,0.5461395),(4063,13328,5.291719e-2),(4063,15268,0.7273681),(4063,16625,6.626633e-2),(4063,32066,0.3075251),(4064,12107,0.9929047),(4064,13891,0.6269661),(4065,21077,0.95084774),(4065,25480,0.802424),(4065,29992,0.74068564),(4065,30041,0.12636504),(4066,1327,0.7086904),(4066,6934,0.83261764),(4066,23617,0.17006704),(4067,26336,0.15047896),(4067,30836,5.511522e-2),(4068,21093,0.18535937),(4068,21387,0.7983415),(4068,23307,2.092591e-2),(4068,26241,0.1595203),(4068,31221,0.81172425),(4069,221,0.4623903),(4069,4209,0.4432412),(4069,16653,0.12317877),(4069,18469,0.7054269),(4069,27603,5.8533e-2),(4070,2353,1.0298339e-3),(4070,28750,1.7056769e-2),(4070,30151,0.39806497),(4071,2707,0.6203017),(4071,7893,3.8651567e-2),(4071,8242,0.47480804),(4071,10839,0.6141301),(4072,3587,0.34413114),(4072,18225,9.7203225e-2),(4072,24822,0.8040915),(4073,1530,0.6754496),(4073,3073,0.88765913),(4073,23299,0.7943102),(4074,12883,0.44443047),(4074,14132,0.63762355),(4075,5892,0.61170405),(4075,9363,0.4336771),(4075,19989,0.10002871),(4075,24477,0.5396302),(4075,28110,0.18939313),(4075,32076,0.16585095),(4076,21194,0.22697206),(4076,31031,0.3019931),(4077,390,0.7630562),(4077,2225,0.75784814),(4077,15370,0.9269841),(4077,15973,2.7341994e-2),(4077,17979,8.415424e-2),(4078,1194,0.89134496),(4078,12732,0.85748905),(4078,21647,0.32228357),(4078,30520,0.73518956),(4079,31042,0.3904634),(4080,1628,0.3257745),(4080,10604,0.15933828),(4080,12888,0.82346606),(4080,32752,0.71739864),(4081,21866,9.262703e-2),(4081,22311,0.48965463),(4082,12865,0.6521596),(4082,20135,0.21378759),(4083,6097,0.97970897),(4083,25633,0.84047),(4084,22082,0.62109786),(4085,4,0.84927094),(4085,7490,0.79685533),(4085,11835,0.27109325),(4085,14430,0.85886467),(4085,25770,0.6863326),(4086,12041,0.52207524),(4086,15559,0.6820831),(4086,20962,3.734231e-2),(4086,23426,0.7236586),(4086,25975,0.80951047),(4086,26897,0.5447934),(4086,31514,0.22799201),(4087,1680,0.24806726),(4087,2081,0.28124538),(4087,2406,0.61054343),(4087,19449,0.9112267),(4087,28778,0.58456993),(4088,2329,0.8191366),(4088,10103,0.37829673),(4088,30421,0.31165883),(4089,4655,0.7510801),(4089,9044,0.8251749),(4089,9232,0.98599994),(4089,21031,0.8689284),(4089,31877,0.5422451),(4089,32164,0.4358397),(4090,3762,3.5708507e-3),(4090,4219,0.516524),(4090,8789,0.93507874),(4090,20532,0.18712303),(4090,25394,0.81936896),(4091,7976,0.12499859),(4091,29085,9.1938585e-2),(4092,460,0.9824982),(4092,3722,0.6788107),(4092,14597,0.914143),(4092,25393,0.30218318),(4093,5451,0.86678946),(4093,8574,0.93516475),(4093,16698,0.2839677),(4093,22902,0.8420005),(4093,24332,0.58112836),(4093,25982,0.57618535),(4093,31530,0.11431298),(4094,3863,0.56126875),(4094,8630,0.64927125),(4094,21210,0.1024975),(4094,31204,0.52727824),(4095,23147,0.26191077),(4095,26802,0.3084843),(4096,706,0.63782436),(4096,12508,0.97873515),(4096,18380,0.633687),(4096,28712,0.37122673),(4097,1887,0.17570543),(4097,16948,0.8174195),(4097,19939,8.413961e-2),(4097,25881,0.66360086),(4097,31759,0.5262685),(4098,1874,0.73702943),(4098,8438,0.52614903),(4098,21173,0.61079437),(4098,22788,0.73017776),(4098,26581,0.41091454),(4099,1296,0.6508845),(4099,9409,0.46406496),(4099,12699,0.95195365),(4099,12877,0.39131895),(4100,1716,0.8080682),(4100,12090,0.62879103),(4100,21440,0.70086116),(4101,21,0.16610686),(4101,8202,0.3211773),(4101,17506,0.49022257),(4101,32759,0.6766742),(4102,8969,0.5095114),(4102,18068,6.5688044e-2),(4102,31867,0.19827263),(4103,6949,0.5173267),(4103,8086,0.16212566),(4103,15653,0.45488888),(4103,15922,0.5099159),(4103,21459,0.5114906),(4104,4959,0.56354225),(4104,12717,0.47597653),(4104,29509,0.4390356),(4105,4654,0.78955007),(4105,10928,0.288504),(4105,13467,0.32447824),(4105,19640,9.626465e-2),(4106,8516,0.26184586),(4106,18016,0.7992148),(4107,436,0.25531083),(4107,8749,0.43310794),(4107,23548,0.35854682),(4107,25727,9.6654214e-2),(4108,5195,0.82447),(4108,10312,0.71990734),(4108,27781,0.37497464),(4108,28220,0.16557795),(4109,2340,0.3594763),(4109,7671,0.48840743),(4109,14095,4.8559826e-2),(4109,23378,0.4080783),(4109,24001,0.22602868),(4109,27472,0.6671149),(4110,1119,0.78652537),(4110,6291,0.5153942),(4110,11037,8.546203e-2),(4110,19193,0.5425071),(4110,30573,0.715007),(4111,6080,0.41590545),(4111,11950,1.1088364e-2),(4111,15469,0.10878242),(4111,17577,3.892878e-2),(4111,20389,0.14033797),(4111,21936,0.24988474),(4111,26398,0.8240668),(4111,28250,0.6642726),(4112,1442,0.97701216),(4112,20854,5.026284e-2),(4112,21887,0.9126675),(4113,10158,0.6868178),(4113,19087,0.69015396),(4114,504,7.397459e-2),(4114,12887,0.10614081),(4114,20792,0.2139071),(4114,31829,0.5275697),(4115,6987,0.115203336),(4115,25731,0.7235972),(4115,27404,0.29720345),(4115,28004,0.7349833),(4115,29016,0.52546716),(4116,4481,0.830731),(4116,9034,0.41965482),(4116,11534,0.73241067),(4116,25690,0.14095911),(4117,16965,0.60601366),(4117,25796,0.24794927),(4118,12019,0.4873416),(4118,17391,0.47750068),(4119,2613,9.333374e-2),(4119,6964,0.39273918),(4119,8504,0.27703172),(4119,8727,0.92396337),(4119,15614,0.787328),(4119,26129,0.5371146),(4120,5807,0.33635518),(4120,18638,0.7810177),(4120,25480,0.27577257),(4120,26211,0.8812911),(4121,7813,0.3809592),(4121,21601,0.11678105),(4122,367,0.8598515),(4122,12507,0.30824912),(4122,16655,0.36773455),(4122,18893,0.88645196),(4122,21202,0.17835532),(4122,21534,0.77190095),(4122,23601,0.6379544),(4122,31056,0.14340931),(4123,2181,0.28425157),(4123,12412,0.9999098),(4123,17232,0.73630726),(4123,21507,0.11545255),(4123,23841,0.67724645),(4123,32332,0.918415),(4124,12277,0.81605506),(4124,22251,0.24278037),(4124,25816,0.97641885),(4124,26100,0.99064976),(4124,26701,0.5562672),(4124,28284,0.10860501),(4124,29846,0.2814266),(4125,4697,0.751638),(4125,20864,0.98711675),(4125,26460,0.54599714),(4126,10987,0.54293776),(4126,14207,0.4559771),(4126,16609,0.7923923),(4126,19566,0.93452555),(4126,20320,0.7621369),(4126,20987,0.34426194),(4126,31264,0.749594),(4127,21183,4.7561787e-3),(4127,21665,8.77123e-3),(4127,31239,0.16893177),(4128,6168,0.5140991),(4128,23548,5.535859e-2),(4128,24519,9.212368e-2),(4128,29258,0.38784683),(4129,10412,0.20515344),(4129,15290,0.10623138),(4129,26332,0.34822795),(4129,27608,0.45100054),(4130,4219,0.27510366),(4130,5511,0.9408518),(4130,18822,5.8682602e-2),(4131,11343,5.1662277e-2),(4131,13008,0.7994333),(4131,14170,0.72936094),(4131,20801,0.686838),(4132,1871,6.748262e-2),(4132,6749,0.66483665),(4132,19192,0.20240285),(4133,1093,0.34381536),(4133,2172,0.33750156),(4133,9255,0.8790725),(4133,15254,0.9048327),(4133,23955,0.12993261),(4134,1797,8.634125e-2),(4134,4787,0.27515343),(4134,10066,0.60918385),(4134,15017,0.666767),(4134,26548,0.42906517),(4134,30049,0.8962448),(4135,3470,0.74616873),(4135,6769,0.6799964),(4135,7515,0.36869454),(4135,30177,0.46723774),(4136,8408,0.21827123),(4136,14008,0.24885143),(4136,14997,0.9144827),(4137,12301,0.5865957),(4137,28308,0.74449694),(4137,30076,1.4540465e-2),(4138,7070,0.8413884),(4138,12141,0.9240506),(4139,1126,0.24242297),(4139,22657,0.5643246),(4139,26211,0.7587317),(4140,2227,0.2410264),(4140,2962,0.2760183),(4140,10619,0.30437964),(4140,15801,0.5564605),(4140,20993,0.75311553),(4141,1188,6.917344e-2),(4141,22533,0.42910764),(4141,30205,0.5859022),(4142,1829,9.015726e-4),(4142,11771,0.61008763),(4142,25021,0.48835883),(4142,30767,0.2171864),(4142,31211,0.5586327),(4142,32623,0.33146858),(4143,8541,0.15400235),(4143,22934,0.8099745),(4143,30619,0.7186314),(4144,1706,0.22218433),(4144,4099,0.45580593),(4144,17238,0.47889018),(4144,22106,0.12309017),(4144,32261,0.3758046),(4145,1484,0.8810646),(4145,1719,0.92443395),(4145,6855,0.12852797),(4145,11010,0.24110073),(4145,11534,8.409663e-2),(4145,12472,0.6109302),(4145,12768,0.13611029),(4145,20034,0.4257047),(4146,8223,0.83935386),(4148,3333,0.5770697),(4148,11609,0.6974484),(4148,22759,0.3271296),(4149,11636,0.8998051),(4149,16144,0.6196763),(4149,29834,0.24990536),(4150,1502,0.34883085),(4150,12840,0.1489825),(4150,14499,0.6151545),(4150,16306,1.3617268e-2),(4150,24973,0.89705753),(4151,6735,0.78886443),(4151,22265,0.46156043),(4152,75,0.3474162),(4152,13734,0.21594515),(4152,14973,0.8372267),(4152,19406,0.9509475),(4152,26250,8.338657e-2),(4152,32408,0.32594115),(4153,4187,0.33596137),(4153,8909,0.9660949),(4153,26049,0.36167794),(4153,32473,6.549185e-2),(4154,3678,0.36781237),(4154,23347,0.6534572),(4154,28007,0.5878),(4154,31191,0.94877934),(4155,2096,0.28618294),(4155,11333,0.9951345),(4155,14281,5.833993e-2),(4155,15518,6.221732e-2),(4155,18438,0.3107873),(4155,21703,0.69652843),(4155,31830,0.19297467),(4156,2589,0.58228475),(4156,5338,0.14336789),(4156,8142,0.4869643),(4156,28755,8.158019e-2),(4156,32105,0.4974012),(4157,1633,0.36078095),(4157,2504,0.57120836),(4157,8438,0.3502234),(4158,739,8.599752e-3),(4158,8970,0.19073404),(4158,16597,0.18821989),(4158,26028,0.3515845),(4158,26155,7.421112e-2),(4159,40,0.76928425),(4159,3077,0.7425718),(4159,13021,4.1703165e-2),(4159,27512,0.64099455),(4160,27,0.80508673),(4160,8070,0.9902641),(4160,16155,0.7942475),(4160,26536,0.9385592),(4160,29345,0.44033897),(4160,29806,0.2327476),(4161,6935,0.94271135),(4161,30695,0.98975915),(4162,24895,0.70813006),(4163,3919,0.78796935),(4163,11299,0.24172297),(4163,21821,0.46594158),(4164,6644,0.9290714),(4164,9946,0.95859265),(4164,20211,8.925516e-2),(4165,23789,0.7186814),(4166,5389,0.8918393),(4166,8456,0.3758807),(4166,18549,0.17231451),(4166,28486,0.16811119),(4167,3762,0.9434861),(4167,15941,0.7479691),(4167,18177,0.8041653),(4168,10050,0.41629505),(4168,18930,0.21696824),(4168,22884,0.67346656),(4169,3761,0.80139875),(4169,17233,0.22530688),(4170,2487,0.8638116),(4170,19266,0.5246245),(4170,25450,0.8275336),(4171,1414,0.3680663),(4171,3234,0.7820813),(4171,13511,0.48050633),(4171,17386,0.15965773),(4171,17728,0.1002884),(4171,20973,0.62787455),(4172,13341,0.46278185),(4172,14330,0.888733),(4172,20654,0.4182453),(4172,28491,0.5288069),(4172,31277,0.25795275),(4173,2182,5.906153e-2),(4173,16324,0.7635889),(4173,19108,0.9611427),(4174,5570,0.85425776),(4174,9989,0.4430395),(4174,19029,0.53828275),(4174,26328,0.93577677),(4174,32249,0.10504351),(4175,3649,0.48137385),(4175,27443,0.91779417),(4176,4615,0.3953121),(4176,7918,0.16952595),(4176,8308,0.7118237),(4177,15054,0.92707556),(4178,1688,0.8892513),(4178,8467,0.34900004),(4178,12534,0.3265921),(4178,21526,0.46822095),(4179,8784,0.5682993),(4180,6583,0.2927781),(4180,12189,0.50043786),(4180,16261,0.6282344),(4180,24334,0.8482119),(4180,26900,0.55035126),(4180,26903,0.72366023),(4180,27214,0.41090906),(4180,29835,0.15529576),(4181,6154,0.9101627),(4181,6640,0.29888365),(4181,20387,0.3125763),(4182,3384,0.69135267),(4182,11964,0.3093202),(4182,23779,0.50421906),(4182,27282,0.19419947),(4183,7756,0.637427),(4183,18240,0.8358771),(4183,28735,0.924993),(4184,11659,0.5636256),(4184,26554,0.88526106),(4185,9435,1.8477067e-2),(4186,274,0.4536067),(4186,17928,0.5217031),(4186,21120,0.52350605),(4186,25281,0.9451213),(4187,5419,0.23884375),(4187,16164,0.4281145),(4187,17825,0.5682832),(4187,26404,0.896233),(4187,31714,0.63457674),(4188,1560,0.9251995),(4188,20668,0.7191048),(4188,21824,0.9631586),(4189,3938,0.82347935),(4189,11484,0.39669308),(4189,17695,0.30604577),(4189,28908,0.60563713),(4189,29146,0.37079066),(4189,29426,0.91596097),(4190,9748,0.60658646),(4190,26904,0.11379325),(4191,18027,0.11476502),(4191,18200,0.26714766),(4192,3466,0.4989842),(4192,5503,0.16422577),(4192,6549,0.652661),(4192,9590,0.9675618),(4192,11164,0.95664614),(4192,12275,0.8128592),(4193,3042,0.77487713),(4193,3742,0.90057015),(4193,4465,0.59804827),(4194,7714,0.9900434),(4194,19794,0.45657223),(4194,22752,5.1528133e-2),(4194,30628,0.36535162),(4194,31780,0.79726374),(4195,18176,0.4681037),(4196,8506,0.78265786),(4196,8833,3.938383e-2),(4196,21677,0.43810683),(4196,32432,0.3036998),(4197,28071,0.46344993),(4197,30151,0.27096388),(4197,31374,0.5822016),(4198,1862,0.5271784),(4199,1708,5.3568702e-2),(4199,3829,0.69554293),(4199,4362,0.7281424),(4199,4463,9.22563e-2),(4199,12975,0.8934628),(4199,21638,0.39961216),(4200,6158,0.22220464),(4200,9010,0.6931325),(4200,21874,0.41967642),(4201,9634,0.25724033),(4201,24645,0.83787906),(4201,29509,0.83925694),(4202,11723,0.6577856),(4202,23657,0.4050205),(4202,26313,0.65230155),(4203,11880,0.9415801),(4203,28444,0.92622435),(4204,3473,0.5238579),(4204,12403,0.28256014),(4204,19458,0.300139),(4205,2877,0.60990846),(4205,15190,0.8612822),(4205,23202,6.544715e-2),(4206,4953,0.63290596),(4207,10637,0.6153241),(4207,11358,0.40253702),(4207,12127,0.24574059),(4207,18579,0.378421),(4207,24627,0.8280013),(4208,6558,0.8761832),(4208,18418,0.18793939),(4208,30071,0.2997875),(4208,30351,0.5744693),(4208,31436,0.7236156),(4209,536,0.27455267),(4209,4194,0.925052),(4209,11094,0.31843555),(4209,23439,0.3192223),(4210,26526,6.6633426e-2),(4211,15124,0.43542975),(4211,23455,0.45745444),(4211,25756,0.34592113),(4212,3608,0.7329751),(4212,12871,0.5451712),(4212,25460,6.470543e-2),(4212,31613,0.5410605),(4213,2976,0.26115778),(4213,4340,0.22215037),(4213,19196,0.8878301),(4213,30315,0.8255812),(4213,30792,0.94128245),(4214,4683,0.6742592),(4214,21254,9.06774e-2),(4215,7115,0.8242047),(4216,3033,1.8699313e-2),(4216,5092,0.56200254),(4216,5468,0.7881942),(4216,10591,0.72069126),(4216,29730,0.5287988),(4216,31903,0.5295943),(4217,6923,0.44359303),(4217,26829,0.48397934),(4217,29597,0.8410752),(4217,32443,6.295455e-2),(4218,124,0.7355607),(4218,4846,0.48603043),(4218,5436,0.844395),(4218,32049,0.716475),(4219,2189,0.62304306),(4220,10943,0.8417361),(4220,16097,0.795475),(4220,27660,0.44314235),(4221,1931,0.25432536),(4222,12684,0.44094944),(4222,27739,0.9025398),(4222,31299,0.829063),(4223,16515,0.8555476),(4223,18125,0.32851675),(4223,18137,0.40516305),(4224,11675,0.36073512),(4224,29608,0.6028532),(4225,1951,0.2993128),(4225,24817,0.31941804),(4226,15631,0.40744883),(4226,19945,0.7722236),(4226,22773,0.9875532),(4226,29001,0.11248855),(4226,29042,0.8111007),(4226,29286,0.5240766),(4227,1426,0.21490675),(4227,12262,0.40588838),(4228,294,6.0758684e-2),(4228,1332,0.60091496),(4228,11149,0.9471668),(4228,13790,0.15219223),(4228,15600,0.6790345),(4228,20379,0.8978162),(4228,22337,0.6893349),(4229,2014,0.91065973),(4229,11716,0.6425409),(4229,14088,2.853173e-3),(4229,14423,0.7051077),(4230,3428,0.66951936),(4230,4161,0.43262),(4230,14145,0.2235657),(4230,15720,0.5024802),(4231,10114,0.9504984),(4231,27079,0.8707837),(4231,28280,0.1658806),(4232,4682,0.33870855),(4232,6234,0.23289391),(4232,7633,0.46528497),(4232,13222,0.9256695),(4232,14397,0.97071135),(4232,16050,5.7317473e-2),(4232,19688,0.60733515),(4232,31369,0.5776049),(4232,32536,0.24610156),(4233,18687,0.6468081),(4235,6053,0.19372441),(4235,25874,0.44454944),(4235,25960,0.14451538),(4235,27870,0.63449484),(4236,24696,0.30481535),(4236,27024,0.8998911),(4237,5946,0.97130233),(4237,18272,1.7557582e-2),(4237,20562,0.30549774),(4237,27859,0.40764946),(4238,3397,0.51003104),(4238,3520,0.8550249),(4238,17153,0.8224865),(4238,21719,1.5137694e-2),(4238,24870,0.91423494),(4238,27365,0.84357095),(4238,28087,0.613287),(4238,31619,0.9816029),(4239,7919,8.351572e-2),(4239,32521,4.370395e-2),(4240,1936,2.783301e-2),(4240,17920,0.9424495),(4240,27574,0.73582554),(4240,27720,0.6639173),(4240,29235,0.65023774),(4241,18591,0.334404),(4241,20176,0.731697),(4242,1761,0.985071),(4242,2980,0.38302568),(4242,8704,0.32675368),(4242,13610,3.3398166e-2),(4242,13946,0.30095693),(4243,5473,0.5347262),(4243,5754,0.7344673),(4243,11513,0.9587989),(4243,21729,0.82848126),(4243,26798,0.37783676),(4243,29544,0.4829273),(4244,6962,0.99920017),(4244,11605,0.3194683),(4244,16560,0.9341923),(4244,30178,0.4221201),(4244,32092,0.62023956),(4245,23964,0.38186207),(4245,24821,0.36316872),(4245,26379,6.903107e-2),(4246,4984,0.423254),(4246,5863,0.5361853),(4246,26042,0.7659525),(4246,31641,0.7852714),(4247,9776,0.40678573),(4247,22727,0.65048635),(4248,10643,0.9373661),(4248,20591,8.1327856e-2),(4249,1225,0.28303823),(4249,6080,0.52636117),(4249,9593,0.66607),(4249,22595,0.44839382),(4250,13133,0.15721866),(4250,18551,0.58480865),(4251,9167,0.7535064),(4251,23796,0.71324384),(4251,31009,0.34090626),(4252,7073,0.3794673),(4252,7286,0.13238172),(4252,9964,0.45841494),(4252,16842,0.8972993),(4252,29389,4.079959e-2),(4253,7641,0.848674),(4253,21803,0.39964837),(4253,29169,0.3214719),(4253,30338,2.3729289e-2),(4254,5988,0.112968676),(4254,16180,0.37959912),(4255,4239,0.20000151),(4255,22711,0.5339059),(4255,30353,0.20459382),(4256,6341,3.6014426e-2),(4257,7815,0.96751744),(4257,9877,0.7607181),(4257,13068,0.47555816),(4257,16563,0.39972824),(4257,20400,0.28843138),(4258,21080,9.085852e-2),(4259,4003,0.3584112),(4259,7604,0.9466426),(4259,9140,0.3003406),(4259,10481,0.44239914),(4259,15667,0.26021367),(4259,19369,0.94067794),(4259,23364,0.47461683),(4259,24928,0.415437),(4259,32218,0.76370144),(4260,7955,2.7488163e-2),(4260,13441,0.6020731),(4260,16565,0.118681766),(4260,17481,0.79959184),(4260,27898,0.6499962),(4260,30833,8.6142376e-2),(4261,1713,0.21547453),(4261,26667,0.7534513),(4262,7993,0.44965124),(4262,9905,0.7815533),(4262,11300,0.8588637),(4262,12902,0.2746863),(4262,18511,0.25891647),(4262,20265,0.86923456),(4262,29821,0.6356333),(4262,30176,0.66017044),(4263,1803,0.32466897),(4263,8842,4.0229186e-2),(4263,12278,0.30641913),(4263,23032,0.14090836),(4263,29261,0.88641673),(4263,30373,0.41467974),(4264,23793,0.40714118),(4265,873,5.7748903e-2),(4265,10215,0.8872016),(4265,12001,0.36306092),(4265,12326,0.5795837),(4265,12601,0.317329),(4266,1970,0.42313656),(4266,10976,0.55862457),(4266,21578,3.82662e-2),(4267,16269,0.44925088),(4267,16716,0.1709973),(4267,20016,0.35089192),(4267,23805,0.46558675),(4267,25148,0.852214),(4267,27673,0.7383816),(4268,618,5.340387e-2),(4268,2474,0.12662886),(4268,9806,0.5009281),(4268,15189,7.132802e-2),(4268,22667,0.4162702),(4268,27855,0.64448065),(4268,31761,0.15459381),(4269,5109,0.16002022),(4269,10408,0.413434),(4269,12276,0.42793003),(4269,19153,4.4329997e-2),(4269,20148,0.92288893),(4270,13098,0.81305903),(4270,20381,0.6274233),(4270,27981,0.4955937),(4270,30652,0.45753044),(4270,30994,0.5540379),(4271,7944,4.777995e-2),(4271,23690,0.82364243),(4272,4016,0.7264185),(4272,22500,0.17857966),(4272,24999,0.21160567),(4273,4573,0.47602752),(4273,10300,0.1602869),(4273,12621,0.27651742),(4273,13425,0.8891313),(4273,24529,0.55453765),(4273,30423,1.851674e-2),(4274,7067,0.77178484),(4274,22209,0.7058985),(4274,22542,0.65814114),(4275,15501,0.5702129),(4275,18096,0.56440336),(4275,31497,0.43551213),(4275,32553,0.7634874),(4276,9525,0.34463072),(4277,2831,0.67882764),(4277,23864,0.49750313),(4278,20783,0.6677849),(4278,21290,0.72888833),(4278,26490,0.74821776),(4279,9096,0.7690439),(4279,17322,0.6553354),(4279,32465,0.61868846),(4280,2577,5.4025773e-2),(4280,4665,0.1383446),(4280,7583,0.11976393),(4281,1839,0.16866325),(4281,5939,0.5103042),(4281,29207,0.2041312),(4281,32613,0.59884596),(4282,10094,0.23476617),(4282,11231,0.25524494),(4282,22938,1.10983085e-2),(4283,28043,0.11968382),(4283,29346,0.21824062),(4284,12428,0.6784789),(4284,22307,0.5547388),(4284,25942,8.404944e-2),(4284,32194,2.7960042e-2),(4285,816,0.12334745),(4285,7984,0.16581765),(4285,7997,0.9746253),(4285,9907,0.65654814),(4286,3146,0.59279114),(4286,8119,0.24132393),(4286,16082,0.24914658),(4286,22450,0.92128575),(4286,23435,0.7211757),(4286,23460,0.9123261),(4286,28475,0.71618485),(4287,6320,0.8902058),(4287,29056,0.96451056),(4287,29331,0.66871303),(4288,2185,0.6982509),(4288,4511,0.67968374),(4288,20604,0.1250983),(4289,86,0.6843194),(4289,5293,0.38608146),(4289,12167,5.0562825e-2),(4289,12423,0.45739454),(4289,20595,0.81240857),(4289,25624,0.3543551),(4289,31015,0.48293182),(4291,4201,0.832669),(4291,8367,0.416674),(4291,12770,0.8106804),(4291,13159,3.739076e-2),(4291,23796,6.0923923e-2),(4292,11374,0.52743924),(4292,13993,0.16775893),(4292,20081,0.38177535),(4292,25942,0.42238554),(4292,26082,7.885716e-3),(4292,26776,0.4674541),(4293,2120,0.65391946),(4293,10541,0.27805424),(4293,11277,0.50117034),(4293,20505,0.8784962),(4293,26265,0.61829436),(4293,26822,0.24939173),(4293,28057,0.18197294),(4294,20394,0.99805117),(4294,32377,0.9335498),(4294,32599,0.95997995),(4295,989,0.36740968),(4295,27572,0.53075415),(4296,10971,0.2930503),(4297,7266,0.6277709),(4297,11958,0.1760156),(4298,11412,0.4902346),(4298,15699,0.494543),(4298,24521,0.66950005),(4298,28816,0.15496874),(4299,7724,0.99367267),(4299,10760,0.70467407),(4299,31529,0.104463175),(4300,12826,0.9473353),(4300,14418,0.6983743),(4300,25620,2.752675e-2),(4300,31323,9.509279e-2),(4301,7046,0.39763018),(4301,9703,0.41156903),(4301,16520,0.512922),(4301,19921,0.5581636),(4301,25172,0.22939548),(4302,4577,0.69209206),(4302,15696,2.9256148e-2),(4302,17620,3.8934566e-2),(4302,26846,0.12894014),(4302,32706,0.7896611),(4303,4981,5.7610583e-2),(4303,10707,0.9215511),(4303,17389,0.17900941),(4303,20799,0.4785912),(4303,29820,9.934293e-2),(4303,30361,0.6125094),(4304,9584,0.7370734),(4304,15143,0.4567626),(4304,18737,0.39022592),(4305,15565,3.0711714e-2),(4305,23240,0.17355561),(4305,23859,0.7540462),(4305,28272,0.32395524),(4306,20983,0.8395007),(4306,23773,0.9926153),(4306,24653,0.67868143),(4306,28936,0.3993614),(4306,29078,0.29405004),(4307,3115,9.212076e-2),(4307,6044,0.60113084),(4307,16381,0.27234268),(4307,29141,4.855744e-2),(4308,609,0.28225252),(4308,1192,0.5110438),(4308,4882,0.38443094),(4308,12416,0.9552199),(4308,18713,0.88695735),(4308,22549,0.8029585),(4309,106,0.4879918),(4309,10781,0.3180946),(4309,18139,0.571464),(4309,19152,0.54608464),(4309,21626,0.9343514),(4309,22586,0.26034325),(4309,23994,0.6051355),(4309,31590,0.6631117),(4310,3225,0.22254513),(4310,7479,0.25025088),(4310,14595,4.6209715e-2),(4310,28773,0.58153796),(4310,32228,0.42548677),(4311,4765,0.4859889),(4311,6832,0.5180968),(4311,14182,0.7524799),(4312,6666,0.9074517),(4312,9876,0.18529645),(4312,21035,0.89601606),(4312,23707,8.971155e-2),(4312,24871,0.5770084),(4312,26433,0.925687),(4312,26773,9.817933e-3),(4313,3686,0.47887868),(4313,17583,0.67956406),(4314,1628,0.7467801),(4314,3606,0.52054137),(4314,4833,0.36951458),(4314,6719,0.9314646),(4314,11374,0.8393205),(4314,15053,0.4089717),(4314,22916,0.48413295),(4314,30322,0.45110652),(4314,32370,0.34387976),(4315,87,0.19106206),(4315,18555,0.49784583),(4315,31040,0.7318996),(4316,7235,0.56306785),(4316,7478,0.4315733),(4316,15358,0.24006721),(4316,22109,0.33209363),(4316,30509,0.21359459),(4317,5835,0.20625135),(4317,6990,5.3769775e-2),(4317,24140,0.16126302),(4317,25262,0.71676534),(4317,30363,0.7685334),(4317,31683,0.2252862),(4318,1179,0.89365923),(4318,4626,0.8346824),(4318,7462,0.4081287),(4318,14828,0.4167787),(4318,16673,0.7436623),(4318,16949,0.14751925),(4318,20646,0.19700283),(4319,1179,0.27675375),(4319,20876,0.13210659),(4319,22974,0.16840698),(4320,6691,0.12695605),(4320,8368,0.35294297),(4320,9134,0.50849783),(4320,9598,3.7351146e-2),(4320,24154,0.672349),(4321,7127,0.670451),(4321,14510,0.15259649),(4321,27296,5.542987e-2),(4322,613,1.7492954e-2),(4322,12882,0.9133263),(4322,30018,0.8126471),(4323,6725,0.46878725),(4323,16390,0.9160447),(4323,18771,0.79001343),(4323,29926,0.8753648),(4324,4205,0.42019972),(4324,4273,0.6638029),(4324,15893,0.7393974),(4325,1309,0.65976506),(4325,2444,0.7992596),(4325,6432,0.7581813),(4325,12388,0.13455355),(4325,14880,0.17568626),(4325,30325,0.26111323),(4327,1772,0.28254053),(4327,2916,6.73926e-2),(4327,22678,7.321025e-2),(4327,27726,0.21920685),(4327,28973,0.4343197),(4328,11289,7.867834e-3),(4328,15673,0.61309075),(4328,29008,0.64266276),(4329,1209,0.18137129),(4329,7934,0.39035296),(4329,16719,0.8568617),(4329,29569,0.98142064),(4330,96,0.3650294),(4330,714,4.2652104e-2),(4330,6667,0.14177911),(4330,9399,0.8389939),(4330,28332,0.2813467),(4330,28968,0.7851541),(4330,29119,0.41349527),(4331,15668,0.6308606),(4332,476,0.7427961),(4332,868,0.14001462),(4332,4723,0.33734643),(4332,23486,0.45593554),(4333,7279,2.0070814e-2),(4333,8897,8.689602e-2),(4333,9780,0.26221964),(4333,11917,0.8149051),(4333,21408,1.276304e-2),(4333,32220,0.32751107),(4334,2044,0.8266399),(4334,14558,0.8984721),(4336,7622,0.17527792),(4336,11704,0.21904846),(4336,21585,0.14440857),(4337,4057,0.6157844),(4337,29192,0.53793144),(4338,12870,0.5402776),(4338,17871,4.741999e-2),(4338,26633,0.4471025),(4338,31073,0.34779206),(4339,15837,0.8065831),(4339,29053,1.1543773e-2),(4340,13876,0.8172442),(4340,15420,0.9519053),(4340,23124,0.88257277),(4340,24995,0.107748516),(4340,26330,0.1400078),(4340,27094,0.56572783),(4341,9867,0.52956635),(4341,10105,0.5905564),(4341,26302,0.22643748),(4342,1706,0.110357255),(4342,1871,0.26703057),(4342,19195,0.5384324),(4342,21727,0.24052475),(4342,30618,0.91403717),(4343,1132,0.8216949),(4343,1712,0.1913424),(4343,5584,0.50018424),(4343,6240,0.9452239),(4343,23091,0.5512841),(4343,24484,5.685035e-4),(4344,3333,0.34142226),(4344,6496,0.89076746),(4344,9988,0.46843472),(4344,25958,0.7951489),(4345,3965,0.89982235),(4345,10405,0.4357914),(4345,15198,4.4807874e-2),(4345,17325,0.3987219),(4346,1633,1.0921508e-2),(4346,16490,0.13544081),(4347,879,0.18706027),(4347,1348,0.7889388),(4347,2613,0.60513306),(4347,11355,3.6706604e-2),(4348,29126,0.81301683),(4349,1542,0.2218952),(4349,12149,0.31811133),(4349,16186,3.9761573e-2),(4349,20145,0.96977586),(4350,2109,5.153396e-2),(4350,3542,0.14043684),(4350,7342,0.13687047),(4350,8391,0.95492816),(4350,15837,0.9365112),(4350,19309,0.6373156),(4350,19760,0.2391501),(4350,21470,0.9979963),(4350,22231,0.9367),(4351,11923,0.48510495),(4352,16353,0.4414436),(4352,17720,0.6005638),(4352,20151,0.5073876),(4353,394,0.21637583),(4353,2270,0.39607537),(4353,12179,1.05662765e-2),(4353,14215,0.23980431),(4353,17726,0.7350772),(4353,24779,0.15173098),(4353,27430,0.7710024),(4354,14583,0.11431346),(4354,23044,0.10745301),(4355,7604,0.39652053),(4355,8520,0.66861063),(4355,22478,0.7144615),(4355,24440,0.9362115),(4356,7298,6.297141e-2),(4356,9413,0.48616722),(4356,27595,0.63204294),(4356,32671,0.41223994),(4357,767,0.79159707),(4357,19030,0.9594518),(4357,22872,0.13021082),(4357,24055,3.8669936e-2),(4357,27663,0.79634887),(4358,102,0.24824241),(4358,143,0.93078613),(4358,28657,0.5921786),(4359,16447,0.7015839),(4360,7309,0.35508183),(4360,26587,0.31456363),(4362,6155,0.3596215),(4362,8124,0.51907486),(4362,17593,5.6597862e-2),(4362,32341,4.607456e-2),(4363,5228,0.86538583),(4363,8354,0.65115994),(4363,20468,0.87609315),(4363,27947,0.2579075),(4364,15735,0.12221758),(4364,20885,0.8487775),(4364,21270,0.8678562),(4364,30881,0.44075024),(4365,162,0.693857),(4365,7939,0.21171519),(4365,19099,0.52935654),(4366,1669,8.959617e-2),(4366,3561,0.6957964),(4366,7024,7.030846e-2),(4366,8050,0.89360476),(4366,8968,0.15102571),(4367,1253,0.59288245),(4367,2782,0.6261934),(4367,10335,0.10194749),(4367,30935,0.51735586),(4368,13794,5.6758296e-2),(4368,18602,0.1815775),(4368,32287,0.6939061),(4369,866,8.691314e-2),(4369,5127,0.53575706),(4369,5432,0.94626874),(4369,8678,0.72200394),(4369,9602,0.30798468),(4369,14510,0.928493),(4369,17460,0.55453444),(4369,24330,0.8544884),(4369,26892,0.8777012),(4369,28610,0.71460104),(4370,14270,0.6293181),(4370,23428,0.4217865),(4370,32518,0.914325),(4371,2594,0.11808397),(4371,4912,0.18908893),(4371,5063,0.34239662),(4371,8260,2.0137567e-3),(4371,11847,0.26244104),(4371,17659,0.31419867),(4371,20719,9.148975e-2),(4371,23274,0.77314204),(4371,27449,0.8445229),(4372,4854,0.51235837),(4372,13888,0.97902966),(4372,19388,0.58186924),(4372,21023,0.97830874),(4373,8387,0.91854537),(4373,16140,0.66215926),(4373,27986,0.34354353),(4374,9080,0.25679427),(4375,10168,0.7770132),(4375,21399,0.47772682),(4375,26782,0.98583037),(4375,29611,0.7394182),(4376,4853,0.85836005),(4376,10333,0.67476064),(4376,12650,0.49667865),(4376,23850,0.22686197),(4377,3712,0.25150955),(4377,5317,0.2010414),(4378,3030,0.5309288),(4378,18059,0.59930074),(4378,19615,0.55335486),(4378,28718,0.5206385),(4378,30799,0.8401979),(4378,31888,0.66378474),(4379,12292,0.48892346),(4379,14237,0.915335),(4379,15622,0.45421052),(4379,23430,0.8539842),(4379,28477,0.5293356),(4380,19305,0.15337059),(4380,20068,0.20557357),(4380,28483,0.589417),(4381,7123,0.29522076),(4381,12447,0.5020149),(4381,22749,0.66330355),(4381,27589,0.6127958),(4382,6370,0.3045829),(4382,7454,0.20766798),(4382,17546,0.68516797),(4382,31277,0.3146239),(4383,900,0.69281507),(4383,13678,6.138056e-2),(4383,16325,0.36991584),(4384,2481,0.67194253),(4384,14475,0.49716723),(4384,18813,0.5561119),(4385,8870,0.857778),(4385,20512,0.1864957),(4385,28664,0.81479466),(4385,31155,0.97650546),(4386,19073,0.9286764),(4386,28326,0.7312177),(4387,4491,0.2041151),(4387,13853,0.98798686),(4387,31687,0.12571274),(4387,32617,0.43158698),(4388,2351,0.49819097),(4388,4466,0.41188133),(4388,10363,0.75575334),(4388,17779,0.30266812),(4388,21337,0.5279513),(4388,26697,0.64482266),(4388,29490,9.979061e-2),(4389,12999,0.66829085),(4389,16722,0.7031554),(4389,23777,0.5959333),(4390,38,0.36746654),(4390,14483,2.6871303e-2),(4391,14710,0.65481555),(4391,28513,9.84392e-2),(4392,7807,0.22484303),(4392,9946,0.9504273),(4392,14886,0.27053225),(4392,15249,0.23673354),(4392,22583,0.4168063),(4392,29457,0.12513748),(4392,32765,0.37408942),(4393,4020,0.35242718),(4393,8261,0.63347113),(4393,8582,0.13163678),(4394,871,0.70803916),(4394,6666,0.62670237),(4394,19330,0.6973312),(4394,31831,3.0967915e-2),(4395,10027,0.91647434),(4395,12205,0.48409572),(4395,23174,0.57264477),(4395,32385,0.15298486),(4396,6751,0.31874347),(4396,7394,0.6091901),(4396,19079,0.8275972),(4396,28828,0.3365799),(4396,29534,0.82974446),(4397,11919,1.676791e-2),(4397,13158,2.9107293e-2),(4397,14399,0.67779297),(4397,20303,0.36910078),(4398,4658,6.088894e-2),(4398,6917,0.921584),(4398,21192,0.20411436),(4399,16911,0.9554571),(4399,18334,6.1229497e-2),(4399,23197,0.2004678),(4399,24378,0.975799),(4399,30507,0.34133053),(4399,31298,1.4361739e-2),(4399,31326,0.9323563),(4400,5121,0.18769173),(4400,8762,0.10589726),(4400,14748,0.36053783),(4400,17245,0.31448513),(4400,18640,0.38039815),(4400,28802,0.9698096),(4400,32099,0.39904281),(4401,1249,0.25764436),(4401,7721,0.17436734),(4402,1368,0.5895578),(4402,16492,0.7148148),(4402,17979,0.83669645),(4402,29097,0.3204084),(4402,31656,0.40710685),(4403,2344,0.25908744),(4403,4362,0.69581544),(4403,5417,0.32079303),(4403,6518,0.5854234),(4403,12817,0.5789645),(4403,13135,0.8057362),(4403,17291,0.5063176),(4403,21410,0.76786983),(4403,27318,4.8101578e-2),(4404,11451,0.56124616),(4404,11976,0.46503106),(4404,13197,0.9195032),(4404,26620,0.48394278),(4405,109,0.29471532),(4405,594,0.71679115),(4405,19722,0.6025868),(4405,23886,0.46254247),(4406,12005,0.34062243),(4406,25451,0.6623883),(4407,19556,0.47469446),(4407,23476,0.73953515),(4407,28124,0.9680533),(4408,10031,0.9706209),(4408,24493,0.21235758),(4409,11115,0.46824446),(4409,18707,0.576179),(4409,26286,0.60756177),(4409,29032,0.8987951),(4410,16811,0.70142645),(4410,30355,0.5088615),(4410,30722,0.6431198),(4411,7696,6.1776824e-2),(4411,8434,0.5925083),(4411,13847,0.35436854),(4412,3537,0.5159488),(4412,10071,9.722155e-2),(4412,11817,0.26355672),(4412,22286,0.24802327),(4412,31834,0.86588144),(4412,32010,0.57391924),(4413,2538,0.12444843),(4413,7854,0.24289195),(4413,12015,0.310515),(4413,12550,0.92307943),(4413,27392,0.65442544),(4413,30129,0.44622594),(4414,6339,0.9535045),(4414,10895,0.43197826),(4414,15410,0.5949077),(4414,22086,0.5097615),(4415,14983,7.73054e-2),(4416,6813,7.869647e-2),(4416,7892,0.76365113),(4416,10406,0.12418684),(4416,13147,0.43189386),(4416,22596,0.5625069),(4416,23371,0.18410787),(4416,24988,5.6560297e-2),(4416,32379,0.92398435),(4417,8614,0.5191767),(4417,10135,0.96396923),(4417,31223,0.5532505),(4418,7804,0.13309984),(4418,20513,0.4611561),(4419,5481,0.90434533),(4419,24344,0.395161),(4419,29764,0.5501871),(4420,2684,0.14426628),(4420,7820,0.39415678),(4420,15123,0.32038248),(4421,12768,0.24692307),(4421,24467,0.3336696),(4422,7322,0.7746458),(4422,15935,0.78048944),(4422,31059,0.9054595),(4423,1707,0.8836712),(4423,8339,0.1424467),(4423,12155,0.7708527),(4423,13355,0.59035736),(4423,17405,0.20900385),(4423,18496,0.29593793),(4423,24003,0.8984798),(4424,1142,0.5245907),(4424,12976,0.1893946),(4424,24701,0.6359465),(4424,28942,0.36066735),(4424,30731,0.16982777),(4425,4931,0.9991349),(4425,9427,0.3386917),(4425,25511,8.1143916e-2),(4426,15631,0.30521476),(4426,20478,0.9635232),(4426,32277,5.6461435e-2),(4427,1770,0.76599),(4427,3491,0.49644354),(4427,10837,0.5094274),(4427,19494,0.6872531),(4427,27361,0.26625845),(4427,30855,0.8648029),(4429,498,0.6535521),(4429,12745,0.89736795),(4429,15244,0.17962061),(4429,22520,0.28661358),(4429,27344,0.55639476),(4430,10913,0.94805425),(4430,13678,0.7493668),(4430,16839,0.11458549),(4430,23188,0.9187455),(4431,2578,0.36573315),(4431,19892,0.92294914),(4432,632,0.5557991),(4432,1229,0.29079637),(4432,1818,0.55439836),(4432,1976,0.7722596),(4432,3318,0.27534357),(4432,3474,0.5127891),(4433,1491,0.35717165),(4433,14828,0.25987425),(4433,26196,0.81557775),(4433,27645,0.46325076),(4434,2235,0.304617),(4434,4826,8.0434315e-2),(4435,19491,0.4731668),(4435,22912,0.44337687),(4435,24471,0.56041867),(4435,29212,0.5286237),(4436,993,6.9969244e-2),(4436,11534,0.412452),(4436,22778,0.6127595),(4436,25343,0.39424944),(4437,22653,0.8042912),(4437,30161,2.6004802e-2),(4438,1982,1.8026889e-3),(4438,29381,0.7545734),(4439,8261,0.8439885),(4439,10304,0.44734633),(4439,10887,0.5274594),(4439,12403,0.14496009),(4440,1901,0.74039984),(4440,4602,1.6322732e-2),(4440,31201,0.35678583),(4440,31692,0.7311349),(4441,3742,0.5876356),(4441,12461,0.2412298),(4441,25143,0.24841204),(4442,5521,0.46051577),(4442,13706,0.6833158),(4442,20131,0.30234993),(4442,29031,0.995634),(4443,6688,0.55408865),(4443,8159,0.20602717),(4443,15815,0.75006384),(4443,15972,0.6495418),(4444,5752,0.5964894),(4444,5822,0.10185929),(4444,16608,0.54502386),(4444,23204,7.824417e-2),(4444,30411,0.40203848),(4444,30799,0.4242605),(4445,188,3.0693738e-2),(4445,12412,0.4450663),(4445,31787,0.4151899),(4446,3077,0.6474777),(4446,18936,0.33522323),(4446,22633,0.16312636),(4446,25865,0.70166993),(4446,31148,0.44042632),(4447,6005,0.29008588),(4447,14653,0.8530492),(4447,15681,0.21915936),(4447,19798,0.31349167),(4447,26545,0.4040623),(4447,29329,0.6603453),(4447,32618,0.22989778),(4448,18170,7.039663e-2),(4448,25715,0.91825217),(4449,18368,2.9325195e-2),(4449,27156,0.30039293),(4450,16538,0.80060166),(4450,21946,0.41201642),(4451,954,0.91335016),(4451,17785,0.40914688),(4451,18250,0.6280972),(4451,30912,0.3455729),(4451,32394,0.5697744),(4452,1801,0.8423962),(4452,11245,0.24385965),(4452,14152,0.37284902),(4453,2580,0.8308412),(4453,13135,0.57944316),(4453,29064,0.88288313),(4454,1952,0.5288609),(4454,20096,4.7562674e-2),(4454,21858,5.043133e-2),(4454,32729,0.9781081),(4455,2243,0.76806533),(4455,13337,7.046909e-2),(4455,14664,0.69385135),(4455,14711,0.66946083),(4455,16478,0.9292029),(4455,17780,0.53385764),(4455,18782,0.4694529),(4455,25567,0.81299835),(4456,421,0.89910674),(4456,5042,0.3100059),(4456,18429,0.6968621),(4457,4302,0.5939107),(4457,4530,0.87274116),(4457,9543,0.81611264),(4457,11627,0.2749351),(4457,19528,0.23813602),(4457,19838,0.45884418),(4457,25259,0.4314496),(4458,6356,0.40631732),(4458,6907,0.93042266),(4458,30015,0.6831354),(4458,31121,0.90377295),(4459,3096,0.8356682),(4459,12053,0.6937961),(4459,32271,0.5387292),(4460,602,0.60885644),(4460,4596,0.5440724),(4460,11205,0.9614792),(4460,15963,0.29956266),(4461,5775,0.18103606),(4461,17982,0.6684078),(4461,20018,0.23040392),(4462,17985,1.8952723e-4),(4462,22988,0.83915585),(4462,26030,0.50119907),(4462,27689,0.88905233),(4463,3166,0.9367685),(4463,5699,0.114132866),(4463,19195,0.46576545),(4463,19732,0.9041665),(4463,31533,0.39460218),(4464,13347,0.76874495),(4464,13941,0.1117087),(4464,14089,0.720794),(4465,2952,0.17874533),(4465,10260,0.9789833),(4465,16280,0.79237145),(4465,16493,0.109824404),(4465,23145,0.8552378),(4465,30912,0.23865536),(4466,4460,0.563239),(4466,6850,0.61204517),(4466,23856,0.35934436),(4466,25069,0.7891431),(4467,9615,0.1725068),(4467,13240,0.64637107),(4467,28244,0.4413541),(4468,4142,0.43352744),(4468,19150,0.38604832),(4468,25189,0.72562736),(4469,11009,0.3484706),(4469,24032,0.11137183),(4470,4706,0.51590514),(4470,11067,0.6844487),(4470,20252,0.533276),(4470,27837,0.89070237),(4470,29991,0.53840834),(4471,5330,0.735221),(4471,8495,0.28220892),(4471,10310,0.7181486),(4471,21640,0.27483886),(4471,31190,0.62018144),(4472,18131,0.9125737),(4472,19913,0.16798633),(4472,20061,0.6928472),(4472,20194,0.44664678),(4472,23452,0.27390596),(4472,23796,0.14941593),(4472,25114,0.5150763),(4472,29952,0.45946145),(4473,6203,3.6070757e-2),(4473,8108,0.3628814),(4473,12900,0.19783106),(4474,6643,0.38220012),(4474,8855,0.628562),(4474,22672,0.5334312),(4475,6892,0.9583261),(4475,13899,0.740828),(4475,28109,0.19163671),(4475,31141,0.5716407),(4475,31155,0.41868153),(4476,10780,0.75136065),(4476,14862,0.8165362),(4477,1043,0.96653205),(4477,1700,0.50591266),(4477,5659,0.83171535),(4477,8070,0.7532463),(4477,20699,0.69710964),(4478,11334,0.6669771),(4478,13254,0.116064824),(4478,23758,0.43252495),(4478,23932,0.36024806),(4478,28279,0.3366214),(4479,9237,0.7992015),(4479,23251,0.90082836),(4480,2756,0.4958907),(4481,12899,0.24678928),(4481,24126,0.6896244),(4481,24918,0.95043206),(4481,25907,0.16889842),(4482,21935,0.72438514),(4483,6340,0.5306247),(4483,14193,0.16086826),(4484,16862,9.6341796e-2),(4484,30738,0.6075273),(4485,196,0.27996445),(4485,7897,0.24125478),(4485,30016,0.2563497),(4486,878,0.96714556),(4486,4599,0.55455464),(4486,7212,0.77997273),(4486,9071,0.84575915),(4486,10332,0.86632663),(4486,17082,9.761446e-2),(4486,21775,0.13415708),(4487,5062,0.8363968),(4487,8775,0.40222204),(4487,17649,0.47762606),(4487,18952,0.4834772),(4487,23440,0.28179562),(4487,24221,2.5246548e-2),(4487,25146,0.64667284),(4488,17293,0.13796507),(4489,1910,0.66911376),(4489,11637,0.586557),(4489,18801,0.81804407),(4489,26708,0.8500184),(4489,28466,0.65806913),(4490,3515,0.79070204),(4490,15971,0.6329467),(4490,18849,0.4262686),(4490,19720,0.35238004),(4491,9745,0.14866659),(4491,16812,0.44064492),(4491,31975,0.35111308),(4492,5589,0.1024352),(4492,18602,0.75686795),(4492,24235,0.26061535),(4492,32215,0.84782726),(4493,21966,0.8515796),(4494,6824,0.6592483),(4494,12899,0.9521383),(4494,15864,8.863759e-2),(4495,1679,0.47560915),(4495,4869,0.28885877),(4495,8432,0.79971224),(4495,12171,0.32400057),(4495,29195,0.5094248),(4495,30794,0.8597022),(4495,31661,2.4481773e-2),(4496,20838,0.5343473),(4497,9436,0.9928419),(4497,18791,0.54001814),(4497,24165,0.1184926),(4497,26902,0.8030335),(4498,7494,0.8485658),(4498,22417,0.35173914),(4498,23208,0.123008475),(4499,3209,0.9463245),(4499,4002,0.8339706),(4499,9872,0.94174033),(4499,21676,0.9280369),(4499,26623,0.59379536),(4500,2853,3.077228e-2),(4500,4381,0.53678334),(4500,12721,2.4524558e-2),(4500,24012,0.6908804),(4500,26758,0.106845506),(4501,5916,0.6101282),(4501,13545,0.58172804),(4501,20993,5.3941265e-2),(4501,25220,0.88402563),(4501,29995,0.49453965),(4502,202,0.7959813),(4502,19432,6.0931034e-2),(4502,23429,0.9570709),(4502,27148,0.3789089),(4503,3869,0.84045243),(4503,16790,0.9805228),(4503,23309,0.15326415),(4503,29460,0.97453266),(4503,31786,0.23318925),(4504,19438,0.19518082),(4504,23259,0.18144393),(4504,32566,0.30663648),(4505,3114,0.13926186),(4505,3569,0.5961298),(4505,10637,0.4751383),(4505,16931,1.3354085e-3),(4505,27083,0.6394615),(4505,28364,0.26119775),(4506,7353,0.8034715),(4506,9907,0.79572666),(4506,16191,0.9088797),(4506,17754,0.49872884),(4506,27491,0.95299906),(4506,30635,0.2881181),(4507,12681,0.7736553),(4507,16876,0.17024423),(4507,26045,0.40973747),(4507,29349,0.92970246),(4508,3348,0.7258959),(4508,13238,0.9825093),(4508,15372,0.7259646),(4508,25798,0.8701184),(4509,14022,0.7489761),(4509,26527,0.40164307),(4510,10764,0.6337537),(4510,22189,0.9940702),(4510,27784,9.777479e-2),(4510,30308,0.16151048),(4511,9541,0.7175591),(4512,14983,0.7949077),(4512,19998,3.3305094e-2),(4512,26038,0.14713536),(4513,3849,0.30543306),(4513,5745,0.8654602),(4513,17271,2.622526e-2),(4513,23392,0.7332138),(4513,28329,0.97050124),(4514,7235,0.35210666),(4514,10219,0.7162489),(4514,11800,0.36959717),(4514,15168,0.6938585),(4514,17158,0.7524225),(4514,26816,0.523839),(4514,30779,0.8062748),(4515,11627,7.3194974e-3),(4515,11715,0.8269487),(4515,15163,0.8740445),(4515,23412,0.6791166),(4515,28209,0.98781395),(4516,8847,0.53777426),(4516,10585,0.13431485),(4516,26554,9.6472725e-2),(4517,4709,3.139823e-2),(4517,4923,0.95972097),(4517,18361,0.7014452),(4518,26240,6.0101267e-2),(4519,3497,0.35992244),(4519,14569,0.5549398),(4519,24531,0.92680365),(4519,27876,0.65921277),(4520,218,0.882869),(4520,1484,0.8740799),(4520,6041,2.0362282e-2),(4520,7669,0.5557054),(4520,10196,5.278208e-3),(4520,22995,0.5725224),(4521,6422,0.74494225),(4521,15234,0.20899718),(4521,16111,0.47657338),(4521,19656,0.59554046),(4522,16877,0.174461),(4523,10599,3.397958e-2),(4523,18582,0.27960384),(4523,19724,5.2059997e-2),(4524,11511,0.9485555),(4524,25671,0.3842497),(4525,17830,0.9678256),(4525,24969,0.7831498),(4526,1068,0.7175091),(4526,5877,0.17748551),(4526,17179,0.6007341),(4526,22479,0.36836755),(4526,26660,0.70465744),(4526,29540,0.91767967),(4526,32375,7.437095e-2),(4527,6368,0.41186988),(4527,7638,0.30568534),(4528,436,0.76277095),(4528,2590,0.24319988),(4528,3835,4.493963e-2),(4528,6421,4.027956e-2),(4528,10636,0.19094759),(4528,22912,0.37036163),(4529,2659,0.4586145),(4529,6562,0.25682905),(4529,9107,0.8527619),(4529,17017,0.32723227),(4529,20695,0.16038857),(4529,21803,0.12935011),(4529,32457,0.6649326),(4530,2670,0.6432664),(4530,9091,0.6973555),(4530,14289,0.58062613),(4530,19602,0.18323149),(4530,26118,0.9911631),(4530,28491,0.11894701),(4531,16813,0.31315142),(4531,24812,0.9430093),(4531,31191,0.67177993),(4532,1412,0.5694123),(4532,3662,0.6976986),(4532,13490,0.16002199),(4532,26831,0.19535716),(4532,28749,0.27333567),(4533,5759,0.90385205),(4533,7577,0.15097335),(4533,9756,0.108285226),(4533,22863,0.5715959),(4533,30930,0.98301077),(4534,845,0.25411797),(4534,8925,0.73021835),(4534,24942,0.32466534),(4534,27396,0.16429503),(4534,30368,0.7099819),(4534,31628,0.23681328),(4535,7566,0.31759185),(4535,7869,0.19127631),(4535,10252,0.3597903),(4535,17440,0.5108152),(4535,23645,0.6747058),(4536,5679,6.6221386e-2),(4536,13250,0.85622257),(4536,14775,0.91575664),(4536,24369,0.7912026),(4537,9643,0.16894975),(4537,13220,0.15339878),(4537,14459,0.6366022),(4537,31650,0.6330442),(4538,31055,0.60368323),(4539,9183,0.42643574),(4539,10539,0.8974907),(4539,11176,0.7514668),(4539,16163,0.3661716),(4539,16937,0.493714),(4539,20898,0.14143254),(4539,25767,0.12804057),(4539,26584,0.9898296),(4540,4869,0.15881623),(4540,6168,8.123681e-2),(4540,7651,0.5496822),(4540,10806,0.95753276),(4540,18247,0.61639625),(4540,24116,7.615837e-2),(4540,28667,0.28574684),(4541,6211,0.6645603),(4541,12269,0.5191365),(4541,25265,0.8360639),(4542,26121,0.50982034),(4543,1581,7.804357e-4),(4543,3730,0.53684366),(4543,3891,0.33246708),(4543,29899,0.33403996),(4544,3917,0.6806752),(4544,9901,3.4894306e-2),(4544,28014,0.26256594),(4545,265,8.406995e-2),(4545,17208,5.010948e-2),(4545,27900,0.4875682),(4546,2058,0.8448088),(4546,21503,0.86420786),(4546,22153,0.9543411),(4546,24869,0.24205504),(4546,31168,0.11391402),(4547,6219,0.3758396),(4547,9745,0.16959281),(4547,17272,0.23068707),(4547,18534,0.7960754),(4547,24729,0.7161646),(4548,2955,0.5842515),(4548,12060,0.7875517),(4548,15073,0.8513599),(4548,27598,0.7565259),(4549,5977,0.4801258),(4549,8434,0.36528447),(4549,26167,0.9069286),(4549,27885,0.42343828),(4550,1122,0.96375644),(4550,4201,0.95491236),(4550,5578,0.38266245),(4550,7435,0.26800582),(4550,12201,9.269846e-2),(4550,31185,0.80115217),(4551,4060,0.6307312),(4551,25127,0.6912337),(4552,839,0.23154083),(4552,6978,0.40385735),(4552,8170,0.35700828),(4552,16589,0.9643372),(4552,19440,0.36063606),(4552,19662,1.2947164e-2),(4552,27100,0.1544109),(4552,27529,6.1175704e-2),(4552,31162,5.070893e-2),(4552,32756,0.15994196),(4553,11965,0.993809),(4553,16371,0.47966853),(4554,7201,0.25060242),(4554,13819,0.80088705),(4554,28861,0.78572047),(4554,29091,0.24732096),(4555,8256,0.43643537),(4555,10774,0.97653836),(4555,18803,0.77579147),(4555,19582,0.38846388),(4555,24589,0.6202506),(4555,29509,0.49561375),(4555,29948,0.8725584),(4555,30510,0.3587276),(4555,31794,0.32115242),(4556,8539,0.23080698),(4556,12142,2.7899493e-2),(4556,14097,9.216488e-2),(4556,16782,0.63637227),(4556,26949,0.734269),(4557,16788,0.7770842),(4557,24607,0.56514907),(4557,29784,0.8862948),(4557,30817,0.10315803),(4558,637,0.4232226),(4558,10015,0.17308526),(4558,11043,0.5351373),(4558,16241,0.5808371),(4559,14778,3.244535e-2),(4559,22665,0.32491803),(4559,28325,0.55557233),(4559,28572,0.5385165),(4559,29602,0.38313526),(4560,11653,0.7293809),(4560,14727,0.3006264),(4560,31464,0.7817428),(4561,650,0.6486648),(4561,6249,0.18661967),(4561,8851,0.3366146),(4561,25960,0.26225048),(4561,29287,0.85249174),(4561,30367,0.8246719),(4562,11487,0.5198756),(4562,21557,0.24443014),(4562,24441,0.7508855),(4562,27342,0.8777757),(4563,7508,0.99364537),(4563,11232,0.47058576),(4563,12442,0.6912508),(4563,15664,0.33189982),(4563,27760,0.45688483),(4564,1269,0.7896962),(4564,10171,0.527239),(4564,13521,0.12965533),(4564,25818,7.089312e-2),(4565,10284,0.26459223),(4565,23310,0.5734496),(4566,16204,0.5622419),(4566,23136,0.35853955),(4566,31044,0.29000872),(4567,12151,0.9853583),(4567,20147,0.8437726),(4567,21543,0.1724743),(4568,4572,0.731219),(4568,5418,0.53321904),(4568,8418,0.8049737),(4568,18592,0.94837064),(4569,13492,0.8352438),(4569,23703,1.9776786e-2),(4570,2319,6.9468856e-2),(4570,14447,0.5229851),(4570,16280,0.15134248),(4570,22600,1.7288079e-3),(4570,26256,0.7527132),(4571,5854,0.8603461),(4571,22192,0.2650611),(4571,31361,0.56778604),(4572,3289,0.5441645),(4572,10211,0.44569814),(4572,10649,0.20725353),(4572,21562,0.22340989),(4573,10451,0.86295724),(4573,28153,0.3789667),(4573,32635,0.35674715),(4574,2319,0.31521612),(4574,2539,0.82627),(4574,13234,0.38065457),(4574,19225,7.438489e-2),(4574,20818,9.084322e-3),(4574,25605,0.77395505),(4574,31013,0.19004634),(4575,19256,0.8151267),(4575,21522,0.9994434),(4575,21800,0.46462342),(4575,31122,0.65990776),(4576,79,0.76186395),(4576,7020,0.7396569),(4576,16749,0.11090249),(4576,29381,0.69466877),(4577,4993,0.42579773),(4577,20235,0.31012183),(4577,25600,0.6903277),(4578,19596,0.8938906),(4578,27668,0.39132786),(4579,1764,0.5880785),(4579,7163,0.63505334),(4579,8824,0.7400529),(4579,9236,0.9123341),(4579,13054,0.37543237),(4579,20424,0.38155258),(4579,21913,0.15110227),(4580,2240,0.4786979),(4580,2856,0.35167596),(4580,5121,0.24031903),(4580,13602,0.4809355),(4580,17271,0.72949743),(4580,25479,0.18248034),(4580,28519,0.92524284),(4580,32005,0.5222231),(4581,6541,0.4623341),(4581,15031,0.40347555),(4581,28063,0.50026816),(4581,32187,0.72934765),(4582,1314,0.69273174),(4582,18741,0.8249042),(4582,22862,0.6445857),(4582,24850,0.358827),(4582,25383,0.82485294),(4583,9849,0.31331578),(4583,30075,0.7789062),(4584,15917,0.94823945),(4584,23019,0.8430081),(4584,30950,0.50269043),(4585,4186,0.80108666),(4585,6823,0.21743028),(4585,9477,0.6052139),(4585,18065,0.22475877),(4586,359,0.29723722),(4586,2641,0.2782716),(4586,10124,0.19734333),(4586,11305,0.3315401),(4586,23729,0.46581692),(4586,25422,0.74766237),(4586,29094,0.8862371),(4587,17082,0.21686359),(4588,15472,0.96169484),(4589,7750,0.4909747),(4589,12162,0.14851326),(4589,26540,0.82058996),(4589,30155,0.6573416),(4590,8400,0.6626475),(4590,8727,0.13714552),(4590,25431,0.92490196),(4590,31763,0.7028961),(4591,8071,0.7678089),(4591,11317,0.86120903),(4591,14423,0.3673921),(4591,20612,0.77985734),(4591,20772,0.8542932),(4591,29918,0.71838534),(4592,2857,0.93072784),(4592,6174,0.24542777),(4592,6974,0.8476099),(4592,22980,0.22126013),(4592,25875,0.5268158),(4593,12722,0.89684826),(4593,21875,0.5600459),(4593,23737,0.7520167),(4594,486,0.79172057),(4594,5434,0.6151797),(4594,8398,0.3016422),(4594,8491,0.90700734),(4594,13872,0.89180785),(4594,16007,0.74445486),(4594,17810,0.5182341),(4594,22183,0.35417217),(4594,26233,0.509979),(4595,6956,0.33562505),(4595,16287,0.7866947),(4595,18618,0.18585506),(4595,20131,0.15542535),(4595,27258,2.8479109e-2),(4596,16375,0.35127857),(4596,20455,0.8038049),(4597,9378,0.25604787),(4597,21115,0.20048723),(4597,29281,0.93198615),(4598,6775,0.69519204),(4598,28161,1.3918952e-2),(4598,30697,0.4968002),(4599,962,0.58735734),(4599,8289,0.75939614),(4599,11791,0.8857414),(4599,14367,0.511678),(4599,16708,0.64129114),(4599,16946,0.39403144),(4599,20140,0.66890675),(4599,21977,0.11532097),(4600,12510,0.13881998),(4600,26084,0.19683151),(4600,29392,0.5162354),(4601,1928,0.14596732),(4601,2387,0.41048425),(4601,12639,0.35934633),(4601,12868,0.46517867),(4601,14192,0.5312598),(4601,18538,0.5649813),(4601,22796,0.88912857),(4601,26271,0.68706),(4602,1648,0.6411486),(4602,22165,1.285267e-2),(4603,8385,0.64104),(4603,9095,0.62573254),(4603,12039,0.91084033),(4603,12300,0.13924637),(4603,18477,0.887467),(4603,18555,0.7554197),(4603,31063,0.5369914),(4604,7338,7.9310164e-2),(4604,11000,0.123838976),(4604,32070,0.85418695),(4605,245,0.5451754),(4605,11440,0.5401775),(4605,16195,6.0000826e-2),(4605,27243,0.2239545),(4606,3488,0.9778188),(4606,17728,0.84854305),(4606,27900,0.13739826),(4607,4035,0.6421314),(4607,4047,0.96221733),(4607,9341,0.55154485),(4607,16180,0.44235718),(4607,16728,0.9961875),(4607,26046,0.30939957),(4607,29069,0.55552477),(4608,7012,0.41476473),(4608,10041,0.46571973),(4608,10340,0.8450898),(4609,9906,0.63549936),(4609,17310,0.21273293),(4609,31363,0.6386694),(4610,1295,0.33424303),(4610,26812,0.15157378),(4610,28704,9.2688926e-2),(4611,10115,0.6779271),(4611,17368,0.8357674),(4611,19846,0.68052053),(4611,20406,0.67917156),(4611,24991,0.1864596),(4611,27980,0.8834041),(4612,695,0.10627052),(4612,13207,6.630588e-2),(4612,15356,0.52726597),(4612,25673,0.6851719),(4612,28538,0.99101585),(4613,11280,0.59256387),(4614,22691,0.8609056),(4614,31735,0.6119332),(4615,22906,0.19359924),(4615,23571,0.953494),(4616,7946,0.88949984),(4616,16228,4.715823e-2),(4617,8367,0.88114727),(4617,15028,0.37367338),(4617,19471,0.38845834),(4618,1583,0.45678034),(4618,1789,0.727103),(4618,2741,0.86180264),(4618,5715,0.3098391),(4618,19281,1.6307946e-2),(4618,19314,2.2614716e-2),(4618,20231,0.26070976),(4618,26467,0.350878),(4618,27009,0.15291035),(4619,21477,0.14222912),(4619,21531,0.8952621),(4619,23865,0.47651193),(4619,24782,0.790302),(4620,10190,0.6620372),(4620,12293,0.6844516),(4620,16359,0.8397421),(4621,19894,0.14109685),(4621,27453,0.31375152),(4622,1521,0.39083722),(4622,3556,0.8043143),(4622,7949,0.97487116),(4622,10618,0.3634135),(4622,12893,0.7561929),(4622,17009,8.169274e-2),(4622,18528,0.9713921),(4622,18753,2.2771308e-2),(4622,21424,0.5368388),(4623,461,0.17469613),(4623,16423,0.356722),(4624,16583,0.9867199),(4624,20722,0.10482042),(4624,20868,0.5942326),(4624,24519,0.11269824),(4625,6538,0.83856755),(4625,8342,0.9452838),(4625,11425,0.28119782),(4625,13615,0.11774656),(4625,16888,0.16916445),(4625,24515,0.21928936),(4625,30713,0.211798),(4626,15147,0.6891136),(4626,16985,0.371498),(4626,28076,0.120651074),(4627,8224,0.8278039),(4627,21534,0.46374872),(4627,28391,4.1354008e-2),(4628,15480,0.6323462),(4628,16307,0.42024174),(4629,780,0.55516136),(4629,11699,0.21341054),(4630,3708,0.46979225),(4630,19823,0.32304463),(4631,3702,0.94906974),(4631,4755,0.26825333),(4631,5268,0.9231051),(4632,891,0.9621271),(4632,9706,0.90228343),(4632,18360,0.3433438),(4632,19070,0.18304648),(4632,29995,0.6447056),(4633,2991,0.21937104),(4633,3626,0.14277726),(4633,11728,0.663865),(4633,15153,0.5630425),(4634,6365,0.8454389),(4634,6623,0.30797714),(4634,8851,0.4850724),(4635,10761,0.19041994),(4635,12135,0.92575353),(4635,13742,0.4370389),(4635,14062,0.18952449),(4635,30091,0.97714055),(4635,31904,0.47704136),(4636,9849,0.24141224),(4636,12518,0.772349),(4636,18977,2.1271061e-2),(4636,22426,2.0044817e-2),(4636,27029,0.35330796),(4637,15814,0.5600283),(4637,19882,0.32995892),(4637,29464,0.3628578),(4638,2490,0.31797123),(4638,10405,0.33790743),(4638,12763,0.5666057),(4638,15571,0.481632),(4638,19594,0.2154327),(4638,19854,0.8379699),(4638,26564,0.22493543),(4638,32406,0.6880332),(4639,5897,0.31835583),(4639,20821,8.203718e-2),(4639,24194,0.617857),(4639,29914,0.35636094),(4640,38,0.21022251),(4640,11325,0.5640115),(4640,12380,0.89464366),(4640,24038,5.038928e-2),(4640,25206,0.7744725),(4641,10033,0.5144681),(4641,19490,0.6987764),(4641,25718,0.30627564),(4641,30781,0.22286943),(4642,3142,0.38945904),(4642,10481,0.89865),(4642,13547,0.7376431),(4642,21078,0.14889832),(4642,28555,0.72474575),(4642,28803,0.9618226),(4643,7912,0.6083159),(4643,20454,0.27778825),(4644,18171,6.917185e-2),(4645,15102,0.5957799),(4645,15554,0.5381997),(4645,17292,0.7831197),(4645,32112,0.66210264),(4646,3742,0.9334738),(4646,23692,0.7690451),(4646,29857,0.7367104),(4647,4887,0.8504152),(4647,13206,0.48100147),(4647,18084,0.58494),(4647,23151,7.3025346e-2),(4647,28938,0.19845685),(4647,29004,0.3972046),(4648,731,0.40319806),(4648,7173,0.114663996),(4649,16007,0.53781456),(4649,24310,0.8152036),(4649,31964,0.8137622),(4650,6062,0.24529581),(4650,6111,0.8892205),(4650,18779,0.29003167),(4650,21936,0.62836844),(4650,25129,0.8753596),(4650,31040,0.3675485),(4652,420,0.18779269),(4652,17157,0.6773217),(4652,23917,0.2446782),(4653,7749,0.7941515),(4653,12096,0.3600029),(4653,15858,0.68133926),(4653,19063,0.31926328),(4653,22127,0.539402),(4653,27279,0.5180461),(4654,11431,0.62961745),(4654,11747,0.33731353),(4654,12418,0.7705733),(4654,15490,0.6878295),(4655,2023,0.396294),(4655,2378,0.18801506),(4655,2886,0.39010274),(4655,4973,9.876709e-2),(4655,6384,0.102759525),(4655,7270,0.73529756),(4655,7799,0.1048634),(4655,18422,0.98492694),(4655,26040,0.3659324),(4655,28464,0.17924763),(4656,1885,0.42948368),(4656,17089,0.6578125),(4656,30319,0.6946885),(4656,31446,0.20313476),(4657,3246,0.19845647),(4658,6615,0.7644549),(4658,15801,0.32474545),(4659,1128,0.10392797),(4659,2913,0.7466958),(4659,32281,5.765933e-2),(4660,18786,0.7798794),(4660,32726,0.13898553),(4661,2207,0.89364874),(4661,6946,0.29212496),(4661,16456,0.92278564),(4661,18048,0.67102873),(4661,21875,0.9417374),(4661,23293,0.7887671),(4661,27300,0.28144622),(4662,7591,0.8764974),(4662,8656,0.98488015),(4662,10898,0.27717796),(4662,16251,0.34925452),(4662,19866,0.8492613),(4662,22300,0.39083424),(4662,26942,0.45916066),(4663,10961,0.9933759),(4663,27053,0.9184221),(4663,32209,0.734725),(4664,6820,3.898278e-2),(4664,19473,0.44824824),(4664,21282,0.18540521),(4664,24966,8.285663e-2),(4664,25517,0.22828856),(4664,32735,0.47977498),(4665,347,0.17691232),(4665,2296,0.5128503),(4665,11620,0.6709528),(4665,17047,0.61484367),(4665,21456,0.4382236),(4665,26212,0.11810386),(4666,2639,0.25760394),(4666,5741,0.6217047),(4666,15970,0.53655005),(4667,24921,0.7123113),(4667,29093,0.29806936),(4668,5562,0.5869709),(4668,13026,9.106246e-2),(4668,14245,0.9175376),(4668,15241,0.9887643),(4668,22738,0.9946797),(4668,23078,0.94099516),(4668,26423,0.25948954),(4669,4022,0.9135106),(4669,19692,0.7229008),(4669,21619,0.19754018),(4669,22126,0.7217367),(4669,31356,0.3144247),(4670,20889,0.9931794),(4670,21021,7.3269405e-3),(4670,24921,0.23068222),(4670,30626,3.5537854e-2),(4671,2840,0.63906854),(4671,3082,8.48272e-2),(4671,4434,0.11783841),(4671,9090,0.5122099),(4671,10535,0.5610069),(4671,22866,0.73301566),(4672,32486,0.24152309),(4673,22193,0.5518752),(4673,23843,0.83139837),(4673,27229,0.9015448),(4674,9098,0.52291167),(4674,9296,0.35706362),(4674,11242,0.5744645),(4674,13310,0.9916277),(4674,27676,0.8943822),(4674,31869,0.31965205),(4675,190,9.4598636e-2),(4675,16816,0.94343984),(4675,23744,0.51840115),(4676,10350,0.94651407),(4676,11476,0.79328895),(4676,14377,0.8496169),(4676,18816,0.5188725),(4676,26808,0.7360791),(4677,6834,0.78658444),(4677,10279,0.4099555),(4677,16806,0.60139155),(4677,22836,0.40366066),(4677,22955,0.79218674),(4677,23974,0.78520954),(4677,30874,0.68076146),(4678,14275,0.17089821),(4678,17032,3.8229583e-3),(4678,20595,0.57579803),(4679,15184,0.49038765),(4679,30955,0.74762076),(4679,32624,0.4354551),(4680,29158,0.22461638),(4681,9292,0.19432995),(4681,10903,0.38588044),(4681,11036,9.442541e-2),(4681,22445,0.2634914),(4681,24051,0.18054467),(4681,27084,2.2851257e-2),(4681,29166,0.27082345),(4681,29720,0.7719688),(4682,2995,0.4136209),(4682,7426,0.95794475),(4682,22634,0.2439967),(4682,24186,0.23692052),(4682,27563,0.27543813),(4682,30749,0.23845159),(4683,3465,0.13140261),(4683,7613,0.7508588),(4683,8975,0.20848437),(4683,31596,0.878225),(4684,15436,0.81176364),(4684,23454,0.29696956),(4685,11839,0.3730082),(4685,23579,0.50938714),(4685,29421,0.94418466),(4686,10180,0.8658552),(4686,13127,0.27931276),(4686,17160,0.19592276),(4686,25493,0.12983866),(4687,14448,0.6056399),(4688,19805,0.3264643),(4689,22639,0.9410782),(4689,23849,0.38868082),(4689,30022,0.5648137),(4690,4221,0.1594972),(4690,7022,0.67146116),(4690,20683,0.26834464),(4690,28546,0.46714732),(4690,32075,0.16705751),(4691,1142,7.463568e-2),(4691,16332,2.468336e-2),(4691,20514,1.3299205e-2),(4691,20616,0.16814783),(4691,24798,0.25953028),(4692,312,0.40684608),(4692,3486,0.70896715),(4692,6538,0.7552939),(4692,10010,5.269858e-2),(4692,14627,0.57703406),(4692,19837,0.47409454),(4692,30312,0.27003545),(4692,30730,0.78695536),(4693,6460,0.63843626),(4693,9238,0.57392174),(4693,11220,0.6689581),(4693,15922,0.2012199),(4693,19511,0.5521453),(4693,27643,0.52997446),(4694,1356,0.52641976),(4694,3305,0.23961255),(4694,10201,0.40345967),(4695,21064,0.27249265),(4695,27916,0.6044784),(4696,4583,2.8378645e-2),(4696,10225,0.8172366),(4697,681,0.8793504),(4697,1674,0.40004063),(4697,8135,0.36246416),(4697,24469,0.44866946),(4697,24573,0.18979),(4697,31270,0.9549248),(4698,1198,0.92122084),(4698,22682,0.5390295),(4698,28064,0.5756264),(4699,1992,0.9899299),(4699,5962,6.1865754e-2),(4699,15942,0.18907157),(4699,27076,9.732152e-3),(4699,30439,0.27530682),(4699,30895,0.94300824),(4700,10704,0.90059865),(4700,13897,0.8177853),(4700,27810,0.97229016),(4700,29034,0.2736833),(4701,11004,0.597669),(4701,15721,0.9929605),(4701,23769,0.68134403),(4701,25901,4.3208178e-2),(4702,7915,0.555705),(4703,3272,0.23276788),(4703,14484,0.2926602),(4703,23013,0.886954),(4703,29778,0.25176555),(4704,10432,0.535998),(4704,29005,3.405818e-2),(4704,29263,0.12554964),(4705,15018,9.009372e-3),(4705,26331,1.45540135e-2),(4705,27440,0.7009656),(4705,28374,0.44351953),(4705,28890,0.87159204),(4706,3380,0.16438471),(4706,5702,0.73768586),(4706,20103,0.22985774),(4706,28363,1.9253799e-3),(4706,30915,0.5058137),(4707,4996,0.63690937),(4707,6237,0.81775135),(4707,26587,0.7663524),(4707,29408,0.39532027),(4707,30732,0.20018898),(4708,2136,0.5324017),(4708,7699,0.5364375),(4709,12842,0.15795153),(4709,29272,3.183135e-2),(4709,31827,0.21584526),(4710,10466,0.17023025),(4710,28863,0.8978604),(4711,27549,0.7850244),(4711,28844,0.17413235),(4711,29406,0.48152947),(4712,1599,0.32730696),(4712,3489,0.11346654),(4712,7572,0.88654953),(4712,20929,0.30971593),(4712,27009,0.2877129),(4713,24114,0.80218077),(4713,25237,0.25325066),(4713,27667,0.6744408),(4713,32115,0.675735),(4714,2278,0.22079992),(4714,7550,0.12874027),(4714,19707,0.70765567),(4714,27689,0.43108043),(4714,28920,0.9691197),(4715,2770,0.71974415),(4715,10466,8.255493e-2),(4715,31902,0.28125525),(4716,24029,0.40502867),(4716,27578,0.79107785),(4716,30241,0.6268539),(4717,5325,0.89963484),(4717,10397,0.6659394),(4718,785,0.9704364),(4718,6354,0.50986314),(4718,11003,0.2155826),(4718,15871,0.7722032),(4718,18030,0.16525917),(4718,22495,0.14496778),(4718,26911,0.3291115),(4718,29514,0.39486393),(4718,32729,0.69164884),(4719,650,0.4453243),(4719,17186,0.29207557),(4720,2242,0.87923986),(4721,10648,7.0954524e-2),(4721,14755,0.5342518),(4721,30621,0.92490155),(4722,2605,0.18420976),(4722,22255,0.5468377),(4722,24466,0.37001294),(4722,32716,0.41498953),(4723,564,0.40491718),(4723,3571,0.69173986),(4723,10913,4.9205538e-2),(4723,15855,0.79478854),(4723,31737,0.76777625),(4724,1326,0.7083263),(4724,14442,0.6339126),(4724,15563,0.305688),(4724,17217,0.17567226),(4725,1385,0.50297517),(4725,3553,0.6205151),(4725,8616,0.65821606),(4726,19343,0.58234555),(4726,23681,0.17630687),(4726,25199,0.4957741),(4726,28912,0.9546261),(4726,29658,0.49167502),(4728,22473,3.9061148e-2),(4728,29210,8.708139e-3),(4729,21913,0.24522234),(4729,22070,0.3913186),(4729,24951,0.47798976),(4729,30007,0.43845665),(4730,8288,0.8365794),(4730,15954,0.8661582),(4730,24877,0.2530455),(4730,26042,0.9886907),(4730,26645,0.5605635),(4731,2120,0.5603421),(4731,12845,0.1656385),(4731,27055,0.22349747),(4731,29273,8.62164e-2),(4732,1111,0.3114242),(4732,8655,0.14946689),(4732,14249,0.801784),(4732,17148,0.6411583),(4733,10714,0.9339555),(4733,12606,3.262407e-2),(4733,14629,0.39190805),(4733,27708,0.39322996),(4733,32015,0.7528277),(4734,2234,0.30486733),(4734,2513,4.226479e-2),(4734,15871,0.25011045),(4734,18228,0.4441046),(4734,21205,0.91114414),(4734,21485,0.30579352),(4734,24330,0.25505525),(4734,28051,0.10797454),(4734,29616,0.14145535),(4735,246,0.24742922),(4735,2472,0.91176474),(4735,2928,0.4015432),(4735,3180,0.66101676),(4735,6854,0.83086324),(4735,12491,0.33892462),(4735,16423,0.5296395),(4736,988,7.4137904e-2),(4736,7822,0.8661983),(4736,20983,4.6082623e-2),(4736,21312,0.15483873),(4736,28345,0.108621255),(4737,4674,0.20375548),(4737,6823,0.59301054),(4737,19006,0.80499935),(4737,20626,0.1835319),(4738,7746,0.5862184),(4738,11395,0.20950921),(4738,32362,0.40850955),(4738,32699,0.6872171),(4739,5056,5.7395995e-2),(4739,13804,0.13099684),(4739,19947,0.5532866),(4739,32128,0.39021298),(4740,18472,0.8554075),(4741,6004,0.39171502),(4741,21131,0.94759417),(4741,21648,0.44200414),(4742,1907,0.63774717),(4742,4249,0.25716972),(4742,6401,0.20162939),(4742,6809,0.67618734),(4742,17828,0.5528094),(4742,19294,0.72532755),(4742,26115,0.10666135),(4742,30074,0.5346037),(4743,14702,0.5506026),(4743,21893,0.3535135),(4743,22366,0.9522844),(4743,25363,0.61782396),(4744,7656,0.57427484),(4744,24092,0.9583077),(4744,24933,6.416143e-2),(4744,26276,0.4770865),(4744,31084,0.402722),(4745,12967,0.45988286),(4745,15050,0.75809014),(4745,25682,0.37325278),(4745,27132,8.1950426e-2),(4746,231,0.48099262),(4746,911,0.8279261),(4746,7584,0.34132963),(4746,13894,0.4514392),(4747,11986,0.18685031),(4747,12192,0.29171562),(4747,14069,0.5833869),(4747,14698,0.5010667),(4747,20761,0.7064364),(4747,32465,0.50829786),(4748,264,0.3538806),(4748,6446,0.15474182),(4748,15057,0.94745),(4748,17226,0.66251487),(4749,20405,0.43110967),(4749,21575,0.41848525),(4750,6561,0.3097356),(4750,8433,0.5316784),(4750,21487,0.9841534),(4750,27719,0.24511401),(4750,31401,0.6969384),(4751,13586,0.66764766),(4751,16338,0.9448333),(4752,3713,5.753134e-3),(4752,15692,1.4941065e-2),(4752,16457,0.795415),(4752,16763,0.24414791),(4752,31211,0.59711975),(4753,4823,0.98469496),(4753,12879,0.858989),(4753,14797,0.3076486),(4753,20208,0.24315317),(4753,31105,0.8423085),(4754,378,0.5607183),(4754,14103,0.64687485),(4754,18344,0.876655),(4755,3066,0.34620866),(4755,3612,0.37214297),(4755,8542,0.3489328),(4755,16994,0.9322345),(4755,17141,0.8034544),(4756,1091,0.124970414),(4756,5684,7.068936e-2),(4756,19441,0.14063515),(4757,1831,0.9670972),(4757,6946,1.4374302e-2),(4757,12051,0.48721054),(4757,14000,0.9317556),(4757,25334,0.47516334),(4757,26027,0.7541869),(4758,185,0.20611005),(4758,7774,0.6742667),(4758,13270,0.1587087),(4759,2812,0.29995278),(4759,20447,0.86542404),(4760,12172,0.13196835),(4760,13324,0.74794185),(4760,18459,0.24488969),(4761,3466,0.24070041),(4761,8289,0.53135586),(4761,27539,0.5904807),(4761,27833,0.25742808),(4762,2451,0.53008753),(4762,3150,0.191733),(4762,9656,0.7915995),(4762,14974,0.99115777),(4762,31022,0.36601552),(4764,4679,0.3119478),(4764,13045,4.6934288e-2),(4764,23469,0.4499775),(4765,12586,0.2187006),(4765,24561,0.50526094),(4766,2391,0.12765367),(4766,17090,0.31510746),(4766,18034,8.340613e-2),(4766,27243,0.77838296),(4767,772,0.57577145),(4767,5034,0.7875855),(4767,22000,0.90162444),(4767,23235,7.4219294e-2),(4767,24987,0.71592045),(4768,2499,0.5315929),(4768,3681,0.17450811),(4768,4184,0.45959684),(4768,10922,0.66874266),(4768,14008,0.9452775),(4768,18488,0.84368795),(4768,25947,0.49568367),(4768,28230,0.7175015),(4769,23901,0.38294512),(4769,23991,0.755144),(4769,26809,0.9593475),(4770,4808,0.74921703),(4770,26888,8.506779e-3),(4771,203,0.60647),(4771,7859,0.53929114),(4771,9805,0.9186079),(4771,12339,0.7515377),(4771,12698,0.59817946),(4771,16644,0.3864226),(4771,24470,1.5842862e-3),(4772,438,0.2933105),(4772,4938,0.82426775),(4772,20964,0.25100756),(4772,31984,0.93694377),(4773,16257,0.99766725),(4774,2168,0.7421925),(4774,13629,0.9176101),(4774,18806,0.60445815),(4774,28558,0.10980876),(4775,11921,0.96253705),(4775,13175,0.4124529),(4775,19573,0.98791856),(4775,21076,0.5978263),(4775,28480,0.95985746),(4776,568,0.9001847),(4776,1260,0.5941978),(4776,25872,0.26776484),(4776,32314,0.4993174),(4777,7273,0.5524689),(4777,16638,0.6301946),(4777,32554,7.83245e-2),(4778,977,4.2141724e-2),(4778,2221,0.9763559),(4778,2348,0.75923985),(4778,6625,0.12733325),(4778,7722,0.8580846),(4778,12775,0.34429),(4778,21054,0.24236207),(4779,421,0.49556097),(4779,14097,0.17386538),(4779,16997,0.7701968),(4779,17532,0.6920534),(4779,23897,0.34696662),(4779,30165,0.7114949),(4780,3435,0.1570984),(4780,9135,1.2443506e-2),(4780,25746,0.5692779),(4780,29350,0.9681055),(4781,509,0.84857786),(4781,10755,0.46994358),(4781,24621,0.99764425),(4782,6655,0.5060582),(4782,18877,0.5678372),(4782,18980,0.13706486),(4783,18330,0.9679789),(4783,28568,0.14765616),(4783,30733,0.4634591),(4784,12433,0.49723622),(4784,28087,0.8817883),(4784,30242,0.14515871),(4784,30782,0.1264002),(4785,5592,4.845176e-2),(4785,14702,0.87812734),(4785,15233,0.7948985),(4786,6089,0.4841295),(4786,7244,0.82673264),(4786,10635,0.798967),(4786,11180,0.820333),(4786,13491,0.6007989),(4787,19275,0.14891973),(4788,13308,0.41778842),(4788,17590,0.15424182),(4789,10988,0.6617287),(4789,14510,0.25835282),(4789,15475,0.6700614),(4789,21648,0.13277236),(4789,27543,0.59716195),(4789,29511,0.48572922),(4790,1886,0.11688917),(4790,5988,0.8655136),(4790,10309,0.38484797),(4790,15348,0.2903227),(4790,15495,0.20640291),(4790,32496,0.9097401),(4791,5923,0.27135113),(4791,17889,0.6351454),(4791,26056,2.7868869e-2),(4792,463,0.3296759),(4792,3175,0.32046968),(4792,3450,0.77432054),(4792,18315,0.5492973),(4793,4449,0.26881403),(4794,1073,0.89466375),(4794,25197,0.528008),(4795,1005,0.18778758),(4795,2722,0.4982626),(4795,4760,0.38101572),(4795,7144,0.6060578),(4795,20805,5.6936186e-2),(4796,950,0.9908462),(4796,6665,0.61414754),(4796,8825,0.16107689),(4796,27956,0.992526),(4796,28031,0.6932788),(4797,4505,3.3371534e-2),(4797,7331,0.92380494),(4797,23207,0.5453234),(4797,24029,8.567543e-2),(4797,25525,0.2565476),(4798,2155,0.869905),(4798,3277,0.24242774),(4798,25574,0.7041706),(4798,27447,0.10906134),(4798,30615,0.6252647),(4799,6755,0.62275285),(4800,24,0.24709356),(4800,3573,0.5364791),(4800,8446,0.5257856),(4800,11837,0.9218427),(4800,17543,0.3609645),(4801,19897,0.6558185),(4802,6232,0.33362934),(4802,29019,0.220837),(4803,1869,0.7098121),(4803,13735,6.9020346e-2),(4803,14265,0.7150041),(4803,24353,0.7316461),(4803,27167,0.4148461),(4803,29634,0.88270575),(4804,9876,0.42723143),(4805,3663,0.15100072),(4805,8784,0.38414404),(4805,23273,0.23344463),(4805,30223,0.14144315),(4805,31108,0.24993885),(4805,31121,0.98571146),(4806,187,0.57211965),(4806,13824,0.24933444),(4806,30012,0.19942549),(4806,31385,0.98419887),(4807,30783,0.720764),(4808,2833,0.7498305),(4808,3621,0.91371256),(4808,10714,0.86759084),(4808,14517,0.6956445),(4808,29768,0.27820438),(4809,1474,0.9012462),(4809,5386,8.961802e-3),(4809,16611,0.7077917),(4809,18155,0.31878966),(4809,24914,8.383636e-2),(4810,9390,0.73789966),(4810,18795,0.7184214),(4810,21920,0.23188967),(4811,21455,3.4774162e-3),(4811,25645,0.233501),(4812,5725,0.7815366),(4812,6691,0.9860659),(4812,17528,0.46547815),(4812,18431,0.69667774),(4812,27697,0.79916865),(4813,8289,0.50258565),(4813,11763,0.68002325),(4813,19958,0.7717348),(4813,19967,0.32394063),(4813,24391,0.4200137),(4814,1906,0.511833),(4814,3218,4.3943595e-2),(4814,15448,0.48400077),(4814,19179,5.155976e-2),(4814,25229,0.38297918),(4814,25272,0.4097058),(4815,5626,0.79543126),(4815,24279,0.90995836),(4816,3718,0.7694968),(4816,22032,0.64986867),(4817,3747,6.2097933e-2),(4817,4330,0.5860882),(4817,9987,0.92499804),(4817,11850,0.55044085),(4817,14553,0.35018197),(4817,17122,0.78522384),(4817,28322,3.053463e-2),(4817,32328,0.59467256),(4818,9814,0.6700978),(4819,12498,0.27890044),(4820,28518,0.9864108),(4821,3121,0.31521958),(4821,5966,0.70623255),(4821,23939,0.85456747),(4821,29600,0.74628323),(4822,4734,0.5714452),(4822,12789,0.15728149),(4822,27149,5.4093987e-2),(4823,6829,0.62575513),(4823,7936,0.8389211),(4823,9723,0.79355973),(4823,20779,0.50860965),(4824,12382,0.8172086),(4824,14502,0.40833715),(4824,23676,0.44522694),(4824,29012,0.24893351),(4825,6346,0.44104126),(4825,23923,0.2889255),(4826,11035,0.9771865),(4826,14948,0.21512136),(4826,17495,0.30202413),(4826,19179,0.4289945),(4826,28960,0.5397341),(4827,10067,6.71783e-2),(4827,11531,0.57781523),(4827,23518,0.8449751),(4828,1246,0.8597558),(4828,3519,0.8728315),(4828,15238,0.4436808),(4828,23175,0.9682704),(4828,23462,0.71697164),(4828,24636,0.93113095),(4829,10092,0.16652997),(4829,13813,0.4732956),(4829,16841,0.4439263),(4830,1824,0.88463295),(4830,9593,0.37746194),(4830,22495,0.29893363),(4831,697,0.36513686),(4831,21091,0.9696883),(4832,12361,0.72552884),(4832,16261,0.71766216),(4832,26577,0.68323725),(4833,13221,0.19878396),(4834,12293,0.32542625),(4834,14871,1.37607e-2),(4834,17243,0.27407646),(4834,19890,0.17489766),(4835,934,0.13017328),(4835,2443,0.29301566),(4835,2761,0.7447624),(4835,13646,0.9312705),(4835,17717,0.6249059),(4835,21662,7.38321e-2),(4835,24066,0.49883598),(4836,14901,0.76098895),(4837,5390,0.7962163),(4837,7436,0.28740937),(4837,10517,0.1293828),(4837,10770,0.78031784),(4837,14902,2.1581864e-2),(4837,19209,0.22139911),(4838,4065,1.3617083e-3),(4838,4573,0.47059187),(4838,7933,0.9816975),(4838,9513,9.6603885e-2),(4838,10069,0.57140917),(4838,22208,0.16893418),(4838,28897,0.78109133),(4839,1728,0.45091128),(4839,10607,2.388103e-2),(4839,13451,0.5513995),(4839,26652,0.834105),(4840,2675,0.10415139),(4840,13549,0.26452175),(4840,16201,0.47348765),(4840,16598,0.93536234),(4840,21754,4.3441104e-3),(4840,25374,0.73639464),(4840,30195,0.2425032),(4841,7951,0.41048145),(4841,8671,0.94358385),(4841,23071,0.51703936),(4842,4956,0.8013561),(4842,5667,0.7077398),(4842,8863,0.44930157),(4842,11514,0.41187957),(4842,22164,0.96307945),(4842,27231,0.29336348),(4843,14434,0.650692),(4843,19981,0.7812257),(4843,23002,0.3527837),(4844,6781,0.40738046),(4844,28091,0.72148335),(4844,32098,0.70622706),(4845,11216,0.4855866),(4845,13819,0.49040258),(4845,21293,0.11836613),(4845,28347,0.9549376),(4846,1014,0.79433334),(4846,17820,0.2367675),(4846,28751,0.94141096),(4847,10166,0.32683682),(4847,18315,0.2215479),(4847,29478,2.7042588e-2),(4848,7915,0.23398134),(4848,11560,0.8703281),(4848,20778,1.0209792e-2),(4848,29779,0.56904083),(4849,2578,0.19097717),(4849,19393,0.68496275),(4849,24404,0.44137257),(4849,24964,0.837936),(4850,18220,0.51505023),(4851,4305,0.69316804),(4851,16456,0.20735778),(4851,26336,0.16602352),(4852,3565,0.95470524),(4852,8968,0.25021806),(4852,22664,0.288323),(4853,2542,0.5527313),(4853,12668,0.9448919),(4853,13696,0.69547594),(4853,17591,0.583943),(4854,5483,0.12187673),(4854,23353,0.7597056),(4855,3585,0.68506944),(4855,26888,0.6429856),(4855,28071,0.16610223),(4856,4149,0.6237475),(4856,4404,0.25876546),(4856,10173,0.880167),(4856,12148,0.35205224),(4856,26118,0.404316),(4857,8499,0.6942753),(4857,26518,0.4899935),(4858,15075,0.81551856),(4858,21677,0.34934497),(4858,23600,0.75062096),(4859,3225,0.33758384),(4859,8415,0.13966465),(4860,2277,9.939179e-2),(4860,6149,0.7200058),(4861,5663,0.84102225),(4861,22693,8.470886e-2),(4862,3966,0.3645962),(4862,18131,0.525962),(4862,22076,0.97804177),(4863,7654,0.41315213),(4863,16755,0.18388079),(4863,17326,0.962809),(4863,26015,0.75018406),(4863,27738,0.5573169),(4864,749,0.7170575),(4864,18870,0.9787521),(4864,24073,0.72878176),(4864,24671,0.575864),(4865,2572,0.7578491),(4865,8583,3.9377697e-2),(4865,19518,7.729796e-2),(4865,25041,0.6917273),(4865,30769,0.434015),(4865,31558,0.5266946),(4866,1723,0.3497483),(4866,32543,0.71137273),(4867,19752,0.59563744),(4867,21855,0.15005799),(4868,21412,0.47392198),(4868,32326,0.65061134),(4869,1096,0.9031195),(4869,4293,0.54610145),(4869,7291,0.20570263),(4869,23707,0.7103628),(4870,3754,0.12928393),(4870,11444,0.10794749),(4870,17599,0.3754876),(4870,22453,0.38476297),(4870,25994,0.38574487),(4871,1201,0.20361437),(4871,10653,0.61331713),(4871,32508,4.868856e-2),(4872,1828,0.25931463),(4872,7736,0.41640934),(4872,8988,0.40990317),(4872,16371,0.7731791),(4872,27841,0.51646274),(4873,23230,0.1522363),(4874,15031,0.5068579),(4874,17217,0.24645768),(4874,21341,4.7438398e-2),(4874,32523,0.7242646),(4875,5197,0.89741063),(4875,30395,0.90474373),(4875,31076,0.8042937),(4876,13065,5.4813724e-2),(4876,15876,0.14981636),(4876,16016,0.5455786),(4876,19180,0.104174405),(4876,23255,8.6635515e-2),(4877,6224,0.6182515),(4877,9215,1.6409967e-2),(4877,10881,0.21646306),(4877,18399,0.7700684),(4878,11726,0.47955123),(4878,12511,0.5297756),(4879,129,0.5368145),(4879,15484,0.54577166),(4879,16665,0.24496986),(4880,859,0.48572558),(4880,14700,0.86115843),(4880,18079,0.11979329),(4880,27372,0.27020705),(4880,29981,0.68063027),(4880,31005,0.82623243),(4881,5270,0.107504345),(4881,9574,0.693913),(4881,27398,0.1705007),(4881,28783,0.358219),(4882,1037,0.918858),(4882,4362,0.15907478),(4883,13214,0.96512336),(4884,5014,1.1870355e-2),(4884,11993,0.14447744),(4884,17505,0.50467694),(4884,23838,2.8699556e-2),(4884,27444,0.28645104),(4885,2916,0.34045598),(4885,9914,0.23958036),(4885,14660,0.49046013),(4885,14741,0.19576149),(4885,15468,0.21908124),(4885,15483,0.20239882),(4885,18455,0.20538391),(4885,25263,0.18516764),(4885,31261,0.5118149),(4886,8788,0.38156965),(4886,16747,0.8663433),(4886,24939,4.157593e-3),(4887,5726,0.6873619),(4887,7540,0.71035045),(4887,12430,0.47688317),(4887,13923,0.92256755),(4887,23604,0.27239886),(4887,32208,0.45520046),(4887,32222,0.9916133),(4888,959,0.86965406),(4888,12339,0.87433237),(4888,13810,0.24528563),(4888,16664,3.685152e-2),(4888,22132,8.717515e-2),(4888,23967,0.37973562),(4888,26983,0.16237535),(4888,28654,0.41290078),(4889,12059,0.47518712),(4889,20948,0.72228444),(4890,9949,0.4646731),(4890,10587,9.325699e-2),(4890,17856,1.5006522e-2),(4891,9010,0.619778),(4891,13467,0.5391506),(4891,17920,0.34036726),(4891,28168,0.73498917),(4892,4405,0.110112704),(4892,9921,2.2510754e-2),(4892,15489,0.397674),(4892,19316,0.22851773),(4892,31935,0.67708933),(4893,7693,0.13086744),(4894,23260,0.23943369),(4894,27055,0.3063584),(4895,11053,6.975938e-2),(4895,23165,0.5893174),(4895,25629,0.31323034),(4896,3725,0.8444551),(4896,8497,0.24364431),(4896,10529,0.7777899),(4896,19746,0.410565),(4896,26652,0.71693194),(4898,4770,0.58150715),(4898,5080,0.17582554),(4898,5265,0.45259437),(4898,5490,0.9152859),(4898,14085,0.6552044),(4898,20973,0.74986637),(4899,699,0.46792144),(4899,15542,0.79170835),(4899,23382,0.8706153),(4899,29503,0.20466642),(4900,9607,0.913783),(4900,16994,0.40613306),(4900,30922,0.88318276),(4900,32041,0.62022865),(4901,16824,0.58246166),(4901,20728,0.74899954),(4901,25982,0.28841838),(4902,6502,0.55310404),(4902,22669,0.32248554),(4902,28332,0.41808116),(4903,454,0.60216933),(4903,6354,0.9215792),(4904,3841,3.4351196e-2),(4904,31669,6.359881e-2),(4905,132,0.95724297),(4905,3340,0.9073392),(4905,9718,6.4683385e-2),(4905,17238,0.4904526),(4905,19621,0.66051286),(4905,32508,0.3399583),(4906,1374,0.8201727),(4907,10064,0.4823783),(4907,14210,0.46529862),(4907,15570,3.6036775e-2),(4907,17984,0.30189934),(4907,18412,0.576332),(4907,23627,0.38172612),(4907,24163,0.2837357),(4907,28994,0.6260762),(4908,6592,0.83523893),(4908,10544,0.5225995),(4909,3496,0.106795676),(4909,17385,0.625453),(4909,19192,0.2349268),(4909,23920,0.9399575),(4909,25823,0.6276523),(4910,7152,0.15797782),(4910,15586,0.8532444),(4910,20510,0.84640384),(4911,21986,0.17092562),(4911,28832,0.93349427),(4911,32508,0.80503523),(4912,3961,0.7130787),(4912,4642,0.17602636),(4912,7519,0.7091838),(4912,11105,4.2715184e-2),(4912,28244,5.1264804e-2),(4912,28342,0.8870064),(4913,4744,0.6631862),(4913,10024,0.5357821),(4913,25205,0.55855703),(4913,32182,0.27208686),(4914,8249,0.40059444),(4914,12213,0.6991818),(4914,23698,5.0157394e-2),(4914,28136,0.13423933),(4915,9524,0.91543055),(4915,12258,0.8790987),(4915,12414,0.2528384),(4915,14212,0.22787389),(4916,5887,0.8242555),(4916,8811,0.13301618),(4916,11281,2.4703875e-2),(4916,11429,0.9883744),(4916,22301,0.75148904),(4916,26223,0.7051296),(4917,2649,0.9813506),(4917,25458,0.71245587),(4917,27907,0.7336509),(4918,13515,0.5046121),(4918,25638,0.86240244),(4918,29310,0.6393198),(4918,30026,0.4419099),(4919,16807,0.41376993),(4919,20452,0.2717458),(4919,26882,0.1780816),(4920,2032,0.2554612),(4920,2983,0.41204432),(4920,17246,0.54964036),(4920,29537,0.9584751),(4920,30440,0.5460294),(4921,2645,0.8188077),(4921,5093,0.3917609),(4921,20764,0.19590132),(4921,21834,0.40531516),(4921,23790,0.30938298),(4922,14309,0.90574414),(4922,16781,0.8778202),(4922,22417,0.8395214),(4922,25191,0.29652014),(4922,32144,0.5399351),(4923,5130,0.6526735),(4923,5140,0.35297805),(4923,6890,0.13266346),(4923,17529,3.5373036e-2),(4924,7388,4.0692177e-2),(4924,10899,0.55793965),(4924,23002,0.23825546),(4924,25699,0.8705297),(4924,25972,0.41245228),(4924,28959,0.6739159),(4925,4490,0.89121306),(4925,8229,0.73359746),(4925,16445,0.928621),(4925,21431,0.9269729),(4925,32076,0.22994952),(4926,7625,5.5390887e-2),(4926,15677,0.41406557),(4926,24140,0.8644361),(4928,20008,0.16634618),(4928,30112,0.85641617),(4929,11734,0.6290779),(4929,11868,0.5521272),(4929,18293,0.9982368),(4929,21647,0.69705284),(4929,23286,0.39329925),(4930,6885,0.6164642),(4930,9589,0.6666918),(4930,31437,0.2765702),(4930,32262,1.872465e-2),(4931,3419,0.3346217),(4931,14240,0.96197283),(4931,21946,0.62303984),(4932,3355,0.74783653),(4932,21260,3.782407e-2),(4932,29360,0.449586),(4932,29884,0.6072963),(4933,27918,0.100248955),(4934,2138,4.8539884e-2),(4934,5178,0.52153015),(4934,27339,5.266215e-3),(4934,29817,0.54087347),(4935,1367,0.43839458),(4935,5469,0.2299509),(4935,6239,3.0094652e-2),(4935,12844,0.4163368),(4935,19519,1.9010028e-2),(4936,1116,0.9420005),(4936,7243,0.73318714),(4936,13877,0.7886315),(4936,18966,0.18066597),(4937,16851,3.339011e-2),(4937,18452,0.8569246),(4937,29866,3.0058745e-2),(4938,2143,0.56423485),(4938,13029,0.9835332),(4939,9900,0.63914675),(4939,31220,0.54269725),(4939,31262,0.37581226),(4940,5897,0.52542704),(4940,24102,0.4447707),(4941,3991,0.55492157),(4941,15359,0.3694606),(4941,20764,0.2885951),(4941,25162,0.24330135),(4941,26321,0.52114403),(4941,27261,0.81418544),(4942,4290,0.18614978),(4942,7099,0.41884974),(4942,17076,0.578753),(4942,17865,0.44056365),(4942,19517,0.83116156),(4942,25297,0.23760524),(4942,30020,0.35238504),(4942,30083,0.2768495),(4942,30307,0.9160573),(4943,231,0.75393456),(4943,6173,0.8064286),(4943,8101,0.78244436),(4943,31055,0.634017),(4943,31626,0.4047564),(4944,788,0.14813048),(4944,12981,0.8127822),(4944,19612,0.984062),(4944,19888,0.19051126),(4945,4844,0.5901929),(4945,18527,0.78247005),(4945,19972,0.9857656),(4946,32048,0.15167671),(4947,1563,0.793174),(4947,7202,1.5736548e-2),(4947,13839,0.26387843),(4947,25653,0.8238539),(4948,9612,0.3410458),(4949,12681,0.9378213),(4949,29878,0.19816473),(4950,12787,0.17725572),(4950,16337,0.18540223),(4951,3748,0.8946627),(4951,7032,0.8189165),(4951,11662,0.87501),(4951,13386,0.6495387),(4951,17416,5.0795652e-2),(4951,18435,0.5055485),(4951,20485,0.23599227),(4952,15397,0.17719664),(4953,2669,8.134257e-2),(4953,7018,0.17214747),(4953,11973,0.8004075),(4953,26629,0.77705824),(4953,27058,0.18998693),(4953,27599,0.60546786),(4954,29527,0.46068722),(4955,10237,0.45328036),(4955,10416,0.45318297),(4955,11418,0.84647536),(4955,15378,0.29009414),(4955,16754,3.4416176e-2),(4955,28432,0.53470445),(4955,30221,0.25134775),(4956,1529,0.7194597),(4956,17848,0.75005573),(4956,22851,0.37589115),(4956,26736,5.024098e-2),(4957,6787,0.78942156),(4957,22156,0.46235934),(4957,22612,0.9572739),(4957,25038,0.5428931),(4958,7036,0.41462746),(4958,9770,0.78803176),(4958,21313,0.7732309),(4958,28066,0.15387052),(4959,3987,0.6667397),(4959,13279,0.33234462),(4959,23575,0.8429595),(4959,30955,0.798024),(4960,7231,6.364405e-2),(4960,17999,2.3771083e-2),(4960,30057,0.42510787),(4961,3806,3.890063e-2),(4961,31660,0.9491363),(4962,80,9.197685e-2),(4962,1913,0.29144853),(4962,5516,0.7288097),(4962,20002,6.848221e-2),(4963,8061,0.94705266),(4963,11009,0.28289315),(4963,21190,0.75003),(4963,24709,0.3264055),(4963,25158,0.44153664),(4964,446,0.81165266),(4964,8272,0.4554922),(4964,9733,0.5543783),(4964,10945,0.84797144),(4964,11044,0.6978638),(4965,5314,0.14318252),(4965,11728,0.35559198),(4965,31178,8.067304e-3),(4965,31751,0.9371271),(4966,475,0.50975543),(4966,4397,0.1782867),(4966,5319,0.50622773),(4966,15891,0.73879784),(4966,16277,0.21827233),(4966,16852,0.37435418),(4966,20715,0.26038),(4966,23411,5.545509e-3),(4966,25863,0.43871105),(4967,21917,0.35370675),(4968,2495,0.7046399),(4968,21990,0.49025548),(4968,24238,7.310813e-2),(4969,6564,0.492383),(4969,11675,0.68891627),(4969,14200,0.727229),(4969,17555,0.13359547),(4969,21220,0.37606204),(4969,21471,0.59356546),(4969,30764,0.12711328),(4970,12763,0.71166027),(4970,27556,0.9548517),(4971,2553,0.66985965),(4971,4383,0.10892376),(4971,20685,0.87740946),(4971,22942,0.32786736),(4971,23359,0.41229436),(4971,25929,0.20663579),(4972,23823,0.6462961),(4973,3622,0.7159154),(4973,23789,0.15543121),(4974,8700,0.5630104),(4974,18471,0.29375994),(4974,31753,0.66659975),(4976,7040,0.69365036),(4976,10086,0.89772797),(4976,23989,0.4083934),(4977,4702,0.92288554),(4977,4837,0.8425837),(4977,13065,0.34706905),(4977,19937,0.41232902),(4977,31363,0.76330787),(4978,5693,0.6970825),(4978,7653,0.7045523),(4978,9168,0.348297),(4978,10872,0.36843133),(4978,28390,0.6507331),(4979,1233,0.3926555),(4979,3814,0.55048937),(4979,13955,0.6386896),(4979,18068,0.785329),(4981,21870,0.25734332),(4981,23265,0.99832726),(4981,26696,0.47616833),(4981,28328,0.2902769),(4981,28665,0.25710416),(4982,4544,0.97440034),(4982,7283,0.59745604),(4982,10065,0.72272253),(4982,11690,0.18775272),(4982,19160,0.20088232),(4982,21798,0.40538314),(4982,26755,0.7604481),(4983,6543,7.353375e-2),(4983,7765,0.8711623),(4983,9027,0.6296367),(4983,12642,0.8167646),(4983,13559,0.36753833),(4983,21501,0.6513556),(4983,22341,0.22275275),(4983,27875,0.84962493),(4984,9909,0.6276298),(4984,17925,4.22111e-3),(4984,20832,0.86838156),(4984,24508,0.42332208),(4985,1367,0.68604565),(4985,5786,0.78089523),(4985,20802,0.66782075),(4986,11913,0.46739632),(4986,18259,0.6162203),(4986,32767,6.1388135e-2),(4988,14057,0.81338346),(4988,20746,0.8568818),(4988,22852,0.2021281),(4988,26653,0.35622847),(4988,31306,3.359401e-2),(4988,32436,0.84092736),(4989,553,0.88473576),(4989,6071,0.4722888),(4989,6525,0.47270742),(4989,17598,0.47160122),(4989,23636,0.9360406),(4989,26876,0.11383208),(4990,14768,0.23742585),(4990,15562,0.2936317),(4990,32076,0.20330448),(4991,22364,0.26892343),(4991,24301,0.8787449),(4991,27145,0.786135),(4991,29571,0.6895343),(4992,2262,0.6487767),(4992,2817,0.89537084),(4992,10089,1.634672e-2),(4992,20314,0.37586135),(4992,28993,0.3334008),(4993,4808,0.65089685),(4993,12100,2.5091425e-3),(4993,26418,0.65453154),(4993,29208,0.7945173),(4994,10772,0.4983429),(4994,13670,0.34913796),(4994,22712,0.55044484),(4994,23902,0.96232396),(4995,11063,0.51662254),(4995,26930,0.5485195),(4996,3419,0.7484501),(4996,11124,0.9134862),(4996,15166,0.4522793),(4996,22316,0.32069853),(4996,32298,0.67219794),(4997,5372,0.18453431),(4998,3985,0.24243765),(4998,14487,0.45316076),(4998,15519,0.62558466),(4998,26382,0.24450247),(4998,31249,2.7978227e-2),(4999,7946,3.12614e-2),(4999,12251,0.9201863),(4999,26399,0.6691335),(5000,469,0.6705866),(5000,4612,0.3424708),(5000,8200,0.9788292),(5000,10646,0.8819035),(5000,15754,0.23092848),(5000,21119,0.7420098),(5000,30585,0.6719814),(5001,17127,0.817839),(5001,30800,0.36352724),(5002,2455,0.13929026),(5002,6809,0.4370871),(5002,11357,0.52439815),(5002,18646,1.3874114e-2),(5002,19191,0.541196),(5002,20375,0.6151205),(5002,21128,9.399134e-2),(5003,29129,0.63513297),(5004,13444,0.6034558),(5004,28479,0.63203186),(5004,31748,0.994629),(5005,10538,0.30200145),(5005,18898,0.96283674),(5005,24956,0.89095736),(5006,8906,0.93335426),(5006,9061,0.13188761),(5006,9336,0.41971382),(5006,9698,0.9446856),(5006,30563,0.26693684),(5007,644,0.1492368),(5007,6322,0.93378437),(5007,11506,0.9058438),(5008,7556,0.23372981),(5008,13599,0.93522453),(5008,13653,0.12411264),(5009,9252,0.7121157),(5009,19118,0.33915937),(5009,19291,0.15912884),(5009,19603,0.6878669),(5009,19688,0.18665786),(5009,25445,0.8795166),(5009,31618,0.67437726),(5010,501,0.826055),(5010,9772,0.6608932),(5010,19952,0.87741166),(5011,1306,0.7992153),(5011,3107,0.43237603),(5011,5897,0.5426329),(5011,7915,0.43178692),(5011,9359,0.7229907),(5011,21211,0.72356135),(5011,29123,4.7434084e-3),(5012,556,0.26643348),(5012,5617,0.7595603),(5012,20276,0.52573854),(5013,7197,0.22707486),(5013,13174,0.50797164),(5013,25301,0.12602395),(5013,30589,0.6100053),(5014,5927,0.70583516),(5014,6273,0.83305144),(5014,6274,0.4558919),(5014,29033,0.49670762),(5014,31788,0.17485632),(5015,8332,0.35556573),(5015,29938,0.52653897),(5016,10585,0.70042986),(5017,11105,0.7259587),(5017,19458,0.33229324),(5017,19851,0.9118871),(5017,30101,0.91703075),(5018,8287,0.34945917),(5018,12858,4.9188152e-2),(5018,31171,0.3330689),(5019,1159,0.6133438),(5019,18636,0.37525114),(5019,19756,0.13614835),(5020,2676,0.78943944),(5020,8920,0.15916616),(5020,16747,7.5394236e-2),(5020,22331,3.1526675e-3),(5020,24138,0.57557964),(5020,28378,0.918518),(5020,32128,4.1724574e-3),(5021,8507,3.9750826e-2),(5021,14486,0.20213106),(5021,14879,0.10948682),(5021,14892,0.7220337),(5021,23484,0.17232564),(5022,2514,0.2562204),(5022,15359,0.3714824),(5022,17767,0.9133504),(5022,25934,0.5415296),(5022,25967,0.90241385),(5022,28437,0.8466604),(5023,6298,0.85537887),(5023,6511,0.26031995),(5023,12746,0.24143735),(5023,30426,0.95420957),(5023,30921,0.20481361),(5024,4907,0.94097453),(5024,13179,0.90215397),(5024,13778,0.25099528),(5024,21600,3.7971154e-2),(5024,27747,0.4210289),(5025,369,0.38573432),(5025,6137,0.9632956),(5025,11229,0.692689),(5025,19705,0.41416508),(5025,25115,0.32954955),(5026,7094,0.9408156),(5026,23008,0.39951184),(5026,27388,0.71733236),(5027,12866,0.45073208),(5027,29171,0.45285842),(5027,32302,0.95049965),(5028,1087,0.90475047),(5028,10861,0.9006596),(5029,14100,0.14062668),(5029,21233,4.509005e-2),(5029,26239,0.30361187),(5030,3022,0.5709146),(5030,19337,0.9675084),(5030,28368,0.15059392),(5030,31439,0.13562268),(5031,2675,7.1966566e-2),(5031,19086,0.6040312),(5031,22265,0.5570432),(5032,3781,0.85150033),(5032,7992,0.22958606),(5032,8874,0.23517431),(5032,11194,0.6890513),(5032,25770,0.5273853),(5032,26181,5.1762916e-2),(5033,7639,0.7269257),(5033,10620,0.45144862),(5033,17783,0.6974011),(5033,31859,0.6019878),(5034,3126,0.3836699),(5034,8349,0.5754072),(5034,13778,0.9063586),(5034,14495,0.5839171),(5034,25460,0.2515327),(5034,28110,0.7307569),(5035,15192,0.88826334),(5035,23774,0.47882488),(5036,7500,6.3564494e-2),(5036,16817,0.53152263),(5036,22558,9.345123e-2),(5036,26921,0.8841179),(5037,11831,0.30066612),(5037,14696,0.28296062),(5037,18745,0.9635088),(5037,27364,8.9759864e-2),(5037,32349,7.7505015e-2),(5038,15990,0.22001931),(5038,20352,0.55393106),(5038,24209,0.9379716),(5038,28444,0.3163415),(5039,7531,0.37063262),(5039,22383,1.4840903e-2),(5039,27336,0.83748287),(5040,7281,0.67329663),(5040,7879,9.166104e-2),(5040,9590,8.355798e-2),(5040,12992,0.21096358),(5040,17615,0.5248275),(5040,26446,9.222232e-2),(5041,9724,0.31313482),(5041,14985,0.64453715),(5041,29542,0.22069852),(5042,5305,0.8016392),(5042,7996,0.3722329),(5042,9576,0.93141925),(5042,16314,0.24490446),(5042,17825,0.43582407),(5042,23880,0.80868095),(5042,26367,0.45502192),(5043,4541,0.87621534),(5043,5746,0.9653066),(5043,19814,0.33915913),(5043,22026,0.23784886),(5043,23042,0.70044416),(5043,27505,0.15385015),(5044,2019,7.228715e-2),(5044,17930,0.54470694),(5045,25968,0.29248816),(5045,26016,0.115973696),(5045,26666,0.67404944),(5045,27167,0.11802253),(5046,716,0.9888252),(5046,14081,3.549077e-2),(5046,25632,0.47242498),(5046,25844,0.24574356),(5046,25927,0.4542503),(5047,7050,0.39905053),(5047,11230,8.9112796e-2),(5047,17334,0.9807613),(5047,19503,0.2022706),(5047,19622,0.9075797),(5047,23949,0.3228993),(5048,642,1.746966e-2),(5048,751,0.76835316),(5048,2573,0.4350867),(5048,3553,0.14186744),(5048,23726,0.98362476),(5049,89,0.672394),(5049,3862,0.9640741),(5049,24117,0.20751895),(5049,27842,0.98722196),(5049,30968,0.804199),(5049,31149,0.1157194),(5050,49,0.64024645),(5050,18587,0.59396565),(5050,19589,7.511557e-2),(5051,17500,0.5018369),(5051,17933,0.6039831),(5051,20992,0.12695512),(5051,21906,0.47358242),(5052,476,0.4812842),(5052,4824,0.2118799),(5052,5683,0.5275947),(5052,6490,0.21437879),(5053,8184,0.37835532),(5053,10276,0.84698683),(5053,13088,0.7160256),(5053,17398,0.55380106),(5053,17635,0.22013724),(5053,22592,0.34028003),(5053,28556,0.30300027),(5053,30774,0.10399695),(5054,16956,0.6860657),(5054,28903,0.39243814),(5055,9216,0.8788582),(5055,28227,0.12132062),(5055,31524,0.64732724),(5056,1394,0.5870966),(5056,11592,0.49815506),(5056,17856,0.18917327),(5056,19939,0.2534696),(5056,29463,0.81590456),(5056,29738,0.4117809),(5056,30189,0.741485),(5057,3907,0.26556668),(5057,9427,0.37231222),(5058,7112,0.19346398),(5058,12674,0.63971746),(5059,8913,0.29830423),(5059,9157,0.67440075),(5059,11403,0.6150482),(5059,18415,0.21519369),(5059,29800,0.67232955),(5059,30214,8.461548e-2),(5059,30693,0.46511078),(5060,10135,6.446585e-2),(5060,28489,0.102797),(5061,5657,0.69984746),(5061,9543,0.8920704),(5061,23719,0.83767235),(5062,4517,0.93758875),(5062,5701,0.34437957),(5062,6498,0.38893938),(5062,8413,0.61513674),(5062,26147,0.7617696),(5063,11925,0.17237565),(5063,24765,0.2556622),(5064,1063,0.46905774),(5065,7774,0.81519103),(5065,11479,0.32189956),(5065,21757,0.615176),(5066,89,0.895437),(5066,25914,0.40851733),(5066,28804,0.20697048),(5067,15260,0.6510098),(5067,30703,0.7186238),(5068,1193,0.46733794),(5068,9621,0.744705),(5068,21895,0.9962485),(5068,29377,0.99173874),(5068,30194,0.11989551),(5068,31773,0.44235718),(5069,3438,0.3391384),(5069,4005,0.218947),(5069,7309,0.3019725),(5069,13333,0.34540424),(5069,23069,0.34226236),(5069,29875,0.35339287),(5070,19978,0.10431146),(5070,29686,0.8317966),(5071,8775,8.490786e-3),(5071,10089,0.7178706),(5071,15079,0.32247546),(5071,23903,0.42121214),(5071,28406,0.17722471),(5071,28761,0.6030031),(5071,32452,0.60205865),(5072,3164,0.35100448),(5072,12631,0.49678436),(5072,16846,0.80295897),(5072,21417,0.290805),(5072,25945,0.7727599),(5072,29315,0.7681134),(5072,32064,0.106389284),(5073,441,0.2256001),(5073,7622,0.583848),(5073,12215,0.6895381),(5073,19894,0.62541986),(5073,27075,0.2662731),(5074,1550,0.6737266),(5074,2886,0.58937603),(5074,17545,0.66157454),(5074,19356,0.87776804),(5074,24268,6.403417e-2),(5074,27730,0.8178357),(5074,31589,0.3461767),(5075,7423,0.31156272),(5075,8259,0.9971561),(5075,22199,0.27437297),(5076,6816,0.99651766),(5076,17834,0.7818882),(5076,20702,8.8358345e-4),(5076,22348,0.37397522),(5076,29872,0.5888018),(5076,30092,0.58615273),(5077,2041,0.6570009),(5077,3815,0.971793),(5077,7854,0.6707154),(5079,14775,0.37384728),(5079,21056,1.6646232e-2),(5079,31002,0.91602546),(5079,31937,0.6234547),(5080,5699,0.863968),(5080,9281,0.49255657),(5080,10691,0.34896016),(5080,21549,0.3501741),(5081,14785,0.9851925),(5082,2154,0.3856679),(5082,2855,0.52336),(5082,4432,0.55620056),(5082,7051,0.8145884),(5082,16682,0.96758443),(5082,20891,0.8263894),(5082,29121,0.12512635),(5083,7445,0.36020535),(5083,12654,7.568709e-2),(5083,13768,1.1760863e-2),(5083,21843,0.6802998),(5083,26182,0.8003848),(5084,1943,0.2452038),(5084,6426,0.5813997),(5084,12344,6.8755254e-2),(5084,16299,0.55676395),(5084,18654,0.6208022),(5084,23928,0.10636661),(5084,28512,0.31058046),(5085,19113,0.5161662),(5085,22403,0.96264344),(5086,8302,0.3949719),(5086,13578,0.4063835),(5086,21194,0.40817454),(5087,11643,0.6691266),(5087,22520,0.24784072),(5087,29565,9.309259e-2),(5087,30276,0.18953088),(5088,20036,0.975211),(5088,28989,0.60473245),(5088,30501,0.1912296),(5089,4382,0.9801151),(5089,9716,0.10956517),(5089,9936,0.1784066),(5090,12321,0.9794894),(5090,19411,0.73537946),(5090,20165,0.26672235),(5091,4583,0.4655282),(5091,5516,0.68235767),(5091,8148,1.7250607e-2),(5091,16098,0.82897),(5091,18577,0.31935507),(5091,27079,0.54589456),(5092,14835,0.3725233),(5092,20324,0.6650179),(5092,25610,0.9615649),(5093,2974,0.57655376),(5093,9070,0.79338145),(5093,10254,0.8823754),(5093,10952,0.9944522),(5093,18768,0.5422246),(5093,22383,0.39970613),(5094,1957,0.12521578),(5094,2477,0.1673545),(5094,4477,0.8017421),(5094,10729,0.35402262),(5094,19614,0.5487402),(5094,23858,0.37057808),(5094,25416,1.0942264e-2),(5095,7947,0.43159258),(5095,9948,0.13209735),(5095,10671,0.6504585),(5095,14623,0.42077938),(5095,18600,0.844092),(5095,29913,0.2400918),(5096,8753,0.481882),(5096,11066,0.717213),(5096,15814,0.9544575),(5096,17659,0.30618677),(5096,27385,0.68520296),(5096,31447,0.26112553),(5097,5005,0.18746917),(5097,5399,5.000753e-2),(5097,6512,0.6930139),(5097,19007,0.86200285),(5097,22063,0.6747346),(5097,30885,0.9865436),(5098,16871,0.32687473),(5098,19745,0.31424814),(5098,21868,3.9054897e-2),(5098,24363,0.42282107),(5098,24899,0.574608),(5098,28017,0.6490878),(5099,6755,2.513303e-2),(5099,20757,1.4379274e-2),(5099,20849,0.86302644),(5099,26661,0.14670981),(5100,6202,0.74996775),(5100,15190,0.99464744),(5100,18863,0.24517798),(5100,26541,9.286246e-2),(5101,7668,0.81939733),(5101,8184,0.5480372),(5101,23153,0.11046065),(5101,31935,6.45281e-3),(5102,14583,0.6058035),(5103,2302,0.8346465),(5103,10768,0.7726724),(5103,12685,0.6486224),(5103,14066,7.93946e-2),(5103,15474,0.1611979),(5103,29990,0.99145526),(5103,31834,0.8821159),(5104,909,0.8108473),(5104,3091,0.4657679),(5104,9639,0.9965482),(5104,23770,0.6247714),(5105,11657,0.4624996),(5105,18346,0.47325793),(5105,19458,0.19218662),(5105,24528,9.2281304e-2),(5105,29645,0.440296),(5106,1028,0.9367253),(5106,1662,0.31541267),(5106,16951,0.39466858),(5106,24904,2.4109462e-2),(5107,186,0.98134285),(5107,8388,0.15388922),(5107,10684,0.4191457),(5107,21479,0.6561103),(5107,31420,0.9159672),(5108,3472,0.7250484),(5108,6812,0.6056103),(5108,9373,0.112542905),(5108,12972,0.51414263),(5108,23874,0.3252896),(5109,27485,0.8925397),(5109,31450,0.21752545),(5110,3953,0.32723573),(5110,8283,0.5221248),(5110,14103,0.49255124),(5110,17187,3.7817825e-3),(5111,17723,0.13102807),(5111,22313,0.6571352),(5112,2916,0.40058807),(5112,13900,0.1735299),(5112,14695,0.31596354),(5112,26686,0.43520173),(5112,28124,0.110430285),(5113,19736,0.81734836),(5113,20824,0.10806422),(5114,25743,0.4619215),(5114,29874,0.25708166),(5115,2237,4.5624547e-2),(5115,6580,0.96797425),(5115,7401,0.44434637),(5115,11873,0.80912817),(5115,17929,0.40710622),(5115,17940,0.67010397),(5115,27694,0.77105707),(5116,21060,0.76287276),(5116,21221,0.6081003),(5116,32351,0.87398195),(5117,11166,6.2748045e-2),(5117,14732,0.82120895),(5118,2401,0.61042506),(5118,6459,0.9967824),(5118,10799,0.5585779),(5118,12589,0.4878406),(5118,13993,0.712916),(5118,20900,0.28766865),(5118,27725,0.35065448),(5119,1087,0.24237354),(5119,10465,0.49341983),(5119,19940,0.32382673),(5120,6928,0.20248921),(5120,14911,0.7358625),(5120,20960,0.1265433),(5121,29547,0.49036407),(5122,18737,0.30501902),(5122,22987,0.24100386),(5122,32717,0.98208857),(5123,2761,0.97248805),(5123,5925,0.9488232),(5123,7406,0.41357043),(5123,7720,0.7277441),(5123,22124,0.6794428),(5123,26308,0.8106052),(5123,27127,0.7271189),(5124,4214,0.6284619),(5124,16110,0.341945),(5124,17653,0.7710746),(5124,17711,0.32941732),(5125,3972,0.33300614),(5125,5049,0.32686037),(5125,21822,0.68796843),(5125,25039,0.81991005),(5125,27670,0.14155704),(5126,32624,0.42346424),(5127,2930,0.60619324),(5127,19882,0.5109313),(5127,20956,0.8491982),(5128,3980,0.10244256),(5128,12705,0.7790968),(5128,18554,0.50774384),(5128,24213,0.6228281),(5128,31150,0.9231327),(5129,877,0.85817915),(5129,24945,3.1043977e-2),(5129,25224,0.73025113),(5130,11144,0.59477425),(5131,808,0.1881369),(5131,7883,0.6397614),(5131,11963,0.27290645),(5131,22695,2.6240295e-3),(5131,30701,0.41718063),(5132,646,0.26145494),(5132,6183,0.36988387),(5132,26365,9.9791475e-2),(5133,21150,0.8283775),(5134,12862,5.918714e-2),(5134,13715,4.9080975e-2),(5135,386,0.37093902),(5135,1168,0.72878516),(5135,14025,0.7470115),(5136,4037,0.4558267),(5136,4565,0.2927452),(5136,7315,0.9840979),(5136,15645,0.65349454),(5136,17072,0.7745095),(5136,27148,0.9401326),(5137,8129,0.116364814),(5137,15024,0.89404935),(5137,15639,0.16752797),(5137,24108,0.37704277),(5137,28370,0.55550885),(5137,31302,0.5288665),(5138,952,0.6836975),(5138,28111,0.42090383),(5139,712,0.69125485),(5139,4135,0.5062245),(5139,6011,0.704441),(5139,7625,0.7850717),(5139,16113,0.50133497),(5139,20538,0.9425049),(5139,21140,0.39864698),(5139,25757,0.7603193),(5140,3737,0.83153373),(5140,6806,0.8435341),(5141,23457,3.445729e-2),(5141,24608,0.8924056),(5141,29928,0.88811326),(5142,4490,0.5030521),(5142,20633,0.102171645),(5142,28749,0.5649365),(5143,294,0.90388834),(5143,25225,0.84988433),(5144,11037,0.9698032),(5144,24713,2.6076445e-2),(5145,15334,6.120387e-2),(5145,28491,0.7239728),(5146,8663,0.9143908),(5147,4449,4.7266265e-4),(5148,2048,0.8390279),(5148,30213,0.90299374),(5149,1569,5.5708373e-3),(5149,14418,0.99168026),(5149,21556,0.7717505),(5149,24916,9.201391e-2),(5149,28232,0.32134473),(5150,2026,0.7162108),(5150,5859,0.35453007),(5150,22633,0.38170776),(5151,227,0.86426413),(5151,11334,3.6428984e-2),(5151,32244,0.5994653),(5152,7438,0.3038657),(5152,9326,6.785134e-2),(5152,11907,0.9541299),(5152,16544,8.526534e-3),(5152,21786,0.62105477),(5152,31774,0.21361499),(5153,11056,0.6176005),(5153,24349,0.66590136),(5153,25977,0.7137148),(5153,28598,0.268819),(5154,10687,0.88561875),(5154,11866,0.39340582),(5155,15169,0.90629524),(5155,16033,0.6024572),(5155,16334,0.69166476),(5155,19325,0.92049146),(5155,22436,0.7455046),(5155,29856,0.4661285),(5156,409,0.6755137),(5156,3097,0.30313835),(5156,3785,0.27527893),(5156,29229,0.7105606),(5156,30409,0.76958436),(5157,4582,0.24966301),(5157,27620,0.3599207),(5157,32090,0.9063728),(5158,2649,0.8882647),(5158,3305,0.4353565),(5158,7766,7.736294e-2),(5158,9480,0.43951672),(5158,13638,0.9612902),(5158,16734,0.24964505),(5159,6473,0.3124931),(5159,8862,0.7898162),(5159,15382,0.3384769),(5160,24086,0.3119023),(5160,24461,0.36145258),(5161,5910,0.1559531),(5161,18119,0.96385807),(5161,19481,0.3720253),(5161,20869,0.91089433),(5161,23283,4.0137727e-2),(5161,25753,2.0577624e-2),(5161,29632,0.9433191),(5162,7452,0.8374405),(5162,21534,0.42257947),(5162,23383,0.68636),(5162,25300,0.3836294),(5163,2198,0.23180008),(5163,9123,0.78761524),(5163,10063,0.5207819),(5163,10378,0.6389931),(5163,26900,0.62095237),(5163,31628,0.404422),(5164,2019,0.25513703),(5164,17754,0.9221032),(5164,21657,0.39569044),(5164,23156,3.4318427e-3),(5164,23336,1.9847953e-3),(5164,29017,0.8690053),(5165,4561,1.3008039e-2),(5165,19595,0.26331684),(5165,27839,0.8960716),(5166,8346,0.76682705),(5166,13014,0.9183944),(5166,30671,0.21365064),(5167,5660,0.78553826),(5167,12489,0.8642787),(5167,15241,0.9344974),(5167,22222,6.73591e-2),(5168,17484,0.21694326),(5168,21220,0.9832289),(5168,23568,0.7566345),(5168,28420,4.545541e-4),(5169,2667,0.65748847),(5169,25145,0.9206297),(5169,27919,0.74495775),(5169,31563,0.87620705),(5169,32059,0.5389582),(5169,32672,0.51717466),(5170,8452,0.6638364),(5170,19150,0.5708949),(5170,19648,0.48787287),(5170,30855,0.32929704),(5171,7499,0.10919302),(5171,17091,0.5934365),(5171,26213,0.45954576),(5171,29620,0.4048203),(5172,2999,0.86354804),(5172,23237,0.5443883),(5172,25702,0.7005728),(5173,1657,0.44449067),(5173,1765,0.87217754),(5173,3280,0.8058507),(5173,25298,0.25831375),(5174,26663,0.6002067),(5174,31721,0.10425772),(5175,1122,0.30160424),(5175,4809,0.20145334),(5176,942,1.6187057e-2),(5176,10677,0.8204855),(5176,17561,2.0356137e-2),(5176,18982,0.1940395),(5177,3185,0.7133171),(5177,6017,0.71877515),(5177,9237,0.6053906),(5178,24887,7.2230145e-2),(5178,25383,0.7052965),(5179,4496,0.41522002),(5179,4703,0.9066906),(5179,11123,0.99237365),(5179,17485,0.9499425),(5179,26649,0.98721397),(5179,28624,0.67377406),(5180,1498,0.5314948),(5180,23597,0.9047904),(5180,24659,0.7452834),(5180,26665,0.53369844),(5180,28183,0.889285),(5181,5661,0.8900314),(5181,13652,0.18059303),(5181,16396,0.5800809),(5181,21951,0.8653889),(5181,30988,0.70978945),(5182,540,0.19639157),(5182,7985,0.51832676),(5182,8934,0.94045806),(5182,9556,0.2167466),(5182,12876,0.7000714),(5182,14622,0.2724159),(5182,21978,0.6527948),(5182,28874,0.81150854),(5185,15176,0.34703743),(5185,20009,0.754978),(5185,30446,0.31868097),(5186,7991,0.36898524),(5187,5759,0.8357183),(5187,6036,0.9012145),(5187,14973,0.15839204),(5187,19473,3.1122935e-3),(5187,28918,0.37698957),(5188,19488,0.27639633),(5188,21794,0.95225674),(5188,28583,0.3682228),(5188,32528,0.95245874),(5189,4323,0.6712285),(5189,5327,0.6132109),(5189,16001,9.976377e-2),(5189,16567,0.97557896),(5189,16731,0.54831725),(5189,28207,0.7267437),(5190,11447,0.88637763),(5190,13035,0.30605742),(5190,20233,0.80936795),(5191,5728,0.5747137),(5191,10206,0.28392413),(5191,12745,0.41441724),(5191,17465,0.61884075),(5191,24338,0.54464227),(5191,26957,7.277739e-2),(5191,27927,0.26832473),(5192,11399,9.634542e-2),(5192,14456,0.4484829),(5192,17048,0.3754163),(5193,3820,6.9075385e-3),(5193,9720,0.8598853),(5193,11048,0.2625894),(5193,29259,0.1559892),(5193,31787,0.37815082),(5194,8423,0.32090434),(5194,11372,0.26457006),(5194,12686,3.1893212e-2),(5195,15001,0.9346038),(5196,31675,0.6371477),(5197,2794,0.8868408),(5197,5834,0.3289215),(5197,9202,6.2551625e-2),(5197,16623,0.7169168),(5197,21446,0.7686037),(5197,29679,0.66552573),(5198,2217,0.35715592),(5199,18732,0.3963182),(5199,21595,0.11571499),(5200,2881,0.44405013),(5200,4682,0.7944385),(5200,12068,0.1877688),(5200,16047,0.26901284),(5201,1277,0.95294464),(5201,31579,0.79375315),(5202,940,0.11985869),(5202,1357,0.7262401),(5203,20504,0.14945889),(5203,29274,0.17512678),(5203,32553,0.44839713),(5204,13162,1.2560406e-2),(5204,19550,0.14015906),(5204,23583,4.3412395e-2),(5204,27943,0.6816992),(5205,1090,0.75067055),(5205,6860,0.27423304),(5205,12229,0.71297777),(5206,4014,0.2499846),(5206,28711,0.36107275),(5206,28915,0.83250546),(5207,1387,0.6282428),(5207,27584,0.8088636),(5208,18547,0.7440431),(5208,18928,0.96052134),(5208,21794,0.702336),(5208,27675,0.3171578),(5209,9577,0.13532822),(5209,9602,0.6318654),(5210,10344,0.8884887),(5210,14923,0.71542734),(5211,2071,0.6893473),(5211,5851,0.2023659),(5211,6747,0.553911),(5211,11327,0.6450797),(5211,12148,0.10968647),(5211,28213,0.19423911),(5211,29498,0.8639295),(5212,9206,0.87657386),(5212,21287,0.47819167),(5212,26887,0.5901549),(5212,28641,0.75991416),(5213,1063,0.11948793),(5213,3888,0.9883223),(5213,9508,0.9719174),(5213,10032,0.26301038),(5213,23960,0.32361466),(5214,5845,0.3575474),(5214,12227,0.1436778),(5214,15573,0.24502742),(5214,26743,0.7038772),(5215,805,0.12552506),(5215,21657,0.829395),(5215,31591,0.67801815),(5216,598,0.78849244),(5216,31314,0.21938512),(5217,2611,0.2157382),(5217,6525,0.17539674),(5217,17700,1.26787545e-2),(5217,20801,0.14122075),(5217,22536,0.34138224),(5217,27986,9.1291845e-2),(5218,581,0.19024555),(5218,8377,0.3334173),(5218,10108,0.255122),(5218,16402,0.30005053),(5218,23615,0.6694722),(5219,83,0.29752892),(5219,25354,0.74925697),(5219,32705,0.20823383),(5220,792,4.2126453e-3),(5220,8337,1.6111821e-2),(5220,30260,0.24810666),(5221,4296,0.5037149),(5221,19018,0.9753465),(5221,22532,0.35189158),(5221,23336,0.7683806),(5221,24880,3.695194e-2),(5222,9907,0.32366842),(5222,14336,3.6694586e-2),(5222,23864,0.9537132),(5222,26737,0.8431934),(5223,5101,0.23679166),(5223,18064,0.79558766),(5223,19288,0.3215123),(5223,23145,0.44003132),(5224,10281,0.13880359),(5224,12406,0.5690005),(5224,19343,0.8127441),(5224,24849,0.8535121),(5224,30567,0.16667235),(5225,1626,0.66626436),(5225,8408,0.43385193),(5225,13147,0.33492523),(5225,16432,0.30654073),(5225,26915,0.39195824),(5225,27373,0.6675401),(5225,29490,0.35288072),(5226,7397,4.330244e-2),(5226,22496,0.6387152),(5226,32625,0.91431767),(5227,19350,0.94774),(5227,24184,0.67249656),(5228,9152,0.7747953),(5228,18401,0.786803),(5229,15271,0.7015894),(5230,3041,0.55357224),(5230,3987,0.39455393),(5230,11463,0.33581722),(5230,24392,0.91590965),(5230,25988,0.62552506),(5230,28678,0.6207205),(5230,31703,0.7087071),(5231,3159,0.106235646),(5232,7899,0.45851612),(5232,15212,0.3548272),(5232,27242,5.8107387e-2),(5233,9531,3.1902697e-2),(5233,16218,0.78184086),(5234,3969,0.10921301),(5234,8858,0.21789746),(5234,9426,2.130565e-3),(5234,15498,0.41958424),(5234,26763,0.7181813),(5235,3023,0.4807704),(5235,5551,8.428174e-2),(5235,9105,0.6499535),(5235,11231,0.27693862),(5235,16868,0.2376401),(5235,17643,0.378357),(5235,29959,0.73140466),(5236,786,0.8540662),(5236,2485,0.3937351),(5236,19178,0.90490055),(5236,19805,0.11691869),(5237,2832,0.9609391),(5237,3701,0.4272336),(5237,11646,0.9567343),(5237,13915,0.33704326),(5237,14676,0.3938026),(5237,25975,0.42561746),(5237,26057,0.84118897),(5237,29126,3.400674e-2),(5237,32722,0.5894253),(5238,3073,0.83335936),(5238,4150,0.7086589),(5238,7613,0.1143296),(5238,13922,0.7717518),(5238,14841,0.7050133),(5238,22067,0.76087093),(5238,28201,0.50973487),(5239,16400,0.33121926),(5239,21801,0.74036604),(5240,5564,0.74740916),(5240,8627,4.1632384e-2),(5240,13708,0.7505898),(5240,19908,0.89246076),(5241,7533,0.15779185),(5241,8838,0.56192225),(5241,16991,0.92614),(5241,24131,0.21113724),(5241,32538,0.6186954),(5242,3580,0.69432473),(5242,4417,0.5683739),(5242,7197,0.28407362),(5242,32337,0.4365985),(5243,10814,0.5260611),(5243,11493,0.38292482),(5243,20202,0.8804655),(5243,25337,0.90334237),(5243,25400,0.4546634),(5243,27244,0.5205935),(5243,32242,0.9384714),(5244,12875,0.92117697),(5244,21633,0.57072216),(5244,24084,0.38231468),(5244,26623,0.27727315),(5244,29450,0.5023492),(5244,29511,0.8735635),(5245,11,0.73851013),(5246,4217,0.52706844),(5246,22047,5.4106064e-2),(5247,19619,0.9102524),(5247,25436,0.39647296),(5247,27239,0.2632443),(5248,8753,0.41033822),(5248,22874,0.97444797),(5249,330,0.88801426),(5249,5023,0.35910857),(5249,5910,8.979248e-2),(5249,24747,0.12844917),(5250,5667,0.6321348),(5250,20690,0.49541372),(5250,21404,0.9062522),(5250,22534,0.67376846),(5250,23197,0.4846812),(5250,26444,0.5975672),(5250,28473,0.121877864),(5250,32229,0.5239404),(5251,19680,8.9153446e-2),(5252,32027,0.33341613),(5254,1412,0.8004377),(5254,4611,0.9706936),(5254,5406,0.553413),(5254,11005,0.39694178),(5254,14928,0.8292484),(5255,3568,0.46229067),(5255,4552,0.36680487),(5255,5652,0.47730732),(5255,6853,0.66563267),(5255,6928,0.894894),(5255,19261,0.15688752),(5256,12675,0.1506881),(5257,1110,6.312338e-2),(5257,7470,0.87022203),(5257,7724,0.9736437),(5257,10144,0.46140516),(5258,6716,0.16388208),(5258,8655,3.369665e-3),(5258,9778,3.0054413e-2),(5258,12306,0.6405066),(5258,13282,0.7223003),(5258,15217,0.28332922),(5258,17743,0.78363484),(5258,25417,0.9864722),(5258,29831,0.9528266),(5259,4442,0.49822074),(5259,7318,0.17682283),(5259,8796,0.27182004),(5259,9197,0.5546036),(5259,11020,0.59448117),(5259,21628,0.4873717),(5259,30182,0.68231213),(5259,30224,5.151455e-3),(5260,25551,0.28539813),(5261,15744,0.9489912),(5261,17744,0.19901095),(5262,11523,6.2481627e-2),(5262,13166,0.6721251),(5262,14172,0.48716027),(5262,19183,0.82059455),(5262,27893,0.94265604),(5262,31860,0.81280476),(5263,4625,0.1890044),(5264,10372,0.29041994),(5265,4557,0.5662096),(5265,8997,0.67435604),(5265,17152,0.77597904),(5265,27267,0.4986211),(5265,27842,0.30036664),(5265,29016,0.87172586),(5266,2386,0.6791772),(5266,3754,0.882405),(5266,16304,0.86759794),(5266,19311,0.20724176),(5266,21441,0.851619),(5266,27420,0.19019054),(5267,4885,0.40862155),(5267,7965,0.31368336),(5267,12237,0.94093674),(5267,25635,0.7109911),(5267,29704,1.3427827e-2),(5268,30720,0.144963),(5269,1116,7.477763e-2),(5269,14644,0.54793227),(5269,22205,0.9698074),(5269,26629,0.40576997),(5270,5266,0.4422678),(5270,20482,0.14051242),(5270,25087,0.15511991),(5270,31807,0.9459371),(5270,32233,0.83268625),(5271,7390,0.426167),(5271,10179,0.21602313),(5271,12158,0.11596516),(5271,13463,0.5145663),(5272,28189,0.19957703),(5273,223,0.328692),(5273,17443,0.5093034),(5274,4377,0.30585358),(5274,9419,0.8871282),(5274,15550,0.33084366),(5274,29544,0.5850685),(5274,30188,0.44470325),(5274,32725,0.40351698),(5275,8840,0.854409),(5275,12078,0.33208835),(5275,19281,0.46809837),(5275,20926,0.507673),(5276,6787,0.3884363),(5276,12660,0.31432468),(5276,19055,4.456881e-3),(5276,19060,0.17170644),(5276,20405,0.43586904),(5276,24049,0.5956642),(5276,24373,0.8418168),(5277,2600,0.9840655),(5277,20904,0.6436668),(5277,28134,0.80544645),(5277,28988,0.96421045),(5278,3466,0.67019963),(5278,18538,0.4711479),(5278,29141,0.5660793),(5279,7763,0.6058888),(5279,14048,0.49809262),(5279,18057,0.7024917),(5280,2678,0.66220933),(5280,3605,0.29577515),(5280,3915,0.98905915),(5280,9249,0.52016646),(5280,9327,4.5597706e-2),(5280,12346,0.99863166),(5280,14119,0.91619545),(5280,16989,0.5904085),(5281,10038,0.30158526),(5281,19456,0.6259721),(5281,23677,0.64502317),(5281,24909,4.9879905e-2),(5281,25740,0.28986785),(5281,28422,0.5138869),(5281,28784,0.88491833),(5282,3768,0.33936104),(5282,30835,0.9720848),(5283,3279,0.9095251),(5283,6513,0.6345096),(5283,9096,0.7927353),(5283,28739,0.42952156),(5283,29646,0.6189982),(5284,9924,4.108717e-2),(5284,13282,0.66876674),(5284,30954,4.085166e-3),(5285,8833,0.85420287),(5285,27572,0.85276586),(5286,1109,0.6872979),(5286,26040,0.6349802),(5287,4346,9.711282e-2),(5287,22926,0.8084302),(5288,10302,0.21195994),(5288,13452,0.97700787),(5288,19608,0.5279253),(5288,21848,0.42461184),(5289,3712,0.90370244),(5289,6892,0.6159925),(5289,27590,0.18446262),(5289,30799,0.5919066),(5290,7371,0.8560503),(5290,13321,0.9574758),(5291,11026,0.70350516),(5291,22764,0.555023),(5292,6511,0.9622697),(5292,8464,0.9883988),(5292,29593,0.15289739),(5294,3522,0.7209603),(5294,11726,0.31521183),(5294,19805,0.38757735),(5294,23997,0.30345333),(5294,25590,0.44228557),(5294,30447,6.106391e-2),(5295,2092,0.5622384),(5295,20978,0.40715128),(5295,21977,6.902837e-2),(5295,31420,0.58314353),(5295,32749,0.81241345),(5296,5898,0.9249198),(5297,692,0.6221042),(5297,14652,0.6506926),(5297,16280,0.9912273),(5297,29587,0.97799796),(5298,4337,0.9705496),(5298,7080,0.38720223),(5298,7879,0.8511919),(5298,9381,0.24691053),(5298,11428,0.50395423),(5298,16660,3.0660594e-2),(5298,17004,0.46925214),(5298,22530,0.22039005),(5298,23510,0.20029935),(5298,27500,0.8252278),(5298,31659,0.1147006),(5299,10715,0.6818142),(5299,12680,0.22358538),(5299,15872,0.85101306),(5299,18970,4.7532026e-2),(5299,32300,5.4334823e-2),(5300,11590,0.18541616),(5300,27364,0.8763565),(5301,7225,0.123937465),(5301,10462,0.6532126),(5301,28914,0.49637598),(5302,10497,0.6469501),(5302,12124,6.148408e-2),(5302,21323,0.22915776),(5302,31164,0.7421833),(5303,357,0.15268083),(5303,3583,0.87632734),(5303,6945,0.8071305),(5304,23679,0.3961186),(5304,23808,0.15419681),(5304,23887,0.4955833),(5304,26394,0.5187377),(5304,27488,0.25308335),(5304,28336,8.5281946e-2),(5305,2304,0.5999115),(5305,3265,0.17832582),(5305,11198,0.99743736),(5305,16327,2.763925e-2),(5306,11007,0.37578782),(5306,22929,0.94054073),(5306,30341,0.8553215),(5307,2736,0.4050849),(5307,5016,0.690468),(5307,9559,0.37187278),(5307,14697,0.74045867),(5307,20068,0.3069392),(5307,30785,0.90844953),(5308,1052,0.8694364),(5308,8793,0.6328659),(5308,9189,0.617712),(5308,13898,0.3937986),(5308,20415,0.7874187),(5308,21281,2.1691155e-3),(5308,22042,6.486806e-2),(5308,25896,0.20701806),(5309,1007,0.35022148),(5309,1931,0.4717215),(5309,13040,0.8503291),(5309,18422,0.6781075),(5309,22053,0.69099325),(5309,22643,3.1062832e-2),(5309,23777,0.96349424),(5309,25048,0.45894617),(5310,22430,0.96976155),(5310,22772,2.6958715e-2),(5310,24834,0.65108347),(5311,2728,0.40904906),(5311,5960,0.37699744),(5311,9026,0.8737877),(5311,16228,0.40287396),(5311,22829,0.3141822),(5311,23083,0.10727781),(5311,25948,0.63894707),(5312,3750,0.77834165),(5312,22050,0.2454772),(5312,25597,2.7232466e-2),(5312,26576,0.2939728),(5313,2643,0.64461213),(5313,14785,0.9733984),(5313,18880,0.2299896),(5313,21130,0.7595244),(5313,22795,0.124382675),(5313,23083,0.9210794),(5313,25051,0.8739763),(5314,9658,6.362642e-2),(5314,14659,6.774094e-2),(5314,21043,0.8177097),(5315,5091,0.6474434),(5315,13864,0.72173965),(5315,17811,0.878452),(5315,26772,0.7274194),(5315,31553,0.56193274),(5316,9981,0.70321524),(5318,6636,0.8877731),(5318,13703,0.41635057),(5318,27504,0.9910956),(5319,3173,0.55775297),(5319,8062,0.5959737),(5319,12536,0.7928523),(5319,19626,0.40385824),(5319,31164,0.9684549),(5320,166,0.39776933),(5320,1470,0.5802405),(5320,3589,0.69725347),(5320,12434,0.62560254),(5320,16560,0.60682774),(5320,17333,0.36696142),(5320,22359,0.27783597),(5320,23593,0.7517262),(5320,29290,0.52656364),(5321,4562,4.7434043e-2),(5321,6518,0.3801986),(5321,6946,0.7742646),(5321,27329,0.7310675),(5321,27986,0.39048487),(5321,31939,0.49925524),(5322,4585,0.88148534),(5322,12958,0.36308074),(5322,25897,0.47158906),(5322,26488,0.49359363),(5322,30286,0.29331043),(5322,30320,0.20006013),(5322,31578,0.6819837),(5322,32250,4.746391e-3),(5324,2216,0.7644898),(5324,4113,0.14096317),(5324,16949,0.5177244),(5324,18483,0.7070975),(5324,25358,0.4544147),(5324,28742,0.7803434),(5324,30257,0.3938998),(5325,5687,0.7822468),(5325,13738,0.9263726),(5325,25456,0.3938543),(5325,29987,0.9468204),(5327,6770,0.85392094),(5327,15799,0.23696429),(5327,17717,0.37062708),(5327,21842,0.5402529),(5328,1136,0.54576045),(5328,17563,0.97451466),(5329,5172,0.6690684),(5329,13253,1.767992e-2),(5329,19638,0.7103022),(5329,22896,0.62379056),(5329,25621,0.215218),(5329,27160,0.97575),(5330,1344,3.3919327e-2),(5330,13353,0.30370343),(5330,18505,0.20642991),(5330,21593,0.16289675),(5331,9115,0.5139538),(5331,25701,3.313706e-2),(5332,4800,0.87465817),(5332,5967,0.82537836),(5332,32108,0.19777235),(5333,7809,0.26501888),(5333,25362,0.12928264),(5333,26649,0.68407935),(5333,27302,0.36642057),(5334,14505,8.48038e-2),(5335,5336,2.9623657e-2),(5335,26223,0.78567487),(5335,31486,1.1703675e-2),(5336,5103,0.2487929),(5336,30094,0.90278625),(5336,30805,0.2894206),(5337,8388,0.16481295),(5337,10100,0.8376515),(5337,21421,0.89497036),(5338,15480,0.9148807),(5338,17992,0.6838104),(5338,21635,0.8481344),(5338,26770,7.0762776e-2),(5338,28964,0.8145558),(5339,2143,0.1731773),(5339,32257,0.30954683),(5340,5568,3.443947e-2),(5340,19623,0.4758406),(5341,2560,0.71013594),(5341,9884,0.94961894),(5341,15325,0.7674754),(5341,18273,2.280615e-2),(5341,26164,0.21349916),(5341,28148,0.46846375),(5341,28969,0.60343647),(5341,29797,0.3894461),(5342,3130,0.27709696),(5342,18339,0.9777945),(5342,24404,0.8077605),(5342,30193,0.121017456),(5343,10841,0.15990753),(5343,19016,0.70022917),(5343,28963,0.3723564),(5344,1941,7.507652e-2),(5344,8243,0.5645969),(5344,10711,0.7272884),(5344,17837,0.2003034),(5344,22557,0.28446198),(5344,27139,0.764388),(5345,22537,0.11780951),(5345,24006,0.84303296),(5345,25488,0.793445),(5346,11828,0.61462283),(5346,21265,0.19353935),(5346,25763,0.7992618),(5346,26230,5.4379817e-2),(5346,26253,0.6472802),(5347,3448,0.87463915),(5347,12694,0.24163526),(5348,6993,3.073821e-2),(5348,20861,5.1604778e-2),(5348,24749,0.92676073),(5348,26557,2.7276501e-2),(5349,5556,0.86268485),(5349,14913,0.6923841),(5349,16573,0.8553682),(5349,16731,0.4120958),(5350,691,0.5270858),(5350,4172,0.45184284),(5350,5246,0.3906888),(5351,4659,0.69084835),(5351,8012,0.9036185),(5351,14145,0.2641688),(5351,25176,0.2760481),(5351,26413,0.13264035),(5352,7244,0.52494895),(5352,12350,0.3500231),(5352,17318,0.26506385),(5352,17909,0.7005994),(5352,23972,0.8549935),(5353,24085,0.90387887),(5353,29181,9.462975e-2),(5353,30289,0.855644),(5354,7356,0.96466666),(5354,9439,0.12351736),(5354,9999,0.8300118),(5355,5122,0.42719558),(5355,8134,0.96295065),(5355,24358,0.95569605),(5355,24734,0.74836296),(5356,6602,7.397481e-5),(5356,8366,0.31503394),(5356,20381,0.9051376),(5356,21102,0.5424747),(5357,17739,0.95962137),(5357,28481,0.2223356),(5357,29060,9.2452094e-2),(5358,3914,0.8539978),(5358,16828,3.9441273e-2),(5358,17077,0.76904905),(5358,20601,0.69056994),(5358,24983,0.27051157),(5359,7042,0.4583547),(5359,25445,0.1377159),(5359,30109,0.11618549),(5360,1315,0.895338),(5360,4369,0.7968659),(5360,9755,0.2136956),(5360,16630,5.095729e-2),(5360,27059,0.1836781),(5361,10303,0.65752953),(5361,10521,0.12809108),(5361,21910,0.76120955),(5361,32489,0.27111158),(5362,1853,4.984377e-2),(5362,13030,0.8169379),(5362,24889,0.49173325),(5362,27038,0.4072308),(5362,31611,0.6910921),(5363,18988,0.85913867),(5363,31864,0.6046199),(5363,32359,0.29599312),(5364,18562,0.76988155),(5364,24235,0.8155723),(5364,27166,0.18135001),(5366,13772,0.49169478),(5366,19815,0.14065579),(5366,21100,0.52452195),(5366,21850,0.19169876),(5366,25208,5.2706644e-2),(5366,26975,0.5332447),(5366,29220,0.6681517),(5366,30121,0.7471573),(5366,32394,0.73022777),(5367,2817,0.47061804),(5367,3344,0.24449466),(5367,3651,0.89814806),(5367,8866,0.44669113),(5367,8935,0.11106829),(5367,14136,0.7574937),(5367,17127,0.95554614),(5368,2460,0.14833188),(5368,2760,0.77644956),(5368,21225,0.9725356),(5369,18801,0.359907),(5369,23255,7.386882e-2),(5370,8451,0.89335835),(5370,12371,0.49101987),(5370,23336,0.9546214),(5371,3954,0.6303794),(5371,26903,2.0931538e-2),(5371,30914,0.40492564),(5372,15786,0.23360412),(5372,20990,0.90722215),(5372,30418,0.8472562),(5373,11791,0.7530027),(5373,22597,0.6489451),(5373,25968,0.18236296),(5373,30323,0.73141825),(5375,8496,0.4577853),(5375,12334,6.712777e-2),(5375,12912,0.74968994),(5375,22017,0.38775116),(5376,714,0.3785605),(5376,3139,0.66173434),(5376,6116,0.15572762),(5376,10328,0.729864),(5376,22007,0.31108934),(5377,7976,0.35284722),(5377,10593,0.44996893),(5377,28986,0.20405747),(5378,9562,0.9142711),(5379,10369,0.5873055),(5379,10920,0.54940885),(5379,17545,0.27841562),(5379,30743,0.6387198),(5379,31297,0.7652962),(5380,6436,0.26663104),(5380,10146,0.21140233),(5380,26074,0.577938),(5380,31981,0.12932996),(5381,7002,0.89990604),(5381,13188,0.1473469),(5381,18399,0.5761592),(5382,17595,0.38407466),(5382,27256,0.9599098),(5382,30377,0.24749307),(5383,6255,0.96212),(5383,20115,0.101859),(5383,24381,1.2084652e-2),(5383,24654,0.8879125),(5383,29192,0.2176589),(5383,31548,0.76145065),(5383,32226,0.2955248),(5384,5853,0.52041125),(5384,7633,0.61232466),(5384,18684,0.23511723),(5384,21454,0.30642065),(5384,21608,0.90298575),(5384,23236,0.21581814),(5384,29705,0.8905131),(5385,3946,6.564499e-2),(5385,4242,0.75695556),(5385,10023,7.932974e-3),(5385,20060,0.79964894),(5385,30064,0.86563087),(5386,2800,0.7051624),(5386,5075,0.14521438),(5386,6366,0.9479645),(5386,9769,0.15356925),(5386,11918,0.69366103),(5386,14211,0.32450345),(5386,16369,5.7074286e-2),(5387,554,0.8397346),(5387,18162,0.66186446),(5387,21584,7.0145056e-2),(5387,29014,0.12294371),(5388,13012,0.17392395),(5388,19380,0.66609436),(5389,7652,0.9557868),(5389,16884,0.89792246),(5389,19819,0.3834652),(5389,25331,0.3740938),(5390,1581,0.15270853),(5390,9582,0.7143425),(5390,13981,0.97253853),(5391,8700,0.25740626),(5391,18279,0.9953757),(5391,22651,0.5137757),(5391,26377,0.24886915),(5391,32518,0.9853807),(5392,7306,0.5159668),(5392,20670,0.6933396),(5392,32298,0.32258788),(5393,359,0.56977075),(5393,3658,0.67332023),(5393,18458,0.6960752),(5393,20523,0.87744987),(5393,25765,0.8323788),(5394,8930,0.369761),(5394,19713,0.78297555),(5394,19846,0.5750802),(5395,17147,0.5982254),(5396,17667,0.8661607),(5396,30203,0.48493916),(5396,31745,0.38282394),(5397,28683,0.37329468),(5397,31811,0.48913878),(5397,32051,0.5442236),(5398,358,0.9823909),(5398,961,0.41681674),(5398,13311,0.46520612),(5398,25848,0.9332828),(5398,29117,0.2718282),(5398,30035,0.88191336),(5399,5233,0.42702958),(5399,16886,0.2932442),(5399,19800,0.2067244),(5399,21375,7.765237e-2),(5399,24544,9.619821e-2),(5399,31776,0.2704494),(5400,11630,0.46182925),(5400,21121,0.20884112),(5400,24738,0.46034777),(5401,5942,0.81091434),(5401,8686,0.7633814),(5401,19494,0.7856888),(5402,27127,0.8730941),(5402,27357,0.47986272),(5402,30645,0.79503703),(5402,30784,0.5520024),(5402,31588,0.46674696),(5403,5836,0.823822),(5403,11586,0.77715445),(5403,14922,0.4602048),(5403,29616,0.976686),(5404,4302,0.9857688),(5404,8704,0.54379404),(5404,10563,5.472798e-2),(5404,31340,0.6315037),(5405,1744,0.5475745),(5405,15600,1.909532e-2),(5405,20872,0.13162394),(5405,22782,0.34163457),(5405,26516,0.64351785),(5405,31725,0.27343494),(5406,1733,0.6387532),(5406,19519,0.5783898),(5406,25342,0.14787707),(5407,16132,0.29156065),(5407,27866,0.14319552),(5407,31831,0.16238181),(5408,7090,0.32982484),(5408,8021,0.5031568),(5408,13787,0.58801794),(5408,14195,0.30714315),(5408,18940,0.28957257),(5408,28011,0.77856266),(5409,917,0.41783738),(5409,3710,0.7246825),(5409,7292,0.59609395),(5409,22762,0.92204386),(5409,26550,0.75419533),(5410,15579,0.14654706),(5410,23620,0.2632922),(5411,5213,0.84225315),(5411,12901,0.3436453),(5411,27888,0.8729252),(5412,12251,6.855382e-2),(5412,14340,0.41878217),(5412,16439,0.49978334),(5412,26989,8.090278e-2),(5413,1250,0.923415),(5413,17431,0.88954175),(5413,29791,0.83613604),(5414,4653,0.686883),(5414,9530,0.5506819),(5414,18383,0.7542467),(5415,13723,0.3530715),(5415,32197,0.70721287),(5416,5401,0.9365312),(5416,9728,0.5173231),(5416,10681,8.265142e-2),(5416,15865,0.8958851),(5416,29169,0.8920241),(5417,4085,1.795014e-2),(5417,10356,0.9213673),(5417,13994,0.19439238),(5417,21885,0.7586058),(5417,22467,0.15072107),(5417,23738,0.1565049),(5417,25461,0.36676976),(5417,27572,0.9015006),(5417,32098,0.1640624),(5418,1129,0.1106453),(5418,7412,0.5773004),(5418,16797,0.2630548),(5418,24582,0.38927972),(5418,28443,0.7367988),(5419,1417,0.58601266),(5419,14169,0.64144313),(5419,16227,0.731736),(5420,13,0.46642575),(5420,3233,0.7749535),(5420,4610,0.91924685),(5420,5723,0.47751045),(5420,12594,0.66975427),(5420,20892,0.52680355),(5420,21848,0.55412966),(5420,32145,0.86053795),(5420,32518,0.9985319),(5421,3693,0.8745325),(5421,4211,5.914405e-2),(5421,13447,0.2180825),(5421,25772,0.18839546),(5422,4738,0.61388284),(5422,10556,0.3754468),(5422,19306,0.98525244),(5423,11207,0.83266604),(5423,26031,0.609834),(5423,27587,0.54578465),(5423,29197,0.9564578),(5424,16146,0.16473676),(5424,24701,0.8253551),(5424,32576,0.74516153),(5425,5182,0.88322204),(5425,9452,0.19169094),(5425,13486,0.26984364),(5425,20750,0.16024153),(5426,5176,0.9602281),(5426,26265,0.6144169),(5426,27173,0.4300377),(5426,30201,0.47217193),(5427,7128,0.14304122),(5427,14954,0.16059512),(5427,22174,0.35397965),(5427,29425,0.6856215),(5428,18484,0.17910933),(5428,19924,0.5380854),(5428,25009,0.586096),(5428,30151,9.492881e-2),(5429,13412,0.33801436),(5429,15234,0.7642424),(5430,15179,0.45773754),(5430,20053,0.6891579),(5430,32570,0.47084388),(5431,2552,0.5041379),(5431,4116,2.1178702e-2),(5431,30176,0.25016922),(5432,5834,0.37737328),(5432,14389,0.9234216),(5433,220,0.62380666),(5433,1891,0.25149062),(5433,8643,0.53568274),(5433,10241,0.70603764),(5433,24187,0.5332207),(5433,29082,0.40490544),(5434,9418,0.97571516),(5434,16114,0.20058618),(5434,19240,0.93525684),(5434,23032,0.49149483),(5434,26030,0.37310237),(5434,27195,0.41007778),(5434,29070,0.9003929),(5434,29282,5.9880856e-2),(5435,19034,0.14869472),(5435,23858,0.13096388),(5435,26276,0.96660525),(5436,1231,0.14389789),(5436,12579,0.2206975),(5436,14170,0.19560885),(5436,20928,0.21650705),(5437,8726,0.3352763),(5437,15396,0.5720611),(5437,19537,0.29515043),(5437,27302,0.26704317),(5437,30097,0.48845965),(5438,2991,0.64858),(5438,4014,0.36481065),(5438,6052,0.40359518),(5438,14333,0.5692857),(5438,18639,0.550812),(5438,20961,0.45038417),(5439,9905,0.21432379),(5439,19092,0.42667174),(5440,9709,0.19609551),(5440,23939,0.8562482),(5440,28076,0.20213903),(5441,11261,0.54485947),(5441,23443,0.27615255),(5442,1423,0.9018845),(5442,15928,3.2007046e-2),(5442,23336,0.35383385),(5442,26442,0.40498653),(5442,28569,0.76545334),(5443,20804,0.6543186),(5443,30756,0.31232864),(5444,2748,0.85724103),(5444,8428,0.3976606),(5444,8619,0.24021728),(5444,26792,0.77110857),(5445,16510,0.36126295),(5445,16582,7.3617795e-3),(5445,19351,0.37676856),(5446,3210,0.645862),(5446,13120,0.79653215),(5446,18456,1.3097745e-2),(5447,21099,9.440773e-2),(5447,31870,0.287943),(5448,17562,0.7032038),(5448,28181,0.79578507),(5448,30737,4.321967e-2),(5449,7642,0.35051325),(5449,17979,0.17938694),(5449,23941,0.26624215),(5449,28721,0.3303363),(5449,32508,0.44469061),(5450,7598,0.7969976),(5450,8463,4.729019e-2),(5450,8936,0.8692302),(5451,5397,7.537484e-2),(5451,9523,0.48941293),(5451,10306,0.47882855),(5451,17662,0.74750346),(5451,19317,0.5899787),(5452,5351,0.82228804),(5452,12208,4.362534e-2),(5452,12852,0.88720816),(5452,23226,0.8474826),(5452,25665,0.79182166),(5452,31194,0.41299203),(5453,7662,0.66683024),(5454,1133,0.94907993),(5454,5910,0.9387504),(5454,13247,0.88849205),(5454,16925,0.7146948),(5454,24105,0.29948232),(5454,29022,0.35937148),(5455,3398,0.30889916),(5455,7495,0.7304502),(5455,13980,0.31533638),(5455,16368,0.15794657),(5456,4791,0.43693456),(5456,13601,0.4294721),(5456,15570,4.357958e-2),(5456,15746,0.15168051),(5456,26046,0.21800485),(5457,24998,0.11287511),(5457,25333,0.29485443),(5459,3506,0.52258855),(5459,7361,0.33799118),(5459,10827,3.1410348e-2),(5459,14576,0.8867054),(5459,15701,0.89505506),(5459,29690,0.86276925),(5460,1369,0.24076152),(5460,9252,0.4836592),(5460,9348,0.8974964),(5460,11539,0.35934916),(5460,12373,0.39577076),(5460,19873,0.67494404),(5460,20033,0.5009165),(5460,24779,0.92610204),(5461,4666,6.521705e-2),(5461,8687,0.6333357),(5461,12041,0.18703225),(5461,18709,0.85021025),(5461,22408,0.36536604),(5461,30509,0.5166774),(5461,30710,0.96407145),(5462,7927,0.6686529),(5462,28272,0.24605526),(5463,904,0.38253206),(5463,1362,0.9424995),(5463,18093,0.5931976),(5463,18431,0.7005507),(5463,20076,0.22852911),(5463,22187,0.5527596),(5463,31165,6.949051e-2),(5464,11056,6.852813e-2),(5464,11187,0.8605831),(5464,16251,0.18675187),(5464,22961,0.32990533),(5464,28232,0.69437176),(5465,3874,0.64557666),(5465,8684,0.1836357),(5465,12340,0.8999922),(5465,14951,0.38260025),(5465,19066,0.21198748),(5465,21690,0.9415031),(5465,29100,0.8420519),(5466,1700,0.88158023),(5466,7449,0.5063211),(5466,11825,0.8248567),(5466,32230,0.34590533),(5467,10149,0.105808035),(5467,20059,0.6927046),(5467,22107,0.7596147),(5467,22955,0.39127836),(5467,24945,9.519281e-2),(5467,31175,8.8940635e-3),(5468,1159,0.42532554),(5468,1808,0.83140457),(5468,11613,0.4053391),(5468,17749,0.8208804),(5468,18268,0.8748366),(5468,25999,0.40384462),(5468,30626,0.8361903),(5468,32564,0.4551526),(5469,3981,0.1804021),(5469,15293,5.026795e-2),(5469,24936,0.70424443),(5469,25939,0.6817686),(5469,29299,0.63408345),(5469,29324,0.70868546),(5469,32558,0.6405279),(5470,8527,0.69161993),(5470,29031,0.5752302),(5471,2449,0.49269336),(5471,27937,0.8608168),(5471,31227,0.19286945),(5471,32494,0.795749),(5472,6803,0.4457211),(5472,13678,0.85704845),(5472,24170,0.34874058),(5472,27100,3.197584e-2),(5473,14306,0.32483262),(5473,22412,0.24761121),(5473,30832,0.12266954),(5473,32105,8.648959e-3),(5474,4819,0.5888134),(5474,9186,0.38391897),(5474,14048,0.8235508),(5474,14958,0.19540685),(5474,29974,0.77090544),(5476,7737,0.9896047),(5476,11529,0.80995035),(5476,31695,0.13403869),(5477,282,0.9287997),(5477,3307,0.26811406),(5477,22041,7.233806e-2),(5478,289,0.6508826),(5478,7840,6.857686e-2),(5478,11662,0.18848868),(5478,16545,0.8887208),(5478,21798,0.88680685),(5478,31716,0.43201017),(5479,9829,0.9090803),(5479,18360,2.0171866e-2),(5479,23086,0.44953188),(5479,26020,6.869908e-2),(5479,26051,0.86620766),(5479,26822,0.29625553),(5480,13112,0.24415487),(5480,22010,0.6119724),(5480,22119,0.36653405),(5480,30224,5.871586e-2),(5481,26351,0.30923334),(5481,26951,0.64977306),(5481,27270,0.81728494),(5481,32076,7.56711e-2),(5481,32183,0.20285195),(5482,2733,0.50003654),(5482,30376,0.21382163),(5483,1634,0.532533),(5483,4799,0.6077379),(5483,7173,0.38392445),(5483,7558,0.3665595),(5483,8625,0.3451649),(5483,16622,0.819132),(5484,798,0.2655481),(5484,10992,0.7398092),(5484,18769,8.816414e-2),(5485,11298,0.5645348),(5485,20055,0.5570177),(5485,25254,0.98686457),(5485,26160,0.8515804),(5485,30228,0.7246049),(5486,9471,0.15972322),(5486,12114,0.99709034),(5486,24488,0.3702326),(5486,31960,0.20224646),(5487,9496,0.71559405),(5487,28552,0.36840558),(5488,11881,0.6799413),(5488,25373,0.12695166),(5488,26801,0.35581914),(5489,6217,0.27255568),(5489,12719,0.7375607),(5489,21753,0.7432976),(5489,28859,0.124250524),(5490,6880,0.18606892),(5490,17219,0.5476872),(5490,17690,0.13374102),(5490,28049,0.6259009),(5490,30986,0.30574295),(5491,1331,0.1714177),(5491,3588,0.5362638),(5491,4450,0.40435183),(5491,6244,0.42555782),(5491,14723,0.7640321),(5491,15517,0.43127885),(5491,17384,0.23756355),(5491,22348,0.12064042),(5491,26733,4.804513e-2),(5492,8727,2.9112666e-3),(5492,13984,0.17068714),(5492,21833,0.23938808),(5493,4537,8.123051e-2),(5493,28483,0.23203056),(5493,28539,0.49665704),(5494,2307,0.15086156),(5494,8486,0.34383768),(5494,11120,0.46432334),(5494,14481,0.9148209),(5494,22400,0.58869654),(5494,29131,0.26281074),(5495,614,0.27040574),(5495,7498,0.61252475),(5495,13329,0.58926445),(5495,15710,0.66610974),(5496,2208,0.43458167),(5496,2790,0.76100665),(5496,10437,0.7948896),(5496,17055,0.39652243),(5497,11243,0.57062477),(5497,30757,0.6761016),(5498,2140,0.5825883),(5498,4489,0.18512626),(5498,12775,3.035809e-2),(5498,22013,0.31770036),(5498,25076,0.86354107),(5498,26421,0.621179),(5499,13322,0.16386086),(5499,31356,0.7644214),(5500,3675,0.7294823),(5500,5614,7.054895e-2),(5500,24172,0.9594819),(5500,25223,0.31860447),(5501,8086,3.0809583e-3),(5501,18868,0.51203257),(5501,22039,0.26063904),(5502,1152,0.7217165),(5502,3424,0.8049197),(5502,5538,0.8528887),(5502,6287,0.19408208),(5502,6660,0.25642797),(5502,8290,0.86428005),(5502,8696,0.13356419),(5502,18909,7.154771e-2),(5502,25049,0.3564973),(5502,30877,0.21347593),(5503,208,0.6386977),(5503,829,0.23588915),(5503,25662,0.21021445),(5504,6631,0.24740696),(5504,16455,0.3165841),(5504,19510,0.6927411),(5504,22316,6.0428273e-2),(5504,22758,8.9488305e-2),(5504,22826,3.2898862e-2),(5504,27498,0.37691396),(5505,18765,0.70468503),(5506,1092,0.7222801),(5506,3921,0.55554634),(5506,5330,0.31168896),(5506,7003,0.7841826),(5506,12122,0.86259604),(5506,32245,0.35026753),(5506,32463,0.6883891),(5507,167,6.4444415e-2),(5507,21242,0.27118525),(5507,21930,3.793719e-2),(5507,32694,0.95339817),(5508,4504,0.8422133),(5508,7861,0.75003767),(5508,23857,0.19886138),(5509,7604,0.9423572),(5509,11125,0.5925458),(5509,23977,0.37731847),(5510,1994,0.4561879),(5510,16760,0.98530227),(5510,17250,0.93405265),(5510,21093,0.20909505),(5510,24896,0.71687883),(5511,26630,0.30747148),(5512,21453,0.21930191),(5512,30656,0.46448782),(5513,11829,0.5597796),(5514,10582,0.35980618),(5514,19692,0.7624409),(5515,9308,0.41329038),(5515,19255,0.38446477),(5516,23238,0.16406383),(5516,29201,0.6913014),(5517,1625,8.784046e-2),(5517,2016,0.19117582),(5517,12611,6.512991e-2),(5517,14732,0.25321317),(5517,18748,0.8949603),(5517,20089,0.37923688),(5517,23806,0.656675),(5518,4202,0.8331464),(5518,10449,0.14234029),(5518,12744,0.72297233),(5518,16851,0.62678725),(5518,18810,5.331334e-2),(5518,23911,0.6481051),(5519,5669,7.837159e-2),(5520,4721,0.34257686),(5520,13332,0.32240736),(5520,20818,0.92474127),(5520,25917,0.43846866),(5520,31708,0.18579823),(5521,13882,0.58177656),(5521,15291,0.9179894),(5521,26674,0.5478399),(5522,2713,0.65514266),(5522,9377,0.7669941),(5522,31353,0.43336362),(5523,13714,0.9619711),(5523,19903,0.4713618),(5523,32171,0.46115556),(5524,4123,0.8185289),(5524,11886,0.47443816),(5524,12558,7.515961e-2),(5524,17661,0.42486545),(5524,27198,0.34485543),(5524,32651,0.6766499),(5525,11646,3.5603117e-2),(5525,21746,0.96176696),(5525,28200,0.7373284),(5525,30646,0.732664),(5526,875,3.934181e-2),(5526,13178,0.10293721),(5526,15520,0.8556873),(5526,17114,0.11856281),(5526,30617,0.94154286),(5527,13798,0.4918079),(5527,25728,0.30079174),(5527,28577,9.555467e-2),(5527,31499,0.6219306),(5528,9995,0.55634224),(5528,10714,0.17327847),(5528,15951,0.772886),(5528,16171,0.68446386),(5528,20705,0.4543499),(5528,22544,0.61271805),(5528,25448,0.3388544),(5528,31643,0.798507),(5529,20950,0.9943742),(5529,25306,0.9622173),(5529,28137,0.9388255),(5530,17655,7.2244797e-3),(5530,27277,0.29401302),(5531,24454,5.4877084e-3),(5531,25556,0.69273335),(5531,30302,0.9536437),(5532,6525,0.8469234),(5532,32310,0.5742518),(5533,3295,0.5802808),(5533,8490,0.619662),(5533,20239,0.10240848),(5534,2179,0.4841918),(5534,3479,0.90314686),(5534,7188,0.941257),(5534,11826,0.8939123),(5534,15550,0.34036672),(5534,17275,0.44291124),(5534,21337,0.7544479),(5534,30292,0.5562647),(5535,14985,0.87327987),(5535,20064,0.73212737),(5536,1990,1.3632378e-2),(5536,6012,0.25975543),(5536,13453,0.9560628),(5536,13734,0.1254682),(5536,14078,0.11854463),(5537,75,0.5158506),(5537,4377,1.3339176e-2),(5537,29351,0.82690144),(5538,7214,0.79635864),(5538,10844,0.9337095),(5538,11485,0.93489933),(5538,14773,0.2612437),(5538,18242,0.1988644),(5538,28856,0.33444464),(5539,10469,0.7754859),(5539,14864,0.23689756),(5540,15943,0.13158143),(5540,16526,0.6370699),(5541,6118,0.35324883),(5541,7305,0.28557488),(5541,14817,0.65405357),(5541,25805,5.8524165e-2),(5541,31419,0.5527435),(5542,2588,0.9341078),(5542,3360,0.9743567),(5542,12347,0.27621645),(5542,15534,0.9968871),(5542,22340,0.83305925),(5543,14777,0.13931157),(5543,22105,0.41011083),(5543,25330,0.5926119),(5543,29998,0.63312083),(5544,4439,0.6942885),(5544,26392,9.664904e-3),(5544,30200,9.100771e-2),(5545,622,0.877221),(5545,24792,0.9383832),(5546,14066,0.3902695),(5546,23362,0.17493054),(5546,24131,0.6083585),(5546,26279,0.271438),(5547,4424,0.45928216),(5547,14490,0.64223),(5547,17598,0.84595156),(5547,18357,0.82351303),(5547,19725,0.42539158),(5547,22214,0.95566785),(5547,22667,9.159825e-2),(5547,25951,0.7538092),(5547,27276,0.40908366),(5548,8420,0.9350089),(5548,12954,4.9768414e-2),(5548,17124,0.29922193),(5548,24091,0.46968612),(5549,4172,0.49255982),(5549,15582,0.2369419),(5549,18881,0.78349197),(5549,27965,0.20494904),(5550,8898,0.23267749),(5550,20203,0.93175924),(5550,23550,0.65756303),(5550,25573,0.86978394),(5550,26989,4.9156576e-2),(5551,1892,0.3955436),(5551,13259,0.5008768),(5551,14077,0.115679145),(5551,21323,0.48639947),(5552,15246,0.17823255),(5552,19076,0.3738869),(5552,29182,0.59616125),(5553,1062,0.3082275),(5553,1259,0.19622912),(5553,25962,0.41815817),(5553,31124,1.9389233e-2),(5554,785,0.25835076),(5554,4846,0.20363846),(5554,10043,0.10206395),(5554,14637,0.4544588),(5554,30921,0.68749213),(5554,31103,4.689149e-2),(5555,2066,0.12802187),(5555,18641,0.6743435),(5555,25521,4.752936e-2),(5556,1676,0.8337059),(5556,5078,0.20108598),(5556,8630,0.1726317),(5556,8961,0.85253847),(5556,12987,0.8748126),(5556,13059,0.82847553),(5556,16009,0.80158055),(5556,18041,0.79732394),(5556,18396,0.8223184),(5556,19540,0.9676573),(5557,10551,0.6295774),(5557,15922,0.65091413),(5557,19314,6.6750586e-2),(5557,25693,0.21005423),(5557,27226,0.75532687),(5557,30476,0.15328264),(5558,5529,0.28802013),(5558,10740,0.8238478),(5558,12013,0.898059),(5558,14633,0.11067213),(5558,18179,0.674327),(5558,21160,3.5155043e-2),(5558,21638,0.9061535),(5559,9748,0.43761662),(5559,10104,0.10912532),(5560,1114,0.25866014),(5560,22507,0.40732422),(5560,24300,0.49890226),(5560,32352,0.41398123),(5560,32608,4.2844366e-2),(5561,8628,0.22453223),(5561,26854,9.374698e-3),(5562,5862,6.1206352e-2),(5562,7460,0.5918104),(5562,10157,0.82183087),(5562,14783,0.9021883),(5562,15842,0.12087904),(5562,19504,0.8973706),(5562,25561,0.51917213),(5562,25611,0.35167173),(5563,3130,0.23714505),(5563,7086,5.2979086e-2),(5563,31590,0.4241979),(5564,1190,0.85679376),(5564,7032,0.19230737),(5564,15023,0.82226914),(5564,18909,0.5603059),(5564,20085,0.40787378),(5564,26541,0.34676275),(5565,14800,0.46077862),(5566,30869,0.5564959),(5567,2230,0.5162112),(5567,2811,0.30869582),(5567,2843,0.8850055),(5567,3849,4.742248e-2),(5567,8164,0.3559286),(5567,8945,0.7808205),(5567,21387,0.8543343),(5567,23234,0.6825077),(5568,18677,7.50301e-2),(5568,28132,1.4324786e-2),(5568,29761,0.62618095),(5569,6126,0.6736043),(5569,23692,0.80092734),(5569,32019,0.6805488),(5570,3645,0.21629402),(5570,6085,0.108997315),(5570,8345,0.45262218),(5570,23030,0.6078214),(5570,24837,0.7805023),(5571,2204,0.37218475),(5571,6109,0.36417937),(5571,18674,0.2502363),(5572,1788,0.42203924),(5572,14748,0.99413997),(5573,25428,0.8775594),(5573,26033,0.9603121),(5573,27137,0.22748177),(5573,29910,0.3437395),(5574,5200,0.80160576),(5574,19770,0.4830435),(5575,1703,0.6393973),(5575,6019,9.397505e-2),(5575,10763,0.39280015),(5575,20317,0.83926797),(5575,21603,0.45741308),(5576,720,0.30792),(5576,3342,0.8406767),(5576,7293,0.8178082),(5576,14476,0.16332029),(5576,20179,0.5551409),(5576,23403,3.138841e-2),(5576,23987,0.24838817),(5577,14057,1.7546233e-2),(5577,30951,0.9000506),(5578,341,0.45994747),(5578,2817,0.8787225),(5578,25893,0.2951848),(5579,4543,0.8192169),(5579,10224,0.72716135),(5579,26727,0.83278996),(5579,27400,0.6372658),(5580,9062,0.9080281),(5580,10677,0.6168371),(5580,11067,0.5930686),(5580,11687,0.80754775),(5580,17525,0.91843903),(5580,20771,0.30392355),(5580,23604,9.567706e-2),(5580,23674,0.56388134),(5580,27346,0.37036276),(5580,29164,0.587764),(5580,32170,0.65419614),(5580,32604,0.9993432),(5581,14021,0.5912079),(5581,26186,0.49208614),(5581,32148,0.36107627),(5582,5155,0.6530164),(5582,19469,0.12773925),(5582,22018,9.970683e-2),(5582,26079,0.821879),(5582,28678,0.3016821),(5583,982,0.540542),(5583,11335,0.9629108),(5583,13423,0.3913279),(5583,14468,0.48597023),(5583,24725,0.33351377),(5584,2496,0.93922615),(5584,5051,0.5766339),(5584,18976,0.18214338),(5584,21721,0.6027058),(5585,96,0.20690571),(5585,4127,0.9032306),(5585,19329,0.5298018),(5585,26141,0.65442187),(5585,28213,0.22903728),(5585,31642,0.12250575),(5586,16193,0.24422504),(5587,11226,0.578076),(5588,12325,1.4901429e-2),(5588,14610,0.92553204),(5588,15762,0.59266496),(5589,5627,0.1699049),(5589,6439,0.9605338),(5589,21036,0.34115443),(5590,5540,8.0430344e-2),(5590,9922,0.12339126),(5590,16534,0.5063904),(5590,20760,0.90235907),(5591,3804,0.4031426),(5591,7031,0.5471292),(5591,11599,0.96198165),(5591,14665,0.8884875),(5591,18901,0.30738422),(5591,19190,0.17698325),(5591,20027,7.594683e-2),(5591,28696,0.38526815),(5592,5338,0.7275145),(5592,9418,0.6019861),(5592,24233,0.46735227),(5592,26910,0.5807547),(5593,1362,0.68038905),(5593,2136,0.16791518),(5593,7445,0.21597268),(5593,15934,0.25885212),(5593,22724,0.71377563),(5594,16044,0.5696658),(5594,16756,0.33986205),(5594,16981,0.12947375),(5594,22483,7.811222e-3),(5595,8557,0.7933394),(5596,10871,0.91727537),(5596,24730,0.6145905),(5596,26287,0.7500021),(5597,2658,9.53372e-3),(5597,14771,0.5387032),(5597,26102,7.97587e-2),(5598,9046,0.6301253),(5598,9330,0.47567582),(5598,31583,0.4333233),(5598,32724,0.33227816),(5599,5956,8.687177e-2),(5599,8547,0.877134),(5599,12797,8.234004e-2),(5599,22359,0.44203842),(5600,18459,0.72513074),(5601,16277,0.48716107),(5601,18534,0.36616626),(5601,23416,0.7256445),(5602,6089,0.27526644),(5602,28048,0.104737476),(5602,29755,0.30351815),(5602,30331,0.31857347),(5602,31394,3.3733837e-2),(5603,5982,0.27100468),(5603,9880,0.6550633),(5603,32348,0.5905226),(5604,1081,0.44951537),(5604,7688,0.87490654),(5604,9996,0.3291679),(5604,16769,4.5200318e-2),(5604,32292,0.1334956),(5605,16000,0.7436738),(5605,17032,0.5116604),(5605,17132,1.35272695e-2),(5605,18385,0.6607453),(5605,18537,0.82537687),(5606,3279,0.522279),(5606,15575,0.88651377),(5606,21120,0.103169434),(5606,25741,1.6004813e-3),(5607,25714,0.7043853),(5607,26093,0.5474511),(5607,27400,0.95726043),(5607,29604,0.43288353),(5607,30301,0.42178422),(5607,31433,4.5152202e-2),(5608,4832,0.9843477),(5608,5368,3.0907132e-2),(5608,7968,0.41038215),(5609,22077,0.83625007),(5609,23536,0.66957474),(5609,26666,3.8466863e-2),(5609,31244,0.9817391),(5610,8057,0.5492222),(5610,14252,0.8398361),(5610,25502,3.6338206e-2),(5611,29965,8.96274e-2),(5612,5369,0.5809907),(5612,12574,0.6353168),(5612,13147,0.90426874),(5613,6229,0.2536154),(5613,8871,0.6842933),(5613,23760,6.759227e-2),(5613,29470,0.22309636),(5614,3610,1.3488815e-2),(5614,5864,0.83580977),(5614,14166,0.12831292),(5614,23210,0.6726611),(5614,25781,0.9004642),(5614,28764,0.79780906),(5615,6309,0.43808287),(5615,17141,0.90979964),(5615,21222,0.13610111),(5615,25644,0.35493124),(5616,4425,0.28923038),(5616,15865,0.49387607),(5616,21800,0.73627317),(5616,22831,0.67937076),(5616,26777,0.3005143),(5616,30228,0.5701348),(5616,30932,0.14929505),(5618,1697,0.15886089),(5618,6573,0.76029783),(5618,11327,0.34848782),(5618,23839,0.4777143),(5618,27234,0.348459),(5618,30283,0.45643103),(5619,338,0.13075712),(5619,831,0.6943821),(5619,2977,0.26896772),(5619,18939,0.3171706),(5619,23257,0.34810793),(5619,30996,9.325453e-2),(5619,31239,0.68168396),(5620,2854,0.11642661),(5620,6513,0.6925949),(5620,7896,3.1286135e-2),(5620,11856,0.78215164),(5620,20340,0.63806933),(5620,30469,0.4185443),(5621,2623,0.85708255),(5621,8500,0.94147825),(5621,10761,0.53106344),(5621,20821,0.8328693),(5621,23902,0.96433634),(5621,27106,0.7493149),(5621,27430,0.7449611),(5621,31350,0.6145128),(5622,26071,0.5973614),(5623,11000,0.1555272),(5623,18720,0.38919935),(5623,30929,0.69051665),(5623,31974,0.338299),(5624,2705,0.87255067),(5624,4782,0.7051477),(5624,9268,0.73928964),(5624,9607,0.6559287),(5624,12907,0.2547786),(5624,16218,0.45882368),(5624,16747,0.93053263),(5624,17811,0.37522203),(5625,2516,0.63540673),(5625,12975,0.5584188),(5627,7703,0.6639972),(5627,15029,0.44731072),(5628,8004,0.6707874),(5628,12299,0.7931981),(5628,14473,0.7494364),(5629,5514,0.6148814),(5629,5975,0.1651551),(5629,6920,0.666254),(5629,18671,0.76291704),(5629,28404,0.30058962),(5629,30724,0.7938304),(5630,4835,0.7185468),(5630,10014,0.16196282),(5630,14330,0.79013556),(5630,25751,0.95594436),(5630,28156,0.29508922),(5631,12402,0.20218746),(5631,15055,0.76559144),(5631,19368,0.24947016),(5631,20680,0.9620972),(5631,22395,0.55741847),(5631,26729,0.79170966),(5631,31202,0.446377),(5632,1419,0.40618643),(5632,6616,5.692899e-2),(5632,20299,0.25718892),(5632,21256,0.16856344),(5633,2159,0.8018899),(5633,29468,0.4495647),(5634,2209,0.30620578),(5634,3561,0.22136046),(5634,25683,0.27999082),(5634,28045,0.9533626),(5635,11398,0.20344588),(5635,13477,0.49307454),(5635,21267,0.4471862),(5635,23355,0.5038056),(5635,29002,6.942903e-2),(5635,32590,0.9984588),(5636,4039,0.7122813),(5636,6789,0.57438487),(5636,14156,0.87025845),(5636,18289,0.49667057),(5636,23457,0.9029364),(5637,483,0.26320973),(5637,3540,0.9657535),(5637,9794,0.50987685),(5637,11602,0.19480048),(5637,15955,0.7177987),(5638,22190,0.46354082),(5638,25802,0.7289042),(5639,2705,0.2678021),(5639,3164,0.15619467),(5639,7362,0.6987703),(5639,13958,0.8393062),(5639,20859,0.64322937),(5639,23033,0.35932374),(5639,23366,0.68591267),(5640,2252,0.84275603),(5640,4382,0.94994086),(5640,5108,0.8683163),(5640,5414,0.5642613),(5640,10963,0.59974855),(5640,19613,0.4305317),(5640,20563,0.24910526),(5640,21602,0.99014133),(5640,24563,0.8552591),(5640,27445,0.5223115),(5640,29702,0.9126633),(5641,139,0.1879106),(5641,635,6.1099358e-2),(5641,2697,0.6474246),(5641,4481,3.2269236e-2),(5641,29507,0.86163),(5642,10952,0.6077891),(5642,11702,0.34716022),(5642,14432,0.8943042),(5642,21270,6.406128e-2),(5642,25643,0.7628347),(5642,27574,0.7281883),(5642,28064,0.5152109),(5642,32101,5.120568e-2),(5643,1398,0.15297838),(5643,1474,0.61425513),(5643,19902,0.41737375),(5644,1312,0.68989116),(5644,9325,0.8719592),(5644,12551,0.19703324),(5644,22482,0.47228774),(5644,25915,4.8713103e-2),(5644,32195,0.71907663),(5645,699,0.8997058),(5645,9100,0.59020984),(5645,9534,0.8207439),(5645,10917,0.90940696),(5645,18932,0.9846359),(5645,20900,0.8048123),(5646,10448,0.10220316),(5646,17815,0.6788952),(5646,21393,0.15112317),(5646,21627,0.5812805),(5646,25422,0.40994146),(5646,26644,0.47319493),(5647,8984,0.52002865),(5647,17181,0.7551137),(5647,22499,0.42535388),(5647,26507,4.9811043e-2),(5648,9138,0.35216928),(5648,11952,0.25798804),(5648,27091,0.29757273),(5649,16300,1.0819737e-3),(5649,18725,0.35827363),(5649,23680,0.49886474),(5650,1510,0.7740608),(5650,15572,0.28051206),(5650,18268,0.79270136),(5651,2775,0.8312204),(5651,21346,0.36541423),(5651,21618,0.7431081),(5652,15778,0.63275945),(5652,28808,0.67008764),(5653,12615,0.34493098),(5653,20377,2.985069e-2),(5653,28196,0.26104292),(5653,28640,0.7606753),(5653,29097,0.86354816),(5653,29155,0.72442377),(5653,32067,0.9358101),(5654,86,0.72222644),(5654,12871,4.990674e-2),(5654,16491,0.68819237),(5655,6358,0.68771845),(5655,18704,0.39653218),(5655,29350,0.14222252),(5656,955,0.6539514),(5656,20265,0.2541994),(5657,12305,0.75008476),(5657,12507,0.13282344),(5657,27026,0.7097121),(5657,30238,0.13373175),(5658,1188,0.39143765),(5658,18115,0.6512749),(5658,23350,0.91828),(5658,29346,0.2939075),(5658,30397,0.6794149),(5658,30660,0.16646041),(5658,32387,0.95949876),(5659,4711,0.37235793),(5659,9251,0.9548574),(5659,10407,0.8763079),(5659,25268,0.9515951),(5659,25462,0.599101),(5660,8093,0.876601),(5660,18261,0.49264684),(5660,20818,0.6238153),(5661,15561,0.31060255),(5661,22792,0.94757),(5661,24521,0.4086858),(5661,28277,0.8178512),(5661,30115,0.3653697),(5661,32607,0.29510602),(5662,3490,0.31857833),(5662,7786,0.1874419),(5662,11918,0.13902159),(5662,14301,0.82762426),(5662,15639,0.69148666),(5663,3004,0.47679794),(5663,13239,0.939369),(5663,20686,0.2275113),(5663,24651,0.19808711),(5663,30185,0.9546331),(5664,17645,2.3287047e-2),(5664,26544,0.43209866),(5665,12578,0.63488114),(5665,15053,0.51051885),(5665,29786,7.63164e-2),(5666,5815,0.8853546),(5666,10589,0.39324114),(5666,24110,0.51327866),(5666,31924,0.9807921),(5667,10731,0.1988264),(5667,13488,0.548275),(5667,21546,0.87143564),(5667,26933,0.57021344),(5667,30591,0.17239493),(5668,20294,0.78571665),(5668,20981,0.9896921),(5668,22321,0.22138657),(5668,24075,0.6125176),(5668,24259,0.7918023),(5668,27759,5.0799433e-2),(5669,4843,0.82435465),(5670,13288,6.687266e-2),(5670,30302,0.20042178),(5670,30726,0.37255728),(5671,3401,0.41247818),(5671,5881,0.47770464),(5671,6293,0.7932564),(5671,7905,0.5216011),(5671,12557,0.9842657),(5671,13546,0.7739526),(5671,14346,0.2187913),(5671,16271,0.66585624),(5671,19640,1.4637736e-2),(5672,7605,0.28996164),(5672,15980,2.1374144e-2),(5672,19494,0.4341343),(5672,22291,0.5760337),(5672,26917,0.5386691),(5672,30023,0.7149967),(5673,7522,0.3975088),(5673,21812,7.382595e-3),(5674,553,0.58318835),(5674,14865,0.5893639),(5674,25543,0.58030707),(5675,6709,0.50927114),(5675,14539,0.9300479),(5675,29889,0.8678545),(5675,31372,0.66408116),(5676,6387,0.35631078),(5676,17500,0.9587027),(5676,18113,0.814473),(5676,25952,0.12315756),(5677,9922,0.40094793),(5677,14328,0.86464316),(5677,31164,0.90491325),(5678,305,0.8981092),(5678,2198,0.10881164),(5678,9112,1.0956292e-2),(5678,16226,0.37117875),(5678,18432,0.679725),(5678,29222,0.493257),(5679,9372,0.48724747),(5679,21536,0.23350103),(5680,6981,0.485932),(5680,11274,0.44181457),(5680,13037,0.81631017),(5680,16871,9.339439e-2),(5680,26461,5.225635e-2),(5681,2908,0.7834541),(5681,15071,0.16589817),(5681,19904,0.1415515),(5682,5709,0.34632906),(5682,24993,0.49115962),(5682,28716,0.3552661),(5683,3888,0.37176254),(5683,12985,0.8605364),(5683,13050,1.4425778e-2),(5683,19898,0.5369303),(5683,23385,0.8000616),(5683,30379,0.7861488),(5684,10952,0.8879584),(5684,11506,0.52955353),(5684,14990,0.9982606),(5684,20439,0.11579788),(5684,24706,5.7815272e-2),(5685,2982,0.68978727),(5685,8060,0.22895977),(5685,8362,0.19824454),(5685,21122,0.39779592),(5685,31784,0.36496302),(5686,1155,0.46824947),(5686,4250,0.705763),(5686,13278,0.18810327),(5687,3228,0.22285178),(5687,14951,0.3341539),(5687,26264,0.356189),(5687,32078,0.39939463),(5688,5427,0.25726843),(5688,5931,0.9937895),(5689,211,7.4953903e-3),(5689,17132,0.120791726),(5689,25873,0.30182612),(5689,31001,0.8252486),(5689,31850,0.40780112),(5690,1240,0.9099483),(5690,17741,0.37912342),(5690,26653,0.7639633),(5690,28664,0.11027063),(5690,31056,0.78686184),(5691,2277,0.69264),(5691,9033,0.3155568),(5691,10394,0.96273714),(5691,11748,0.9569595),(5691,15052,0.59460986),(5691,16597,0.52335846),(5691,29653,0.74806994),(5692,8204,0.67938155),(5692,9614,0.4074502),(5692,10975,0.6376907),(5692,12094,0.54952055),(5692,20540,0.99322975),(5692,21932,0.419389),(5693,16909,0.7460873),(5693,19934,0.30925015),(5694,3555,0.69691616),(5694,6465,0.5697403),(5694,20311,0.17635605),(5694,21362,0.5073815),(5694,30756,0.8351045),(5695,29761,0.76411337),(5695,30456,3.5325583e-2),(5696,197,0.7516847),(5696,9144,0.7054286),(5696,10436,0.32379526),(5696,22859,0.287026),(5696,26518,0.94574255),(5697,10264,0.19697666),(5697,23664,0.9204584),(5698,1252,0.6916791),(5698,6921,0.301591),(5698,16880,0.6461381),(5699,3022,0.33847874),(5699,16444,4.7481384e-2),(5699,19091,0.38884324),(5699,21825,0.11624397),(5699,32107,0.51174825),(5700,20637,2.3060145e-2),(5700,22984,0.7651366),(5700,23739,0.36967137),(5700,27325,0.96638125),(5701,14558,0.24929008),(5701,17953,0.26085323),(5701,19144,0.8754256),(5701,31876,0.29556426),(5701,32455,0.44302344),(5702,670,0.35180616),(5702,5304,0.5287404),(5702,7169,0.7270825),(5703,3208,0.73274696),(5703,3456,0.43476057),(5703,9851,0.40039927),(5703,24901,0.6076854),(5703,25836,0.32434353),(5704,8929,0.518465),(5704,10430,0.93905157),(5704,21808,0.30782124),(5705,6419,0.6325964),(5705,12754,0.3763121),(5705,18058,0.5371314),(5705,22731,0.99032706),(5705,27141,0.53184104),(5706,115,0.67725587),(5706,2994,0.22842586),(5706,7546,0.9824225),(5706,19026,0.7495609),(5706,21578,0.5034365),(5707,18658,0.738629),(5707,27934,0.23168865),(5708,7020,0.64320797),(5708,11608,0.30975744),(5708,22733,0.17314687),(5708,28976,0.85999906),(5708,29802,0.62665087),(5709,2181,0.65695035),(5709,11345,0.37415552),(5709,16950,0.22280182),(5709,18881,0.45717773),(5709,23417,0.19453453),(5710,20648,0.27428842),(5710,20748,0.6213082),(5710,27167,0.8836221),(5711,68,0.1297405),(5711,8741,0.21444844),(5711,13409,0.7140716),(5711,25764,0.6018513),(5712,3969,0.985149),(5712,11279,0.59143394),(5712,31771,0.5378236),(5713,5270,0.37643063),(5713,6929,0.43959397),(5713,11017,0.3418818),(5713,11633,0.41164872),(5713,29846,0.39121827),(5713,30319,0.58630407),(5714,9368,0.10582886),(5714,11542,0.15505046),(5714,28694,4.907642e-2),(5714,32440,0.94621336),(5715,24127,0.71485645),(5715,24156,0.93803185),(5715,30792,0.12630272),(5715,32109,0.123973005),(5716,11716,0.23319435),(5716,24935,0.18575054),(5716,27644,0.30894825),(5717,14605,0.43714535),(5717,16129,0.84489495),(5717,19173,0.6137656),(5717,24360,0.20018528),(5717,25367,0.9514281),(5718,948,0.42319703),(5718,1550,3.4478944e-2),(5718,4205,0.69746834),(5718,11318,0.52607596),(5718,12460,0.8390773),(5718,32691,0.53267443),(5719,2618,0.3555131),(5719,3238,0.14260799),(5719,13189,0.89766896),(5719,15119,0.34744766),(5719,16438,0.97635716),(5719,20518,0.33811253),(5720,11959,0.1436823),(5720,12127,2.4009274e-2),(5720,18039,0.6293365),(5720,23973,0.56117857),(5721,13392,0.32899785),(5721,25310,0.33171752),(5723,21892,0.6262677),(5723,32236,0.42937052),(5724,333,0.6790832),(5724,7509,0.5975095),(5724,11804,0.17617473),(5724,29150,0.71144176),(5724,30396,0.5284745),(5724,31533,0.40473288),(5725,6004,3.6700223e-2),(5725,6019,0.90919644),(5725,6877,0.6348974),(5725,17991,0.7595393),(5726,13067,3.8856782e-2),(5726,14541,0.69561213),(5726,20866,1.53701035e-2),(5726,32531,0.8515803),(5727,13049,0.3022846),(5727,17829,0.35954583),(5727,18192,0.9766721),(5727,22751,0.21198727),(5727,30247,0.25556147),(5728,784,0.5704708),(5728,9084,0.7731344),(5728,12657,0.39762652),(5728,15016,0.96437967),(5728,19587,0.3811622),(5728,23699,0.6554656),(5729,2875,9.594944e-2),(5729,7710,0.8103538),(5729,7718,0.5885259),(5729,9056,0.7524417),(5729,13847,0.8258788),(5729,16028,0.23394519),(5729,17599,0.7628818),(5729,26277,0.4276965),(5729,26634,1.4707236e-2),(5730,1921,3.3080385e-3),(5730,13305,0.8794265),(5731,7309,0.59627354),(5731,7363,0.82130104),(5731,11014,0.41520035),(5732,6718,0.6198456),(5732,10922,0.89779085),(5732,15074,0.74106294),(5732,20383,0.5577609),(5732,29312,0.94885176),(5732,32716,9.408761e-3),(5733,574,3.725069e-2),(5733,10844,0.7741076),(5733,13257,0.5926294),(5733,18108,0.2954992),(5733,26714,0.4322551),(5733,27011,0.73267996),(5734,4982,0.6986206),(5734,30456,0.49426383),(5735,1852,0.85030955),(5735,2108,0.15614031),(5735,12859,0.13442096),(5735,13930,0.12147377),(5735,26676,0.594328),(5736,4407,0.16846529),(5736,16054,0.45494008),(5736,19996,0.9036734),(5736,23022,0.60858077),(5736,28080,0.85450786),(5737,5288,0.4489725),(5737,22985,0.35112202),(5737,28855,0.88968337),(5738,4748,0.76496714),(5738,9736,0.7138797),(5738,24240,0.9660452),(5738,26688,0.73231554),(5738,27231,0.6933248),(5738,32375,0.9799509),(5739,3753,0.8790975),(5739,5475,0.58028156),(5739,18899,0.44807258),(5739,27414,0.4192172),(5739,29612,0.56387854),(5740,6840,0.91242373),(5740,7342,0.29230782),(5740,10119,0.50155616),(5740,17567,0.47099558),(5740,18121,0.97453576),(5740,22016,0.11850823),(5740,31805,0.25735417),(5741,13093,0.2626168),(5741,15665,0.9318779),(5741,30849,0.5945575),(5741,31794,0.24580573),(5742,3490,0.4138967),(5742,6761,0.8737922),(5742,26859,0.98422617),(5743,8291,0.8720812),(5743,15316,0.49310973),(5743,27361,0.1252264),(5744,2291,0.7564416),(5744,4667,0.99411213),(5744,10141,0.5600172),(5744,10440,0.8058827),(5744,13444,0.36511776),(5744,14725,0.9942826),(5745,4435,0.12570056),(5745,9488,0.98092175),(5745,25476,0.69270134),(5745,30997,0.12385432),(5746,5616,0.99542785),(5746,7395,0.4415411),(5746,9780,0.26937884),(5746,13057,9.673755e-3),(5746,14674,0.46078825),(5746,15047,0.7319888),(5746,20841,9.9656835e-2),(5747,10274,0.26391476),(5747,25322,0.7875655),(5747,26529,6.071782e-2),(5748,8969,0.2699293),(5748,17409,5.1960677e-2),(5748,21021,0.5791118),(5749,1434,3.344904e-2),(5749,12154,0.7658431),(5749,29782,0.55741036),(5749,31045,0.3321698),(5750,5183,0.64924324),(5750,15337,0.72840154),(5750,27304,0.3150822),(5750,29025,0.82624507),(5751,5171,0.24014384),(5751,19608,0.47750056),(5751,22622,0.944349),(5751,26383,0.29270732),(5751,27875,0.5085389),(5752,7660,0.35554394),(5752,11550,0.8408528),(5752,12191,0.45132157),(5752,16850,0.59971267),(5753,993,0.22730094),(5753,14823,0.85525036),(5753,29840,0.5843395),(5753,32268,0.68593025),(5754,13221,0.32813978),(5754,17292,0.9556595),(5754,24743,0.9211113),(5755,5266,2.368283e-2),(5756,10706,0.61651635),(5756,27091,0.31297126),(5757,9404,0.73671263),(5757,13757,0.9034953),(5757,29241,0.6043102),(5759,2185,0.105933584),(5759,16830,0.44246927),(5759,16913,0.93960357),(5759,26845,0.9799716),(5760,7604,0.31242582),(5760,8607,0.13804238),(5760,25147,0.81304485),(5760,31540,0.760103),(5761,4282,0.2692467),(5761,15462,0.33817413),(5761,18326,0.9728188),(5761,21090,0.64592695),(5761,26590,0.24745199),(5762,1597,0.36140913),(5763,404,0.3919392),(5763,4770,0.43259495),(5763,5366,0.35794696),(5763,6839,0.6815568),(5763,9072,0.29743078),(5763,17190,0.27052405),(5763,19610,0.9160076),(5763,23489,0.9871717),(5764,1741,0.42130223),(5764,10307,0.5505137),(5764,18090,0.72507566),(5764,29091,0.3797253),(5765,6765,0.693099),(5765,17014,0.17047904),(5766,1660,0.15682428),(5766,6293,0.62150586),(5766,17165,0.74259496),(5766,26084,0.32511178),(5766,32081,0.6789111),(5767,1601,0.46726212),(5767,4014,0.27104715),(5767,7350,0.55186045),(5768,1215,0.73273885),(5768,23014,7.135226e-2),(5768,24586,0.86014974),(5768,29051,0.43280274),(5768,31481,0.58857197),(5769,304,0.6589274),(5769,31716,0.45223033),(5770,2679,0.3508502),(5770,5943,0.5519615),(5770,14709,0.3786089),(5771,4552,0.574309),(5771,7559,0.6253635),(5771,7754,0.32862696),(5771,14495,0.6325556),(5771,17474,0.6807008),(5772,5103,0.9173396),(5772,21517,0.7013532),(5772,27174,0.5185523),(5773,4448,0.7642978),(5773,7612,9.739462e-2),(5773,29641,0.11379928),(5774,3107,0.9104317),(5774,6634,0.12920517),(5774,12679,0.8860538),(5774,15547,0.65366095),(5774,30944,0.56575),(5775,12506,0.79791373),(5775,14740,0.25054806),(5775,20505,0.12460313),(5776,1574,0.31184226),(5776,5644,2.3591641e-2),(5776,13228,0.91598445),(5776,20522,0.44599178),(5776,31630,0.88513935),(5777,7734,0.34956855),(5777,9854,0.20327887),(5777,23756,0.5500163),(5777,28790,9.585007e-2),(5778,2802,0.60629594),(5778,5572,7.01819e-2),(5778,8046,0.29054755),(5778,8556,0.4475872),(5778,15994,0.78040683),(5779,665,0.750319),(5779,10816,0.6983594),(5780,11480,0.84457743),(5780,12078,0.5093364),(5781,3014,0.44881442),(5781,3393,0.50744224),(5781,5245,0.530708),(5781,7894,0.2299388),(5781,10249,0.72765595),(5781,19869,0.843807),(5781,24034,0.80035514),(5781,27075,0.7387644),(5781,28386,0.39347327),(5781,28620,0.28797388),(5782,17114,0.33621523),(5783,11027,0.91517586),(5783,14455,0.6367167),(5783,15069,3.166389e-2),(5783,15838,0.2776977),(5783,26760,0.809722),(5784,11669,0.86380947),(5784,17419,0.88287026),(5784,31044,7.231139e-2),(5785,2480,0.11128551),(5785,10595,0.53682745),(5785,21104,0.15723084),(5785,24808,0.5656821),(5785,28597,0.7165438),(5786,5732,0.10151398),(5786,6555,0.6289529),(5786,10195,0.32497814),(5786,21465,0.3134846),(5786,30492,0.22766773),(5787,4348,7.275814e-2),(5787,11662,0.28231838),(5787,20203,0.7368736),(5787,24033,0.5985441),(5788,5617,0.4329243),(5788,12199,0.53318024),(5788,14986,5.272829e-3),(5788,19831,0.35482734),(5789,59,0.77562404),(5789,5098,6.973397e-2),(5789,13135,0.9572491),(5789,15549,0.12133815),(5789,19864,0.69774514),(5789,25109,0.3209141),(5789,29433,0.5013054),(5789,29919,0.51421946),(5789,31697,0.13177906),(5790,1000,0.6257196),(5790,5087,0.33326927),(5791,4160,0.1592099),(5791,6150,0.32666257),(5791,7083,0.533869),(5791,17024,0.13312782),(5791,28471,0.5516121),(5791,30506,0.99811226),(5792,13378,0.9988575),(5792,19018,0.16102721),(5792,24885,0.2602947),(5792,25889,0.5602213),(5793,6142,7.166033e-2),(5793,6756,0.5744869),(5793,7666,1.4660887e-2),(5793,11770,0.93463635),(5793,29662,0.73064303),(5794,5201,1.21139195e-2),(5794,6311,0.52928275),(5794,18615,0.98667693),(5794,21520,0.7994541),(5795,11450,0.5161822),(5795,14116,0.7175915),(5795,27722,0.6723379),(5795,32302,0.9572287),(5796,9249,0.5893352),(5796,10510,0.23591383),(5796,21466,0.72127795),(5797,2370,0.42450714),(5797,5907,0.59295565),(5797,18715,0.5624821),(5797,24127,0.9933456),(5797,24910,0.48446995),(5798,29606,0.2194232),(5798,30514,0.7777272),(5799,8394,0.6129914),(5799,13659,0.21809383),(5800,15682,0.1308381),(5800,25922,0.54558355),(5800,26258,0.6770029),(5800,30362,0.3177941),(5801,1295,0.34676343),(5801,8301,0.9908841),(5801,25421,0.6211839),(5801,27113,0.3017032),(5803,2419,0.81856817),(5803,18106,0.9452122),(5803,21237,0.6328332),(5803,23206,0.85209066),(5803,26122,0.42005843),(5803,31799,0.7417272),(5804,13503,0.7430504),(5804,23668,0.67009115),(5805,9029,0.10429966),(5805,17010,0.96399754),(5805,18641,0.63170016),(5805,26847,0.32653657),(5805,28922,0.6719877),(5806,3748,0.60302883),(5806,12848,0.5416219),(5806,14725,0.48171613),(5806,27106,0.902214),(5807,12837,0.5806916),(5807,20247,0.84582263),(5808,1484,0.7590372),(5808,24106,0.5433199),(5809,5803,6.315844e-2),(5809,12179,0.552938),(5809,29374,0.34463432),(5810,16247,0.6122524),(5810,27999,0.13648674),(5811,1195,0.47128108),(5811,7636,0.3140519),(5811,13257,0.1274601),(5811,13698,0.10936621),(5811,15075,0.4662887),(5811,17004,0.48121503),(5811,23987,0.3305938),(5811,24177,6.1949708e-2),(5812,12311,0.19289042),(5812,12558,0.17415065),(5812,13605,0.21732764),(5812,15319,0.2036111),(5812,25912,0.5284033),(5813,18981,0.25332707),(5813,26717,0.104587175),(5813,32667,0.21056113),(5814,2383,0.7850774),(5814,17060,0.46332175),(5814,23618,0.18449327),(5815,6996,0.8494177),(5815,11282,0.738256),(5815,27724,0.96552485),(5816,7583,5.0856568e-2),(5816,12503,0.95973575),(5816,13125,0.5999197),(5816,19472,0.5040341),(5816,29773,0.4518448),(5816,32655,0.12595901),(5817,23765,0.5130185),(5817,25305,0.22710681),(5817,28453,0.5751517),(5817,31324,0.4780512),(5818,4264,0.7369531),(5818,9704,0.7268144),(5818,12185,8.772296e-2),(5818,12625,0.5754536),(5818,18328,0.7467526),(5818,19022,0.40147448),(5818,20486,0.92226106),(5818,30211,0.88617194),(5819,5338,0.41976804),(5819,15277,0.2183166),(5819,30325,0.49209535),(5819,32590,0.5123472),(5820,1043,0.20416419),(5820,1152,0.45433176),(5820,19478,0.84567696),(5821,10965,0.7166846),(5821,13407,0.27954608),(5821,20155,0.7286868),(5821,20839,0.61854565),(5821,24474,0.21690919),(5821,25500,0.2031328),(5822,9146,0.69377106),(5822,24756,0.9295206),(5823,1188,0.3193657),(5823,18035,9.820084e-2),(5823,29655,3.4147403e-3),(5823,31555,0.5966827),(5824,7754,2.0082759e-2),(5824,9026,0.8656659),(5824,29040,0.9893274),(5824,29141,0.95032644),(5825,4519,0.50395554),(5825,11249,0.23945329),(5825,14961,0.5190493),(5825,19435,0.29512018),(5826,977,0.98304063),(5826,1219,0.8356315),(5826,3697,0.57083875),(5826,10926,0.5729194),(5826,24032,0.810438),(5826,27173,0.1146539),(5827,24289,0.6178409),(5828,17,0.98761743),(5828,3392,0.9208917),(5828,4259,0.11202475),(5828,25233,0.5158573),(5828,30970,0.31278208),(5828,32210,0.23172359),(5829,2529,0.7065911),(5829,3744,0.28230172),(5829,4057,0.8622985),(5829,9710,0.37244213),(5829,12958,0.5641978),(5829,13694,0.7401423),(5830,328,0.94454044),(5830,3845,0.577535),(5830,5145,0.30429912),(5830,25984,0.39703017),(5830,31849,0.9276754),(5831,833,0.5796007),(5831,884,0.68608),(5831,12338,0.8697787),(5831,12576,0.2157875),(5831,31434,5.179601e-2),(5832,13448,0.9971196),(5832,13775,0.79056764),(5832,20575,0.9124299),(5832,28922,0.47753948),(5833,497,0.16884826),(5833,7807,0.1569249),(5833,11058,0.63541996),(5833,22974,0.8310242),(5833,30936,0.14639163),(5834,5355,0.6653605),(5834,15126,0.47183284),(5834,19394,0.34272876),(5834,25682,0.31544358),(5834,32394,0.15124735),(5835,22437,0.8760182),(5835,23627,0.18315195),(5835,25314,7.164425e-2),(5835,25720,0.2669658),(5835,28146,0.45251828),(5836,12420,0.9069173),(5836,18324,0.26448828),(5836,18780,0.9583063),(5836,25782,0.37074003),(5836,28397,0.33352536),(5837,2264,0.3877982),(5837,10105,0.71693),(5837,12309,0.7883241),(5837,23371,0.47562644),(5837,26876,0.41224483),(5838,5289,0.94977564),(5838,8614,0.596488),(5839,7,0.26008764),(5839,5132,0.43127),(5839,14563,0.96262884),(5839,14962,7.5347446e-2),(5839,21246,0.5689773),(5840,8196,0.38182172),(5840,12082,0.27529272),(5840,14947,9.249727e-2),(5840,20968,0.44993934),(5840,22866,0.33002138),(5840,26809,0.8497906),(5840,28750,0.5724156),(5841,29205,0.7379467),(5841,30341,0.99244964),(5841,30974,0.70187443),(5841,31843,0.93429345),(5842,122,0.828045),(5842,2016,3.580509e-2),(5842,13863,0.85144377),(5842,28715,0.9218073),(5842,30917,0.50113034),(5843,129,0.759904),(5843,29511,6.0156778e-2),(5843,29713,0.9567915),(5844,5874,0.31130597),(5844,8210,0.59282047),(5844,30125,0.6290035),(5845,23290,0.433855),(5846,9000,0.7362773),(5846,14551,0.14574447),(5846,18828,0.8233072),(5846,29853,0.59513414),(5846,29927,0.60374063),(5847,1767,7.684558e-2),(5847,7747,0.60090286),(5847,8906,0.79161716),(5847,9075,0.10110015),(5847,29609,0.44393054),(5848,13636,0.5766079),(5848,18552,0.9315076),(5848,18858,0.88809216),(5848,24807,0.48206297),(5848,25835,0.6860326),(5848,29614,1.3949295e-2),(5849,16370,0.6835452),(5849,19928,0.26677075),(5850,2136,0.58197695),(5850,5100,0.23172338),(5850,7583,0.1802281),(5850,11713,0.25219357),(5850,12882,0.1388088),(5850,18079,0.7386078),(5850,22243,0.320073),(5850,27760,4.0553287e-2),(5851,4014,0.7227773),(5851,7115,0.8770066),(5851,23455,0.26379755),(5851,29379,6.7418925e-2),(5852,13104,0.4574579),(5852,28980,0.75933456),(5852,30465,0.9381499),(5853,6677,0.390281),(5853,24341,0.34424117),(5853,26944,2.8496174e-2),(5853,26982,0.5400807),(5854,3965,7.517608e-2),(5854,10754,0.5814522),(5854,10858,0.5646293),(5854,11394,0.5182902),(5854,13939,0.61463237),(5854,18982,0.64990497),(5854,20017,0.46978265),(5854,20589,0.18976241),(5854,24301,0.15370125),(5854,27836,0.33741245),(5855,3708,5.2958015e-2),(5855,14079,0.43233338),(5855,31927,0.91068184),(5856,473,0.8921741),(5856,12614,0.7048147),(5856,17354,0.18934679),(5856,17981,0.31734022),(5856,23019,0.31693074),(5856,24355,0.5565637),(5857,2262,0.8929704),(5857,7408,0.57667416),(5857,10093,7.600504e-2),(5858,16331,0.5661111),(5859,616,0.6408713),(5859,3915,0.80354685),(5859,9364,0.11758756),(5859,29489,0.74516857),(5860,5365,0.937373),(5860,15606,0.30276892),(5860,19473,0.9725529),(5861,22020,0.3031489),(5861,25089,0.1590479),(5862,1092,5.8400318e-2),(5862,5640,0.56586987),(5862,13193,0.34084767),(5862,30668,0.80663836),(5863,3094,0.9226909),(5863,24166,2.6562933e-2),(5863,28176,0.6675928),(5864,10584,0.11725273),(5864,12091,0.91970724),(5865,4764,0.5644198),(5865,5411,0.30155873),(5865,6682,0.50772446),(5865,7075,0.6096852),(5865,19618,0.8868002),(5865,32656,0.49311563),(5866,11334,0.86205626),(5866,29099,0.22348148),(5867,18261,0.4969737),(5867,19531,0.1998931),(5867,22830,0.5615284),(5867,23354,0.36241058),(5868,10436,0.5529255),(5868,10641,0.9208911),(5869,3763,0.1884725),(5869,7162,0.93531626),(5869,10379,0.12961903),(5869,16858,0.28471002),(5869,27007,0.23023939),(5870,10819,0.74482346),(5870,17718,0.7396396),(5870,32120,0.19891462),(5871,4797,3.7518974e-2),(5871,13749,0.55404127),(5871,17354,0.42878646),(5871,19970,0.37224376),(5871,21682,0.2552379),(5872,5547,0.27437437),(5872,8731,0.17768654),(5872,8778,0.1406737),(5872,15389,0.63720846),(5872,28128,0.65327835),(5873,2386,0.87620085),(5873,4179,0.5424764),(5873,4474,0.27180818),(5873,16533,6.315999e-2),(5873,21332,0.20635143),(5873,21788,0.5423943),(5873,26643,0.8437847),(5874,5325,0.9804664),(5874,20444,0.40210062),(5874,24556,0.74205446),(5874,25977,0.72030413),(5874,26805,0.56005657),(5874,26962,0.105375335),(5875,15256,0.8111449),(5875,19891,0.3865603),(5875,28297,0.5035898),(5876,23698,0.9279249),(5877,6325,0.9918419),(5877,17533,0.75961214),(5877,26419,0.78022367),(5878,10646,0.44919547),(5878,16378,0.7106464),(5878,20037,0.3326967),(5878,25630,0.8623959),(5878,26665,0.22038946),(5878,32609,7.05503e-2),(5879,10362,0.3409548),(5879,28763,0.75147766),(5880,6248,0.71180856),(5880,20494,0.42984957),(5880,21696,0.19985023),(5881,6563,0.43677613),(5881,7470,5.52484e-2),(5881,7520,0.5669749),(5881,8543,0.43128768),(5881,9741,0.82190275),(5881,17871,0.6198824),(5881,19564,1.2132429e-2),(5881,22799,0.478169),(5881,29502,0.40088513),(5881,30128,0.8077693),(5882,2162,0.53076625),(5882,6635,0.18158025),(5882,30233,0.32036564),(5882,31404,1.2094898e-2),(5883,6609,0.6008466),(5883,10386,0.9346528),(5883,15938,0.13855647),(5884,17755,0.6252775),(5884,20650,0.13967188),(5885,26941,0.9641729),(5886,6454,9.762036e-2),(5886,7565,8.55839e-2),(5886,9319,0.69510126),(5886,11627,9.022471e-2),(5886,11783,0.49061817),(5886,24685,0.22494704),(5887,19000,0.37038288),(5888,303,0.94329417),(5888,17174,0.86810696),(5888,30304,0.38701358),(5890,15696,9.3733616e-2),(5891,2921,0.26139954),(5891,3800,0.6768221),(5891,11056,2.6514985e-2),(5891,11950,0.17304842),(5891,28322,4.029335e-2),(5892,988,0.16911723),(5892,6235,0.7919607),(5892,9279,0.24595463),(5892,21325,0.3585472),(5892,24540,0.5827949),(5892,24813,0.78549755),(5892,29984,0.124795385),(5893,674,0.4784654),(5893,1927,0.35837346),(5893,16643,0.5869712),(5893,26035,0.49246487),(5894,10482,6.735735e-2),(5894,15364,0.29654837),(5894,15814,0.27221954),(5894,30093,0.27488747),(5895,19637,0.91203463),(5895,21036,0.15678881),(5895,25915,0.70295966),(5896,5691,0.5185564),(5896,7984,0.68929505),(5896,21322,0.48201972),(5897,1235,0.26339215),(5897,9575,0.1081206),(5897,16123,0.24817966),(5897,16420,8.3535716e-2),(5898,239,0.3798157),(5898,2333,0.19844592),(5898,3620,0.26290232),(5898,6387,0.5571136),(5898,8431,0.18020386),(5899,15174,9.14107e-2),(5899,31019,0.36857706),(5900,12448,0.5500757),(5900,13717,0.114521466),(5900,16695,4.4047933e-2),(5901,11270,0.81905884),(5901,15213,0.23760742),(5901,20060,0.22030613),(5902,18915,0.2270749),(5902,24111,0.7592285),(5903,14021,5.3881384e-2),(5903,19655,0.9072687),(5903,30577,0.86071247),(5903,30801,0.31621543),(5904,3399,3.358354e-2),(5904,4755,0.52312696),(5904,11017,0.4028009),(5904,16086,0.5548529),(5904,23611,0.8110363),(5904,30196,9.974355e-4),(5904,30964,0.9013477),(5904,31329,0.8669755),(5905,2865,0.17433856),(5905,6051,0.2281526),(5905,14917,0.63295335),(5905,20184,0.64876974),(5905,24956,4.6084806e-2),(5905,26890,0.829403),(5905,31245,0.44965497),(5905,31731,0.29322058),(5906,8145,0.86747235),(5906,15634,0.15317276),(5906,28760,0.55831504),(5908,4970,0.44185317),(5908,6845,0.74426144),(5908,9410,1.874736e-2),(5908,10004,0.13432403),(5908,26529,0.5644468),(5908,28928,0.29966906),(5908,32034,0.10588664),(5909,4963,0.90957826),(5909,24921,5.1875502e-2),(5909,29059,0.16682217),(5909,29806,0.6233479),(5909,31770,0.90055346),(5910,5231,0.87460107),(5910,15660,0.9016922),(5910,18841,0.4456518),(5910,29547,0.23117532),(5910,31104,0.7938238),(5911,1337,0.47820422),(5911,3394,0.73783344),(5911,5953,0.3419498),(5911,8849,0.47803763),(5911,12246,0.8940361),(5911,29057,0.41872337),(5912,9386,0.80277514),(5912,20822,0.96902084),(5912,27828,0.37060195),(5913,3284,5.9215758e-2),(5913,4660,0.4906987),(5913,15544,0.24982636),(5913,15856,0.35105616),(5913,18003,0.7539432),(5913,21498,0.6446148),(5913,24431,0.16139211),(5913,29465,0.35417873),(5913,31148,0.12773886),(5914,5168,0.62457764),(5914,15174,0.15508835),(5914,16486,3.1817246e-3),(5914,19541,0.1272363),(5914,27732,0.6341434),(5915,2872,0.1900628),(5915,3740,0.67687184),(5915,17615,0.31503925),(5916,1394,0.44570068),(5916,12527,0.32730252),(5916,22621,0.3494709),(5916,22730,0.79778135),(5917,323,0.26064008),(5917,12317,0.22272399),(5917,25966,0.35279134),(5917,30659,0.41116256),(5918,8913,0.7092629),(5918,21015,0.48786607),(5918,24134,0.3383294),(5919,14621,0.59632784),(5920,9357,0.57922703),(5920,11255,0.27749735),(5920,14057,0.6579191),(5920,15125,0.82996815),(5920,17798,0.31214407),(5920,29388,0.3703017),(5921,9820,0.6224691),(5921,15493,0.44568592),(5921,19960,0.21742368),(5921,21758,0.16799921),(5921,22199,0.6996172),(5921,25175,0.10396093),(5922,7868,0.9774425),(5923,493,0.37525836),(5923,13850,9.249764e-2),(5923,21360,0.22981808),(5923,26600,0.43288696),(5923,26771,0.4958773),(5924,29249,0.37354177),(5925,12711,0.5147055),(5925,13693,0.642253),(5925,15907,0.12843335),(5925,16391,0.35181376),(5925,25220,0.3379217),(5926,783,0.5428219),(5926,20370,0.86774015),(5926,32058,2.0998104e-2),(5927,1574,0.20991184),(5927,3195,0.22648795),(5927,17613,0.9673117),(5927,18466,0.22575827),(5927,22005,7.017477e-2),(5927,31779,0.5288039),(5928,551,0.83205944),(5928,1418,0.40052953),(5928,9285,0.29253104),(5928,10419,0.1830036),(5928,10653,0.20346543),(5928,14906,0.694609),(5928,18881,1.253297e-2),(5928,32606,0.51818466),(5929,1892,0.38978648),(5929,3692,0.83021176),(5929,12220,0.70284986),(5929,20118,0.25327116),(5929,24895,0.28974256),(5929,31215,0.998525),(5930,4842,0.8464395),(5930,4850,0.9889699),(5930,12149,0.10260446),(5930,15152,0.5372152),(5931,10153,0.73383486),(5931,15009,0.44945422),(5931,23268,0.8773095),(5932,7850,0.46154568),(5932,16302,0.6390066),(5933,12299,0.42401809),(5933,25080,0.5825538),(5934,357,0.97544765),(5934,8709,0.63604057),(5934,22870,0.968436),(5935,8138,0.8622142),(5935,11576,0.6597329),(5935,19297,0.98425496),(5936,11388,2.4261538e-2),(5936,16624,0.2095079),(5936,25322,0.42746884),(5937,14100,5.3291887e-2),(5937,16234,0.870444),(5938,1629,0.7403698),(5938,6032,0.70079195),(5938,7452,0.91085124),(5938,8295,0.85298085),(5938,14174,0.17457014),(5938,24231,0.7374244),(5938,24859,2.3651268e-2),(5938,25562,0.7980294),(5939,14610,0.22041446),(5940,1747,0.23354952),(5940,32035,0.58684146),(5941,7448,0.44698256),(5941,12111,0.29844058),(5941,17161,4.6766736e-2),(5941,30193,0.59286743),(5941,30727,0.61723375),(5942,6496,0.764228),(5942,19989,0.995516),(5942,23815,0.17737521),(5942,31955,0.21071036),(5943,7421,0.38239753),(5943,9247,4.2802207e-2),(5943,11790,0.41824844),(5943,28149,0.82632124),(5943,28303,0.35808438),(5943,29637,0.60156244),(5944,14615,0.109423384),(5944,16163,0.8191104),(5944,24492,0.5219266),(5945,7604,0.6246884),(5945,13860,0.94063646),(5945,18214,0.70980394),(5946,10385,0.5544216),(5946,22609,0.4604639),(5946,24775,0.42606676),(5946,25555,0.6579849),(5946,28485,0.24145316),(5946,29512,0.5685893),(5946,30954,0.7963822),(5947,483,0.56942856),(5947,6504,0.92551315),(5947,12419,0.3508432),(5947,17227,0.53563446),(5948,2199,0.9373539),(5948,2849,0.4797061),(5948,10580,0.5666348),(5948,18961,0.7013077),(5948,19166,0.21689174),(5948,26902,0.43541464),(5949,7644,0.64181685),(5949,10793,0.5399534),(5950,18790,0.86262935),(5950,20361,0.3900659),(5950,27772,9.7185396e-2),(5951,1246,0.9271797),(5951,22624,0.25673163),(5951,29669,0.3899366),(5951,31421,0.90523434),(5952,18365,0.96880835),(5952,23413,0.55465126),(5952,27050,0.20178063),(5952,28251,0.56243134),(5952,30573,0.77386326),(5953,4137,0.63203967),(5953,7452,8.244041e-2),(5953,21385,0.37338516),(5953,22109,0.24613895),(5954,18000,0.17646317),(5954,21059,0.45141175),(5954,24411,0.29675636),(5954,28175,0.964213),(5955,4813,6.536352e-3),(5955,10330,0.4896509),(5955,18422,0.95656157),(5955,30386,0.60663164),(5955,30532,0.39101973),(5956,1264,0.53093994),(5956,1742,0.9727173),(5956,8536,0.9253089),(5956,10382,0.38658607),(5956,12420,0.27747557),(5956,13541,0.7801251),(5957,6219,0.25644234),(5957,11703,0.19653772),(5957,20362,0.8291521),(5958,1840,0.58826166),(5958,13642,0.84046674),(5958,14529,0.73041266),(5958,29424,0.73015606),(5958,31900,0.76056516),(5959,12318,0.5635528),(5959,15090,0.9509143),(5960,419,0.20192024),(5960,25631,0.42708856),(5960,27020,0.19428587),(5960,29353,0.79864806),(5961,243,0.89196527),(5961,17724,0.82642317),(5961,29099,0.5278914),(5961,32578,0.13876289),(5962,1584,0.39982143),(5962,1992,0.24814996),(5962,14809,0.7326711),(5962,28178,0.93688744),(5963,947,0.6988159),(5964,14035,0.5301338),(5964,20357,0.7469535),(5964,27593,0.7120096),(5964,31864,0.6862701),(5965,17021,0.22816227),(5965,18874,0.6889771),(5965,27614,7.965443e-2),(5966,9773,0.43619913),(5966,30162,0.19224516),(5967,6889,0.18583928),(5967,9580,0.5613888),(5967,13655,4.5064285e-2),(5967,14988,0.27160758),(5968,2766,0.60784656),(5968,10180,0.8839374),(5968,16221,0.51156896),(5968,21985,0.18370573),(5969,5633,0.9615362),(5969,12394,7.5127415e-2),(5969,23638,0.5341396),(5970,3330,0.3230517),(5970,7860,0.8454932),(5970,24447,0.11593746),(5970,29118,4.1556716e-2),(5970,29629,0.8928812),(5970,32407,0.9933993),(5970,32566,0.85552347),(5971,4549,0.2075748),(5971,15739,0.5581784),(5972,17531,0.22008719),(5972,18178,0.19507757),(5972,20959,0.4891175),(5972,21496,0.7166291),(5972,21843,0.33769378),(5972,32439,0.37760565),(5973,23705,0.5633398),(5974,11449,0.75066787),(5975,7179,0.6900212),(5976,3031,0.13709278),(5976,26545,0.6108731),(5976,29056,0.18489559),(5977,4541,0.70832705),(5977,5808,0.5926659),(5977,11634,0.9366481),(5978,26986,0.5139803),(5979,7329,0.16751385),(5979,11612,0.7250892),(5979,12518,0.30726355),(5979,13080,0.1338229),(5979,17748,8.617937e-2),(5980,7582,0.21796289),(5980,8995,0.5311316),(5980,10466,0.76656866),(5980,20575,0.8701994),(5980,25996,0.813567),(5981,2189,0.55026764),(5981,8482,0.9348567),(5981,10130,0.5392629),(5981,10918,0.2942363),(5981,13686,0.41158238),(5981,15058,0.28723747),(5981,22119,0.61659616),(5982,3040,0.46724188),(5982,11492,0.40217012),(5983,1017,0.5441629),(5983,22613,0.7830819),(5983,24272,0.6012842),(5983,25685,0.70372653),(5985,5653,0.8087987),(5985,11529,0.19455524),(5985,14017,0.24834572),(5985,15050,0.3221352),(5985,17121,0.76783735),(5986,2654,0.27010742),(5986,26442,0.8573751),(5986,30960,0.8640627),(5987,10376,0.26305792),(5987,10843,1.9889608e-2),(5988,15671,0.43261048),(5988,29636,0.79113936),(5989,4244,0.76023865),(5989,11703,0.4007691),(5989,16847,5.2316982e-2),(5989,28696,0.34089604),(5990,6367,0.6245854),(5991,8520,0.9160148),(5991,17619,0.6388093),(5991,28724,0.25695264),(5992,265,0.7223992),(5992,4973,0.4615916),(5992,6018,6.6145733e-3),(5992,11449,0.11637389),(5992,20842,0.45380265),(5993,18109,0.91312057),(5993,21417,0.8313693),(5993,21571,3.6263666e-3),(5993,23558,0.24655804),(5993,25805,0.34854278),(5994,12944,0.87758297),(5994,20778,0.17844114),(5995,4806,0.8718096),(5995,11139,0.7491363),(5995,13631,0.3887636),(5995,18954,0.28361034),(5995,23770,0.188512),(5995,26091,0.40855804),(5995,30145,0.82025814),(5996,5271,0.20060946),(5996,20028,0.69882405),(5996,23550,0.94666666),(5996,31983,0.9102129),(5997,12518,0.4811465),(5997,16933,0.76992846),(5998,3458,0.7424726),(5998,11066,9.010417e-2),(5998,22002,0.4763584),(5998,23034,0.19482714),(5999,14412,0.7586936),(5999,26019,0.6850629),(6000,17696,0.15527147),(6001,1131,0.3825541),(6001,5962,0.7424134),(6001,17472,0.73597425),(6001,19559,0.92954963),(6001,21853,1.78072e-2),(6001,25745,0.6977947),(6001,26367,0.110590056),(6002,6391,0.622325),(6002,10649,0.8858376),(6002,29160,7.596353e-2),(6002,31868,0.29639316),(6003,3085,0.23200555),(6003,5114,0.44768956),(6003,5574,0.7974139),(6003,7200,0.20184886),(6003,16717,0.2473947),(6003,16854,0.9206609),(6003,18654,0.6562354),(6003,20281,0.33045077),(6003,20521,0.8977782),(6003,21512,0.2241629),(6003,29198,0.4276596),(6003,30969,0.54537576),(6004,373,0.67426634),(6004,22758,0.6644552),(6004,28102,0.8884791),(6005,4190,0.11759356),(6005,18552,0.737333),(6005,18941,0.7573606),(6005,22040,0.9679104),(6005,25606,0.40553874),(6005,27027,0.9520533),(6005,29431,5.4984912e-2),(6006,26663,0.96733755),(6006,29220,0.23000078),(6007,523,0.45038936),(6007,7989,0.59046715),(6007,17584,9.3614586e-2),(6007,25454,0.8269159),(6008,31997,0.3265119),(6009,562,0.43096483),(6009,738,0.92763364),(6009,6981,0.3189855),(6009,7877,0.6114886),(6009,11827,0.5883512),(6009,12730,0.5877247),(6009,26984,0.23023449),(6010,145,0.11916957),(6010,14775,0.72167796),(6010,29816,0.13679981),(6011,30045,0.93786746),(6012,420,0.5926273),(6012,2980,0.7094002),(6012,29364,0.7217719),(6013,3338,0.5976805),(6013,18375,0.9400599),(6014,9732,0.5705776),(6014,14547,0.39297906),(6014,16580,1.4070248e-2),(6014,22829,0.8411394),(6014,27378,0.6705572),(6015,3136,0.8047033),(6015,3603,0.49634933),(6015,19097,0.5482543),(6015,26574,0.11283579),(6016,2101,0.1526021),(6016,5022,0.88029695),(6016,8568,0.9070384),(6016,22402,0.46033642),(6016,28376,0.71359956),(6016,30289,0.42845014),(6017,13915,0.4293965),(6017,17003,0.24921763),(6017,27227,2.4498602e-2),(6017,30228,0.9969954),(6018,14428,0.5344938),(6018,14788,0.59192634),(6018,19860,0.9900546),(6018,32370,0.7829338),(6019,23323,0.69261944),(6019,23885,0.92289734),(6019,31756,0.12736233),(6020,4508,0.6278282),(6020,8283,0.28859982),(6020,11154,0.6326493),(6020,14747,3.0146316e-2),(6020,16198,3.8645815e-2),(6020,19191,0.56926125),(6020,23937,0.880507),(6020,28957,0.3012491),(6020,31611,0.5068923),(6021,11586,0.3576028),(6021,13787,0.5794002),(6021,25433,0.90695894),(6022,10971,6.0665842e-2),(6022,23210,0.103985436),(6022,25581,0.9014162),(6022,26713,0.9254672),(6022,27556,0.1597083),(6022,27732,0.8398845),(6023,643,0.8749359),(6023,12877,0.72663647),(6023,18350,0.4491689),(6023,19890,0.6879898),(6023,23084,0.72173345),(6023,29718,7.4194945e-2),(6024,936,0.8538465),(6024,30606,9.615884e-2),(6024,31975,0.5110174),(6025,10938,0.9898445),(6025,16295,0.24831727),(6025,20884,0.7580997),(6025,22381,0.693831),(6025,27909,0.41911998),(6025,27969,0.12287296),(6026,2829,0.49501026),(6028,2851,0.73971504),(6028,13740,0.5839141),(6028,16064,0.2563999),(6028,19034,7.3735535e-2),(6028,23443,0.335469),(6028,29491,0.28258568),(6029,1638,0.14722683),(6029,1658,0.2341303),(6029,21130,0.9123409),(6030,4164,0.6963588),(6030,8768,0.6713499),(6030,29920,0.8272358),(6031,9293,0.9860611),(6031,12716,0.4427755),(6032,16810,0.13664982),(6033,17933,0.162339),(6033,19624,0.62363315),(6033,31939,0.324523),(6034,14574,0.32602397),(6034,19153,0.8336852),(6034,20054,5.183538e-2),(6034,31103,1.010764e-2),(6035,2778,0.8346559),(6035,8489,0.774784),(6035,10764,0.3485098),(6035,22552,0.37667868),(6035,23229,0.6085787),(6035,27271,0.4539085),(6036,19495,0.58576274),(6037,7117,0.68965495),(6037,9325,0.40731892),(6037,11378,4.32912e-2),(6037,15801,0.6794021),(6037,18024,0.5378427),(6037,32700,0.90531623),(6038,18515,0.5841541),(6038,19604,0.7206457),(6038,21376,0.84229535),(6039,3068,0.73959255),(6039,5388,0.47458768),(6040,10045,0.9674815),(6040,10102,0.86054814),(6040,28135,0.9401983),(6040,31497,0.48571935),(6041,6777,0.48312885),(6041,21527,7.138393e-2),(6041,25922,0.5717222),(6041,29785,0.277368),(6041,30595,0.5652844),(6041,30729,0.3644717),(6042,2923,0.26901183),(6042,5353,5.899132e-2),(6042,9249,0.7343961),(6042,30457,0.9444867),(6042,32401,0.5645338),(6043,108,0.32872516),(6043,15174,2.9988134e-2),(6045,5943,5.4387357e-2),(6045,6909,0.1256961),(6045,9012,0.6162779),(6045,26316,0.45972115),(6046,14362,0.5016136),(6047,10129,0.34766877),(6047,13215,0.80146784),(6047,16811,0.80969363),(6048,6,0.79398495),(6048,1793,0.19457889),(6048,11529,0.1431389),(6048,25886,0.115501024),(6049,4661,0.369936),(6049,20883,0.7937402),(6049,23525,0.5941871),(6049,28979,0.9653685),(6050,7628,0.9844018),(6050,8747,0.3382957),(6050,9873,0.10683443),(6050,19581,0.47135255),(6050,23423,0.99562526),(6050,23866,6.967593e-2),(6050,32027,0.12229994),(6051,6529,0.995608),(6051,18883,0.9036353),(6051,21429,0.79987615),(6051,25699,0.47729954),(6051,29186,0.56972665),(6051,29580,0.86350816),(6052,19198,0.3655564),(6052,19477,0.28604567),(6053,12808,0.62428844),(6053,15338,0.38801348),(6053,16478,2.4782993e-2),(6054,18158,0.50362873),(6054,25256,0.5126716),(6055,7424,0.76871526),(6055,10879,0.7008016),(6055,12244,0.9551787),(6055,30791,0.6113417),(6055,31234,0.5534664),(6056,24480,0.34376082),(6057,1202,0.13477743),(6057,7308,0.99442875),(6057,18577,0.6808696),(6057,22360,0.56727684),(6058,7831,0.23107399),(6058,12359,0.7384981),(6058,12916,7.552509e-2),(6058,19641,0.5715806),(6058,27290,0.13966583),(6059,6462,0.58906174),(6059,10465,6.7943176e-3),(6059,22009,7.848392e-2),(6059,32445,0.6991881),(6060,5846,0.18866633),(6060,6065,0.41615096),(6060,12725,0.2604626),(6060,16501,0.3255725),(6060,21778,0.62789714),(6061,3607,0.46120852),(6061,11929,0.8805539),(6061,15613,0.79912066),(6061,22060,0.995959),(6061,23913,0.7448898),(6061,30720,0.30552697),(6062,47,0.4673495),(6062,16541,0.6535699),(6062,18900,0.34859747),(6062,24459,0.5223732),(6062,25015,0.11956219),(6062,30978,0.53378665),(6063,7592,0.36479107),(6063,8846,0.60572207),(6063,10747,0.97039),(6063,26059,0.5828665),(6063,27063,0.8371006),(6063,30170,0.9275221),(6064,5450,0.8460552),(6064,7166,0.45004955),(6064,7555,3.539229e-2),(6064,11632,0.5120627),(6064,24985,0.118683755),(6065,5086,0.7952812),(6065,6504,5.5836488e-2),(6066,4046,6.980424e-2),(6067,4677,0.9121423),(6067,10660,0.25601378),(6067,13273,0.49369717),(6067,14478,0.18678604),(6067,19003,0.28960595),(6068,17127,0.10846494),(6068,17342,0.40781322),(6068,23779,0.42323312),(6069,11675,0.47327194),(6069,11900,3.9344173e-2),(6069,23786,0.58638686),(6069,27471,0.63305515),(6070,10975,8.373396e-3),(6070,18882,1.9076567e-2),(6070,21726,0.14553533),(6071,1588,0.78485),(6071,3722,0.33554447),(6071,10790,0.35334352),(6071,14484,0.15425536),(6071,24491,0.5893603),(6072,1619,0.16232514),(6072,3243,0.7742504),(6072,5954,0.5636657),(6072,10556,6.050336e-2),(6073,9483,0.40294853),(6073,14484,0.5551939),(6074,4977,5.127372e-2),(6074,5358,0.63827115),(6074,5530,0.48375225),(6074,8922,0.8775776),(6075,2702,0.96012145),(6075,13462,0.6004541),(6075,14241,0.241699),(6075,15204,0.41743922),(6075,21472,0.6767667),(6076,7723,0.47412413),(6076,10478,0.8744552),(6076,17022,0.8506602),(6076,26597,1.7889222e-2),(6077,878,0.92997885),(6077,17746,0.89386386),(6078,26814,0.120797746),(6078,27642,0.113186),(6079,2718,0.72737414),(6079,5432,0.1665327),(6079,9559,5.932291e-2),(6079,12086,0.8935932),(6079,16824,0.2064795),(6079,32159,0.6967746),(6080,7497,0.6150561),(6080,12537,0.5426944),(6080,17301,0.99765176),(6080,20944,0.32401443),(6080,27627,0.2736052),(6081,7116,0.72271097),(6081,8864,0.7671442),(6081,9870,0.1972458),(6081,18363,0.849253),(6081,20950,0.5827979),(6081,21835,0.19432159),(6081,27378,0.6137355),(6081,30913,0.6107789),(6081,32601,0.24910906),(6082,9585,0.3223638),(6082,11805,0.80118173),(6082,13890,5.3848702e-2),(6082,21648,0.81286323),(6082,29209,0.77057314),(6083,992,0.2349976),(6083,5428,0.2107552),(6083,9421,0.70830405),(6083,12358,0.83450615),(6083,17166,0.9942319),(6084,14110,0.85451555),(6084,23621,0.7983885),(6084,28277,0.865717),(6085,797,0.24874799),(6085,2553,0.788576),(6085,21405,0.7746104),(6085,24936,0.17960963),(6086,4296,0.61670333),(6086,21299,0.54611427),(6087,4251,0.66622996),(6087,7202,0.6497683),(6087,9629,0.10942855),(6087,14913,0.16001672),(6087,19793,4.7120754e-2),(6087,27413,0.21010245),(6087,28602,0.69478655),(6088,13412,0.5353956),(6088,21403,0.6039449),(6088,24947,0.66446537),(6088,27279,0.8819829),(6089,2333,0.40674275),(6089,15513,0.9995957),(6089,25631,0.18419395),(6090,3578,0.33899286),(6090,23749,0.5020297),(6090,25800,9.0038806e-2),(6090,29294,0.57138234),(6090,31009,0.30720177),(6091,14659,0.61720157),(6091,17728,0.7400513),(6091,30274,0.1832125),(6092,18535,0.5658158),(6092,31383,0.53440297),(6092,32676,0.78299296),(6093,13323,0.6369292),(6093,28844,0.2674009),(6094,10193,5.9473906e-2),(6094,20055,0.773754),(6095,1104,0.5085879),(6095,3737,0.36329177),(6095,11092,0.5963271),(6095,16210,0.9932722),(6096,19149,0.55025977),(6096,24083,0.4289512),(6096,31819,0.5571674),(6097,2909,0.2694167),(6097,4062,0.4515849),(6097,4462,0.25574723),(6097,18619,0.23414962),(6098,7167,0.39304516),(6098,14411,0.7255481),(6098,26432,0.37170637),(6099,8504,0.40413636),(6099,8641,0.69856834),(6099,10081,0.8830734),(6099,23276,0.20063952),(6100,6895,0.9640016),(6100,12206,0.8961554),(6100,13636,0.9151147),(6100,22488,9.5248476e-2),(6100,24600,0.6285768),(6101,8495,0.4933049),(6101,14354,0.6955665),(6101,16866,0.3171145),(6101,27289,0.60564566),(6102,9369,0.7324309),(6102,11973,0.27918085),(6102,16243,0.7062482),(6102,23803,0.36008063),(6102,24349,0.7677997),(6102,27980,0.6535438),(6103,7886,0.71066993),(6103,17343,0.8994018),(6103,17460,0.4457743),(6103,20230,0.13695684),(6103,25471,0.72197616),(6103,31863,0.8269205),(6103,31959,2.8433349e-2),(6105,7951,0.68795836),(6105,13847,0.7702071),(6106,3169,0.46392637),(6106,16803,0.7699386),(6106,19793,0.7205398),(6106,23782,0.46402082),(6106,28056,0.4942326),(6107,2635,6.906142e-2),(6107,8357,0.5942682),(6107,12639,0.38749993),(6107,21264,0.31042868),(6107,23505,0.5753348),(6108,14735,0.890923),(6108,28144,0.17505689),(6109,13663,0.40686366),(6109,14404,0.66404045),(6109,16352,0.7262603),(6109,24038,0.2784847),(6109,32359,0.44556314),(6110,501,0.6137555),(6111,17219,9.4610445e-2),(6111,19047,0.89693207),(6111,28580,0.6499018),(6111,30546,0.5203326),(6112,10739,2.7681468e-2),(6113,4326,5.2605726e-2),(6113,9693,0.102359645),(6114,7951,0.39311028),(6114,13438,0.63665926),(6114,14191,0.57305104),(6114,20765,9.5731705e-2),(6114,26312,0.7914094),(6115,2138,0.5920556),(6115,3795,0.93788856),(6115,7256,0.20829302),(6115,14425,0.19420728),(6116,6249,0.12327922),(6116,10421,0.5653284),(6116,24812,0.8243048),(6116,29002,0.95481473),(6116,32358,0.5532757),(6117,1270,0.31219563),(6117,6261,0.26114553),(6117,10796,9.065697e-2),(6117,30452,0.60659766),(6118,3075,0.27083373),(6118,4986,0.9488473),(6118,23970,0.28112563),(6118,26272,0.7615025),(6119,2516,0.7681351),(6119,4776,0.5983487),(6119,9134,0.2332329),(6119,10626,0.9662205),(6119,12418,1.4150088e-2),(6119,22470,0.7373239),(6119,24243,0.91693646),(6119,29375,0.82013875),(6119,30039,0.82912207),(6120,18301,0.547166),(6120,24152,0.4520161),(6120,28779,0.900242),(6120,30591,4.70337e-2),(6121,7589,0.7616435),(6121,15677,0.37954104),(6121,23492,0.23325533),(6121,30785,0.8519246),(6122,9149,0.91559756),(6122,13042,0.25942627),(6122,19620,0.8234744),(6122,26535,0.4983311),(6122,31477,2.0502392e-2),(6123,10173,0.6038339),(6123,14693,0.64379513),(6123,18441,0.8844095),(6124,510,0.34206045),(6124,1411,0.17388819),(6124,3034,0.7536476),(6125,3890,0.7149597),(6125,5851,0.7820701),(6125,6843,0.78893024),(6125,24632,0.9465564),(6125,24997,0.77856964),(6126,12945,0.7283653),(6126,16505,0.39789242),(6126,19776,0.30392206),(6126,26548,0.26644993),(6127,14267,0.2817297),(6128,11903,0.8417835),(6128,16792,0.22839159),(6128,17840,0.68194765),(6129,6653,5.3666957e-2),(6129,9027,0.45088586),(6129,9641,0.39127094),(6129,10155,0.9681508),(6129,12176,0.767071),(6129,12573,0.2253959),(6129,21430,0.6114598),(6129,28872,0.5579415),(6130,2275,0.18938336),(6130,17877,0.24209867),(6131,25340,0.3219061),(6131,26867,0.72416747),(6131,30422,0.9940341),(6132,3384,0.5350681),(6132,9768,0.8100468),(6132,18157,0.22661163),(6132,19401,0.2776178),(6132,20886,0.5798547),(6132,32168,9.522031e-2),(6133,5947,0.6165072),(6133,8469,0.4869651),(6133,18598,1.3093436e-2),(6133,30491,0.82569444),(6133,31938,0.6243802),(6134,15661,0.87214726),(6135,4843,4.996337e-2),(6135,12290,0.35114634),(6135,17647,0.18535051),(6135,26090,0.75998634),(6135,26877,0.62010044),(6135,28616,0.80192125),(6136,8696,0.27403724),(6136,13295,0.21570794),(6136,15171,0.5917384),(6136,20528,0.5189943),(6137,23029,0.12803432),(6138,3348,0.6618306),(6138,9873,0.6154048),(6138,16507,0.6449328),(6139,1139,8.2640916e-2),(6139,3285,0.5302629),(6139,18692,0.9555985),(6140,8429,0.6266656),(6140,11897,0.7872911),(6140,19652,0.80895025),(6140,23791,0.44945893),(6140,32586,0.42029977),(6141,14940,0.29330587),(6141,16920,0.8104733),(6141,26074,0.7687544),(6142,6006,0.8395736),(6142,10145,0.19017805),(6142,13614,9.631103e-2),(6142,24821,0.619494),(6143,1508,0.58928263),(6143,2511,0.64645123),(6143,3348,0.2821021),(6143,6592,0.34900343),(6143,23220,9.9141665e-2),(6143,23398,0.2718143),(6144,5068,0.8331878),(6144,16343,0.51019883),(6145,1477,0.15703072),(6145,10755,0.60463345),(6145,19918,0.5187709),(6145,25228,0.1890516),(6146,3296,0.45374605),(6146,6363,4.5041844e-2),(6146,10532,0.37077007),(6146,11108,0.56552815),(6146,13085,0.23242469),(6146,17250,9.7275354e-2),(6146,20392,0.8076609),(6146,29450,0.3444152),(6147,9347,0.28640583),(6147,10564,0.32397366),(6147,12095,0.52737695),(6147,16173,0.44400984),(6147,19216,8.689544e-2),(6147,26551,8.016447e-3),(6148,912,0.4181441),(6148,13887,0.5191456),(6148,18315,0.64006686),(6148,25278,4.1497394e-2),(6149,17858,0.8353596),(6149,21584,0.6876493),(6149,24075,0.69846565),(6149,29590,0.8581584),(6150,6920,0.45403627),(6151,2722,0.9411764),(6151,4626,9.8873265e-2),(6151,4980,0.13577954),(6151,16663,0.9740553),(6151,18625,0.4246788),(6151,20891,0.35184056),(6152,555,0.30314896),(6152,7100,0.6574924),(6152,20320,0.27785417),(6152,20933,5.2318737e-2),(6152,21548,0.7368345),(6152,24253,0.4276556),(6152,25978,0.10486204),(6152,26232,0.15687698),(6152,30053,3.769826e-2),(6152,32363,0.9858328),(6153,13216,0.9149209),(6153,14327,0.19724046),(6153,14775,0.22027467),(6153,16152,0.9007462),(6153,29079,0.55592275),(6153,29463,0.7431794),(6153,30017,0.9929069),(6154,9546,0.109163485),(6154,20552,0.58400613),(6154,26651,0.10740775),(6154,30003,0.8291213),(6154,30004,0.21039292),(6155,2645,0.98032695),(6155,10381,0.50186056),(6155,15550,0.3097781),(6155,22577,0.6910562),(6155,23977,0.63312054),(6156,5350,0.6815581),(6156,25716,0.52191985),(6156,27048,0.4532527),(6157,11553,0.77270055),(6157,11713,6.449434e-2),(6157,16102,0.2192916),(6157,25314,0.3173997),(6157,31381,0.32931882),(6158,2008,0.8489808),(6158,5519,0.47595295),(6158,19563,0.6673786),(6158,32367,0.9341553),(6159,8538,0.38173807),(6159,32595,0.56170774),(6160,4904,0.92303514),(6160,5497,0.10641194),(6160,9657,2.271651e-2),(6160,14039,0.67918503),(6161,8489,0.95524037),(6161,9167,0.17748772),(6162,5117,2.2452118e-2),(6162,12438,0.67253697),(6162,22869,0.9267715),(6162,25051,0.46781075),(6162,25183,0.6811731),(6162,29752,0.122200586),(6163,3431,0.8302361),(6163,7441,0.4768518),(6163,9235,0.6636547),(6165,6433,0.9797235),(6165,6999,0.5132741),(6165,11969,0.76860434),(6165,17007,0.8090067),(6165,29458,0.6466851),(6166,1646,0.37003538),(6166,10467,0.31411782),(6166,13399,0.15620525),(6166,13415,0.23160808),(6166,18637,0.511159),(6167,1425,0.2252305),(6167,2944,0.109871365),(6167,9456,0.8624326),(6167,12400,0.9802015),(6167,25292,0.12393215),(6168,5029,0.406463),(6168,5430,0.41703418),(6168,14384,0.70772237),(6168,16444,0.5354681),(6168,17386,0.36362308),(6168,19414,0.5860442),(6168,20542,0.48257634),(6168,21846,1.9788608e-2),(6168,28176,4.436466e-3),(6168,32502,0.48560315),(6169,9343,0.45297),(6169,10197,0.17973159),(6169,28750,0.33365652),(6170,12227,0.911449),(6170,16173,0.12032986),(6170,24899,0.89316106),(6170,30553,0.26337823),(6171,6895,7.8165345e-2),(6171,8774,0.81746733),(6171,9517,2.1985838e-2),(6171,14762,0.112732254),(6171,25787,0.99123263),(6171,26155,0.91943693),(6172,11557,0.7321341),(6172,22998,0.5843705),(6172,25207,0.2345888),(6173,22082,3.79851e-2),(6174,3641,0.83777326),(6174,8729,0.50042564),(6174,12523,0.81674504),(6174,21070,1.5113703e-2),(6174,26589,0.42615506),(6174,32375,0.87189174),(6175,6340,0.45128992),(6175,23070,0.44568872),(6175,25269,1.6129877e-2),(6176,782,0.61746234),(6176,9936,0.31589428),(6176,15448,6.648835e-2),(6176,18505,2.4985077e-3),(6176,20477,0.9833914),(6176,22134,0.94486606),(6176,23573,0.87823117),(6176,27511,0.28408208),(6177,14694,0.13381323),(6177,27229,0.9023907),(6178,2313,0.32894832),(6178,10683,0.71206206),(6178,14657,0.9798501),(6178,27358,0.8936406),(6178,31168,0.6744453),(6179,4183,0.6362727),(6179,4506,0.15777518),(6179,4899,0.77446073),(6179,6771,0.9365695),(6179,17644,0.52525383),(6179,21208,0.76441395),(6179,23626,0.21918464),(6180,434,0.72499746),(6180,888,5.1352374e-2),(6180,10936,0.4025018),(6180,15215,0.1676583),(6180,15680,0.74644583),(6180,27015,4.5381438e-2),(6180,30998,0.797294),(6181,24944,3.0684724e-2),(6181,25307,0.8903105),(6181,27606,3.2960802e-2),(6182,3194,3.7997495e-2),(6182,13960,0.23818474),(6182,31064,0.85081357),(6183,3122,0.42903686),(6183,3939,0.85912544),(6183,19492,0.187018),(6183,20059,0.72144026),(6183,23298,0.39225274),(6183,23377,0.6279381),(6183,29456,0.6443989),(6184,29851,0.28151697),(6184,29929,0.19871715),(6184,30149,0.6349835),(6185,11840,8.3063714e-2),(6185,30170,0.41349486),(6185,30602,0.7652219),(6186,18072,0.43718097),(6186,29201,0.124790825),(6186,31756,0.17092077),(6187,794,0.76507974),(6187,7148,0.5279705),(6187,15184,0.52498555),(6187,15691,4.13753e-2),(6187,16307,0.4013863),(6187,28530,0.52918327),(6187,28656,0.51248413),(6188,21101,0.30156794),(6189,4579,0.33356297),(6189,11642,0.8655656),(6189,14990,0.20378278),(6189,16365,0.5367121),(6190,770,0.96420497),(6190,1303,0.634721),(6190,5129,0.56237894),(6190,14061,0.27109453),(6190,18566,0.10103558),(6190,25244,0.28897867),(6190,26074,0.89988434),(6190,26924,0.8004923),(6190,27661,0.16110201),(6190,32646,0.3482733),(6191,2353,0.7639248),(6191,10048,0.22190315),(6191,11846,0.6620907),(6191,22675,0.69210196),(6191,28939,0.23742977),(6191,32288,0.9135083),(6192,1603,0.56391734),(6192,7621,0.15410629),(6192,8895,0.87647766),(6192,8937,0.15754516),(6192,13121,0.18278132),(6193,11,0.5515596),(6193,430,0.7980413),(6193,1135,0.9285295),(6193,8264,0.220196),(6193,10735,0.23497464),(6194,634,0.51996714),(6194,6448,0.48349506),(6194,14824,0.29900038),(6194,21354,0.15787408),(6194,23320,0.577517),(6194,25070,0.3902594),(6194,31126,0.32931265),(6195,6838,0.9985533),(6195,11476,0.8047812),(6196,2676,0.31465074),(6196,7465,0.9588392),(6196,10106,0.6622521),(6196,21675,0.26267573),(6196,30113,0.19845237),(6197,3631,9.524272e-2),(6197,15577,0.8893423),(6197,20718,0.57480264),(6197,21037,0.28074253),(6197,22644,0.26899028),(6197,29201,0.12453111),(6197,30304,0.38851076),(6198,9673,0.87761325),(6198,17536,0.34171578),(6198,18291,0.43983778),(6198,22693,9.770337e-2),(6198,27611,0.5835598),(6198,28653,0.23081988),(6199,17275,4.3167967e-2),(6199,17954,0.7322411),(6199,30207,0.45406055),(6199,30843,2.1044035e-2),(6200,16836,0.46479452),(6200,17764,0.5784418),(6200,25064,5.4729614e-2),(6200,25803,0.4761354),(6201,9088,0.34944963),(6201,17897,0.39520243),(6201,18622,0.30938426),(6201,23458,0.41392106),(6201,26539,0.82522595),(6202,8463,0.5033834),(6202,13121,0.54645026),(6202,18678,9.969252e-2),(6202,22316,1.354102e-2),(6202,32584,0.6424768),(6203,492,0.7941078),(6203,2436,0.65398246),(6203,5215,0.76459134),(6203,8940,0.9108416),(6203,24129,0.6712513),(6204,13359,0.31148812),(6205,293,0.374871),(6205,29708,0.9782783),(6205,30071,0.8485234),(6206,2243,0.5875737),(6206,7978,0.7954435),(6206,10531,0.8924947),(6207,2645,0.31136754),(6207,7816,0.75112116),(6207,8937,0.10972283),(6207,12561,0.4538938),(6207,31559,2.2794817e-2),(6208,5957,0.98895025),(6208,22403,0.35816306),(6209,7844,0.58742064),(6209,13767,0.117494024),(6209,23026,0.29169104),(6209,24461,0.74961644),(6209,25481,0.3632608),(6209,28693,0.652325),(6210,1722,0.38567543),(6210,3244,0.7263921),(6210,15242,0.18269712),(6211,25405,0.3209736),(6212,5633,0.8381025),(6212,24261,0.6096268),(6213,6803,0.16379468),(6213,13507,0.31601176),(6213,19975,0.8805979),(6213,20352,0.58205265),(6213,22162,0.4748621),(6213,26993,0.72813684),(6213,29711,3.969926e-2),(6213,29775,0.49096665),(6214,13047,0.48089936),(6214,13803,0.39028636),(6214,17992,0.76316714),(6214,22222,0.7906385),(6214,30422,0.6761097),(6215,14071,0.24423222),(6215,20632,0.9337813),(6216,2772,0.112242416),(6216,4527,0.14140144),(6216,20432,0.9299706),(6216,31647,0.47455165),(6217,12935,6.0589023e-2),(6217,23394,0.26349166),(6217,30277,0.35328516),(6217,32196,0.47749364),(6218,13878,0.8200934),(6218,24084,0.7825092),(6218,29415,0.29066756),(6218,31042,0.34900442),(6219,9970,0.20518075),(6219,10132,0.17239721),(6219,15355,0.5135362),(6219,24164,0.28205952),(6219,25809,0.12688516),(6220,5641,0.8387939),(6220,5824,0.93709177),(6220,17405,0.63084733),(6220,20532,0.8208523),(6220,25930,6.650555e-2),(6222,19333,0.284067),(6222,22233,0.6058145),(6222,29214,0.764361),(6222,30706,5.1419407e-2),(6223,11013,0.5913157),(6223,14046,0.18050951),(6223,19341,0.8018806),(6223,21934,0.4742773),(6223,25008,0.78428096),(6223,30911,0.4721954),(6223,31836,0.83937675),(6224,8585,0.99743825),(6224,9895,0.3848668),(6224,17412,5.7777423e-2),(6224,18723,0.51558036),(6224,22265,0.29348752),(6224,23074,0.2605127),(6224,23449,0.35645458),(6224,29680,0.51636034),(6225,24542,0.31738752),(6225,27819,0.50919163),(6225,28781,0.27080336),(6225,31214,0.24381316),(6226,30146,0.1912911),(6227,18119,0.3077248),(6227,20944,0.18914507),(6228,31936,0.16975522),(6229,7043,0.29930788),(6229,8144,0.8972925),(6229,25319,0.27031183),(6230,2741,0.56533647),(6230,20541,0.98355895),(6230,25103,5.587273e-2),(6230,26912,0.77664924),(6231,4014,0.293349),(6231,13385,0.5183777),(6231,21224,0.447268),(6231,23891,9.307803e-3),(6231,29534,0.53703755),(6231,31689,0.27946094),(6232,4275,0.7290024),(6232,11086,0.84095937),(6232,13496,0.17561983),(6232,15621,0.34031823),(6233,12696,0.32546327),(6233,20334,0.2856211),(6233,23923,2.5418835e-2),(6233,24642,0.95160973),(6234,2317,0.2335567),(6234,12974,0.63871497),(6234,20320,0.62815976),(6235,7689,0.5677182),(6235,14694,0.37213734),(6235,17021,0.93742466),(6235,23622,3.98452e-2),(6235,24970,2.981769e-2),(6236,1807,0.6183994),(6236,9169,0.2037401),(6236,12494,0.7698917),(6236,15896,0.17997116),(6236,18280,0.27818844),(6236,24172,0.61263865),(6236,25969,0.91623485),(6236,32437,0.9266071),(6237,15939,0.15167253),(6237,20087,0.74855703),(6237,21228,0.85082626),(6237,25469,0.31963333),(6238,3282,0.37409154),(6238,3832,0.41990304),(6238,12952,0.17560692),(6238,27863,0.99312556),(6239,2851,0.99443865),(6239,13305,0.2837618),(6239,18250,0.5746516),(6239,23581,4.6452828e-2),(6239,23878,0.64945626),(6239,25147,0.31688836),(6239,27439,3.3691548e-2),(6240,20828,0.5353542),(6240,20866,0.16007681),(6240,28788,1.1714764e-2),(6240,31863,0.21603398),(6241,2925,0.8028067),(6241,11251,0.2657293),(6241,17043,0.85911787),(6241,20116,0.7745166),(6241,25629,0.43771985),(6242,1688,4.0241133e-4),(6243,10847,7.4101076e-2),(6243,10902,0.46241468),(6243,29078,0.7365032),(6243,32376,0.84172446),(6244,13994,8.050544e-2),(6244,18756,0.8879575),(6244,25466,0.9426785),(6245,9774,0.5762132),(6245,21681,0.4076602),(6245,22638,0.20504777),(6245,25506,3.0221213e-2),(6246,17323,0.74465925),(6246,20144,0.9851509),(6247,8376,0.26770076),(6247,8478,9.235969e-2),(6248,984,0.79749876),(6248,20786,0.87512374),(6248,23457,0.5743932),(6249,25094,0.23629026),(6250,10127,0.82561666),(6250,13343,0.9850746),(6250,15436,0.10127278),(6250,15586,0.58411896),(6250,15937,0.22940736),(6250,23266,0.29333833),(6250,26916,0.6371378),(6251,10171,0.2215149),(6252,6011,0.74375755),(6252,7368,0.882783),(6253,2697,0.6485653),(6253,3414,0.5417969),(6253,20270,0.990699),(6253,28683,0.9056605),(6253,30924,2.2547416e-2),(6253,31771,0.1628881),(6254,8837,0.39686581),(6254,14161,0.17202997),(6254,14384,0.7924946),(6254,21705,4.4195388e-2),(6254,27444,0.26010484),(6254,29645,0.7818522),(6255,23926,0.6686893),(6255,27940,0.11520426),(6255,28398,7.787445e-2),(6256,14857,0.6364677),(6256,22386,0.27678496),(6256,23025,0.9641433),(6256,27337,0.53848404),(6256,28453,0.17548509),(6256,31096,0.27452216),(6257,2526,0.33444306),(6257,5044,0.5195184),(6257,6524,9.493578e-3),(6257,13927,0.1758651),(6257,17191,0.7268864),(6257,29212,0.53556514),(6257,29610,0.5478637),(6258,8760,0.929165),(6258,9764,0.6709266),(6258,11758,5.4667653e-3),(6258,12905,0.22175021),(6258,13671,0.503371),(6258,18216,0.76941985),(6258,21379,0.90489405),(6258,23667,0.59222984),(6258,26149,8.3011374e-2),(6259,3866,0.48655096),(6259,14250,0.8696898),(6259,20686,0.19999555),(6259,21324,0.45185697),(6259,21455,0.11584266),(6259,32138,0.2572081),(6260,14779,0.83646053),(6260,26619,0.50985336),(6261,5724,0.80232227),(6261,22745,0.5502101),(6261,24650,0.20070961),(6261,28074,4.231814e-2),(6262,8356,0.5921814),(6262,9206,0.96340346),(6262,18057,2.5723325e-2),(6263,4079,0.12465391),(6263,12209,0.46714547),(6264,10581,0.95967233),(6264,13897,2.3463808e-2),(6264,28948,0.31894538),(6264,32716,0.4389227),(6265,16588,0.19663514),(6265,19081,0.1417623),(6265,22084,0.12195485),(6265,28886,0.28162003),(6266,24908,0.8228479),(6266,30117,0.9243268),(6267,14394,0.44563767),(6267,15619,0.24203517),(6267,15751,0.6215599),(6267,25413,0.84128535),(6267,30345,0.13371776),(6268,2609,0.96722233),(6268,3378,0.13269049),(6268,12127,0.50543827),(6268,14100,0.7566007),(6268,20824,0.9131871),(6269,10723,0.15707171),(6269,18896,0.8853875),(6269,24219,0.3075687),(6270,8978,0.8090796),(6270,9740,0.46181566),(6271,21184,0.56275094),(6271,25118,0.28163123),(6271,32327,0.26199913),(6272,7827,0.97146153),(6272,8771,0.20444895),(6272,10338,0.35668978),(6272,23260,0.20458004),(6272,25145,0.6568039),(6272,27118,0.71885204),(6273,5934,0.8944535),(6273,16362,0.20095246),(6273,18885,0.25726345),(6274,1659,0.684329),(6274,14286,0.3433891),(6274,32207,0.4329575),(6275,16316,0.6222907),(6275,18689,0.34009928),(6276,477,4.7856554e-2),(6276,8985,0.7385399),(6276,10796,0.9269991),(6276,25313,0.57825625),(6277,5085,0.43078682),(6277,17758,0.8714593),(6278,6026,0.41493517),(6278,9333,0.88147414),(6279,643,0.96507543),(6279,14461,0.8230301),(6279,23429,0.93331254),(6280,8581,0.76173246),(6280,14363,0.445835),(6280,15712,0.19765712),(6280,24280,0.40383118),(6281,23766,0.23171447),(6282,20491,0.71307105),(6282,26791,0.9421159),(6282,31336,0.5336898),(6282,31917,0.5747592),(6283,500,0.18995963),(6283,28775,0.7323174),(6283,32481,0.38690412),(6284,3544,0.514328),(6284,12324,0.795263),(6284,17707,0.78232205),(6284,26090,0.5212952),(6284,30228,0.809451),(6284,30962,2.0434537e-3),(6285,15088,0.8108842),(6285,29907,0.57550675),(6286,8417,0.28219813),(6286,9571,0.19762182),(6286,14019,0.33876568),(6286,21886,0.85203254),(6286,24486,0.11054049),(6287,2272,0.5646725),(6287,8876,0.43641746),(6287,13009,0.5662294),(6288,4962,7.609923e-3),(6288,8490,0.25091347),(6288,22895,0.45707777),(6288,32190,0.403528),(6289,7074,0.58822775),(6289,11523,0.55568385),(6289,15335,0.88205504),(6289,18715,0.9894297),(6289,27581,0.12632035),(6290,2612,0.852866),(6290,3046,4.1891415e-2),(6290,3831,0.12020937),(6290,11283,0.8156656),(6290,15527,0.45202705),(6290,17519,0.9868003),(6290,29470,0.6960913),(6292,3835,0.12324264),(6292,7165,0.65827525),(6292,11266,0.8240209),(6292,18188,0.42515975),(6292,21546,0.94422877),(6293,5501,0.35511744),(6293,12870,0.8663117),(6293,15317,0.44206306),(6293,19702,0.6941755),(6293,21496,0.27931297),(6293,30526,0.8391926),(6293,30605,3.1086568e-2),(6294,15049,7.872365e-2),(6295,1691,0.12229103),(6295,24047,0.8720461),(6295,25708,0.4799299),(6296,14655,0.9531892),(6296,15017,0.71663827),(6296,21410,0.6678685),(6297,22597,2.3666268e-2),(6298,1002,8.1203446e-2),(6298,6262,0.8823614),(6298,11073,0.4664656),(6298,12497,0.6052565),(6298,14199,0.84179264),(6298,19323,0.7193979),(6298,27087,0.9389524),(6298,27815,0.9739672),(6299,7731,0.5380463),(6299,14355,0.21648529),(6299,16377,0.2560454),(6299,25568,5.7370454e-2),(6299,32138,0.702492),(6300,10050,0.84201854),(6300,24537,0.23834457),(6300,29079,4.8307292e-2),(6300,30851,0.612669),(6301,1038,0.62718034),(6301,3802,0.5247049),(6301,7465,0.74956757),(6301,11736,0.4963101),(6301,12819,0.33398092),(6301,13520,0.11623701),(6301,19193,0.8481815),(6301,25538,0.23349842),(6301,32730,0.95712847),(6302,1727,0.385409),(6302,3002,0.7418796),(6302,14511,0.13917968),(6302,17136,0.5343077),(6302,29759,0.49136427),(6303,18102,0.12029892),(6304,1207,0.56657815),(6304,2802,0.6535989),(6304,3464,0.75989985),(6304,22675,0.9645669),(6304,24689,0.63191724),(6304,29702,0.560155),(6305,3630,0.8018481),(6305,12719,2.431477e-2),(6305,19146,0.107531086),(6306,6337,0.10919797),(6307,7561,0.43708882),(6307,8277,0.27911317),(6307,14704,0.9148506),(6307,15906,7.022192e-2),(6307,24851,0.9874485),(6307,30792,0.26759636),(6308,342,0.10138086),(6308,15858,0.8339166),(6308,28806,0.82570875),(6308,29415,0.17370807),(6309,8984,0.9274659),(6309,18086,0.6034253),(6309,19991,0.8499649),(6309,27807,0.77972436),(6310,1275,0.3469545),(6310,6380,3.815865e-2),(6310,8958,0.58282554),(6310,18829,0.5046105),(6310,31545,0.599814),(6311,10718,0.9276889),(6311,14929,0.19180875),(6311,18938,0.30945244),(6311,29687,7.180586e-2),(6312,1543,4.3175686e-2),(6312,11219,8.649059e-3),(6312,25187,0.72941244),(6312,31441,0.22354771),(6312,32058,0.41128096),(6313,8080,0.81734276),(6313,30633,0.46768066),(6314,184,0.3867146),(6314,498,0.9779001),(6314,3293,0.6555087),(6314,4840,2.6342403e-2),(6314,12371,0.9816451),(6314,17150,0.48130348),(6314,26193,0.12008105),(6314,27812,0.32929066),(6314,30296,0.9805303),(6315,6869,0.5305311),(6315,8261,0.14960296),(6315,10752,5.0396312e-2),(6315,19728,0.3316813),(6315,21164,0.74419683),(6315,21210,3.1251136e-2),(6316,5652,0.7845136),(6316,5994,0.7909607),(6316,10840,0.34343404),(6316,14397,0.45511445),(6316,19821,0.87429),(6316,21742,0.57479346),(6317,2237,0.27766436),(6317,2769,0.45215872),(6317,8900,0.4505158),(6317,16747,0.851955),(6317,21537,0.32033154),(6318,10712,0.7000797),(6318,11903,0.6527907),(6318,12103,0.19307163),(6318,25788,0.97117877),(6319,316,0.738829),(6319,560,4.5574892e-2),(6319,4366,0.7282865),(6319,4377,0.5330251),(6319,9970,0.6035458),(6319,10177,5.6933623e-2),(6319,12452,0.43240753),(6320,21792,0.6048701),(6320,22914,0.9749641),(6320,29752,0.9550697),(6321,7257,0.74233776),(6321,10645,0.15531406),(6321,14333,0.12445252),(6322,1506,0.26000297),(6322,4527,0.6055655),(6322,5424,0.8873702),(6322,5840,4.588303e-2),(6322,5844,0.5612573),(6322,24245,0.40885317),(6322,27985,0.7060887),(6322,30697,0.3561461),(6323,4856,5.6972876e-3),(6323,9611,0.4886546),(6323,12301,0.13396136),(6323,14398,7.932048e-2),(6323,14528,0.4408862),(6323,24822,0.35836303),(6324,2669,0.76765305),(6324,6246,0.7964147),(6324,10132,0.2628663),(6325,22582,0.8733815),(6326,22488,0.7776036),(6326,23873,0.27066362),(6326,25833,0.56598824),(6326,27185,0.95611906),(6327,12573,0.8543762),(6327,27332,0.81221944),(6328,6290,0.23090707),(6328,8196,0.78698593),(6328,13497,0.88789016),(6328,13740,0.6050295),(6328,16652,0.69227004),(6328,31598,0.794834),(6328,32602,0.21415848),(6328,32633,0.6764642),(6329,1668,0.9563804),(6329,2636,0.34615877),(6329,7047,0.3745273),(6329,9039,0.37196398),(6329,22523,0.83312917),(6329,23962,0.21029669),(6330,18969,0.458651),(6330,22643,0.63532555),(6330,22980,0.48935115),(6330,23787,0.6325964),(6331,17918,0.6633288),(6331,20632,0.84757864),(6331,24823,5.4734606e-2),(6332,18826,0.42485794),(6332,20828,0.5998118),(6333,10965,0.8854729),(6334,11174,0.15544648),(6334,28409,9.018344e-2),(6335,25907,0.31155917),(6335,26354,8.362311e-2),(6335,26520,0.6979894),(6336,4279,0.3786105),(6336,10200,1.4048333e-2),(6336,16576,6.318567e-2),(6337,905,0.6260473),(6337,5276,0.17261043),(6337,16520,0.12724017),(6337,27230,6.891019e-2),(6338,13558,0.7935087),(6338,25677,0.9182477),(6338,31215,0.10828805),(6339,1142,0.91939163),(6339,3044,0.26432037),(6340,5374,0.93407226),(6340,13111,0.8041653),(6340,27056,0.747083),(6341,3327,0.7242801),(6341,4342,5.78196e-2),(6341,19669,0.7216413),(6341,22770,0.93458664),(6342,1714,0.4919087),(6342,10489,0.6993968),(6342,17553,5.752933e-2),(6342,18655,0.7605491),(6342,20453,0.4926978),(6342,22538,0.9164733),(6343,477,0.27647212),(6343,19891,0.20230842),(6343,24720,0.1030044),(6343,24947,0.15507849),(6344,8719,0.5263502),(6344,15527,0.3472564),(6344,16533,0.9268705),(6345,9795,0.5994981),(6345,11861,0.9110683),(6345,31606,0.7543807),(6346,4577,0.8774137),(6346,12660,0.90165514),(6346,26495,0.727425),(6346,26911,0.5120957),(6346,30742,0.657036),(6347,23859,0.86283624),(6347,26944,0.68658054),(6348,8113,0.692646),(6348,16175,0.93141496),(6348,20398,0.7330103),(6348,24699,6.650576e-3),(6348,24786,0.48374346),(6348,25164,0.91704446),(6348,27151,0.37369427),(6348,29299,0.1919709),(6348,31696,0.51633793),(6349,8787,0.28118035),(6349,8924,8.1575386e-2),(6349,20126,0.35630333),(6349,24462,0.80392885),(6349,27904,0.30801794),(6350,2607,0.14432006),(6350,5999,3.6856633e-2),(6350,6789,0.69311845),(6350,11129,0.12174735),(6350,11144,0.24905892),(6350,13970,0.22378162),(6350,28863,0.95807177),(6350,31505,0.38417628),(6351,5763,0.31213376),(6351,6247,0.850079),(6351,8845,0.2005438),(6351,12344,0.17866296),(6351,12360,3.2728843e-2),(6351,22745,0.40093395),(6351,30920,0.3972056),(6352,7169,0.2621127),(6352,8461,0.592121),(6352,8757,0.4696105),(6352,14781,0.8623032),(6352,15709,0.3939617),(6352,16356,0.4170096),(6352,23746,0.67361444),(6353,17461,0.3713062),(6353,22123,0.31347248),(6353,26482,0.38158202),(6354,16109,0.2440531),(6354,23631,0.46719038),(6354,24782,0.37755835),(6354,24863,0.74865675),(6355,21757,0.5094901),(6355,25417,0.18030156),(6356,12672,0.122924484),(6356,18665,0.8364798),(6356,23933,0.14478204),(6356,30126,0.32192633),(6356,30964,0.41057953),(6357,2666,0.25885493),(6357,18009,0.865504),(6357,21838,0.82163453),(6357,25856,0.117914386),(6357,32147,0.39786166),(6358,12724,0.9019122),(6358,18273,0.2146475),(6358,20189,1.3167096e-2),(6358,20193,0.1033152),(6358,20654,0.5715748),(6358,32034,1.9247681e-3),(6359,8736,0.80048174),(6359,8891,0.6869228),(6360,5763,0.7073274),(6360,23351,0.5470575),(6360,24867,0.86023206),(6361,4383,0.20713018),(6361,7501,0.2918395),(6361,20697,0.6055561),(6362,12679,0.14664684),(6362,20172,0.3541969),(6362,29902,0.81813157),(6362,29997,0.6819736),(6363,16866,7.102742e-2),(6363,23644,0.8061765),(6363,23731,0.75432026),(6363,27036,4.7921415e-2),(6364,15214,0.1957016),(6364,18967,0.66938484),(6364,19883,0.54646796),(6364,20347,0.3365076),(6364,27007,0.82817566),(6365,944,0.23636793),(6365,1106,0.31762493),(6365,4520,0.29581213),(6365,12493,0.16780941),(6365,20741,0.396217),(6365,20770,0.65424347),(6365,24169,0.6748224),(6365,29460,6.549539e-2),(6366,6962,0.20797116),(6366,7840,0.6447684),(6366,20518,0.17059956),(6367,2868,0.8930139),(6367,15259,0.6514219),(6367,28643,0.627326),(6368,7878,0.12124398),(6368,9497,0.45920086),(6368,11848,0.7566512),(6368,13466,0.75432134),(6368,22277,4.505067e-2),(6368,22468,0.6209258),(6369,8882,9.2247725e-2),(6369,15611,0.6474351),(6369,26782,0.2530857),(6369,31428,0.5173046),(6370,704,0.49685305),(6370,10545,0.30591512),(6370,15300,0.9749444),(6370,18962,0.33564472),(6370,22161,0.36516246),(6370,23448,0.6069456),(6371,8481,0.61845994),(6371,13599,0.7163661),(6371,13819,0.7827907),(6371,14058,0.58353007),(6371,19872,0.4201396),(6371,26308,0.28049174),(6371,26429,0.9354581),(6372,4025,2.1517532e-2),(6372,10857,0.64773834),(6372,12667,0.97460407),(6372,17674,0.5791255),(6372,22159,0.21761921),(6372,22679,0.6385284),(6372,26603,0.5308748),(6373,4971,0.8219634),(6373,6227,0.3282525),(6373,17536,0.5844609),(6373,19571,0.567034),(6373,22247,0.9053774),(6373,24702,0.3951507),(6373,29693,0.35126433),(6373,31726,0.7942463),(6374,5399,0.6754109),(6374,5412,0.6422649),(6374,21291,1.3319146e-2),(6374,22117,0.83545035),(6374,30321,0.27985853),(6374,31949,0.1495887),(6375,3404,0.54106146),(6375,5496,0.66639906),(6375,6577,0.22626126),(6375,7496,0.47427922),(6375,9414,0.32141793),(6375,23041,0.43892372),(6375,28867,3.406152e-2),(6375,30401,0.45117903),(6376,25515,0.41905683),(6376,27980,0.74358636),(6377,3062,0.8071971),(6377,6853,0.20639664),(6377,9495,0.43224597),(6377,9904,0.578853),(6377,17658,0.41074434),(6377,31135,0.36782387),(6378,1927,0.6165477),(6378,2637,0.49914333),(6378,12345,0.60003674),(6378,14549,0.14641704),(6378,15444,0.8547656),(6378,29732,0.68337905),(6378,32571,0.6462984),(6378,32668,0.8126952),(6379,8274,9.5235854e-2),(6379,15431,0.9595267),(6379,21416,0.71787375),(6379,23839,0.29296246),(6380,14325,0.60992557),(6380,28297,0.5421079),(6381,2691,0.6238387),(6381,5556,0.7704062),(6381,20517,0.44423378),(6381,32307,0.81878376),(6382,6227,0.50997055),(6382,12949,0.18753485),(6382,28206,0.5824467),(6383,1280,0.22073434),(6383,5764,0.6223117),(6383,15823,0.17247646),(6383,17040,5.3178404e-2),(6383,23213,0.6169868),(6383,31232,0.77217317),(6383,32544,6.1600665e-3),(6384,1147,0.42407632),(6384,4291,0.44189167),(6384,30984,0.96166867),(6385,1925,0.8052062),(6385,3718,0.6584787),(6385,10834,0.87947977),(6385,13070,4.0386714e-2),(6385,14468,0.6487491),(6385,31271,0.6104238),(6386,402,0.412457),(6386,1981,0.4579422),(6386,1985,0.74532896),(6386,16383,0.3977804),(6386,20425,8.376032e-2),(6386,29905,0.4593578),(6386,31983,0.5203469),(6388,1944,8.956279e-2),(6388,6019,0.29091692),(6388,7867,0.50520766),(6388,18778,0.74426657),(6388,20253,0.9813533),(6388,21555,0.4873288),(6388,24523,0.8516501),(6389,2357,0.822986),(6389,26507,0.53638744),(6389,32155,0.61467415),(6390,8318,0.48731056),(6390,10143,0.8589084),(6390,13394,0.4909526),(6390,20471,0.48035267),(6390,24516,0.3139526),(6390,25891,0.8452548),(6391,6091,0.1530115),(6391,15159,0.50320274),(6391,28381,0.75393116),(6391,32713,0.42818877),(6392,7233,0.8078298),(6392,14477,0.1994378),(6392,18321,0.24125978),(6392,29563,0.592416),(6393,5374,2.5512028e-2),(6393,13950,0.51132596),(6393,23007,0.102573775),(6393,27118,0.2833357),(6394,7252,0.8546201),(6394,8075,0.5329006),(6394,23768,0.21867834),(6395,250,0.47964197),(6395,1607,0.78208655),(6395,5535,0.8087393),(6395,21209,0.10475929),(6395,30333,3.2553196e-2),(6396,7566,0.7133793),(6396,13581,8.894125e-2),(6396,14254,0.5606583),(6396,27664,0.75136864),(6397,6082,2.7685955e-2),(6397,11629,0.24832961),(6397,11724,0.29909733),(6397,20169,0.6146304),(6397,22942,0.7549039),(6397,27021,0.9925763),(6398,2194,0.554834),(6398,3948,0.1657358),(6398,7672,9.261039e-2),(6398,14935,0.7104646),(6398,19440,0.23509742),(6398,22134,0.91756594),(6398,26576,0.5460114),(6399,6783,0.30670318),(6399,9417,0.5415431),(6399,11721,0.3954318),(6399,12764,0.32255042),(6399,13005,0.6287213),(6400,17264,0.2019938),(6400,25712,0.99841475),(6402,14303,9.187982e-2),(6402,22446,0.32890865),(6402,25185,0.9659787),(6403,4111,1.413056e-2),(6403,23711,0.6296555),(6403,26681,0.69391495),(6403,31559,0.90590835),(6404,833,0.5705765),(6404,7277,0.5694985),(6404,8632,0.50332177),(6404,9325,0.21701589),(6404,11885,0.2776747),(6404,11915,0.44295272),(6404,12792,0.8265324),(6404,27570,3.487301e-2),(6404,29444,0.72639567),(6404,31920,0.30748892),(6405,1409,0.18744625),(6405,2761,0.838154),(6405,5275,7.324492e-2),(6405,13114,0.5063528),(6405,15405,0.16133411),(6405,15697,9.078975e-2),(6405,15799,0.31888852),(6405,21117,0.5471489),(6405,23253,0.68385905),(6405,32224,0.8204454),(6406,11622,0.8168961),(6406,14802,0.99897677),(6406,30717,0.61886173),(6406,31334,4.424257e-2),(6407,967,9.08004e-2),(6407,5589,9.950388e-2),(6407,16115,0.18317917),(6407,30279,0.49801132),(6408,12948,0.48566508),(6408,26931,0.2707546),(6409,1523,0.24866083),(6409,8157,0.33702385),(6410,1815,5.1905148e-2),(6410,6236,0.6104782),(6410,10872,1.1885862e-2),(6410,12167,0.4241773),(6410,25264,0.43815386),(6410,32583,6.8130024e-2),(6411,1262,0.23775275),(6411,1265,0.9361775),(6411,2574,2.6363578e-2),(6411,3992,0.818559),(6411,4787,0.49415064),(6411,7572,0.39291647),(6413,4391,0.15975834),(6414,5126,0.93192667),(6414,5294,0.22355999),(6414,9275,0.504831),(6414,19390,0.34028405),(6414,19493,0.65842354),(6415,15917,0.45262775),(6415,25813,0.32768497),(6415,26349,0.11975512),(6415,26550,0.5711372),(6416,10913,0.24561584),(6416,14692,0.35759968),(6416,15185,0.1473277),(6416,16609,0.7579313),(6416,20903,4.952331e-2),(6417,18713,0.9868779),(6418,8694,0.9736703),(6418,9520,0.77030843),(6418,14150,0.13400267),(6418,19471,0.932772),(6418,19742,0.45708793),(6418,20600,0.78225255),(6418,27923,0.23221406),(6419,9114,0.75519776),(6419,14424,0.7900971),(6419,18478,0.3687892),(6419,26587,0.11775613),(6419,28037,0.8818046),(6419,29131,0.41174346),(6420,14117,0.9819384),(6420,18084,0.643506),(6421,886,0.32615158),(6421,4854,0.9646142),(6421,10406,0.55233806),(6421,18436,0.96598697),(6421,19643,0.66442025),(6421,23148,0.7363558),(6422,7659,0.60223156),(6422,15349,0.7248417),(6422,18235,0.9850634),(6422,25987,0.6325448),(6422,31224,0.256447),(6422,31655,0.36445644),(6423,1043,0.3897693),(6423,10822,0.100479215),(6423,11774,0.27649972),(6423,20736,0.38571927),(6423,24886,0.9196055),(6423,29218,0.9032645),(6424,7979,0.903426),(6424,12030,0.27856848),(6424,14588,0.6732432),(6424,15325,0.7322876),(6424,24514,0.1893389),(6424,29593,6.350561e-2),(6425,13733,0.3885726),(6425,22360,0.43669614),(6426,939,0.6519651),(6426,2553,0.14945556),(6426,13490,0.5977942),(6426,22168,0.44399026),(6426,23508,0.98770654),(6426,23751,0.2959984),(6426,31037,0.9302062),(6427,2899,0.40086266),(6427,5933,2.3493953e-2),(6427,25699,0.19973515),(6428,8260,0.31175348),(6428,15841,0.72314495),(6428,23951,0.17476957),(6428,30969,4.157044e-2),(6428,31624,0.100887276),(6429,258,0.8166228),(6429,799,0.9670558),(6429,2339,0.78394127),(6429,3487,0.9483375),(6429,12219,0.4410866),(6429,13185,0.83419114),(6429,17869,0.11728791),(6429,22269,0.35536644),(6429,27106,9.543004e-2),(6430,617,0.6727658),(6430,7393,0.9164574),(6430,12825,0.79015315),(6430,24427,0.779603),(6430,24723,0.11113547),(6431,718,0.9882775),(6431,6892,0.51314056),(6431,8049,0.33519563),(6431,13786,0.29314482),(6432,6296,0.9004422),(6432,7927,0.33736208),(6433,5413,0.7387409),(6433,11278,0.7584071),(6433,11532,0.8572854),(6434,804,0.3137207),(6434,12334,0.4391162),(6434,14677,0.6402678),(6434,14767,0.44215572),(6434,21471,0.7609514),(6434,24042,0.7728192),(6434,31282,0.6115924),(6435,9274,0.9499572),(6435,11657,0.7749232),(6435,13021,7.141804e-2),(6435,13585,0.9993763),(6435,32166,0.94646376),(6436,371,0.28345546),(6436,4925,0.84784365),(6436,8941,0.50096744),(6437,2546,0.8277138),(6437,12515,0.271227),(6437,15189,0.5502539),(6438,2371,0.96592283),(6438,4518,0.9370665),(6438,7076,0.5711938),(6438,13141,0.4853139),(6438,16673,0.74474996),(6438,18586,0.7159645),(6438,20654,0.9287567),(6438,26643,0.89354926),(6438,29410,0.45261234),(6439,677,0.322514),(6439,3578,0.89785624),(6439,3771,0.70026857),(6439,7274,0.78869814),(6439,21957,0.6585317),(6439,22283,4.0022032e-3),(6439,23817,0.11108302),(6439,32496,0.93297654),(6440,11547,5.2411715e-3),(6440,19134,4.846947e-2),(6440,19504,0.7531755),(6440,24914,0.67734665),(6441,12224,0.22577846),(6441,17431,0.38775858),(6442,2086,0.394203),(6442,2597,0.6010329),(6442,6794,0.13159136),(6442,7383,0.35424355),(6442,16724,0.11342117),(6443,7657,0.33352968),(6443,9490,0.7601623),(6443,14361,0.6043595),(6443,15694,0.5403681),(6443,19977,0.74992853),(6443,30203,0.17947064),(6444,5887,0.26345673),(6446,702,0.8450453),(6446,9220,0.4795628),(6446,11408,0.13923486),(6446,27109,0.7880133),(6447,23896,0.88196665),(6447,25297,5.7316918e-2),(6447,31367,7.194949e-2),(6448,1598,0.1714167),(6448,9360,0.85349923),(6448,14356,0.24561703),(6449,12756,0.509139),(6449,16725,0.44309843),(6449,16752,5.066221e-2),(6450,8674,8.735626e-2),(6450,9691,6.322331e-2),(6450,12323,0.67740566),(6451,4420,0.8388687),(6451,8204,0.98436236),(6451,13368,6.5617025e-2),(6452,9071,0.8060528),(6453,12129,0.43370536),(6453,15860,0.25163558),(6453,16208,0.21955104),(6453,21370,0.3886316),(6453,22290,0.33559933),(6454,16265,0.7959989),(6455,26012,0.36256757),(6456,27154,0.18888545),(6456,31774,0.23261203),(6457,6661,0.6071229),(6457,9330,0.22451146),(6457,21171,0.36771598),(6457,23360,0.9421848),(6458,14924,0.15282993),(6458,19359,0.8261029),(6458,27278,0.89382607),(6459,590,0.836837),(6459,11351,0.9576844),(6459,16213,0.76738596),(6459,18525,0.689052),(6459,21290,0.99306494),(6459,24380,0.10373462),(6459,26284,0.44745833),(6459,27660,0.2919916),(6459,32624,0.6850534),(6460,1751,0.47037125),(6460,16077,0.94848037),(6460,20044,0.14318801),(6460,21527,0.6138519),(6460,30133,0.11675891),(6461,9784,0.38151792),(6461,10775,0.6663436),(6461,11713,1.7259726e-2),(6461,22824,0.3745031),(6461,29096,0.9748355),(6462,2109,0.25434333),(6462,6653,0.99090636),(6462,12447,0.20725416),(6462,16107,0.6697402),(6463,10256,0.58631516),(6463,17651,8.9418665e-2),(6463,21977,0.9387728),(6463,25230,0.85283285),(6464,2159,0.5441115),(6464,5256,0.7280358),(6464,7900,0.2759048),(6464,18644,0.9702003),(6464,19984,0.3408294),(6465,6843,0.23095758),(6465,8676,0.48369893),(6465,9508,0.11059048),(6465,13099,0.10563272),(6465,19939,0.30157465),(6465,30770,0.4648426),(6466,11931,0.5837999),(6466,30382,7.4955267e-3),(6467,2944,0.2321097),(6467,7499,0.16382372),(6467,10756,0.6572588),(6467,14833,0.83861065),(6467,19464,0.3963764),(6467,20871,8.213474e-2),(6467,22605,0.43093875),(6467,30161,0.3911594),(6468,16554,0.25812048),(6469,2766,0.20880167),(6469,13820,0.44630265),(6469,22619,2.7271584e-2),(6469,30145,0.4499718),(6470,1194,0.69020724),(6470,5028,0.8865618),(6470,18700,0.62476426),(6470,19439,0.19874057),(6470,27618,0.764631),(6471,4904,0.50504375),(6471,7215,0.6121911),(6471,22388,0.9654855),(6472,5957,0.25180772),(6472,15640,0.5305512),(6473,496,0.27523494),(6473,2396,0.6028439),(6473,4088,0.8805206),(6473,17449,0.5250957),(6473,27329,0.6301161),(6474,5795,0.17784347),(6474,13134,0.17758176),(6474,16083,0.5775382),(6474,20658,3.5310045e-2),(6474,26128,0.36997473),(6474,27213,0.6011082),(6475,7949,0.9923002),(6475,19994,0.5856827),(6475,21335,0.8987224),(6475,23420,0.3683382),(6476,3030,9.480327e-2),(6476,14999,0.7882215),(6477,3692,0.68219763),(6477,12650,0.7691582),(6477,23759,1.7455898e-3),(6477,30211,0.15914813),(6477,31891,0.24767633),(6478,11037,0.19837159),(6478,20740,0.83141005),(6478,24937,0.22274347),(6479,3192,0.98404473),(6479,5834,0.16909613),(6479,5895,0.3418429),(6479,10270,0.6430392),(6479,12171,0.436205),(6479,14741,0.4850578),(6479,16272,0.11964853),(6479,19191,0.29264787),(6479,26379,0.93917376),(6480,9406,0.96010244),(6480,11864,0.5149448),(6480,15699,0.48421437),(6480,32388,0.8252057),(6481,3341,0.34086815),(6481,8957,0.52428156),(6481,12363,0.23700309),(6481,12833,0.84602743),(6482,5492,0.8845248),(6482,6305,0.8517671),(6483,5283,1.8171804e-2),(6483,14227,0.98003393),(6483,16228,0.75411135),(6483,20198,0.5139899),(6483,22363,0.8538773),(6483,31978,0.8123131),(6484,3184,0.7917605),(6484,8019,0.6514609),(6484,11793,0.8624259),(6484,15359,0.6841394),(6484,17294,0.4573512),(6484,18209,3.677408e-2),(6485,3015,0.2684161),(6485,9361,0.24920811),(6485,12578,0.9186804),(6485,15671,0.5057823),(6486,10898,0.16668873),(6486,11230,0.60745597),(6486,19364,0.30234525),(6487,3959,0.9976968),(6487,6682,0.9569847),(6487,9229,0.6180056),(6487,9827,0.36576268),(6487,22336,0.47423846),(6488,2905,0.34535456),(6488,2938,0.5085378),(6488,3206,0.8636956),(6488,5051,0.9255788),(6488,6007,0.70686394),(6488,12600,0.42779168),(6488,12879,0.22239919),(6489,2060,0.8489593),(6489,23082,0.674953),(6489,25194,0.70165336),(6489,28197,0.8681184),(6490,9711,0.71969944),(6490,10975,0.5849291),(6491,613,0.73241407),(6491,13100,0.8398516),(6491,13298,0.20999804),(6491,15337,0.6651361),(6491,24043,0.3088159),(6492,4879,0.47999024),(6492,9814,0.19228621),(6492,12015,0.58881205),(6493,7007,0.5539568),(6493,7998,0.67786676),(6494,13834,4.0517595e-2),(6494,16372,0.43094876),(6494,22980,8.486107e-2),(6495,568,4.292324e-3),(6495,4432,0.40236115),(6495,14546,0.14118776),(6495,23132,0.8605356),(6495,27780,0.6423045),(6495,28323,0.34820315),(6496,1064,0.23477161),(6496,2714,0.48749182),(6496,9101,0.6258438),(6496,16081,0.4425706),(6496,27203,0.18935925),(6496,29129,0.87164265),(6497,10594,1.3338566e-2),(6497,11057,0.24838416),(6497,32571,0.31787318),(6498,10085,0.4108355),(6498,16228,0.124650985),(6498,17489,0.44799882),(6499,23087,0.27315018),(6499,25826,0.25476187),(6500,1224,0.6834113),(6500,1645,0.32105404),(6500,3787,0.38922366),(6500,10170,0.50970495),(6500,21690,0.25003868),(6501,5518,0.90682054),(6501,5963,0.4325002),(6501,20508,0.9020477),(6501,21738,0.9378395),(6502,11756,0.9596236),(6502,18133,0.626692),(6503,759,0.24267787),(6503,1903,1.2001331e-2),(6503,5739,0.5453011),(6503,6299,0.9716285),(6503,12419,0.12432629),(6503,15026,8.258083e-2),(6503,17175,0.9044111),(6503,18676,0.6789377),(6503,25199,0.8546516),(6503,32497,0.28891304),(6504,9538,0.711296),(6504,29746,0.9390323),(6504,30949,0.2161327),(6505,1414,5.5937704e-2),(6505,5206,0.44166598),(6505,17101,0.82911456),(6505,18291,0.7394536),(6505,20438,0.509546),(6506,489,0.9491521),(6506,2643,0.12617643),(6506,4902,9.988393e-2),(6506,13448,3.9654944e-2),(6506,19439,0.33678865),(6506,31869,0.107443035),(6507,11238,5.8038283e-2),(6507,15646,0.93311816),(6507,18051,0.8424422),(6507,29281,0.64911705),(6508,1666,0.39609987),(6508,15219,0.5406482),(6508,16647,0.16627647),(6508,27916,0.74409854),(6509,5963,1.2762883e-2),(6509,13325,7.469995e-2),(6509,25168,0.67191046),(6509,32224,0.63735217),(6510,5962,0.77462506),(6510,7145,0.78591347),(6510,8984,0.12297644),(6510,11931,0.83909535),(6510,22626,0.5228255),(6510,28761,0.51252884),(6512,23265,0.46796468),(6512,25283,0.4098027),(6512,30515,0.74134797),(6513,4185,0.17796598),(6513,5373,0.5910205),(6513,17918,0.61158544),(6513,27262,0.39955363),(6514,7354,0.39306474),(6514,8655,0.48650697),(6514,21176,0.55863005),(6514,24143,0.81724614),(6515,30361,7.248277e-2),(6516,7180,0.8857954),(6516,13977,0.33585936),(6516,16210,0.4396679),(6516,28215,0.13266234),(6516,31613,0.9569087),(6517,19791,0.7743487),(6517,21020,0.4413887),(6518,4584,0.5450788),(6518,4631,0.5971057),(6518,8557,0.68750364),(6518,27821,0.47816664),(6519,3441,0.21765491),(6519,9687,0.3436675),(6519,14881,0.9048665),(6519,15258,0.5194126),(6519,18324,0.63143635),(6519,23934,0.68076164),(6520,870,0.87871224),(6520,9160,0.26966986),(6520,11072,6.24064e-2),(6520,12388,0.33055502),(6520,18660,0.21473165),(6520,21274,0.26098225),(6520,23072,0.67304146),(6520,25691,0.9374891),(6521,1490,0.82129556),(6521,5195,0.24696697),(6521,14532,0.91503465),(6522,1850,2.0928225e-2),(6522,5493,0.21825962),(6522,6688,0.75534356),(6522,15864,0.75641716),(6522,23819,0.30048946),(6522,25163,0.8671694),(6522,27624,1.4835658e-2),(6522,29485,0.92720795),(6522,29633,0.39489603),(6523,3975,6.43915e-2),(6523,6305,2.2268947e-2),(6523,10090,0.8698942),(6523,12721,0.94216955),(6523,19559,0.46480194),(6523,26882,0.4765167),(6524,3312,0.62397295),(6524,3565,0.45268753),(6524,4009,0.41569152),(6524,8942,0.16797872),(6524,13247,0.16592379),(6524,22427,0.68891376),(6525,10304,0.7833427),(6526,9814,0.6418489),(6526,18122,0.88425875),(6526,22102,0.27440417),(6527,14718,8.892721e-2),(6528,4556,0.69895214),(6528,11863,2.3357002e-2),(6528,16859,0.96752197),(6528,17052,0.86051476),(6528,25823,0.5004045),(6528,28231,0.77144235),(6529,1148,0.9199056),(6529,21897,0.95822865),(6530,6900,0.5363704),(6530,9813,0.49226075),(6530,12853,0.34472105),(6530,19434,0.48639494),(6530,27219,0.728128),(6531,6932,0.7441378),(6531,18906,0.16588403),(6531,20525,0.40984768),(6531,30001,0.8423266),(6532,6009,0.6463644),(6532,19241,0.5877861),(6532,19346,1.4686851e-2),(6532,20071,0.24678887),(6532,27729,0.7101929),(6533,10835,0.59062964),(6533,12211,0.21704426),(6533,12543,0.56452274),(6534,9011,0.39837152),(6534,27611,0.77743626),(6535,8228,0.37664735),(6535,10864,0.9610622),(6535,11900,0.8254828),(6535,15027,0.4551448),(6535,17740,0.21295829),(6535,28156,8.3413646e-2),(6536,5948,0.2292769),(6536,18268,5.0281923e-2),(6536,20076,0.5273163),(6536,21300,0.8869799),(6537,7142,0.644854),(6537,21455,6.0290415e-2),(6537,23134,4.973036e-2),(6537,27450,0.23206642),(6538,8145,0.79243493),(6538,12196,1.6117802e-2),(6538,16324,6.283929e-2),(6538,24920,0.55163336),(6538,26070,0.3346507),(6539,886,0.9764635),(6539,2105,0.22800723),(6539,7277,0.71462137),(6539,19296,0.34206727),(6539,22621,0.57495326),(6539,24022,1.075642e-3),(6540,3847,0.76878995),(6540,4750,0.19736059),(6540,5058,0.7797207),(6540,14916,4.2553935e-2),(6540,15264,0.5959058),(6540,19947,0.6386612),(6540,32418,0.3935495),(6541,18338,0.5606585),(6541,19438,9.139233e-2),(6541,31963,0.58529687),(6542,7559,2.5873749e-2),(6542,8098,0.34836903),(6543,14790,0.5009029),(6543,14965,0.30461562),(6543,16795,0.30537635),(6543,17060,0.7817629),(6543,23140,0.96826386),(6544,8377,0.74648345),(6544,16055,0.41693604),(6544,18652,0.6346344),(6544,27331,0.54887754),(6545,9102,0.7998541),(6545,15088,0.4733065),(6546,7065,0.16007034),(6547,19645,5.7211794e-2),(6547,26836,0.22289038),(6547,27323,0.34556025),(6547,28656,5.1756486e-2),(6548,1520,0.56142765),(6548,2265,0.10389456),(6548,31297,0.43258247),(6549,2933,0.9795846),(6549,12939,0.915805),(6549,19274,0.18427412),(6549,20601,0.21829142),(6549,22345,0.9878265),(6549,24321,0.35543406),(6550,11605,0.828812),(6550,16974,0.825488),(6551,440,0.24239682),(6551,3279,0.5325616),(6551,6707,0.229924),(6551,18308,0.7162436),(6551,20915,1.1191171e-2),(6551,21936,0.2625073),(6551,22244,0.672104),(6551,25300,0.6871187),(6551,27659,0.45331344),(6551,30460,0.47166246),(6552,7413,0.58935386),(6552,10431,0.8017647),(6552,13210,0.6951848),(6552,25970,5.920992e-3),(6553,6906,0.8017685),(6553,11613,6.244464e-2),(6553,12566,0.9519226),(6553,14640,0.8629554),(6553,22894,0.5040335),(6553,24301,0.8727177),(6553,31667,0.37807563),(6554,12367,0.91014826),(6554,14538,0.15402062),(6554,23937,0.2875691),(6554,28013,0.5453),(6555,9171,0.48115933),(6555,10473,0.23960188),(6555,16719,0.3679077),(6555,17364,0.20069243),(6555,24134,0.2681271),(6555,30196,0.65363103),(6556,28865,0.43329966),(6557,12099,0.4486528),(6557,12896,0.95956874),(6557,21984,0.97637045),(6558,9865,0.5244224),(6558,26220,1.4108516e-2),(6559,1929,0.594093),(6559,11197,0.35832608),(6559,13592,0.29106492),(6559,29121,0.5754886),(6560,4349,0.1587269),(6560,7714,0.86009234),(6560,13049,4.448933e-3),(6560,24246,0.30164602),(6561,4167,0.776882),(6561,7306,0.41765708),(6561,28165,0.88607395),(6561,30605,0.6113205),(6562,1464,0.45989218),(6562,11423,0.10685275),(6562,25367,0.24844636),(6563,231,0.92282295),(6563,19976,0.25968483),(6563,22202,0.2557542),(6563,22811,0.63263834),(6564,5009,0.27423295),(6564,7161,0.9596896),(6565,674,0.40377384),(6565,2035,0.3214633),(6565,6698,0.5411059),(6565,11248,0.67141676),(6565,28853,0.9756711),(6565,30202,0.2878356),(6566,7731,0.7310022),(6566,15821,0.9229246),(6566,30203,4.265142e-2),(6567,11759,0.15533373),(6568,2396,0.52505964),(6568,24010,0.473028),(6568,24750,0.16072987),(6569,3233,0.60362154),(6569,17394,0.8725059),(6569,17494,2.5398044e-2),(6569,26880,0.6584365),(6570,10871,0.60544825),(6570,23120,0.35936323),(6570,23254,0.802698),(6570,24375,0.9020808),(6571,3614,0.45230234),(6571,5680,0.37480354),(6571,23956,0.43395564),(6571,24978,0.43820813),(6572,11279,0.37732235),(6572,13146,0.26124394),(6572,15412,0.7161835),(6572,19740,0.83611137),(6573,3835,0.28867006),(6573,5191,0.97972935),(6573,9119,0.6318579),(6573,17565,4.694165e-2),(6573,18596,0.3961789),(6573,23494,0.24186146),(6574,4168,0.11739043),(6574,8433,0.166158),(6574,17455,1.8242812e-2),(6574,26256,0.7013542),(6574,29235,0.7573643),(6574,31338,0.79487777),(6574,31686,0.3188149),(6575,4902,0.60680556),(6575,6140,0.78485614),(6575,13677,0.32968432),(6575,14191,5.2680954e-2),(6575,23231,0.755779),(6575,30855,0.16681466),(6576,4054,0.24570622),(6576,4260,0.8646268),(6576,9550,0.7241776),(6576,9577,8.740078e-2),(6576,12319,0.67885566),(6576,12383,0.19298482),(6576,17480,0.4395441),(6576,23752,0.688371),(6576,25011,4.70135e-3),(6576,26008,0.7321257),(6577,2194,0.6362961),(6577,19896,0.22968863),(6577,28580,0.14185853),(6577,32255,0.36351427),(6578,2228,0.5106933),(6578,11588,0.8927482),(6578,13672,0.9140189),(6578,15614,0.14632973),(6578,22051,0.2574698),(6579,8151,0.21025129),(6579,8507,0.2489874),(6580,2903,0.49869812),(6580,15539,7.646811e-2),(6581,20421,0.30407318),(6582,2242,0.4379374),(6582,2284,0.40019196),(6582,18030,0.8157931),(6583,2892,0.23613249),(6583,6070,4.51229e-2),(6583,15761,0.114303224),(6583,23506,0.62793183),(6583,29132,0.22311437),(6583,29767,0.8564219),(6584,8516,0.29711318),(6584,21940,0.5369369),(6585,626,0.9486795),(6585,4541,0.11011959),(6585,11362,0.14288166),(6585,15414,0.8979979),(6585,19623,0.89382344),(6585,26136,0.1452869),(6586,493,0.16092928),(6586,1544,8.148171e-2),(6586,1869,0.62251437),(6586,2171,0.43452644),(6586,4544,0.91237396),(6586,26256,0.106566526),(6586,31194,0.49963135),(6587,16,0.56320274),(6587,17501,0.9438052),(6587,19043,0.1908616),(6587,19258,0.8315775),(6588,5076,0.17786705),(6588,21997,0.8761722),(6588,28302,0.14455627),(6589,18349,0.67538613),(6589,23291,0.60829234),(6590,573,0.14662397),(6590,5592,0.676206),(6590,17437,0.1792655),(6590,26503,0.8223722),(6591,14691,0.42925912),(6591,21031,0.9403862),(6591,22957,0.49513423),(6591,29301,0.19337775),(6592,3582,0.39582705),(6592,13702,4.8410848e-2),(6592,14633,0.13358985),(6592,17699,0.5749294),(6592,26636,0.100256756),(6593,4467,9.6150525e-2),(6593,14676,0.3486546),(6593,28398,0.4682586),(6593,30421,0.3666235),(6593,31334,0.9753487),(6594,29190,0.37265328),(6594,31610,0.41582772),(6595,7092,0.5916404),(6595,21265,0.74446386),(6595,22739,0.880254),(6595,27198,0.1703472),(6596,1694,0.8953966),(6596,10177,0.8534781),(6596,13167,0.14153746),(6596,25144,0.6120184),(6596,31642,0.46295542),(6596,32666,0.8524621),(6597,8499,1.0254416e-2),(6597,9609,0.14120454),(6597,14810,0.25189877),(6597,15242,0.48359483),(6597,15781,0.34148785),(6597,18206,0.14430247),(6597,27937,0.44245166),(6598,840,0.4746515),(6598,31097,0.9805811),(6599,746,0.59769595),(6599,23619,0.37904838),(6599,28166,0.8148274),(6599,28188,0.892529),(6600,28307,0.5406887),(6601,3401,0.96544397),(6601,9677,0.25637582),(6601,10242,5.3005457e-2),(6602,833,0.25970733),(6602,7720,0.898646),(6602,23038,0.7695648),(6602,27953,0.6568362),(6602,28711,0.28264984),(6602,31146,0.7374088),(6603,4524,0.20523551),(6603,7230,0.5550207),(6603,15698,0.35911086),(6603,31180,2.923987e-2),(6604,725,0.63995624),(6604,1174,0.24774043),(6604,2912,0.4120825),(6604,19270,0.8001112),(6604,32299,0.859836),(6605,11071,0.1456148),(6605,19898,0.101673245),(6605,20922,0.4865906),(6605,25604,0.74955744),(6605,27223,0.7562762),(6606,2937,0.76380384),(6606,9530,0.75818056),(6606,19897,0.31289145),(6606,24849,0.46115467),(6607,20878,0.2880731),(6607,32410,0.57150626),(6608,9014,0.9142093),(6608,20364,3.251668e-2),(6609,428,0.65810585),(6609,5066,0.46682036),(6609,10910,0.9199741),(6609,18596,0.24392998),(6609,24417,0.1866038),(6610,10260,0.96102077),(6610,11886,0.62318486),(6610,13169,0.8603449),(6611,9662,0.25663146),(6612,253,0.7986095),(6612,10352,0.82864535),(6612,20617,0.28951246),(6612,23195,0.9995733),(6612,24736,0.5777141),(6612,32047,0.569879),(6613,1928,6.294829e-2),(6613,18281,0.22888227),(6613,19191,0.49088883),(6613,19583,0.8644376),(6613,25604,0.92637175),(6614,10028,0.79344684),(6614,14420,0.45896703),(6614,25480,0.28693026),(6615,2930,0.85636634),(6615,4919,0.52588814),(6615,8149,0.40634838),(6615,13514,5.504091e-2),(6615,23399,0.84723985),(6616,1857,0.41136786),(6616,2110,0.36843127),(6616,7401,0.67241514),(6616,8996,0.93040067),(6616,24223,0.55323845),(6616,26153,0.3539365),(6616,26835,5.554559e-2),(6616,27838,0.18729323),(6617,19011,0.13265143),(6618,6110,0.96286297),(6618,9208,9.909779e-3),(6618,10485,0.8973694),(6618,10861,2.6867162e-2),(6618,22748,8.201778e-2),(6618,30714,0.34732735),(6619,9054,5.1232543e-2),(6619,24782,4.1399345e-2),(6620,1737,0.36099225),(6620,8310,7.628947e-2),(6620,13556,0.20546415),(6620,15667,0.5783129),(6621,340,0.328432),(6621,6495,7.818829e-2),(6621,13434,0.90946656),(6621,14803,0.8504794),(6621,21329,0.91697377),(6621,22367,0.38228035),(6621,22496,0.459687),(6621,23205,0.40457225),(6622,5005,0.13186616),(6622,8701,0.5818039),(6622,15440,0.7456134),(6622,16555,0.2710213),(6622,22159,0.1932378),(6622,31751,5.2261062e-2),(6623,3356,4.0518593e-2),(6623,9513,0.88499796),(6623,22046,0.16694444),(6623,24244,0.7313736),(6624,1630,0.24753274),(6624,3876,0.37199047),(6624,10475,0.6171671),(6624,30369,0.573949),(6625,14367,0.23014796),(6625,15188,0.108008675),(6625,19507,0.6913843),(6625,21116,0.74410623),(6625,31726,0.97243),(6626,4491,0.7309974),(6626,13572,0.2236493),(6626,26661,0.8557732),(6627,896,0.6233094),(6627,1692,0.151962),(6627,15675,0.57279766),(6627,21062,0.30966923),(6627,23881,0.29502472),(6627,28602,0.66396904),(6628,20460,0.9713694),(6628,30721,0.4577076),(6628,31395,0.74729776),(6629,10986,0.23054941),(6629,18325,0.18417317),(6629,29039,0.370097),(6630,16960,0.16784774),(6630,32222,0.84583557),(6631,743,4.4402212e-2),(6631,3447,0.6779688),(6631,18527,0.7198728),(6631,21985,0.7358272),(6631,22416,2.6441573e-3),(6631,25335,6.849866e-2),(6631,28832,0.9232432),(6631,30485,0.70238507),(6632,7,0.7209513),(6632,2855,0.710934),(6632,7587,0.15911096),(6632,8066,0.896076),(6632,12106,5.3778153e-2),(6632,14512,0.7178657),(6632,26165,0.5603267),(6632,26626,7.1483175e-4),(6632,27056,0.28106877),(6633,4093,0.98952603),(6633,8141,0.11332651),(6633,21906,0.8093687),(6633,27931,0.32308432),(6633,29381,0.23367904),(6634,22418,0.28820693),(6634,30070,0.18503714),(6636,4090,0.7488847),(6636,10834,0.9466152),(6636,22718,0.7364529),(6636,23271,0.6197716),(6636,23967,0.8328506),(6637,2599,0.81021065),(6637,3687,0.36136281),(6637,21152,0.74842733),(6637,26220,2.7495943e-2),(6637,31657,0.19446795),(6638,20364,0.6739565),(6638,23954,0.44919875),(6639,7065,0.42276675),(6639,7252,0.6358781),(6639,10256,0.7311202),(6639,23449,0.5473074),(6640,508,0.107737586),(6640,3449,0.8591796),(6640,6656,0.34372976),(6640,21960,0.40373453),(6640,23003,0.2605034),(6641,3717,0.37772423),(6641,13328,9.900872e-2),(6642,7992,0.90867305),(6644,1553,0.25661075),(6644,16471,0.4470898),(6644,21706,4.1806974e-2),(6644,23664,0.40771723),(6645,15428,3.251899e-2),(6645,18621,0.6520088),(6646,6704,0.55814844),(6646,14508,0.4918914),(6646,25576,0.18569316),(6647,12399,0.66893697),(6647,14992,0.14610134),(6647,19168,0.51270515),(6648,6692,0.48572874),(6648,19827,0.36748227),(6649,17788,0.631245),(6649,25677,3.787809e-2),(6649,26824,0.5845605),(6649,29657,0.90705866),(6650,5707,8.1895836e-2),(6650,12024,0.39381418),(6650,22092,0.5395356),(6650,22831,0.36156797),(6651,2648,0.4696902),(6651,12576,6.233154e-3),(6651,18078,0.10625434),(6651,24551,0.7654017),(6651,26585,0.8993252),(6651,31228,0.52991796),(6652,15437,0.5451576),(6652,15938,0.22779325),(6653,1202,0.6283051),(6653,6176,1.41190635e-2),(6653,8538,0.5048871),(6653,15898,8.034697e-2),(6653,23674,0.25836244),(6654,4542,0.7429157),(6655,7346,0.27552447),(6655,16673,0.3736959),(6655,21418,3.62321e-2),(6655,24007,0.83222777),(6656,416,0.372723),(6656,1491,0.78994524),(6656,2080,0.50237095),(6656,16919,0.19911133),(6656,25309,0.4823223),(6656,26553,0.5397724),(6656,28390,0.28767538),(6657,7964,0.7036951),(6657,20277,0.4734284),(6657,28078,0.87359136),(6657,32041,0.506813),(6657,32287,0.76811624),(6658,1626,9.1902345e-2),(6658,1988,0.7045573),(6658,5662,0.8158342),(6658,19541,0.2424153),(6658,23456,0.26695612),(6659,13415,8.785088e-2),(6659,22800,2.6676254e-2),(6660,1161,0.40815923),(6660,11824,0.5576515),(6661,5906,0.233224),(6661,12051,0.53750724),(6661,21833,0.69165796),(6662,5652,0.40546918),(6662,6707,2.147819e-2),(6662,13546,0.14939542),(6663,2655,0.5657645),(6663,6617,0.14606366),(6663,14847,5.533464e-2),(6663,15463,8.759055e-2),(6663,31013,0.62630486),(6664,14488,0.663006),(6664,18320,0.49394706),(6664,21803,0.5309158),(6664,26058,0.52580535),(6664,32582,0.7204524),(6665,20642,0.5494917),(6666,1226,0.5903964),(6666,10273,0.62613374),(6666,10534,3.8904537e-2),(6666,12888,0.84121454),(6666,17844,0.5560135),(6666,22502,0.1760297),(6666,25268,0.77728873),(6667,5818,5.935547e-2),(6667,32567,0.14603053),(6668,10291,0.45149413),(6668,13905,0.14540741),(6669,16241,0.7150553),(6669,31094,0.4522769),(6670,8405,4.9067855e-2),(6670,11256,0.60621256),(6671,2306,0.9313063),(6671,2729,0.6078025),(6671,27730,0.5171411),(6671,29555,0.631998),(6672,755,0.27281567),(6672,8627,0.89612955),(6672,11461,0.50084716),(6672,27531,0.94990945),(6673,12596,0.82200795),(6673,14076,0.3027748),(6673,18412,0.31306222),(6673,23240,8.308628e-2),(6673,24626,0.29909682),(6674,32161,0.827077),(6675,6307,0.78898937),(6676,335,9.8493874e-2),(6676,6011,0.83515984),(6676,6200,0.90453774),(6676,29471,0.27227694),(6676,30621,0.73732376),(6677,11386,0.5489986),(6677,28490,0.81272453),(6678,571,0.7917978),(6678,20638,0.9889094),(6678,30987,0.22366987),(6679,1744,0.12990122),(6679,8156,0.693447),(6679,15951,0.53944683),(6679,18180,0.24936722),(6679,19910,0.57261664),(6679,22380,4.2085033e-2),(6679,27127,0.4702297),(6680,990,0.6110313),(6680,2618,0.85191625),(6680,15912,3.5401266e-2),(6680,19393,0.9100212),(6680,30490,0.6909685),(6681,3626,0.7759072),(6682,591,0.59592104),(6682,7089,0.20531692),(6682,11158,0.56223476),(6682,12928,0.15032093),(6682,25208,0.25319967),(6682,27696,0.5370397),(6682,29253,0.366034),(6683,3748,8.9806326e-2),(6683,10952,0.39632234),(6683,18827,0.66616166),(6683,22261,0.48079637),(6683,25038,0.9525462),(6685,11275,0.5123521),(6685,20228,0.70595),(6685,23541,0.49743113),(6685,28925,0.5924336),(6685,31186,0.16566089),(6686,9733,0.21699373),(6687,10561,0.5273909),(6688,4965,0.94044846),(6688,15066,0.11588996),(6688,18020,0.9285683),(6688,20100,0.9621141),(6688,32755,0.7057404),(6689,11284,0.52035975),(6689,17782,7.657471e-2),(6689,28866,0.43672508),(6689,29127,0.5444402),(6690,3371,0.9346899),(6690,10178,0.32570913),(6690,13260,1.3420378e-2),(6690,19801,0.6799226),(6690,31650,0.68933725),(6691,4449,6.502025e-2),(6691,14239,4.5625374e-2),(6691,21245,0.6123753),(6691,28708,0.8243881),(6691,31706,0.81468946),(6692,5817,0.10101264),(6692,13812,0.72155803),(6692,16541,0.38444093),(6692,17972,0.120883256),(6693,6613,0.35578173),(6693,9664,0.5095397),(6693,11854,0.52085847),(6693,25886,0.6060182),(6693,30343,0.79501265),(6694,1005,0.8134624),(6694,1587,0.780843),(6695,12600,0.35984764),(6695,15273,0.43621355),(6695,26075,0.18415676),(6695,29521,0.81873703),(6696,5206,0.32675955),(6696,24323,0.9512142),(6696,32501,0.15026994),(6697,621,0.18367852),(6697,10178,0.16675392),(6697,12974,0.78443354),(6697,17831,0.3021731),(6698,9004,0.5531655),(6698,11211,9.696785e-2),(6698,12293,0.5942658),(6698,19918,0.17543027),(6699,19376,0.37193534),(6700,8791,0.43034837),(6700,13242,0.5212012),(6700,14406,0.806627),(6700,24250,0.13281941),(6701,18971,0.10723847),(6701,30210,0.8589522),(6702,566,8.582122e-3),(6702,11430,0.5018381),(6702,11864,0.7065178),(6702,16699,2.8953234e-2),(6702,23763,0.2477612),(6702,29978,0.7288371),(6703,4193,0.47706375),(6703,18287,0.12146851),(6703,18310,6.0744274e-2),(6703,18359,4.4587657e-2),(6703,22305,0.7975645),(6704,5909,0.28509405),(6704,10219,0.37390515),(6704,28651,5.025417e-2),(6704,31778,0.25135353),(6705,14161,0.8308),(6705,15497,8.276796e-2),(6705,23457,0.7892679),(6705,25022,0.5696341),(6705,30709,0.1605954),(6705,32111,0.29973215),(6706,3928,0.14611529),(6707,142,0.61018455),(6707,2696,0.7495619),(6707,6746,0.709677),(6707,9522,0.16976877),(6707,9756,0.5317954),(6707,15223,0.7407649),(6708,17709,0.58337307),(6708,28275,0.94809914),(6709,4048,0.598772),(6709,8580,0.8853257),(6709,12563,0.6697008),(6709,24942,0.6351461),(6710,2246,0.9812752),(6710,14275,0.5844139),(6710,22543,0.27309293),(6710,30624,0.6607668),(6711,13882,0.7754031),(6711,25217,3.6798913e-2),(6712,13682,0.52550316),(6712,20336,0.18811595),(6712,25677,0.91654754),(6712,25678,0.506351),(6712,28796,0.2338603),(6713,4262,3.427072e-2),(6713,14004,0.67026585),(6713,27895,0.10137878),(6713,28847,0.8902803),(6714,2872,0.8177613),(6714,8266,0.25429943),(6714,16661,0.8497559),(6714,23903,0.51333743),(6714,28515,0.5940695),(6714,29844,0.10786668),(6715,13421,0.8823019),(6715,19471,0.30333832),(6715,22834,0.7616279),(6715,30099,0.7280738),(6716,211,0.9541298),(6716,5481,0.7564536),(6716,6636,0.93794245),(6716,11822,0.61927223),(6716,12025,0.95974493),(6716,28389,0.57578295),(6716,32431,0.7028774),(6717,7583,0.49794227),(6717,14375,0.497432),(6718,15252,3.8718063e-2),(6719,3072,0.55122954),(6719,5713,0.8279755),(6719,10436,0.35591313),(6719,18509,0.7313267),(6719,21369,0.5983146),(6719,22597,0.7598854),(6719,26200,0.77749896),(6719,27573,8.5228376e-2),(6720,5094,0.10644157),(6720,18515,5.0767496e-2),(6720,20141,0.6024112),(6720,21621,0.18420058),(6720,22417,0.38647643),(6720,24166,0.8121948),(6721,15547,0.89694697),(6721,18710,0.29700145),(6723,16257,0.21640721),(6724,520,0.73507565),(6724,10121,0.26341733),(6725,716,0.12539952),(6725,18926,0.559061),(6725,19223,0.60929257),(6725,19717,0.5379188),(6725,29648,0.57119644),(6725,31132,7.3117964e-2),(6725,32364,0.976622),(6726,28021,0.690477),(6727,3680,0.2965472),(6727,5128,0.1173334),(6727,18702,0.22211401),(6727,29716,0.20298247),(6728,28635,0.90061355),(6728,30945,0.24093919),(6729,13910,0.3310154),(6729,25959,0.95284826),(6729,31906,0.3144093),(6729,32630,4.9865887e-2),(6730,7519,0.67307895),(6730,12201,0.2469275),(6730,20201,0.36837414),(6730,27597,0.25486088),(6731,25295,0.54169863),(6732,6088,0.32765844),(6732,22192,0.5093026),(6732,23329,0.54875445),(6732,29183,0.62929666),(6732,31848,0.62201005),(6733,2445,0.87144095),(6733,3836,5.9875187e-2),(6733,4557,0.34388936),(6733,10056,0.6582399),(6733,19673,0.7355245),(6733,21596,4.377383e-2),(6734,3145,0.34900177),(6734,10140,0.92203903),(6734,32186,0.48363385),(6736,7779,0.4556862),(6736,16985,0.4416076),(6736,19917,0.15675718),(6737,85,0.6482817),(6737,165,0.8769125),(6737,3598,0.49904156),(6737,12643,0.8250192),(6737,13013,0.9629833),(6737,29215,0.8055223),(6738,5415,0.24922729),(6738,22783,0.81877893),(6738,27659,0.6405556),(6739,14310,0.7293153),(6739,21300,0.39713725),(6739,23771,0.25538915),(6739,25017,0.69592196),(6740,12196,0.8388242),(6740,18693,0.6689972),(6741,2317,0.35368747),(6741,31278,0.46599472),(6742,1419,0.67612195),(6742,2290,0.3934575),(6742,15601,0.981406),(6742,16057,0.36814737),(6742,21349,0.87227273),(6742,21351,0.34541067),(6742,27717,0.8132941),(6743,10748,0.5306943),(6743,24984,0.21096379),(6744,21901,0.27595282),(6745,27412,0.42667165),(6745,29397,0.30044284),(6746,653,0.93213874),(6746,3669,0.15648408),(6746,14736,0.8139624),(6746,16710,0.64860153),(6746,16946,0.81790847),(6746,29435,8.470205e-2),(6747,9721,0.76673454),(6747,15040,0.73794585),(6748,7370,0.12650631),(6748,18345,0.13057578),(6748,22447,0.4439416),(6748,31043,0.18835157),(6749,8545,0.51889086),(6749,19848,0.43114638),(6749,20875,0.6294229),(6749,22163,0.18376221),(6749,23661,0.595359),(6749,28482,0.43275622),(6750,2120,0.49851114),(6750,13556,0.69814247),(6751,22253,0.38362542),(6751,26941,0.31763119),(6752,9548,0.75391364),(6752,25166,0.9540687),(6753,5791,0.24700645),(6753,6759,0.29223904),(6753,14745,0.7880527),(6753,28172,0.94010425),(6753,29989,0.9699326),(6754,400,0.49568298),(6754,2267,0.79352885),(6754,6450,0.6336198),(6754,31221,0.1596),(6755,3392,0.37168095),(6755,5454,0.15231785),(6755,17106,0.50070345),(6755,26324,0.8010039),(6755,26992,0.8340511),(6755,27869,0.56874734),(6756,5406,0.5579755),(6756,7590,0.15656906),(6756,25109,0.17457375),(6756,28961,0.83090794),(6756,31708,6.56944e-2),(6757,2011,0.87934804),(6757,2185,0.2487122),(6757,22223,0.20336227),(6757,29036,0.9942829),(6757,31117,0.91871315),(6758,6022,0.24664761),(6758,7390,0.2545351),(6758,16921,0.24281448),(6758,17469,0.28197157),(6758,27474,3.0687304e-2),(6758,31630,0.72819936),(6759,5444,0.55606586),(6759,12505,0.14327393),(6759,15721,0.2784079),(6759,18635,0.21499059),(6759,22322,0.27035096),(6760,937,0.6517794),(6760,1977,0.47364587),(6760,21188,0.46152157),(6760,23831,0.14183247),(6760,27602,0.19268733),(6760,30862,0.6133548),(6761,4401,0.16282532),(6761,11663,0.12799282),(6761,24141,0.3229307),(6762,8026,0.3943014),(6762,28857,9.55114e-2),(6762,31933,0.9861677),(6763,8019,0.5924656),(6763,12907,0.51994485),(6763,17164,0.9465782),(6763,24722,0.46102238),(6763,28321,0.98206556),(6763,32300,0.20087154),(6763,32599,0.96522605),(6764,10271,0.59952414),(6764,15992,7.914039e-2),(6764,27642,0.6022044),(6765,8579,0.641633),(6765,16695,0.5546729),(6766,1899,6.620053e-2),(6766,12523,0.65819865),(6766,13270,0.8188548),(6766,14464,0.38254666),(6766,17742,0.8749864),(6766,19104,0.95554143),(6767,3705,0.2159474),(6767,8378,7.288098e-2),(6767,9178,0.73301077),(6768,22064,0.5691742),(6768,29021,0.49928728),(6769,7369,0.70873326),(6769,15221,4.7812235e-2),(6769,20893,0.7453662),(6769,24861,1.1247933e-2),(6769,25882,0.26264313),(6769,30864,0.8966047),(6770,1882,0.2736031),(6770,19143,0.46431527),(6770,21370,0.90214896),(6770,24363,0.9509544),(6770,29399,1.4731887e-4),(6771,5178,0.62083054),(6771,25916,0.7560885),(6772,8228,0.6325789),(6772,17087,0.4258974),(6772,17992,0.8781866),(6772,20604,0.31708637),(6772,25797,0.82815063),(6773,9765,0.14220288),(6774,27494,0.45889077),(6775,5623,0.9779219),(6775,10665,0.91738945),(6775,13680,2.9815866e-2),(6775,14295,0.94744486),(6775,17406,0.8651776),(6776,6642,5.2596193e-2),(6776,11043,0.956266),(6776,19526,0.37301114),(6776,24696,0.38966405),(6776,29397,0.4165737),(6777,2049,1.7927716e-2),(6777,12575,0.5051092),(6777,24100,0.23371345),(6777,25808,0.579692),(6778,8892,0.9973144),(6778,21268,0.8024206),(6778,22167,0.33933735),(6778,32318,0.45384547),(6779,7911,4.64812e-2),(6779,14498,0.77577716),(6779,20643,0.66203046),(6779,24533,0.40748227),(6779,28186,6.6165045e-2),(6780,3823,0.97858274),(6780,10014,0.79713136),(6780,21972,0.19768664),(6780,25449,0.93253267),(6780,27373,0.15640806),(6780,30520,0.28150713),(6781,26346,0.517435),(6782,786,0.9372845),(6782,873,2.5884411e-3),(6782,5747,0.4811394),(6782,7862,7.903405e-2),(6782,24203,0.16723296),(6782,25806,0.116764486),(6783,2604,0.1721088),(6783,18241,0.544682),(6783,19452,0.7921674),(6783,22909,0.49447808),(6784,1187,0.78911966),(6786,1058,0.32845476),(6786,1320,0.26735577),(6786,6161,0.60294545),(6786,12294,9.201421e-2),(6787,5983,6.682599e-2),(6787,7525,0.14769949),(6787,13489,0.6197877),(6787,16059,2.4284136e-2),(6787,19505,0.80330503),(6787,30050,0.16040316),(6788,1293,0.99705833),(6788,3366,0.6067578),(6788,12326,0.123811625),(6788,13020,0.92399514),(6788,14213,0.5826806),(6788,27475,0.33671802),(6789,7159,0.16818623),(6789,24069,0.1068411),(6789,30380,5.8046337e-2),(6790,1932,0.7434605),(6790,3850,6.0051803e-2),(6790,5697,0.603862),(6790,10144,0.3063576),(6790,10907,0.5826165),(6790,11824,0.82205003),(6791,24061,2.1688629e-2),(6791,26299,0.26165137),(6791,29607,8.667895e-2),(6792,8882,0.86989266),(6792,15797,9.209919e-2),(6792,24721,0.9480035),(6792,27639,0.7738588),(6792,28183,0.8854872),(6792,31922,0.33683726),(6793,1597,0.3067692),(6793,18955,0.5496949),(6793,22642,7.6691374e-2),(6794,10677,0.44422433),(6794,13214,0.9593603),(6794,23672,0.98907113),(6795,12188,0.45662296),(6796,5052,0.5716354),(6796,5731,0.8972847),(6796,5998,0.22274686),(6796,6192,0.20771855),(6796,11551,0.40879962),(6796,14686,0.6445029),(6796,18068,0.3930726),(6796,24717,0.7204296),(6796,25562,0.70213664),(6797,391,0.6559),(6797,666,0.8639691),(6798,1512,0.46823806),(6798,6159,0.44879705),(6798,9462,0.10830235),(6798,17592,0.55457443),(6798,19046,0.7751919),(6798,19509,0.8240484),(6798,22137,0.13609478),(6798,27948,0.6231682),(6799,3540,0.21746328),(6799,6188,0.3980199),(6799,17094,0.4581774),(6799,17380,0.44150615),(6799,31339,3.6335807e-2),(6800,10150,0.36355868),(6800,15816,0.80326414),(6800,16062,0.40962955),(6800,16594,0.50951356),(6800,23077,0.46492907),(6800,26126,0.7416347),(6800,27014,0.41874948),(6800,31184,0.67101544),(6801,6052,0.78369296),(6801,6815,0.9973585),(6801,7180,0.58732516),(6801,11074,0.66545945),(6801,11825,9.509064e-2),(6801,16490,0.47417456),(6801,18926,0.7929621),(6801,19043,0.6164957),(6801,23816,0.31572872),(6802,3130,0.18614247),(6802,5322,0.8872543),(6802,16499,0.1607171),(6803,3987,0.54863995),(6803,15883,0.1769762),(6803,25308,1.944247e-3),(6804,19163,0.7791833),(6804,27730,9.327267e-2),(6805,5792,0.68466634),(6805,12342,0.9343402),(6805,12736,0.5358165),(6805,21317,0.22815113),(6805,24805,6.3461155e-2),(6805,28364,0.46452495),(6806,10639,0.55471224),(6806,18157,0.39553258),(6806,21439,0.67642146),(6806,30113,0.88081145),(6806,31242,0.32291606),(6807,4468,0.9064182),(6807,7200,0.6774206),(6807,15661,0.7945498),(6807,15897,0.74044657),(6807,18765,0.8369734),(6807,25545,0.62297547),(6808,417,0.37573558),(6808,1583,0.7456351),(6808,4601,0.36648065),(6808,14335,0.923525),(6808,14622,0.147292),(6808,22854,0.51202196),(6808,28850,0.896689),(6809,7309,0.8068061),(6810,905,8.729312e-3),(6810,6340,0.2619048),(6810,11500,0.83845013),(6810,13977,0.71655464),(6811,11307,0.6393552),(6811,24044,0.82357985),(6811,29633,0.17419718),(6812,19211,0.6731131),(6812,32562,0.16331327),(6813,810,0.80534774),(6813,15874,0.1451632),(6814,1652,0.6453252),(6814,5520,0.8249528),(6814,13512,0.16710855),(6814,20576,3.396528e-2),(6814,24977,0.8887383),(6815,1507,0.43505597),(6815,11356,0.5361188),(6815,12229,2.55587e-2),(6815,18859,0.16758019),(6816,426,0.11571741),(6816,655,0.72583455),(6816,1723,0.5867344),(6816,20462,0.3703653),(6817,778,0.36415905),(6817,4590,0.78610706),(6817,18142,0.1508489),(6817,26625,0.20222703),(6818,24888,3.437779e-2),(6819,28192,0.61786395),(6819,31205,0.31553996),(6820,6477,0.17539433),(6820,11100,0.49633697),(6820,27329,0.3971826),(6820,29293,0.54633754),(6820,32485,0.36556926),(6821,3923,0.40200266),(6821,10000,0.58331215),(6821,30053,0.29834384),(6822,13787,0.90624547),(6822,17412,0.3901588),(6822,27913,0.3907201),(6822,28004,0.55874753),(6823,2574,0.31762004),(6823,2633,0.27015847),(6823,19732,0.9389845),(6823,21435,8.529906e-2),(6823,28017,0.6437184),(6824,31507,0.21465953),(6824,32032,0.96307486),(6825,6703,0.17034495),(6825,9675,0.7744807),(6825,27747,0.15465362),(6826,8180,0.43019998),(6827,6053,0.37082186),(6827,18727,0.36023155),(6827,25278,0.5017227),(6828,14973,1.4849345e-2),(6829,5280,0.17652553),(6829,24407,0.42069176),(6829,30393,0.14008746),(6830,3968,0.930285),(6830,24229,0.8761223),(6831,957,0.9609788),(6831,10962,9.480903e-2),(6831,19200,0.5684102),(6831,25096,0.39693975),(6832,1759,0.912271),(6832,5328,0.8408138),(6832,9553,0.9420862),(6832,15906,0.847303),(6832,16119,0.3558591),(6833,9637,0.6710371),(6834,5439,0.67553365),(6834,16986,0.57914233),(6834,26646,0.84996426),(6835,827,0.6834491),(6835,19021,2.2677999e-2),(6835,24067,0.6391598),(6835,26848,0.90882033),(6836,10683,0.42297098),(6837,25096,6.702423e-2),(6837,26307,0.8832556),(6838,6165,3.1652585e-2),(6838,18792,0.2040664),(6838,21104,0.41642305),(6839,17180,0.22433403),(6840,2111,0.44760713),(6840,5731,0.62036896),(6840,8671,0.30795574),(6840,12877,1.9893998e-2),(6840,13476,0.15823613),(6840,31005,0.33395815),(6842,12616,8.476803e-2),(6842,13354,0.52039564),(6842,14016,0.10908351),(6842,25676,0.9358909),(6842,28291,0.84771323),(6843,125,0.9695818),(6843,4350,0.21282473),(6843,8624,0.9638582),(6843,8983,0.37590083),(6843,9147,0.1703663),(6843,18344,0.4602119),(6843,23478,0.61328894),(6844,18755,0.9607133),(6844,19819,0.3844974),(6844,23436,2.6242992e-2),(6844,31320,0.14495875),(6845,10258,7.607603e-2),(6845,10519,0.45902002),(6845,21682,0.6363559),(6845,26534,0.2609994),(6845,26778,0.2052461),(6845,31563,0.60966665),(6846,14544,0.34143063),(6846,18988,0.6908018),(6846,26122,0.231193),(6846,28308,0.3081332),(6846,32187,0.3962625),(6847,2361,2.0496324e-2),(6847,12503,5.902475e-3),(6847,16376,0.45473912),(6847,18349,0.26787096),(6847,20906,0.77559566),(6847,24489,0.30348727),(6847,25763,0.63425195),(6848,24678,0.4117025),(6848,30412,0.12935281),(6849,22118,0.16500902),(6849,24380,0.5178414),(6849,29885,8.935756e-2),(6850,6763,0.25791728),(6850,12297,0.7006463),(6850,26826,0.14789775),(6851,6721,0.72061944),(6851,8003,0.6400225),(6851,17411,0.78893405),(6852,6923,0.5626949),(6852,10959,0.425129),(6852,26083,0.8066898),(6853,13610,0.469573),(6853,16847,0.9404635),(6853,17724,0.9555077),(6853,20318,0.87164754),(6853,20519,3.9525576e-2),(6853,21481,0.6581948),(6854,3163,6.560219e-2),(6854,7052,0.609959),(6854,10518,0.8430892),(6854,13462,0.117745526),(6854,25971,0.9476006),(6854,26951,0.89237756),(6855,2615,0.18432795),(6855,6915,0.45096454),(6855,14070,0.47231498),(6855,14387,0.2884283),(6855,22756,0.48974237),(6855,27396,0.57238644),(6856,10153,0.9109659),(6856,12090,1.7698066e-2),(6856,25315,0.5782602),(6857,1120,0.21678548),(6857,10818,0.9402887),(6857,14476,0.25333166),(6857,16074,0.38158637),(6857,18431,0.89626944),(6857,27672,0.12922229),(6858,5411,0.58357626),(6858,6029,0.5494439),(6858,8060,0.604666),(6858,16723,0.41338754),(6858,22033,5.9748296e-2),(6859,17835,0.54200274),(6859,18605,0.76545185),(6859,21238,0.4506128),(6861,1449,0.6086201),(6861,3370,9.510673e-2),(6861,6906,0.38833427),(6862,8900,0.18570273),(6862,20705,7.241596e-2),(6862,21845,0.3436059),(6862,25925,0.79157466),(6863,2240,0.35120174),(6863,2731,0.28043053),(6863,6177,0.34842426),(6863,7130,0.41975424),(6863,9645,0.37686667),(6863,10526,0.11919604),(6863,16353,0.53816885),(6863,16709,2.7744016e-2),(6863,22488,0.81438214),(6863,27750,0.35284835),(6864,11874,0.18584993),(6864,20005,0.20132045),(6864,20838,0.25453582),(6864,30993,0.3940712),(6865,2318,0.82136667),(6865,7233,0.81752366),(6865,7997,0.50551367),(6865,14382,0.377797),(6865,14463,0.45944443),(6865,21751,6.1119836e-2),(6865,28436,3.4469173e-3),(6866,15385,0.2520026),(6866,23986,0.55225),(6866,24131,0.790934),(6866,30461,0.14562964),(6866,31073,0.15838587),(6866,31777,0.6370284),(6867,5365,0.60678846),(6867,15462,0.22527601),(6867,15618,0.13473953),(6867,29262,0.41509032),(6868,7207,0.1567097),(6868,10805,8.8588735e-3),(6868,17537,0.41495365),(6868,25945,0.51748776),(6869,10196,0.6314705),(6869,14859,0.5533822),(6869,18750,0.52640575),(6869,19978,0.6917335),(6870,14977,0.5037265),(6870,22153,0.7764677),(6870,22668,0.33207837),(6870,23658,0.67239517),(6870,30540,0.60976106),(6871,7122,0.57884663),(6871,10750,0.20562337),(6871,10783,0.84850657),(6871,16661,1.3045426e-2),(6871,20005,1.308762e-2),(6871,21524,0.9350905),(6871,28553,0.3851306),(6872,5634,0.6205263),(6872,27740,0.81524366),(6873,2877,0.36868095),(6873,5233,0.15598379),(6873,10245,0.34318283),(6874,9028,0.6112738),(6874,15496,0.6302182),(6874,17517,0.19268791),(6874,20126,0.67217165),(6875,30761,6.6081434e-2),(6876,5979,0.9440596),(6876,18839,0.15151456),(6876,27216,0.8925648),(6877,12053,0.80370396),(6877,17413,0.82500213),(6877,21034,0.46480995),(6877,31809,0.599721),(6878,18202,0.23146866),(6878,19574,0.92791885),(6878,21839,0.2377195),(6879,9908,0.9230109),(6879,15033,0.97895306),(6879,16620,0.37621617),(6879,19735,0.84539074),(6879,25310,0.4865115),(6880,4459,0.47155166),(6880,9307,0.96402764),(6880,13423,0.2816015),(6880,21273,0.40439174),(6880,24495,6.507472e-2),(6880,26836,0.9919194),(6881,3687,4.9446926e-2),(6881,4400,0.83652085),(6881,13480,0.8854635),(6881,15170,0.72264206),(6881,19468,0.9699034),(6882,345,0.6447959),(6882,3584,0.16291475),(6882,15470,0.7205815),(6882,21205,0.5743876),(6882,21584,0.24990235),(6883,8719,0.84114116),(6883,14798,0.41643155),(6883,19534,0.17643222),(6883,19863,0.9664783),(6883,20979,0.9953857),(6883,22303,7.052158e-2),(6883,32192,0.68530774),(6884,1326,0.48403865),(6884,10573,0.5819754),(6884,21495,0.15338705),(6885,5759,0.3139379),(6885,8777,0.5830006),(6885,10171,0.3434043),(6886,3631,0.3435956),(6886,16963,0.3338375),(6886,20829,0.96763724),(6886,24127,0.20410416),(6887,1718,0.6629696),(6887,7933,0.4255503),(6887,9429,0.85533863),(6887,14005,0.12686718),(6887,20157,0.26416144),(6887,21203,0.8210969),(6888,23819,0.26759905),(6889,11454,6.928187e-2),(6889,17165,0.52756894),(6889,21594,0.4403455),(6889,32364,0.5949085),(6890,8934,0.45717886),(6890,9182,0.9250682),(6890,19657,0.5200295),(6890,23948,0.7492116),(6891,24816,0.30514482),(6891,28174,0.8457098),(6891,30725,4.8902407e-2),(6892,7189,0.42483515),(6892,8674,0.9908348),(6892,24129,0.45442855),(6892,29855,0.9895004),(6893,1314,0.29437903),(6894,7344,0.9678932),(6894,32138,0.9900606),(6895,2277,2.930768e-2),(6895,14471,0.77857417),(6895,18455,0.19670698),(6895,21235,0.23645335),(6896,8305,0.58663523),(6896,13964,8.424072e-2),(6896,19603,0.7777795),(6896,23719,0.43301094),(6896,27086,0.29888058),(6896,30062,0.61230975),(6897,3515,0.73141223),(6897,8502,0.9671871),(6897,9403,0.54784983),(6897,9537,0.29526457),(6897,18873,0.40035823),(6897,21942,0.25123557),(6897,30709,0.693266),(6898,4020,0.9816204),(6898,7070,0.38680553),(6898,8049,0.4622071),(6898,16422,0.41988844),(6898,17666,0.32100877),(6898,23441,0.13196266),(6898,31268,5.901747e-2),(6899,5590,0.20778018),(6899,6195,0.7633902),(6899,28493,0.7167592),(6900,2073,6.284129e-2),(6900,15710,0.96757096),(6900,18211,0.96951383),(6900,20646,0.58899426),(6901,5499,0.50553596),(6901,19584,0.5593441),(6902,11544,0.3534238),(6902,19824,0.75720245),(6902,24988,0.1617864),(6903,12168,0.11467256),(6904,20439,6.773249e-2),(6904,23983,0.50312394),(6905,1040,0.4859572),(6905,12057,0.7654241),(6905,19168,0.48635125),(6906,2842,0.15783706),(6906,27676,0.24806866),(6907,138,0.39650255),(6907,13378,0.1681028),(6907,16856,0.81533325),(6908,1420,0.3728815),(6908,4258,0.47225776),(6908,7774,0.40516418),(6908,27932,0.8420384),(6909,18663,0.6676363),(6909,30932,0.20895538),(6910,2258,0.49474886),(6910,3471,5.0130274e-2),(6910,10349,0.5943344),(6910,11724,0.28336146),(6910,22135,0.870264),(6910,28423,0.7697693),(6911,19728,0.7673969),(6911,29089,5.8555823e-2),(6912,13660,0.6055186),(6912,14058,0.6342339),(6912,16017,0.770124),(6912,20836,0.6833342),(6912,23009,0.8023249),(6912,28677,0.29305655),(6913,8,0.17454638),(6913,694,0.5165245),(6913,6882,0.64499927),(6913,9524,0.15068592),(6913,10679,0.14388587),(6913,14296,0.8783844),(6913,19397,7.1644776e-2),(6913,22867,0.5769852),(6913,27130,0.5360798),(6913,31972,0.35102388),(6914,6281,0.7125835),(6914,10556,0.36429057),(6914,26453,0.7391395),(6914,28053,0.44282424),(6915,5134,0.57529855),(6915,24184,0.3607788),(6915,30505,0.6216076),(6916,32608,0.550776),(6918,4574,0.5524221),(6918,6482,0.28271094),(6918,6533,8.1474535e-2),(6918,31226,6.889245e-2),(6919,7346,2.8187407e-2),(6919,14406,0.8610598),(6919,27493,0.46992752),(6919,29948,0.28274286),(6920,460,0.121447966),(6920,16298,1.8182324e-2),(6920,32253,0.38666853),(6922,11846,0.6105248),(6923,9781,0.67168057),(6923,12396,0.34704262),(6923,26774,0.4395377),(6924,14906,0.99926525),(6925,14533,0.6583331),(6925,19408,0.5655878),(6925,31649,0.6892971),(6926,11330,0.8398138),(6926,22289,0.62949336),(6926,28180,7.65915e-2),(6926,31595,0.85194725),(6927,1461,0.45575792),(6927,17935,0.8041132),(6927,20112,3.1080391e-2),(6927,22979,0.15069795),(6928,1962,0.19955617),(6928,9663,0.82658386),(6928,26796,0.26115516),(6928,28441,4.1092142e-2),(6928,31772,0.31604305),(6929,5131,0.26163954),(6929,25238,0.82917696),(6929,27276,0.22231616),(6929,32217,0.6330649),(6930,10575,0.81349856),(6930,11176,0.20566826),(6930,17786,0.106511064),(6931,6843,0.936255),(6931,7184,7.97633e-2),(6931,16110,0.21215186),(6931,21541,0.90235674),(6931,25711,0.9589381),(6931,30683,0.9930385),(6932,11661,7.6099716e-2),(6932,13241,0.44447362),(6932,14752,0.18324433),(6932,30079,7.3529005e-2),(6933,2842,2.0128673e-2),(6933,5842,0.679422),(6933,8450,0.9011668),(6933,29727,0.7106347),(6934,2022,0.72944),(6934,12031,0.2331829),(6935,6514,0.71806383),(6935,8012,0.38296202),(6935,14517,0.3107014),(6935,29201,0.85038215),(6936,30718,0.81734896),(6936,31614,0.3099783),(6937,7497,0.4435026),(6937,16565,2.9137308e-2),(6937,21509,0.12996525),(6938,3473,0.8198826),(6938,13290,0.43536398),(6938,16477,0.24565987),(6938,23552,0.75340986),(6938,31467,0.30472264),(6939,10439,0.11657952),(6939,16707,0.20214988),(6939,22715,0.67045325),(6939,28155,0.43687096),(6940,3760,0.77948874),(6940,6768,0.72242993),(6940,12277,0.15144576),(6940,17067,0.6289203),(6941,3254,9.455193e-2),(6941,5480,0.80877995),(6941,15610,0.8750741),(6941,18411,0.16956781),(6941,23122,0.9523229),(6941,25252,0.5045928),(6941,28676,0.68985575),(6942,14348,0.8999255),(6942,19542,0.25297168),(6942,32418,0.22359507),(6943,2170,0.8089666),(6943,10527,0.69601876),(6943,19850,0.2829986),(6943,21054,0.37114364),(6943,21192,0.31583896),(6944,6466,0.4379577),(6944,13622,0.48529643),(6945,17508,0.3614272),(6945,26452,0.6619739),(6946,5243,0.59294564),(6946,26720,0.84684193),(6947,406,0.8195385),(6947,8703,0.856836),(6947,21903,0.6103505),(6947,27176,0.81665605),(6947,27312,0.43319237),(6948,18487,0.8790099),(6949,15527,0.9875505),(6950,18276,0.46502003),(6951,1841,0.37574705),(6951,5515,0.84646016),(6951,6472,0.4076393),(6951,10510,0.85630983),(6951,13443,0.97446203),(6951,13923,0.21422432),(6951,17151,5.0884493e-2),(6952,3027,0.5528729),(6952,3406,0.41497728),(6952,9878,0.98011434),(6953,12142,0.30015293),(6953,17324,0.11434934),(6953,17349,0.16344786),(6954,4129,0.48825854),(6954,10500,0.46496648),(6954,11153,0.1316432),(6954,14120,0.12137101),(6955,2967,0.275743),(6955,8962,0.90787536),(6955,12620,8.006222e-2),(6955,15322,0.38267177),(6955,21310,0.7701947),(6956,4297,0.46905595),(6956,14822,0.31596768),(6956,17221,0.9651203),(6956,18804,0.11039663),(6956,29381,6.3556634e-2),(6956,31786,0.17637618),(6957,10825,0.5446917),(6957,19604,0.3887169),(6957,28389,0.51669025),(6958,525,8.175371e-2),(6958,1545,6.710715e-2),(6958,15044,0.13221775),(6958,21978,0.7764505),(6958,30049,0.46810353),(6959,1434,4.9337327e-2),(6959,1842,0.8560337),(6959,6051,0.18401323),(6959,6287,0.37590975),(6959,14025,0.20047998),(6959,14848,7.387547e-2),(6959,22893,9.685086e-2),(6960,7886,0.1992913),(6960,29137,0.870108),(6960,30573,0.1778392),(6961,14159,0.9123393),(6961,18222,0.92261666),(6961,19336,0.9269417),(6961,26144,9.867462e-2),(6961,28750,3.6478717e-2),(6961,30651,6.638843e-2),(6962,2799,1.876156e-3),(6962,7782,0.2357153),(6962,10155,0.35995317),(6962,20276,0.5843009),(6962,23609,0.28787094),(6962,24274,0.5913146),(6962,27404,0.14563921),(6962,29400,0.67178214),(6963,6094,0.7347526),(6963,16554,0.39068174),(6963,20685,0.74075675),(6963,21127,0.5253795),(6963,22198,0.34750116),(6963,26578,0.7122175),(6963,28620,7.306157e-2),(6964,11306,0.8812697),(6964,18326,2.9111996e-2),(6964,20882,0.34274495),(6964,23598,0.89961416),(6964,24320,0.364871),(6965,8655,0.26268777),(6965,10443,0.37549773),(6965,15103,0.33833984),(6965,20136,8.52895e-2),(6965,22690,0.12343004),(6965,28466,0.6418621),(6965,31134,5.9172716e-2),(6965,31582,0.6270401),(6966,3846,7.0868574e-2),(6966,10159,0.8430587),(6966,12400,0.74315566),(6966,29678,0.72895986),(6966,30399,0.81225294),(6967,5456,0.10278979),(6967,28387,0.93233556),(6968,10375,0.33501187),(6968,17011,0.59496486),(6969,5226,0.74300796),(6969,6039,0.5048933),(6970,2125,0.23625763),(6970,16434,0.4383374),(6970,17546,1.3324425e-2),(6971,3868,0.95624566),(6971,5595,0.6331967),(6971,9162,0.7478793),(6971,26275,0.8469675),(6971,28432,0.17868592),(6971,31832,0.40983385),(6971,32473,0.13968226),(6972,15922,0.9911963),(6972,21819,0.8416735),(6972,26807,0.5185279),(6972,27010,0.49889696),(6973,16993,0.43300828),(6973,20979,0.26065928),(6974,12688,0.10457217),(6974,12713,0.7006643),(6974,16475,0.85772926),(6974,27105,3.338919e-2),(6974,27333,0.9430429),(6974,28362,0.4490113),(6974,29675,0.17536952),(6975,8856,0.55168176),(6975,9554,0.49212155),(6975,16066,0.13105525),(6975,30635,0.2219203),(6976,13120,0.2852313),(6976,28281,0.79262906),(6977,7420,0.9842916),(6977,9083,0.19902961),(6978,505,0.15818828),(6978,31726,7.3820435e-2),(6979,6420,0.13886079),(6979,7250,0.8369664),(6979,31516,4.0031172e-2),(6980,14155,0.93695885),(6980,20076,0.16729167),(6980,31409,0.56611603),(6981,14992,0.50333804),(6981,17969,0.18683252),(6981,29876,0.8859434),(6982,3241,0.71271366),(6982,17639,0.90263695),(6982,28802,0.1509775),(6983,12702,0.58813494),(6983,16053,0.4144032),(6983,20045,0.2421025),(6984,3650,0.51496637),(6984,13493,0.5846964),(6984,19842,0.76659924),(6984,26664,0.9672225),(6984,27027,0.3758755),(6984,27147,0.12884206),(6984,29453,0.62743014),(6985,1410,0.6150184),(6985,7115,0.7201358),(6985,11502,0.6751506),(6985,13736,3.781061e-2),(6985,14685,0.70186025),(6985,32145,0.93800247),(6986,11267,0.77192116),(6986,18420,0.24117877),(6986,23510,0.5330128),(6986,24177,0.7355821),(6987,1261,0.16883154),(6987,21077,7.76098e-2),(6987,28386,0.3717435),(6987,31065,0.54753107),(6988,4874,0.118056186),(6988,6129,0.7054994),(6988,12863,0.19670446),(6988,24994,0.9004669),(6988,27653,0.63278633),(6988,28673,0.9626658),(6989,634,0.6547046),(6989,12675,0.75665194),(6989,23269,0.7161815),(6989,25151,0.33696654),(6990,4549,0.8028251),(6990,23633,0.767436),(6990,28769,0.71238714),(6991,6347,0.36484656),(6991,10191,3.136914e-2),(6991,22954,0.47930598),(6991,30785,0.3578585),(6992,15175,9.063339e-2),(6992,17425,0.8440118),(6992,31309,0.59620607),(6992,31538,0.32940105),(6993,8257,0.9029301),(6993,14890,0.39623493),(6993,14995,0.20325916),(6993,27166,0.11121634),(6993,31927,0.99466014),(6994,11294,0.2662511),(6994,19015,0.71424055),(6994,22420,0.39022213),(6995,1275,0.6004301),(6995,2091,0.321994),(6995,5485,4.6682313e-2),(6995,14964,2.0876743e-2),(6995,15480,1.4831384e-2),(6995,19363,0.87917167),(6995,22543,0.84271264),(6995,29513,0.9493339),(6995,30893,0.22125159),(6996,593,0.70416945),(6996,2923,2.475306e-2),(6996,25761,0.5886106),(6996,29236,0.20766485),(6996,31955,0.56369185),(6997,987,0.6416091),(6997,2301,4.599188e-2),(6997,13194,0.26454124),(6997,19058,0.5632122),(6997,20328,5.6355253e-2),(6997,29894,0.9566649),(6998,5693,0.5726066),(6998,12312,0.70233303),(6998,23557,0.75792277),(6998,30280,0.6601231),(6998,31463,0.6291073),(6999,1102,0.38132703),(6999,3869,0.890021),(6999,5250,0.89685935),(6999,15904,0.2813201),(6999,22835,0.30260548),(7000,418,0.432366),(7000,9281,0.8935485),(7000,15556,0.4849435),(7000,16673,0.9630084),(7001,1752,0.8923523),(7001,6156,3.065156e-2),(7001,17228,4.7196712e-2),(7001,32293,0.996414),(7001,32537,0.3846479),(7002,13362,0.8397526),(7002,17543,0.80413926),(7003,8426,0.54244006),(7003,15086,0.65364623),(7003,23866,0.1979315),(7003,26495,0.48535073),(7003,28133,0.8872787),(7004,72,0.9429677),(7004,27379,0.48685232),(7004,29324,0.7668059),(7005,23658,0.632111),(7005,29870,0.1798125),(7006,16563,0.6541486),(7006,23019,0.29075873),(7006,29050,0.6961795),(7006,29572,0.7267653),(7006,29781,0.5954384),(7007,3585,0.22748542),(7007,5100,0.11764817),(7007,6240,6.370991e-2),(7008,22161,0.80449694),(7009,7403,0.8722757),(7009,8893,0.44898716),(7009,32514,0.94396615),(7011,2355,0.2471391),(7011,6045,0.33248648),(7011,18586,0.13078983),(7011,23008,0.17651244),(7012,12666,0.81970066),(7012,17622,0.15191594),(7012,22601,0.7591108),(7012,30823,0.19292991),(7012,32525,0.3010879),(7013,14945,0.9863087),(7013,29354,0.27720717),(7014,3196,0.8458248),(7014,3290,0.28967172),(7014,4542,0.27529547),(7014,15564,0.20967244),(7015,14391,0.2673152),(7015,24632,0.19396275),(7015,26143,4.9180493e-2),(7015,26579,0.69860303),(7016,4715,0.6545353),(7016,7980,0.27725405),(7016,28585,0.65680575),(7017,9985,0.6772114),(7018,12704,0.37802443),(7018,13993,0.51923436),(7018,14739,0.9622264),(7018,16788,0.530885),(7018,23163,0.33151034),(7018,27122,0.18968058),(7018,30930,0.13282573),(7019,8276,0.6917886),(7019,9792,0.19035853),(7019,9952,0.37768838),(7019,22080,0.69194955),(7019,26104,0.85189456),(7019,26900,0.33020148),(7020,16607,0.9939875),(7020,19206,0.7135905),(7020,22069,0.85217446),(7020,28684,0.4792387),(7021,16195,0.26054853),(7021,16199,0.37803143),(7021,17340,0.7515297),(7021,23885,9.038913e-2),(7022,8749,0.16151042),(7022,14426,0.9237197),(7022,15884,0.1010946),(7023,2761,0.5274081),(7023,9875,0.26539734),(7023,10776,0.2501029),(7023,20035,0.43872574),(7023,22801,0.9477488),(7023,27650,8.8830166e-2),(7023,29920,0.33171755),(7024,5702,0.74867225),(7024,11395,0.5079142),(7024,17780,0.58146465),(7024,20301,0.28833488),(7024,21270,0.9771846),(7024,22716,0.6996214),(7025,10359,0.97744465),(7025,12774,0.6972874),(7025,14108,0.40841419),(7025,14252,0.4491255),(7026,138,0.44414198),(7026,1560,0.54661036),(7026,26684,0.9755377),(7027,6475,0.5684908),(7027,7367,0.90904456),(7027,22405,0.8377939),(7027,26027,7.510946e-2),(7027,30043,0.43915525),(7028,6296,0.8352269),(7028,6505,0.87632746),(7028,11683,0.7737066),(7028,13154,0.20709993),(7028,13319,0.76867014),(7029,1635,0.6382056),(7029,23060,0.24699393),(7029,27763,0.95265746),(7029,28221,0.97467846),(7029,30566,0.7558283),(7030,5541,0.45813426),(7030,13660,0.7885681),(7030,17554,0.66927123),(7030,31181,0.116272904),(7031,7395,0.80851555),(7031,27052,0.2692941),(7031,31122,0.92270344),(7032,9475,6.98104e-2),(7032,13270,0.72853976),(7032,16645,0.29055932),(7033,574,0.41556346),(7033,6745,0.39595035),(7033,15987,0.9646973),(7033,20732,0.79259884),(7033,22983,0.1593193),(7034,1158,0.36110762),(7034,9341,0.46352002),(7034,10016,0.93847007),(7034,10536,0.11020166),(7034,18808,0.38191825),(7034,23410,0.15370174),(7035,1059,0.2992505),(7035,2315,0.5944863),(7035,5148,0.73581374),(7035,14522,1.8653769e-2),(7035,17884,0.13287629),(7035,22765,0.7027726),(7036,7661,0.59437716),(7037,238,0.35380122),(7037,22177,0.48086977),(7037,30322,0.32599628),(7037,32573,8.275635e-2),(7039,9184,3.9263166e-2),(7039,11678,0.32942078),(7039,25378,0.49850073),(7040,5801,0.82142997),(7040,9002,0.9382479),(7040,12642,0.6249785),(7040,16688,0.60067815),(7040,18291,0.47696543),(7040,18472,0.65304226),(7040,18914,0.4088656),(7040,27220,0.93524104),(7040,28388,0.19458033),(7040,32368,0.5641774),(7041,7629,0.46620327),(7042,5926,0.3001831),(7042,18144,0.37445462),(7042,23754,0.9096998),(7042,25183,0.7382928),(7042,28290,0.728252),(7043,9118,0.8758236),(7043,12502,0.8802706),(7043,19648,0.56680256),(7043,27862,0.42525953),(7044,7871,0.8120791),(7044,16663,0.6059206),(7044,25066,0.93852943),(7044,26806,0.30508158),(7044,27433,0.49829084),(7044,29132,0.5115427),(7044,30807,0.94932157),(7045,263,3.751437e-2),(7045,5922,0.74699795),(7045,10101,0.25832093),(7045,12018,0.51063275),(7045,28234,0.7164652),(7045,31405,0.98861253),(7046,6871,0.16869858),(7046,12066,0.9945305),(7046,19502,0.6390632),(7046,22585,0.5022194),(7046,23611,0.7665893),(7047,19590,0.73876476),(7047,21655,0.29437223),(7048,1420,0.15406245),(7048,7790,0.8581196),(7048,14814,0.17339437),(7048,15372,0.6721807),(7048,19436,0.69849575),(7048,23208,0.76759636),(7048,26592,0.3231539),(7049,460,0.29663184),(7049,7299,0.66134804),(7049,9324,0.11406822),(7049,11275,0.59789735),(7050,131,0.3337783),(7050,20039,0.76604676),(7050,21374,0.28572607),(7050,25394,0.82430404),(7050,28049,0.5456998),(7050,29672,7.2120085e-2),(7051,13933,0.5121608),(7051,28105,0.28310263),(7051,31119,0.26047856),(7052,8607,0.97305655),(7052,11865,0.22872166),(7052,14809,0.13974452),(7052,17668,0.20933807),(7052,22460,0.5278698),(7052,28384,0.4270308),(7053,16533,0.34321433),(7054,3642,0.89112896),(7054,18608,0.65429807),(7054,20984,0.85851836),(7055,3771,0.8571824),(7055,11372,0.872534),(7055,16714,0.49710724),(7055,21991,0.24116851),(7055,25721,0.46982804),(7055,29885,0.23257537),(7056,19789,0.29488298),(7056,22768,0.37076032),(7057,19491,0.9671276),(7057,26681,3.139249e-2),(7058,18192,0.785793),(7058,28960,0.40738782),(7059,24480,0.6453374),(7060,21177,0.72786766),(7061,1124,0.7371456),(7061,19269,0.14089261),(7061,26092,9.5436216e-4),(7062,15499,0.8717451),(7062,19780,0.6304796),(7062,22727,0.32798427),(7063,5549,0.45766148),(7063,29829,0.24186115),(7064,1461,0.18698215),(7064,6272,0.40524256),(7064,17823,1.9583924e-2),(7064,19064,0.72629654),(7065,11610,0.6193318),(7065,15898,0.5393824),(7065,17862,6.1287146e-2),(7065,24040,0.66619027),(7065,26953,0.98405755),(7066,5582,0.35088512),(7066,22771,0.6850421),(7066,25661,1.276005e-2),(7067,2655,0.8978612),(7067,15528,0.6878439),(7067,26395,0.17128156),(7067,28361,0.36500385),(7068,8066,0.18132107),(7068,8431,0.81567234),(7068,13012,0.7934371),(7068,24442,0.7704727),(7069,395,0.6556282),(7069,5478,0.25887218),(7069,31556,0.9652638),(7070,13628,6.299e-2),(7070,18341,0.30648527),(7070,26148,2.5462106e-2),(7071,22514,0.9561209),(7071,24265,0.31949294),(7071,27554,0.5564853),(7072,10652,0.53060734),(7072,11060,0.4388739),(7072,13133,0.67222846),(7072,14181,0.109013975),(7072,15975,0.732579),(7072,16263,0.32300666),(7072,22187,0.53154373),(7072,30152,0.7687115),(7073,1360,0.27487105),(7073,1565,0.863443),(7073,11895,0.37790653),(7073,12437,0.6922944),(7073,22461,0.2602605),(7073,22580,8.9387015e-2),(7074,14807,0.22418815),(7074,20688,0.68125737),(7074,20690,0.205893),(7075,9397,0.25712857),(7075,10988,0.96016634),(7075,21936,0.8324438),(7075,22620,0.32176033),(7075,30998,7.4434634e-3),(7076,8934,0.5584221),(7076,11699,0.9256016),(7076,13580,0.9883588),(7076,14205,0.33530188),(7076,19586,0.32234117),(7077,8404,0.27813506),(7077,19973,0.68410164),(7077,20100,0.4358622),(7078,2039,0.93788105),(7078,6908,0.89979005),(7078,7004,0.88863724),(7078,19891,0.8345436),(7078,20824,0.5570676),(7078,22015,0.41378236),(7078,25959,0.89364034),(7079,8419,0.6233245),(7079,10226,0.14529102),(7079,13331,0.8691347),(7079,13886,0.1509241),(7079,24076,0.26738983),(7079,24507,0.97682846),(7079,24564,0.1669417),(7080,2094,0.9688837),(7080,12438,0.9975839),(7080,19138,0.7900989),(7080,26653,0.11388944),(7080,32583,0.61259305),(7081,8767,0.82763344),(7081,10411,0.61957157),(7081,10943,0.12784114),(7081,16439,0.90291315),(7081,26461,0.8366772),(7082,5128,0.8915435),(7082,19249,0.8317633),(7082,23214,0.9130072),(7083,26701,0.1850582),(7084,8301,0.4112186),(7084,8558,0.8206349),(7084,13325,0.8952162),(7085,4195,0.9999923),(7085,12369,0.90717137),(7085,16354,0.8140481),(7085,25292,0.98452455),(7086,15950,0.8185909),(7086,21670,0.17381375),(7086,23633,0.8481873),(7086,30883,7.64422e-2),(7086,31406,0.57220805),(7087,3650,0.45522282),(7087,9378,0.24946745),(7087,15696,0.40813804),(7087,16496,9.3669e-2),(7087,25399,8.375709e-2),(7087,25702,0.73116267),(7088,5306,0.851711),(7088,7758,0.75829214),(7088,12166,5.3149205e-2),(7088,30732,0.6001464),(7088,30811,0.36700958),(7090,11708,3.883278e-2),(7090,14402,0.41216046),(7090,24204,0.17980865),(7091,6414,0.22009684),(7091,7054,0.37997532),(7091,10512,0.9811003),(7091,32149,0.49851432),(7092,7819,0.66633),(7092,12491,0.73566365),(7092,24392,0.757415),(7093,301,0.75717473),(7093,21330,0.4653481),(7094,1636,0.7948442),(7094,4148,0.58764285),(7094,7787,0.227978),(7094,14983,0.73654836),(7094,22303,0.68854004),(7094,32407,0.118705325),(7095,975,0.8587446),(7095,1802,0.79025745),(7095,2001,0.5921969),(7095,5492,0.62757826),(7095,15133,0.5244471),(7095,21384,0.7014651),(7095,22863,0.7805446),(7095,32609,0.60405713),(7096,9012,0.9928652),(7096,18655,0.34110904),(7096,23880,7.7104946e-3),(7096,25231,0.81940126),(7097,10561,0.20363621),(7098,14239,0.68727183),(7098,25426,0.11433452),(7099,3433,0.5716504),(7099,5681,0.7153064),(7099,8395,0.87756395),(7099,15699,0.4674121),(7099,16967,0.37519863),(7099,18733,0.6121553),(7100,14323,0.63102275),(7101,13363,0.24333891),(7101,21035,0.7211824),(7101,21115,0.9433452),(7101,21343,0.72169805),(7102,5293,7.854715e-2),(7102,11830,0.75968844),(7102,17544,0.60677284),(7102,17744,0.7820297),(7102,27391,0.5139143),(7102,31315,0.42121485),(7103,1627,6.0949605e-2),(7103,22571,0.8955951),(7104,1772,0.8222866),(7104,12388,0.15963301),(7104,16010,0.46479258),(7104,19588,5.103104e-2),(7104,21506,8.8215515e-2),(7104,21573,0.17348582),(7104,29670,0.28136805),(7104,29718,0.31492966),(7104,30777,0.620868),(7104,32535,0.9488357),(7105,3480,0.33795124),(7105,9965,0.61963695),(7105,26898,0.5209211),(7106,1154,0.7000433),(7106,5310,5.47215e-2),(7106,9992,0.78005886),(7106,12293,0.7293893),(7106,14187,0.93752944),(7106,19093,8.339637e-2),(7106,19862,0.97787714),(7107,289,0.10796257),(7107,6221,0.7033819),(7107,14230,0.96147466),(7107,15334,0.12513627),(7107,15498,0.14789063),(7107,24174,0.11203677),(7107,28912,0.7629558),(7107,29501,0.5172228),(7108,862,0.8150167),(7108,15787,0.9869464),(7108,17951,0.7307208),(7108,22081,0.101536945),(7108,24464,0.6054999),(7109,6257,0.9033009),(7109,10310,0.20290686),(7109,32697,0.38860697),(7110,720,0.76332283),(7111,4735,0.26392013),(7111,10078,0.5452205),(7111,17787,0.36759833),(7111,23040,0.6648936),(7112,9849,0.8287185),(7112,18227,0.59631306),(7113,1983,0.80782217),(7113,17176,0.21833965),(7113,25183,0.47947356),(7113,27915,0.9187965),(7113,28210,0.7337588),(7113,31648,0.13972224),(7114,3351,0.63499194),(7114,16564,0.97319984),(7114,20698,0.25653934),(7114,22529,3.2121338e-2),(7114,31982,0.37467456),(7115,5853,0.97495854),(7115,28988,0.34359705),(7115,31443,6.44235e-2),(7116,916,0.62639093),(7116,3399,0.23254651),(7116,27313,0.9161037),(7117,6048,3.3141274e-2),(7117,7578,2.5462579e-2),(7117,9261,0.8591486),(7117,31309,0.316497),(7119,2330,0.34542388),(7119,8130,0.5014868),(7119,12876,7.7281795e-2),(7119,20134,0.9863962),(7120,11399,0.32010072),(7120,14847,0.867545),(7121,1086,0.8612445),(7121,16440,0.23919478),(7122,1369,0.87369955),(7122,3340,0.6267648),(7122,14168,0.73610765),(7122,23928,0.25440392),(7122,24423,4.4702035e-3),(7122,30444,8.3811523e-4),(7122,32281,5.81322e-2),(7123,26799,0.19545741),(7124,2284,0.78365827),(7124,2604,0.86349565),(7124,5584,0.85418606),(7124,7776,0.60007685),(7124,10567,0.6040095),(7124,12259,0.7232395),(7124,18089,0.11436406),(7124,19217,0.37698907),(7124,32460,0.97943246),(7125,13429,0.44072285),(7125,14592,0.13882305),(7125,24610,0.34597546),(7127,7395,6.433402e-2),(7127,10410,0.5247309),(7127,15099,0.4449512),(7127,17309,0.27979833),(7128,3939,0.8363955),(7128,5772,0.87513757),(7128,6576,0.81464106),(7129,7669,0.25028536),(7129,8886,0.9855804),(7129,16930,0.44323438),(7129,29497,0.9647741),(7130,1623,0.9850734),(7130,1804,5.2746624e-2),(7130,4688,4.0355872e-2),(7130,21891,0.46480134),(7130,30684,0.4004233),(7130,31846,2.7829543e-2),(7130,32016,0.7158996),(7131,12469,0.9702603),(7131,28265,0.8542577),(7131,28403,0.9927285),(7131,28500,0.20488507),(7132,1532,0.5701615),(7133,7148,0.47972345),(7133,13456,0.18287767),(7133,18215,0.41073763),(7133,30807,0.3331048),(7134,15220,0.18539825),(7134,28070,0.29017815),(7134,30250,0.28256217),(7134,30720,0.56951576),(7135,1538,0.6255142),(7135,7586,0.9066865),(7135,9830,0.8170541),(7135,23118,0.6085227),(7135,29783,0.7581232),(7136,224,0.8804752),(7136,7199,0.9613138),(7136,8233,0.7365096),(7136,16409,0.95847285),(7136,25403,0.29235032),(7137,2305,0.5379001),(7137,32213,0.6709743),(7137,32374,3.931575e-2),(7138,64,0.548393),(7138,5041,0.37220636),(7138,11006,0.49307215),(7138,25515,0.24109848),(7138,26590,0.34284937),(7138,30350,0.77177584),(7139,8524,0.6074871),(7139,14211,0.19124039),(7139,18125,0.33235735),(7140,3172,0.3300374),(7140,5312,4.25424e-3),(7140,18616,0.3499737),(7140,19381,0.17260572),(7140,27218,0.63085896),(7141,3648,6.352039e-2),(7141,16329,0.9677783),(7141,20505,0.8059161),(7141,26581,0.83898234),(7141,29402,0.78262645),(7141,31594,6.277632e-2),(7142,16572,0.1089279),(7142,24541,0.29612318),(7142,32219,0.68361413),(7143,3595,0.72601837),(7143,4524,0.38846728),(7143,22761,8.9436315e-2),(7144,2855,5.566882e-2),(7144,3691,0.33668035),(7144,20586,0.18667811),(7144,24673,0.7403478),(7145,5195,0.33037212),(7145,17798,0.41882235),(7145,27840,0.8789124),(7146,28773,0.3440629),(7146,29850,0.5400883),(7147,9245,0.69252455),(7147,24462,0.9445385),(7147,27959,0.30587745),(7148,4309,0.71889937),(7148,5334,2.6882172e-3),(7148,6212,0.97710735),(7148,16069,0.35881975),(7149,5811,0.9418397),(7149,8067,0.23912343),(7149,10368,0.42783105),(7149,23776,0.8577841),(7149,28808,0.68570936),(7149,29257,0.6313317),(7150,324,0.1547206),(7150,3133,0.8700117),(7150,15629,0.5902979),(7151,24835,0.65291524),(7151,29393,4.0656622e-2),(7152,11235,0.19371645),(7152,16793,0.8636522),(7153,207,0.9634768),(7153,1061,1.3030592e-2),(7153,16905,0.3319008),(7153,31104,0.5573961),(7154,8314,0.7263914),(7154,9791,0.39066735),(7154,27060,0.3749109),(7155,8335,0.5629129),(7155,11755,1.9435361e-2),(7155,16657,0.4515637),(7155,18218,0.70771956),(7155,18833,0.6827087),(7156,3364,0.10728278),(7156,15273,0.9796032),(7156,18007,0.6805428),(7157,5926,0.884452),(7157,14363,9.163636e-2),(7158,7335,0.2110199),(7158,30255,0.14307348),(7159,31511,0.33470964),(7160,1831,0.3171198),(7160,5227,0.33209172),(7160,28311,0.6121098),(7161,3927,0.7294713),(7161,14452,0.5181838),(7161,16311,0.52049077),(7161,26431,0.5459549),(7161,27711,0.9648514),(7162,12703,0.8996356),(7162,20426,0.50202286),(7162,24951,0.74436307),(7163,1038,0.979882),(7163,3400,0.20436656),(7163,14991,0.7451162),(7163,27229,0.16214329),(7163,31906,0.59670365),(7164,8218,0.7378413),(7164,12432,0.79488444),(7165,23955,0.28089353),(7165,25002,0.6767333),(7166,7138,0.47005758),(7166,8580,0.6155009),(7166,18948,0.19125985),(7166,23143,0.88484687),(7166,25360,0.14304638),(7167,1624,0.79481435),(7167,17264,0.54622453),(7167,24450,0.92780143),(7167,25868,0.9795441),(7168,11929,0.97694486),(7168,23215,2.5077833e-2),(7169,8364,0.46544036),(7169,9292,0.8166072),(7169,16404,0.5838748),(7169,19834,0.3203953),(7170,891,5.0107376e-3),(7170,11443,0.18732738),(7170,23771,0.4367885),(7170,28241,0.73036927),(7171,4289,0.7949969),(7171,12300,9.9734634e-2),(7171,14083,0.4380305),(7171,15039,0.6520638),(7171,26257,6.5711565e-2),(7171,30425,0.8310442),(7171,30897,0.7419487),(7172,3915,0.6818384),(7172,5570,0.5357264),(7172,25476,0.45565298),(7173,20993,0.3010752),(7173,24672,0.685156),(7173,24874,0.9480417),(7173,27626,0.79709023),(7173,30681,0.15637575),(7174,5858,0.114675686),(7174,6931,0.91501784),(7174,9564,0.3162872),(7174,10649,0.12460797),(7174,17927,0.6092833),(7175,1926,0.7425713),(7175,3641,0.4284501),(7175,12664,3.192783e-2),(7175,24766,0.90259784),(7175,25523,0.120697275),(7175,26612,0.25842282),(7176,3115,0.60758823),(7176,14189,0.7801245),(7176,15045,0.9271257),(7176,30360,0.22921534),(7177,734,0.50009954),(7177,4239,0.6551414),(7177,10409,0.67461544),(7177,18637,0.8060493),(7177,24231,0.53333646),(7177,31421,1.3361361e-2),(7177,32584,0.32950202),(7178,18982,0.22153008),(7178,29218,0.24719878),(7179,11638,0.25706562),(7179,12178,0.22228031),(7179,22261,0.18545862),(7179,26043,0.9764753),(7180,29662,0.5975406),(7181,11595,0.9491746),(7181,13440,0.91120034),(7181,23593,0.79743004),(7182,11132,0.57987046),(7182,19602,0.26531136),(7182,23746,0.62435305),(7182,24250,0.57451403),(7182,28195,0.4918854),(7183,11578,0.41276368),(7183,19119,0.58878493),(7183,21411,0.5984529),(7183,22422,0.37973386),(7183,25532,2.8003303e-2),(7183,29255,1.0242007e-2),(7184,1084,4.48513e-2),(7184,25655,0.5487216),(7184,30134,6.309438e-2),(7184,31964,0.66779375),(7185,18383,0.4384096),(7186,8313,0.26810646),(7186,14179,0.30682108),(7186,27008,0.24742377),(7187,8095,0.33604917),(7187,15053,0.18055709),(7187,28637,9.261239e-3),(7188,10634,0.53630495),(7188,11286,0.4579744),(7188,19870,0.48091382),(7188,25705,2.178154e-2),(7189,14291,0.13028729),(7189,23769,0.40515244),(7190,20717,0.6846298),(7190,21932,0.49557158),(7190,26120,4.4130042e-2),(7190,28332,0.4847715),(7190,31352,0.32855365),(7190,31877,0.9385086),(7191,6491,0.49024948),(7191,11265,3.2930166e-2),(7191,12223,0.19746955),(7192,6083,0.6624974),(7192,10606,0.14298987),(7192,11315,0.3377556),(7192,14772,0.38009727),(7192,15847,0.16999146),(7192,16555,0.7158795),(7192,19652,7.686634e-3),(7192,20528,0.77735335),(7192,31387,0.7600472),(7193,5611,0.9136242),(7193,7527,0.31974804),(7193,16312,0.87802076),(7193,17607,0.74467206),(7193,18015,0.49937195),(7193,27253,0.66217417),(7194,2245,0.5167556),(7194,2691,0.72357774),(7194,9306,0.24146967),(7194,16547,7.2873406e-2),(7194,18857,0.27080622),(7194,25224,0.6047763),(7195,2944,0.64513224),(7195,21889,0.20196645),(7196,1660,0.25136042),(7196,4254,0.87650126),(7196,15500,0.20429575),(7196,27010,0.11711706),(7197,20461,0.1631668),(7197,29459,0.87747175),(7198,6396,0.5606395),(7199,15976,0.7038036),(7199,25454,0.9164271),(7199,26188,0.3051061),(7199,26342,0.49142087),(7199,29543,0.6953621),(7200,1326,0.74494135),(7200,10554,0.4703863),(7200,11243,0.45234948),(7200,12478,5.3346187e-2),(7201,4606,0.7655525),(7201,5109,0.5081728),(7201,12000,0.685463),(7201,14712,0.23885928),(7201,15663,0.5550034),(7201,24389,0.9815063),(7202,9019,0.51473045),(7202,9660,0.5198915),(7202,9742,0.15816996),(7202,17980,0.92178977),(7202,20810,9.58426e-2),(7203,4100,0.88800067),(7203,10704,0.7694553),(7203,14688,0.86990756),(7203,30178,0.55422604),(7205,10458,0.9648937),(7205,14400,0.9885491),(7205,22037,0.2986643),(7205,22460,0.6650913),(7205,28786,0.65315974),(7206,11303,6.1909683e-2),(7207,1179,0.33870956),(7207,16587,0.5105293),(7207,32332,0.9645864),(7208,3695,0.17515564),(7208,9804,0.85525703),(7208,12433,0.91828465),(7208,25834,0.67557245),(7208,26122,0.3744902),(7209,7150,0.2854592),(7209,7969,0.10095948),(7209,24996,0.100672044),(7210,8945,0.65046793),(7210,15572,0.23039275),(7210,16403,0.5506004),(7210,26772,0.16174209),(7210,27694,0.613852),(7211,8948,0.65175664),(7211,8964,0.6725395),(7211,15219,0.30223903),(7211,15655,0.3302683),(7211,20348,0.13505645),(7211,21736,0.41236895),(7211,32537,9.1909595e-2),(7212,2443,0.8456901),(7212,11207,0.604785),(7212,19144,0.19022052),(7212,32715,0.2025808),(7213,23905,0.6606192),(7213,25841,0.5380646),(7213,28327,0.40098882),(7214,287,0.80969125),(7214,3967,0.68209195),(7214,8650,0.4139766),(7214,15436,8.5516416e-2),(7214,18391,0.7646987),(7215,982,0.56136763),(7215,12647,0.8145279),(7215,20890,0.112276405),(7216,6352,0.68880624),(7216,11102,4.9228992e-2),(7216,30435,0.8676452),(7217,25074,0.70844054),(7217,31085,1.1520961e-2),(7218,214,0.39833367),(7218,18476,0.3513458),(7218,21212,0.4213582),(7218,32712,0.72522795),(7219,11904,0.85414165),(7219,13537,0.3248794),(7219,18780,0.3767133),(7219,20622,0.8214697),(7220,7838,0.10343535),(7220,11178,0.50490594),(7220,11985,0.9567915),(7221,1030,0.12829511),(7221,2124,0.33669758),(7221,4463,3.068387e-2),(7221,16163,0.6505617),(7221,24377,0.41857),(7221,28167,0.5568132),(7222,5184,0.8978234),(7222,16684,0.5948235),(7222,22279,0.29812422),(7222,24526,0.39366788),(7223,21158,0.4864606),(7224,9249,0.9063283),(7224,10821,0.22633392),(7224,14225,0.6039718),(7224,19462,0.2660281),(7224,23165,0.26663113),(7224,24241,0.97770554),(7225,12613,0.25073263),(7225,17218,0.33889425),(7225,19260,0.54258096),(7225,20578,0.71919394),(7225,24896,0.8525296),(7226,12007,0.80486983),(7226,15516,0.8232145),(7226,27304,0.53277516),(7227,10503,0.6902914),(7227,13441,0.29069918),(7227,25869,0.43087065),(7227,27808,0.79275835),(7227,30635,0.26575857),(7227,31085,0.18956168),(7228,22315,0.45786238),(7228,29909,0.48197395),(7229,9985,0.52762014),(7229,15823,0.55737436),(7229,22306,0.14263913),(7229,24052,0.44279307),(7229,28479,0.5585121),(7229,29352,0.34832978),(7230,15509,0.519628),(7230,23312,0.31845915),(7230,27210,0.4606421),(7230,28290,0.60240203),(7231,4195,0.54053146),(7231,22669,3.7063945e-2),(7232,12318,0.30328757),(7232,29612,0.7130047),(7233,5494,0.45233157),(7233,6021,0.94137293),(7233,12341,0.764842),(7233,15765,0.9084062),(7233,24086,0.45372155),(7233,26792,0.2044327),(7234,637,0.5879901),(7234,10463,0.57545954),(7234,11601,0.50471264),(7234,13651,0.28170508),(7234,16676,0.10412941),(7234,18205,0.51406735),(7234,21017,0.70100105),(7235,292,0.915794),(7235,5875,0.47451204),(7236,948,0.13332051),(7236,14972,0.37092867),(7236,15328,0.44968697),(7236,32125,0.18805003),(7237,3085,0.2963881),(7237,7768,0.28229886),(7237,17165,0.6672236),(7237,26322,0.7440424),(7238,3053,0.9694186),(7238,4600,0.6795744),(7238,21586,8.421528e-2),(7238,25418,0.5073067),(7238,29670,0.8263838),(7238,30240,0.4921281),(7238,30983,0.5411237),(7239,523,0.76021105),(7239,9301,0.16054784),(7240,5857,6.529448e-2),(7240,17968,0.685784),(7240,20648,0.123678006),(7240,22931,4.6679255e-2),(7241,7217,0.94139665),(7242,14441,0.95259273),(7242,19444,0.36690354),(7242,24543,0.32534066),(7243,24143,0.92006195),(7244,11323,0.3465588),(7244,22312,0.35745937),(7244,28945,0.72148746),(7244,31015,0.7620914),(7245,1294,0.63914496),(7245,25832,0.60364294),(7246,4552,0.7815846),(7246,5860,0.95241606),(7246,20949,0.5455487),(7246,28683,0.9500054),(7247,11331,0.7253562),(7247,11534,0.94354033),(7247,26081,0.8612146),(7248,10487,0.74352056),(7248,20122,0.9227911),(7249,7413,0.6779944),(7249,16911,0.21519953),(7249,25555,0.10039792),(7251,6696,0.9400842),(7251,6758,0.61052173),(7251,15890,0.8342802),(7251,20581,0.49606192),(7252,598,0.13786665),(7252,1942,0.6039587),(7252,6651,0.9468746),(7252,9441,0.35595277),(7252,15372,0.6971737),(7252,19783,0.38586012),(7252,20251,0.10362837),(7252,32147,0.71522015),(7253,1774,0.33409488),(7253,3392,0.6305157),(7253,8096,1.3431543e-2),(7253,9118,0.24601123),(7253,13300,0.5838944),(7253,16554,0.52777153),(7254,986,0.39930624),(7254,2925,0.14312167),(7254,5479,0.8296632),(7254,8647,0.45088658),(7254,9543,0.7068937),(7255,9847,1.6340533e-2),(7255,14935,0.68530685),(7255,29372,0.68265736),(7256,7389,0.62053466),(7256,21285,0.28392103),(7256,22324,0.13826528),(7256,24083,0.95308846),(7256,24215,0.7233342),(7256,27614,0.43624505),(7257,4694,0.79688495),(7257,10802,4.4464555e-2),(7257,22836,0.59746027),(7258,3894,1.1530183e-2),(7258,4322,0.2804523),(7258,28108,0.6269917),(7259,9754,0.8399852),(7259,10197,0.6294872),(7259,16209,0.6658693),(7259,20146,0.63810205),(7259,23678,1.4909362e-2),(7259,26628,0.9871998),(7259,27077,3.4590874e-2),(7260,8033,0.44845086),(7260,20953,0.10333192),(7260,24678,0.10313435),(7261,8810,0.26106235),(7261,25175,0.3944067),(7261,30720,0.5620191),(7261,32311,0.23190577),(7262,6711,0.19825934),(7262,16635,0.72126263),(7263,2746,0.39130056),(7263,5527,0.85521126),(7263,6945,1.2206609e-2),(7263,24805,0.33513525),(7263,25080,0.8650623),(7264,4013,0.33363754),(7264,5307,8.165341e-2),(7264,7275,0.59780097),(7265,6157,0.687901),(7265,15737,0.91392356),(7265,16522,0.14527392),(7265,26545,0.67845714),(7265,29996,0.6120501),(7266,4991,0.109500505),(7266,11246,0.43632692),(7266,13087,0.64044654),(7266,18168,0.68731374),(7266,18513,0.9057248),(7266,20530,0.6134639),(7267,6350,0.15505359),(7267,7347,0.3171171),(7267,11417,0.3886178),(7267,11753,0.28254563),(7267,18703,0.71025944),(7267,20223,0.28361365),(7268,15041,1.7132366e-3),(7268,18855,0.454982),(7268,25380,0.8789667),(7268,30000,0.97615135),(7268,32357,0.19287118),(7269,12178,0.81076896),(7269,30536,1.3997994e-2),(7270,2552,0.53871286),(7270,7194,0.6786837),(7270,7424,0.113172665),(7270,9796,0.95624775),(7270,14530,0.22233643),(7270,19218,0.6794519),(7270,29590,0.61423284),(7270,30155,0.85215706),(7271,2187,0.5013451),(7271,29595,0.13424017),(7272,12741,0.66738224),(7272,18676,0.45358956),(7272,19581,0.81167716),(7272,31017,1.9188043e-2),(7273,7544,0.1281242),(7273,8207,0.74103886),(7273,11291,0.57193947),(7273,12791,0.78754663),(7273,12879,0.40833795),(7273,14174,0.6964341),(7273,26268,0.73425925),(7273,29220,0.40869525),(7274,6070,0.5010905),(7274,10395,0.3976688),(7274,11544,0.42237476),(7274,18359,0.85779697),(7275,5048,8.44501e-2),(7275,6446,0.34581912),(7275,10361,0.34840786),(7275,13628,0.15943632),(7275,15486,0.45115095),(7275,17891,5.7970684e-2),(7276,11528,0.87589556),(7277,22297,0.35233924),(7277,26742,0.2960556),(7277,32718,0.8289805),(7278,1096,0.39034784),(7278,21311,0.6702886),(7278,24173,0.83693886),(7279,2927,8.716493e-2),(7279,5585,0.6467363),(7279,8214,0.68275625),(7279,8297,0.24622673),(7279,12661,0.97262925),(7279,17824,0.7989843),(7279,22109,3.2451313e-2),(7279,23634,0.29581615),(7280,1444,0.9582694),(7280,5353,0.89525443),(7280,11327,0.6537374),(7281,3560,0.22528103),(7281,5856,0.2638288),(7281,10883,0.620487),(7281,11198,0.26115042),(7281,12407,2.9097987e-2),(7281,29738,0.5979885),(7281,29948,0.81578887),(7282,10753,0.9812394),(7282,30408,0.72047895),(7283,887,0.96434546),(7283,2427,0.35139254),(7283,6144,0.5465555),(7283,8267,0.51816875),(7283,15147,0.7649408),(7283,17615,0.67669743),(7283,19286,0.67184633),(7283,20192,0.80217886),(7283,20840,0.104713164),(7283,21341,0.7210623),(7283,21360,0.63427544),(7283,23269,0.4862222),(7284,1188,0.7760344),(7284,8648,0.66022706),(7284,11186,0.6049341),(7284,19491,0.69226915),(7285,5929,3.9318584e-2),(7285,20448,0.75450116),(7286,17231,8.939454e-2),(7286,19063,0.12317323),(7286,31229,0.18609075),(7287,10760,0.4351101),(7287,31999,0.56175065),(7288,11372,0.11229145),(7289,179,0.8553179),(7289,7745,0.16433537),(7289,9920,0.6880689),(7289,9997,0.56424075),(7289,24072,0.95374936),(7289,24702,0.9597158),(7289,30256,0.28454936),(7289,31984,4.7397543e-2),(7290,2552,0.57833385),(7290,13124,0.38632202),(7290,14177,0.50439495),(7290,14429,0.9692172),(7290,31943,0.56586605),(7291,1337,0.9514355),(7291,2127,0.34001833),(7291,3717,0.29408503),(7291,6218,0.82913214),(7291,15260,0.6317929),(7291,17172,0.26254767),(7291,18805,0.1454134),(7291,20720,0.97002834),(7292,5097,0.73532796),(7292,24119,0.43871236),(7293,1814,0.873911),(7293,7829,0.52142316),(7293,18019,0.30292317),(7293,24715,0.49371397),(7294,5852,0.7865705),(7294,15645,0.8750932),(7294,29467,0.663054),(7295,4589,0.83923966),(7295,23301,0.50086206),(7296,869,0.6630441),(7296,5698,0.5200151),(7296,8939,0.2489187),(7296,10040,0.53363276),(7296,17461,0.21559109),(7297,520,0.5491872),(7297,3495,9.041685e-2),(7297,9346,0.37975276),(7297,16688,0.20126987),(7297,20135,0.51141876),(7297,24942,0.6730138),(7297,25993,0.60818577),(7297,29591,0.79609823),(7297,30138,0.6957209),(7298,20306,0.17487282),(7298,24441,0.36702743),(7299,14588,0.5622215),(7299,15153,0.5072909),(7299,17990,0.6692955),(7299,22554,0.58894664),(7300,4577,0.98601246),(7300,10116,0.823218),(7300,10536,0.29301125),(7300,28184,0.87234414),(7300,29119,0.63030285),(7300,32228,0.4197809),(7301,5228,0.33457103),(7301,10609,0.332564),(7301,11301,0.24267133),(7302,737,0.5852276),(7302,4175,0.4068144),(7302,9112,0.88667494),(7302,11577,0.24026814),(7302,25030,0.2010668),(7302,32590,6.0106754e-2),(7303,1395,0.2346978),(7303,9860,0.72752416),(7304,11969,0.45099273),(7305,1220,0.24478057),(7305,3509,0.7161863),(7305,8463,0.5324201),(7305,9462,0.9777046),(7305,9839,0.6763438),(7305,11323,0.78657293),(7305,24668,0.43664876),(7305,31352,0.9169632),(7305,32004,0.52580893),(7306,23826,0.35963875),(7306,28146,0.60334617),(7306,29641,0.1635565),(7307,8812,0.24246682),(7307,9150,0.55738646),(7307,26412,7.1621075e-2),(7307,30218,0.8863003),(7308,3029,0.62664783),(7308,9278,0.74175096),(7308,20370,0.840717),(7308,24719,9.1612995e-2),(7310,9013,0.49328983),(7310,14785,0.1477606),(7310,22310,0.6451339),(7310,24139,0.9486003),(7311,7198,0.16682872),(7311,9788,8.560915e-2),(7311,14202,0.24984702),(7311,30921,0.28433707),(7312,8237,0.5303242),(7312,18462,0.8765791),(7313,45,0.12102738),(7313,2840,0.50762415),(7313,6928,6.65384e-2),(7313,8567,0.32908255),(7313,13297,0.6897714),(7313,15923,0.40774953),(7314,744,0.3798041),(7314,3169,0.7835589),(7314,9920,0.7158072),(7314,14617,0.7304023),(7314,16693,0.32696673),(7314,18802,6.492859e-3),(7314,23146,0.5699702),(7314,25220,0.40114775),(7315,15782,0.59583706),(7315,22664,0.7419015),(7315,24560,0.14565904),(7315,26052,0.20809974),(7316,12896,0.4584081),(7316,31652,8.272733e-2),(7316,31792,0.83093876),(7317,6173,0.17859478),(7317,12000,0.7741495),(7317,12503,0.11213487),(7318,16784,0.48505595),(7318,16993,0.63358253),(7318,21396,0.5701962),(7318,24676,0.4546123),(7319,25027,0.18649489),(7320,11261,0.92659336),(7320,12325,0.6219348),(7320,12374,2.9575115e-2),(7320,18116,0.9926986),(7320,20033,0.66484225),(7320,24437,0.1567931),(7320,29563,0.9337236),(7320,31682,0.20973848),(7321,3372,0.994568),(7321,17460,0.22014867),(7321,24895,0.44237933),(7322,5174,0.3629377),(7322,27026,0.1448598),(7322,29855,6.933235e-2),(7323,9866,0.8663747),(7323,12658,0.53257155),(7323,12700,0.42953172),(7323,17747,0.1307028),(7323,20953,0.57780313),(7323,26321,0.6685855),(7323,26658,0.45407942),(7323,27157,0.47228754),(7323,31416,0.35187522),(7324,2415,0.16143796),(7324,11189,0.8379621),(7324,14112,0.81558967),(7324,18729,0.3957794),(7324,19590,0.43368554),(7324,20616,0.86541724),(7324,20743,8.0300465e-2),(7324,23336,0.15498789),(7324,32452,0.422275),(7325,16708,0.61892515),(7325,23565,0.27867112),(7325,27533,0.2963574),(7326,10231,0.29011458),(7326,18919,6.087909e-2),(7326,19468,0.10560194),(7327,512,0.9425024),(7327,1670,0.45999),(7327,18932,0.6287024),(7327,28636,0.34074837),(7328,1018,0.654822),(7328,10065,0.73731273),(7328,14045,0.30002525),(7328,25856,0.6707238),(7328,27123,0.8183838),(7329,6220,0.2936482),(7329,15825,0.60405314),(7329,31864,0.88921285),(7330,784,0.74447095),(7330,25983,0.32244366),(7330,30564,0.8128779),(7330,30816,0.7348342),(7331,3011,0.84778845),(7331,3444,0.324313),(7331,3648,0.31822303),(7331,14536,6.249629e-2),(7331,20948,0.7555353),(7331,22798,0.3742907),(7332,10078,0.3333997),(7332,16777,0.77941453),(7333,775,0.3855041),(7333,8221,0.7736226),(7333,26896,0.24560663),(7334,2695,0.40175423),(7334,10732,0.9925306),(7334,15539,0.8693818),(7334,16739,0.8433534),(7334,19110,3.292535e-2),(7334,24834,0.56141585),(7334,26591,0.43203723),(7334,30584,0.9053641),(7336,9741,0.95263207),(7336,21427,0.2122193),(7336,26220,0.43305936),(7336,30768,0.8777775),(7337,7861,0.20250972),(7338,2921,0.69783646),(7338,10760,0.34727708),(7338,19355,0.68888617),(7338,23999,0.16776681),(7338,32395,0.5608492),(7339,6994,0.88373435),(7339,15320,0.72709996),(7339,31529,0.20083068),(7340,5644,6.1942454e-2),(7340,10481,0.92491305),(7340,18869,0.628836),(7340,21951,0.77890414),(7341,8343,0.66446257),(7341,11725,0.48806733),(7341,24367,0.6336603),(7341,30526,0.39459157),(7342,5050,0.6716556),(7342,5400,0.50694954),(7342,9563,0.8651442),(7342,25329,0.960486),(7343,13785,0.30032265),(7343,15457,0.19376756),(7343,24687,0.7464896),(7344,2185,0.9095248),(7344,6164,0.87698627),(7344,15765,0.17240277),(7344,31279,0.9497184),(7345,15240,0.54443365),(7345,16988,0.36247653),(7345,29562,0.56568235),(7346,8117,0.65583557),(7346,13948,1.5334051e-2),(7346,19297,0.7467517),(7346,23800,0.69804347),(7347,4060,0.7864415),(7347,5817,0.30685863),(7347,15527,7.366306e-2),(7347,24750,0.45661688),(7347,25812,0.5673871),(7347,32695,0.48065725),(7348,395,0.2439655),(7348,8252,0.13467216),(7348,18041,0.91384214),(7348,19843,0.8393996),(7348,28347,0.64046293),(7348,32070,2.0219594e-2),(7349,13382,0.69250476),(7349,24762,0.5002073),(7350,13093,4.816957e-3),(7350,23007,0.7750041),(7351,975,0.23867291),(7351,1257,0.81356716),(7351,9304,0.15219443),(7351,11808,0.99934083),(7351,26805,0.5297133),(7351,29694,0.41068402),(7352,4927,0.7648858),(7352,5989,0.16005613),(7352,8593,0.43425024),(7352,12779,0.36495265),(7352,12953,0.6767079),(7352,17985,0.9212657),(7352,24643,0.512206),(7352,28213,0.6588082),(7352,31042,9.2692964e-2),(7352,32436,0.47592524),(7353,8402,0.55632603),(7353,31893,0.64704317),(7354,3017,0.54891235),(7354,15667,0.5857722),(7354,21275,0.6409124),(7355,13945,0.21769907),(7355,18361,0.30908626),(7355,18894,0.25629684),(7356,98,0.19728091),(7356,29939,0.68791735),(7356,32619,0.14430249),(7357,19795,8.3651535e-2),(7358,15474,0.5465414),(7358,23430,6.187342e-2),(7358,24842,0.8105564),(7358,30380,1.4346457e-2),(7359,6592,0.8872054),(7360,6129,0.6794681),(7360,12655,0.26985857),(7360,12816,0.16650197),(7360,20035,0.29954404),(7361,2431,0.16558462),(7361,5379,0.34883496),(7361,6807,0.21145143),(7361,9074,0.8015581),(7361,15172,0.7043054),(7361,16502,0.8680503),(7361,20504,0.87394863),(7361,29210,2.1595933e-2),(7362,12460,0.9506265),(7362,12691,0.296407),(7362,24360,0.94437456),(7362,26937,0.37370816),(7362,32319,0.9905207),(7363,18630,0.26677537),(7364,13545,0.9952688),(7364,21877,0.27889046),(7365,7462,0.15075706),(7365,25488,0.89614093),(7365,30039,0.68294156),(7365,30184,0.7969022),(7365,30700,0.3856015),(7366,20880,0.16413249),(7366,21485,0.45048413),(7367,20035,0.20559557),(7368,6327,0.4033409),(7368,20944,0.44995213),(7368,24545,0.60188985),(7368,27427,0.23305331),(7368,31812,0.3551456),(7369,12022,0.41008198),(7369,15051,0.84059),(7369,25016,0.25722575),(7369,28386,0.97246337),(7369,28402,0.6477823),(7370,7523,0.45451745),(7370,30735,0.4168361),(7371,2132,7.1168855e-2),(7371,2668,0.7661426),(7371,4900,0.3571069),(7371,8741,0.75213253),(7371,15482,0.9696036),(7371,30180,0.8468432),(7371,31407,3.551738e-2),(7371,32082,0.37477678),(7372,8140,0.74170756),(7372,11737,0.2659676),(7372,22978,9.4269566e-2),(7372,23413,0.3632927),(7373,17,0.4513899),(7373,16494,0.22677553),(7373,16935,0.82646996),(7373,17669,0.70873505),(7373,29731,0.17349987),(7374,4682,0.34250903),(7374,13995,0.45197886),(7374,13998,0.5723326),(7374,21888,0.7234965),(7374,28235,0.25626925),(7375,2471,0.2748219),(7375,11366,0.75118923),(7375,13927,0.6953889),(7376,890,0.8600427),(7376,14176,0.6227015),(7376,15702,0.80255866),(7376,16322,0.6491965),(7376,25169,0.7553837),(7377,6294,0.67138803),(7377,22356,0.32027042),(7378,5163,0.24517167),(7379,2708,0.8225676),(7379,19741,0.42000306),(7379,30182,0.25392747),(7380,2512,0.4831966),(7380,14847,2.8619263e-2),(7380,23898,0.16958259),(7380,25294,0.11473666),(7381,16313,0.480384),(7381,29097,0.1757608),(7381,32533,0.91345346),(7382,17150,0.5748883),(7382,18929,0.92776465),(7383,5699,0.30262917),(7383,7877,0.95545715),(7383,12079,0.24704817),(7383,17766,0.16821422),(7383,22895,0.93318194),(7384,4824,0.26135138),(7384,13726,0.9923555),(7384,15859,2.0238044e-2),(7384,18920,0.33729726),(7384,29801,0.5740122),(7385,21787,3.067604e-2),(7385,24074,0.3023601),(7386,14465,0.65385294),(7387,17679,0.5975632),(7387,20319,0.6994929),(7387,22644,0.5036333),(7388,2158,0.94985336),(7388,7173,0.3219469),(7388,22055,0.29330814),(7388,23685,0.47655335),(7388,29868,0.41831204),(7389,700,0.879009),(7389,10771,0.4173461),(7389,30538,9.620574e-2),(7390,4,0.6893007),(7390,2671,0.22330627),(7390,13350,0.5715837),(7390,18894,0.7029059),(7390,27257,0.12561157),(7390,31966,0.8744422),(7391,6930,0.47022253),(7391,13491,0.95146894),(7392,584,0.67779654),(7392,14550,0.4458912),(7392,14908,0.24676615),(7392,23544,0.3206108),(7392,27849,0.65488636),(7392,28632,0.7231912),(7393,15350,7.331319e-5),(7393,22706,0.9937174),(7393,24463,0.7453114),(7393,30462,0.71566737),(7394,9,0.75463474),(7394,3513,0.35718626),(7394,26942,0.20499669),(7394,28714,0.5811462),(7395,221,0.83973837),(7395,2933,0.2702759),(7395,3512,0.25660688),(7395,5381,0.78745717),(7395,6973,0.62584746),(7395,7640,0.21885169),(7395,8996,0.5513938),(7395,9563,0.63199914),(7395,22369,0.9953139),(7395,22781,0.6823494),(7395,30688,0.9857657),(7396,1125,0.7634484),(7396,3194,0.9201848),(7396,3419,0.20688696),(7396,5068,0.98938966),(7396,6899,0.81498426),(7396,19279,0.6982472),(7397,11219,0.91728187),(7397,18879,0.47314098),(7397,19853,0.963279),(7398,12064,0.7981779),(7398,17859,0.98348385),(7399,2109,0.6069),(7399,6729,0.69617385),(7399,6798,0.9408409),(7399,9021,0.2464981),(7399,14373,0.45821112),(7399,14540,0.31256512),(7399,19293,8.613998e-2),(7399,30220,0.3542823),(7400,7665,0.6279903),(7400,12494,0.7227046),(7400,17099,0.64318824),(7400,21593,0.917599),(7400,22406,0.33788526),(7400,30379,0.60563064),(7401,14017,0.5053726),(7401,17781,0.34486884),(7401,21759,0.29910597),(7401,22122,0.48463458),(7402,11729,0.81038624),(7402,15175,0.46154377),(7402,15230,0.54172724),(7402,19829,0.324819),(7402,20654,0.37840685),(7402,22138,0.3587152),(7403,849,0.72875357),(7403,7641,0.46074444),(7403,8013,0.8969571),(7403,19380,8.104757e-2),(7403,25878,0.19228409),(7403,32748,0.30518836),(7404,6602,0.20521332),(7404,17754,0.7916606),(7404,27007,0.48448735),(7404,27900,0.68514085),(7404,28621,0.6197412),(7405,15029,0.61326045),(7405,24405,0.6681982),(7406,5394,0.5622442),(7406,11399,0.6502923),(7406,17755,0.7446218),(7406,20257,0.19445422),(7406,20545,0.11314395),(7406,21873,9.07958e-2),(7406,23931,0.7586243),(7406,29133,0.41267887),(7407,2565,0.9045825),(7408,1375,0.40585557),(7408,2611,0.5790972),(7408,15461,0.9579811),(7408,17108,0.5866399),(7408,27234,0.7792245),(7409,2651,0.65964395),(7409,13000,8.9958526e-2),(7409,15461,0.6056493),(7409,26076,0.5929435),(7409,26146,0.40789047),(7410,804,0.86532974),(7410,3521,0.57618487),(7410,9717,0.4213749),(7410,10163,0.8090666),(7410,24577,0.13823043),(7410,29386,0.25248474),(7411,21709,0.95653695),(7412,4614,0.96734726),(7412,8290,0.1686564),(7412,14436,0.6249743),(7412,29707,9.107093e-2),(7413,1209,0.78523725),(7413,5819,0.17067787),(7413,20140,0.6341901),(7413,22306,0.27556533),(7413,23135,0.58509374),(7414,3843,0.74953014),(7414,4268,0.67343974),(7414,6441,0.24366778),(7414,26439,0.8860106),(7415,16937,0.56557286),(7415,21031,0.27365473),(7416,12575,0.7361986),(7416,17929,0.12765504),(7417,5498,0.38198555),(7417,8535,0.19618236),(7417,10044,4.938376e-2),(7417,11981,0.63757986),(7417,27559,0.5327083),(7418,5321,0.5398548),(7418,7041,0.55699337),(7418,30532,0.51481503),(7418,32749,0.2100209),(7419,1789,0.89337903),(7419,14950,0.16041693),(7419,29744,0.21978799),(7420,12649,0.62413865),(7420,15582,0.5056701),(7420,19472,4.61348e-2),(7420,27416,0.65852326),(7421,15952,0.43222862),(7421,22753,0.5551504),(7422,20349,0.24172816),(7422,27309,0.49622738),(7422,29000,0.9151229),(7422,30422,0.91905475),(7423,31857,1.9129192e-2),(7424,4333,0.101500034),(7424,8147,0.115483895),(7424,15900,0.90697694),(7425,7629,0.3061742),(7425,21332,0.15607671),(7426,1377,0.21265793),(7426,6294,0.6063029),(7426,6779,0.5013555),(7426,27400,0.23257013),(7427,4531,0.43160477),(7427,8653,0.6940856),(7427,15700,0.37089187),(7428,8889,0.37869763),(7428,9331,0.65784997),(7428,10410,6.1468795e-2),(7428,11061,0.92068267),(7428,21845,0.20188765),(7428,22870,0.39709395),(7428,26443,0.79747146),(7429,10119,3.0726789e-2),(7429,14518,0.4641738),(7429,14854,6.7049764e-2),(7429,30494,0.7460979),(7430,26144,0.9649326),(7431,555,0.19180962),(7431,5635,0.22727919),(7431,16913,0.1668085),(7431,20127,0.23866875),(7431,26610,0.85838413),(7432,3423,0.6504099),(7432,4334,0.9604083),(7432,4516,0.1836427),(7432,9074,0.16081685),(7432,10881,0.95906866),(7432,17199,0.80269676),(7432,23395,0.47245127),(7432,29028,0.4859561),(7433,624,0.14000775),(7433,17244,0.74567676),(7433,25005,0.37462917),(7434,18488,0.67699116),(7434,24340,0.33652315),(7435,13917,0.61526984),(7436,2860,0.305551),(7436,3152,0.7525226),(7436,3689,0.8116998),(7436,14476,3.5312086e-2),(7436,17954,0.8956809),(7436,30953,0.1360581),(7436,32310,0.5317481),(7437,16733,0.7980203),(7437,24920,0.2382681),(7437,28304,0.8010648),(7437,28855,0.61985284),(7438,4019,7.879879e-2),(7438,6089,0.47871646),(7438,8490,0.4480483),(7438,14613,0.5289194),(7438,16076,0.15925823),(7438,21057,0.72154677),(7439,11144,0.13951121),(7439,12518,0.9507653),(7440,1232,0.41599974),(7440,2790,0.3656976),(7440,9776,0.62070745),(7440,14657,0.6215566),(7440,21079,3.6413196e-5),(7441,2461,0.16930878),(7441,20730,0.32590035),(7442,2383,0.6493239),(7442,5340,0.12146295),(7442,7002,0.33812603),(7442,12163,0.15543295),(7442,16627,0.97904706),(7442,16673,0.76194924),(7442,20836,0.27344045),(7442,21302,0.18513732),(7442,24113,0.9636781),(7442,27265,0.9370595),(7442,32632,0.864038),(7443,7567,0.8851198),(7443,10162,0.32609168),(7443,17213,9.473496e-2),(7443,20370,0.81703824),(7444,8,8.22611e-2),(7444,11188,0.21309687),(7444,16513,0.40988988),(7444,31627,8.035767e-2),(7445,1523,0.9503538),(7445,20571,0.4641662),(7445,22961,0.10082777),(7446,12247,0.41497862),(7446,14000,0.9922996),(7446,20864,0.75238645),(7446,31895,0.6089696),(7446,32701,0.3058524),(7447,1977,0.12862264),(7447,2158,0.1145295),(7447,11252,0.927153),(7447,13043,0.5244242),(7447,16159,0.72455686),(7447,20561,0.71693933),(7447,28486,0.6123109),(7447,29332,0.90255237),(7448,12179,0.17572021),(7448,17040,0.6340638),(7448,27697,0.8047993),(7448,32206,0.44143358),(7449,517,0.15536872),(7449,959,3.7954077e-2),(7449,9306,0.69561833),(7449,12502,0.9580782),(7449,24310,0.85442835),(7449,24402,0.20585512),(7449,26360,0.23721312),(7449,27022,0.6705073),(7450,855,0.80080307),(7450,23518,0.19359976),(7451,1765,0.20187482),(7451,5542,0.89936537),(7451,9626,0.19283372),(7452,4801,5.9613988e-2),(7452,30232,0.9324725),(7452,31086,0.87507355),(7452,31610,0.84707606),(7453,7775,0.58708256),(7453,9524,0.52841073),(7453,10407,0.63456905),(7453,13500,0.6585776),(7453,27884,0.29194817),(7453,29519,0.15493058),(7454,13142,0.74482507),(7454,15081,0.37080893),(7454,20494,0.48722798),(7454,21869,0.57009125),(7455,6717,0.21289924),(7455,17171,0.7917766),(7455,20009,0.9058419),(7455,21850,0.16027194),(7455,23865,0.45925593),(7456,10853,0.2567155),(7456,22917,0.13169122),(7456,24686,0.6226375),(7457,10159,5.5429284e-2),(7457,12154,0.33954647),(7457,15401,0.24652573),(7457,18246,0.3637075),(7457,28642,9.423983e-2),(7458,8842,0.33471373),(7458,18157,0.13636535),(7459,877,0.16085571),(7459,29807,0.11700589),(7460,16090,0.9173663),(7460,18354,0.43310845),(7460,25199,0.4166173),(7461,2080,0.62735415),(7461,2663,0.5987471),(7461,7178,0.95830935),(7461,7214,3.5760246e-2),(7461,21699,9.959767e-2),(7462,3495,0.20309778),(7462,14145,8.277143e-2),(7462,26514,0.801183),(7463,11142,5.851238e-2),(7463,12972,0.12698656),(7463,25501,0.7930154),(7464,266,0.24423414),(7465,401,0.28448796),(7465,8250,0.61755425),(7465,25682,0.8911101),(7465,28848,0.24698994),(7466,4490,0.17697877),(7466,16414,0.6969669),(7466,16960,0.16104133),(7466,25737,0.81577665),(7466,30656,0.82281035),(7467,12377,0.59913963),(7467,23173,0.9562616),(7467,32647,0.1560254),(7468,6286,0.56122404),(7468,6965,0.33722362),(7468,11223,0.61282533),(7468,14265,0.905594),(7468,15810,0.802003),(7468,23486,0.6164965),(7469,935,0.5279423),(7469,2932,8.676576e-2),(7469,20104,0.45498595),(7469,24451,0.73870724),(7469,26931,0.9482519),(7469,27957,0.9165184),(7469,32410,0.6446391),(7470,23372,2.5425648e-2),(7471,9127,0.63331664),(7471,13173,0.3044904),(7471,22915,0.6322865),(7472,14900,0.4981283),(7472,17523,0.8298301),(7472,19554,0.8210327),(7472,24747,0.6475483),(7472,29442,0.7732148),(7472,30025,0.97875404),(7473,29227,0.9164698),(7474,2820,0.19503182),(7474,4265,0.40743622),(7474,7526,0.7202086),(7474,19856,0.27972665),(7474,32008,0.41973665),(7475,4702,0.95005596),(7475,12679,0.18742791),(7476,12329,0.19512005),(7476,14258,0.80482495),(7476,14954,0.5040163),(7476,15345,1.701865e-2),(7476,16613,0.6594315),(7476,24559,0.66212785),(7476,28880,0.69768494),(7477,2794,0.73438066),(7477,10935,0.52245915),(7477,31098,0.49059197),(7478,9115,0.22594179),(7478,20618,0.9005745),(7478,25869,2.1487791e-2),(7478,30233,0.6418095),(7479,4607,0.51441544),(7479,25757,0.64083064),(7480,12683,7.128586e-2),(7480,12889,0.39989477),(7481,7590,0.19835389),(7481,10804,0.63242275),(7481,17660,2.0797264e-2),(7481,19126,0.8791474),(7481,22653,0.8561024),(7481,30103,0.9491227),(7481,30313,0.80471283),(7481,30514,0.47068217),(7482,11109,0.2906367),(7482,11761,0.10286927),(7482,18016,6.52626e-2),(7483,1319,0.24693422),(7483,16229,0.5349813),(7483,18700,0.35548726),(7483,21023,0.5870857),(7483,28113,0.6115624),(7484,1642,0.4332867),(7484,2764,5.8075977e-3),(7484,6005,0.75199205),(7484,8131,3.337144e-2),(7484,24536,0.7595799),(7485,8083,0.9026393),(7485,20027,0.99595755),(7485,25403,0.74776185),(7485,26160,0.5609305),(7486,3264,0.64407337),(7486,19039,5.325986e-2),(7486,20284,0.26610705),(7486,25912,0.6878813),(7486,32376,0.1011046),(7487,629,0.33785373),(7487,11256,0.9891864),(7487,16541,0.20761988),(7487,23080,0.82969487),(7487,25933,0.22558838),(7487,27889,0.29714644),(7487,28660,0.5060457),(7488,2147,0.21494836),(7488,5552,0.5527526),(7488,8034,0.27428815),(7488,12066,0.32220468),(7488,19241,0.9602684),(7488,20916,0.42579824),(7488,22997,7.529518e-3),(7488,27944,0.8460672),(7488,31257,0.9981255),(7489,11682,0.45224273),(7489,29354,0.83764726),(7490,1786,2.8123945e-2),(7490,7784,0.9982458),(7490,17585,0.65579385),(7490,30279,0.48518255),(7491,17512,0.13800113),(7491,29356,0.27275229),(7492,12482,0.8909558),(7492,13529,0.4271367),(7492,15199,8.50424e-2),(7492,16298,0.5057548),(7492,16345,0.7775585),(7492,18455,0.91846216),(7493,3429,5.99092e-2),(7493,10230,0.8623142),(7493,11200,0.3102056),(7494,3452,0.9393903),(7494,16430,0.6219601),(7495,19332,0.9208132),(7495,20381,0.19218114),(7495,23097,0.6931779),(7496,9611,0.77816826),(7496,13460,0.9157546),(7496,14453,0.37428516),(7496,21093,0.54519594),(7497,1325,0.3683743),(7497,9217,0.86439234),(7497,10050,0.75238633),(7497,16598,0.37175593),(7497,24497,0.4203973),(7498,5380,0.18178308),(7498,10191,0.93172294),(7498,28186,0.5776878),(7499,12347,0.24430679),(7499,18247,0.48497382),(7499,24760,0.80222535),(7499,30303,0.31567466),(7500,5266,0.13340971),(7500,7418,0.844052),(7501,1306,0.5832189),(7502,3391,0.8139997),(7502,12125,8.093572e-2),(7502,21188,5.9365235e-2),(7502,26412,8.092783e-2),(7503,1430,0.89800835),(7503,3205,0.7501327),(7503,8591,0.5434848),(7503,10409,0.20788918),(7503,11917,0.86874276),(7503,15655,0.4059697),(7503,17779,0.26994404),(7503,19692,0.89573437),(7503,32057,0.4049679),(7504,16817,0.45277807),(7504,23733,0.39126217),(7505,3858,0.6857379),(7505,26254,0.38366634),(7506,12108,0.18688779),(7506,25321,0.31191593),(7507,5215,0.30104163),(7507,11373,0.910101),(7507,15611,0.29942206),(7507,15718,0.31812853),(7507,19119,0.5437174),(7507,22201,0.34189364),(7508,6035,0.9752867),(7508,8324,0.1791938),(7508,10636,0.7926273),(7508,22273,0.6369436),(7508,23527,0.9441806),(7509,20009,0.56639045),(7510,4112,0.33530492),(7510,5744,0.39721933),(7510,17000,0.83338326),(7510,18624,0.92601115),(7510,22635,5.844142e-2),(7511,3312,0.51847196),(7511,25655,0.6931876),(7511,27595,0.75502867),(7512,260,0.40636057),(7513,4609,0.11413141),(7513,8807,0.48739183),(7513,18108,0.983187),(7513,20418,0.32282588),(7513,30173,0.78354603),(7514,4489,0.42477614),(7514,5045,0.19430691),(7514,19767,0.58695465),(7514,20416,0.49929157),(7514,22969,0.113965765),(7514,23767,0.8560936),(7514,32664,0.4374133),(7515,13824,0.6719787),(7515,15737,0.9940415),(7515,31528,0.17770703),(7516,8885,3.8835097e-2),(7516,13695,8.243707e-2),(7516,18160,0.68303204),(7516,28725,0.69282067),(7516,30110,0.5160264),(7517,9015,0.10738437),(7518,28505,0.38123688),(7518,30167,0.9827943),(7519,3656,0.23932193),(7519,9803,0.16759318),(7519,9876,0.3284206),(7519,16331,0.7111667),(7519,32534,0.21136735),(7520,8431,0.9278932),(7520,8613,0.23915415),(7520,13987,0.9588677),(7520,17641,0.3634662),(7521,22060,7.1993686e-2),(7521,27264,0.9004088),(7521,31921,0.60452646),(7522,24223,0.44377837),(7522,27427,0.2770315),(7523,607,0.3478937),(7523,1040,0.17285387),(7523,1521,0.35525474),(7523,1745,0.73812383),(7523,4498,0.15602499),(7523,7508,0.7913219),(7523,8555,0.8200152),(7523,22629,0.93700784),(7523,23503,0.2203617),(7524,9679,0.3637499),(7524,17620,0.38106552),(7524,23466,0.50586027),(7524,23901,1.5760897e-2),(7524,26895,0.48930362),(7524,30268,0.36831462),(7525,3388,5.733158e-2),(7525,14646,9.061915e-2),(7525,18627,0.8327427),(7525,22458,0.48593187),(7526,7471,0.2319289),(7526,8316,0.28183022),(7526,21930,0.42337814),(7527,15585,0.21426992),(7527,20333,0.8973678),(7527,31978,0.9640914),(7528,9914,0.7767922),(7528,17094,9.541551e-2),(7528,17152,0.46993464),(7528,20967,0.2877848),(7528,29431,0.666377),(7529,8867,0.4566361),(7529,18789,0.9180803),(7529,19296,0.947002),(7530,1477,0.43086702),(7530,10207,0.20825529),(7530,21903,0.9022414),(7531,1513,0.47642574),(7531,2082,0.4187821),(7531,4352,0.46450484),(7532,25313,1.1373475e-2),(7533,4430,0.6591591),(7533,23105,0.6034925),(7533,32422,0.6461376),(7534,2696,0.65058094),(7534,2934,0.88873184),(7534,3298,0.41200382),(7534,20875,0.19316614),(7534,23486,0.40978605),(7534,31470,0.68524617),(7535,3267,0.49707347),(7535,6560,0.16691446),(7535,19326,0.28326428),(7535,22853,0.61894274),(7536,13536,0.49424455),(7536,15926,0.39339158),(7536,26311,0.53047895),(7536,26560,0.4940537),(7538,3739,6.692939e-2),(7538,4047,0.9028766),(7538,4908,0.4140339),(7538,7798,0.24260421),(7538,24497,0.6310291),(7538,25437,0.6576693),(7539,959,0.77090895),(7539,1252,0.18621035),(7539,6983,0.19036442),(7539,21672,0.7096462),(7539,22526,7.333663e-2),(7539,29945,0.8730057),(7540,6231,0.6861554),(7540,9087,0.40324116),(7540,11122,0.9134888),(7540,20704,6.799685e-2),(7541,14446,0.93832827),(7541,25797,0.25860023),(7542,1366,0.8954798),(7542,9433,0.8220997),(7542,19115,0.424535),(7542,23418,0.53750885),(7542,26443,0.4926741),(7542,32554,0.30886453),(7543,11846,0.4116414),(7544,459,0.13111493),(7544,5691,0.16026735),(7544,8993,0.33542177),(7544,10651,0.6621235),(7544,28199,0.4103373),(7544,28857,0.72903514),(7545,18602,0.6415394),(7545,20700,0.41974086),(7545,26178,0.16424887),(7546,1080,0.1705956),(7546,3367,0.26211858),(7546,4661,0.3297534),(7546,10885,0.70845854),(7546,11978,0.5652796),(7546,28949,0.5042427),(7547,31021,0.35711977),(7547,31395,0.20130293),(7547,31632,0.44697288),(7548,11007,0.9621645),(7548,25872,0.75147945),(7548,30020,0.53245157),(7549,2821,7.536501e-2),(7549,26081,5.0066013e-2),(7550,4116,0.75680196),(7550,7541,0.7803578),(7550,14543,0.9750481),(7550,20858,0.29168442),(7550,29397,0.7549122),(7550,29908,0.5826181),(7551,13408,0.9769381),(7551,16506,0.29761887),(7551,19129,0.34006673),(7551,25453,0.9703523),(7551,29506,0.33795926),(7552,3551,0.66129184),(7552,8029,0.10116907),(7553,15028,0.91996586),(7553,17792,0.2724411),(7553,31610,8.164169e-2),(7553,32387,0.8981898),(7554,2777,0.9877546),(7554,7797,0.53453153),(7554,21181,0.7022215),(7554,31955,0.91257113),(7555,5904,0.99015),(7555,27146,0.50972676),(7555,32668,0.14327958),(7556,728,0.20544475),(7556,1161,0.62655205),(7556,3995,0.45606476),(7556,29907,0.35171196),(7557,6530,9.70795e-2),(7557,8083,0.6380321),(7557,17621,0.4935294),(7558,8788,0.38530624),(7558,24702,0.53590363),(7558,28393,0.3210127),(7559,2786,0.43681005),(7559,14203,0.7491926),(7559,23411,0.74177766),(7559,28193,0.5443611),(7560,2078,0.8876583),(7560,4902,0.15619548),(7560,16705,0.32110512),(7560,32563,0.90040785),(7561,3627,9.866482e-3),(7561,17541,0.7085661),(7561,32105,0.5349899),(7562,17428,0.68447715),(7562,18999,0.79045343),(7562,19364,0.7589287),(7563,13498,0.910873),(7563,31062,5.1863242e-2),(7564,8115,0.25258875),(7564,15434,0.8458285),(7564,25733,1.2332377e-4),(7565,6108,0.3744297),(7565,10166,0.91890585),(7565,10363,0.7927468),(7565,26614,0.1394612),(7565,28630,0.49962872),(7566,685,0.62846947),(7566,1717,0.3901541),(7566,3032,4.089748e-2),(7566,11898,0.28309983),(7566,18515,3.4759868e-2),(7567,4904,0.30357653),(7567,31861,0.35936415),(7568,17010,0.4979747),(7568,17285,0.24994108),(7569,30621,0.28371635),(7570,3926,6.0648892e-2),(7570,27570,0.52465934),(7571,7147,9.813014e-3),(7571,10626,0.6851147),(7571,21314,2.386507e-2),(7572,1545,0.18715835),(7572,20460,0.9752101),(7573,2885,0.6174568),(7573,11512,0.22944628),(7573,22868,0.3352143),(7573,26429,0.34341928),(7573,28340,0.24238215),(7574,4612,0.8288893),(7574,7425,0.123282805),(7574,17196,0.20476332),(7575,2832,0.529269),(7575,3045,0.78473794),(7575,4953,0.95353097),(7575,8236,6.664843e-2),(7575,11448,0.93184596),(7575,24839,0.9752046),(7575,29188,0.9645395),(7576,5928,0.7170344),(7576,15599,0.9529364),(7577,26745,6.916893e-2),(7577,32350,0.95677626),(7578,6104,7.077606e-2),(7578,21549,0.43000522),(7578,29345,0.19312656),(7579,2757,0.8917358),(7579,14440,0.77821386),(7579,30185,0.37937826),(7580,7789,0.364881),(7580,24115,0.34266505),(7581,1308,0.19149566),(7581,5002,0.414255),(7581,9425,7.837811e-2),(7582,1614,0.18073013),(7582,8835,0.74426645),(7582,17432,0.5648301),(7583,8058,0.6585213),(7583,17471,0.3982888),(7583,17667,2.5258727e-2),(7583,23333,0.7384713),(7583,28188,0.695603),(7584,17549,0.15359363),(7584,22419,0.24506214),(7584,23800,0.26355252),(7584,27641,0.3930908),(7584,31654,0.55602854),(7585,7598,0.16371922),(7585,16107,0.38629866),(7585,20921,0.85937935),(7586,1845,0.8275049),(7586,4693,0.55395466),(7586,8221,0.36715454),(7586,8849,3.908096e-2),(7586,12728,0.89763254),(7587,7740,0.20028374),(7587,10630,0.10248245),(7587,28004,6.4994894e-2),(7588,3319,0.7922887),(7588,19082,0.5116752),(7589,3152,7.263843e-2),(7589,4092,0.23345488),(7589,10815,0.62782276),(7589,22820,0.36649987),(7589,31282,0.8509446),(7590,12574,0.26318207),(7590,28233,0.27973872),(7590,28932,0.41931543),(7591,4907,7.280889e-2),(7591,24188,0.63767874),(7591,27178,0.21693105),(7591,29072,0.40930137),(7592,22844,0.61763084),(7592,23742,0.3248508),(7592,25135,0.2524912),(7593,8835,0.64610046),(7593,22399,0.84728867),(7593,24367,0.44091475),(7593,25080,0.27811182),(7594,3206,0.79719186),(7594,3975,0.66358477),(7594,4047,0.89861846),(7594,23942,1.8736994e-2),(7594,26344,0.29379746),(7594,28797,0.36047205),(7594,31911,0.26504618),(7595,2031,0.15922539),(7595,8372,1.85754e-2),(7596,11188,0.32895485),(7596,12830,0.3939316),(7596,24577,0.4910737),(7596,25860,0.11020302),(7597,9584,0.13939483),(7597,15193,6.81051e-2),(7597,15440,0.2583479),(7597,20773,0.3368852),(7597,21876,0.37034795),(7597,24602,0.12831871),(7598,12844,0.97018445),(7598,27265,0.7723839),(7598,31092,0.4480543),(7599,5012,0.9675573),(7599,21590,0.12039381),(7599,23290,0.28354976),(7599,31408,0.122111015),(7600,11197,0.82776964),(7600,12091,0.21282205),(7601,1001,0.9828676),(7601,2580,0.6477809),(7601,3008,0.91277516),(7601,14975,0.122468986),(7601,17587,0.48836052),(7601,21641,0.97721297),(7602,143,0.63702035),(7602,5200,0.840607),(7602,14277,0.22395633),(7602,16682,0.8804924),(7602,20193,0.5035844),(7602,25714,0.5452084),(7602,27191,0.9259935),(7602,27756,0.2520576),(7602,29157,0.90081984),(7603,1479,0.17502704),(7603,3141,0.44476753),(7604,1795,0.8878505),(7604,3828,0.868303),(7604,17168,0.7627714),(7604,23458,0.29896545),(7604,28762,0.2202665),(7604,28912,0.113979205),(7604,32657,0.76961434),(7605,6868,0.26196474),(7605,12597,0.70247144),(7605,18285,0.5025881),(7605,20730,0.38224325),(7605,24767,0.61695075),(7606,1490,0.2930694),(7606,5801,7.5980544e-2),(7606,12781,0.6682304),(7606,24444,0.69139034),(7606,28595,0.8118114),(7607,9218,0.60978425),(7607,9859,5.8627915e-2),(7607,28808,2.573504e-3),(7608,10260,0.8027457),(7608,13624,0.66319704),(7608,29085,0.6508557),(7609,792,0.46404514),(7609,3644,0.25568944),(7609,5813,0.69202274),(7609,21770,0.8393189),(7609,22192,0.6850915),(7610,10173,0.87549835),(7610,20029,0.2793629),(7610,20901,0.87037694),(7610,31939,0.458091),(7611,10862,0.55039716),(7612,1146,0.3965857),(7612,8007,0.22666179),(7612,8630,0.30099383),(7612,26631,0.9304105),(7612,28803,0.75378144),(7612,31488,0.6855611),(7613,12821,0.46582985),(7614,23860,0.16116136),(7614,27665,0.9361962),(7614,29574,0.25488296),(7615,1816,0.8297853),(7615,10191,0.90603644),(7615,30174,0.6237222),(7615,30698,0.82526994),(7616,16280,0.1435701),(7616,21849,0.85808355),(7616,26494,0.8173579),(7617,14738,0.37835786),(7617,17052,0.22186442),(7617,28665,2.1682434e-2),(7617,32741,0.87558156),(7618,14861,7.223567e-2),(7618,20550,0.6271807),(7618,23158,5.6441408e-2),(7619,808,0.47118318),(7619,12007,0.86587477),(7619,13196,0.7068194),(7619,13693,8.315106e-2),(7619,16618,0.93554384),(7619,21155,0.60085136),(7620,12049,0.94616455),(7620,13734,0.7113476),(7620,21388,0.1179379),(7621,6027,0.6828345),(7621,11907,0.96116483),(7621,24275,9.487563e-2),(7622,1549,0.58158654),(7622,5034,0.21116053),(7622,7988,0.14075343),(7622,11424,0.98305595),(7622,18559,0.93129444),(7623,6000,0.4474341),(7623,14957,0.12554127),(7623,28068,0.8334602),(7624,4431,0.546491),(7624,8365,0.12684384),(7624,15908,0.7113714),(7625,6418,0.6070495),(7625,8285,0.49375653),(7625,26860,0.15727326),(7626,2166,0.6919178),(7626,13509,1.9675765e-2),(7626,24560,0.4874177),(7626,26925,0.6421574),(7626,31975,0.90310967),(7627,15396,0.23017494),(7627,28801,0.59024817),(7628,5949,0.7350348),(7628,8139,1.9818489e-2),(7628,12021,0.72618115),(7628,32040,0.6249568),(7629,1293,0.67944115),(7629,14098,0.8569963),(7629,24894,0.48976249),(7630,10810,0.12598674),(7630,24343,0.8449413),(7630,27125,0.40579447),(7631,13231,0.68858236),(7631,13400,0.6663344),(7631,15456,0.918991),(7632,14168,0.49870297),(7632,16627,7.960115e-2),(7632,22387,0.98656523),(7632,23221,0.37397358),(7633,1132,2.061523e-4),(7633,5958,0.16525978),(7633,11235,0.59227157),(7633,18415,0.4989462),(7633,21711,0.1537222),(7633,28110,0.14668576),(7634,16753,0.4667698),(7634,19993,0.53399855),(7634,24391,0.5403518),(7634,26989,0.63615024),(7634,29915,0.10332378),(7634,30292,1.40523575e-2),(7634,30358,0.7977083),(7635,3526,0.40639013),(7635,3939,0.44607967),(7635,9524,0.73732793),(7636,6577,0.9946303),(7636,30097,0.9933272),(7638,13886,0.5508544),(7638,21071,8.67698e-2),(7638,23874,0.35287407),(7638,29174,0.48717117),(7639,11630,0.41008124),(7639,20089,0.5343076),(7639,20367,0.86101973),(7639,23835,0.4104831),(7639,27032,0.4460538),(7639,28377,0.69105375),(7639,30367,0.14918028),(7639,32730,0.6820939),(7640,9761,0.57435584),(7640,10651,0.4648801),(7640,19528,0.73505795),(7640,30450,0.71410507),(7640,31486,0.35543403),(7641,5848,0.7893194),(7641,7266,0.67316496),(7641,26651,0.20504317),(7642,3991,9.329694e-2),(7642,6736,0.89947337),(7642,9895,0.7788244),(7642,12585,0.4678862),(7642,14855,7.853304e-2),(7642,22063,0.307505),(7642,27018,0.6419426),(7642,28440,0.72323775),(7643,8137,0.3476566),(7643,11259,0.8428604),(7643,11547,0.2907637),(7643,15823,0.90317434),(7643,24846,0.3900825),(7643,25352,0.89257234),(7644,1102,0.30980897),(7644,1869,0.9810663),(7644,20608,0.89222354),(7644,28722,0.8953961),(7645,8938,1.913142e-2),(7645,11455,0.99832),(7645,13007,8.910302e-2),(7645,23579,0.5384006),(7646,29365,9.639383e-2),(7646,30397,0.42351362),(7647,3499,0.3477559),(7647,6532,0.6491581),(7647,22180,0.6212856),(7648,16999,0.17595701),(7648,30593,0.45445856),(7649,11050,8.053301e-2),(7650,9175,7.364785e-2),(7650,12994,0.85088515),(7650,21212,0.7212173),(7651,1680,0.7650083),(7651,21436,0.77667224),(7652,3892,9.096046e-2),(7653,2531,0.1626418),(7653,12508,0.9405773),(7653,27340,0.10341053),(7653,27856,0.35110083),(7653,32068,0.6468491),(7654,2909,0.83301663),(7654,3168,0.7301091),(7654,5192,0.46808454),(7654,14192,0.86554587),(7654,20931,0.22164723),(7654,23132,0.2543756),(7654,28278,0.49246755),(7655,7740,0.89232576),(7655,12931,0.32441103),(7655,21536,0.14710782),(7655,31934,0.27126944),(7656,5267,0.27208924),(7656,5289,0.80971855),(7656,6102,0.43648097),(7656,9032,0.49807206),(7656,9938,0.23216467),(7656,13865,0.47139418),(7656,23442,0.81231886),(7657,17929,0.9782898),(7657,26520,0.20834047),(7657,31497,0.70897794),(7658,11371,0.203995),(7659,4752,0.55023074),(7659,8704,5.725289e-2),(7659,13307,0.18743593),(7659,18141,0.25936982),(7659,20021,0.6290071),(7660,4773,9.6003704e-2),(7660,8021,0.14637403),(7660,8758,0.5759096),(7661,2611,0.41720468),(7661,2843,1.812003e-2),(7661,4431,9.3589246e-2),(7661,9963,0.6758675),(7661,12702,0.8070944),(7661,14535,0.7425293),(7661,16361,0.9054589),(7661,19896,0.8370273),(7661,20673,0.24647251),(7661,24989,0.45158538),(7661,32263,0.3228424),(7662,3680,0.11146092),(7662,13458,0.49409053),(7662,22760,0.9811479),(7663,2921,0.9786917),(7663,5708,0.94811785),(7663,12713,0.17104353),(7663,22339,0.19628131),(7663,23502,0.70709825),(7664,16891,6.1024323e-2),(7664,22924,8.46024e-2),(7664,26447,0.94050753),(7665,5249,0.35125536),(7665,5385,0.9799747),(7666,12329,0.63046813),(7666,17707,0.27709597),(7667,8310,2.2446772e-2),(7667,23210,5.385921e-2),(7667,25042,0.80595225),(7668,1134,0.83149177),(7668,1693,0.9499566),(7668,21287,0.82655394),(7668,21366,0.76316226),(7668,24956,0.12748094),(7668,28033,0.6650304),(7669,9543,0.6243893),(7669,17957,0.4877841),(7669,19593,0.5788687),(7670,1202,0.831453),(7670,24373,0.95451546),(7670,24643,0.21665841),(7670,30782,0.799678),(7671,18965,0.8243219),(7671,23935,0.97831595),(7671,30906,0.71232325),(7671,32386,0.89306325),(7672,2033,0.3336148),(7672,11745,0.44228336),(7672,23562,0.62090254),(7672,27872,0.26958776),(7672,29803,0.83185625),(7673,18742,0.7282482),(7673,27473,6.1873455e-2),(7673,28271,0.3082033),(7673,28881,0.18192872),(7673,32671,0.35297844),(7674,1079,0.28647095),(7674,8677,0.60094386),(7674,12474,0.38627887),(7674,19568,0.28810343),(7674,23090,0.17426586),(7674,30028,0.27402267),(7675,832,0.744262),(7675,8103,0.73416364),(7675,20710,0.7404427),(7676,8948,0.1662621),(7676,27308,0.717976),(7676,28416,0.44167858),(7677,4230,0.9249116),(7677,26692,0.56819546),(7677,27857,0.7569927),(7678,7053,0.60953164),(7678,13963,0.6265283),(7678,20237,0.76153326),(7679,7437,0.5590195),(7679,8085,0.80812514),(7679,27886,0.99969697),(7679,30726,0.17762026),(7680,7777,0.658532),(7680,16669,0.3847519),(7680,19162,0.78132635),(7680,20757,0.49445173),(7681,4089,0.9461038),(7681,7993,0.85525906),(7681,10753,0.33429712),(7681,14033,0.8421629),(7681,15813,0.86872476),(7682,16842,0.5408355),(7682,21983,0.1740929),(7682,26688,0.27855092),(7682,26955,0.16781032),(7683,1707,0.9475641),(7683,16243,0.9940414),(7683,22942,0.18149301),(7683,23709,0.5560579),(7683,27983,0.5956417),(7683,28761,0.39154562),(7684,11429,0.56630945),(7684,18063,0.500854),(7684,25915,0.4434917),(7684,27672,0.3324787),(7685,3102,0.30323297),(7685,7164,0.24396192),(7685,14069,0.57162267),(7685,18877,0.43299404),(7685,21635,0.17643818),(7686,16060,0.46560317),(7686,25742,0.5145669),(7686,27000,0.93239343),(7686,30980,0.40234876),(7686,32268,0.2098193),(7687,1315,0.5850039),(7687,5536,0.71520406),(7687,11580,0.825091),(7687,13914,0.14582938),(7687,21830,0.69861895),(7687,28914,8.079861e-2),(7687,29040,0.35001504),(7688,1843,0.32667193),(7688,8264,0.8439698),(7689,4454,0.2052646),(7689,7450,0.27130586),(7689,10313,0.3967169),(7689,16242,0.9312454),(7689,20937,0.92930835),(7689,21211,0.5310113),(7690,3082,0.8419639),(7690,9753,0.243587),(7690,11070,1.2416184e-2),(7690,14320,0.38928688),(7690,23815,0.34704462),(7690,28950,0.7166239),(7690,30055,0.27476925),(7691,1282,8.538554e-2),(7691,3024,0.44054532),(7691,11775,0.66426694),(7691,17273,0.42685953),(7691,20458,0.7018888),(7691,21286,3.2241765e-2),(7691,25425,0.90510625),(7691,31543,0.6238887),(7692,6520,0.22501808),(7692,9166,0.90916795),(7692,9623,0.3376896),(7692,9640,0.77361506),(7692,27383,0.11510539),(7693,6196,0.47938865),(7694,190,0.9093358),(7694,2325,0.14568226),(7694,4716,0.7970412),(7694,23107,7.0970744e-2),(7695,371,0.9058049),(7695,7120,0.30809066),(7695,15952,0.40518808),(7695,23286,0.43812323),(7696,19562,0.71300024),(7696,22344,0.8803449),(7696,25072,0.64013606),(7696,29655,0.16342065),(7696,31471,0.74285364),(7696,31945,0.9807903),(7697,25331,0.10483344),(7697,28252,0.2672126),(7698,6397,0.503476),(7698,12533,0.7278878),(7698,12890,0.55766445),(7698,16343,9.3721785e-2),(7698,19985,6.2631555e-2),(7698,21187,0.2901558),(7698,27090,0.21234126),(7698,31383,0.7509604),(7699,5829,0.54391867),(7699,6461,0.63924),(7699,6464,0.9902304),(7699,7146,0.72348946),(7699,10912,0.54552305),(7699,18495,0.5417322),(7700,10233,0.92248064),(7700,10335,0.9381866),(7700,24002,0.71230006),(7701,798,0.327991),(7702,9991,0.5826184),(7702,12591,0.57451063),(7702,18256,0.49545363),(7702,20655,0.20644896),(7702,23517,0.9809126),(7702,25468,0.9095978),(7702,29387,0.119325176),(7703,2519,9.4700664e-2),(7703,22033,5.9215833e-2),(7704,16287,0.43825397),(7704,18444,0.31652284),(7704,24589,0.67659247),(7704,27661,0.34013462),(7704,31113,7.362256e-2),(7705,2190,0.67510355),(7705,12528,0.4906673),(7706,7754,7.253209e-2),(7706,8947,0.5424742),(7706,31234,0.16620469),(7706,31279,0.16541126),(7707,2007,5.7148733e-3),(7707,5187,0.17385888),(7708,2883,0.84165645),(7708,5083,0.3521323),(7708,11327,0.2608651),(7708,19457,0.79735816),(7708,28635,0.39078456),(7708,29549,0.14750785),(7709,3488,0.27535632),(7709,8886,0.8466111),(7709,14259,8.4857576e-2),(7709,24106,0.22825082),(7709,27164,0.23017246),(7710,10541,0.48734128),(7710,15700,0.23308542),(7710,28186,0.2576283),(7711,3332,0.23046224),(7711,8810,7.514718e-4),(7711,15819,0.33140427),(7711,16703,4.064504e-3),(7711,17707,0.9103599),(7711,19806,0.5252685),(7712,798,0.9831995),(7712,8184,0.1841839),(7712,27336,0.11353755),(7712,30550,0.4134188),(7712,31992,0.8927756),(7713,23,0.92572665),(7713,5988,0.19292088),(7713,14284,0.677497),(7713,16985,0.72758746),(7713,26004,0.9435315),(7713,30966,0.4301548),(7714,31867,0.5679048),(7715,5819,0.14245352),(7715,5822,9.50967e-2),(7715,12265,0.5368568),(7716,16501,0.6884084),(7716,29020,0.85701144),(7717,3064,9.2769094e-2),(7717,3725,0.10176946),(7717,7249,0.10644164),(7717,8226,0.88123304),(7717,10394,0.8194312),(7717,12191,0.6596284),(7717,12730,0.7274462),(7717,29875,0.5150587),(7717,30957,6.525971e-2),(7718,21605,0.85845333),(7719,2269,0.38288486),(7719,10752,0.38242078),(7719,14036,0.44790697),(7719,17404,0.25821146),(7719,19370,0.2926273),(7719,19799,0.9445071),(7719,21232,0.9288564),(7719,32511,0.4182078),(7720,5516,0.35711294),(7720,11848,0.9880366),(7720,13649,0.76066095),(7720,14006,0.8444451),(7720,25434,0.5515118),(7720,28014,0.32241932),(7720,28560,0.18571201),(7720,31016,0.8951075),(7721,1563,0.4671171),(7721,17519,0.40969044),(7722,19278,0.89045954),(7722,20621,7.5360276e-2),(7723,10400,1.7431806e-3),(7723,14710,0.7066569),(7723,24187,6.9149554e-2),(7724,4918,0.6580305),(7724,27242,0.10377733),(7724,29233,0.22503117),(7724,29966,0.10343954),(7725,18267,1.0729625e-2),(7725,18983,0.6013904),(7725,20527,0.49681795),(7725,20587,0.8594898),(7725,20895,0.6719131),(7725,29395,0.4790401),(7726,7938,0.94110185),(7726,12720,0.23596776),(7726,16015,0.735218),(7726,17666,0.13614361),(7726,22612,0.8386012),(7726,23478,0.23782858),(7727,4026,4.6389673e-2),(7727,12740,0.28211945),(7727,14792,0.27665293),(7727,14870,0.19809031),(7727,16179,0.5642768),(7727,25766,0.55558735),(7728,12668,0.4745987),(7728,19788,0.96517676),(7728,29114,0.66331697),(7728,31839,4.7340672e-4),(7728,32391,0.8335963),(7729,13054,0.16159523),(7729,20241,0.49513996),(7729,26282,0.7521673),(7729,29401,0.855928),(7730,6220,0.88008225),(7730,12051,0.83689606),(7731,5962,8.915005e-2),(7731,18874,0.91459143),(7731,20845,0.18884654),(7732,1008,0.9538854),(7732,5646,0.82822806),(7732,11142,1.4599353e-4),(7732,13924,0.9944586),(7732,14169,0.5763582),(7732,15650,0.6342393),(7732,19575,0.82591194),(7732,22879,0.75793535),(7733,2394,0.24527149),(7733,21442,0.39160067),(7733,31156,0.31883907),(7734,440,0.2705709),(7734,2492,0.99361956),(7734,6572,0.94076926),(7734,6920,0.53792626),(7734,11735,0.8708026),(7734,18592,8.26287e-2),(7734,23776,0.35378692),(7735,13433,0.44766507),(7735,22198,7.289355e-2),(7736,26325,0.4069154),(7737,1659,0.74131703),(7737,5371,0.2887293),(7737,12982,0.7807605),(7737,16345,0.52864915),(7737,22269,0.50656164),(7737,23655,0.76368433),(7737,30183,0.7997683),(7737,32622,0.62212414),(7738,6477,0.53796196),(7738,14522,0.88650596),(7738,16450,0.38685462),(7738,21515,0.848133),(7739,1598,0.9136287),(7739,9826,0.581746),(7739,19698,0.7746489),(7739,25024,0.45448986),(7739,26620,0.72566104),(7740,7684,5.661378e-2),(7740,8369,0.7558733),(7740,8525,0.966642),(7741,10677,3.3109564e-2),(7741,14392,0.7775708),(7741,25180,0.58984506),(7741,32690,0.9180145),(7742,13488,0.1740352),(7744,9902,0.30701336),(7744,10926,0.3221182),(7744,17831,0.7709639),(7744,21101,0.9364814),(7745,23497,0.53855383),(7745,25794,0.8892739),(7747,1557,0.43716767),(7747,17664,0.7886186),(7747,23776,0.13767959),(7747,27937,0.12360979),(7747,28375,0.8048245),(7748,524,0.8559204),(7748,2618,0.9183503),(7748,21394,0.67452633),(7748,23352,0.6314482),(7748,27281,0.2910362),(7748,27369,0.17961653),(7748,30178,0.48608032),(7749,3519,0.3606142),(7749,7436,0.47681603),(7749,9180,0.65859413),(7749,30280,0.3029083),(7750,20228,0.55029494),(7750,23744,0.22669229),(7750,25720,0.27797824),(7750,32172,0.36827356),(7751,3702,0.7561614),(7751,10220,0.13912934),(7751,21843,0.8586211),(7751,26362,9.652638e-2),(7752,2284,0.98577225),(7752,20005,0.617811),(7752,22042,0.56835175),(7752,28382,0.32751313),(7752,32238,0.91481924),(7753,11865,0.135316),(7753,17626,0.8878918),(7754,13570,0.46684393),(7754,17625,0.4201343),(7755,8575,0.706106),(7755,10178,0.10330345),(7755,11649,0.48991588),(7756,4859,0.30614537),(7756,6550,0.3717964),(7756,17881,6.273815e-2),(7756,21229,0.29426575),(7756,25959,0.9631953),(7756,32316,0.4724024),(7757,6727,0.49114317),(7757,11559,0.3857267),(7757,25964,2.1084666e-2),(7757,29840,0.49897015),(7757,31191,0.9373889),(7757,31449,0.29914486),(7757,32758,0.17538427),(7758,10845,7.4813984e-2),(7758,12292,0.56082255),(7758,13649,0.4503694),(7758,18837,0.98639125),(7758,22091,0.33704332),(7758,28547,0.73745155),(7759,3382,6.640177e-2),(7759,5758,0.59737843),(7759,15151,3.8102034e-2),(7759,26616,0.84221065),(7760,21030,0.6499113),(7761,14979,0.25606385),(7761,16295,0.3701926),(7761,16794,0.30013368),(7761,19111,0.78393894),(7761,30700,0.87881535),(7762,3082,0.56245756),(7762,14530,0.45921454),(7762,24334,0.14305511),(7763,6133,0.55935323),(7763,8113,0.4913834),(7763,9689,0.76765734),(7763,13166,0.8890436),(7763,26145,0.99529076),(7763,28679,0.18068549),(7764,4280,0.66790944),(7764,13981,0.46205097),(7764,16517,0.87679714),(7765,3683,0.9440789),(7765,21989,0.7698805),(7765,22405,0.77731144),(7765,29642,0.8660475),(7765,32585,0.5973084),(7766,42,0.8596316),(7766,7109,0.9207664),(7766,18714,0.5478273),(7766,19820,0.87961656),(7766,21505,0.39497966),(7766,32483,0.2863406),(7767,1746,0.13314186),(7767,17539,0.27355078),(7768,4051,0.8202067),(7768,4472,0.16178487),(7768,12421,0.35892937),(7768,20113,0.85778725),(7768,24642,0.18546437),(7768,27988,0.8952686),(7769,8421,0.117325574),(7769,15256,0.6181382),(7769,24828,0.2623322),(7769,25737,6.679741e-2),(7769,25759,0.41087452),(7769,27308,0.7201789),(7770,7172,0.7250949),(7770,12947,0.9703144),(7770,14841,0.90838534),(7770,25653,0.8221601),(7770,26221,0.2508997),(7770,27877,0.28951222),(7771,4526,0.62974024),(7771,16892,0.465995),(7771,19084,0.9816607),(7771,31234,0.4191714),(7772,12286,1.7986508e-2),(7772,15999,0.18702658),(7772,27674,0.9713673),(7772,30757,0.5934899),(7772,31737,0.1761612),(7773,21082,6.927332e-2),(7774,5786,0.19059637),(7774,21026,0.4409644),(7774,21147,0.5323337),(7774,22318,0.37127116),(7774,25962,0.24381796),(7774,27801,0.8873468),(7775,10285,0.4780424),(7775,18320,0.14260791),(7775,18448,0.43513247),(7775,22712,0.1910455),(7776,13244,0.48521435),(7776,17262,0.48474023),(7777,4888,6.706577e-2),(7777,18156,0.8587222),(7777,28890,0.52700263),(7778,7693,0.60765505),(7778,8558,0.5407657),(7778,16067,0.9087542),(7778,20771,0.21298361),(7778,24527,0.11102905),(7779,777,0.9400303),(7779,15036,0.37238872),(7779,18596,0.2830969),(7780,1479,0.5705843),(7780,6120,9.755776e-2),(7780,9304,0.4022837),(7780,15107,0.90910953),(7780,23065,0.108804375),(7780,25838,0.9482023),(7780,27290,0.14814208),(7780,28537,0.6929114),(7781,3522,0.44481304),(7781,8143,0.865139),(7781,9539,0.16962081),(7781,12314,8.9076735e-2),(7781,27579,0.7166631),(7782,2036,0.86297065),(7782,5578,0.96171707),(7782,6721,0.5901118),(7782,15651,0.19363894),(7782,18177,0.7648171),(7782,22422,4.4411562e-2),(7782,31796,0.93637884),(7783,1431,0.67402375),(7783,6865,1.6133439e-2),(7783,18571,0.50905323),(7783,28149,0.5890362),(7783,29880,0.13164526),(7783,30228,0.3657499),(7784,1489,7.031917e-2),(7784,9991,3.5787284e-2),(7784,19710,0.45639244),(7784,24144,0.56449527),(7785,6265,0.8032541),(7785,13393,0.31128323),(7785,15231,0.59341526),(7785,22475,8.2944125e-2),(7786,4821,0.14440396),(7786,7483,0.89908195),(7786,13790,0.98113745),(7787,1276,0.43036607),(7787,26802,0.3985038),(7787,30428,0.6642007),(7788,1645,0.5304209),(7788,6157,0.60832846),(7788,12528,0.5852297),(7788,31973,0.5838351),(7789,4448,0.37740502),(7789,8699,0.1103006),(7789,9541,0.22211356),(7789,19890,0.35872138),(7790,3210,0.55974644),(7790,6965,0.23065604),(7790,7244,0.16314895),(7790,10485,6.5013915e-2),(7790,12212,0.14002222),(7790,17921,0.38040894),(7791,26676,0.8277025),(7792,7414,0.2823809),(7792,12110,0.74789804),(7792,24501,0.16183148),(7792,25001,0.7032775),(7792,25596,0.90083796),(7792,31553,0.1704756),(7793,2461,0.739135),(7793,11579,0.92780364),(7793,28918,9.056674e-2),(7794,2343,8.79531e-2),(7794,11347,0.8482994),(7795,27569,0.3310942),(7796,11760,0.6328192),(7796,22217,1.0857139e-2),(7797,8512,0.7185312),(7797,9092,0.20006527),(7798,17180,0.6562999),(7799,1422,8.088739e-2),(7799,4688,3.4166668e-2),(7799,7567,0.84334177),(7799,9275,0.900911),(7800,19981,0.13970746),(7800,22756,0.616304),(7801,7764,0.19132233),(7801,16850,0.79879516),(7801,17574,0.5739968),(7801,17616,0.13589787),(7801,24698,0.45351002),(7802,2461,0.19275935),(7802,24702,0.30704024),(7803,6978,0.2904671),(7803,11579,0.7427061),(7803,31768,5.819807e-2),(7804,6313,0.97312653),(7804,7782,0.8038047),(7804,16453,0.76423454),(7805,290,0.41842932),(7805,555,6.2435947e-2),(7805,4411,0.20405737),(7805,9636,0.40347984),(7805,29035,0.20883457),(7806,11553,0.9610651),(7806,28781,0.187202),(7806,32637,3.5451792e-2),(7807,99,0.51128614),(7807,14285,3.8324807e-2),(7807,28389,0.44154957),(7808,19466,0.27889472),(7809,11749,0.7619301),(7809,21928,0.6451868),(7810,2481,0.37400192),(7810,11084,0.32440415),(7810,16432,0.8888774),(7810,17155,0.43973458),(7810,22958,0.6488243),(7810,32117,0.27708223),(7811,4901,0.5680081),(7811,17959,0.5842323),(7811,20825,0.77418983),(7811,22176,7.0067324e-2),(7811,31270,0.8699491),(7812,6404,0.6584897),(7813,16061,0.41674605),(7814,16056,0.8329583),(7814,22857,0.6520242),(7814,27807,0.44747725),(7815,620,3.8738355e-2),(7815,2566,0.8440055),(7815,4258,0.2766481),(7815,5063,0.23187812),(7815,6757,0.31659034),(7815,6921,0.108108416),(7815,18861,0.8611562),(7815,19858,0.26572424),(7815,26197,0.102480866),(7816,2650,0.88834685),(7816,6656,0.107872),(7816,19572,0.9991065),(7816,32660,0.57824415),(7817,802,0.14281932),(7817,14420,0.9363398),(7817,22640,0.32579088),(7817,28005,0.31059632),(7817,30751,0.8891997),(7818,13935,0.39535874),(7818,19776,0.764688),(7818,26383,0.38057002),(7819,3187,0.10661653),(7819,14081,0.18416823),(7819,14291,0.15201108),(7819,20524,0.8761589),(7819,21984,0.73472863),(7819,22892,0.1782297),(7820,4993,0.35348058),(7820,7709,0.273846),(7820,21027,0.44262546),(7820,27185,1.7827155e-2),(7821,17104,0.122233026),(7821,19324,0.6938645),(7821,27279,0.4539668),(7821,29911,0.92558485),(7822,15587,0.77354527),(7822,21142,0.9167072),(7823,31698,0.89363605),(7823,31967,0.55700964),(7824,26540,0.99960685),(7824,31278,6.191568e-2),(7824,32191,0.8399203),(7825,11165,7.9466075e-2),(7825,18218,0.4619661),(7825,23752,3.846382e-2),(7825,24565,0.57769585),(7825,26590,0.10184431),(7825,27334,0.87886405),(7825,27713,0.37445205),(7826,8640,0.7420893),(7826,22634,0.6274596),(7826,26937,0.37773085),(7827,4566,7.600578e-2),(7827,9049,0.48055565),(7827,23928,0.24056482),(7827,24754,0.19857179),(7827,24829,0.35679725),(7827,25520,0.47439024),(7828,534,0.735173),(7828,5316,4.2036183e-2),(7828,6728,0.360508),(7828,9828,0.85037726),(7828,21117,0.5577555),(7828,21736,0.42939436),(7828,26059,0.30150944),(7829,668,0.45970052),(7829,18399,0.8437787),(7829,27773,0.17765282),(7829,32024,0.20557624),(7830,8992,0.20459391),(7830,9406,0.29870453),(7830,17152,0.40172648),(7830,18244,0.5616184),(7831,2287,0.8479471),(7831,26015,0.50709385),(7831,32603,0.36505252),(7832,2226,0.88334066),(7832,2737,0.6759614),(7832,12998,0.76520693),(7832,15614,0.7527801),(7832,19064,0.88513786),(7832,21264,0.3560947),(7832,24320,0.48853257),(7833,5037,0.61131996),(7833,5318,0.59457624),(7833,26276,0.8462929),(7834,1281,0.24921738),(7834,6219,0.18998264),(7834,19761,0.1511722),(7834,25512,2.0289356e-2),(7835,33,0.793618),(7836,6986,0.5171039),(7836,8908,0.18929541),(7836,17740,0.62110406),(7837,7946,6.1958138e-2),(7837,16865,0.7031365),(7837,17429,6.3754104e-2),(7837,20986,0.33154476),(7837,21563,0.20205238),(7837,22213,0.28568202),(7838,13635,0.44516632),(7838,15964,0.41323134),(7838,21345,0.7097822),(7838,23353,0.16178386),(7839,469,4.475903e-3),(7839,4526,0.932609),(7839,6169,0.5177972),(7839,21617,5.4037254e-2),(7839,21901,0.36636075),(7839,29296,0.91867393),(7840,5580,0.820113),(7840,10619,0.31270063),(7840,18175,5.8314677e-2),(7840,23169,0.67226726),(7840,24115,0.8475439),(7840,31063,0.9206263),(7841,13898,0.69528604),(7841,18753,0.37768948),(7841,24864,0.44258007),(7841,30280,0.5874025),(7842,8196,0.9646997),(7842,9050,0.10000615),(7842,11508,0.60660017),(7842,21104,0.5869043),(7842,26317,5.4014698e-2),(7842,30614,0.194553),(7843,14775,4.1484167e-3),(7843,16349,0.47862723),(7843,21131,0.41665706),(7843,22972,0.8688493),(7843,28203,0.25152183),(7844,3834,0.18661545),(7844,10700,0.4158087),(7844,19764,0.8773615),(7844,21006,0.5641616),(7844,22519,0.20908256),(7844,23526,3.109591e-2),(7844,30658,8.892067e-3),(7845,265,0.8831849),(7845,3573,0.4263887),(7845,11937,6.585924e-2),(7845,25785,0.25413612),(7845,28904,0.7534362),(7846,1130,0.5712813),(7846,3110,0.9232517),(7846,24580,0.7288526),(7847,831,0.19196315),(7847,8529,0.9579714),(7847,24751,2.8440306e-2),(7847,25965,0.38775998),(7848,5631,5.4528657e-2),(7848,5842,0.3774898),(7849,23676,0.16469204),(7849,27102,0.18909906),(7849,28013,9.080445e-2),(7849,30845,6.1065264e-2),(7849,30984,0.62257004),(7849,31770,0.5010289),(7850,6021,0.7340026),(7850,6813,0.81899226),(7850,7615,0.811637),(7851,7727,0.4241173),(7851,13803,0.17946354),(7851,14216,0.68565476),(7851,14229,0.45921776),(7852,4307,0.9257007),(7852,25258,0.4034506),(7853,15711,0.8122319),(7853,19706,0.81758654),(7854,6056,0.9406765),(7854,18614,0.6992768),(7855,690,0.27012613),(7855,11112,6.6696085e-2),(7855,16480,0.8793867),(7855,20909,0.89771),(7856,13510,0.4545513),(7856,22910,0.9783363),(7857,7637,0.9615524),(7857,12735,0.7711601),(7857,13098,0.42382628),(7857,17205,0.1316168),(7857,17615,0.76362044),(7857,25391,0.36223027),(7858,16131,0.64524716),(7858,26893,9.0348005e-2),(7858,27488,0.69398993),(7858,30936,0.7060531),(7858,32154,4.5704447e-2),(7859,4194,0.79274714),(7859,13886,0.63384354),(7859,24543,0.49850324),(7860,12119,0.90310293),(7861,6004,6.093596e-2),(7861,8448,0.8097319),(7861,9953,0.40622064),(7861,31610,0.23612021),(7862,7128,0.75040525),(7862,7673,0.9722545),(7862,12893,0.65634),(7862,14978,0.21622227),(7862,17154,0.95017046),(7862,19373,8.4506795e-2),(7862,25742,0.5263247),(7863,1674,0.32263085),(7863,23460,0.6231344),(7863,24866,0.56391793),(7864,8451,0.4203093),(7864,11437,0.37766504),(7864,29937,0.8342098),(7865,17381,0.14189143),(7865,30000,0.1534076),(7865,30933,0.23943678),(7866,19059,0.8478402),(7867,7113,3.268866e-2),(7867,18095,0.1880445),(7867,21611,0.77800655),(7868,17278,0.36322778),(7868,26904,2.6741957e-3),(7868,31721,0.91489905),(7869,20186,0.97510076),(7869,29842,0.70304334),(7870,388,3.971699e-2),(7870,12300,0.55768204),(7870,28776,0.5165104),(7871,8560,0.8816345),(7871,21278,0.32366157),(7871,26616,0.5464677),(7872,17231,0.93819577),(7872,20321,0.8377308),(7872,25783,0.61356366),(7872,27838,0.49825314),(7872,30648,0.62150496),(7874,3668,0.5633782),(7874,7436,0.58217335),(7874,7879,0.59433365),(7874,29187,0.59408236),(7874,29486,7.3053345e-2),(7875,968,0.4583042),(7875,6140,0.96522695),(7875,28191,0.47017446),(7876,16695,0.97045916),(7876,30480,0.35902664),(7877,16184,0.26075962),(7877,18036,0.7235163),(7878,1208,0.46435758),(7878,10783,0.2849451),(7878,13897,0.30462435),(7878,20544,0.7913435),(7878,24990,0.4846751),(7878,27169,0.60910696),(7878,28948,0.9316956),(7879,14216,0.16816707),(7879,25932,0.13397984),(7879,29200,0.16446011),(7880,1806,0.49191996),(7880,16835,0.5143477),(7880,17270,0.45674893),(7880,22940,0.88757133),(7880,26144,0.8917629),(7880,29084,0.6674577),(7881,3866,0.6142298),(7881,12110,0.19494501),(7881,20221,0.9730358),(7881,22959,0.44940746),(7881,24123,0.57168645),(7881,25902,0.9577961),(7882,13966,0.27858004),(7882,21091,0.57069695),(7882,23038,3.400687e-2),(7882,24667,0.40733907),(7882,25901,0.6215516),(7882,26483,0.23308925),(7883,3042,0.8210669),(7883,4354,0.15700172),(7883,20964,0.7240654),(7883,21852,0.7682923),(7883,27394,0.6591674),(7884,4237,0.2765731),(7884,4311,0.7131286),(7884,8576,0.21897717),(7885,30641,0.8595205),(7886,19361,0.53347474),(7886,21561,0.69216037),(7887,8085,0.8802861),(7887,21290,7.702631e-2),(7887,29351,0.98978996),(7888,4369,0.83011353),(7888,25613,0.27056563),(7889,2143,0.5128704),(7889,9134,0.549387),(7889,10830,0.74425185),(7889,21080,0.9678626),(7889,23501,0.4159287),(7889,24551,7.0091195e-2),(7889,27287,0.6842013),(7889,31764,0.44406635),(7890,7738,0.30621663),(7890,30565,0.99831825),(7890,32291,0.24263445),(7891,16606,0.9128809),(7892,298,0.4403123),(7892,782,6.1077558e-2),(7892,2757,0.6688992),(7892,3541,7.801028e-2),(7892,7418,0.19588125),(7892,32710,0.69230497),(7893,761,0.6436685),(7893,846,0.20391956),(7893,8947,0.5260004),(7893,24120,0.5448512),(7893,30171,0.7772461),(7894,13713,0.25597867),(7894,19703,0.505071),(7895,16729,0.40039006),(7895,29832,0.9369484),(7896,6873,0.53803116),(7896,24601,0.15218714),(7896,27767,0.20957664),(7897,683,0.889965),(7897,3666,0.8996917),(7897,4004,0.8039062),(7897,17565,0.640098),(7897,24807,0.15574743),(7897,29451,0.40613207),(7898,20326,0.15292376),(7899,1371,0.46108934),(7899,6567,0.2275395),(7899,10253,0.7024253),(7899,20661,0.10396178),(7900,29304,0.40090704),(7901,453,0.38961235),(7901,12255,0.5801989),(7901,16037,0.117526405),(7901,22312,0.7216687),(7901,22680,1.6918536e-3),(7901,32083,0.930385),(7901,32690,0.4543845),(7902,2225,0.16890572),(7902,4105,0.6415456),(7902,21128,0.5571327),(7902,23874,0.57747316),(7903,1663,0.66705644),(7903,6227,0.64045465),(7903,10553,0.8176452),(7903,15384,0.86540985),(7903,25067,0.85176194),(7904,4641,0.9631868),(7904,6052,0.97622234),(7904,12529,0.6196966),(7904,13526,0.24730468),(7904,19721,0.855423),(7905,17727,0.13931988),(7906,20724,0.22611861),(7907,14275,0.16644195),(7907,28293,0.66881007),(7907,31559,0.8526284),(7907,31787,0.19122498),(7908,6613,0.449109),(7908,9243,0.9723493),(7908,10415,3.4385715e-2),(7908,18712,6.141502e-2),(7909,205,0.35309386),(7909,4706,0.3492159),(7909,14116,0.928507),(7909,15107,0.5363827),(7909,21610,5.5602852e-2),(7909,26275,0.5413548),(7909,30113,0.6279962),(7910,7963,0.8197555),(7910,26100,0.37760973),(7910,29088,0.27909842),(7911,5586,0.3688863),(7911,14549,0.42551386),(7911,21501,9.491838e-2),(7911,25987,0.8861017),(7911,27952,0.5640334),(7912,20973,0.7038352),(7913,1920,0.27500883),(7913,6357,0.30092874),(7913,17779,0.6278308),(7914,680,0.5800925),(7914,8656,0.5790398),(7914,16434,0.15631276),(7914,18844,0.707065),(7915,185,0.5641556),(7915,19085,0.7381792),(7915,22150,0.3612458),(7915,25254,0.827479),(7916,4614,0.20198634),(7916,10178,0.31463128),(7916,12451,0.8897638),(7916,13268,0.8786509),(7916,20905,0.33419096),(7916,21527,0.89048964),(7917,23450,0.56150126),(7917,32387,0.47582248),(7918,6621,0.541773),(7918,20964,0.78835666),(7918,26058,0.63682675),(7918,30040,0.601839),(7918,32209,0.32709503),(7919,8601,0.79531753),(7919,13469,0.14856468),(7919,20015,0.8745662),(7919,25531,0.19304152),(7920,1177,0.27775514),(7920,5046,0.4942992),(7920,17566,0.1789277),(7921,12650,0.92435724),(7921,16851,0.16827987),(7922,22451,5.644365e-2),(7922,23497,0.8701795),(7922,26672,0.5250154),(7923,16892,0.25816232),(7923,23315,0.78680867),(7924,16088,0.9745134),(7924,16528,0.48578763),(7924,30663,0.5586831),(7924,32697,0.72370917),(7925,4997,0.7427677),(7925,7295,0.5673642),(7925,8051,0.7273833),(7925,13609,0.42955703),(7925,19421,0.8023446),(7925,27483,0.7258194),(7925,31958,0.64241177),(7926,20,0.7789064),(7926,21519,0.34014523),(7927,1941,0.8795718),(7927,5357,0.12130237),(7927,9890,0.38762155),(7927,11564,0.5827871),(7927,14112,0.73048705),(7927,14862,0.8288715),(7927,24387,0.60367924),(7927,26919,0.5183182),(7927,28975,0.35936525),(7928,9910,6.233149e-2),(7929,4247,0.24028476),(7929,13114,4.453172e-2),(7929,13448,0.1393865),(7929,16545,0.71593446),(7929,22175,0.9291098),(7929,26600,0.748295),(7930,10634,0.14591998),(7930,32280,0.9433464),(7931,7427,0.79419935),(7931,11324,0.37454307),(7931,11550,0.6120069),(7931,19277,0.9862687),(7931,19736,0.94676685),(7931,20783,0.2528719),(7931,28200,0.45260105),(7932,1336,0.15092374),(7932,10431,0.6138126),(7932,11671,0.47991833),(7932,19210,0.5851708),(7932,20541,0.6494125),(7932,22198,0.10858857),(7932,28936,0.1849343),(7933,10060,0.85470086),(7933,19473,0.52051365),(7933,29755,0.40732923),(7934,4110,0.11922166),(7934,4575,0.89988136),(7934,12646,0.55296385),(7935,13139,0.6024792),(7935,23529,0.22030327),(7937,4008,0.5249246),(7938,7553,0.64313346),(7938,24277,0.2809954),(7938,24282,0.14960034),(7939,301,0.69387394),(7939,15910,0.9929255),(7939,16564,0.2806449),(7939,17303,0.6188137),(7939,21027,0.8969839),(7939,25981,0.81099683),(7940,8680,0.9536629),(7940,17906,3.2146305e-2),(7940,18543,0.15960757),(7941,9578,0.122491136),(7941,18965,0.6332474),(7941,28429,0.36000428),(7942,7918,0.10883144),(7942,12588,0.39463514),(7942,24525,0.62202513),(7942,31762,0.10713494),(7942,32262,0.70071244),(7943,18202,0.28209108),(7944,10887,0.93851197),(7944,17408,0.6696676),(7944,18184,0.8289374),(7945,11363,0.4158468),(7945,23771,0.8990249),(7946,14896,0.59685165),(7946,20095,9.386209e-2),(7946,29489,3.37875e-2),(7946,29887,0.26212257),(7947,26249,0.39136276),(7948,6257,0.24662842),(7948,28153,0.69931614),(7949,7867,0.688814),(7949,9570,0.32042086),(7949,17736,0.4824143),(7949,18830,0.23930515),(7949,23229,0.56039155),(7949,29951,0.35738325),(7950,1973,0.30028448),(7950,7131,0.1347661),(7950,8719,0.9482034),(7950,24313,0.47813153),(7950,25192,0.5012128),(7951,4128,0.5841651),(7951,6963,0.69485176),(7951,26744,0.67749244),(7951,31204,0.8506094),(7952,24878,0.44643795),(7952,27987,0.71877927),(7953,6461,0.3155833),(7953,20808,0.2245367),(7953,25170,0.19274807),(7954,3502,0.6735941),(7954,9737,6.230435e-2),(7954,11919,0.13266963),(7954,12303,0.6097359),(7954,13845,0.6907463),(7954,13854,0.14681554),(7954,28644,0.92909014),(7954,28693,8.140435e-2),(7955,2302,0.32216704),(7955,8468,0.10743921),(7955,17533,0.8035414),(7955,18598,0.52178043),(7955,22177,0.38764152),(7955,26972,0.7041345),(7956,5358,0.7404184),(7956,16301,0.66727585),(7956,32522,0.6428968),(7957,19951,0.65580106),(7957,24311,0.79841495),(7957,26355,0.16946107),(7957,27150,0.5076019),(7957,30979,1.3177433e-2),(7958,24821,0.6585099),(7958,32545,0.106224455),(7959,23207,0.668074),(7959,29202,0.4528169),(7960,957,0.21229132),(7960,9575,5.7803956e-3),(7960,23690,0.6538948),(7961,2628,6.7461687e-3),(7961,12709,0.2544222),(7962,6876,0.25372308),(7962,9090,0.68471575),(7962,17168,0.8369805),(7962,30414,0.9469907),(7963,4841,0.3637434),(7963,4971,0.7250126),(7963,6533,0.805848),(7963,11024,0.81190085),(7963,13551,0.21973617),(7963,18264,0.8911424),(7963,21397,0.516424),(7963,24178,0.73865825),(7963,24213,0.6481285),(7964,632,0.41502786),(7964,5315,0.48245972),(7964,21997,0.8103585),(7964,31230,0.7221168),(7965,1876,0.93879366),(7965,10220,0.800147),(7965,28563,8.533002e-2),(7966,2139,0.5134699),(7966,21411,0.21621002),(7966,21975,0.35399896),(7966,30928,0.7048306),(7967,5070,6.0340796e-2),(7967,16170,0.142052),(7967,30951,0.90573734),(7968,4,0.46883178),(7968,6905,0.5895572),(7968,30216,7.276866e-2),(7969,7688,1.9211408e-3),(7969,8061,0.2816678),(7969,22458,0.42336172),(7969,22719,0.29223904),(7969,30287,0.572096),(7970,4881,0.53475463),(7970,17219,0.30902183),(7970,25685,0.99703914),(7970,29532,0.9977691),(7971,5234,0.46689728),(7971,5552,0.83646333),(7971,6855,0.70130837),(7971,16932,5.5608816e-2),(7973,6675,6.883019e-2),(7973,6977,0.9416241),(7973,20757,0.6881494),(7973,26470,4.6542745e-2),(7973,30979,0.92934716),(7973,31553,0.5050127),(7974,5477,0.53956354),(7974,5798,0.57802564),(7974,12646,0.33623946),(7974,17869,0.47670045),(7974,21189,0.50415856),(7975,3800,0.30325288),(7975,27307,2.4699097e-2),(7975,29263,0.81660455),(7975,29841,0.6533258),(7976,6458,0.63112175),(7976,31323,2.6256373e-2),(7977,9922,0.41809908),(7977,19206,0.54116404),(7977,30299,0.73615843),(7978,12422,0.958553),(7978,19331,0.8652203),(7978,25675,0.57043356),(7978,31731,0.32173827),(7979,3385,0.19458675),(7979,15751,0.95864415),(7979,19458,0.2233125),(7979,24832,0.322672),(7980,17301,0.14997941),(7980,18298,0.26624984),(7980,22783,0.509447),(7980,26390,0.17728314),(7981,2059,0.19681744),(7981,7110,0.4101674),(7981,15582,0.17241335),(7981,15907,0.8740965),(7981,18336,8.060338e-2),(7981,19340,6.262982e-2),(7982,1209,0.27997062),(7982,6704,0.4405424),(7982,13859,0.30592296),(7982,28331,0.79035807),(7983,4128,0.89297885),(7983,10037,0.44612816),(7983,13113,0.82178074),(7984,10169,0.37745667),(7985,12981,0.9423362),(7985,15049,0.3553326),(7985,21175,0.8826083),(7985,32549,7.025151e-2),(7986,1154,2.9868543e-2),(7986,2604,0.33655074),(7986,26294,0.33403546),(7987,119,0.34472778),(7987,24883,0.5045534),(7987,30646,0.2561057),(7989,2834,0.48667043),(7989,10894,8.258352e-2),(7989,18964,0.81457084),(7989,29538,1.5554246e-2),(7989,29552,0.44239637),(7990,2075,0.37219384),(7990,3943,3.3823412e-2),(7990,5436,0.97576123),(7990,22264,0.39274964),(7991,9049,0.20681141),(7991,15817,0.28773108),(7991,17127,0.1440436),(7991,21697,0.5380065),(7991,23619,0.33064026),(7992,16923,0.4570269),(7992,26779,0.6540358),(7993,30011,0.11069727),(7994,3054,4.7522426e-2),(7994,8802,0.5874386),(7994,15997,0.16183956),(7994,18222,0.4071902),(7994,18660,0.34593597),(7994,19390,0.97404146),(7994,22602,0.8458694),(7994,26218,6.917951e-2),(7994,31088,0.9653939),(7995,1203,0.5641693),(7995,2908,0.759625),(7995,9075,0.79835415),(7995,12908,0.99311125),(7995,17413,0.86235714),(7995,32156,0.5402988),(7995,32489,6.552867e-2),(7996,877,0.8137424),(7996,2805,0.19879502),(7996,8312,0.10961376),(7996,9140,0.46132797),(7996,9380,0.2810731),(7996,13629,4.6837267e-2),(7996,16653,0.46138215),(7996,31611,0.39216354),(7997,2148,0.13731098),(7997,13265,0.81776774),(7997,21182,3.577993e-2),(7997,26900,8.970527e-2),(7998,5079,0.72894055),(7998,13673,0.50268644),(7998,18636,0.7098703),(7999,7194,0.14045322),(7999,15865,0.14731255),(7999,32641,0.4415515),(8000,19988,0.97735703),(8001,5905,0.11696937),(8001,21138,2.4344074e-2),(8001,26302,0.63427764),(8002,1497,0.6811958),(8002,6983,0.50860476),(8002,8287,0.47708967),(8002,16405,5.6230915e-3),(8003,6127,0.32543978),(8003,15023,0.5373881),(8003,18706,8.935147e-2),(8003,22069,0.9718585),(8003,22303,0.70131904),(8003,31952,0.70138294),(8004,11616,0.47681385),(8004,20752,4.947089e-2),(8004,27441,0.578445),(8005,3552,0.15637745),(8005,16636,0.7827293),(8005,20397,0.8686861),(8005,23293,0.7948856),(8005,24134,0.9760115),(8006,4769,0.7635697),(8006,15806,0.22299404),(8007,308,0.6054775),(8007,4344,0.20513944),(8007,17534,0.982041),(8008,2171,0.53068626),(8008,11136,0.99753994),(8008,20742,0.76392883),(8008,26748,4.267561e-2),(8009,27496,0.38723534),(8009,27596,4.4299267e-2),(8010,10782,2.1006295e-2),(8010,14465,6.800508e-2),(8011,8676,0.9048974),(8011,28824,0.83994913),(8012,9097,0.28407383),(8012,13975,0.32187882),(8012,22429,0.11085766),(8013,2261,1.23107135e-2),(8013,2896,0.13338242),(8013,9829,0.26844838),(8013,30650,0.35230634),(8014,21608,0.10075987),(8014,27378,9.23035e-2),(8014,30262,2.262988e-2),(8015,8880,0.94787383),(8015,19186,0.6919325),(8015,23795,0.39578626),(8016,3705,0.8840156),(8016,5132,0.7926174),(8016,23784,0.88034797),(8017,625,0.67399037),(8017,16869,0.8837434),(8017,20578,0.9016002),(8017,25666,0.871209),(8017,28391,0.3220485),(8017,29320,0.6028126),(8017,31646,0.24120344),(8018,5756,0.5826036),(8018,8196,2.5705257e-2),(8018,16775,0.56643677),(8018,17081,0.9662435),(8018,27150,0.704995),(8018,31323,0.9591711),(8019,9189,0.818861),(8019,9632,0.9545511),(8019,15330,0.7036931),(8019,15976,0.43238142),(8019,28045,0.8014315),(8020,3850,0.20575391),(8020,6441,0.802704),(8020,9751,0.35422015),(8020,17289,0.101995364),(8020,18088,0.26281682),(8021,39,0.34336653),(8021,464,0.2771458),(8021,1071,0.313882),(8021,1920,0.3968192),(8021,2952,0.49859416),(8021,7032,0.6237791),(8021,7774,0.4329377),(8021,10657,0.6965793),(8021,30251,0.85543084),(8022,12560,0.4531034),(8022,27074,0.66904753),(8022,27724,0.6876819),(8023,6222,0.17035769),(8023,11043,0.45243347),(8023,29933,0.77906704),(8024,2392,0.9274475),(8024,5362,0.16772725),(8024,6063,0.9010641),(8024,9380,0.6398601),(8024,16967,0.38498127),(8024,23244,0.3185816),(8024,28325,0.7263519),(8024,30758,0.8764969),(8024,32027,0.49394712),(8025,1101,0.71754825),(8025,12031,0.122945875),(8025,18274,0.578831),(8025,25345,0.26569128),(8025,29857,0.928933),(8025,32150,0.9024646),(8026,4918,0.4238064),(8026,20036,0.30360228),(8027,12520,0.62943536),(8027,12933,0.8994081),(8027,25276,0.91738456),(8027,32077,0.18372594),(8028,2453,0.70178515),(8028,2964,0.6154491),(8028,11773,0.14534537),(8028,13845,5.423686e-2),(8028,27598,9.036803e-2),(8029,2743,0.717073),(8029,4222,0.29144713),(8029,8306,0.75339645),(8029,28634,0.6416077),(8029,32382,0.14006902),(8030,4168,0.83105314),(8030,13504,0.78909427),(8030,14611,0.70314366),(8030,14921,0.29328558),(8030,21483,0.52495414),(8031,3699,0.5192423),(8031,6370,5.4775048e-2),(8031,9999,0.99904525),(8032,1515,0.7794108),(8032,8275,0.90694547),(8032,12929,0.4233841),(8033,3197,0.55268186),(8033,6137,0.2495267),(8033,12953,0.47784883),(8033,21685,0.29857492),(8033,26153,5.335882e-2),(8033,29674,0.45876902),(8033,30238,5.6582235e-2),(8034,1098,0.47505593),(8034,15691,0.47482267),(8034,22543,0.18559492),(8034,28802,0.22391923),(8034,30539,0.17899707),(8035,7215,0.2988633),(8035,7332,0.37907133),(8035,10136,0.36658078),(8035,11653,0.66836447),(8035,16378,0.53547716),(8035,18204,0.6817382),(8036,9596,0.8635037),(8036,10302,0.8708604),(8036,14838,0.82927984),(8036,17559,0.30552253),(8036,29325,0.7421572),(8037,3729,0.7446045),(8038,22204,0.6027246),(8038,23968,0.49929246),(8039,10272,0.41633734),(8039,11363,0.6758455),(8039,13478,0.9157591),(8040,127,0.5568584),(8040,6291,0.8577882),(8040,16114,0.42395085),(8040,22699,0.6550352),(8040,27449,0.53515023),(8041,10013,0.71977425),(8041,19876,0.44688183),(8041,22954,0.5075064),(8042,3240,0.52106094),(8042,4884,0.9279759),(8042,8084,0.67574924),(8042,8926,0.446585),(8043,13696,9.1875926e-2),(8043,32090,0.120359205),(8043,32719,0.52402604),(8044,5767,0.60129535),(8044,19222,0.51377594),(8044,23759,0.38336495),(8044,28511,0.8230192),(8045,9997,0.5719666),(8045,14676,0.93073374),(8045,20443,0.42305303),(8045,27255,0.70476806),(8047,2534,0.3195518),(8047,12986,0.1783977),(8047,24927,0.7664989),(8047,29180,0.73565334),(8048,205,0.77239853),(8048,20707,0.2802252),(8048,24583,0.50346094),(8049,26007,0.57638603),(8050,19567,0.46541357),(8050,27013,0.6794831),(8051,4366,0.440254),(8051,17041,0.5945301),(8051,29100,0.2698453),(8051,32153,0.21700187),(8052,3464,0.8136079),(8052,7791,9.910326e-4),(8052,20575,0.13925682),(8053,8099,0.838767),(8053,15040,0.7533751),(8053,28149,0.22272402),(8053,29727,8.4936425e-2),(8054,2765,0.31446642),(8054,6803,0.33071315),(8054,13112,0.9282905),(8054,22675,6.2319435e-2),(8055,25063,0.30045295),(8055,29048,0.49249467),(8055,31658,0.7210722),(8056,759,0.6621473),(8056,1841,0.65228474),(8056,9824,0.6312929),(8056,14514,0.93542105),(8057,5326,0.8115018),(8057,10984,9.809736e-2),(8057,16279,3.691444e-2),(8057,21873,0.64043456),(8058,5415,3.5883263e-2),(8058,7941,0.6393626),(8058,9615,0.17577587),(8058,17407,0.7828504),(8058,18630,0.81843525),(8058,23677,0.23864886),(8058,25023,0.12959886),(8059,7539,0.12577239),(8059,8676,0.49986127),(8059,10040,0.5641328),(8059,10577,0.6490653),(8059,25405,0.32805625),(8060,3179,0.54468995),(8060,3234,2.9293591e-2),(8060,4134,0.5281383),(8060,10344,0.93633544),(8060,14868,0.59319407),(8060,26557,0.6344119),(8060,31046,0.48571128),(8061,3472,0.7929109),(8061,23583,0.49537548),(8062,8343,0.9830511),(8062,11709,0.770853),(8063,289,2.2204371e-2),(8063,4173,0.8294177),(8063,6226,0.4096155),(8063,13690,0.27559897),(8063,16081,0.7524425),(8063,20990,0.7758246),(8064,19194,0.281453),(8064,20158,0.7502898),(8064,23531,0.35356182),(8064,25716,0.66138786),(8064,28028,0.41035444),(8065,4676,0.6123672),(8065,25788,0.604183),(8065,30207,0.44474745),(8066,2367,0.7378423),(8066,5736,0.9916689),(8066,19037,0.487739),(8066,20486,0.6957018),(8066,27895,0.55343354),(8066,28497,0.45558316),(8067,4285,0.8120908),(8067,9898,0.14864999),(8067,15479,7.879754e-2),(8067,16621,0.24675803),(8067,31378,0.5705202),(8067,32353,0.47353363),(8068,1510,0.57550144),(8068,3465,0.63232),(8068,13908,0.23496129),(8068,29320,0.1645867),(8069,7603,0.76057076),(8069,10332,0.4721139),(8069,16977,0.3779023),(8069,21092,0.66404957),(8070,628,0.44482765),(8070,5310,0.2942958),(8070,6189,0.8424232),(8070,7502,9.133955e-2),(8070,14654,0.5167947),(8070,25242,0.81591046),(8070,28876,0.1454786),(8070,32400,0.9997151),(8071,1491,0.9036854),(8071,2092,0.8467051),(8072,3213,0.4690547),(8072,5945,0.9408314),(8072,12862,5.8225974e-2),(8072,16132,0.6440412),(8072,20637,5.2385643e-2),(8072,29516,0.7819205),(8072,32028,0.58241063),(8073,20076,0.68124074),(8073,20341,0.8625189),(8073,24200,6.147481e-2),(8074,1715,0.9525657),(8074,8027,0.8298704),(8074,10120,7.745779e-2),(8074,19051,0.30759445),(8074,24129,0.38940686),(8075,18566,0.64731187),(8076,8297,0.43592936),(8076,13857,0.5024194),(8076,22954,0.22130089),(8076,23310,9.815124e-2),(8076,25220,0.6299278),(8077,20601,0.35612404),(8077,23176,0.5962482),(8078,506,0.48610792),(8078,8338,0.6486669),(8078,21460,0.44148794),(8078,25772,3.5782747e-2),(8079,506,4.9998605e-4),(8079,3194,0.393778),(8079,11770,0.4369712),(8079,16113,0.46245503),(8080,18565,0.89258736),(8080,20244,0.27913594),(8080,29872,0.34270954),(8081,9736,0.51747066),(8081,25907,2.4403196e-2),(8081,31383,0.32430848),(8082,43,0.69078463),(8082,5541,0.22358528),(8082,19393,0.2789125),(8082,22139,0.14992273),(8083,5717,0.92063004),(8083,9381,0.3829064),(8083,9972,7.911851e-2),(8083,13960,0.5566762),(8084,6758,0.45493278),(8084,10587,0.21203938),(8084,20065,0.9723353),(8084,20620,0.79698664),(8084,21534,0.24790372),(8084,22210,0.56146204),(8084,29561,0.7497243),(8085,1379,0.8468452),(8085,15016,0.84756744),(8086,6248,0.33521354),(8086,24172,0.57919914),(8086,26518,0.6347077),(8087,931,0.60310185),(8088,2288,0.4820609),(8089,8239,0.6284865),(8089,12747,0.35147104),(8089,18107,0.788762),(8089,21764,0.8904082),(8090,8778,0.7332178),(8090,11740,0.28949696),(8090,25344,0.93469715),(8090,28214,0.7526383),(8091,508,0.78938144),(8091,3217,0.4075914),(8091,9803,0.40371975),(8091,11056,0.60234857),(8091,23228,0.44670942),(8091,24502,0.7545449),(8091,25648,0.15213127),(8091,28219,0.5531181),(8091,28956,0.23679961),(8092,9424,0.82660705),(8092,13495,0.7873295),(8092,22555,0.25043458),(8092,27748,0.53736526),(8092,29320,0.63703674),(8093,11112,0.1153674),(8093,14629,0.80303055),(8093,15146,0.27353904),(8093,26865,0.7353338),(8094,2390,0.1614049),(8094,9277,0.85321665),(8094,30112,0.8054157),(8095,5711,0.46975484),(8095,13855,0.7292558),(8096,11947,0.78239644),(8096,23535,0.57635605),(8096,27468,0.14527622),(8096,27737,0.7771404),(8096,31055,0.27914155),(8096,31883,0.31983203),(8097,2689,0.59500504),(8097,13286,0.13346383),(8098,1604,0.13587967),(8098,13573,4.3790467e-2),(8098,14335,0.14764918),(8098,14537,0.5458884),(8098,15002,0.9315641),(8098,19362,0.27911413),(8100,4867,0.5022714),(8100,5276,0.3105785),(8100,6480,0.14464259),(8100,32208,0.8216803),(8101,10583,0.6966326),(8102,15826,0.39314187),(8102,16531,1.9543763e-2),(8102,19218,0.6303663),(8102,23769,0.47266537),(8103,21687,0.43084437),(8103,27921,0.7652477),(8104,8911,0.7520973),(8104,12745,5.871974e-2),(8104,27516,0.116248764),(8105,929,0.35455772),(8105,10687,0.14964475),(8105,12976,6.882022e-2),(8106,6057,0.2552031),(8106,14759,0.5956896),(8106,19033,0.9142746),(8107,21999,0.14982271),(8107,24120,0.45166144),(8108,2193,0.74751943),(8108,4621,0.5566465),(8108,6711,0.37439394),(8108,16818,0.30402577),(8108,26641,0.9013959),(8109,3310,0.53811824),(8109,6075,0.74648046),(8109,9926,0.96044487),(8109,11159,0.33054927),(8109,17959,0.10223992),(8109,22797,0.66606534),(8109,25621,0.5030216),(8109,30998,7.5413905e-2),(8110,6041,0.19341436),(8110,18146,0.16292046),(8110,23456,0.4038054),(8110,24610,0.32485098),(8110,26579,0.16266352),(8111,2898,0.41685802),(8111,5662,0.2952237),(8111,21579,0.18198207),(8112,6827,0.19175252),(8112,12333,5.458759e-2),(8112,20944,0.27042907),(8112,22208,0.89820343),(8112,28841,0.49466383),(8113,19741,0.21468316),(8113,26261,0.3552233),(8113,29595,0.783994),(8113,32641,0.68125635),(8114,16365,0.6844746),(8114,17434,0.16171536),(8114,18832,0.11578905),(8114,18868,0.7041175),(8114,23882,0.96584046),(8115,2445,0.94805133),(8115,2791,0.7933687),(8115,3111,0.29229447),(8116,7994,9.09520